#! /usr/bin/perl -w

use strict;
use warnings;

use DBI;
use Date::Calc;
use CGI;

use Classes::Statistic;
use Classes::User;

package main;

require 'Functions/config.pl';
require 'Functions/db.pl';
require 'Functions/parser.pl';
require 'Functions/web.pl';
require 'Functions/encode.pl';
require 'Functions/FakeFunctions.pl';

require 'Functions/_Stats.pl';
require 'Functions/ps.pl';

our $CurUser = User->new()->auth();

our %conf = ();	# configuration directives
our %miss = ();	# 
our $cgi = '';	# CGI data

print "Pragma: no-cache\n";
print "Expires: -1\n";
print "Cache-Control: no-cache\n";
print "Content-Type: text/html\n\n";

LoadConfig();

  # Import CGI parameters :
$cgi = CGI->new();

if ( ! $cgi->param( 'backend' ) ) {$cgi->param( 'backend', $conf{'default_backend'} );};

if ( $cgi->param( 'backend' ) eq 'GD' )
{
	eval( 'require GD::Graph::hbars' ) || ( $::miss{'GD::Graph'} = 1 );
	if ( ! $::miss{'GD::Graph'} )
	{
		require GD::Graph::lines;
		require GD::Graph::area;
		require GD::Graph::pie;

		eval( 'require GD::Graph::bars3d' ) || ( $::miss{'GD::Graph3d'} = 1 );
		if ( ! $::miss{'GD::Graph3d'} )
		{
			require GD::Graph::lines3d;
		}
	}
}

  # Open the DB connection :
our $dbh = DB_Open();

our $PageTitle = ' - Statistics';
ParseComponent( 'CommonHeader' );

ParseComponent( 'Links' );

if ( ! $cgi->param( 'TimePeriodType' ) )
{
	$cgi->param( 'TimePeriodType', 'YYYY-MM-DD' );

	my $Today = sprintf( "%04d-%02d-%02d", Date::Calc::Today() );
	my $From = sprintf( "%04d-%02d-%02d", Date::Calc::Add_Delta_Days( Date::Calc::Today(), -6 ) );

	$cgi->param( 'From', $From );
	$cgi->param( 'To', $Today );
}

my $Stat = Statistic->new();
my $Filter = Filter->new();

if ( ! defined( $cgi->param( 'load' ) ) ) {$cgi->param( 'load', '' );};
if ( $cgi->param( 'load' ) )
{
	$cgi->param( 'Label', $cgi->param( 'load' ) );
	if ( $cgi->param( 'load' ) =~ m/^(Temp|default)\// ) {$cgi->param( 'Label', ' ' );};

	$Filter->load( 'generated/Filters/'.$cgi->param( 'load' ).'.flt' );
	$Stat->Label( $cgi->param( 'Label' ) );
	$Filter->FileName( $cgi->param( 'Label' ) );
}
else
{
	if ( ! $cgi->param( 'Label' ) )
	{
		$cgi->param( 'Label', 'All alerts (unfiltered)' );
	}

	$Stat->Label( $cgi->param( 'Label' ) );
	$Filter->FileName( 'All alerts (unfiltered)' );
}

ParseComponent( 'Statistics' );

my $regex = $cgi->param( 'TimePeriodType' );
$regex =~ s/[YMDH]/\\d/g;

if ( $cgi->param( 'From' ) !~ m/^$regex$/ )
{
	error( "'From' parameter has a bad format : must be ".$cgi->param( 'TimePeriodType' ) );
}
else
{
	if ( $cgi->param( 'To' ) !~ m/^$regex$/ )
	{
		error( "'To' parameter has a bad format : must be ".$cgi->param( 'TimePeriodType' ) );
	}
	else
	{
		$Stat->addFilter( $Filter );

		$Stat->KeyType( $cgi->param( 'TimePeriodType' ) );
		$Stat->From( $cgi->param( 'From' ) );
		$Stat->To( $cgi->param( 'To' ) );

		{
			$Stat->Type( 'Time' );
		}

		$Stat->prepare_display();

		print '<center>';

		my ( $Type, $SubType ) = split( /\//, $cgi->param( 'OutputType' ) );

		if ( $Type eq 'text' )
		{
			if ( $SubType eq 'html' )
			{
				$Stat->display();
			}
		}

		if ( $Type eq 'png' )
		{
			$Stat->Parameters()->{'Graph_Type'} = $SubType;
			$Stat->Parameters()->{'Graph_Width'} = 800;
			$Stat->Parameters()->{'Graph_Heigth'} = 600;
			$Stat->Parameters()->{'Graph_FileName'} = 'generated/Images/Statistics_'.$SubType.'.png';
			my $res = $Stat->display();

			if ( $res )
			{
				print "<br><img src=\"".( $Stat->Parameters()->{'Graph_FileName'} )."\" alt=\"\">\n";
			}
			else
			{
				print "Statistic generation failed :( (no data for this time interval ?)";
			}
		}

		print '</center>';
	}
}

ParseComponent( 'CommonFooter' );
