/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __LISTEMESSAGE__
#define __LISTEMESSAGE__

#include <src/messages/messages/compilateur/global.h>

// ATTENTION dans ce fichier, on lit et ecrit directement
// dans les structures ! (gain de temps)

typedef struct listetexte ListeTexte;

typedef struct listeparametre ListeParametre;

typedef struct listemessage ListeMessage;

typedef struct listecharset ListeCharset;

typedef struct listelangue ListeLangue;

//Pour ces trois dernieres structures, si suivant == NULL, cela signifie que
//le maillon en question correspond a la valeur par defaut.

typedef enum
{
	TYPEPARAMETRE_ENTIER,
	TYPEPARAMETRE_FLOTTANT,
	TYPEPARAMETRE_DOUBLE,
	TYPEPARAMETRE_CARACTERE,
	TYPEPARAMETRE_CHAINE,
	TYPEPARAMETRE_POINTEUR
} TypeParametre;

typedef enum
{
	TYPETEXTE_TEXTE,
	TYPETEXTE_PARAMETRE
} TypeTexte;

struct listetexte
{
	Chaine texte;
	TypeTexte type;
	ListeTexte *suivant;
};

struct listeparametre
{
	Entier parametre;
	TypeParametre typeparametre;
	ListeParametre *suivant;
};

struct listemessage
{
	Chaine message;
	ListeTexte *texte;
	ListeParametre *parametre;
	ListeMessage *suivant;
};

struct listecharset
{
	Chaine charset;
	Chaine detection;
	//Cette chaine doit etre liberee a la destruction
	ListeMessage *message;
	ListeCharset *suivant;
};

struct listelangue
{
	Chaine langue;
	Chaine detection;
	//Cette chaine doit etre liberee a la destruction
	ListeCharset *charset;
	ListeLangue *suivant;
};

//Pour les fonctions, on ne fait que creer et detruire
//UN maillon, en renvoyant l'adresse du suivant.
//ATTENTION : les elements sont ajoutes a la fin des structures !
//c plus long, mais tant pis.

Resultat listetexte_initialisation(ListeTexte **listetexte);

Resultat listetexte_ajout_texte(ListeTexte **listetexte , Chaine texte , TypeTexte type);

Resultat listetexte_destruction(ListeTexte **listetexte);

Resultat listeparametre_initialisation(ListeParametre **listeparametre);

Resultat listeparametre_ajout_parametre(ListeParametre **listeparametre , Entier parametre , TypeParametre typeparametre);

Resultat listeparametre_destruction(ListeParametre **listeparametre);

Resultat listemessage_initialisation(ListeMessage **listemessage);

Resultat listemessage_ajout_message(ListeMessage **listemessage , Chaine message , ListeTexte *texte , ListeParametre *parametre);

Resultat listemessage_destruction(ListeMessage **listemessage);

Resultat listecharset_initialisation(ListeCharset **listecharset);

Resultat listecharset_ajout_charset(ListeCharset **listecharset , Chaine charset , ListeMessage *message);

Resultat listecharset_destruction(ListeCharset **listecharset);

Resultat listelangue_initialisation(ListeLangue **listelangue);

Resultat listelangue_ajout_langue(ListeLangue **listelangue , Chaine langue , ListeCharset *charset);

Resultat listelangue_destruction(ListeLangue **listelangue);

#endif
