/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "commandetexte.h"

Resultat commandetexte_initialisation(TRAVAIL(CommandeTexte) commandetexte)
{
	/* Cre une commande de texte vide.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 */ 
	if((S_T(commandetexte)=(STOCKAGE(CommandeTexte))(malloc(SIZEOF(CONTENEUR(CommandeTexte)))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	CHAMP(commandetexte , localisation)=NULL;
	CHAMP(commandetexte , texte)=NULL;
	return RESULTAT_OK;
}

Resultat commandetexte_definition_localisationfichier(TRAVAIL(CommandeTexte) commandetexte , TRAVAIL(LocalisationFichier) localisationfichier)
{
	/* Indique la position d'une commande texte.
	 * Renvoie RESULTAT_ERREUR si commandetexte est NULL.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 */ 
	DEBUTZONESECURISEE
	if(S_T(commandetexte)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(localisationfichier_copie_commande(localisationfichier,CHAMP_TRAVAIL(commandetexte , localisation)));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat commandetexte_definition_texte(TRAVAIL(CommandeTexte) commandetexte , TRAVAIL_SCALAIRE(Texte) texte)
{
	/* Assigne un nom de fichier  une commande de texte.
	 * Renvoie RESULTAT_ERREUR si commandetexte est NULL.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 */ 
	if(S_T(commandetexte)==NULL)
		return RESULTAT_ERREUR;
	if(CHAMP(commandetexte , texte)!=NULL)
	{
		free(CHAMP(commandetexte , texte));
		CHAMP(commandetexte , texte)=NULL;
	}
	if((CHAMP(commandetexte , texte)=(STOCKAGE_SCALAIRE(Texte))(strdup((char*)(texte))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	return RESULTAT_OK;
}

Resultat commandetexte_lecture_localisationfichier(TRAVAIL(CommandeTexte) commandetexte , REFERENCE(LocalisationFichier) localisationfichier)
{
	/* Indique la position d'une commande texte.
	 * Renvoie RESULTAT_ERREUR si commandetexte est NULL.
	 */ 
	if(S_T(commandetexte)==NULL)
		return RESULTAT_ERREUR;
	T_R(localisationfichier)=CHAMP_TRAVAIL(commandetexte , localisation);
	return RESULTAT_OK;
}

Resultat commandetexte_lecture_texte(TRAVAIL(CommandeTexte) commandetexte , REFERENCE_SCALAIRE(Texte) texte)
{
	/* Lit un nom de fichier  une commande de texte.
	 * Renvoie RESULTAT_ERREUR si commandetexte est NULL.
	 */ 
	if(S_T(commandetexte)==NULL)
		return RESULTAT_ERREUR;
	T_R_(texte)=T_S_(CHAMP(commandetexte , texte));
	return RESULTAT_OK;
}

Resultat commandetexte_parcours(TRAVAIL(CommandeTexte) commandetexte , TRAVAIL(ActionFlux) action , TRAVAIL(General) general)
{
	/* Ralise un parcours des flux inclus dans la commande spcifie.
	 * Renvoie les mmes erreurs que flux_parcours,
	 * ainsi que RESULTAT_ERREUR si commande est NULL,
	 * rien ne se passe si action est NULL.
	 */
	if(S_T(commandetexte)==NULL)
		return RESULTAT_ERREUR;
	return RESULTAT_OK;
}

Resultat commandetexte_copie(TRAVAIL(CommandeTexte) commandetexte , TRAVAIL(CommandeTexte) copie)
{
	/* Cre une copie de la commande texte.
	 * Renvoie RESULTAT_ERREUR si commandetexte est NULL, et
	 * RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 * Si la copie est non vide, elle est au pralable supprime.
	 */ 
	DEBUTZONESECURISEE
	if(S_T(commandetexte)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(commandetexte_destruction(copie));
	SECURISE(commandetexte_initialisation(copie));
	SECURISE(commandetexte_definition_localisationfichier(copie,CHAMP_TRAVAIL(commandetexte , localisation)));
	SECURISE(commandetexte_definition_texte(copie,T_S_(CHAMP(commandetexte , texte))));
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat commandetexte_destruction(TRAVAIL(CommandeTexte) commandetexte)
{
	/* Dtruit une commande texte.
	 */ 
	DEBUTZONESECURISEE
	if(S_T(commandetexte)==NULL)
		return RESULTAT_OK;
	SECURISE(localisationfichier_destruction(CHAMP_TRAVAIL(commandetexte , localisation)));
	if(CHAMP(commandetexte , texte)!=NULL)
	{
		free(CHAMP(commandetexte , texte));
		CHAMP(commandetexte , texte)=NULL;
	}
	free(S_T(commandetexte));
	S_T(commandetexte)=NULL;
	FINZONESECURISEE
	return RESULTAT_OK;
}

