 /**
 * Title:        ProAlign<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Ari Loytynoja<p>
 * License:      GNU GENERAL PUBLIC LICENSE<p>
 * @see          http://www.gnu.org/copyleft/gpl.html
 * Company:      ULB<p>
 * @author Ari Loytynoja
 * @version 1.0
 */
package proalign;

public class SubstitutionModel {
  
    double delta, epsilon;
    double deltaDefault, epsilonDefault;

    double[] charFreqs;
    double[] charFreqsDefault;
    double[][] substProb1, substProb2;

    String alphabet;
    String equateAlphabet;

    double[] aaFreqs;
    double[][] aaPam;
    double[][] gapPam;

    double gapFreq;
    double gapProb;
    double gapFreqDefault, gapProbDefault;

    String modelName;

    /**
     * Holds a handle to ProAlign-class. 
     */
    public SubstitutionModel(ProAlign pa) {  

	delta = pa.modelDelta;     // prob to move to INSERT(X/Y) 
	epsilon = pa.modelEpsilon; // prob to stay in INSERT(X/Y) 

	gapFreq = pa.gapFreq;
	gapProb = pa.gapProb;

	// save defaults
	deltaDefault = delta; 
	epsilonDefault = epsilon;
	gapFreqDefault = gapFreq;
	gapProbDefault = gapProb;
	
	ProAlign.log("SubstitutionModel");
    }

    /**
     * Simple DNA model. Currently the alphabet is "ACGT-", all the background 
     * frequencies are 0.2, and substitution probabilities are equal.  
     */
    void jcDnaModel() { 

	modelName = "jcDnaModel";

	alphabet = "ACGT-";
	equateAlphabet = "ACGTRYMKSWHBVDNU";

	charFreqs = new double[5];

	charFreqs[0] = 0.2d;
	charFreqs[1] = 0.2d;
	charFreqs[2] = 0.2d;
	charFreqs[3] = 0.2d;
	charFreqs[4] = 0.2d;

	printDebug();

	// save defaults
	charFreqsDefault = charFreqs;

    }


    /**
     * Simple protein model based on WAG.  
     */

    void wagProteinModel() {

	modelName = "wagProteinModel";

	alphabet = "ARNDCQEGHILKMFPSTWYV-";
	equateAlphabet = "ARNDCQEGHILKMFPSTWYVX";

	double[] tmp = {0.086628,0.043972,0.039089,0.057045,0.019308,
			0.036728,0.058059,0.083252,0.024431,0.048466,
			0.086209,0.062029,0.019503,0.038432,0.045763,
			0.069518,0.061013,0.014386,0.035274,0.070896};
	aaFreqs = tmp;

	double[][] tmp2 = {{0.989896,0.000294,0.000272,0.000394,0.000548,
			   0.000485,0.000844,0.000756,0.000169,0.000103,
			   0.000212,0.000483,0.000477,0.000112,0.000767,
			   0.001798,0.001131,6.03e-05,0.000128,0.00107},
			  {0.000294,0.989794,0.000339,7.86e-05,0.000282,
			   0.001619,0.000234,0.000312,0.00114,9.97e-05,
			   0.000265,0.002854,0.000364,5.48e-05,0.000362,
			   0.000653,0.000296,0.000621,0.000203,0.000134},
			  {0.000272,0.000339,0.986156,0.002896,0.000141,
			   0.000823,0.000505,0.0006,0.00211,0.000296,
			   7.01e-05,0.001606,0.000106,5.13e-05,0.000104,
			   0.00212,0.001083,3.84e-05,0.000579,0.000105},
			  {0.000394,7.86e-05,0.002896,0.990311,1.62e-05,
			   0.000329,0.003293,0.000462,0.000496,2.1e-05,
			   4.52e-05,0.000256,5.53e-05,2.49e-05,0.000226,
			   0.000572,0.0002,6.92e-05,0.000174,8.12e-05},
			  {0.000548,0.000282,0.000141,1.62e-05,0.995607,
			   5.27e-05,1.14e-05,0.000164,0.000133,9.07e-05,
			   0.000205,3.95e-05,0.000208,0.000212,5.83e-05,
			   0.000751,0.000274,0.000382,0.00029,0.000534},
			  {0.000485,0.001619,0.000823,0.000329,5.27e-05,
			   0.985928,0.002917,0.000176,0.00229,6.08e-05,
			   0.000464,0.002077,0.000824,5.33e-05,0.000498,
			   0.000549,0.000458,0.000115,0.000121,0.000161},
			  {0.000844,0.000234,0.000505,0.003293,1.14e-05,
			   0.002917,0.988168,0.000303,0.000304,6.79e-05,
			   8.23e-05,0.001378,0.000168,4.33e-05,0.000364,
			   0.000376,0.000439,8.35e-05,0.000105,0.000314},
			  {0.000756,0.000312,0.0006,0.000462,0.000164,
			   0.000176,0.000303,0.995427,0.000133,1.62e-05,
			   3.27e-05,0.000199,9.29e-05,2.66e-05,0.00013,
			   0.000716,0.00012,0.00018,5.53e-05,9.99e-05},
			  {0.000169,0.00114,0.00211,0.000496,0.000133,
			   0.00229,0.000304,0.000133,0.988544,7.37e-05,
			   0.000266,0.000475,0.000216,0.000362,0.000371,
			   0.000395,0.000252,0.00014,0.002066,6.31e-05},
			  {0.000103,9.97e-05,0.000296,2.1e-05,9.07e-05,
			   6.08e-05,6.79e-05,1.62e-05,7.37e-05,0.988961,
			   0.001691,0.000173,0.002271,0.000565,5.33e-05,
			   0.00017,0.000778,0.000113,0.000224,0.004171},
			  {0.000212,0.000265,7.01e-05,4.52e-05,0.000205,
			   0.000464,8.23e-05,3.27e-05,0.000266,0.001691,
			   0.990704,0.000137,0.002589,0.001128,0.000222,
			   0.000184,0.000174,0.000355,0.000213,0.00096},
			  {0.000483,0.002854,0.001606,0.000256,3.95e-05,
			   0.002077,0.001378,0.000199,0.000475,0.000173,
			   0.000137,0.987915,0.000498,4.74e-05,0.000297,
			   0.000516,0.00074,7.33e-05,7.11e-05,0.000163},
			  {0.000477,0.000364,0.000106,5.53e-05,0.000208,
			   0.000824,0.000168,9.29e-05,0.000216,0.002271,
			   0.002589,0.000498,0.988732,0.000635,9.14e-05,
			   0.000263,0.000809,0.000275,0.000228,0.001098},
			  {0.000112,5.48e-05,5.13e-05,2.49e-05,0.000212,
			   5.33e-05,4.33e-05,2.66e-05,0.000362,0.000565,
			   0.001128,4.74e-05,0.000635,0.99161,8.61e-05,
			   0.000291,9.17e-05,0.000816,0.003442,0.000347},
			  {0.000767,0.000362,0.000104,0.000226,5.83e-05,
			   0.000498,0.000364,0.00013,0.000371,5.33e-05,
			   0.000222,0.000297,9.14e-05,8.61e-05,0.994727,
			   0.00086,0.000424,7.43e-05,0.000115,0.000168},
			  {0.001798,0.000653,0.00212,0.000572,0.000751,
			   0.000549,0.000376,0.000716,0.000395,0.00017,
			   0.000184,0.000516,0.000263,0.000291,0.00086,
			   0.986629,0.002335,0.000279,0.00042,0.000124},
			  {0.001131,0.000296,0.001083,0.0002,0.000274,
			   0.000458,0.000439,0.00012,0.000252,0.000778,
			   0.000174,0.00074,0.000809,9.17e-05,0.000424,
			   0.002335,0.989442,5.91e-05,0.000155,0.00074},
			  {6.03e-05,0.000621,3.84e-05,6.92e-05,0.000382,
			   0.000115,8.35e-05,0.00018,0.00014,0.000113,
			   0.000355,7.33e-05,0.000275,0.000816,7.43e-05,
			   0.000279,5.91e-05,0.994745,0.001326,0.000195},
			  {0.000128,0.000203,0.000579,0.000174,0.00029,
			   0.000121,0.000105,5.53e-05,0.002066,0.000224,
			   0.000213,7.11e-05,0.000228,0.003442,0.000115,
			   0.00042,0.000155,0.001326,0.989916,0.000168},
			  {0.00107,0.000134,0.000105,8.12e-05,0.000534,
			   0.000161,0.000314,9.99e-05,6.31e-05,0.004171,
			   0.00096,0.000163,0.001098,0.000347,0.000168,
			   0.000124,0.00074,0.000195,0.000168,0.989304}};
	aaPam = tmp2;
	setGapPam();

	printDebug();
    }



    void dayhoffProteinModel() {

	modelName = "dayhoffProteinModel";

	alphabet = "ARNDCQEGHILKMFPSTWYV-";
	equateAlphabet = "ARNDCQEGHILKMFPSTWYVX";

	double[] tmp = {0.087,0.041,0.04,0.047,0.033,
			0.038,0.05,0.089,0.034,0.037,
			0.085,0.08,0.015,0.04,0.051,
			0.07,0.058,0.01,0.03,0.065};
	aaFreqs = tmp;

	double[][] tmp2 = {{0.988234,0.000137,0.000509,0.000612,0.000187,
			    0.000457,0.000994,0.001216,0.000115,0.000333,
			    0.000209,0.000133,0.000361,9.35e-05,0.001264,
			    0.002061,0.001901,5.46e-06,0.000125,0.00105},
			   {0.000137,0.991108,0.000169,8.44e-06,0.00012,
			    0.001252,7.93e-06,4.46e-05,0.001202,0.000322,
			    7.93e-05,0.002365,0.000449,6.94e-05,0.000521,
			    0.000776,0.000137,0.001071,3.97e-05,0.000122},
			   {0.000509,0.000169,0.983089,0.004602,1.05e-05,
			    0.000535,0.000764,0.000713,0.002702,0.000396,
			    0.000177,0.001636,2.71e-05,7.11e-05,0.000215,
			    0.002509,0.001185,0.000122,0.000488,8.13e-05},
			   {0.000612,8.44e-06,0.004602,0.985754,3.62e-06,
			    0.000692,0.00575,0.00063,0.000438,0.000122,
			    3.68e-06,0.000368,1.65e-05,1.84e-06,6.78e-05,
			    0.000484,0.00034,4.59e-06,1.15e-05,9.05e-05},
			   {0.000187,0.00012,1.05e-05,3.62e-06,0.99741,
			    3.1e-06,2.09e-06,5.54e-05,0.000145,0.000226,
			    5.54e-06,1.15e-06,2.01e-05,1.23e-05,9.66e-05,
			    0.000824,8.5e-05,4.93e-05,0.000493,0.00025},
			   {0.000457,0.001252,0.000535,0.000692,3.1e-06,
			    0.98687,0.003612,0.000144,0.003058,9.25e-05,
			    0.000378,0.000786,0.000571,2.56e-06,0.00078,
			    0.000287,0.000273,1.36e-05,1.43e-05,0.000178},
			   {0.000994,7.93e-06,0.000764,0.00575,2.09e-06,
			    0.003612,0.986165,0.000409,0.00022,0.000308,
			    5.74e-05,0.000423,0.000152,2.81e-06,0.000255,
			    0.0004,0.000174,1.04e-05,0.000108,0.000185},
			   {0.001216,4.46e-05,0.000713,0.00063,5.54e-05,
			    0.000144,0.000409,0.994594,5.37e-05,3.28e-06,
			    3.65e-05,0.000137,8.53e-05,7.77e-05,0.000176,
			    0.001175,0.000158,1.83e-05,2.43e-06,0.000273},
			   {0.000115,0.001202,0.002702,0.000438,0.000145,
			    0.003058,0.00022,5.37e-05,0.989644,3.88e-05,
			    0.000225,0.000138,1.78e-05,0.000239,0.000469,
			    0.000178,0.000115,0.000143,0.000638,0.000221},
			   {0.000333,0.000322,0.000396,0.000122,0.000226,
			    9.25e-05,0.000308,3.28e-06,3.88e-05,0.988119,
			    0.001308,0.000236,0.00167,0.000989,6.03e-05,
			    0.000126,0.000977,1.4e-05,0.00019,0.004469},
			   {0.000209,7.93e-05,0.000177,3.68e-06,5.54e-06,
			    0.000378,5.74e-05,3.65e-05,0.000225,0.001308,
			    0.992281,9.33e-05,0.00264,0.000799,0.000161,
			    8.75e-05,0.000172,0.000249,0.000147,0.000892},
			   {0.000133,0.002365,0.001636,0.000368,1.15e-06,
			    0.000786,0.000423,0.000137,0.000138,0.000236,
			    9.33e-05,0.990977,0.00122,9.45e-07,0.000171,
			    0.000488,0.000701,4.86e-06,6.78e-05,5.32e-05},
			   {0.000361,0.000449,2.71e-05,1.65e-05,2.01e-05,
			    0.000571,0.000152,8.53e-05,1.78e-05,0.00167,
			    0.00264,0.00122,0.990068,0.000461,8.5e-05,
			    0.00031,0.000523,2.3e-05,1.63e-05,0.001284},
			   {9.35e-05,6.94e-05,7.11e-05,1.84e-06,1.23e-05,
			    2.56e-06,2.81e-06,7.77e-05,0.000239,0.000989,
			    0.000799,9.45e-07,0.000461,0.99283,5.58e-05,
			    0.000232,7.01e-05,0.000407,0.003523,6.25e-05},
			   {0.001264,0.000521,0.000215,6.78e-05,9.66e-05,
			    0.00078,0.000255,0.000176,0.000469,6.03e-05,
			    0.000161,0.000171,8.5e-05,5.58e-05,0.993738,
			    0.001225,0.000401,5.08e-06,6.21e-06,0.000245},
			   {0.002061,0.000776,0.002509,0.000484,0.000824,
			    0.000287,0.0004,0.001175,0.000178,0.000126,
			    8.75e-05,0.000488,0.00031,0.000232,0.001225,
			    0.985332,0.002788,0.000395,0.00017,0.000154},
			   {0.001901,0.000137,0.001185,0.00034,8.5e-05,
			    0.000273,0.000174,0.000158,0.000115,0.000977,
			    0.000172,0.000701,0.000523,7.01e-05,0.000401,
			    0.002788,0.988977,5.96e-06,0.000215,0.000802},
			   {5.46e-06,0.001071,0.000122,4.59e-06,4.93e-05,
			    1.36e-05,1.04e-05,1.83e-05,0.000143,1.4e-05,
			    0.000249,4.86e-06,2.3e-05,0.000407,5.08e-06,
			    0.000395,5.96e-06,0.997116,0.000325,1.79e-05},
			   {0.000125,3.97e-05,0.000488,1.15e-05,0.000493,
			    1.43e-05,0.000108,2.43e-06,0.000638,0.00019,
			    0.000147,6.78e-05,1.63e-05,0.003523,6.21e-06,
			    0.00017,0.000215,0.000325,0.993278,0.000142},
			   {0.00105,0.000122,8.13e-05,9.05e-05,0.00025,
			    0.000178,0.000185,0.000273,0.000221,0.004469,
			    0.000892,5.32e-05,0.001284,6.25e-05,0.000245,
			    0.000154,0.000802,1.79e-05,0.000142,0.989428}};
	aaPam = tmp2;
	setGapPam();

	printDebug();
    }



    void jttProteinModel() {

	modelName = "jttProteinModel";

	alphabet = "ARNDCQEGHILKMFPSTWYV-";
	equateAlphabet = "ARNDCQEGHILKMFPSTWYVX";

	double[] tmp = {0.077,0.051,0.043,0.052,0.02,
			0.041,0.062,0.074,0.023,0.052,
			0.091,0.059,0.024,0.04,0.051,
			0.069,0.059,0.014,0.032,0.066};
	aaFreqs = tmp;

	double[][] tmp2 = {{0.986454,0.000128,0.000552,0.000645,0.00036,
			    0.000494,0.000935,0.001705,0.000199,0.000277,
			    0.000228,0.000211,0.000263,0.000109,0.001474,
			    0.002439,0.00218,4.55e-06,0.000136,0.001205},
			   {0.000128,0.991919,0.00013,6.33e-06,0.000165,
			    0.000963,5.31e-06,4.45e-05,0.001474,0.00019,
			    6.15e-05,0.00266,0.000233,5.76e-05,0.000432,
			    0.000653,0.000112,0.000635,3.09e-05,9.97e-05},
			   {0.000552,0.00013,0.982571,0.003993,1.66e-05,
			    0.000476,0.000592,0.000823,0.003835,0.00027,
			    0.000159,0.00213,1.63e-05,6.83e-05,0.000207,
			    0.002444,0.001118,8.36e-05,0.000439,7.69e-05},
			   {0.000645,6.33e-06,0.003993,0.987626,5.57e-06,
			    0.000598,0.004326,0.000707,0.000603,8.07e-05,
			    3.2e-06,0.000465,9.64e-06,1.71e-06,6.33e-05,
			    0.000458,0.000312,3.06e-06,1.01e-05,8.31e-05},
			   {0.00036,0.000165,1.66e-05,5.57e-06,0.995644,
			    4.89e-06,2.88e-06,0.000113,0.000365,0.000274,
			    8.82e-06,2.64e-06,2.14e-05,2.1e-05,0.000165,
			    0.001423,0.000142,5.99e-05,0.000787,0.00042},
			   {0.000494,0.000963,0.000476,0.000598,4.89e-06,
			    0.986951,0.002786,0.000166,0.004325,6.3e-05,
			    0.000337,0.00102,0.000341,2.45e-06,0.000746,
			    0.000279,0.000257,9.32e-06,1.28e-05,0.000167},
			   {0.000935,5.31e-06,0.000592,0.004326,2.88e-06,
			    0.002786,0.988953,0.00041,0.000271,0.000182,
			    4.46e-05,0.000477,7.9e-05,2.34e-06,0.000212,
			    0.000337,0.000142,6.16e-06,8.46e-05,0.000152},
			   {0.001705,4.45e-05,0.000823,0.000707,0.000113,
			    0.000166,0.00041,0.993253,9.86e-05,2.9e-06,
			    4.24e-05,0.000231,6.61e-05,9.64e-05,0.000218,
			    0.001479,0.000192,1.62e-05,2.82e-06,0.000333},
			   {0.000199,0.001474,0.003835,0.000603,0.000365,
			    0.004325,0.000271,9.86e-05,0.985237,4.21e-05,
			    0.000321,0.000284,1.7e-05,0.000365,0.000715,
			    0.000275,0.000173,0.000156,0.000912,0.000332},
			   {0.000277,0.00019,0.00027,8.07e-05,0.000274,
			    6.3e-05,0.000182,2.9e-06,4.21e-05,0.991779,
			    0.000897,0.000235,0.000767,0.000726,4.43e-05,
			    9.35e-05,0.000706,7.35e-06,0.000131,0.003232},
			   {0.000228,6.15e-05,0.000159,3.2e-06,8.82e-06,
			    0.000337,4.46e-05,4.24e-05,0.000321,0.000897,
			    0.993861,0.000122,0.001591,0.00077,0.000155,
			    8.55e-05,0.000163,0.000171,0.000133,0.000847},
			   {0.000211,0.00266,0.00213,0.000465,2.64e-06,
			    0.00102,0.000477,0.000231,0.000284,0.000235,
			    0.000122,0.98903,0.001067,1.32e-06,0.00024,
			    0.000693,0.000964,4.86e-06,8.89e-05,7.33e-05},
			   {0.000263,0.000233,1.63e-05,9.64e-06,2.14e-05,
			    0.000341,7.9e-05,6.61e-05,1.7e-05,0.000767,
			    0.001591,0.001067,0.993806,0.000297,5.48e-05,
			    0.000203,0.000332,1.06e-05,9.87e-06,0.000816},
			   {0.000109,5.76e-05,6.83e-05,1.71e-06,2.1e-05,
			    2.45e-06,2.34e-06,9.64e-05,0.000365,0.000726,
			    0.00077,1.32e-06,0.000297,0.993338,5.76e-05,
			    0.000243,7.11e-05,0.0003,0.003409,6.36e-05},
			   {0.001474,0.000432,0.000207,6.33e-05,0.000165,
			    0.000746,0.000212,0.000218,0.000715,4.43e-05,
			    0.000155,0.00024,5.48e-05,5.76e-05,0.993266,
			    0.001283,0.000407,3.75e-06,6.01e-06,0.000249},
			   {0.002439,0.000653,0.002444,0.000458,0.001423,
			    0.000279,0.000337,0.001479,0.000275,9.35e-05,
			    8.55e-05,0.000693,0.000203,0.000243,0.001283,
			    0.984122,0.002869,0.000295,0.000167,0.000158},
			   {0.00218,0.000112,0.001118,0.000312,0.000142,
			    0.000257,0.000142,0.000192,0.000173,0.000706,
			    0.000163,0.000964,0.000332,7.11e-05,0.000407,
			    0.002869,0.98885,4.32e-06,0.000204,0.000802},
			   {4.55e-06,0.000635,8.36e-05,3.06e-06,5.99e-05,
			    9.32e-06,6.16e-06,1.62e-05,0.000156,7.35e-06,
			    0.000171,4.86e-06,1.06e-05,0.0003,3.75e-06,
			    0.000295,4.32e-06,0.997991,0.000225,1.3e-05},
			   {0.000136,3.09e-05,0.000439,1.01e-05,0.000787,
			    1.28e-05,8.46e-05,2.82e-06,0.000912,0.000131,
			    0.000133,8.89e-05,9.87e-06,0.003409,6.01e-06,
			    0.000167,0.000204,0.000225,0.993076,0.000135},
			   {0.001205,9.97e-05,7.69e-05,8.31e-05,0.00042,
			    0.000167,0.000152,0.000333,0.000332,0.003232,
			    0.000847,7.33e-05,0.000816,6.36e-05,0.000249,
			    0.000158,0.000802,1.3e-05,0.000135,0.990742}}; 
	aaPam = tmp2;
	setGapPam();

	printDebug();
    }

    void setBranchLength(double dist1, double dist2) {


	dist1 = ProAlign.distScale*dist1;
	dist2 = ProAlign.distScale*dist2;

	if(ProAlign.isDna) {
	    setDnaSubstTable(dist1,1);
	    setDnaSubstTable(dist2,2);
	} else {
	    setProtSubstTable(dist1*100,1);
	    setProtSubstTable(dist2*100,2);
   	}
    }

    void setDnaSubstTable(double dist, int table) {

	// probablility matrix to observe character pairs
	double[][] sProb = new double[5][5];

	for(int i=0; i<sProb.length; i++) {
	    for(int j=0; j<sProb.length; j++) {
		if(i==j) {
		    sProb[i][j] = (double) 1d/5d+4d/5d*Math.exp(-5d/4d*dist);
		} else {
		    sProb[i][j] = (double) 1d/5d-1d/5d*Math.exp(-5d/4d*dist);
		}
	    }
	}

	if(table == 1) {
	    substProb1 = sProb;
	} else {
	    substProb2 = sProb;
	}
    }

    void setGapPam() {

	// Compute new character freqs.
	charFreqs = new double[21];
	for(int i=0; i<20; i++) {
	    charFreqs[i] = aaFreqs[i]*(1-gapFreq);
	}
	charFreqs[20] = gapFreq;

	// Add gap to PAM1 matrix.
	gapPam = new double[21][21];
	for(int i=0; i<20; i++) {
	    gapPam[i][20] = gapProb;
	    gapPam[20][i] = gapProb;
	}
	gapPam[20][20] = 1-20*gapProb;

	for(int i=0; i<20; i++) {
	    for(int j=0; j<20; j++) {
		gapPam[i][j] = aaPam[i][j]*(1-gapPam[20][i]);
	    }
	}

	// Scale matrix to PAM1.
	double sum = 0d;
	for(int i=0; i<21; i++) {
	    sum += charFreqs[i]*(1-gapPam[i][i]);	    
	}	
	for(int i=0; i<21; i++) {
	    for(int j=0; j<21; j++) {
		gapPam[i][j] = gapPam[i][j]*(0.01d/sum);
	    }
	}

	for(int i=0; i<21; i++) {
	    sum = 0d;
	    for(int j=0; j<21; j++) {
		if(j!=i) {
		    sum += gapPam[i][j];
		}
	    }
	    gapPam[i][i] = 1-sum;
	}
    }

    void setProtSubstTable(double num, int table) {

	double[][] sProb = gapPam;
	double[][] newProb;

	for(int n=1; n<num; n++) {
	    newProb = new double[21][21];
	    for(int i=0; i<21; i++) {
		for(int j=0; j<21; j++) {	
		    double sum = 0d;
		    for(int k=0; k<21; k++) {
			 sum += gapPam[k][j]*sProb[i][k];
		    }
		    newProb[i][j] = sum;
		}
	    }
	    sProb = newProb;
	}

	if(table == 1) {
	    substProb1 = sProb;
	} else {
	    substProb2 = sProb;
	}
    }

    void printDebug() {

	if(ProAlign.DEBUG) {
	    ProAlign.log(" preset variables:");
	    ProAlign.log("  delta:      "+delta);
	    ProAlign.log("  epsilon:    "+epsilon);
	    ProAlign.log(" model: "+modelName+"\n");
	    ProAlign.log(" alphabet:  "+alphabet);
	    ProAlign.log("  character freqs:");
	    for(int i=0; i<charFreqs.length; i++) {
		ProAlign.log.print(" "+charFreqs[i]);
	    }
	    ProAlign.log("");
	}
    }

}
