##******************************************************************
##                      MadGraph/MadEvent                          *
##******************************************************************
##                                                                 *
##  param_card corresponding the SPS point 2 (by SoftSusy 2.0.5)   *
##                                                                 *
##******************************************************************
## Les Houches friendly file for the (MS)SM parameters of MadGraph *
##      SM parameter set and decay widths produced by MSSMCalc     *
##******************************************************************
##*Please note the following IMPORTANT issues:                     *
##                                                                 *
##0. REFRAIN from editing this file by hand! Some of the parame-   *
##   ters are not independent. Always use a calculator.            *
##                                                                 *
##1. alpha_S(MZ) has been used in the calculation of the parameters*
##   This value is KEPT by madgraph when no pdf are used lpp(i)=0, *
##   but, for consistency, it will be reset by madgraph to the     *
##   value expected IF the pdfs for collisions with hadrons are    *
##   used.                                                         *
##                                                                 *
##2. Values of the charm and bottom kinematic (pole) masses are    *
##   those used in the matrix elements and phase space UNLESS they *
##   are set to ZERO from the start in the model (particles.dat)   *
##   This happens, for example,  when using 5-flavor QCD where     *
##   charm and bottom are treated as partons in the initial state  *
##   and a zero mass might be hardwired in the model definition.   *
##                                                                 *
##       The SUSY decays have calculated using SDECAY 1.1a         *
##                                                                 *
##******************************************************************
#
BLOCK DCINFO  # Decay Program information
     1   SDECAY      # decay calculator
     2   1.1a        # version number
#
BLOCK SPINFO  # Spectrum calculator information
     1   SOFTSUSY    # spectrum calculator                 
     2   2.0.5         # version number                    
#
BLOCK MODSEL  # Model selection
     1     1   sugra                                             
#
BLOCK SMINPUTS  # Standard Model inputs
     1     1.27934000E+02   # alpha_em^-1(M_Z)^MSbar
     2     1.16637000E-05   # G_F [GeV^-2]
     3     1.18000000E-01   # alpha_S(M_Z)^MSbar
     4     9.11876000E+01   # M_Z pole mass
     5     4.25000000E+00   # mb(mb)^MSbar
     6     1.75000000E+02   # mt pole mass
     7     1.77700000E+00   # mtau pole mass
#
BLOCK MINPAR  # Input parameters - minimal models
     1     1.45000000E+03   # m0                  
     2     3.00000000E+02   # m12                 
     3     1.00000000E+01   # tanb                
     4     1.00000000E+00   # sign(mu)            
#
BLOCK MASS  # Mass Spectrum
# PDG code           mass       particle
         5     4.88991651E+00   # b-quark pole mass calculated from mb(mb)_Msbar
         6     1.75000000E+02   # mt pole mass (not read by ME)
        24     7.98290131E+01   # W+
        25     1.15172279E+02   # h
        35     1.51114877E+03   # H
        36     1.51103826E+03   # A
        37     1.51343530E+03   # H+
   1000001     1.55931152E+03   # ~d_L
   2000001     1.55240630E+03   # ~d_R
   1000002     1.55431328E+03   # ~u_L
   2000002     1.55382420E+03   # ~u_R
   1000003     1.55931152E+03   # ~s_L
   2000003     1.55240630E+03   # ~s_R
   1000004     1.55431328E+03   # ~c_L
   2000004     1.55382420E+03   # ~c_R
   1000005     1.28421793E+03   # ~b_1
   2000005     1.53908204E+03   # ~b_2
   1000006     9.50096226E+02   # ~t_1
   2000006     1.29611751E+03   # ~t_2
   1000011     1.45911583E+03   # ~e_L
   2000011     1.45303116E+03   # ~e_R
   1000012     1.45599000E+03   # ~nu_eL
   1000013     1.45911583E+03   # ~mu_L
   2000013     1.45303116E+03   # ~mu_R
   1000014     1.45599000E+03   # ~nu_muL
   1000015     1.44007642E+03   # ~tau_1
   2000015     1.45350507E+03   # ~tau_2
   1000016     1.45001839E+03   # ~nu_tauL
   1000021     7.81898886E+02   # ~g
   1000022     1.22849441E+02   # ~chi_10
   1000023     2.35046162E+02   # ~chi_20
   1000025    -4.69015751E+02   # ~chi_30
   1000035     4.83058535E+02   # ~chi_40
   1000024     2.37406034E+02   # ~chi_1+
   1000037     4.84104812E+02   # ~chi_2+
#
BLOCK NMIX  # Neutralino Mixing Matrix
  1  1     9.92797628E-01   # N_11
  1  2    -3.04145381E-02   # N_12
  1  3     1.09080644E-01   # N_13
  1  4    -3.91054708E-02   # N_14
  2  1     5.84996523E-02   # N_21
  2  2     9.66019640E-01   # N_22
  2  3    -2.17829192E-01   # N_23
  2  4     1.26231093E-01   # N_24
  3  1    -4.69368399E-02   # N_31
  3  2     6.81242959E-02   # N_32
  3  3     7.00360055E-01   # N_33
  3  4     7.08979412E-01   # N_34
  4  1    -9.34215858E-02   # N_41
  4  2     2.47467354E-01   # N_42
  4  3     6.70930436E-01   # N_43
  4  4    -6.92737083E-01   # N_44
#
BLOCK UMIX  # Chargino Mixing Matrix U
  1  1     9.48909352E-01   # U_11
  1  2    -3.15548795E-01   # U_12
  2  1     3.15548795E-01   # U_21
  2  2     9.48909352E-01   # U_22
#
BLOCK VMIX  # Chargino Mixing Matrix V
  1  1     9.83010683E-01   # V_11
  1  2    -1.83548349E-01   # V_12
  2  1     1.83548349E-01   # V_21
  2  2     9.83010683E-01   # V_22
#
BLOCK STOPMIX  # Stop Mixing Matrix
  1  1     1.25445912E-01   # O_{11}
  1  2     9.92100460E-01   # O_{12}
  2  1     9.92100460E-01   # O_{21}
  2  2    -1.25445912E-01   # O_{22}
#
BLOCK SBOTMIX  # Sbottom Mixing Matrix
  1  1     9.99839511E-01   # O_{11}
  1  2     1.79151679E-02   # O_{12}
  2  1    -1.79151679E-02   # O_{21}
  2  2     9.99839511E-01   # O_{22}
#
BLOCK STAUMIX  # Stau Mixing Matrix
  1  1     2.14038360E-01   # O_{11}
  1  2     9.76825256E-01   # O_{12}
  2  1     9.76825256E-01   # O_{21}
  2  2    -2.14038360E-01   # O_{22}
#
BLOCK ALPHA  # Higgs mixing
          -1.04393740E-01   # Mixing angle in the neutral Higgs boson sector
#
BLOCK HMIX Q=  1.09862507E+03  # DRbar Higgs Parameters
     1     4.64310302E+02   # mu(Q)MSSM DRbar     
     2     9.63167226E+00   # tan beta(Q)MSSM DRba
     3     2.43241679E+02   # higgs vev(Q)MSSM DRb
     4     2.30234275E+06   # mA^2(Q)MSSM DRbar   
#
BLOCK GAUGE Q=  1.09862507E+03  # The gauge couplings
     3     1.05313071E+00   # g3(Q) MSbar
#
BLOCK AU Q=  1.09862507E+03  # The trilinear couplings
  1  1     0.00000000E+00   # A_u(Q) DRbar
  2  2     0.00000000E+00   # A_c(Q) DRbar
  3  3    -5.20713786E+02   # A_t(Q) DRbar
#
BLOCK AD Q=  1.09862507E+03  # The trilinear couplings
  1  1     0.00000000E+00   # A_d(Q) DRbar
  2  2     0.00000000E+00   # A_s(Q) DRbar
  3  3    -7.83275622E+02   # A_b(Q) DRbar
#
BLOCK AE Q=  1.09862507E+03  # The trilinear couplings
  1  1     0.00000000E+00   # A_e(Q) DRbar
  2  2     0.00000000E+00   # A_mu(Q) DRbar
  3  3    -1.78852193E+02   # A_tau(Q) DRbar
#
BLOCK YU Q=  1.09862507E+03  # The Yukawa couplings
  3  3     8.73306713E-01   # y_t(Q) DRbar
#
BLOCK YD Q=  1.09862507E+03  # The Yukawa couplings
  3  3     1.36198959E-01   # y_b(Q) DRbar
#
BLOCK YE Q=  1.09862507E+03  # The Yukawa couplings
  3  3     9.90900945E-02   # y_tau(Q) DRbar
#
BLOCK MSOFT Q=  1.09862507E+03  # The soft SUSY breaking masses at the scale Q
     1     1.25459404E+02   # M_1(Q)              
     2     2.33056280E+02   # M_2(Q)              
     3     6.69284431E+02   # M_3(Q)              
    21     2.04348830E+06   # mH1^2(Q)            
    22    -1.69489026E+05   # mH2^2(Q)            
    31     1.45570737E+03   # meL(Q)              
    32     1.45570737E+03   # mmuL(Q)             
    33     1.44967248E+03   # mtauL(Q)            
    34     1.45113170E+03   # meR(Q)              
    35     1.45113170E+03   # mmuR(Q)             
    36     1.43894634E+03   # mtauR(Q)            
    41     1.53851945E+03   # mqL1(Q)             
    42     1.53851945E+03   # mqL2(Q)             
    43     1.27150657E+03   # mqL3(Q)             
    44     1.53533107E+03   # muR(Q)              
    45     1.53533107E+03   # mcR(Q)              
    46     9.34674342E+02   # mtR(Q)              
    47     1.53339994E+03   # mdR(Q)              
    48     1.53339994E+03   # msR(Q)              
    49     1.52101430E+03   # mbR(Q)              
#
#
#
#                             =================
#                             |The decay table|
#                             =================
#
# - The multi-body decays for the inos, stops and sbottoms are included.
#
# - The SUSY decays of the top quark are included.
#
#
#         PDG            Width
DECAY        23     2.41143316E+00   # Z width (SM calculation)
DECAY        24     2.00282196E+00   # W width (SM calculation)
#
#         PDG            Width
DECAY         6     1.56194983E+00   # top decays
#          BR         NDA      ID1       ID2
     1.00000000E+00    2           5        24   # BR(t ->  b    W+)
     0.00000000E+00    2           5        37   # BR(t ->  b    H+)
     0.00000000E+00    2     1000006   1000022   # BR(t -> ~t_1 ~chi_10)
     0.00000000E+00    2     1000006   1000023   # BR(t -> ~t_1 ~chi_20)
     0.00000000E+00    2     1000006   1000025   # BR(t -> ~t_1 ~chi_30)
     0.00000000E+00    2     1000006   1000035   # BR(t -> ~t_1 ~chi_40)
     0.00000000E+00    2     2000006   1000022   # BR(t -> ~t_2 ~chi_10)
     0.00000000E+00    2     2000006   1000023   # BR(t -> ~t_2 ~chi_20)
     0.00000000E+00    2     2000006   1000025   # BR(t -> ~t_2 ~chi_30)
     0.00000000E+00    2     2000006   1000035   # BR(t -> ~t_2 ~chi_40)
#
#         PDG            Width
DECAY        25     1.74556397E-03   # h decays
#          BR         NDA      ID1       ID2
     1.39750346E-01    2          15       -15   # BR(H1 -> tau- tau+)
     7.84634857E-01    2           5        -5   # BR(H1 -> b bb)
     7.08726118E-02    2          24       -24   # BR(H1 -> W+ W-)
     4.74218479E-03    2          23        23   # BR(H1 -> Z Z)
#
#         PDG            Width
DECAY        35     2.63857501E+00   # H decays
#          BR         NDA      ID1       ID2
     1.10658102E-01    2          15       -15   # BR(H -> tau- tau+)
     2.60600489E-01    2           6        -6   # BR(H -> t tb)
     6.27144880E-01    2           5        -5   # BR(H -> b bb)
     3.73136377E-04    2          24       -24   # BR(H -> W+ W-)
     1.85618475E-04    2          23        23   # BR(H -> Z Z)
     0.00000000E+00    2          24       -37   # BR(H -> W+ H-)
     0.00000000E+00    2         -24        37   # BR(H -> W- H+)
     0.00000000E+00    2          37       -37   # BR(H -> H+ H-)
     1.03777426E-03    2          25        25   # BR(H -> h h)
     0.00000000E+00    2          36        36   # BR(H -> A A)
#
#         PDG            Width
DECAY        36     2.66158444E+00   # A decays
#          BR         NDA      ID1       ID2
     1.09715563E-01    2          15       -15   # BR(A -> tau- tau+)
     2.68093243E-01    2           6        -6   # BR(A -> t tb)
     6.21825730E-01    2           5        -5   # BR(A -> b bb)
     3.65463754E-04    2          23        25   # BR(A -> Z h)
     0.00000000E+00    2          23        35   # BR(A -> Z H)
     0.00000000E+00    2          24       -37   # BR(A -> W+ H-)
     0.00000000E+00    2         -24        37   # BR(A -> W- H+)
#
#         PDG            Width
DECAY        37     2.62953484E+00   # H+ decays
#          BR         NDA      ID1       ID2
     1.11229134E-01    2         -15        16   # BR(H+ -> tau+ nu_tau)
     8.88398184E-01    2           6        -5   # BR(H+ -> t bb)
     3.72682177E-04    2          24        25   # BR(H+ -> W+ h)
     0.00000000E+00    2          24        35   # BR(H+ -> W+ H)
     0.00000000E+00    2          24        36   # BR(H+ -> W+ A)
#
#         PDG            Width
DECAY   1000021     2.61914150E-03   # gluino decays
#           BR         NDA      ID1       ID2       ID3
     1.08568721E-02    3     1000022         1        -1   # BR(~g -> ~chi_10 d  db)
     3.85532351E-02    3     1000023         1        -1   # BR(~g -> ~chi_20 d  db)
     1.44423781E-05    3     1000025         1        -1   # BR(~g -> ~chi_30 d  db)
     3.78641719E-04    3     1000035         1        -1   # BR(~g -> ~chi_40 d  db)
     3.38409830E-02    3     1000022         2        -2   # BR(~g -> ~chi_10 u  ub)
     4.09634282E-02    3     1000023         2        -2   # BR(~g -> ~chi_20 u  ub)
     1.12060501E-05    3     1000025         2        -2   # BR(~g -> ~chi_30 u  ub)
     3.11741607E-04    3     1000035         2        -2   # BR(~g -> ~chi_40 u  ub)
     1.08568721E-02    3     1000022         3        -3   # BR(~g -> ~chi_10 s  sb)
     3.85532351E-02    3     1000023         3        -3   # BR(~g -> ~chi_20 s  sb)
     1.44423781E-05    3     1000025         3        -3   # BR(~g -> ~chi_30 s  sb)
     3.78641719E-04    3     1000035         3        -3   # BR(~g -> ~chi_40 s  sb)
     3.38409830E-02    3     1000022         4        -4   # BR(~g -> ~chi_10 c  cb)
     4.09634282E-02    3     1000023         4        -4   # BR(~g -> ~chi_20 c  cb)
     1.12060501E-05    3     1000025         4        -4   # BR(~g -> ~chi_30 c  cb)
     3.11741607E-04    3     1000035         4        -4   # BR(~g -> ~chi_40 c  cb)
     1.53100058E-02    3     1000022         5        -5   # BR(~g -> ~chi_10 b  bb)
     9.65125323E-02    3     1000023         5        -5   # BR(~g -> ~chi_20 b  bb)
     1.06208080E-03    3     1000025         5        -5   # BR(~g -> ~chi_30 b  bb)
     1.83692827E-03    3     1000035         5        -5   # BR(~g -> ~chi_40 b  bb)
     9.92065188E-02    3     1000022         6        -6   # BR(~g -> ~chi_10 t  tb)
     1.17953941E-02    3     1000023         6        -6   # BR(~g -> ~chi_20 t  tb)
     0.00000000E+00    3     1000025         6        -6   # BR(~g -> ~chi_30 t  tb)
     0.00000000E+00    3     1000035         6        -6   # BR(~g -> ~chi_40 t  tb)
     7.85597617E-02    3     1000024         1        -2   # BR(~g -> ~chi_1+ d  ub)
     7.85597617E-02    3    -1000024         2        -1   # BR(~g -> ~chi_1- u  db)
     6.72469173E-04    3     1000037         1        -2   # BR(~g -> ~chi_2+ d  ub)
     6.72469173E-04    3    -1000037         2        -1   # BR(~g -> ~chi_2- u  db)
     7.85597617E-02    3     1000024         3        -4   # BR(~g -> ~chi_1+ s  cb)
     7.85597617E-02    3    -1000024         4        -3   # BR(~g -> ~chi_1- c  sb)
     6.72469173E-04    3     1000037         3        -4   # BR(~g -> ~chi_2+ s  cb)
     6.72469173E-04    3    -1000037         4        -3   # BR(~g -> ~chi_2- c  sb)
     7.99935892E-02    3     1000024         5        -6   # BR(~g -> ~chi_1+ b  tb)
     7.99935892E-02    3    -1000024         6        -5   # BR(~g -> ~chi_1- t  bb)
     2.37496688E-02    3     1000037         5        -6   # BR(~g -> ~chi_2+ b  tb)
     2.37496688E-02    3    -1000037         6        -5   # BR(~g -> ~chi_2- t  bb)
     0.00000000E+00    3     1000006        -5       -24   # BR(~g -> ~t_1    bb W-)
     0.00000000E+00    3    -1000006         5        24   # BR(~g -> ~t_1*   b  W+)
     0.00000000E+00    3     1000006        -5       -37   # BR(~g -> ~t_1    bb H-)
     0.00000000E+00    3    -1000006         5        37   # BR(~g -> ~t_1*   b  H+)
#
#         PDG            Width
DECAY   1000006     1.75928469E+01   # stop1 decays
#          BR         NDA      ID1       ID2
     1.09448984E-01    2     1000022         6   # BR(~t_1 -> ~chi_10 t )
     2.41846014E-02    2     1000023         6   # BR(~t_1 -> ~chi_20 t )
     2.27512666E-01    2     1000025         6   # BR(~t_1 -> ~chi_30 t )
     1.72542842E-01    2     1000035         6   # BR(~t_1 -> ~chi_40 t )
     5.39584750E-02    2     1000024         5   # BR(~t_1 -> ~chi_1+ b )
     4.12352432E-01    2     1000037         5   # BR(~t_1 -> ~chi_2+ b )
     0.00000000E+00    2     1000021         6   # BR(~t_1 -> ~g      t )
     0.00000000E+00    2     1000005        37   # BR(~t_1 -> ~b_1    H+)
     0.00000000E+00    2     2000005        37   # BR(~t_1 -> ~b_2    H+)
     0.00000000E+00    2     1000005        24   # BR(~t_1 -> ~b_1    W+)
     0.00000000E+00    2     2000005        24   # BR(~t_1 -> ~b_2    W+)
#
#         PDG            Width
DECAY   2000006     5.75326698E+01   # stop2 decays
#          BR         NDA      ID1       ID2
     2.30908763E-03    2     1000022         6   # BR(~t_2 -> ~chi_10 t )
     7.77273606E-02    2     1000023         6   # BR(~t_2 -> ~chi_20 t )
     1.19356099E-01    2     1000025         6   # BR(~t_2 -> ~chi_30 t )
     1.33939015E-01    2     1000035         6   # BR(~t_2 -> ~chi_40 t )
     1.57657021E-01    2     1000024         5   # BR(~t_2 -> ~chi_1+ b )
     2.24336879E-02    2     1000037         5   # BR(~t_2 -> ~chi_2+ b )
     4.56063239E-01    2     1000021         6   # BR(~t_2 -> ~g      t )
     1.34554106E-02    2     1000006        25   # BR(~t_2 -> ~t_1    h )
     0.00000000E+00    2     1000006        35   # BR(~t_2 -> ~t_1    H )
     0.00000000E+00    2     1000006        36   # BR(~t_2 -> ~t_1    A )
     0.00000000E+00    2     1000005        37   # BR(~t_2 -> ~b_1    H+)
     0.00000000E+00    2     2000005        37   # BR(~t_2 -> ~b_2    H+)
     1.70590802E-02    2     1000006        23   # BR(~t_2 -> ~t_1    Z )
     0.00000000E+00    2     1000005        24   # BR(~t_2 -> ~b_1    W+)
     0.00000000E+00    2     2000005        24   # BR(~t_2 -> ~b_2    W+)
#
#         PDG            Width
DECAY   1000005     6.09457233E+01   # sbottom1 decays
#          BR         NDA      ID1       ID2
     4.08034135E-03    2     1000022         5   # BR(~b_1 -> ~chi_10 b )
     7.56044373E-02    2     1000023         5   # BR(~b_1 -> ~chi_20 b )
     3.20158717E-03    2     1000025         5   # BR(~b_1 -> ~chi_30 b )
     7.01193659E-03    2     1000035         5   # BR(~b_1 -> ~chi_40 b )
     1.48222955E-01    2    -1000024         6   # BR(~b_1 -> ~chi_1- t )
     2.40382303E-01    2    -1000037         6   # BR(~b_1 -> ~chi_2- t )
     4.91084085E-01    2     1000021         5   # BR(~b_1 -> ~g      b )
     0.00000000E+00    2     1000006       -37   # BR(~b_1 -> ~t_1    H-)
     0.00000000E+00    2     2000006       -37   # BR(~b_1 -> ~t_2    H-)
     3.04123541E-02    2     1000006       -24   # BR(~b_1 -> ~t_1    W-)
     0.00000000E+00    2     2000006       -24   # BR(~b_1 -> ~t_2    W-)
#
#         PDG            Width
DECAY   2000005     5.16683385E+01   # sbottom2 decays
#          BR         NDA      ID1       ID2
     1.64661552E-02    2     1000022         5   # BR(~b_2 -> ~chi_10 b )
     3.30476030E-04    2     1000023         5   # BR(~b_2 -> ~chi_20 b )
     4.53772512E-03    2     1000025         5   # BR(~b_2 -> ~chi_30 b )
     4.36303330E-03    2     1000035         5   # BR(~b_2 -> ~chi_40 b )
     5.69055898E-04    2    -1000024         6   # BR(~b_2 -> ~chi_1- t )
     8.49106743E-03    2    -1000037         6   # BR(~b_2 -> ~chi_2- t )
     9.64528400E-01    2     1000021         5   # BR(~b_2 -> ~g      b )
     1.88178360E-04    2     1000005        25   # BR(~b_2 -> ~b_1    h )
     0.00000000E+00    2     1000005        35   # BR(~b_2 -> ~b_1    H )
     0.00000000E+00    2     1000005        36   # BR(~b_2 -> ~b_1    A )
     0.00000000E+00    2     1000006       -37   # BR(~b_2 -> ~t_1    H-)
     0.00000000E+00    2     2000006       -37   # BR(~b_2 -> ~t_2    H-)
     1.69299183E-04    2     1000005        23   # BR(~b_2 -> ~b_1    Z )
     5.38503978E-05    2     1000006       -24   # BR(~b_2 -> ~t_1    W-)
     3.02759424E-04    2     2000006       -24   # BR(~b_2 -> ~t_2    W-)
#
#         PDG            Width
DECAY   1000002     6.97366941E+01   # sup_L decays
#          BR         NDA      ID1       ID2
     2.13518517E-03    2     1000022         2   # BR(~u_L -> ~chi_10 u)
     8.49210037E-02    2     1000023         2   # BR(~u_L -> ~chi_20 u)
     2.72533879E-04    2     1000025         2   # BR(~u_L -> ~chi_30 u)
     4.03435386E-03    2     1000035         2   # BR(~u_L -> ~chi_40 u)
     1.71851278E-01    2     1000024         1   # BR(~u_L -> ~chi_1+ d)
     5.12165391E-03    2     1000037         1   # BR(~u_L -> ~chi_2+ d)
     7.31663991E-01    2     1000021         2   # BR(~u_L -> ~g      u)
#
#         PDG            Width
DECAY   2000002     5.44569139E+01   # sup_R decays
#          BR         NDA      ID1       ID2
     6.29470484E-02    2     1000022         2   # BR(~u_R -> ~chi_10 u)
     2.11300540E-04    2     1000023         2   # BR(~u_R -> ~chi_20 u)
     1.17692759E-04    2     1000025         2   # BR(~u_R -> ~chi_30 u)
     4.60583405E-04    2     1000035         2   # BR(~u_R -> ~chi_40 u)
     0.00000000E+00    2     1000024         1   # BR(~u_R -> ~chi_1+ d)
     0.00000000E+00    2     1000037         1   # BR(~u_R -> ~chi_2+ d)
     9.36263375E-01    2     1000021         2   # BR(~u_R -> ~g      u)
#
#         PDG            Width
DECAY   1000001     7.00587302E+01   # sdown_L decays
#          BR         NDA      ID1       ID2
     4.17598062E-03    2     1000022         1   # BR(~d_L -> ~chi_10 d)
     8.11292744E-02    2     1000023         1   # BR(~d_L -> ~chi_20 d)
     4.53766766E-04    2     1000025         1   # BR(~d_L -> ~chi_30 d)
     5.32901315E-03    2     1000035         1   # BR(~d_L -> ~chi_40 d)
     1.59960207E-01    2    -1000024         2   # BR(~d_L -> ~chi_1- u)
     1.51367547E-02    2    -1000037         2   # BR(~d_L -> ~chi_2- u)
     7.33815004E-01    2     1000021         1   # BR(~d_L -> ~g      d)
#
#         PDG            Width
DECAY   2000001     5.17432847E+01   # sdown_R decays
#          BR         NDA      ID1       ID2
     1.65465685E-02    2     1000022         1   # BR(~d_R -> ~chi_10 d)
     5.55400145E-05    2     1000023         1   # BR(~d_R -> ~chi_20 d)
     3.09266699E-05    2     1000025         1   # BR(~d_R -> ~chi_30 d)
     1.21026644E-04    2     1000035         1   # BR(~d_R -> ~chi_40 d)
     0.00000000E+00    2    -1000024         2   # BR(~d_R -> ~chi_1- u)
     0.00000000E+00    2    -1000037         2   # BR(~d_R -> ~chi_2- u)
     9.83245938E-01    2     1000021         1   # BR(~d_R -> ~g      d)
#
#         PDG            Width
DECAY   1000004     6.97366941E+01   # scharm_L decays
#          BR         NDA      ID1       ID2
     2.13518517E-03    2     1000022         4   # BR(~c_L -> ~chi_10 c)
     8.49210037E-02    2     1000023         4   # BR(~c_L -> ~chi_20 c)
     2.72533879E-04    2     1000025         4   # BR(~c_L -> ~chi_30 c)
     4.03435386E-03    2     1000035         4   # BR(~c_L -> ~chi_40 c)
     1.71851278E-01    2     1000024         3   # BR(~c_L -> ~chi_1+ s)
     5.12165391E-03    2     1000037         3   # BR(~c_L -> ~chi_2+ s)
     7.31663991E-01    2     1000021         4   # BR(~c_L -> ~g      c)
#
#         PDG            Width
DECAY   2000004     5.44569139E+01   # scharm_R decays
#          BR         NDA      ID1       ID2
     6.29470484E-02    2     1000022         4   # BR(~c_R -> ~chi_10 c)
     2.11300540E-04    2     1000023         4   # BR(~c_R -> ~chi_20 c)
     1.17692759E-04    2     1000025         4   # BR(~c_R -> ~chi_30 c)
     4.60583405E-04    2     1000035         4   # BR(~c_R -> ~chi_40 c)
     0.00000000E+00    2     1000024         3   # BR(~c_R -> ~chi_1+ s)
     0.00000000E+00    2     1000037         3   # BR(~c_R -> ~chi_2+ s)
     9.36263375E-01    2     1000021         4   # BR(~c_R -> ~g      c)
#
#         PDG            Width
DECAY   1000003     7.00587302E+01   # sstrange_L decays
#          BR         NDA      ID1       ID2
     4.17598062E-03    2     1000022         3   # BR(~s_L -> ~chi_10 s)
     8.11292744E-02    2     1000023         3   # BR(~s_L -> ~chi_20 s)
     4.53766766E-04    2     1000025         3   # BR(~s_L -> ~chi_30 s)
     5.32901315E-03    2     1000035         3   # BR(~s_L -> ~chi_40 s)
     1.59960207E-01    2    -1000024         4   # BR(~s_L -> ~chi_1- c)
     1.51367547E-02    2    -1000037         4   # BR(~s_L -> ~chi_2- c)
     7.33815004E-01    2     1000021         3   # BR(~s_L -> ~g      s)
#
#         PDG            Width
DECAY   2000003     5.17432847E+01   # sstrange_R decays
#          BR         NDA      ID1       ID2
     1.65465685E-02    2     1000022         3   # BR(~s_R -> ~chi_10 s)
     5.55400145E-05    2     1000023         3   # BR(~s_R -> ~chi_20 s)
     3.09266699E-05    2     1000025         3   # BR(~s_R -> ~chi_30 s)
     1.21026644E-04    2     1000035         3   # BR(~s_R -> ~chi_40 s)
     0.00000000E+00    2    -1000024         4   # BR(~s_R -> ~chi_1- c)
     0.00000000E+00    2    -1000037         4   # BR(~s_R -> ~chi_2- c)
     9.83245938E-01    2     1000021         3   # BR(~s_R -> ~g      s)
#
#         PDG            Width
DECAY   1000011     1.89560173E+01   # selectron_L decays
#          BR         NDA      ID1       ID2
     8.50695192E-02    2     1000022        11   # BR(~e_L -> ~chi_10 e-)
     3.04422052E-01    2     1000023        11   # BR(~e_L -> ~chi_20 e-)
     4.61195429E-04    2     1000025        11   # BR(~e_L -> ~chi_30 e-)
     9.79407881E-03    2     1000035        11   # BR(~e_L -> ~chi_40 e-)
     5.49478974E-01    2    -1000024        12   # BR(~e_L -> ~chi_1- nu_e)
     5.07741802E-02    2    -1000037        12   # BR(~e_L -> ~chi_2- nu_e)
#
#         PDG            Width
DECAY   2000011     7.28776336E+00   # selectron_R decays
#          BR         NDA      ID1       ID2
     9.87881974E-01    2     1000022        11   # BR(~e_R -> ~chi_10 e-)
     3.29981923E-03    2     1000023        11   # BR(~e_R -> ~chi_20 e-)
     1.79752313E-03    2     1000025        11   # BR(~e_R -> ~chi_30 e-)
     7.02068362E-03    2     1000035        11   # BR(~e_R -> ~chi_40 e-)
     0.00000000E+00    2    -1000024        12   # BR(~e_R -> ~chi_1- nu_e)
     0.00000000E+00    2    -1000037        12   # BR(~e_R -> ~chi_2- nu_e)
#
#         PDG            Width
DECAY   1000013     1.89560173E+01   # smuon_L decays
#          BR         NDA      ID1       ID2
     8.50695192E-02    2     1000022        13   # BR(~mu_L -> ~chi_10 mu-)
     3.04422052E-01    2     1000023        13   # BR(~mu_L -> ~chi_20 mu-)
     4.61195429E-04    2     1000025        13   # BR(~mu_L -> ~chi_30 mu-)
     9.79407881E-03    2     1000035        13   # BR(~mu_L -> ~chi_40 mu-)
     5.49478974E-01    2    -1000024        14   # BR(~mu_L -> ~chi_1- nu_mu)
     5.07741802E-02    2    -1000037        14   # BR(~mu_L -> ~chi_2- nu_mu)
#
#         PDG            Width
DECAY   2000013     7.28776336E+00   # smuon_R decays
#          BR         NDA      ID1       ID2
     9.87881974E-01    2     1000022        13   # BR(~mu_R -> ~chi_10 mu-)
     3.29981923E-03    2     1000023        13   # BR(~mu_R -> ~chi_20 mu-)
     1.79752313E-03    2     1000025        13   # BR(~mu_R -> ~chi_30 mu-)
     7.02068362E-03    2     1000035        13   # BR(~mu_R -> ~chi_40 mu-)
     0.00000000E+00    2    -1000024        14   # BR(~mu_R -> ~chi_1- nu_mu)
     0.00000000E+00    2    -1000037        14   # BR(~mu_R -> ~chi_2- nu_mu)
#
#         PDG            Width
DECAY   1000015     8.24807251E+00   # stau_1 decays
#          BR         NDA      ID1       ID2
     8.38602901E-01    2     1000022        15   # BR(~tau_1 -> ~chi_10  tau-)
     4.86007412E-02    2     1000023        15   # BR(~tau_1 -> ~chi_20  tau-)
     1.14356540E-02    2     1000025        15   # BR(~tau_1 -> ~chi_30  tau-)
     8.52209631E-03    2     1000035        15   # BR(~tau_1 -> ~chi_40  tau-)
     8.65282764E-02    2    -1000024        16   # BR(~tau_1 -> ~chi_1-  nu_tau)
     6.31033104E-03    2    -1000037        16   # BR(~tau_1 -> ~chi_2-  nu_tau)
     0.00000000E+00    2     1000016       -37   # BR(~tau_1 -> ~nu_tauL H-)
     0.00000000E+00    2     1000016       -24   # BR(~tau_1 -> ~nu_tauL W-)
#
#         PDG            Width
DECAY   2000015     1.85221018E+01   # stau_2 decays
#          BR         NDA      ID1       ID2
     9.88781367E-02    2     1000022        15   # BR(~tau_2 -> ~chi_10  tau-)
     2.91028031E-01    2     1000023        15   # BR(~tau_2 -> ~chi_20  tau-)
     8.07736393E-03    2     1000025        15   # BR(~tau_2 -> ~chi_30  tau-)
     1.98225111E-02    2     1000035        15   # BR(~tau_2 -> ~chi_40  tau-)
     5.22468322E-01    2    -1000024        16   # BR(~tau_2 -> ~chi_1-  nu_tau)
     5.97256353E-02    2    -1000037        16   # BR(~tau_2 -> ~chi_2-  nu_tau)
     0.00000000E+00    2     1000016       -37   # BR(~tau_2 -> ~nu_tauL H-)
     0.00000000E+00    2     1000016       -24   # BR(~tau_2 -> ~nu_tauL W-)
     0.00000000E+00    2     1000015        25   # BR(~tau_2 -> ~tau_1 h)
     0.00000000E+00    2     1000015        35   # BR(~tau_2 -> ~tau_1 H)
     0.00000000E+00    2     1000015        36   # BR(~tau_2 -> ~tau_1 A)
     0.00000000E+00    2     1000015        23   # BR(~tau_2 -> ~tau_1 Z)
#
#         PDG            Width
DECAY   1000012     1.89960334E+01   # snu_eL decays
#          BR         NDA      ID1       ID2
     1.05777173E-01    2     1000022        12   # BR(~nu_eL -> ~chi_10 nu_e)
     2.65110565E-01    2     1000023        12   # BR(~nu_eL -> ~chi_20 nu_e)
     2.27708934E-03    2     1000025        12   # BR(~nu_eL -> ~chi_30 nu_e)
     2.27045033E-02    2     1000035        12   # BR(~nu_eL -> ~chi_40 nu_e)
     5.87042258E-01    2     1000024        11   # BR(~nu_eL -> ~chi_1+ e-)
     1.70884115E-02    2     1000037        11   # BR(~nu_eL -> ~chi_2+ e-)
#
#         PDG            Width
DECAY   1000014     1.89960334E+01   # snu_muL decays
#          BR         NDA      ID1       ID2
     1.05777173E-01    2     1000022        14   # BR(~nu_muL -> ~chi_10 nu_mu)
     2.65110565E-01    2     1000023        14   # BR(~nu_muL -> ~chi_20 nu_mu)
     2.27708934E-03    2     1000025        14   # BR(~nu_muL -> ~chi_30 nu_mu)
     2.27045033E-02    2     1000035        14   # BR(~nu_muL -> ~chi_40 nu_mu)
     5.87042258E-01    2     1000024        13   # BR(~nu_muL -> ~chi_1+ mu-)
     1.70884115E-02    2     1000037        13   # BR(~nu_muL -> ~chi_2+ mu-)
#
#         PDG            Width
DECAY   1000016     1.91370930E+01   # snu_tauL decays
#          BR         NDA      ID1       ID2
     1.04554475E-01    2     1000022        16   # BR(~nu_tauL -> ~chi_10 nu_tau)
     2.61961375E-01    2     1000023        16   # BR(~nu_tauL -> ~chi_20 nu_tau)
     2.24673432E-03    2     1000025        16   # BR(~nu_tauL -> ~chi_30 nu_tau)
     2.23989114E-02    2     1000035        16   # BR(~nu_tauL -> ~chi_40 nu_tau)
     5.81434076E-01    2     1000024        15   # BR(~nu_tauL -> ~chi_1+ tau-)
     2.74044284E-02    2     1000037        15   # BR(~nu_tauL -> ~chi_2+ tau-)
     0.00000000E+00    2    -1000015       -37   # BR(~nu_tauL -> ~tau_1+ H-)
     0.00000000E+00    2    -2000015       -37   # BR(~nu_tauL -> ~tau_2+ H-)
     0.00000000E+00    2    -1000015       -24   # BR(~nu_tauL -> ~tau_1+ W-)
     0.00000000E+00    2    -2000015       -24   # BR(~nu_tauL -> ~tau_2+ W-)
#
#         PDG            Width
DECAY   1000024     6.04568843E-03   # chargino1+ decays
#          BR         NDA      ID1       ID2
     0.00000000E+00    2     1000002        -1   # BR(~chi_1+ -> ~u_L   db)
     0.00000000E+00    2     2000002        -1   # BR(~chi_1+ -> ~u_R   db)
     0.00000000E+00    2    -1000001         2   # BR(~chi_1+ -> ~d_L*  u )
     0.00000000E+00    2    -2000001         2   # BR(~chi_1+ -> ~d_R*  u )
     0.00000000E+00    2     1000004        -3   # BR(~chi_1+ -> ~c_L   sb)
     0.00000000E+00    2     2000004        -3   # BR(~chi_1+ -> ~c_R   sb)
     0.00000000E+00    2    -1000003         4   # BR(~chi_1+ -> ~s_L*  c )
     0.00000000E+00    2    -2000003         4   # BR(~chi_1+ -> ~s_R*  c )
     0.00000000E+00    2     1000006        -5   # BR(~chi_1+ -> ~t_1   bb)
     0.00000000E+00    2     2000006        -5   # BR(~chi_1+ -> ~t_2   bb)
     0.00000000E+00    2    -1000005         6   # BR(~chi_1+ -> ~b_1*  t )
     0.00000000E+00    2    -2000005         6   # BR(~chi_1+ -> ~b_2*  t )
     0.00000000E+00    2     1000012       -11   # BR(~chi_1+ -> ~nu_eL  e+  )
     0.00000000E+00    2     1000014       -13   # BR(~chi_1+ -> ~nu_muL  mu+ )
     0.00000000E+00    2     1000016       -15   # BR(~chi_1+ -> ~nu_tau1 tau+)
     0.00000000E+00    2    -1000011        12   # BR(~chi_1+ -> ~e_L+    nu_e)
     0.00000000E+00    2    -2000011        12   # BR(~chi_1+ -> ~e_R+    nu_e)
     0.00000000E+00    2    -1000013        14   # BR(~chi_1+ -> ~mu_L+   nu_mu)
     0.00000000E+00    2    -2000013        14   # BR(~chi_1+ -> ~mu_R+   nu_mu)
     0.00000000E+00    2    -1000015        16   # BR(~chi_1+ -> ~tau_1+  nu_tau)
     0.00000000E+00    2    -2000015        16   # BR(~chi_1+ -> ~tau_2+  nu_tau)
     1.00000000E+00    2     1000022        24   # BR(~chi_1+ -> ~chi_10  W+)
     0.00000000E+00    2     1000023        24   # BR(~chi_1+ -> ~chi_20  W+)
     0.00000000E+00    2     1000025        24   # BR(~chi_1+ -> ~chi_30  W+)
     0.00000000E+00    2     1000035        24   # BR(~chi_1+ -> ~chi_40  W+)
     0.00000000E+00    2     1000022        37   # BR(~chi_1+ -> ~chi_10  H+)
     0.00000000E+00    2     1000023        37   # BR(~chi_1+ -> ~chi_20  H+)
     0.00000000E+00    2     1000025        37   # BR(~chi_1+ -> ~chi_30  H+)
     0.00000000E+00    2     1000035        37   # BR(~chi_1+ -> ~chi_40  H+)
#
#         PDG            Width
DECAY   1000037     2.80411818E+00   # chargino2+ decays
#          BR         NDA      ID1       ID2
     0.00000000E+00    2     1000002        -1   # BR(~chi_2+ -> ~u_L   db)
     0.00000000E+00    2     2000002        -1   # BR(~chi_2+ -> ~u_R   db)
     0.00000000E+00    2    -1000001         2   # BR(~chi_2+ -> ~d_L*  u )
     0.00000000E+00    2    -2000001         2   # BR(~chi_2+ -> ~d_R*  u )
     0.00000000E+00    2     1000004        -3   # BR(~chi_2+ -> ~c_L   sb)
     0.00000000E+00    2     2000004        -3   # BR(~chi_2+ -> ~c_R   sb)
     0.00000000E+00    2    -1000003         4   # BR(~chi_2+ -> ~s_L*  c )
     0.00000000E+00    2    -2000003         4   # BR(~chi_2+ -> ~s_R*  c )
     0.00000000E+00    2     1000006        -5   # BR(~chi_2+ -> ~t_1   bb)
     0.00000000E+00    2     2000006        -5   # BR(~chi_2+ -> ~t_2   bb)
     0.00000000E+00    2    -1000005         6   # BR(~chi_2+ -> ~b_1*  t )
     0.00000000E+00    2    -2000005         6   # BR(~chi_2+ -> ~b_2*  t )
     0.00000000E+00    2     1000012       -11   # BR(~chi_2+ -> ~nu_eL  e+  )
     0.00000000E+00    2     1000014       -13   # BR(~chi_2+ -> ~nu_muL  mu+ )
     0.00000000E+00    2     1000016       -15   # BR(~chi_2+ -> ~nu_tau1 tau+)
     0.00000000E+00    2    -1000011        12   # BR(~chi_2+ -> ~e_L+    nu_e)
     0.00000000E+00    2    -2000011        12   # BR(~chi_2+ -> ~e_R+    nu_e)
     0.00000000E+00    2    -1000013        14   # BR(~chi_2+ -> ~mu_L+   nu_mu)
     0.00000000E+00    2    -2000013        14   # BR(~chi_2+ -> ~mu_R+   nu_mu)
     0.00000000E+00    2    -1000015        16   # BR(~chi_2+ -> ~tau_1+  nu_tau)
     0.00000000E+00    2    -2000015        16   # BR(~chi_2+ -> ~tau_2+  nu_tau)
     2.98772282E-01    2     1000024        23   # BR(~chi_2+ -> ~chi_1+  Z )
     9.50834392E-02    2     1000022        24   # BR(~chi_2+ -> ~chi_10  W+)
     3.47817700E-01    2     1000023        24   # BR(~chi_2+ -> ~chi_20  W+)
     0.00000000E+00    2     1000025        24   # BR(~chi_2+ -> ~chi_30  W+)
     0.00000000E+00    2     1000035        24   # BR(~chi_2+ -> ~chi_40  W+)
     2.58326579E-01    2     1000024        25   # BR(~chi_2+ -> ~chi_1+  h )
     0.00000000E+00    2     1000024        35   # BR(~chi_2+ -> ~chi_1+  H )
     0.00000000E+00    2     1000024        36   # BR(~chi_2+ -> ~chi_1+  A )
     0.00000000E+00    2     1000022        37   # BR(~chi_2+ -> ~chi_10  H+)
     0.00000000E+00    2     1000023        37   # BR(~chi_2+ -> ~chi_20  H+)
     0.00000000E+00    2     1000025        37   # BR(~chi_2+ -> ~chi_30  H+)
     0.00000000E+00    2     1000035        37   # BR(~chi_2+ -> ~chi_40  H+)
#
#         PDG            Width
DECAY   1000022     0.00000000E+00   # neutralino1 decays
#
#         PDG            Width
DECAY   1000023     1.00000000E-03   # neutralino2 decays
#          BR         NDA      ID1       ID2
     1.00000000E+00    2     1000022        23   # BR(~chi_20 -> ~chi_10   Z )
     0.00000000E+00    2     1000024       -24   # BR(~chi_20 -> ~chi_1+   W-)
     0.00000000E+00    2    -1000024        24   # BR(~chi_20 -> ~chi_1-   W+)
     0.00000000E+00    2     1000037       -24   # BR(~chi_20 -> ~chi_2+   W-)
     0.00000000E+00    2    -1000037        24   # BR(~chi_20 -> ~chi_2-   W+)
     0.00000000E+00    2     1000022        25   # BR(~chi_20 -> ~chi_10   h )
     0.00000000E+00    2     1000022        35   # BR(~chi_20 -> ~chi_10   H )
     0.00000000E+00    2     1000022        36   # BR(~chi_20 -> ~chi_10   A )
     0.00000000E+00    2     1000024       -37   # BR(~chi_20 -> ~chi_1+   H-)
     0.00000000E+00    2    -1000024        37   # BR(~chi_20 -> ~chi_1-   H+)
     0.00000000E+00    2     1000037       -37   # BR(~chi_20 -> ~chi_2+   H-)
     0.00000000E+00    2    -1000037        37   # BR(~chi_20 -> ~chi_2-   H+)
     0.00000000E+00    2     1000002        -2   # BR(~chi_20 -> ~u_L      ub)
     0.00000000E+00    2    -1000002         2   # BR(~chi_20 -> ~u_L*     u )
     0.00000000E+00    2     2000002        -2   # BR(~chi_20 -> ~u_R      ub)
     0.00000000E+00    2    -2000002         2   # BR(~chi_20 -> ~u_R*     u )
     0.00000000E+00    2     1000001        -1   # BR(~chi_20 -> ~d_L      db)
     0.00000000E+00    2    -1000001         1   # BR(~chi_20 -> ~d_L*     d )
     0.00000000E+00    2     2000001        -1   # BR(~chi_20 -> ~d_R      db)
     0.00000000E+00    2    -2000001         1   # BR(~chi_20 -> ~d_R*     d )
     0.00000000E+00    2     1000004        -4   # BR(~chi_20 -> ~c_L      cb)
     0.00000000E+00    2    -1000004         4   # BR(~chi_20 -> ~c_L*     c )
     0.00000000E+00    2     2000004        -4   # BR(~chi_20 -> ~c_R      cb)
     0.00000000E+00    2    -2000004         4   # BR(~chi_20 -> ~c_R*     c )
     0.00000000E+00    2     1000003        -3   # BR(~chi_20 -> ~s_L      sb)
     0.00000000E+00    2    -1000003         3   # BR(~chi_20 -> ~s_L*     s )
     0.00000000E+00    2     2000003        -3   # BR(~chi_20 -> ~s_R      sb)
     0.00000000E+00    2    -2000003         3   # BR(~chi_20 -> ~s_R*     s )
     0.00000000E+00    2     1000006        -6   # BR(~chi_20 -> ~t_1      tb)
     0.00000000E+00    2    -1000006         6   # BR(~chi_20 -> ~t_1*     t )
     0.00000000E+00    2     2000006        -6   # BR(~chi_20 -> ~t_2      tb)
     0.00000000E+00    2    -2000006         6   # BR(~chi_20 -> ~t_2*     t )
     0.00000000E+00    2     1000005        -5   # BR(~chi_20 -> ~b_1      bb)
     0.00000000E+00    2    -1000005         5   # BR(~chi_20 -> ~b_1*     b )
     0.00000000E+00    2     2000005        -5   # BR(~chi_20 -> ~b_2      bb)
     0.00000000E+00    2    -2000005         5   # BR(~chi_20 -> ~b_2*     b )
     0.00000000E+00    2     1000011       -11   # BR(~chi_20 -> ~e_L-     e+)
     0.00000000E+00    2    -1000011        11   # BR(~chi_20 -> ~e_L+     e-)
     0.00000000E+00    2     2000011       -11   # BR(~chi_20 -> ~e_R-     e+)
     0.00000000E+00    2    -2000011        11   # BR(~chi_20 -> ~e_R+     e-)
     0.00000000E+00    2     1000013       -13   # BR(~chi_20 -> ~mu_L-    mu+)
     0.00000000E+00    2    -1000013        13   # BR(~chi_20 -> ~mu_L+    mu-)
     0.00000000E+00    2     2000013       -13   # BR(~chi_20 -> ~mu_R-    mu+)
     0.00000000E+00    2    -2000013        13   # BR(~chi_20 -> ~mu_R+    mu-)
     0.00000000E+00    2     1000015       -15   # BR(~chi_20 -> ~tau_1-   tau+)
     0.00000000E+00    2    -1000015        15   # BR(~chi_20 -> ~tau_1+   tau-)
     0.00000000E+00    2     2000015       -15   # BR(~chi_20 -> ~tau_2-   tau+)
     0.00000000E+00    2    -2000015        15   # BR(~chi_20 -> ~tau_2+   tau-)
     0.00000000E+00    2     1000012       -12   # BR(~chi_20 -> ~nu_eL    nu_eb)
     0.00000000E+00    2    -1000012        12   # BR(~chi_20 -> ~nu_eL*   nu_e )
     0.00000000E+00    2     1000014       -14   # BR(~chi_20 -> ~nu_muL   nu_mub)
     0.00000000E+00    2    -1000014        14   # BR(~chi_20 -> ~nu_muL*  nu_mu )
     0.00000000E+00    2     1000016       -16   # BR(~chi_20 -> ~nu_tau1  nu_taub)
     0.00000000E+00    2    -1000016        16   # BR(~chi_20 -> ~nu_tau1* nu_tau )
#
#         PDG            Width
DECAY   1000025     2.66094361E+00   # neutralino3 decays
#          BR         NDA      ID1       ID2
     1.03551919E-01    2     1000022        23   # BR(~chi_30 -> ~chi_10   Z )
     2.50581402E-01    2     1000023        23   # BR(~chi_30 -> ~chi_20   Z )
     3.04220186E-01    2     1000024       -24   # BR(~chi_30 -> ~chi_1+   W-)
     3.04220186E-01    2    -1000024        24   # BR(~chi_30 -> ~chi_1-   W+)
     0.00000000E+00    2     1000037       -24   # BR(~chi_30 -> ~chi_2+   W-)
     0.00000000E+00    2    -1000037        24   # BR(~chi_30 -> ~chi_2-   W+)
     2.11117491E-02    2     1000022        25   # BR(~chi_30 -> ~chi_10   h )
     0.00000000E+00    2     1000022        35   # BR(~chi_30 -> ~chi_10   H )
     0.00000000E+00    2     1000022        36   # BR(~chi_30 -> ~chi_10   A )
     1.63145570E-02    2     1000023        25   # BR(~chi_30 -> ~chi_20   h )
     0.00000000E+00    2     1000023        35   # BR(~chi_30 -> ~chi_20   H )
     0.00000000E+00    2     1000023        36   # BR(~chi_30 -> ~chi_20   A )
     0.00000000E+00    2     1000024       -37   # BR(~chi_30 -> ~chi_1+   H-)
     0.00000000E+00    2    -1000024        37   # BR(~chi_30 -> ~chi_1-   H+)
     0.00000000E+00    2     1000037       -37   # BR(~chi_30 -> ~chi_2+   H-)
     0.00000000E+00    2    -1000037        37   # BR(~chi_30 -> ~chi_2-   H+)
     0.00000000E+00    2     1000002        -2   # BR(~chi_30 -> ~u_L      ub)
     0.00000000E+00    2    -1000002         2   # BR(~chi_30 -> ~u_L*     u )
     0.00000000E+00    2     2000002        -2   # BR(~chi_30 -> ~u_R      ub)
     0.00000000E+00    2    -2000002         2   # BR(~chi_30 -> ~u_R*     u )
     0.00000000E+00    2     1000001        -1   # BR(~chi_30 -> ~d_L      db)
     0.00000000E+00    2    -1000001         1   # BR(~chi_30 -> ~d_L*     d )
     0.00000000E+00    2     2000001        -1   # BR(~chi_30 -> ~d_R      db)
     0.00000000E+00    2    -2000001         1   # BR(~chi_30 -> ~d_R*     d )
     0.00000000E+00    2     1000004        -4   # BR(~chi_30 -> ~c_L      cb)
     0.00000000E+00    2    -1000004         4   # BR(~chi_30 -> ~c_L*     c )
     0.00000000E+00    2     2000004        -4   # BR(~chi_30 -> ~c_R      cb)
     0.00000000E+00    2    -2000004         4   # BR(~chi_30 -> ~c_R*     c )
     0.00000000E+00    2     1000003        -3   # BR(~chi_30 -> ~s_L      sb)
     0.00000000E+00    2    -1000003         3   # BR(~chi_30 -> ~s_L*     s )
     0.00000000E+00    2     2000003        -3   # BR(~chi_30 -> ~s_R      sb)
     0.00000000E+00    2    -2000003         3   # BR(~chi_30 -> ~s_R*     s )
     0.00000000E+00    2     1000006        -6   # BR(~chi_30 -> ~t_1      tb)
     0.00000000E+00    2    -1000006         6   # BR(~chi_30 -> ~t_1*     t )
     0.00000000E+00    2     2000006        -6   # BR(~chi_30 -> ~t_2      tb)
     0.00000000E+00    2    -2000006         6   # BR(~chi_30 -> ~t_2*     t )
     0.00000000E+00    2     1000005        -5   # BR(~chi_30 -> ~b_1      bb)
     0.00000000E+00    2    -1000005         5   # BR(~chi_30 -> ~b_1*     b )
     0.00000000E+00    2     2000005        -5   # BR(~chi_30 -> ~b_2      bb)
     0.00000000E+00    2    -2000005         5   # BR(~chi_30 -> ~b_2*     b )
     0.00000000E+00    2     1000011       -11   # BR(~chi_30 -> ~e_L-     e+)
     0.00000000E+00    2    -1000011        11   # BR(~chi_30 -> ~e_L+     e-)
     0.00000000E+00    2     2000011       -11   # BR(~chi_30 -> ~e_R-     e+)
     0.00000000E+00    2    -2000011        11   # BR(~chi_30 -> ~e_R+     e-)
     0.00000000E+00    2     1000013       -13   # BR(~chi_30 -> ~mu_L-    mu+)
     0.00000000E+00    2    -1000013        13   # BR(~chi_30 -> ~mu_L+    mu-)
     0.00000000E+00    2     2000013       -13   # BR(~chi_30 -> ~mu_R-    mu+)
     0.00000000E+00    2    -2000013        13   # BR(~chi_30 -> ~mu_R+    mu-)
     0.00000000E+00    2     1000015       -15   # BR(~chi_30 -> ~tau_1-   tau+)
     0.00000000E+00    2    -1000015        15   # BR(~chi_30 -> ~tau_1+   tau-)
     0.00000000E+00    2     2000015       -15   # BR(~chi_30 -> ~tau_2-   tau+)
     0.00000000E+00    2    -2000015        15   # BR(~chi_30 -> ~tau_2+   tau-)
     0.00000000E+00    2     1000012       -12   # BR(~chi_30 -> ~nu_eL    nu_eb)
     0.00000000E+00    2    -1000012        12   # BR(~chi_30 -> ~nu_eL*   nu_e )
     0.00000000E+00    2     1000014       -14   # BR(~chi_30 -> ~nu_muL   nu_mub)
     0.00000000E+00    2    -1000014        14   # BR(~chi_30 -> ~nu_muL*  nu_mu )
     0.00000000E+00    2     1000016       -16   # BR(~chi_30 -> ~nu_tau1  nu_taub)
     0.00000000E+00    2    -1000016        16   # BR(~chi_30 -> ~nu_tau1* nu_tau )
#
#         PDG            Width
DECAY   1000035     2.76313390E+00   # neutralino4 decays
#          BR         NDA      ID1       ID2
     2.45444969E-02    2     1000022        23   # BR(~chi_40 -> ~chi_10   Z )
     2.36477385E-02    2     1000023        23   # BR(~chi_40 -> ~chi_20   Z )
     0.00000000E+00    2     1000025        23   # BR(~chi_40 -> ~chi_30   Z )
     3.16676477E-01    2     1000024       -24   # BR(~chi_40 -> ~chi_1+   W-)
     3.16676477E-01    2    -1000024        24   # BR(~chi_40 -> ~chi_1-   W+)
     0.00000000E+00    2     1000037       -24   # BR(~chi_40 -> ~chi_2+   W-)
     0.00000000E+00    2    -1000037        24   # BR(~chi_40 -> ~chi_2-   W+)
     8.67251407E-02    2     1000022        25   # BR(~chi_40 -> ~chi_10   h )
     0.00000000E+00    2     1000022        35   # BR(~chi_40 -> ~chi_10   H )
     0.00000000E+00    2     1000022        36   # BR(~chi_40 -> ~chi_10   A )
     2.31729670E-01    2     1000023        25   # BR(~chi_40 -> ~chi_20   h )
     0.00000000E+00    2     1000023        35   # BR(~chi_40 -> ~chi_20   H )
     0.00000000E+00    2     1000023        36   # BR(~chi_40 -> ~chi_20   A )
     0.00000000E+00    2     1000025        25   # BR(~chi_40 -> ~chi_30   h )
     0.00000000E+00    2     1000025        35   # BR(~chi_40 -> ~chi_30   H )
     0.00000000E+00    2     1000025        36   # BR(~chi_40 -> ~chi_30   A )
     0.00000000E+00    2     1000024       -37   # BR(~chi_40 -> ~chi_1+   H-)
     0.00000000E+00    2    -1000024        37   # BR(~chi_40 -> ~chi_1-   H+)
     0.00000000E+00    2     1000037       -37   # BR(~chi_40 -> ~chi_2+   H-)
     0.00000000E+00    2    -1000037        37   # BR(~chi_40 -> ~chi_2-   H+)
     0.00000000E+00    2     1000002        -2   # BR(~chi_40 -> ~u_L      ub)
     0.00000000E+00    2    -1000002         2   # BR(~chi_40 -> ~u_L*     u )
     0.00000000E+00    2     2000002        -2   # BR(~chi_40 -> ~u_R      ub)
     0.00000000E+00    2    -2000002         2   # BR(~chi_40 -> ~u_R*     u )
     0.00000000E+00    2     1000001        -1   # BR(~chi_40 -> ~d_L      db)
     0.00000000E+00    2    -1000001         1   # BR(~chi_40 -> ~d_L*     d )
     0.00000000E+00    2     2000001        -1   # BR(~chi_40 -> ~d_R      db)
     0.00000000E+00    2    -2000001         1   # BR(~chi_40 -> ~d_R*     d )
     0.00000000E+00    2     1000004        -4   # BR(~chi_40 -> ~c_L      cb)
     0.00000000E+00    2    -1000004         4   # BR(~chi_40 -> ~c_L*     c )
     0.00000000E+00    2     2000004        -4   # BR(~chi_40 -> ~c_R      cb)
     0.00000000E+00    2    -2000004         4   # BR(~chi_40 -> ~c_R*     c )
     0.00000000E+00    2     1000003        -3   # BR(~chi_40 -> ~s_L      sb)
     0.00000000E+00    2    -1000003         3   # BR(~chi_40 -> ~s_L*     s )
     0.00000000E+00    2     2000003        -3   # BR(~chi_40 -> ~s_R      sb)
     0.00000000E+00    2    -2000003         3   # BR(~chi_40 -> ~s_R*     s )
     0.00000000E+00    2     1000006        -6   # BR(~chi_40 -> ~t_1      tb)
     0.00000000E+00    2    -1000006         6   # BR(~chi_40 -> ~t_1*     t )
     0.00000000E+00    2     2000006        -6   # BR(~chi_40 -> ~t_2      tb)
     0.00000000E+00    2    -2000006         6   # BR(~chi_40 -> ~t_2*     t )
     0.00000000E+00    2     1000005        -5   # BR(~chi_40 -> ~b_1      bb)
     0.00000000E+00    2    -1000005         5   # BR(~chi_40 -> ~b_1*     b )
     0.00000000E+00    2     2000005        -5   # BR(~chi_40 -> ~b_2      bb)
     0.00000000E+00    2    -2000005         5   # BR(~chi_40 -> ~b_2*     b )
     0.00000000E+00    2     1000011       -11   # BR(~chi_40 -> ~e_L-     e+)
     0.00000000E+00    2    -1000011        11   # BR(~chi_40 -> ~e_L+     e-)
     0.00000000E+00    2     2000011       -11   # BR(~chi_40 -> ~e_R-     e+)
     0.00000000E+00    2    -2000011        11   # BR(~chi_40 -> ~e_R+     e-)
     0.00000000E+00    2     1000013       -13   # BR(~chi_40 -> ~mu_L-    mu+)
     0.00000000E+00    2    -1000013        13   # BR(~chi_40 -> ~mu_L+    mu-)
     0.00000000E+00    2     2000013       -13   # BR(~chi_40 -> ~mu_R-    mu+)
     0.00000000E+00    2    -2000013        13   # BR(~chi_40 -> ~mu_R+    mu-)
     0.00000000E+00    2     1000015       -15   # BR(~chi_40 -> ~tau_1-   tau+)
     0.00000000E+00    2    -1000015        15   # BR(~chi_40 -> ~tau_1+   tau-)
     0.00000000E+00    2     2000015       -15   # BR(~chi_40 -> ~tau_2-   tau+)
     0.00000000E+00    2    -2000015        15   # BR(~chi_40 -> ~tau_2+   tau-)
     0.00000000E+00    2     1000012       -12   # BR(~chi_40 -> ~nu_eL    nu_eb)
     0.00000000E+00    2    -1000012        12   # BR(~chi_40 -> ~nu_eL*   nu_e )
     0.00000000E+00    2     1000014       -14   # BR(~chi_40 -> ~nu_muL   nu_mub)
     0.00000000E+00    2    -1000014        14   # BR(~chi_40 -> ~nu_muL*  nu_mu )
     0.00000000E+00    2     1000016       -16   # BR(~chi_40 -> ~nu_tau1  nu_taub)
     0.00000000E+00    2    -1000016        16   # BR(~chi_40 -> ~nu_tau1* nu_tau )
