# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RepresentationContract(Model):
    """Operation request/response representation details.

    All required parameters must be populated in order to send to Azure.

    :param content_type: Required. Specifies a registered or custom content
     type for this representation, e.g. application/xml.
    :type content_type: str
    :param sample: An example of the representation.
    :type sample: str
    :param schema_id: Schema identifier. Applicable only if 'contentType'
     value is neither 'application/x-www-form-urlencoded' nor
     'multipart/form-data'.
    :type schema_id: str
    :param type_name: Type name defined by the schema. Applicable only if
     'contentType' value is neither 'application/x-www-form-urlencoded' nor
     'multipart/form-data'.
    :type type_name: str
    :param form_parameters: Collection of form parameters. Required if
     'contentType' value is either 'application/x-www-form-urlencoded' or
     'multipart/form-data'..
    :type form_parameters:
     list[~azure.mgmt.apimanagement.models.ParameterContract]
    """

    _validation = {
        'content_type': {'required': True},
    }

    _attribute_map = {
        'content_type': {'key': 'contentType', 'type': 'str'},
        'sample': {'key': 'sample', 'type': 'str'},
        'schema_id': {'key': 'schemaId', 'type': 'str'},
        'type_name': {'key': 'typeName', 'type': 'str'},
        'form_parameters': {'key': 'formParameters', 'type': '[ParameterContract]'},
    }

    def __init__(self, *, content_type: str, sample: str=None, schema_id: str=None, type_name: str=None, form_parameters=None, **kwargs) -> None:
        super(RepresentationContract, self).__init__(**kwargs)
        self.content_type = content_type
        self.sample = sample
        self.schema_id = schema_id
        self.type_name = type_name
        self.form_parameters = form_parameters
