# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RefreshDetails(Model):
    """Fields for tracking refresh job on the share.

    :param in_progress_refresh_job_id: If a refresh share job is currently in
     progress on this share, this field indicates the ARM resource ID of that
     job. The field is empty if no job is in progress.
    :type in_progress_refresh_job_id: str
    :param last_completed_refresh_job_time_in_utc: Indicates the completed
     time for the last refresh job on this particular share, if any.This could
     be a failed job or a successful job.
    :type last_completed_refresh_job_time_in_utc: datetime
    :param error_manifest_file: Indicates the relative path of the error xml
     for the last refresh job on this particular share, if any. This could be a
     failed job or a successful job.
    :type error_manifest_file: str
    :param last_job: Indicates the id of the last refresh job on this
     particular share,if any. This could be a failed job or a successful job.
    :type last_job: str
    """

    _attribute_map = {
        'in_progress_refresh_job_id': {'key': 'inProgressRefreshJobId', 'type': 'str'},
        'last_completed_refresh_job_time_in_utc': {'key': 'lastCompletedRefreshJobTimeInUTC', 'type': 'iso-8601'},
        'error_manifest_file': {'key': 'errorManifestFile', 'type': 'str'},
        'last_job': {'key': 'lastJob', 'type': 'str'},
    }

    def __init__(self, *, in_progress_refresh_job_id: str=None, last_completed_refresh_job_time_in_utc=None, error_manifest_file: str=None, last_job: str=None, **kwargs) -> None:
        super(RefreshDetails, self).__init__(**kwargs)
        self.in_progress_refresh_job_id = in_progress_refresh_job_id
        self.last_completed_refresh_job_time_in_utc = last_completed_refresh_job_time_in_utc
        self.error_manifest_file = error_manifest_file
        self.last_job = last_job
