# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from collections.abc import MutableMapping
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .._utils import serialization as _serialization

if TYPE_CHECKING:
    from .. import models as _models
JSON = MutableMapping[str, Any]


class AliasPathType(_serialization.Model):
    """The type of the paths for alias.

    :ivar path: The path of an alias.
    :vartype path: str
    :ivar api_versions: The API versions.
    :vartype api_versions: list[str]
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "api_versions": {"key": "apiVersions", "type": "[str]"},
    }

    def __init__(self, *, path: Optional[str] = None, api_versions: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword path: The path of an alias.
        :paramtype path: str
        :keyword api_versions: The API versions.
        :paramtype api_versions: list[str]
        """
        super().__init__(**kwargs)
        self.path = path
        self.api_versions = api_versions


class AliasType(_serialization.Model):
    """The alias type.

    :ivar name: The alias name.
    :vartype name: str
    :ivar paths: The paths for an alias.
    :vartype paths: list[~azure.mgmt.resource.resources.v2019_03_01.models.AliasPathType]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "paths": {"key": "paths", "type": "[AliasPathType]"},
    }

    def __init__(
        self, *, name: Optional[str] = None, paths: Optional[List["_models.AliasPathType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: The alias name.
        :paramtype name: str
        :keyword paths: The paths for an alias.
        :paramtype paths: list[~azure.mgmt.resource.resources.v2019_03_01.models.AliasPathType]
        """
        super().__init__(**kwargs)
        self.name = name
        self.paths = paths


class BasicDependency(_serialization.Model):
    """Deployment dependency information.

    :ivar id: The ID of the dependency.
    :vartype id: str
    :ivar resource_type: The dependency resource type.
    :vartype resource_type: str
    :ivar resource_name: The dependency resource name.
    :vartype resource_name: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "resource_name": {"key": "resourceName", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        resource_type: Optional[str] = None,
        resource_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the dependency.
        :paramtype id: str
        :keyword resource_type: The dependency resource type.
        :paramtype resource_type: str
        :keyword resource_name: The dependency resource name.
        :paramtype resource_name: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.resource_type = resource_type
        self.resource_name = resource_name


class ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties(
    _serialization.Model
):  # pylint: disable=name-too-long
    """ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.client_id: Optional[str] = None


class DebugSetting(_serialization.Model):
    """DebugSetting.

    :ivar detail_level: Specifies the type of information to log for debugging. The permitted
     values are none, requestContent, responseContent, or both requestContent and responseContent
     separated by a comma. The default is none. When setting this value, carefully consider the type
     of information you are passing in during deployment. By logging information about the request
     or response, you could potentially expose sensitive data that is retrieved through the
     deployment operations.
    :vartype detail_level: str
    """

    _attribute_map = {
        "detail_level": {"key": "detailLevel", "type": "str"},
    }

    def __init__(self, *, detail_level: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword detail_level: Specifies the type of information to log for debugging. The permitted
         values are none, requestContent, responseContent, or both requestContent and responseContent
         separated by a comma. The default is none. When setting this value, carefully consider the type
         of information you are passing in during deployment. By logging information about the request
         or response, you could potentially expose sensitive data that is retrieved through the
         deployment operations.
        :paramtype detail_level: str
        """
        super().__init__(**kwargs)
        self.detail_level = detail_level


class Dependency(_serialization.Model):
    """Deployment dependency information.

    :ivar depends_on: The list of dependencies.
    :vartype depends_on: list[~azure.mgmt.resource.resources.v2019_03_01.models.BasicDependency]
    :ivar id: The ID of the dependency.
    :vartype id: str
    :ivar resource_type: The dependency resource type.
    :vartype resource_type: str
    :ivar resource_name: The dependency resource name.
    :vartype resource_name: str
    """

    _attribute_map = {
        "depends_on": {"key": "dependsOn", "type": "[BasicDependency]"},
        "id": {"key": "id", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "resource_name": {"key": "resourceName", "type": "str"},
    }

    def __init__(
        self,
        *,
        depends_on: Optional[List["_models.BasicDependency"]] = None,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        resource_type: Optional[str] = None,
        resource_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword depends_on: The list of dependencies.
        :paramtype depends_on: list[~azure.mgmt.resource.resources.v2019_03_01.models.BasicDependency]
        :keyword id: The ID of the dependency.
        :paramtype id: str
        :keyword resource_type: The dependency resource type.
        :paramtype resource_type: str
        :keyword resource_name: The dependency resource name.
        :paramtype resource_name: str
        """
        super().__init__(**kwargs)
        self.depends_on = depends_on
        self.id = id
        self.resource_type = resource_type
        self.resource_name = resource_name


class Deployment(_serialization.Model):
    """Deployment operation parameters.

    All required parameters must be populated in order to send to server.

    :ivar location: The location to store the deployment data.
    :vartype location: str
    :ivar properties: The deployment properties. Required.
    :vartype properties: ~azure.mgmt.resource.resources.v2019_03_01.models.DeploymentProperties
    """

    _validation = {
        "properties": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "DeploymentProperties"},
    }

    def __init__(
        self, *, properties: "_models.DeploymentProperties", location: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword location: The location to store the deployment data.
        :paramtype location: str
        :keyword properties: The deployment properties. Required.
        :paramtype properties: ~azure.mgmt.resource.resources.v2019_03_01.models.DeploymentProperties
        """
        super().__init__(**kwargs)
        self.location = location
        self.properties = properties


class DeploymentExportResult(_serialization.Model):
    """The deployment export result.

    :ivar template: The template content.
    :vartype template: JSON
    """

    _attribute_map = {
        "template": {"key": "template", "type": "object"},
    }

    def __init__(self, *, template: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword template: The template content.
        :paramtype template: JSON
        """
        super().__init__(**kwargs)
        self.template = template


class DeploymentExtended(_serialization.Model):
    """Deployment information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The ID of the deployment.
    :vartype id: str
    :ivar name: The name of the deployment.
    :vartype name: str
    :ivar type: The type of the deployment.
    :vartype type: str
    :ivar location: the location of the deployment.
    :vartype location: str
    :ivar properties: Deployment properties.
    :vartype properties:
     ~azure.mgmt.resource.resources.v2019_03_01.models.DeploymentPropertiesExtended
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "properties": {"key": "properties", "type": "DeploymentPropertiesExtended"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        properties: Optional["_models.DeploymentPropertiesExtended"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: the location of the deployment.
        :paramtype location: str
        :keyword properties: Deployment properties.
        :paramtype properties:
         ~azure.mgmt.resource.resources.v2019_03_01.models.DeploymentPropertiesExtended
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.properties = properties


class DeploymentExtendedFilter(_serialization.Model):
    """Deployment filter.

    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, *, provisioning_state: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword provisioning_state: The provisioning state.
        :paramtype provisioning_state: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state


class DeploymentListResult(_serialization.Model):
    """List of deployments.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of deployments.
    :vartype value: list[~azure.mgmt.resource.resources.v2019_03_01.models.DeploymentExtended]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeploymentExtended]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.DeploymentExtended"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of deployments.
        :paramtype value: list[~azure.mgmt.resource.resources.v2019_03_01.models.DeploymentExtended]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DeploymentOperation(_serialization.Model):
    """Deployment operation information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Full deployment operation ID.
    :vartype id: str
    :ivar operation_id: Deployment operation ID.
    :vartype operation_id: str
    :ivar properties: Deployment properties.
    :vartype properties:
     ~azure.mgmt.resource.resources.v2019_03_01.models.DeploymentOperationProperties
    """

    _validation = {
        "id": {"readonly": True},
        "operation_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "operation_id": {"key": "operationId", "type": "str"},
        "properties": {"key": "properties", "type": "DeploymentOperationProperties"},
    }

    def __init__(self, *, properties: Optional["_models.DeploymentOperationProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Deployment properties.
        :paramtype properties:
         ~azure.mgmt.resource.resources.v2019_03_01.models.DeploymentOperationProperties
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.operation_id: Optional[str] = None
        self.properties = properties


class DeploymentOperationProperties(_serialization.Model):
    """Deployment operation properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The state of the provisioning.
    :vartype provisioning_state: str
    :ivar timestamp: The date and time of the operation.
    :vartype timestamp: ~datetime.datetime
    :ivar service_request_id: Deployment operation service request id.
    :vartype service_request_id: str
    :ivar status_code: Operation status code.
    :vartype status_code: str
    :ivar status_message: Operation status message.
    :vartype status_message: JSON
    :ivar target_resource: The target resource.
    :vartype target_resource: ~azure.mgmt.resource.resources.v2019_03_01.models.TargetResource
    :ivar request: The HTTP request message.
    :vartype request: ~azure.mgmt.resource.resources.v2019_03_01.models.HttpMessage
    :ivar response: The HTTP response message.
    :vartype response: ~azure.mgmt.resource.resources.v2019_03_01.models.HttpMessage
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "timestamp": {"readonly": True},
        "service_request_id": {"readonly": True},
        "status_code": {"readonly": True},
        "status_message": {"readonly": True},
        "target_resource": {"readonly": True},
        "request": {"readonly": True},
        "response": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "service_request_id": {"key": "serviceRequestId", "type": "str"},
        "status_code": {"key": "statusCode", "type": "str"},
        "status_message": {"key": "statusMessage", "type": "object"},
        "target_resource": {"key": "targetResource", "type": "TargetResource"},
        "request": {"key": "request", "type": "HttpMessage"},
        "response": {"key": "response", "type": "HttpMessage"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[str] = None
        self.timestamp: Optional[datetime.datetime] = None
        self.service_request_id: Optional[str] = None
        self.status_code: Optional[str] = None
        self.status_message: Optional[JSON] = None
        self.target_resource: Optional["_models.TargetResource"] = None
        self.request: Optional["_models.HttpMessage"] = None
        self.response: Optional["_models.HttpMessage"] = None


class DeploymentOperationsListResult(_serialization.Model):
    """List of deployment operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of deployment operations.
    :vartype value: list[~azure.mgmt.resource.resources.v2019_03_01.models.DeploymentOperation]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DeploymentOperation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.DeploymentOperation"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of deployment operations.
        :paramtype value: list[~azure.mgmt.resource.resources.v2019_03_01.models.DeploymentOperation]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class DeploymentProperties(_serialization.Model):
    """Deployment properties.

    All required parameters must be populated in order to send to server.

    :ivar template: The template content. You use this element when you want to pass the template
     syntax directly in the request rather than link to an existing template. It can be a JObject or
     well-formed JSON string. Use either the templateLink property or the template property, but not
     both.
    :vartype template: JSON
    :ivar template_link: The URI of the template. Use either the templateLink property or the
     template property, but not both.
    :vartype template_link: ~azure.mgmt.resource.resources.v2019_03_01.models.TemplateLink
    :ivar parameters: Name and value pairs that define the deployment parameters for the template.
     You use this element when you want to provide the parameter values directly in the request
     rather than link to an existing parameter file. Use either the parametersLink property or the
     parameters property, but not both. It can be a JObject or a well formed JSON string.
    :vartype parameters: JSON
    :ivar parameters_link: The URI of parameters file. You use this element to link to an existing
     parameters file. Use either the parametersLink property or the parameters property, but not
     both.
    :vartype parameters_link: ~azure.mgmt.resource.resources.v2019_03_01.models.ParametersLink
    :ivar mode: The mode that is used to deploy resources. This value can be either Incremental or
     Complete. In Incremental mode, resources are deployed without deleting existing resources that
     are not included in the template. In Complete mode, resources are deployed and existing
     resources in the resource group that are not included in the template are deleted. Be careful
     when using Complete mode as you may unintentionally delete resources. Required. Known values
     are: "Incremental" and "Complete".
    :vartype mode: str or ~azure.mgmt.resource.resources.v2019_03_01.models.DeploymentMode
    :ivar debug_setting: The debug setting of the deployment.
    :vartype debug_setting: ~azure.mgmt.resource.resources.v2019_03_01.models.DebugSetting
    :ivar on_error_deployment: The deployment on error behavior.
    :vartype on_error_deployment:
     ~azure.mgmt.resource.resources.v2019_03_01.models.OnErrorDeployment
    """

    _validation = {
        "mode": {"required": True},
    }

    _attribute_map = {
        "template": {"key": "template", "type": "object"},
        "template_link": {"key": "templateLink", "type": "TemplateLink"},
        "parameters": {"key": "parameters", "type": "object"},
        "parameters_link": {"key": "parametersLink", "type": "ParametersLink"},
        "mode": {"key": "mode", "type": "str"},
        "debug_setting": {"key": "debugSetting", "type": "DebugSetting"},
        "on_error_deployment": {"key": "onErrorDeployment", "type": "OnErrorDeployment"},
    }

    def __init__(
        self,
        *,
        mode: Union[str, "_models.DeploymentMode"],
        template: Optional[JSON] = None,
        template_link: Optional["_models.TemplateLink"] = None,
        parameters: Optional[JSON] = None,
        parameters_link: Optional["_models.ParametersLink"] = None,
        debug_setting: Optional["_models.DebugSetting"] = None,
        on_error_deployment: Optional["_models.OnErrorDeployment"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword template: The template content. You use this element when you want to pass the
         template syntax directly in the request rather than link to an existing template. It can be a
         JObject or well-formed JSON string. Use either the templateLink property or the template
         property, but not both.
        :paramtype template: JSON
        :keyword template_link: The URI of the template. Use either the templateLink property or the
         template property, but not both.
        :paramtype template_link: ~azure.mgmt.resource.resources.v2019_03_01.models.TemplateLink
        :keyword parameters: Name and value pairs that define the deployment parameters for the
         template. You use this element when you want to provide the parameter values directly in the
         request rather than link to an existing parameter file. Use either the parametersLink property
         or the parameters property, but not both. It can be a JObject or a well formed JSON string.
        :paramtype parameters: JSON
        :keyword parameters_link: The URI of parameters file. You use this element to link to an
         existing parameters file. Use either the parametersLink property or the parameters property,
         but not both.
        :paramtype parameters_link: ~azure.mgmt.resource.resources.v2019_03_01.models.ParametersLink
        :keyword mode: The mode that is used to deploy resources. This value can be either Incremental
         or Complete. In Incremental mode, resources are deployed without deleting existing resources
         that are not included in the template. In Complete mode, resources are deployed and existing
         resources in the resource group that are not included in the template are deleted. Be careful
         when using Complete mode as you may unintentionally delete resources. Required. Known values
         are: "Incremental" and "Complete".
        :paramtype mode: str or ~azure.mgmt.resource.resources.v2019_03_01.models.DeploymentMode
        :keyword debug_setting: The debug setting of the deployment.
        :paramtype debug_setting: ~azure.mgmt.resource.resources.v2019_03_01.models.DebugSetting
        :keyword on_error_deployment: The deployment on error behavior.
        :paramtype on_error_deployment:
         ~azure.mgmt.resource.resources.v2019_03_01.models.OnErrorDeployment
        """
        super().__init__(**kwargs)
        self.template = template
        self.template_link = template_link
        self.parameters = parameters
        self.parameters_link = parameters_link
        self.mode = mode
        self.debug_setting = debug_setting
        self.on_error_deployment = on_error_deployment


class DeploymentPropertiesExtended(_serialization.Model):
    """Deployment properties with additional details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The state of the provisioning.
    :vartype provisioning_state: str
    :ivar correlation_id: The correlation ID of the deployment.
    :vartype correlation_id: str
    :ivar timestamp: The timestamp of the template deployment.
    :vartype timestamp: ~datetime.datetime
    :ivar outputs: Key/value pairs that represent deployment output.
    :vartype outputs: JSON
    :ivar providers: The list of resource providers needed for the deployment.
    :vartype providers: list[~azure.mgmt.resource.resources.v2019_03_01.models.Provider]
    :ivar dependencies: The list of deployment dependencies.
    :vartype dependencies: list[~azure.mgmt.resource.resources.v2019_03_01.models.Dependency]
    :ivar template: The template content. Use only one of Template or TemplateLink.
    :vartype template: JSON
    :ivar template_link: The URI referencing the template. Use only one of Template or
     TemplateLink.
    :vartype template_link: ~azure.mgmt.resource.resources.v2019_03_01.models.TemplateLink
    :ivar parameters: Deployment parameters. Use only one of Parameters or ParametersLink.
    :vartype parameters: JSON
    :ivar parameters_link: The URI referencing the parameters. Use only one of Parameters or
     ParametersLink.
    :vartype parameters_link: ~azure.mgmt.resource.resources.v2019_03_01.models.ParametersLink
    :ivar mode: The deployment mode. Possible values are Incremental and Complete. Known values
     are: "Incremental" and "Complete".
    :vartype mode: str or ~azure.mgmt.resource.resources.v2019_03_01.models.DeploymentMode
    :ivar debug_setting: The debug setting of the deployment.
    :vartype debug_setting: ~azure.mgmt.resource.resources.v2019_03_01.models.DebugSetting
    :ivar on_error_deployment: The deployment on error behavior.
    :vartype on_error_deployment:
     ~azure.mgmt.resource.resources.v2019_03_01.models.OnErrorDeploymentExtended
    :ivar error: The deployment error.
    :vartype error: ~azure.mgmt.resource.resources.v2019_03_01.models.ErrorResponse
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "correlation_id": {"readonly": True},
        "timestamp": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "correlation_id": {"key": "correlationId", "type": "str"},
        "timestamp": {"key": "timestamp", "type": "iso-8601"},
        "outputs": {"key": "outputs", "type": "object"},
        "providers": {"key": "providers", "type": "[Provider]"},
        "dependencies": {"key": "dependencies", "type": "[Dependency]"},
        "template": {"key": "template", "type": "object"},
        "template_link": {"key": "templateLink", "type": "TemplateLink"},
        "parameters": {"key": "parameters", "type": "object"},
        "parameters_link": {"key": "parametersLink", "type": "ParametersLink"},
        "mode": {"key": "mode", "type": "str"},
        "debug_setting": {"key": "debugSetting", "type": "DebugSetting"},
        "on_error_deployment": {"key": "onErrorDeployment", "type": "OnErrorDeploymentExtended"},
        "error": {"key": "error", "type": "ErrorResponse"},
    }

    def __init__(
        self,
        *,
        outputs: Optional[JSON] = None,
        providers: Optional[List["_models.Provider"]] = None,
        dependencies: Optional[List["_models.Dependency"]] = None,
        template: Optional[JSON] = None,
        template_link: Optional["_models.TemplateLink"] = None,
        parameters: Optional[JSON] = None,
        parameters_link: Optional["_models.ParametersLink"] = None,
        mode: Optional[Union[str, "_models.DeploymentMode"]] = None,
        debug_setting: Optional["_models.DebugSetting"] = None,
        on_error_deployment: Optional["_models.OnErrorDeploymentExtended"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword outputs: Key/value pairs that represent deployment output.
        :paramtype outputs: JSON
        :keyword providers: The list of resource providers needed for the deployment.
        :paramtype providers: list[~azure.mgmt.resource.resources.v2019_03_01.models.Provider]
        :keyword dependencies: The list of deployment dependencies.
        :paramtype dependencies: list[~azure.mgmt.resource.resources.v2019_03_01.models.Dependency]
        :keyword template: The template content. Use only one of Template or TemplateLink.
        :paramtype template: JSON
        :keyword template_link: The URI referencing the template. Use only one of Template or
         TemplateLink.
        :paramtype template_link: ~azure.mgmt.resource.resources.v2019_03_01.models.TemplateLink
        :keyword parameters: Deployment parameters. Use only one of Parameters or ParametersLink.
        :paramtype parameters: JSON
        :keyword parameters_link: The URI referencing the parameters. Use only one of Parameters or
         ParametersLink.
        :paramtype parameters_link: ~azure.mgmt.resource.resources.v2019_03_01.models.ParametersLink
        :keyword mode: The deployment mode. Possible values are Incremental and Complete. Known values
         are: "Incremental" and "Complete".
        :paramtype mode: str or ~azure.mgmt.resource.resources.v2019_03_01.models.DeploymentMode
        :keyword debug_setting: The debug setting of the deployment.
        :paramtype debug_setting: ~azure.mgmt.resource.resources.v2019_03_01.models.DebugSetting
        :keyword on_error_deployment: The deployment on error behavior.
        :paramtype on_error_deployment:
         ~azure.mgmt.resource.resources.v2019_03_01.models.OnErrorDeploymentExtended
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[str] = None
        self.correlation_id: Optional[str] = None
        self.timestamp: Optional[datetime.datetime] = None
        self.outputs = outputs
        self.providers = providers
        self.dependencies = dependencies
        self.template = template
        self.template_link = template_link
        self.parameters = parameters
        self.parameters_link = parameters_link
        self.mode = mode
        self.debug_setting = debug_setting
        self.on_error_deployment = on_error_deployment
        self.error: Optional["_models.ErrorResponse"] = None


class DeploymentValidateResult(_serialization.Model):
    """Information from validate template deployment response.

    :ivar error: Validation error.
    :vartype error:
     ~azure.mgmt.resource.resources.v2019_03_01.models.ResourceManagementErrorWithDetails
    :ivar properties: The template deployment properties.
    :vartype properties:
     ~azure.mgmt.resource.resources.v2019_03_01.models.DeploymentPropertiesExtended
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ResourceManagementErrorWithDetails"},
        "properties": {"key": "properties", "type": "DeploymentPropertiesExtended"},
    }

    def __init__(
        self,
        *,
        error: Optional["_models.ResourceManagementErrorWithDetails"] = None,
        properties: Optional["_models.DeploymentPropertiesExtended"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error: Validation error.
        :paramtype error:
         ~azure.mgmt.resource.resources.v2019_03_01.models.ResourceManagementErrorWithDetails
        :keyword properties: The template deployment properties.
        :paramtype properties:
         ~azure.mgmt.resource.resources.v2019_03_01.models.DeploymentPropertiesExtended
        """
        super().__init__(**kwargs)
        self.error = error
        self.properties = properties


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type: Optional[str] = None
        self.info: Optional[JSON] = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.resource.resources.v2019_03_01.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.resource.resources.v2019_03_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorResponse]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ErrorResponse"]] = None
        self.additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = None


class ExportTemplateRequest(_serialization.Model):
    """Export resource group template request parameters.

    :ivar resources: The IDs of the resources to filter the export by. To export all resources,
     supply an array with single entry '*'.
    :vartype resources: list[str]
    :ivar options: The export template options. A CSV-formatted list containing zero or more of the
     following: 'IncludeParameterDefaultValue', 'IncludeComments',
     'SkipResourceNameParameterization', 'SkipAllParameterization'.
    :vartype options: str
    """

    _attribute_map = {
        "resources": {"key": "resources", "type": "[str]"},
        "options": {"key": "options", "type": "str"},
    }

    def __init__(self, *, resources: Optional[List[str]] = None, options: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resources: The IDs of the resources to filter the export by. To export all resources,
         supply an array with single entry '*'.
        :paramtype resources: list[str]
        :keyword options: The export template options. A CSV-formatted list containing zero or more of
         the following: 'IncludeParameterDefaultValue', 'IncludeComments',
         'SkipResourceNameParameterization', 'SkipAllParameterization'.
        :paramtype options: str
        """
        super().__init__(**kwargs)
        self.resources = resources
        self.options = options


class Resource(_serialization.Model):
    """Specified resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.location = location
        self.tags = tags


class GenericResource(Resource):
    """Resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar plan: The plan of the resource.
    :vartype plan: ~azure.mgmt.resource.resources.v2019_03_01.models.Plan
    :ivar properties: The resource properties.
    :vartype properties: JSON
    :ivar kind: The kind of the resource.
    :vartype kind: str
    :ivar managed_by: ID of the resource that manages this resource.
    :vartype managed_by: str
    :ivar sku: The SKU of the resource.
    :vartype sku: ~azure.mgmt.resource.resources.v2019_03_01.models.Sku
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.resource.resources.v2019_03_01.models.Identity
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"pattern": r"^[-\w\._,\(\)]+$"},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "plan": {"key": "plan", "type": "Plan"},
        "properties": {"key": "properties", "type": "object"},
        "kind": {"key": "kind", "type": "str"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "Identity"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.Plan"] = None,
        properties: Optional[JSON] = None,
        kind: Optional[str] = None,
        managed_by: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.Identity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword plan: The plan of the resource.
        :paramtype plan: ~azure.mgmt.resource.resources.v2019_03_01.models.Plan
        :keyword properties: The resource properties.
        :paramtype properties: JSON
        :keyword kind: The kind of the resource.
        :paramtype kind: str
        :keyword managed_by: ID of the resource that manages this resource.
        :paramtype managed_by: str
        :keyword sku: The SKU of the resource.
        :paramtype sku: ~azure.mgmt.resource.resources.v2019_03_01.models.Sku
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.resource.resources.v2019_03_01.models.Identity
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.plan = plan
        self.properties = properties
        self.kind = kind
        self.managed_by = managed_by
        self.sku = sku
        self.identity = identity


class GenericResourceExpanded(GenericResource):
    """Resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar plan: The plan of the resource.
    :vartype plan: ~azure.mgmt.resource.resources.v2019_03_01.models.Plan
    :ivar properties: The resource properties.
    :vartype properties: JSON
    :ivar kind: The kind of the resource.
    :vartype kind: str
    :ivar managed_by: ID of the resource that manages this resource.
    :vartype managed_by: str
    :ivar sku: The SKU of the resource.
    :vartype sku: ~azure.mgmt.resource.resources.v2019_03_01.models.Sku
    :ivar identity: The identity of the resource.
    :vartype identity: ~azure.mgmt.resource.resources.v2019_03_01.models.Identity
    :ivar created_time: The created time of the resource. This is only present if requested via the
     $expand query parameter.
    :vartype created_time: ~datetime.datetime
    :ivar changed_time: The changed time of the resource. This is only present if requested via the
     $expand query parameter.
    :vartype changed_time: ~datetime.datetime
    :ivar provisioning_state: The provisioning state of the resource. This is only present if
     requested via the $expand query parameter.
    :vartype provisioning_state: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kind": {"pattern": r"^[-\w\._,\(\)]+$"},
        "created_time": {"readonly": True},
        "changed_time": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "plan": {"key": "plan", "type": "Plan"},
        "properties": {"key": "properties", "type": "object"},
        "kind": {"key": "kind", "type": "str"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "Identity"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "changed_time": {"key": "changedTime", "type": "iso-8601"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["_models.Plan"] = None,
        properties: Optional[JSON] = None,
        kind: Optional[str] = None,
        managed_by: Optional[str] = None,
        sku: Optional["_models.Sku"] = None,
        identity: Optional["_models.Identity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword plan: The plan of the resource.
        :paramtype plan: ~azure.mgmt.resource.resources.v2019_03_01.models.Plan
        :keyword properties: The resource properties.
        :paramtype properties: JSON
        :keyword kind: The kind of the resource.
        :paramtype kind: str
        :keyword managed_by: ID of the resource that manages this resource.
        :paramtype managed_by: str
        :keyword sku: The SKU of the resource.
        :paramtype sku: ~azure.mgmt.resource.resources.v2019_03_01.models.Sku
        :keyword identity: The identity of the resource.
        :paramtype identity: ~azure.mgmt.resource.resources.v2019_03_01.models.Identity
        """
        super().__init__(
            location=location,
            tags=tags,
            plan=plan,
            properties=properties,
            kind=kind,
            managed_by=managed_by,
            sku=sku,
            identity=identity,
            **kwargs
        )
        self.created_time: Optional[datetime.datetime] = None
        self.changed_time: Optional[datetime.datetime] = None
        self.provisioning_state: Optional[str] = None


class GenericResourceFilter(_serialization.Model):
    """Resource filter.

    :ivar resource_type: The resource type.
    :vartype resource_type: str
    :ivar tagname: The tag name.
    :vartype tagname: str
    :ivar tagvalue: The tag value.
    :vartype tagvalue: str
    """

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "tagname": {"key": "tagname", "type": "str"},
        "tagvalue": {"key": "tagvalue", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        tagname: Optional[str] = None,
        tagvalue: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_type: The resource type.
        :paramtype resource_type: str
        :keyword tagname: The tag name.
        :paramtype tagname: str
        :keyword tagvalue: The tag value.
        :paramtype tagvalue: str
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.tagname = tagname
        self.tagvalue = tagvalue


class HttpMessage(_serialization.Model):
    """HTTP message.

    :ivar content: HTTP message content.
    :vartype content: JSON
    """

    _attribute_map = {
        "content": {"key": "content", "type": "object"},
    }

    def __init__(self, *, content: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword content: HTTP message content.
        :paramtype content: JSON
        """
        super().__init__(**kwargs)
        self.content = content


class Identity(_serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :ivar type: The identity type. Known values are: "SystemAssigned", "UserAssigned",
     "SystemAssigned, UserAssigned", and "None".
    :vartype type: str or ~azure.mgmt.resource.resources.v2019_03_01.models.ResourceIdentityType
    :ivar user_assigned_identities: The list of user identities associated with the resource. The
     user identity dictionary key references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.resource.resources.v2019_03_01.models.ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {
            "key": "userAssignedIdentities",
            "type": "{ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties}",
        },
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceIdentityType"]] = None,
        user_assigned_identities: Optional[
            Dict[str, "_models.ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties"]
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The identity type. Known values are: "SystemAssigned", "UserAssigned",
         "SystemAssigned, UserAssigned", and "None".
        :paramtype type: str or ~azure.mgmt.resource.resources.v2019_03_01.models.ResourceIdentityType
        :keyword user_assigned_identities: The list of user identities associated with the resource.
         The user identity dictionary key references will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.resource.resources.v2019_03_01.models.ComponentsSgqdofSchemasIdentityPropertiesUserassignedidentitiesAdditionalproperties]
        """
        super().__init__(**kwargs)
        self.principal_id: Optional[str] = None
        self.tenant_id: Optional[str] = None
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class OnErrorDeployment(_serialization.Model):
    """Deployment on error behavior.

    :ivar type: The deployment on error behavior type. Possible values are LastSuccessful and
     SpecificDeployment. Known values are: "LastSuccessful" and "SpecificDeployment".
    :vartype type: str or ~azure.mgmt.resource.resources.v2019_03_01.models.OnErrorDeploymentType
    :ivar deployment_name: The deployment to be used on error case.
    :vartype deployment_name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "deployment_name": {"key": "deploymentName", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.OnErrorDeploymentType"]] = None,
        deployment_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The deployment on error behavior type. Possible values are LastSuccessful and
         SpecificDeployment. Known values are: "LastSuccessful" and "SpecificDeployment".
        :paramtype type: str or ~azure.mgmt.resource.resources.v2019_03_01.models.OnErrorDeploymentType
        :keyword deployment_name: The deployment to be used on error case.
        :paramtype deployment_name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.deployment_name = deployment_name


class OnErrorDeploymentExtended(_serialization.Model):
    """Deployment on error behavior with additional details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The state of the provisioning for the on error deployment.
    :vartype provisioning_state: str
    :ivar type: The deployment on error behavior type. Possible values are LastSuccessful and
     SpecificDeployment. Known values are: "LastSuccessful" and "SpecificDeployment".
    :vartype type: str or ~azure.mgmt.resource.resources.v2019_03_01.models.OnErrorDeploymentType
    :ivar deployment_name: The deployment to be used on error case.
    :vartype deployment_name: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "deployment_name": {"key": "deploymentName", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.OnErrorDeploymentType"]] = None,
        deployment_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The deployment on error behavior type. Possible values are LastSuccessful and
         SpecificDeployment. Known values are: "LastSuccessful" and "SpecificDeployment".
        :paramtype type: str or ~azure.mgmt.resource.resources.v2019_03_01.models.OnErrorDeploymentType
        :keyword deployment_name: The deployment to be used on error case.
        :paramtype deployment_name: str
        """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[str] = None
        self.type = type
        self.deployment_name = deployment_name


class Operation(_serialization.Model):
    """Microsoft.Resources operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.resource.resources.v2019_03_01.models.OperationDisplay
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(
        self, *, name: Optional[str] = None, display: Optional["_models.OperationDisplay"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.resource.resources.v2019_03_01.models.OperationDisplay
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.Resources.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Profile, endpoint, etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft.Resources.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: Profile, endpoint, etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationListResult(_serialization.Model):
    """Result of the request to list Microsoft.Resources operations. It contains a list of operations
    and a URL link to get the next set of results.

    :ivar value: List of Microsoft.Resources operations.
    :vartype value: list[~azure.mgmt.resource.resources.v2019_03_01.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Operation"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of Microsoft.Resources operations.
        :paramtype value: list[~azure.mgmt.resource.resources.v2019_03_01.models.Operation]
        :keyword next_link: URL to get the next set of operation list results if there are any.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ParametersLink(_serialization.Model):
    """Entity representing the reference to the deployment parameters.

    All required parameters must be populated in order to send to server.

    :ivar uri: The URI of the parameters file. Required.
    :vartype uri: str
    :ivar content_version: If included, must match the ContentVersion in the template.
    :vartype content_version: str
    """

    _validation = {
        "uri": {"required": True},
    }

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
        "content_version": {"key": "contentVersion", "type": "str"},
    }

    def __init__(self, *, uri: str, content_version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword uri: The URI of the parameters file. Required.
        :paramtype uri: str
        :keyword content_version: If included, must match the ContentVersion in the template.
        :paramtype content_version: str
        """
        super().__init__(**kwargs)
        self.uri = uri
        self.content_version = content_version


class Plan(_serialization.Model):
    """Plan for the resource.

    :ivar name: The plan ID.
    :vartype name: str
    :ivar publisher: The publisher ID.
    :vartype publisher: str
    :ivar product: The offer ID.
    :vartype product: str
    :ivar promotion_code: The promotion code.
    :vartype promotion_code: str
    :ivar version: The plan's version.
    :vartype version: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "publisher": {"key": "publisher", "type": "str"},
        "product": {"key": "product", "type": "str"},
        "promotion_code": {"key": "promotionCode", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The plan ID.
        :paramtype name: str
        :keyword publisher: The publisher ID.
        :paramtype publisher: str
        :keyword product: The offer ID.
        :paramtype product: str
        :keyword promotion_code: The promotion code.
        :paramtype promotion_code: str
        :keyword version: The plan's version.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code
        self.version = version


class Provider(_serialization.Model):
    """Resource provider information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The provider ID.
    :vartype id: str
    :ivar namespace: The namespace of the resource provider.
    :vartype namespace: str
    :ivar registration_state: The registration state of the resource provider.
    :vartype registration_state: str
    :ivar registration_policy: The registration policy of the resource provider.
    :vartype registration_policy: str
    :ivar resource_types: The collection of provider resource types.
    :vartype resource_types:
     list[~azure.mgmt.resource.resources.v2019_03_01.models.ProviderResourceType]
    """

    _validation = {
        "id": {"readonly": True},
        "registration_state": {"readonly": True},
        "registration_policy": {"readonly": True},
        "resource_types": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "namespace": {"key": "namespace", "type": "str"},
        "registration_state": {"key": "registrationState", "type": "str"},
        "registration_policy": {"key": "registrationPolicy", "type": "str"},
        "resource_types": {"key": "resourceTypes", "type": "[ProviderResourceType]"},
    }

    def __init__(self, *, namespace: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword namespace: The namespace of the resource provider.
        :paramtype namespace: str
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.namespace = namespace
        self.registration_state: Optional[str] = None
        self.registration_policy: Optional[str] = None
        self.resource_types: Optional[List["_models.ProviderResourceType"]] = None


class ProviderListResult(_serialization.Model):
    """List of resource providers.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of resource providers.
    :vartype value: list[~azure.mgmt.resource.resources.v2019_03_01.models.Provider]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Provider]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Provider"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of resource providers.
        :paramtype value: list[~azure.mgmt.resource.resources.v2019_03_01.models.Provider]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ProviderResourceType(_serialization.Model):
    """Resource type managed by the resource provider.

    :ivar resource_type: The resource type.
    :vartype resource_type: str
    :ivar locations: The collection of locations where this resource type can be created.
    :vartype locations: list[str]
    :ivar aliases: The aliases that are supported by this resource type.
    :vartype aliases: list[~azure.mgmt.resource.resources.v2019_03_01.models.AliasType]
    :ivar api_versions: The API version.
    :vartype api_versions: list[str]
    :ivar zone_mappings:
    :vartype zone_mappings: list[~azure.mgmt.resource.resources.v2019_03_01.models.ZoneMapping]
    :ivar capabilities: The additional capabilities offered by this resource type.
    :vartype capabilities: str
    :ivar properties: The properties.
    :vartype properties: dict[str, str]
    """

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "locations": {"key": "locations", "type": "[str]"},
        "aliases": {"key": "aliases", "type": "[AliasType]"},
        "api_versions": {"key": "apiVersions", "type": "[str]"},
        "zone_mappings": {"key": "zoneMappings", "type": "[ZoneMapping]"},
        "capabilities": {"key": "capabilities", "type": "str"},
        "properties": {"key": "properties", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        locations: Optional[List[str]] = None,
        aliases: Optional[List["_models.AliasType"]] = None,
        api_versions: Optional[List[str]] = None,
        zone_mappings: Optional[List["_models.ZoneMapping"]] = None,
        capabilities: Optional[str] = None,
        properties: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_type: The resource type.
        :paramtype resource_type: str
        :keyword locations: The collection of locations where this resource type can be created.
        :paramtype locations: list[str]
        :keyword aliases: The aliases that are supported by this resource type.
        :paramtype aliases: list[~azure.mgmt.resource.resources.v2019_03_01.models.AliasType]
        :keyword api_versions: The API version.
        :paramtype api_versions: list[str]
        :keyword zone_mappings:
        :paramtype zone_mappings: list[~azure.mgmt.resource.resources.v2019_03_01.models.ZoneMapping]
        :keyword capabilities: The additional capabilities offered by this resource type.
        :paramtype capabilities: str
        :keyword properties: The properties.
        :paramtype properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.locations = locations
        self.aliases = aliases
        self.api_versions = api_versions
        self.zone_mappings = zone_mappings
        self.capabilities = capabilities
        self.properties = properties


class ResourceGroup(_serialization.Model):
    """Resource group information.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: The ID of the resource group.
    :vartype id: str
    :ivar name: The name of the resource group.
    :vartype name: str
    :ivar type: The type of the resource group.
    :vartype type: str
    :ivar properties: The resource group properties.
    :vartype properties: ~azure.mgmt.resource.resources.v2019_03_01.models.ResourceGroupProperties
    :ivar location: The location of the resource group. It cannot be changed after the resource
     group has been created. It must be one of the supported Azure locations. Required.
    :vartype location: str
    :ivar managed_by: The ID of the resource that manages this resource group.
    :vartype managed_by: str
    :ivar tags: The tags attached to the resource group.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "ResourceGroupProperties"},
        "location": {"key": "location", "type": "str"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        location: str,
        properties: Optional["_models.ResourceGroupProperties"] = None,
        managed_by: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: The resource group properties.
        :paramtype properties:
         ~azure.mgmt.resource.resources.v2019_03_01.models.ResourceGroupProperties
        :keyword location: The location of the resource group. It cannot be changed after the resource
         group has been created. It must be one of the supported Azure locations. Required.
        :paramtype location: str
        :keyword managed_by: The ID of the resource that manages this resource group.
        :paramtype managed_by: str
        :keyword tags: The tags attached to the resource group.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.name: Optional[str] = None
        self.type: Optional[str] = None
        self.properties = properties
        self.location = location
        self.managed_by = managed_by
        self.tags = tags


class ResourceGroupExportResult(_serialization.Model):
    """Resource group export result.

    :ivar template: The template content.
    :vartype template: JSON
    :ivar error: The error.
    :vartype error:
     ~azure.mgmt.resource.resources.v2019_03_01.models.ResourceManagementErrorWithDetails
    """

    _attribute_map = {
        "template": {"key": "template", "type": "object"},
        "error": {"key": "error", "type": "ResourceManagementErrorWithDetails"},
    }

    def __init__(
        self,
        *,
        template: Optional[JSON] = None,
        error: Optional["_models.ResourceManagementErrorWithDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword template: The template content.
        :paramtype template: JSON
        :keyword error: The error.
        :paramtype error:
         ~azure.mgmt.resource.resources.v2019_03_01.models.ResourceManagementErrorWithDetails
        """
        super().__init__(**kwargs)
        self.template = template
        self.error = error


class ResourceGroupFilter(_serialization.Model):
    """Resource group filter.

    :ivar tag_name: The tag name.
    :vartype tag_name: str
    :ivar tag_value: The tag value.
    :vartype tag_value: str
    """

    _attribute_map = {
        "tag_name": {"key": "tagName", "type": "str"},
        "tag_value": {"key": "tagValue", "type": "str"},
    }

    def __init__(self, *, tag_name: Optional[str] = None, tag_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword tag_name: The tag name.
        :paramtype tag_name: str
        :keyword tag_value: The tag value.
        :paramtype tag_value: str
        """
        super().__init__(**kwargs)
        self.tag_name = tag_name
        self.tag_value = tag_value


class ResourceGroupListResult(_serialization.Model):
    """List of resource groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of resource groups.
    :vartype value: list[~azure.mgmt.resource.resources.v2019_03_01.models.ResourceGroup]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ResourceGroup"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of resource groups.
        :paramtype value: list[~azure.mgmt.resource.resources.v2019_03_01.models.ResourceGroup]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ResourceGroupPatchable(_serialization.Model):
    """Resource group information.

    :ivar name: The name of the resource group.
    :vartype name: str
    :ivar properties: The resource group properties.
    :vartype properties: ~azure.mgmt.resource.resources.v2019_03_01.models.ResourceGroupProperties
    :ivar managed_by: The ID of the resource that manages this resource group.
    :vartype managed_by: str
    :ivar tags: The tags attached to the resource group.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "properties": {"key": "properties", "type": "ResourceGroupProperties"},
        "managed_by": {"key": "managedBy", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["_models.ResourceGroupProperties"] = None,
        managed_by: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the resource group.
        :paramtype name: str
        :keyword properties: The resource group properties.
        :paramtype properties:
         ~azure.mgmt.resource.resources.v2019_03_01.models.ResourceGroupProperties
        :keyword managed_by: The ID of the resource that manages this resource group.
        :paramtype managed_by: str
        :keyword tags: The tags attached to the resource group.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.properties = properties
        self.managed_by = managed_by
        self.tags = tags


class ResourceGroupProperties(_serialization.Model):
    """The resource group properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state: Optional[str] = None


class ResourceListResult(_serialization.Model):
    """List of resource groups.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of resources.
    :vartype value: list[~azure.mgmt.resource.resources.v2019_03_01.models.GenericResourceExpanded]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[GenericResourceExpanded]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.GenericResourceExpanded"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of resources.
        :paramtype value:
         list[~azure.mgmt.resource.resources.v2019_03_01.models.GenericResourceExpanded]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class ResourceManagementErrorWithDetails(_serialization.Model):
    """The detailed error message of resource management.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code returned when exporting the template.
    :vartype code: str
    :ivar message: The error message describing the export error.
    :vartype message: str
    :ivar target: The target of the error.
    :vartype target: str
    :ivar details: Validation error.
    :vartype details:
     list[~azure.mgmt.resource.resources.v2019_03_01.models.ResourceManagementErrorWithDetails]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ResourceManagementErrorWithDetails]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code: Optional[str] = None
        self.message: Optional[str] = None
        self.target: Optional[str] = None
        self.details: Optional[List["_models.ResourceManagementErrorWithDetails"]] = None


class ResourceProviderOperationDisplayProperties(_serialization.Model):  # pylint: disable=name-too-long
    """Resource provider operation's display properties.

    :ivar publisher: Operation description.
    :vartype publisher: str
    :ivar provider: Operation provider.
    :vartype provider: str
    :ivar resource: Operation resource.
    :vartype resource: str
    :ivar operation: Resource provider operation.
    :vartype operation: str
    :ivar description: Operation description.
    :vartype description: str
    """

    _attribute_map = {
        "publisher": {"key": "publisher", "type": "str"},
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher: Operation description.
        :paramtype publisher: str
        :keyword provider: Operation provider.
        :paramtype provider: str
        :keyword resource: Operation resource.
        :paramtype resource: str
        :keyword operation: Resource provider operation.
        :paramtype operation: str
        :keyword description: Operation description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.publisher = publisher
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ResourcesMoveInfo(_serialization.Model):
    """Parameters of move resources.

    :ivar resources: The IDs of the resources.
    :vartype resources: list[str]
    :ivar target_resource_group: The target resource group.
    :vartype target_resource_group: str
    """

    _attribute_map = {
        "resources": {"key": "resources", "type": "[str]"},
        "target_resource_group": {"key": "targetResourceGroup", "type": "str"},
    }

    def __init__(
        self, *, resources: Optional[List[str]] = None, target_resource_group: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword resources: The IDs of the resources.
        :paramtype resources: list[str]
        :keyword target_resource_group: The target resource group.
        :paramtype target_resource_group: str
        """
        super().__init__(**kwargs)
        self.resources = resources
        self.target_resource_group = target_resource_group


class Sku(_serialization.Model):
    """SKU for the resource.

    :ivar name: The SKU name.
    :vartype name: str
    :ivar tier: The SKU tier.
    :vartype tier: str
    :ivar size: The SKU size.
    :vartype size: str
    :ivar family: The SKU family.
    :vartype family: str
    :ivar model: The SKU model.
    :vartype model: str
    :ivar capacity: The SKU capacity.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "size": {"key": "size", "type": "str"},
        "family": {"key": "family", "type": "str"},
        "model": {"key": "model", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        model: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The SKU name.
        :paramtype name: str
        :keyword tier: The SKU tier.
        :paramtype tier: str
        :keyword size: The SKU size.
        :paramtype size: str
        :keyword family: The SKU family.
        :paramtype family: str
        :keyword model: The SKU model.
        :paramtype model: str
        :keyword capacity: The SKU capacity.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.size = size
        self.family = family
        self.model = model
        self.capacity = capacity


class SubResource(_serialization.Model):
    """Sub-resource.

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class TagCount(_serialization.Model):
    """Tag count.

    :ivar type: Type of count.
    :vartype type: str
    :ivar value: Value of count.
    :vartype value: int
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "value": {"key": "value", "type": "int"},
    }

    def __init__(self, *, type: Optional[str] = None, value: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword type: Type of count.
        :paramtype type: str
        :keyword value: Value of count.
        :paramtype value: int
        """
        super().__init__(**kwargs)
        self.type = type
        self.value = value


class TagDetails(_serialization.Model):
    """Tag details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The tag ID.
    :vartype id: str
    :ivar tag_name: The tag name.
    :vartype tag_name: str
    :ivar count: The total number of resources that use the resource tag. When a tag is initially
     created and has no associated resources, the value is 0.
    :vartype count: ~azure.mgmt.resource.resources.v2019_03_01.models.TagCount
    :ivar values: The list of tag values.
    :vartype values: list[~azure.mgmt.resource.resources.v2019_03_01.models.TagValue]
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "tag_name": {"key": "tagName", "type": "str"},
        "count": {"key": "count", "type": "TagCount"},
        "values": {"key": "values", "type": "[TagValue]"},
    }

    def __init__(
        self,
        *,
        tag_name: Optional[str] = None,
        count: Optional["_models.TagCount"] = None,
        values: Optional[List["_models.TagValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tag_name: The tag name.
        :paramtype tag_name: str
        :keyword count: The total number of resources that use the resource tag. When a tag is
         initially created and has no associated resources, the value is 0.
        :paramtype count: ~azure.mgmt.resource.resources.v2019_03_01.models.TagCount
        :keyword values: The list of tag values.
        :paramtype values: list[~azure.mgmt.resource.resources.v2019_03_01.models.TagValue]
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.tag_name = tag_name
        self.count = count
        self.values = values


class TagsListResult(_serialization.Model):
    """List of subscription tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: An array of tags.
    :vartype value: list[~azure.mgmt.resource.resources.v2019_03_01.models.TagDetails]
    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TagDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.TagDetails"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: An array of tags.
        :paramtype value: list[~azure.mgmt.resource.resources.v2019_03_01.models.TagDetails]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link: Optional[str] = None


class TagValue(_serialization.Model):
    """Tag information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The tag ID.
    :vartype id: str
    :ivar tag_value: The tag value.
    :vartype tag_value: str
    :ivar count: The tag value count.
    :vartype count: ~azure.mgmt.resource.resources.v2019_03_01.models.TagCount
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "tag_value": {"key": "tagValue", "type": "str"},
        "count": {"key": "count", "type": "TagCount"},
    }

    def __init__(
        self, *, tag_value: Optional[str] = None, count: Optional["_models.TagCount"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tag_value: The tag value.
        :paramtype tag_value: str
        :keyword count: The tag value count.
        :paramtype count: ~azure.mgmt.resource.resources.v2019_03_01.models.TagCount
        """
        super().__init__(**kwargs)
        self.id: Optional[str] = None
        self.tag_value = tag_value
        self.count = count


class TargetResource(_serialization.Model):
    """Target resource.

    :ivar id: The ID of the resource.
    :vartype id: str
    :ivar resource_name: The name of the resource.
    :vartype resource_name: str
    :ivar resource_type: The type of the resource.
    :vartype resource_type: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "resource_name": {"key": "resourceName", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        resource_name: Optional[str] = None,
        resource_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: The ID of the resource.
        :paramtype id: str
        :keyword resource_name: The name of the resource.
        :paramtype resource_name: str
        :keyword resource_type: The type of the resource.
        :paramtype resource_type: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.resource_name = resource_name
        self.resource_type = resource_type


class TemplateHashResult(_serialization.Model):
    """Result of the request to calculate template hash. It contains a string of minified template and
    its hash.

    :ivar minified_template: The minified template string.
    :vartype minified_template: str
    :ivar template_hash: The template hash.
    :vartype template_hash: str
    """

    _attribute_map = {
        "minified_template": {"key": "minifiedTemplate", "type": "str"},
        "template_hash": {"key": "templateHash", "type": "str"},
    }

    def __init__(
        self, *, minified_template: Optional[str] = None, template_hash: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword minified_template: The minified template string.
        :paramtype minified_template: str
        :keyword template_hash: The template hash.
        :paramtype template_hash: str
        """
        super().__init__(**kwargs)
        self.minified_template = minified_template
        self.template_hash = template_hash


class TemplateLink(_serialization.Model):
    """Entity representing the reference to the template.

    All required parameters must be populated in order to send to server.

    :ivar uri: The URI of the template to deploy. Required.
    :vartype uri: str
    :ivar content_version: If included, must match the ContentVersion in the template.
    :vartype content_version: str
    """

    _validation = {
        "uri": {"required": True},
    }

    _attribute_map = {
        "uri": {"key": "uri", "type": "str"},
        "content_version": {"key": "contentVersion", "type": "str"},
    }

    def __init__(self, *, uri: str, content_version: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword uri: The URI of the template to deploy. Required.
        :paramtype uri: str
        :keyword content_version: If included, must match the ContentVersion in the template.
        :paramtype content_version: str
        """
        super().__init__(**kwargs)
        self.uri = uri
        self.content_version = content_version


class ZoneMapping(_serialization.Model):
    """ZoneMapping.

    :ivar location: The location of the zone mapping.
    :vartype location: str
    :ivar zones:
    :vartype zones: list[str]
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
    }

    def __init__(self, *, location: Optional[str] = None, zones: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The location of the zone mapping.
        :paramtype location: str
        :keyword zones:
        :paramtype zones: list[str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.zones = zones
