# MkDocs

> *Project documentation with Markdown*

[![PyPI Version][pypi-v-image]][pypi-v-link]
[![Build Status][GHAction-image]][GHAction-link]
[![Coverage Status][codecov-image]][codecov-link]

MkDocs is a **fast**, **simple** and **downright gorgeous** static site
generator that's geared towards building project documentation. Documentation
source files are written in Markdown, and configured with a single YAML
configuration file. It is designed to be easy to use and can be extended with
third-party themes, plugins, and Markdown extensions.

Please see the [Documentation][mkdocs] for an introductory tutorial and a full
user guide.

## Features

- Build static HTML files from Markdown files.
- Use Plugins and Markdown Extensions to enhance MkDocs.
- Use the built-in themes, third party themes or create your own.
- Publish your documentation anywhere that static files can be served.
- Much more!

## Support

If you need help with MkDocs, do not hesitate to get in contact with us!

-   For questions and high-level discussions, use **[Discussions]** on GitHub.
    -   For small questions, a good alternative is the **[Chat room]** on
        Gitter/Matrix.
-   To report a bug or make a feature request, open an **[Issue]** on GitHub.

Please note that we may only provide
support for problems/questions regarding core features of MkDocs. Any
questions or bug reports about features of third-party themes, plugins,
extensions or similar should be made to their respective projects.  
But, such questions are *not* banned from the [chat room].

Make sure to stick around to answer some questions as well!

## Links

- [Official Documentation][mkdocs]
- [Latest Release Notes][release-notes]
- [Catalog of third-party plugins, themes and recipes][catalog]

## Contributing to MkDocs

The MkDocs project welcomes, and depends on, contributions from developers and
users in the open source community. Please see the [Contributing Guide] for
information on how you can help.

## Code of Conduct

Everyone interacting in the MkDocs project's codebases, issue trackers, and
discussion forums is expected to follow the [PyPA Code of Conduct].

<!-- Badges -->
[codecov-image]: https://codecov.io/github/mkdocs/mkdocs/coverage.svg?branch=master
[codecov-link]: https://codecov.io/github/mkdocs/mkdocs?branch=master
[pypi-v-image]: https://img.shields.io/pypi/v/mkdocs.svg
[pypi-v-link]: https://pypi.org/project/mkdocs/
[GHAction-image]: https://github.com/mkdocs/mkdocs/workflows/CI/badge.svg?branch=master&event=push
[GHAction-link]: https://github.com/mkdocs/mkdocs/actions?query=event%3Apush+branch%3Amaster
<!-- Links -->
[mkdocs]: https://www.mkdocs.org
[Issue]: https://github.com/mkdocs/mkdocs/issues
[Discussions]: https://github.com/mkdocs/mkdocs/discussions
[Chat room]: https://gitter.im/mkdocs/community
[release-notes]: https://www.mkdocs.org/about/release-notes/
[Contributing Guide]: https://www.mkdocs.org/about/contributing/
[PyPA Code of Conduct]: https://www.pypa.io/en/latest/code-of-conduct/
[catalog]: https://github.com/mkdocs/catalog

## License

[BSD-2-Clause](https://github.com/mkdocs/mkdocs/blob/master/LICENSE)
