# PySNMP SMI module. Autogenerated from smidump -f python IP-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:11 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
( InetAddress, InetAddressPrefixLength, InetAddressType, InetVersion, InetZoneIndex, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressPrefixLength", "InetAddressType", "InetVersion", "InetZoneIndex")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Counter64, Integer32, Integer32, IpAddress, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, zeroDotZero, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Integer32", "Integer32", "IpAddress", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2", "zeroDotZero")
( PhysAddress, RowPointer, RowStatus, StorageType, TextualConvention, TestAndIncr, TimeStamp, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "PhysAddress", "RowPointer", "RowStatus", "StorageType", "TextualConvention", "TestAndIncr", "TimeStamp", "TruthValue")

# Types

class IpAddressOriginTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(1,4,6,2,5,)
    namedValues = NamedValues(("other", 1), ("manual", 2), ("dhcp", 4), ("linklayer", 5), ("random", 6), )
    
class IpAddressPrefixOriginTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(1,4,3,2,5,)
    namedValues = NamedValues(("other", 1), ("manual", 2), ("wellknown", 3), ("dhcp", 4), ("routeradv", 5), )
    
class IpAddressStatusTC(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(4,1,8,6,2,3,7,5,)
    namedValues = NamedValues(("preferred", 1), ("deprecated", 2), ("invalid", 3), ("inaccessible", 4), ("unknown", 5), ("tentative", 6), ("duplicate", 7), ("optimistic", 8), )
    
class Ipv6AddressIfIdentifierTC(TextualConvention, OctetString):
    displayHint = "2x:"
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,8)
    

# Objects

ip = MibIdentifier((1, 3, 6, 1, 2, 1, 4))
ipForwarding = MibScalar((1, 3, 6, 1, 2, 1, 4, 1), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("forwarding", 1), ("notForwarding", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipForwarding.setDescription("The indication of whether this entity is acting as an IPv4\nrouter in respect to the forwarding of datagrams received\nby, but not addressed to, this entity.  IPv4 routers forward\ndatagrams.  IPv4 hosts do not (except those source-routed\nvia the host).\n\nWhen this object is written, the entity should save the\nchange to non-volatile storage and restore the object from\nnon-volatile storage upon re-initialization of the system.\nNote: a stronger requirement is not used because this object\nwas previously defined.")
ipDefaultTTL = MibScalar((1, 3, 6, 1, 2, 1, 4, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipDefaultTTL.setDescription("The default value inserted into the Time-To-Live field of\nthe IPv4 header of datagrams originated at this entity,\nwhenever a TTL value is not supplied by the transport layer\n\n\n\nprotocol.\n\nWhen this object is written, the entity should save the\nchange to non-volatile storage and restore the object from\nnon-volatile storage upon re-initialization of the system.\nNote: a stronger requirement is not used because this object\nwas previously defined.")
ipInReceives = MibScalar((1, 3, 6, 1, 2, 1, 4, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInReceives.setDescription("The total number of input datagrams received from\ninterfaces, including those received in error.\n\nThis object has been deprecated, as a new IP version-neutral\n\n\n\ntable has been added.  It is loosely replaced by\nipSystemStatsInRecieves.")
ipInHdrErrors = MibScalar((1, 3, 6, 1, 2, 1, 4, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInHdrErrors.setDescription("The number of input datagrams discarded due to errors in\ntheir IPv4 headers, including bad checksums, version number\nmismatch, other format errors, time-to-live exceeded, errors\ndiscovered in processing their IPv4 options, etc.\n\nThis object has been deprecated as a new IP version-neutral\ntable has been added.  It is loosely replaced by\nipSystemStatsInHdrErrors.")
ipInAddrErrors = MibScalar((1, 3, 6, 1, 2, 1, 4, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInAddrErrors.setDescription("The number of input datagrams discarded because the IPv4\naddress in their IPv4 header's destination field was not a\nvalid address to be received at this entity.  This count\nincludes invalid addresses (e.g., 0.0.0.0) and addresses of\nunsupported Classes (e.g., Class E).  For entities which are\nnot IPv4 routers, and therefore do not forward datagrams,\nthis counter includes datagrams discarded because the\ndestination address was not a local address.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by\nipSystemStatsInAddrErrors.")
ipForwDatagrams = MibScalar((1, 3, 6, 1, 2, 1, 4, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipForwDatagrams.setDescription("The number of input datagrams for which this entity was not\ntheir final IPv4 destination, as a result of which an\nattempt was made to find a route to forward them to that\nfinal destination.  In entities which do not act as IPv4\nrouters, this counter will include only those packets which\n\n\n\nwere Source-Routed via this entity, and the Source-Route\noption processing was successful.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by\nipSystemStatsInForwDatagrams.")
ipInUnknownProtos = MibScalar((1, 3, 6, 1, 2, 1, 4, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInUnknownProtos.setDescription("The number of locally-addressed datagrams received\nsuccessfully but discarded because of an unknown or\nunsupported protocol.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by\nipSystemStatsInUnknownProtos.")
ipInDiscards = MibScalar((1, 3, 6, 1, 2, 1, 4, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInDiscards.setDescription("The number of input IPv4 datagrams for which no problems\nwere encountered to prevent their continued processing, but\nwhich were discarded (e.g., for lack of buffer space).  Note\nthat this counter does not include any datagrams discarded\nwhile awaiting re-assembly.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by\nipSystemStatsInDiscards.")
ipInDelivers = MibScalar((1, 3, 6, 1, 2, 1, 4, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipInDelivers.setDescription("The total number of input datagrams successfully delivered\nto IPv4 user-protocols (including ICMP).\n\nThis object has been deprecated as a new IP version neutral\ntable has been added.  It is loosely replaced by\n\n\n\nipSystemStatsIndelivers.")
ipOutRequests = MibScalar((1, 3, 6, 1, 2, 1, 4, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipOutRequests.setDescription("The total number of IPv4 datagrams which local IPv4 user\nprotocols (including ICMP) supplied to IPv4 in requests for\ntransmission.  Note that this counter does not include any\ndatagrams counted in ipForwDatagrams.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by\nipSystemStatsOutRequests.")
ipOutDiscards = MibScalar((1, 3, 6, 1, 2, 1, 4, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipOutDiscards.setDescription("The number of output IPv4 datagrams for which no problem was\nencountered to prevent their transmission to their\ndestination, but which were discarded (e.g., for lack of\nbuffer space).  Note that this counter would include\ndatagrams counted in ipForwDatagrams if any such packets met\nthis (discretionary) discard criterion.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by\nipSystemStatsOutDiscards.")
ipOutNoRoutes = MibScalar((1, 3, 6, 1, 2, 1, 4, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipOutNoRoutes.setDescription("The number of IPv4 datagrams discarded because no route\ncould be found to transmit them to their destination.  Note\nthat this counter includes any packets counted in\nipForwDatagrams which meet this `no-route' criterion.  Note\nthat this includes any datagrams which a host cannot route\nbecause all of its default routers are down.\n\nThis object has been deprecated, as a new IP version-neutral\n\n\n\ntable has been added.  It is loosely replaced by\nipSystemStatsOutNoRoutes.")
ipReasmTimeout = MibScalar((1, 3, 6, 1, 2, 1, 4, 13), Integer32()).setMaxAccess("readonly").setUnits("seconds")
if mibBuilder.loadTexts: ipReasmTimeout.setDescription("The maximum number of seconds that received fragments are\nheld while they are awaiting reassembly at this entity.")
ipReasmReqds = MibScalar((1, 3, 6, 1, 2, 1, 4, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipReasmReqds.setDescription("The number of IPv4 fragments received which needed to be\nreassembled at this entity.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by\nipSystemStatsReasmReqds.")
ipReasmOKs = MibScalar((1, 3, 6, 1, 2, 1, 4, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipReasmOKs.setDescription("The number of IPv4 datagrams successfully re-assembled.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by\nipSystemStatsReasmOKs.")
ipReasmFails = MibScalar((1, 3, 6, 1, 2, 1, 4, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipReasmFails.setDescription("The number of failures detected by the IPv4 re-assembly\nalgorithm (for whatever reason: timed out, errors, etc).\nNote that this is not necessarily a count of discarded IPv4\nfragments since some algorithms (notably the algorithm in\nRFC 815) can lose track of the number of fragments by\ncombining them as they are received.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by\nipSystemStatsReasmFails.")
ipFragOKs = MibScalar((1, 3, 6, 1, 2, 1, 4, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipFragOKs.setDescription("The number of IPv4 datagrams that have been successfully\nfragmented at this entity.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by\nipSystemStatsOutFragOKs.")
ipFragFails = MibScalar((1, 3, 6, 1, 2, 1, 4, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipFragFails.setDescription("The number of IPv4 datagrams that have been discarded\nbecause they needed to be fragmented at this entity but\ncould not be, e.g., because their Don't Fragment flag was\nset.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by\nipSystemStatsOutFragFails.")
ipFragCreates = MibScalar((1, 3, 6, 1, 2, 1, 4, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipFragCreates.setDescription("The number of IPv4 datagram fragments that have been\ngenerated as a result of fragmentation at this entity.\n\nThis object has been deprecated as a new IP version neutral\ntable has been added.  It is loosely replaced by\nipSystemStatsOutFragCreates.")
ipAddrTable = MibTable((1, 3, 6, 1, 2, 1, 4, 20))
if mibBuilder.loadTexts: ipAddrTable.setDescription("The table of addressing information relevant to this\nentity's IPv4 addresses.\n\nThis table has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by the\nipAddressTable although several objects that weren't deemed\nuseful weren't carried forward while another\n(ipAdEntReasmMaxSize) was moved to the ipv4InterfaceTable.")
ipAddrEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 20, 1)).setIndexNames((0, "IP-MIB", "ipAdEntAddr"))
if mibBuilder.loadTexts: ipAddrEntry.setDescription("The addressing information for one of this entity's IPv4\naddresses.")
ipAdEntAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 1), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntAddr.setDescription("The IPv4 address to which this entry's addressing\ninformation pertains.")
ipAdEntIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntIfIndex.setDescription("The index value which uniquely identifies the interface to\nwhich this entry is applicable.  The interface identified by\na particular value of this index is the same interface as\nidentified by the same value of the IF-MIB's ifIndex.")
ipAdEntNetMask = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 3), IpAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntNetMask.setDescription("The subnet mask associated with the IPv4 address of this\nentry.  The value of the mask is an IPv4 address with all\nthe network bits set to 1 and all the hosts bits set to 0.")
ipAdEntBcastAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 1))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntBcastAddr.setDescription("The value of the least-significant bit in the IPv4 broadcast\naddress used for sending datagrams on the (logical)\ninterface associated with the IPv4 address of this entry.\nFor example, when the Internet standard all-ones broadcast\naddress is used, the value will be 1.  This value applies to\nboth the subnet and network broadcast addresses used by the\nentity on this (logical) interface.")
ipAdEntReasmMaxSize = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 20, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAdEntReasmMaxSize.setDescription("The size of the largest IPv4 datagram which this entity can\nre-assemble from incoming IPv4 fragmented datagrams received\non this interface.")
ipNetToMediaTable = MibTable((1, 3, 6, 1, 2, 1, 4, 22))
if mibBuilder.loadTexts: ipNetToMediaTable.setDescription("The IPv4 Address Translation table used for mapping from\nIPv4 addresses to physical addresses.\n\nThis table has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by the\nipNetToPhysicalTable.")
ipNetToMediaEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 22, 1)).setIndexNames((0, "IP-MIB", "ipNetToMediaIfIndex"), (0, "IP-MIB", "ipNetToMediaNetAddress"))
if mibBuilder.loadTexts: ipNetToMediaEntry.setDescription("Each entry contains one IpAddress to `physical' address\nequivalence.")
ipNetToMediaIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 22, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1, 2147483647))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToMediaIfIndex.setDescription("The interface on which this entry's equivalence is\neffective.  The interface identified by a particular value\nof this index is the same interface as identified by the\n\n\n\nsame value of the IF-MIB's ifIndex.\n\nThis object predates the rule limiting index objects to a\nmax access value of 'not-accessible' and so continues to use\na value of 'read-create'.")
ipNetToMediaPhysAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 22, 1, 2), PhysAddress().subtype(subtypeSpec=ValueSizeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToMediaPhysAddress.setDescription("The media-dependent `physical' address.  This object should\nreturn 0 when this entry is in the 'incomplete' state.\n\nAs the entries in this table are typically not persistent\nwhen this object is written the entity should not save the\nchange to non-volatile storage.  Note: a stronger\nrequirement is not used because this object was previously\ndefined.")
ipNetToMediaNetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 22, 1, 3), IpAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToMediaNetAddress.setDescription("The IpAddress corresponding to the media-dependent\n`physical' address.\n\nThis object predates the rule limiting index objects to a\nmax access value of 'not-accessible' and so continues to use\na value of 'read-create'.")
ipNetToMediaType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 22, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(4,1,3,2,)).subtype(namedValues=NamedValues(("other", 1), ("invalid", 2), ("dynamic", 3), ("static", 4), ))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToMediaType.setDescription("The type of mapping.\n\nSetting this object to the value invalid(2) has the effect\n\n\n\nof invalidating the corresponding entry in the\nipNetToMediaTable.  That is, it effectively dis-associates\nthe interface identified with said entry from the mapping\nidentified with said entry.  It is an implementation-\nspecific matter as to whether the agent removes an\ninvalidated entry from the table.  Accordingly, management\nstations must be prepared to receive tabular information\nfrom agents that corresponds to entries not currently in\nuse.  Proper interpretation of such entries requires\nexamination of the relevant ipNetToMediaType object.\n\nAs the entries in this table are typically not persistent\nwhen this object is written the entity should not save the\nchange to non-volatile storage.  Note: a stronger\nrequirement is not used because this object was previously\ndefined.")
ipRoutingDiscards = MibScalar((1, 3, 6, 1, 2, 1, 4, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipRoutingDiscards.setDescription("The number of routing entries which were chosen to be\ndiscarded even though they are valid.  One possible reason\nfor discarding such an entry could be to free-up buffer\nspace for other routing entries.\n\n\n\nThis object was defined in pre-IPv6 versions of the IP MIB.\nIt was implicitly IPv4 only, but the original specifications\ndid not indicate this protocol restriction.  In order to\nclarify the specifications, this object has been deprecated\nand a similar, but more thoroughly clarified, object has\nbeen added to the IP-FORWARD-MIB.")
ipv6IpForwarding = MibScalar((1, 3, 6, 1, 2, 1, 4, 25), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("forwarding", 1), ("notForwarding", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6IpForwarding.setDescription("The indication of whether this entity is acting as an IPv6\nrouter on any interface in respect to the forwarding of\ndatagrams received by, but not addressed to, this entity.\nIPv6 routers forward datagrams.  IPv6 hosts do not (except\nthose source-routed via the host).\n\nWhen this object is written, the entity SHOULD save the\nchange to non-volatile storage and restore the object from\nnon-volatile storage upon re-initialization of the system.")
ipv6IpDefaultHopLimit = MibScalar((1, 3, 6, 1, 2, 1, 4, 26), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6IpDefaultHopLimit.setDescription("The default value inserted into the Hop Limit field of the\nIPv6 header of datagrams originated at this entity whenever\na Hop Limit value is not supplied by the transport layer\nprotocol.\n\nWhen this object is written, the entity SHOULD save the\nchange to non-volatile storage and restore the object from\nnon-volatile storage upon re-initialization of the system.")
ipv4InterfaceTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 4, 27), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv4InterfaceTableLastChange.setDescription("The value of sysUpTime on the most recent occasion at which\na row in the ipv4InterfaceTable was added or deleted, or\nwhen an ipv4InterfaceReasmMaxSize or an\nipv4InterfaceEnableStatus object was modified.\n\nIf new objects are added to the ipv4InterfaceTable that\nrequire the ipv4InterfaceTableLastChange to be updated when\nthey are modified, they must specify that requirement in\ntheir description clause.")
ipv4InterfaceTable = MibTable((1, 3, 6, 1, 2, 1, 4, 28))
if mibBuilder.loadTexts: ipv4InterfaceTable.setDescription("The table containing per-interface IPv4-specific\ninformation.")
ipv4InterfaceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 28, 1)).setIndexNames((0, "IP-MIB", "ipv4InterfaceIfIndex"))
if mibBuilder.loadTexts: ipv4InterfaceEntry.setDescription("An entry containing IPv4-specific information for a specific\ninterface.")
ipv4InterfaceIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 28, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv4InterfaceIfIndex.setDescription("The index value that uniquely identifies the interface to\nwhich this entry is applicable.  The interface identified by\na particular value of this index is the same interface as\nidentified by the same value of the IF-MIB's ifIndex.")
ipv4InterfaceReasmMaxSize = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 28, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv4InterfaceReasmMaxSize.setDescription("The size of the largest IPv4 datagram that this entity can\nre-assemble from incoming IPv4 fragmented datagrams received\non this interface.")
ipv4InterfaceEnableStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 28, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("up", 1), ("down", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv4InterfaceEnableStatus.setDescription("The indication of whether IPv4 is enabled (up) or disabled\n(down) on this interface.  This object does not affect the\nstate of the interface itself, only its connection to an\nIPv4 stack.  The IF-MIB should be used to control the state\nof the interface.")
ipv4InterfaceRetransmitTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 28, 1, 4), Unsigned32().clone(1000)).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv4InterfaceRetransmitTime.setDescription("The time between retransmissions of ARP requests to a\nneighbor when resolving the address or when probing the\nreachability of a neighbor.")
ipv6InterfaceTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 4, 29), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6InterfaceTableLastChange.setDescription("The value of sysUpTime on the most recent occasion at which\na row in the ipv6InterfaceTable was added or deleted or when\nan ipv6InterfaceReasmMaxSize, ipv6InterfaceIdentifier,\nipv6InterfaceEnableStatus, ipv6InterfaceReachableTime,\nipv6InterfaceRetransmitTime, or ipv6InterfaceForwarding\nobject was modified.\n\nIf new objects are added to the ipv6InterfaceTable that\nrequire the ipv6InterfaceTableLastChange to be updated when\nthey are modified, they must specify that requirement in\ntheir description clause.")
ipv6InterfaceTable = MibTable((1, 3, 6, 1, 2, 1, 4, 30))
if mibBuilder.loadTexts: ipv6InterfaceTable.setDescription("The table containing per-interface IPv6-specific\ninformation.")
ipv6InterfaceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 30, 1)).setIndexNames((0, "IP-MIB", "ipv6InterfaceIfIndex"))
if mibBuilder.loadTexts: ipv6InterfaceEntry.setDescription("An entry containing IPv6-specific information for a given\ninterface.")
ipv6InterfaceIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv6InterfaceIfIndex.setDescription("The index value that uniquely identifies the interface to\nwhich this entry is applicable.  The interface identified by\na particular value of this index is the same interface as\nidentified by the same value of the IF-MIB's ifIndex.")
ipv6InterfaceReasmMaxSize = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1500, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6InterfaceReasmMaxSize.setDescription("The size of the largest IPv6 datagram that this entity can\nre-assemble from incoming IPv6 fragmented datagrams received\non this interface.")
ipv6InterfaceIdentifier = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 3), Ipv6AddressIfIdentifierTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6InterfaceIdentifier.setDescription("The Interface Identifier for this interface.  The Interface\nIdentifier is combined with an address prefix to form an\ninterface address.\n\nBy default, the Interface Identifier is auto-configured\naccording to the rules of the link type to which this\ninterface is attached.\n\n\n\n\nA zero length identifier may be used where appropriate.  One\npossible example is a loopback interface.")
ipv6InterfaceEnableStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("up", 1), ("down", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6InterfaceEnableStatus.setDescription("The indication of whether IPv6 is enabled (up) or disabled\n(down) on this interface.  This object does not affect the\nstate of the interface itself, only its connection to an\nIPv6 stack.  The IF-MIB should be used to control the state\nof the interface.\n\nWhen this object is written, the entity SHOULD save the\nchange to non-volatile storage and restore the object from\nnon-volatile storage upon re-initialization of the system.")
ipv6InterfaceReachableTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 6), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6InterfaceReachableTime.setDescription("The time a neighbor is considered reachable after receiving\na reachability confirmation.")
ipv6InterfaceRetransmitTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 7), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6InterfaceRetransmitTime.setDescription("The time between retransmissions of Neighbor Solicitation\nmessages to a neighbor when resolving the address or when\nprobing the reachability of a neighbor.")
ipv6InterfaceForwarding = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 30, 1, 8), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("forwarding", 1), ("notForwarding", 2), ))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6InterfaceForwarding.setDescription("The indication of whether this entity is acting as an IPv6\nrouter on this interface with respect to the forwarding of\ndatagrams received by, but not addressed to, this entity.\nIPv6 routers forward datagrams.  IPv6 hosts do not (except\nthose source-routed via the host).\n\nThis object is constrained by ipv6IpForwarding and is\nignored if ipv6IpForwarding is set to notForwarding.  Those\nsystems that do not provide per-interface control of the\nforwarding function should set this object to forwarding for\nall interfaces and allow the ipv6IpForwarding object to\ncontrol the forwarding capability.\n\nWhen this object is written, the entity SHOULD save the\nchange to non-volatile storage and restore the object from\nnon-volatile storage upon re-initialization of the system.")
ipTrafficStats = MibIdentifier((1, 3, 6, 1, 2, 1, 4, 31))
ipSystemStatsTable = MibTable((1, 3, 6, 1, 2, 1, 4, 31, 1))
if mibBuilder.loadTexts: ipSystemStatsTable.setDescription("The table containing system wide, IP version specific\ntraffic statistics.  This table and the ipIfStatsTable\ncontain similar objects whose difference is in their\ngranularity.  Where this table contains system wide traffic\nstatistics, the ipIfStatsTable contains the same statistics\nbut counted on a per-interface basis.")
ipSystemStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 31, 1, 1)).setIndexNames((0, "IP-MIB", "ipSystemStatsIPVersion"))
if mibBuilder.loadTexts: ipSystemStatsEntry.setDescription("A statistics entry containing system-wide objects for a\nparticular IP version.")
ipSystemStatsIPVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 1), InetVersion()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipSystemStatsIPVersion.setDescription("The IP version of this row.")
ipSystemStatsInReceives = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInReceives.setDescription("The total number of input IP datagrams received, including\nthose received in error.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsHCInReceives = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInReceives.setDescription("The total number of input IP datagrams received, including\nthose received in error.  This object counts the same\ndatagrams as ipSystemStatsInReceives, but allows for larger\nvalues.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInOctets.setDescription("The total number of octets received in input IP datagrams,\nincluding those received in error.  Octets from datagrams\ncounted in ipSystemStatsInReceives MUST be counted here.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsHCInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInOctets.setDescription("The total number of octets received in input IP datagrams,\nincluding those received in error.  This object counts the\nsame octets as ipSystemStatsInOctets, but allows for larger\n\n\n\nvalues.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsInHdrErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInHdrErrors.setDescription("The number of input IP datagrams discarded due to errors in\ntheir IP headers, including version number mismatch, other\nformat errors, hop count exceeded, errors discovered in\nprocessing their IP options, etc.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsInNoRoutes = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInNoRoutes.setDescription("The number of input IP datagrams discarded because no route\ncould be found to transmit them to their destination.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsInAddrErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInAddrErrors.setDescription("The number of input IP datagrams discarded because the IP\naddress in their IP header's destination field was not a\nvalid address to be received at this entity.  This count\nincludes invalid addresses (e.g., ::0).  For entities\nthat are not IP routers and therefore do not forward\n\n\n\ndatagrams, this counter includes datagrams discarded\nbecause the destination address was not a local address.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsInUnknownProtos = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInUnknownProtos.setDescription("The number of locally-addressed IP datagrams received\nsuccessfully but discarded because of an unknown or\nunsupported protocol.\n\nWhen tracking interface statistics, the counter of the\ninterface to which these datagrams were addressed is\nincremented.  This interface might not be the same as the\ninput interface for some of the datagrams.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsInTruncatedPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInTruncatedPkts.setDescription("The number of input IP datagrams discarded because the\ndatagram frame didn't carry enough data.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsInForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInForwDatagrams.setDescription("The number of input datagrams for which this entity was not\ntheir final IP destination and for which this entity\nattempted to find a route to forward them to that final\ndestination.  In entities that do not act as IP routers,\nthis counter will include only those datagrams that were\nSource-Routed via this entity, and the Source-Route\nprocessing was successful.\n\nWhen tracking interface statistics, the counter of the\nincoming interface is incremented for each datagram.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsHCInForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 13), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInForwDatagrams.setDescription("The number of input datagrams for which this entity was not\ntheir final IP destination and for which this entity\nattempted to find a route to forward them to that final\ndestination.  This object counts the same packets as\nipSystemStatsInForwDatagrams, but allows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsReasmReqds = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsReasmReqds.setDescription("The number of IP fragments received that needed to be\nreassembled at this interface.\n\nWhen tracking interface statistics, the counter of the\ninterface to which these fragments were addressed is\nincremented.  This interface might not be the same as the\ninput interface for some of the fragments.\n\nDiscontinuities in the value of this counter can occur at\n\n\n\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsReasmOKs = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsReasmOKs.setDescription("The number of IP datagrams successfully reassembled.\n\nWhen tracking interface statistics, the counter of the\ninterface to which these datagrams were addressed is\nincremented.  This interface might not be the same as the\ninput interface for some of the datagrams.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsReasmFails = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsReasmFails.setDescription("The number of failures detected by the IP re-assembly\nalgorithm (for whatever reason: timed out, errors, etc.).\nNote that this is not necessarily a count of discarded IP\nfragments since some algorithms (notably the algorithm in\nRFC 815) can lose track of the number of fragments by\ncombining them as they are received.\n\nWhen tracking interface statistics, the counter of the\ninterface to which these fragments were addressed is\nincremented.  This interface might not be the same as the\ninput interface for some of the fragments.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInDiscards.setDescription("The number of input IP datagrams for which no problems were\nencountered to prevent their continued processing, but\nwere discarded (e.g., for lack of buffer space).  Note that\nthis counter does not include any datagrams discarded while\nawaiting re-assembly.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsInDelivers = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInDelivers.setDescription("The total number of datagrams successfully delivered to IP\nuser-protocols (including ICMP).\n\nWhen tracking interface statistics, the counter of the\ninterface to which these datagrams were addressed is\nincremented.  This interface might not be the same as the\ninput interface for some of the datagrams.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsHCInDelivers = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 19), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInDelivers.setDescription("The total number of datagrams successfully delivered to IP\nuser-protocols (including ICMP).  This object counts the\nsame packets as ipSystemStatsInDelivers, but allows for\nlarger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutRequests.setDescription("The total number of IP datagrams that local IP user-\nprotocols (including ICMP) supplied to IP in requests for\ntransmission.  Note that this counter does not include any\ndatagrams counted in ipSystemStatsOutForwDatagrams.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsHCOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 21), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutRequests.setDescription("The total number of IP datagrams that local IP user-\nprotocols (including ICMP) supplied to IP in requests for\ntransmission.  This object counts the same packets as\nipSystemStatsOutRequests, but allows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsOutNoRoutes = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutNoRoutes.setDescription("The number of locally generated IP datagrams discarded\nbecause no route could be found to transmit them to their\ndestination.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsOutForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutForwDatagrams.setDescription("The number of datagrams for which this entity was not their\nfinal IP destination and for which it was successful in\nfinding a path to their final destination.  In entities\nthat do not act as IP routers, this counter will include\nonly those datagrams that were Source-Routed via this\nentity, and the Source-Route processing was successful.\n\nWhen tracking interface statistics, the counter of the\noutgoing interface is incremented for a successfully\nforwarded datagram.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsHCOutForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 24), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutForwDatagrams.setDescription("The number of datagrams for which this entity was not their\nfinal IP destination and for which it was successful in\nfinding a path to their final destination.  This object\ncounts the same packets as ipSystemStatsOutForwDatagrams,\nbut allows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsOutDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutDiscards.setDescription("The number of output IP datagrams for which no problem was\nencountered to prevent their transmission to their\ndestination, but were discarded (e.g., for lack of\nbuffer space).  Note that this counter would include\n\n\n\ndatagrams counted in ipSystemStatsOutForwDatagrams if any\nsuch datagrams met this (discretionary) discard criterion.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsOutFragReqds = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutFragReqds.setDescription("The number of IP datagrams that would require fragmentation\nin order to be transmitted.\n\nWhen tracking interface statistics, the counter of the\noutgoing interface is incremented for a successfully\nfragmented datagram.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsOutFragOKs = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutFragOKs.setDescription("The number of IP datagrams that have been successfully\nfragmented.\n\nWhen tracking interface statistics, the counter of the\noutgoing interface is incremented for a successfully\nfragmented datagram.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsOutFragFails = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutFragFails.setDescription("The number of IP datagrams that have been discarded because\nthey needed to be fragmented but could not be.  This\nincludes IPv4 packets that have the DF bit set and IPv6\npackets that are being forwarded and exceed the outgoing\nlink MTU.\n\nWhen tracking interface statistics, the counter of the\noutgoing interface is incremented for an unsuccessfully\nfragmented datagram.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsOutFragCreates = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 29), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutFragCreates.setDescription("The number of output datagram fragments that have been\ngenerated as a result of IP fragmentation.\n\nWhen tracking interface statistics, the counter of the\noutgoing interface is incremented for a successfully\nfragmented datagram.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsOutTransmits = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutTransmits.setDescription("The total number of IP datagrams that this entity supplied\nto the lower layers for transmission.  This includes\ndatagrams generated locally and those forwarded by this\nentity.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\n\n\n\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsHCOutTransmits = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 31), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutTransmits.setDescription("The total number of IP datagrams that this entity supplied\nto the lower layers for transmission.  This object counts\nthe same datagrams as ipSystemStatsOutTransmits, but allows\nfor larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 32), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutOctets.setDescription("The total number of octets in IP datagrams delivered to the\nlower layers for transmission.  Octets from datagrams\ncounted in ipSystemStatsOutTransmits MUST be counted here.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsHCOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 33), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutOctets.setDescription("The total number of octets in IP datagrams delivered to the\nlower layers for transmission.  This objects counts the same\noctets as ipSystemStatsOutOctets, but allows for larger\nvalues.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\n\n\n\nipSystemStatsDiscontinuityTime.")
ipSystemStatsInMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 34), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInMcastPkts.setDescription("The number of IP multicast datagrams received.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsHCInMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 35), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInMcastPkts.setDescription("The number of IP multicast datagrams received.  This object\ncounts the same datagrams as ipSystemStatsInMcastPkts but\nallows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsInMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 36), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInMcastOctets.setDescription("The total number of octets received in IP multicast\ndatagrams.  Octets from datagrams counted in\nipSystemStatsInMcastPkts MUST be counted here.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsHCInMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 37), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInMcastOctets.setDescription("The total number of octets received in IP multicast\ndatagrams.  This object counts the same octets as\nipSystemStatsInMcastOctets, but allows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsOutMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 38), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutMcastPkts.setDescription("The number of IP multicast datagrams transmitted.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsHCOutMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 39), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutMcastPkts.setDescription("The number of IP multicast datagrams transmitted.  This\nobject counts the same datagrams as\nipSystemStatsOutMcastPkts, but allows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsOutMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 40), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutMcastOctets.setDescription("The total number of octets transmitted in IP multicast\ndatagrams.  Octets from datagrams counted in\n\n\n\nipSystemStatsOutMcastPkts MUST be counted here.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsHCOutMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 41), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutMcastOctets.setDescription("The total number of octets transmitted in IP multicast\ndatagrams.  This object counts the same octets as\nipSystemStatsOutMcastOctets, but allows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsInBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 42), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsInBcastPkts.setDescription("The number of IP broadcast datagrams received.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsHCInBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 43), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCInBcastPkts.setDescription("The number of IP broadcast datagrams received.  This object\ncounts the same datagrams as ipSystemStatsInBcastPkts but\nallows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\n\n\n\nipSystemStatsDiscontinuityTime.")
ipSystemStatsOutBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 44), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsOutBcastPkts.setDescription("The number of IP broadcast datagrams transmitted.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsHCOutBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 45), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsHCOutBcastPkts.setDescription("The number of IP broadcast datagrams transmitted.  This\nobject counts the same datagrams as\nipSystemStatsOutBcastPkts, but allows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipSystemStatsDiscontinuityTime.")
ipSystemStatsDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 46), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at which\nany one or more of this entry's counters suffered a\ndiscontinuity.\n\nIf no such discontinuities have occurred since the last re-\ninitialization of the local management subsystem, then this\nobject contains a zero value.")
ipSystemStatsRefreshRate = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 1, 1, 47), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipSystemStatsRefreshRate.setDescription("The minimum reasonable polling interval for this entry.\nThis object provides an indication of the minimum amount of\ntime required to update the counters in this entry.")
ipIfStatsTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 4, 31, 2), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsTableLastChange.setDescription("The value of sysUpTime on the most recent occasion at which\na row in the ipIfStatsTable was added or deleted.\n\nIf new objects are added to the ipIfStatsTable that require\nthe ipIfStatsTableLastChange to be updated when they are\nmodified, they must specify that requirement in their\ndescription clause.")
ipIfStatsTable = MibTable((1, 3, 6, 1, 2, 1, 4, 31, 3))
if mibBuilder.loadTexts: ipIfStatsTable.setDescription("The table containing per-interface traffic statistics.  This\ntable and the ipSystemStatsTable contain similar objects\nwhose difference is in their granularity.  Where this table\ncontains per-interface statistics, the ipSystemStatsTable\ncontains the same statistics, but counted on a system wide\nbasis.")
ipIfStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 31, 3, 1)).setIndexNames((0, "IP-MIB", "ipIfStatsIPVersion"), (0, "IP-MIB", "ipIfStatsIfIndex"))
if mibBuilder.loadTexts: ipIfStatsEntry.setDescription("An interface statistics entry containing objects for a\nparticular interface and version of IP.")
ipIfStatsIPVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 1), InetVersion()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipIfStatsIPVersion.setDescription("The IP version of this row.")
ipIfStatsIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 2), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipIfStatsIfIndex.setDescription("The index value that uniquely identifies the interface to\nwhich this entry is applicable.  The interface identified by\na particular value of this index is the same interface as\nidentified by the same value of the IF-MIB's ifIndex.")
ipIfStatsInReceives = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInReceives.setDescription("The total number of input IP datagrams received, including\nthose received in error.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsHCInReceives = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 4), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInReceives.setDescription("The total number of input IP datagrams received, including\nthose received in error.  This object counts the same\ndatagrams as ipIfStatsInReceives, but allows for larger\nvalues.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInOctets.setDescription("The total number of octets received in input IP datagrams,\nincluding those received in error.  Octets from datagrams\ncounted in ipIfStatsInReceives MUST be counted here.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsHCInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInOctets.setDescription("The total number of octets received in input IP datagrams,\nincluding those received in error.  This object counts the\nsame octets as ipIfStatsInOctets, but allows for larger\nvalues.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsInHdrErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInHdrErrors.setDescription("The number of input IP datagrams discarded due to errors in\ntheir IP headers, including version number mismatch, other\nformat errors, hop count exceeded, errors discovered in\nprocessing their IP options, etc.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsInNoRoutes = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInNoRoutes.setDescription("The number of input IP datagrams discarded because no route\ncould be found to transmit them to their destination.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsInAddrErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInAddrErrors.setDescription("The number of input IP datagrams discarded because the IP\naddress in their IP header's destination field was not a\nvalid address to be received at this entity.  This count\nincludes invalid addresses (e.g., ::0).  For entities that\nare not IP routers and therefore do not forward datagrams,\nthis counter includes datagrams discarded because the\ndestination address was not a local address.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsInUnknownProtos = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInUnknownProtos.setDescription("The number of locally-addressed IP datagrams received\nsuccessfully but discarded because of an unknown or\nunsupported protocol.\n\nWhen tracking interface statistics, the counter of the\ninterface to which these datagrams were addressed is\nincremented.  This interface might not be the same as the\ninput interface for some of the datagrams.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\n\n\n\nipIfStatsDiscontinuityTime.")
ipIfStatsInTruncatedPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInTruncatedPkts.setDescription("The number of input IP datagrams discarded because the\ndatagram frame didn't carry enough data.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsInForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInForwDatagrams.setDescription("The number of input datagrams for which this entity was not\ntheir final IP destination and for which this entity\nattempted to find a route to forward them to that final\ndestination.  In entities that do not act as IP routers,\nthis counter will include only those datagrams that were\nSource-Routed via this entity, and the Source-Route\nprocessing was successful.\n\nWhen tracking interface statistics, the counter of the\nincoming interface is incremented for each datagram.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsHCInForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 13), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInForwDatagrams.setDescription("The number of input datagrams for which this entity was not\ntheir final IP destination and for which this entity\nattempted to find a route to forward them to that final\ndestination.  This object counts the same packets as\n\n\n\nipIfStatsInForwDatagrams, but allows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsReasmReqds = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsReasmReqds.setDescription("The number of IP fragments received that needed to be\nreassembled at this interface.\n\nWhen tracking interface statistics, the counter of the\ninterface to which these fragments were addressed is\nincremented.  This interface might not be the same as the\ninput interface for some of the fragments.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsReasmOKs = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsReasmOKs.setDescription("The number of IP datagrams successfully reassembled.\n\nWhen tracking interface statistics, the counter of the\ninterface to which these datagrams were addressed is\nincremented.  This interface might not be the same as the\ninput interface for some of the datagrams.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsReasmFails = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsReasmFails.setDescription("The number of failures detected by the IP re-assembly\nalgorithm (for whatever reason: timed out, errors, etc.).\nNote that this is not necessarily a count of discarded IP\nfragments since some algorithms (notably the algorithm in\nRFC 815) can lose track of the number of fragments by\ncombining them as they are received.\n\nWhen tracking interface statistics, the counter of the\ninterface to which these fragments were addressed is\nincremented.  This interface might not be the same as the\ninput interface for some of the fragments.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInDiscards.setDescription("The number of input IP datagrams for which no problems were\nencountered to prevent their continued processing, but\nwere discarded (e.g., for lack of buffer space).  Note that\nthis counter does not include any datagrams discarded while\nawaiting re-assembly.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsInDelivers = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInDelivers.setDescription("The total number of datagrams successfully delivered to IP\nuser-protocols (including ICMP).\n\nWhen tracking interface statistics, the counter of the\ninterface to which these datagrams were addressed is\nincremented.  This interface might not be the same as the\n\n\n\ninput interface for some of the datagrams.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsHCInDelivers = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 19), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInDelivers.setDescription("The total number of datagrams successfully delivered to IP\nuser-protocols (including ICMP).  This object counts the\nsame packets as ipIfStatsInDelivers, but allows for larger\nvalues.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutRequests.setDescription("The total number of IP datagrams that local IP user-\nprotocols (including ICMP) supplied to IP in requests for\ntransmission.  Note that this counter does not include any\ndatagrams counted in ipIfStatsOutForwDatagrams.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsHCOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 21), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutRequests.setDescription("The total number of IP datagrams that local IP user-\nprotocols (including ICMP) supplied to IP in requests for\ntransmission.  This object counts the same packets as\n\n\n\nipIfStatsOutRequests, but allows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsOutForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutForwDatagrams.setDescription("The number of datagrams for which this entity was not their\nfinal IP destination and for which it was successful in\nfinding a path to their final destination.  In entities\nthat do not act as IP routers, this counter will include\nonly those datagrams that were Source-Routed via this\nentity, and the Source-Route processing was successful.\n\nWhen tracking interface statistics, the counter of the\noutgoing interface is incremented for a successfully\nforwarded datagram.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsHCOutForwDatagrams = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 24), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutForwDatagrams.setDescription("The number of datagrams for which this entity was not their\nfinal IP destination and for which it was successful in\nfinding a path to their final destination.  This object\ncounts the same packets as ipIfStatsOutForwDatagrams, but\nallows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\n\n\n\nipIfStatsDiscontinuityTime.")
ipIfStatsOutDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutDiscards.setDescription("The number of output IP datagrams for which no problem was\nencountered to prevent their transmission to their\ndestination, but were discarded (e.g., for lack of\nbuffer space).  Note that this counter would include\ndatagrams counted in ipIfStatsOutForwDatagrams if any such\ndatagrams met this (discretionary) discard criterion.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsOutFragReqds = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutFragReqds.setDescription("The number of IP datagrams that would require fragmentation\nin order to be transmitted.\n\nWhen tracking interface statistics, the counter of the\noutgoing interface is incremented for a successfully\nfragmented datagram.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsOutFragOKs = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 27), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutFragOKs.setDescription("The number of IP datagrams that have been successfully\nfragmented.\n\nWhen tracking interface statistics, the counter of the\n\n\n\noutgoing interface is incremented for a successfully\nfragmented datagram.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsOutFragFails = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 28), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutFragFails.setDescription("The number of IP datagrams that have been discarded because\nthey needed to be fragmented but could not be.  This\nincludes IPv4 packets that have the DF bit set and IPv6\npackets that are being forwarded and exceed the outgoing\nlink MTU.\n\nWhen tracking interface statistics, the counter of the\noutgoing interface is incremented for an unsuccessfully\nfragmented datagram.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsOutFragCreates = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 29), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutFragCreates.setDescription("The number of output datagram fragments that have been\ngenerated as a result of IP fragmentation.\n\nWhen tracking interface statistics, the counter of the\noutgoing interface is incremented for a successfully\nfragmented datagram.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsOutTransmits = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 30), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutTransmits.setDescription("The total number of IP datagrams that this entity supplied\nto the lower layers for transmission.  This includes\ndatagrams generated locally and those forwarded by this\nentity.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsHCOutTransmits = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 31), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutTransmits.setDescription("The total number of IP datagrams that this entity supplied\nto the lower layers for transmission.  This object counts\nthe same datagrams as ipIfStatsOutTransmits, but allows for\nlarger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 32), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutOctets.setDescription("The total number of octets in IP datagrams delivered to the\nlower layers for transmission.  Octets from datagrams\ncounted in ipIfStatsOutTransmits MUST be counted here.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsHCOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 33), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutOctets.setDescription("The total number of octets in IP datagrams delivered to the\nlower layers for transmission.  This objects counts the same\noctets as ipIfStatsOutOctets, but allows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsInMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 34), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInMcastPkts.setDescription("The number of IP multicast datagrams received.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsHCInMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 35), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInMcastPkts.setDescription("The number of IP multicast datagrams received.  This object\ncounts the same datagrams as ipIfStatsInMcastPkts, but\nallows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsInMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 36), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInMcastOctets.setDescription("The total number of octets received in IP multicast\n\n\n\ndatagrams.  Octets from datagrams counted in\nipIfStatsInMcastPkts MUST be counted here.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsHCInMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 37), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInMcastOctets.setDescription("The total number of octets received in IP multicast\ndatagrams.  This object counts the same octets as\nipIfStatsInMcastOctets, but allows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsOutMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 38), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutMcastPkts.setDescription("The number of IP multicast datagrams transmitted.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsHCOutMcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 39), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutMcastPkts.setDescription("The number of IP multicast datagrams transmitted.  This\nobject counts the same datagrams as ipIfStatsOutMcastPkts,\nbut allows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\n\n\n\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsOutMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 40), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutMcastOctets.setDescription("The total number of octets transmitted in IP multicast\ndatagrams.  Octets from datagrams counted in\nipIfStatsOutMcastPkts MUST be counted here.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsHCOutMcastOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 41), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutMcastOctets.setDescription("The total number of octets transmitted in IP multicast\ndatagrams.  This object counts the same octets as\nipIfStatsOutMcastOctets, but allows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsInBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 42), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsInBcastPkts.setDescription("The number of IP broadcast datagrams received.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsHCInBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 43), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCInBcastPkts.setDescription("The number of IP broadcast datagrams received.  This object\ncounts the same datagrams as ipIfStatsInBcastPkts, but\nallows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsOutBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 44), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsOutBcastPkts.setDescription("The number of IP broadcast datagrams transmitted.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsHCOutBcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 45), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsHCOutBcastPkts.setDescription("The number of IP broadcast datagrams transmitted.  This\nobject counts the same datagrams as ipIfStatsOutBcastPkts,\nbut allows for larger values.\n\nDiscontinuities in the value of this counter can occur at\nre-initialization of the management system, and at other\ntimes as indicated by the value of\nipIfStatsDiscontinuityTime.")
ipIfStatsDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 46), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at which\n\n\n\nany one or more of this entry's counters suffered a\ndiscontinuity.\n\nIf no such discontinuities have occurred since the last re-\ninitialization of the local management subsystem, then this\nobject contains a zero value.")
ipIfStatsRefreshRate = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 31, 3, 1, 47), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipIfStatsRefreshRate.setDescription("The minimum reasonable polling interval for this entry.\nThis object provides an indication of the minimum amount of\ntime required to update the counters in this entry.")
ipAddressPrefixTable = MibTable((1, 3, 6, 1, 2, 1, 4, 32))
if mibBuilder.loadTexts: ipAddressPrefixTable.setDescription("This table allows the user to determine the source of an IP\naddress or set of IP addresses, and allows other tables to\nshare the information via pointer rather than by copying.\n\nFor example, when the node configures both a unicast and\nanycast address for a prefix, the ipAddressPrefix objects\nfor those addresses will point to a single row in this\ntable.\n\nThis table primarily provides support for IPv6 prefixes, and\nseveral of the objects are less meaningful for IPv4.  The\ntable continues to allow IPv4 addresses to allow future\nflexibility.  In order to promote a common configuration,\nthis document includes suggestions for default values for\nIPv4 prefixes.  Each of these values may be overridden if an\nobject is meaningful to the node.\n\nAll prefixes used by this entity should be included in this\ntable independent of how the entity learned the prefix.\n(This table isn't limited to prefixes learned from router\n\n\n\nadvertisements.)")
ipAddressPrefixEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 32, 1)).setIndexNames((0, "IP-MIB", "ipAddressPrefixIfIndex"), (0, "IP-MIB", "ipAddressPrefixType"), (0, "IP-MIB", "ipAddressPrefixPrefix"), (0, "IP-MIB", "ipAddressPrefixLength"))
if mibBuilder.loadTexts: ipAddressPrefixEntry.setDescription("An entry in the ipAddressPrefixTable.")
ipAddressPrefixIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipAddressPrefixIfIndex.setDescription("The index value that uniquely identifies the interface on\nwhich this prefix is configured.  The interface identified\nby a particular value of this index is the same interface as\nidentified by the same value of the IF-MIB's ifIndex.")
ipAddressPrefixType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 2), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipAddressPrefixType.setDescription("The address type of ipAddressPrefix.")
ipAddressPrefixPrefix = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 3), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipAddressPrefixPrefix.setDescription("The address prefix.  The address type of this object is\nspecified in ipAddressPrefixType.  The length of this object\nis the standard length for objects of that type (4 or 16\nbytes).  Any bits after ipAddressPrefixLength must be zero.\n\nImplementors need to be aware that, if the size of\nipAddressPrefixPrefix exceeds 114 octets, then OIDS of\ninstances of columns in this row will have more than 128\nsub-identifiers and cannot be accessed using SNMPv1,\nSNMPv2c, or SNMPv3.")
ipAddressPrefixLength = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 4), InetAddressPrefixLength()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipAddressPrefixLength.setDescription("The prefix length associated with this prefix.\n\nThe value 0 has no special meaning for this object.  It\nsimply refers to address '::/0'.")
ipAddressPrefixOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 5), IpAddressPrefixOriginTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefixOrigin.setDescription("The origin of this prefix.")
ipAddressPrefixOnLinkFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefixOnLinkFlag.setDescription("This object has the value 'true(1)', if this prefix can be\nused for on-link determination; otherwise, the value is\n'false(2)'.\n\nThe default for IPv4 prefixes is 'true(1)'.")
ipAddressPrefixAutonomousFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 7), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefixAutonomousFlag.setDescription("Autonomous address configuration flag.  When true(1),\nindicates that this prefix can be used for autonomous\naddress configuration (i.e., can be used to form a local\ninterface address).  If false(2), it is not used to auto-\nconfigure a local interface address.\n\nThe default for IPv4 prefixes is 'false(2)'.")
ipAddressPrefixAdvPreferredLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefixAdvPreferredLifetime.setDescription("The remaining length of time, in seconds, that this prefix\nwill continue to be preferred, i.e., time until deprecation.\n\nA value of 4,294,967,295 represents infinity.\n\nThe address generated from a deprecated prefix should no\nlonger be used as a source address in new communications,\nbut packets received on such an interface are processed as\nexpected.\n\nThe default for IPv4 prefixes is 4,294,967,295 (infinity).")
ipAddressPrefixAdvValidLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 32, 1, 9), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefixAdvValidLifetime.setDescription("The remaining length of time, in seconds, that this prefix\nwill continue to be valid, i.e., time until invalidation.  A\nvalue of 4,294,967,295 represents infinity.\n\nThe address generated from an invalidated prefix should not\nappear as the destination or source address of a packet.\n\n\n\n\nThe default for IPv4 prefixes is 4,294,967,295 (infinity).")
ipAddressSpinLock = MibScalar((1, 3, 6, 1, 2, 1, 4, 33), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipAddressSpinLock.setDescription("An advisory lock used to allow cooperating SNMP managers to\ncoordinate their use of the set operation in creating or\nmodifying rows within this table.\n\nIn order to use this lock to coordinate the use of set\noperations, managers should first retrieve\nipAddressTableSpinLock.  They should then determine the\nappropriate row to create or modify.  Finally, they should\nissue the appropriate set command, including the retrieved\nvalue of ipAddressSpinLock.  If another manager has altered\nthe table in the meantime, then the value of\nipAddressSpinLock will have changed, and the creation will\nfail as it will be specifying an incorrect value for\nipAddressSpinLock.  It is suggested, but not required, that\nthe ipAddressSpinLock be the first var bind for each set of\nobjects representing a 'row' in a PDU.")
ipAddressTable = MibTable((1, 3, 6, 1, 2, 1, 4, 34))
if mibBuilder.loadTexts: ipAddressTable.setDescription("This table contains addressing information relevant to the\nentity's interfaces.\n\nThis table does not contain multicast address information.\nTables for such information should be contained in multicast\nspecific MIBs, such as RFC 3019.\n\nWhile this table is writable, the user will note that\nseveral objects, such as ipAddressOrigin, are not.  The\nintention in allowing a user to write to this table is to\nallow them to add or remove any entry that isn't\n\n\n\npermanent.  The user should be allowed to modify objects\nand entries when that would not cause inconsistencies\nwithin the table.  Allowing write access to objects, such\nas ipAddressOrigin, could allow a user to insert an entry\nand then label it incorrectly.\n\nNote well: When including IPv6 link-local addresses in this\ntable, the entry must use an InetAddressType of 'ipv6z' in\norder to differentiate between the possible interfaces.")
ipAddressEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 34, 1)).setIndexNames((0, "IP-MIB", "ipAddressAddrType"), (0, "IP-MIB", "ipAddressAddr"))
if mibBuilder.loadTexts: ipAddressEntry.setDescription("An address mapping for a particular interface.")
ipAddressAddrType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipAddressAddrType.setDescription("The address type of ipAddressAddr.")
ipAddressAddr = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipAddressAddr.setDescription("The IP address to which this entry's addressing information\n\n\n\npertains.  The address type of this object is specified in\nipAddressAddrType.\n\nImplementors need to be aware that if the size of\nipAddressAddr exceeds 116 octets, then OIDS of instances of\ncolumns in this row will have more than 128 sub-identifiers\nand cannot be accessed using SNMPv1, SNMPv2c, or SNMPv3.")
ipAddressIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 3), InterfaceIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipAddressIfIndex.setDescription("The index value that uniquely identifies the interface to\nwhich this entry is applicable.  The interface identified by\na particular value of this index is the same interface as\nidentified by the same value of the IF-MIB's ifIndex.")
ipAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 4), Integer().subtype(subtypeSpec=SingleValueConstraint(1,3,2,)).subtype(namedValues=NamedValues(("unicast", 1), ("anycast", 2), ("broadcast", 3), )).clone(1)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipAddressType.setDescription("The type of address.  broadcast(3) is not a valid value for\nIPv6 addresses (RFC 3513).")
ipAddressPrefix = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 5), RowPointer().clone('0.0')).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressPrefix.setDescription("A pointer to the row in the prefix table to which this\naddress belongs.  May be { 0 0 } if there is no such row.")
ipAddressOrigin = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 6), IpAddressOriginTC()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressOrigin.setDescription("The origin of the address.")
ipAddressStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 7), IpAddressStatusTC().clone('preferred')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipAddressStatus.setDescription("The status of the address, describing if the address can be\nused for communication.\n\nIn the absence of other information, an IPv4 address is\nalways preferred(1).")
ipAddressCreated = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 8), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressCreated.setDescription("The value of sysUpTime at the time this entry was created.\nIf this entry was created prior to the last re-\ninitialization of the local network management subsystem,\nthen this object contains a zero value.")
ipAddressLastChanged = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 9), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipAddressLastChanged.setDescription("The value of sysUpTime at the time this entry was last\nupdated.  If this entry was updated prior to the last re-\ninitialization of the local network management subsystem,\nthen this object contains a zero value.")
ipAddressRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 10), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipAddressRowStatus.setDescription("The status of this conceptual row.\n\nThe RowStatus TC requires that this DESCRIPTION clause\nstates under which circumstances other objects in this row\n\n\n\ncan be modified.  The value of this object has no effect on\nwhether other objects in this conceptual row can be\nmodified.\n\nA conceptual row can not be made active until the\nipAddressIfIndex has been set to a valid index.")
ipAddressStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 34, 1, 11), StorageType().clone('volatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipAddressStorageType.setDescription("The storage type for this conceptual row.  If this object\nhas a value of 'permanent', then no other objects are\nrequired to be able to be modified.")
ipNetToPhysicalTable = MibTable((1, 3, 6, 1, 2, 1, 4, 35))
if mibBuilder.loadTexts: ipNetToPhysicalTable.setDescription("The IP Address Translation table used for mapping from IP\naddresses to physical addresses.\n\nThe Address Translation tables contain the IP address to\n'physical' address equivalences.  Some interfaces do not use\ntranslation tables for determining address equivalences\n(e.g., DDN-X.25 has an algorithmic method); if all\ninterfaces are of this type, then the Address Translation\ntable is empty, i.e., has zero entries.\n\nWhile many protocols may be used to populate this table, ARP\nand Neighbor Discovery are the most likely\noptions.")
ipNetToPhysicalEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 35, 1)).setIndexNames((0, "IP-MIB", "ipNetToPhysicalIfIndex"), (0, "IP-MIB", "ipNetToPhysicalNetAddressType"), (0, "IP-MIB", "ipNetToPhysicalNetAddress"))
if mibBuilder.loadTexts: ipNetToPhysicalEntry.setDescription("Each entry contains one IP address to `physical' address\nequivalence.")
ipNetToPhysicalIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipNetToPhysicalIfIndex.setDescription("The index value that uniquely identifies the interface to\nwhich this entry is applicable.  The interface identified by\na particular value of this index is the same interface as\nidentified by the same value of the IF-MIB's ifIndex.")
ipNetToPhysicalNetAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 2), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipNetToPhysicalNetAddressType.setDescription("The type of ipNetToPhysicalNetAddress.")
ipNetToPhysicalNetAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 3), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipNetToPhysicalNetAddress.setDescription("The IP Address corresponding to the media-dependent\n`physical' address.  The address type of this object is\nspecified in ipNetToPhysicalAddressType.\n\nImplementors need to be aware that if the size of\n\n\n\nipNetToPhysicalNetAddress exceeds 115 octets, then OIDS of\ninstances of columns in this row will have more than 128\nsub-identifiers and cannot be accessed using SNMPv1,\nSNMPv2c, or SNMPv3.")
ipNetToPhysicalPhysAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 4), PhysAddress().subtype(subtypeSpec=ValueSizeConstraint(0, 65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToPhysicalPhysAddress.setDescription("The media-dependent `physical' address.\n\nAs the entries in this table are typically not persistent\nwhen this object is written the entity SHOULD NOT save the\nchange to non-volatile storage.")
ipNetToPhysicalLastUpdated = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 5), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipNetToPhysicalLastUpdated.setDescription("The value of sysUpTime at the time this entry was last\nupdated.  If this entry was updated prior to the last re-\ninitialization of the local network management subsystem,\nthen this object contains a zero value.")
ipNetToPhysicalType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(3,2,1,4,5,)).subtype(namedValues=NamedValues(("other", 1), ("invalid", 2), ("dynamic", 3), ("static", 4), ("local", 5), )).clone(4)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToPhysicalType.setDescription("The type of mapping.\n\nSetting this object to the value invalid(2) has the effect\nof invalidating the corresponding entry in the\nipNetToPhysicalTable.  That is, it effectively dis-\nassociates the interface identified with said entry from the\nmapping identified with said entry.  It is an\nimplementation-specific matter as to whether the agent\n\n\n\nremoves an invalidated entry from the table.  Accordingly,\nmanagement stations must be prepared to receive tabular\ninformation from agents that corresponds to entries not\ncurrently in use.  Proper interpretation of such entries\nrequires examination of the relevant ipNetToPhysicalType\nobject.\n\nThe 'dynamic(3)' type indicates that the IP address to\nphysical addresses mapping has been dynamically resolved\nusing e.g., IPv4 ARP or the IPv6 Neighbor Discovery\nprotocol.\n\nThe 'static(4)' type indicates that the mapping has been\nstatically configured.  Both of these refer to entries that\nprovide mappings for other entities addresses.\n\nThe 'local(5)' type indicates that the mapping is provided\nfor an entity's own interface address.\n\nAs the entries in this table are typically not persistent\nwhen this object is written the entity SHOULD NOT save the\nchange to non-volatile storage.")
ipNetToPhysicalState = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 7), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,7,6,2,4,5,)).subtype(namedValues=NamedValues(("reachable", 1), ("stale", 2), ("delay", 3), ("probe", 4), ("invalid", 5), ("unknown", 6), ("incomplete", 7), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipNetToPhysicalState.setDescription("The Neighbor Unreachability Detection state for the\ninterface when the address mapping in this entry is used.\nIf Neighbor Unreachability Detection is not in use (e.g. for\nIPv4), this object is always unknown(6).")
ipNetToPhysicalRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 35, 1, 8), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipNetToPhysicalRowStatus.setDescription("The status of this conceptual row.\n\nThe RowStatus TC requires that this DESCRIPTION clause\nstates under which circumstances other objects in this row\ncan be modified.  The value of this object has no effect on\nwhether other objects in this conceptual row can be\nmodified.\n\nA conceptual row can not be made active until the\nipNetToPhysicalPhysAddress object has been set.\n\nNote that if the ipNetToPhysicalType is set to 'invalid',\nthe managed node may delete the entry independent of the\nstate of this object.")
ipv6ScopeZoneIndexTable = MibTable((1, 3, 6, 1, 2, 1, 4, 36))
if mibBuilder.loadTexts: ipv6ScopeZoneIndexTable.setDescription("The table used to describe IPv6 unicast and multicast scope\nzones.\n\nFor those objects that have names rather than numbers, the\nnames were chosen to coincide with the names used in the\nIPv6 address architecture document. ")
ipv6ScopeZoneIndexEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 36, 1)).setIndexNames((0, "IP-MIB", "ipv6ScopeZoneIndexIfIndex"))
if mibBuilder.loadTexts: ipv6ScopeZoneIndexEntry.setDescription("Each entry contains the list of scope identifiers on a given\ninterface.")
ipv6ScopeZoneIndexIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexIfIndex.setDescription("The index value that uniquely identifies the interface to\nwhich these scopes belong.  The interface identified by a\nparticular value of this index is the same interface as\nidentified by the same value of the IF-MIB's ifIndex.")
ipv6ScopeZoneIndexLinkLocal = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 2), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexLinkLocal.setDescription("The zone index for the link-local scope on this interface.")
ipv6ScopeZoneIndex3 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 3), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndex3.setDescription("The zone index for scope 3 on this interface.")
ipv6ScopeZoneIndexAdminLocal = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 4), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexAdminLocal.setDescription("The zone index for the admin-local scope on this interface.")
ipv6ScopeZoneIndexSiteLocal = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 5), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexSiteLocal.setDescription("The zone index for the site-local scope on this interface.")
ipv6ScopeZoneIndex6 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 6), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndex6.setDescription("The zone index for scope 6 on this interface.")
ipv6ScopeZoneIndex7 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 7), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndex7.setDescription("The zone index for scope 7 on this interface.")
ipv6ScopeZoneIndexOrganizationLocal = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 8), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexOrganizationLocal.setDescription("The zone index for the organization-local scope on this\ninterface.")
ipv6ScopeZoneIndex9 = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 9), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndex9.setDescription("The zone index for scope 9 on this interface.")
ipv6ScopeZoneIndexA = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 10), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexA.setDescription("The zone index for scope A on this interface.")
ipv6ScopeZoneIndexB = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 11), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexB.setDescription("The zone index for scope B on this interface.")
ipv6ScopeZoneIndexC = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 12), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexC.setDescription("The zone index for scope C on this interface.")
ipv6ScopeZoneIndexD = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 36, 1, 13), InetZoneIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipv6ScopeZoneIndexD.setDescription("The zone index for scope D on this interface.")
ipDefaultRouterTable = MibTable((1, 3, 6, 1, 2, 1, 4, 37))
if mibBuilder.loadTexts: ipDefaultRouterTable.setDescription("The table used to describe the default routers known to this\n\n\n\nentity.")
ipDefaultRouterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 37, 1)).setIndexNames((0, "IP-MIB", "ipDefaultRouterAddressType"), (0, "IP-MIB", "ipDefaultRouterAddress"), (0, "IP-MIB", "ipDefaultRouterIfIndex"))
if mibBuilder.loadTexts: ipDefaultRouterEntry.setDescription("Each entry contains information about a default router known\nto this entity.")
ipDefaultRouterAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 37, 1, 1), InetAddressType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipDefaultRouterAddressType.setDescription("The address type for this row.")
ipDefaultRouterAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 37, 1, 2), InetAddress()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipDefaultRouterAddress.setDescription("The IP address of the default router represented by this\nrow.  The address type of this object is specified in\nipDefaultRouterAddressType.\n\nImplementers need to be aware that if the size of\nipDefaultRouterAddress exceeds 115 octets, then OIDS of\ninstances of columns in this row will have more than 128\nsub-identifiers and cannot be accessed using SNMPv1,\nSNMPv2c, or SNMPv3.")
ipDefaultRouterIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 37, 1, 3), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipDefaultRouterIfIndex.setDescription("The index value that uniquely identifies the interface by\nwhich the router can be reached.  The interface identified\nby a particular value of this index is the same interface as\nidentified by the same value of the IF-MIB's ifIndex.")
ipDefaultRouterLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 37, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipDefaultRouterLifetime.setDescription("The remaining length of time, in seconds, that this router\nwill continue to be useful as a default router.  A value of\nzero indicates that it is no longer useful as a default\nrouter.  It is left to the implementer of the MIB as to\nwhether a router with a lifetime of zero is removed from the\nlist.\n\nFor IPv6, this value should be extracted from the router\nadvertisement messages.")
ipDefaultRouterPreference = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 37, 1, 5), Integer().subtype(subtypeSpec=SingleValueConstraint(1,0,-2,-1,)).subtype(namedValues=NamedValues(("low", -1), ("reserved", -2), ("medium", 0), ("high", 1), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ipDefaultRouterPreference.setDescription("An indication of preference given to this router as a\ndefault router as described in he Default Router\nPreferences document.  Treating the value as a\n2 bit signed integer allows for simple arithmetic\ncomparisons.\n\nFor IPv4 routers or IPv6 routers that are not using the\nupdated router advertisement format, this object is set to\nmedium (0).")
ipv6RouterAdvertSpinLock = MibScalar((1, 3, 6, 1, 2, 1, 4, 38), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ipv6RouterAdvertSpinLock.setDescription("An advisory lock used to allow cooperating SNMP managers to\ncoordinate their use of the set operation in creating or\nmodifying rows within this table.\n\nIn order to use this lock to coordinate the use of set\noperations, managers should first retrieve\nipv6RouterAdvertSpinLock.  They should then determine the\nappropriate row to create or modify.  Finally, they should\nissue the appropriate set command including the retrieved\nvalue of ipv6RouterAdvertSpinLock.  If another manager has\naltered the table in the meantime, then the value of\nipv6RouterAdvertSpinLock will have changed and the creation\nwill fail as it will be specifying an incorrect value for\nipv6RouterAdvertSpinLock.  It is suggested, but not\nrequired, that the ipv6RouterAdvertSpinLock be the first var\nbind for each set of objects representing a 'row' in a PDU.")
ipv6RouterAdvertTable = MibTable((1, 3, 6, 1, 2, 1, 4, 39))
if mibBuilder.loadTexts: ipv6RouterAdvertTable.setDescription("The table containing information used to construct router\nadvertisements.")
ipv6RouterAdvertEntry = MibTableRow((1, 3, 6, 1, 2, 1, 4, 39, 1)).setIndexNames((0, "IP-MIB", "ipv6RouterAdvertIfIndex"))
if mibBuilder.loadTexts: ipv6RouterAdvertEntry.setDescription("An entry containing information used to construct router\nadvertisements.\n\nInformation in this table is persistent, and when this\nobject is written, the entity SHOULD save the change to\nnon-volatile storage.")
ipv6RouterAdvertIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 1), InterfaceIndex()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: ipv6RouterAdvertIfIndex.setDescription("The index value that uniquely identifies the interface on\nwhich router advertisements constructed with this\ninformation will be transmitted.  The interface identified\nby a particular value of this index is the same interface as\nidentified by the same value of the IF-MIB's ifIndex.")
ipv6RouterAdvertSendAdverts = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 2), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertSendAdverts.setDescription("A flag indicating whether the router sends periodic\nrouter advertisements and responds to router solicitations\non this interface.")
ipv6RouterAdvertMaxInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(4, 1800)).clone(600)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertMaxInterval.setDescription("The maximum time allowed between sending unsolicited router\n\n\n\nadvertisements from this interface.")
ipv6RouterAdvertMinInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(3, 1350))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertMinInterval.setDescription("The minimum time allowed between sending unsolicited router\nadvertisements from this interface.\n\nThe default is 0.33 * ipv6RouterAdvertMaxInterval, however,\nin the case of a low value for ipv6RouterAdvertMaxInterval,\nthe minimum value for this object is restricted to 3.")
ipv6RouterAdvertManagedFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 5), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertManagedFlag.setDescription("The true/false value to be placed into the 'managed address\nconfiguration' flag field in router advertisements sent from\nthis interface.")
ipv6RouterAdvertOtherConfigFlag = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 6), TruthValue().clone('false')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertOtherConfigFlag.setDescription("The true/false value to be placed into the 'other stateful\nconfiguration' flag field in router advertisements sent from\nthis interface.")
ipv6RouterAdvertLinkMTU = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 7), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertLinkMTU.setDescription("The value to be placed in MTU options sent by the router on\nthis interface.\n\nA value of zero indicates that no MTU options are sent.")
ipv6RouterAdvertReachableTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 8), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 3600000)).clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertReachableTime.setDescription("The value to be placed in the reachable time field in router\nadvertisement messages sent from this interface.\n\nA value of zero in the router advertisement indicates that\nthe advertisement isn't specifying a value for reachable\ntime.")
ipv6RouterAdvertRetransmitTime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 9), Unsigned32().clone(0)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertRetransmitTime.setDescription("The value to be placed in the retransmit timer field in\nrouter advertisements sent from this interface.\n\nA value of zero in the router advertisement indicates that\nthe advertisement isn't specifying a value for retrans\ntime.")
ipv6RouterAdvertCurHopLimit = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertCurHopLimit.setDescription("The default value to be placed in the current hop limit\nfield in router advertisements sent from this interface.\n\n\n\nThe value should be set to the current diameter of the\nInternet.\n\nA value of zero in the router advertisement indicates that\nthe advertisement isn't specifying a value for curHopLimit.\n\nThe default should be set to the value specified in the IANA\nweb pages (www.iana.org) at the time of implementation.")
ipv6RouterAdvertDefaultLifetime = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 11), Unsigned32().subtype(subtypeSpec=ConstraintsUnion(ValueRangeConstraint(0,0),ValueRangeConstraint(4,9000),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertDefaultLifetime.setDescription("The value to be placed in the router lifetime field of\nrouter advertisements sent from this interface.  This value\nMUST be either 0 or between ipv6RouterAdvertMaxInterval and\n9000 seconds.\n\nA value of zero indicates that the router is not to be used\nas a default router.\n\nThe default is 3 * ipv6RouterAdvertMaxInterval.")
ipv6RouterAdvertRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 4, 39, 1, 12), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ipv6RouterAdvertRowStatus.setDescription("The status of this conceptual row.\n\nAs all objects in this conceptual row have default values, a\nrow can be created and made active by setting this object\nappropriately.\n\nThe RowStatus TC requires that this DESCRIPTION clause\nstates under which circumstances other objects in this row\ncan be modified.  The value of this object has no effect on\nwhether other objects in this conceptual row can be\nmodified.")
icmp = MibIdentifier((1, 3, 6, 1, 2, 1, 5))
icmpInMsgs = MibScalar((1, 3, 6, 1, 2, 1, 5, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInMsgs.setDescription("The total number of ICMP messages which the entity received.\nNote that this counter includes all those counted by\nicmpInErrors.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by\nicmpStatsInMsgs.")
icmpInErrors = MibScalar((1, 3, 6, 1, 2, 1, 5, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInErrors.setDescription("The number of ICMP messages which the entity received but\ndetermined as having ICMP-specific errors (bad ICMP\nchecksums, bad length, etc.).\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by\nicmpStatsInErrors.")
icmpInDestUnreachs = MibScalar((1, 3, 6, 1, 2, 1, 5, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInDestUnreachs.setDescription("The number of ICMP Destination Unreachable messages\nreceived.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpInTimeExcds = MibScalar((1, 3, 6, 1, 2, 1, 5, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInTimeExcds.setDescription("The number of ICMP Time Exceeded messages received.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpInParmProbs = MibScalar((1, 3, 6, 1, 2, 1, 5, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInParmProbs.setDescription("The number of ICMP Parameter Problem messages received.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpInSrcQuenchs = MibScalar((1, 3, 6, 1, 2, 1, 5, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInSrcQuenchs.setDescription("The number of ICMP Source Quench messages received.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpInRedirects = MibScalar((1, 3, 6, 1, 2, 1, 5, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInRedirects.setDescription("The number of ICMP Redirect messages received.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpInEchos = MibScalar((1, 3, 6, 1, 2, 1, 5, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInEchos.setDescription("The number of ICMP Echo (request) messages received.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpInEchoReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInEchoReps.setDescription("The number of ICMP Echo Reply messages received.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpInTimestamps = MibScalar((1, 3, 6, 1, 2, 1, 5, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInTimestamps.setDescription("The number of ICMP Timestamp (request) messages received.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpInTimestampReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInTimestampReps.setDescription("The number of ICMP Timestamp Reply messages received.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpInAddrMasks = MibScalar((1, 3, 6, 1, 2, 1, 5, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInAddrMasks.setDescription("The number of ICMP Address Mask Request messages received.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpInAddrMaskReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpInAddrMaskReps.setDescription("The number of ICMP Address Mask Reply messages received.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpOutMsgs = MibScalar((1, 3, 6, 1, 2, 1, 5, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutMsgs.setDescription("The total number of ICMP messages which this entity\nattempted to send.  Note that this counter includes all\nthose counted by icmpOutErrors.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by\nicmpStatsOutMsgs.")
icmpOutErrors = MibScalar((1, 3, 6, 1, 2, 1, 5, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutErrors.setDescription("The number of ICMP messages which this entity did not send\ndue to problems discovered within ICMP, such as a lack of\nbuffers.  This value should not include errors discovered\noutside the ICMP layer, such as the inability of IP to route\nthe resultant datagram.  In some implementations, there may\nbe no types of error which contribute to this counter's\nvalue.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by\nicmpStatsOutErrors.")
icmpOutDestUnreachs = MibScalar((1, 3, 6, 1, 2, 1, 5, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutDestUnreachs.setDescription("The number of ICMP Destination Unreachable messages sent.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpOutTimeExcds = MibScalar((1, 3, 6, 1, 2, 1, 5, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutTimeExcds.setDescription("The number of ICMP Time Exceeded messages sent.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpOutParmProbs = MibScalar((1, 3, 6, 1, 2, 1, 5, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutParmProbs.setDescription("The number of ICMP Parameter Problem messages sent.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpOutSrcQuenchs = MibScalar((1, 3, 6, 1, 2, 1, 5, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutSrcQuenchs.setDescription("The number of ICMP Source Quench messages sent.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpOutRedirects = MibScalar((1, 3, 6, 1, 2, 1, 5, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutRedirects.setDescription("The number of ICMP Redirect messages sent.  For a host, this\nobject will always be zero, since hosts do not send\nredirects.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpOutEchos = MibScalar((1, 3, 6, 1, 2, 1, 5, 21), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutEchos.setDescription("The number of ICMP Echo (request) messages sent.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpOutEchoReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 22), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutEchoReps.setDescription("The number of ICMP Echo Reply messages sent.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpOutTimestamps = MibScalar((1, 3, 6, 1, 2, 1, 5, 23), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutTimestamps.setDescription("The number of ICMP Timestamp (request) messages sent.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpOutTimestampReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 24), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutTimestampReps.setDescription("The number of ICMP Timestamp Reply messages sent.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpOutAddrMasks = MibScalar((1, 3, 6, 1, 2, 1, 5, 25), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutAddrMasks.setDescription("The number of ICMP Address Mask Request messages sent.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpOutAddrMaskReps = MibScalar((1, 3, 6, 1, 2, 1, 5, 26), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpOutAddrMaskReps.setDescription("The number of ICMP Address Mask Reply messages sent.\n\nThis object has been deprecated, as a new IP version-neutral\ntable has been added.  It is loosely replaced by a column in\nthe icmpMsgStatsTable.")
icmpStatsTable = MibTable((1, 3, 6, 1, 2, 1, 5, 29))
if mibBuilder.loadTexts: icmpStatsTable.setDescription("The table of generic system-wide ICMP counters.")
icmpStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 5, 29, 1)).setIndexNames((0, "IP-MIB", "icmpStatsIPVersion"))
if mibBuilder.loadTexts: icmpStatsEntry.setDescription("A conceptual row in the icmpStatsTable.")
icmpStatsIPVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 29, 1, 1), InetVersion()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: icmpStatsIPVersion.setDescription("The IP version of the statistics.")
icmpStatsInMsgs = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 29, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpStatsInMsgs.setDescription("The total number of ICMP messages that the entity received.\nNote that this counter includes all those counted by\nicmpStatsInErrors.")
icmpStatsInErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 29, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpStatsInErrors.setDescription("The number of ICMP messages that the entity received but\ndetermined as having ICMP-specific errors (bad ICMP\nchecksums, bad length, etc.).")
icmpStatsOutMsgs = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 29, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpStatsOutMsgs.setDescription("The total number of ICMP messages that the entity attempted\nto send.  Note that this counter includes all those counted\nby icmpStatsOutErrors.")
icmpStatsOutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 29, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpStatsOutErrors.setDescription("The number of ICMP messages that this entity did not send\ndue to problems discovered within ICMP, such as a lack of\nbuffers.  This value should not include errors discovered\noutside the ICMP layer, such as the inability of IP to route\nthe resultant datagram.  In some implementations, there may\nbe no types of error that contribute to this counter's\nvalue.")
icmpMsgStatsTable = MibTable((1, 3, 6, 1, 2, 1, 5, 30))
if mibBuilder.loadTexts: icmpMsgStatsTable.setDescription("The table of system-wide per-version, per-message type ICMP\ncounters.")
icmpMsgStatsEntry = MibTableRow((1, 3, 6, 1, 2, 1, 5, 30, 1)).setIndexNames((0, "IP-MIB", "icmpMsgStatsIPVersion"), (0, "IP-MIB", "icmpMsgStatsType"))
if mibBuilder.loadTexts: icmpMsgStatsEntry.setDescription("A conceptual row in the icmpMsgStatsTable.\n\nThe system should track each ICMP type value, even if that\nICMP type is not supported by the system.  However, a\ngiven row need not be instantiated unless a message of that\ntype has been processed, i.e., the row for\nicmpMsgStatsType=X MAY be instantiated before but MUST be\ninstantiated after the first message with Type=X is\nreceived or transmitted.  After receiving or transmitting\nany succeeding messages with Type=X, the relevant counter\nmust be incremented.")
icmpMsgStatsIPVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 30, 1, 1), InetVersion()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: icmpMsgStatsIPVersion.setDescription("The IP version of the statistics.")
icmpMsgStatsType = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 30, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0, 255))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: icmpMsgStatsType.setDescription("The ICMP type field of the message type being counted by\nthis row.\n\nNote that ICMP message types are scoped by the address type\nin use.")
icmpMsgStatsInPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 30, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpMsgStatsInPkts.setDescription("The number of input packets for this AF and type.")
icmpMsgStatsOutPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 5, 30, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: icmpMsgStatsOutPkts.setDescription("The number of output packets for this AF and type.")
ipMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 48)).setRevisions(("2006-02-02 00:00","1994-11-01 00:00","1991-03-31 00:00",))
if mibBuilder.loadTexts: ipMIB.setOrganization("IETF IPv6 MIB Revision Team")
if mibBuilder.loadTexts: ipMIB.setContactInfo("Editor:\n\n\n\nShawn A. Routhier\nInterworking Labs\n108 Whispering Pines Dr. Suite 235\nScotts Valley, CA 95066\nUSA\nEMail: <sar@iwl.com>")
if mibBuilder.loadTexts: ipMIB.setDescription("The MIB module for managing IP and ICMP implementations, but\nexcluding their management of IP routes.\n\nCopyright (C) The Internet Society (2006).  This version of\nthis MIB module is part of RFC 4293; see the RFC itself for\nfull legal notices.")
ipMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 48, 2))
ipMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 48, 2, 1))
ipMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 48, 2, 2))

# Augmentions

# Groups

ipGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 1)).setObjects(*(("IP-MIB", "ipInDelivers"), ("IP-MIB", "ipOutDiscards"), ("IP-MIB", "ipForwDatagrams"), ("IP-MIB", "ipReasmFails"), ("IP-MIB", "ipForwarding"), ("IP-MIB", "ipRoutingDiscards"), ("IP-MIB", "ipNetToMediaNetAddress"), ("IP-MIB", "ipNetToMediaType"), ("IP-MIB", "ipInHdrErrors"), ("IP-MIB", "ipFragFails"), ("IP-MIB", "ipAdEntReasmMaxSize"), ("IP-MIB", "ipInReceives"), ("IP-MIB", "ipReasmTimeout"), ("IP-MIB", "ipFragCreates"), ("IP-MIB", "ipAdEntIfIndex"), ("IP-MIB", "ipDefaultTTL"), ("IP-MIB", "ipInUnknownProtos"), ("IP-MIB", "ipReasmOKs"), ("IP-MIB", "ipAdEntAddr"), ("IP-MIB", "ipOutNoRoutes"), ("IP-MIB", "ipNetToMediaIfIndex"), ("IP-MIB", "ipInAddrErrors"), ("IP-MIB", "ipFragOKs"), ("IP-MIB", "ipOutRequests"), ("IP-MIB", "ipNetToMediaPhysAddress"), ("IP-MIB", "ipReasmReqds"), ("IP-MIB", "ipAdEntNetMask"), ("IP-MIB", "ipAdEntBcastAddr"), ("IP-MIB", "ipInDiscards"), ) )
if mibBuilder.loadTexts: ipGroup.setDescription("The ip group of objects providing for basic management of IP\nentities, exclusive of the management of IP routes.\n\n\n\n\nAs part of the version independence, this group has been\ndeprecated.  ")
icmpGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 2)).setObjects(*(("IP-MIB", "icmpOutRedirects"), ("IP-MIB", "icmpOutTimestamps"), ("IP-MIB", "icmpOutAddrMasks"), ("IP-MIB", "icmpInTimestamps"), ("IP-MIB", "icmpInEchos"), ("IP-MIB", "icmpInMsgs"), ("IP-MIB", "icmpInParmProbs"), ("IP-MIB", "icmpOutParmProbs"), ("IP-MIB", "icmpOutTimeExcds"), ("IP-MIB", "icmpInDestUnreachs"), ("IP-MIB", "icmpOutEchoReps"), ("IP-MIB", "icmpOutMsgs"), ("IP-MIB", "icmpOutTimestampReps"), ("IP-MIB", "icmpOutErrors"), ("IP-MIB", "icmpOutDestUnreachs"), ("IP-MIB", "icmpOutSrcQuenchs"), ("IP-MIB", "icmpOutAddrMaskReps"), ("IP-MIB", "icmpInAddrMaskReps"), ("IP-MIB", "icmpInTimeExcds"), ("IP-MIB", "icmpInErrors"), ("IP-MIB", "icmpOutEchos"), ("IP-MIB", "icmpInAddrMasks"), ("IP-MIB", "icmpInRedirects"), ("IP-MIB", "icmpInTimestampReps"), ("IP-MIB", "icmpInSrcQuenchs"), ("IP-MIB", "icmpInEchoReps"), ) )
if mibBuilder.loadTexts: icmpGroup.setDescription("The icmp group of objects providing ICMP statistics.\n\nAs part of the version independence, this group has been\ndeprecated.  ")
ipv4GeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 3)).setObjects(*(("IP-MIB", "ipForwarding"), ("IP-MIB", "ipReasmTimeout"), ("IP-MIB", "ipDefaultTTL"), ) )
if mibBuilder.loadTexts: ipv4GeneralGroup.setDescription("The group of IPv4-specific objects for basic management of\nIPv4 entities.")
ipv4IfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 4)).setObjects(*(("IP-MIB", "ipv4InterfaceEnableStatus"), ("IP-MIB", "ipv4InterfaceRetransmitTime"), ("IP-MIB", "ipv4InterfaceReasmMaxSize"), ) )
if mibBuilder.loadTexts: ipv4IfGroup.setDescription("The group of IPv4-specific objects for basic management of\nIPv4 interfaces.")
ipv6GeneralGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 5)).setObjects(*(("IP-MIB", "ipv6IpForwarding"), ("IP-MIB", "ipv6IpDefaultHopLimit"), ) )
if mibBuilder.loadTexts: ipv6GeneralGroup2.setDescription("The IPv6 group of objects providing for basic management of\nIPv6 entities.")
ipv6IfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 6)).setObjects(*(("IP-MIB", "ipv6InterfaceRetransmitTime"), ("IP-MIB", "ipv6InterfaceReachableTime"), ("IP-MIB", "ipv6InterfaceEnableStatus"), ("IP-MIB", "ipv6InterfaceIdentifier"), ("IP-MIB", "ipv6InterfaceReasmMaxSize"), ("IP-MIB", "ipv6InterfaceForwarding"), ) )
if mibBuilder.loadTexts: ipv6IfGroup.setDescription("The group of IPv6-specific objects for basic management of\nIPv6 interfaces.")
ipLastChangeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 7)).setObjects(*(("IP-MIB", "ipv6InterfaceTableLastChange"), ("IP-MIB", "ipIfStatsTableLastChange"), ("IP-MIB", "ipv4InterfaceTableLastChange"), ) )
if mibBuilder.loadTexts: ipLastChangeGroup.setDescription("The last change objects associated with this MIB.  These\nobjects are optional for all agents.  They SHOULD be\nimplemented on agents where it is possible to determine the\nproper values.  Where it is not possible to determine the\nproper values, for example when the tables are split amongst\nseveral sub-agents using AgentX, the agent MUST NOT\nimplement these objects to return an incorrect or static\nvalue.")
ipSystemStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 8)).setObjects(*(("IP-MIB", "ipSystemStatsOutTransmits"), ("IP-MIB", "ipSystemStatsInMcastOctets"), ("IP-MIB", "ipSystemStatsOutFragOKs"), ("IP-MIB", "ipSystemStatsInTruncatedPkts"), ("IP-MIB", "ipSystemStatsRefreshRate"), ("IP-MIB", "ipSystemStatsInDelivers"), ("IP-MIB", "ipSystemStatsOutRequests"), ("IP-MIB", "ipSystemStatsInMcastPkts"), ("IP-MIB", "ipSystemStatsInHdrErrors"), ("IP-MIB", "ipSystemStatsOutMcastPkts"), ("IP-MIB", "ipSystemStatsReasmFails"), ("IP-MIB", "ipSystemStatsReasmReqds"), ("IP-MIB", "ipSystemStatsInDiscards"), ("IP-MIB", "ipSystemStatsOutNoRoutes"), ("IP-MIB", "ipSystemStatsInReceives"), ("IP-MIB", "ipSystemStatsInUnknownProtos"), ("IP-MIB", "ipSystemStatsDiscontinuityTime"), ("IP-MIB", "ipSystemStatsOutDiscards"), ("IP-MIB", "ipSystemStatsReasmOKs"), ("IP-MIB", "ipSystemStatsInNoRoutes"), ("IP-MIB", "ipSystemStatsOutMcastOctets"), ("IP-MIB", "ipSystemStatsOutFragReqds"), ("IP-MIB", "ipSystemStatsOutFragCreates"), ("IP-MIB", "ipSystemStatsOutFragFails"), ("IP-MIB", "ipSystemStatsOutOctets"), ("IP-MIB", "ipSystemStatsInOctets"), ("IP-MIB", "ipSystemStatsOutForwDatagrams"), ("IP-MIB", "ipSystemStatsInAddrErrors"), ("IP-MIB", "ipSystemStatsInForwDatagrams"), ) )
if mibBuilder.loadTexts: ipSystemStatsGroup.setDescription("IP system wide statistics.")
ipv4SystemStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 9)).setObjects(*(("IP-MIB", "ipSystemStatsInBcastPkts"), ("IP-MIB", "ipSystemStatsOutBcastPkts"), ) )
if mibBuilder.loadTexts: ipv4SystemStatsGroup.setDescription("IPv4 only system wide statistics.")
ipSystemStatsHCOctetGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 10)).setObjects(*(("IP-MIB", "ipSystemStatsHCInOctets"), ("IP-MIB", "ipSystemStatsHCOutOctets"), ("IP-MIB", "ipSystemStatsHCOutMcastOctets"), ("IP-MIB", "ipSystemStatsHCInMcastOctets"), ) )
if mibBuilder.loadTexts: ipSystemStatsHCOctetGroup.setDescription("IP system wide statistics for systems that may overflow the\nstandard octet counters within 1 hour.")
ipSystemStatsHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 11)).setObjects(*(("IP-MIB", "ipSystemStatsHCInReceives"), ("IP-MIB", "ipSystemStatsHCOutTransmits"), ("IP-MIB", "ipSystemStatsHCInForwDatagrams"), ("IP-MIB", "ipSystemStatsHCInDelivers"), ("IP-MIB", "ipSystemStatsHCOutForwDatagrams"), ("IP-MIB", "ipSystemStatsHCOutMcastPkts"), ("IP-MIB", "ipSystemStatsHCOutRequests"), ("IP-MIB", "ipSystemStatsHCInMcastPkts"), ) )
if mibBuilder.loadTexts: ipSystemStatsHCPacketGroup.setDescription("IP system wide statistics for systems that may overflow the\nstandard packet counters within 1 hour.")
ipv4SystemStatsHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 12)).setObjects(*(("IP-MIB", "ipSystemStatsHCInBcastPkts"), ("IP-MIB", "ipSystemStatsHCOutBcastPkts"), ) )
if mibBuilder.loadTexts: ipv4SystemStatsHCPacketGroup.setDescription("IPv4 only system wide statistics for systems that may\noverflow the standard packet counters within 1 hour.")
ipIfStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 13)).setObjects(*(("IP-MIB", "ipIfStatsOutFragOKs"), ("IP-MIB", "ipIfStatsRefreshRate"), ("IP-MIB", "ipIfStatsOutFragFails"), ("IP-MIB", "ipIfStatsInReceives"), ("IP-MIB", "ipIfStatsOutFragReqds"), ("IP-MIB", "ipIfStatsOutMcastPkts"), ("IP-MIB", "ipIfStatsOutForwDatagrams"), ("IP-MIB", "ipIfStatsOutMcastOctets"), ("IP-MIB", "ipIfStatsInNoRoutes"), ("IP-MIB", "ipIfStatsReasmOKs"), ("IP-MIB", "ipIfStatsInMcastPkts"), ("IP-MIB", "ipIfStatsDiscontinuityTime"), ("IP-MIB", "ipIfStatsOutDiscards"), ("IP-MIB", "ipIfStatsInAddrErrors"), ("IP-MIB", "ipIfStatsInHdrErrors"), ("IP-MIB", "ipIfStatsInOctets"), ("IP-MIB", "ipIfStatsInTruncatedPkts"), ("IP-MIB", "ipIfStatsOutRequests"), ("IP-MIB", "ipIfStatsInDiscards"), ("IP-MIB", "ipIfStatsInDelivers"), ("IP-MIB", "ipIfStatsOutFragCreates"), ("IP-MIB", "ipIfStatsReasmReqds"), ("IP-MIB", "ipIfStatsInForwDatagrams"), ("IP-MIB", "ipIfStatsInUnknownProtos"), ("IP-MIB", "ipIfStatsReasmFails"), ("IP-MIB", "ipIfStatsOutOctets"), ("IP-MIB", "ipIfStatsInMcastOctets"), ("IP-MIB", "ipIfStatsOutTransmits"), ) )
if mibBuilder.loadTexts: ipIfStatsGroup.setDescription("IP per-interface statistics.")
ipv4IfStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 14)).setObjects(*(("IP-MIB", "ipIfStatsInBcastPkts"), ("IP-MIB", "ipIfStatsOutBcastPkts"), ) )
if mibBuilder.loadTexts: ipv4IfStatsGroup.setDescription("IPv4 only per-interface statistics.")
ipIfStatsHCOctetGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 15)).setObjects(*(("IP-MIB", "ipIfStatsHCOutOctets"), ("IP-MIB", "ipIfStatsHCInMcastOctets"), ("IP-MIB", "ipIfStatsHCOutMcastOctets"), ("IP-MIB", "ipIfStatsHCInOctets"), ) )
if mibBuilder.loadTexts: ipIfStatsHCOctetGroup.setDescription("IP per-interfaces statistics for systems that include\ninterfaces that may overflow the standard octet\ncounters within 1 hour.")
ipIfStatsHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 16)).setObjects(*(("IP-MIB", "ipIfStatsHCOutTransmits"), ("IP-MIB", "ipIfStatsHCInReceives"), ("IP-MIB", "ipIfStatsHCInMcastPkts"), ("IP-MIB", "ipIfStatsHCOutForwDatagrams"), ("IP-MIB", "ipIfStatsHCOutRequests"), ("IP-MIB", "ipIfStatsHCInForwDatagrams"), ("IP-MIB", "ipIfStatsHCInDelivers"), ("IP-MIB", "ipIfStatsHCOutMcastPkts"), ) )
if mibBuilder.loadTexts: ipIfStatsHCPacketGroup.setDescription("IP per-interfaces statistics for systems that include\ninterfaces that may overflow the standard packet counters\nwithin 1 hour.")
ipv4IfStatsHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 17)).setObjects(*(("IP-MIB", "ipIfStatsHCOutBcastPkts"), ("IP-MIB", "ipIfStatsHCInBcastPkts"), ) )
if mibBuilder.loadTexts: ipv4IfStatsHCPacketGroup.setDescription("IPv4 only per-interface statistics for systems that include\ninterfaces that may overflow the standard packet counters\nwithin 1 hour.")
ipAddressPrefixGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 18)).setObjects(*(("IP-MIB", "ipAddressPrefixOnLinkFlag"), ("IP-MIB", "ipAddressPrefixOrigin"), ("IP-MIB", "ipAddressPrefixAdvValidLifetime"), ("IP-MIB", "ipAddressPrefixAutonomousFlag"), ("IP-MIB", "ipAddressPrefixAdvPreferredLifetime"), ) )
if mibBuilder.loadTexts: ipAddressPrefixGroup.setDescription("The group of objects for providing information about address\nprefixes used by this node.")
ipAddressGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 19)).setObjects(*(("IP-MIB", "ipAddressType"), ("IP-MIB", "ipAddressStorageType"), ("IP-MIB", "ipAddressCreated"), ("IP-MIB", "ipAddressOrigin"), ("IP-MIB", "ipAddressSpinLock"), ("IP-MIB", "ipAddressIfIndex"), ("IP-MIB", "ipAddressLastChanged"), ("IP-MIB", "ipAddressStatus"), ("IP-MIB", "ipAddressPrefix"), ("IP-MIB", "ipAddressRowStatus"), ) )
if mibBuilder.loadTexts: ipAddressGroup.setDescription("The group of objects for providing information about the\naddresses relevant to this entity's interfaces.")
ipNetToPhysicalGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 20)).setObjects(*(("IP-MIB", "ipNetToPhysicalPhysAddress"), ("IP-MIB", "ipNetToPhysicalType"), ("IP-MIB", "ipNetToPhysicalRowStatus"), ("IP-MIB", "ipNetToPhysicalState"), ("IP-MIB", "ipNetToPhysicalLastUpdated"), ) )
if mibBuilder.loadTexts: ipNetToPhysicalGroup.setDescription("The group of objects for providing information about the\nmappings of network address to physical address known to\nthis node.")
ipv6ScopeGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 21)).setObjects(*(("IP-MIB", "ipv6ScopeZoneIndexAdminLocal"), ("IP-MIB", "ipv6ScopeZoneIndex6"), ("IP-MIB", "ipv6ScopeZoneIndexA"), ("IP-MIB", "ipv6ScopeZoneIndex9"), ("IP-MIB", "ipv6ScopeZoneIndexB"), ("IP-MIB", "ipv6ScopeZoneIndexC"), ("IP-MIB", "ipv6ScopeZoneIndexD"), ("IP-MIB", "ipv6ScopeZoneIndexLinkLocal"), ("IP-MIB", "ipv6ScopeZoneIndexSiteLocal"), ("IP-MIB", "ipv6ScopeZoneIndex3"), ("IP-MIB", "ipv6ScopeZoneIndexOrganizationLocal"), ("IP-MIB", "ipv6ScopeZoneIndex7"), ) )
if mibBuilder.loadTexts: ipv6ScopeGroup.setDescription("The group of objects for managing IPv6 scope zones.")
ipDefaultRouterGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 22)).setObjects(*(("IP-MIB", "ipDefaultRouterPreference"), ("IP-MIB", "ipDefaultRouterLifetime"), ) )
if mibBuilder.loadTexts: ipDefaultRouterGroup.setDescription("The group of objects for providing information about default\nrouters known to this node.")
ipv6RouterAdvertGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 23)).setObjects(*(("IP-MIB", "ipv6RouterAdvertLinkMTU"), ("IP-MIB", "ipv6RouterAdvertRowStatus"), ("IP-MIB", "ipv6RouterAdvertRetransmitTime"), ("IP-MIB", "ipv6RouterAdvertMinInterval"), ("IP-MIB", "ipv6RouterAdvertSpinLock"), ("IP-MIB", "ipv6RouterAdvertMaxInterval"), ("IP-MIB", "ipv6RouterAdvertDefaultLifetime"), ("IP-MIB", "ipv6RouterAdvertSendAdverts"), ("IP-MIB", "ipv6RouterAdvertReachableTime"), ("IP-MIB", "ipv6RouterAdvertOtherConfigFlag"), ("IP-MIB", "ipv6RouterAdvertManagedFlag"), ("IP-MIB", "ipv6RouterAdvertCurHopLimit"), ) )
if mibBuilder.loadTexts: ipv6RouterAdvertGroup.setDescription("The group of objects for controlling information advertised\nby IPv6 routers.")
icmpStatsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 48, 2, 2, 24)).setObjects(*(("IP-MIB", "icmpMsgStatsInPkts"), ("IP-MIB", "icmpStatsInMsgs"), ("IP-MIB", "icmpStatsInErrors"), ("IP-MIB", "icmpMsgStatsOutPkts"), ("IP-MIB", "icmpStatsOutMsgs"), ("IP-MIB", "icmpStatsOutErrors"), ) )
if mibBuilder.loadTexts: icmpStatsGroup.setDescription("The group of objects providing ICMP statistics.")

# Compliances

ipMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 48, 2, 1, 1)).setObjects(*(("IP-MIB", "icmpGroup"), ("IP-MIB", "ipGroup"), ) )
if mibBuilder.loadTexts: ipMIBCompliance.setDescription("The compliance statement for systems that implement only\nIPv4.  For version-independence, this compliance statement\nis deprecated in favor of ipMIBCompliance2.")
ipMIBCompliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 48, 2, 1, 2)).setObjects(*(("IP-MIB", "ipSystemStatsHCPacketGroup"), ("IP-MIB", "ipv6ScopeGroup"), ("IP-MIB", "ipDefaultRouterGroup"), ("IP-MIB", "ipLastChangeGroup"), ("IP-MIB", "ipNetToPhysicalGroup"), ("IP-MIB", "ipv6GeneralGroup2"), ("IP-MIB", "ipSystemStatsGroup"), ("IP-MIB", "ipSystemStatsHCOctetGroup"), ("IP-MIB", "icmpStatsGroup"), ("IP-MIB", "ipv4SystemStatsGroup"), ("IP-MIB", "ipAddressPrefixGroup"), ("IP-MIB", "ipv6IfGroup"), ("IP-MIB", "ipv4SystemStatsHCPacketGroup"), ("IP-MIB", "ipv6RouterAdvertGroup"), ("IP-MIB", "ipv4IfStatsHCPacketGroup"), ("IP-MIB", "ipAddressGroup"), ("IP-MIB", "ipIfStatsGroup"), ("IP-MIB", "ipIfStatsHCPacketGroup"), ("IP-MIB", "ipv4GeneralGroup"), ("IP-MIB", "ipv4IfGroup"), ("IP-MIB", "ipIfStatsHCOctetGroup"), ("IP-MIB", "ipv4IfStatsGroup"), ) )
if mibBuilder.loadTexts: ipMIBCompliance2.setDescription("The compliance statement for systems that implement IP -\neither IPv4 or IPv6.\n\nThere are a number of INDEX objects that cannot be\nrepresented in the form of OBJECT clauses in SMIv2, but\nfor which we have the following compliance requirements,\nexpressed in OBJECT clause form in this description\nclause:\n\n\n\n\n-- OBJECT        ipSystemStatsIPVersion\n-- SYNTAX        InetVersion {ipv4(1), ipv6(2)}\n-- DESCRIPTION\n--     This MIB requires support for only IPv4 and IPv6\n--     versions.\n--\n-- OBJECT        ipIfStatsIPVersion\n-- SYNTAX        InetVersion {ipv4(1), ipv6(2)}\n-- DESCRIPTION\n--     This MIB requires support for only IPv4 and IPv6\n--     versions.\n--\n-- OBJECT        icmpStatsIPVersion\n-- SYNTAX        InetVersion {ipv4(1), ipv6(2)}\n-- DESCRIPTION\n--     This MIB requires support for only IPv4 and IPv6\n--     versions.\n--\n-- OBJECT        icmpMsgStatsIPVersion\n-- SYNTAX        InetVersion {ipv4(1), ipv6(2)}\n-- DESCRIPTION\n--     This MIB requires support for only IPv4 and IPv6\n--     versions.\n--\n-- OBJECT        ipAddressPrefixType\n-- SYNTAX        InetAddressType {ipv4(1), ipv6(2)}\n-- DESCRIPTION\n--     This MIB requires support for only global IPv4 and\n--     IPv6 address types.\n--\n-- OBJECT        ipAddressPrefixPrefix\n-- SYNTAX        InetAddress (Size(4 | 16))\n-- DESCRIPTION\n--     This MIB requires support for only global IPv4 and\n--     IPv6 addresses and so the size can be either 4 or\n--     16 bytes.\n--\n-- OBJECT        ipAddressAddrType\n-- SYNTAX        InetAddressType {ipv4(1), ipv6(2),\n--                                ipv4z(3), ipv6z(4)}\n-- DESCRIPTION\n--     This MIB requires support for only global and\n--     non-global IPv4 and IPv6 address types.\n--\n-- OBJECT        ipAddressAddr\n-- SYNTAX        InetAddress (Size(4 | 8 | 16 | 20))\n-- DESCRIPTION\n--     This MIB requires support for only global and\n\n\n\n--     non-global IPv4 and IPv6 addresses and so the size\n--     can be 4, 8, 16, or 20 bytes.\n--\n-- OBJECT        ipNetToPhysicalNetAddressType\n-- SYNTAX        InetAddressType {ipv4(1), ipv6(2),\n--                                ipv4z(3), ipv6z(4)}\n-- DESCRIPTION\n--     This MIB requires support for only global and\n--     non-global IPv4 and IPv6 address types.\n--\n-- OBJECT        ipNetToPhysicalNetAddress\n-- SYNTAX        InetAddress (Size(4 | 8 | 16 | 20))\n-- DESCRIPTION\n--     This MIB requires support for only global and\n--     non-global IPv4 and IPv6 addresses and so the size\n--     can be 4, 8, 16, or 20 bytes.\n--\n-- OBJECT        ipDefaultRouterAddressType\n-- SYNTAX        InetAddressType {ipv4(1), ipv6(2),\n--                                ipv4z(3), ipv6z(4)}\n-- DESCRIPTION\n--     This MIB requires support for only global and\n--     non-global IPv4 and IPv6 address types.\n--\n-- OBJECT        ipDefaultRouterAddress\n-- SYNTAX        InetAddress (Size(4 | 8 | 16 | 20))\n-- DESCRIPTION\n--     This MIB requires support for only global and\n--     non-global IPv4 and IPv6 addresses and so the size\n--     can be 4, 8, 16, or 20 bytes.")

# Exports

# Module identity
mibBuilder.exportSymbols("IP-MIB", PYSNMP_MODULE_ID=ipMIB)

# Types
mibBuilder.exportSymbols("IP-MIB", IpAddressOriginTC=IpAddressOriginTC, IpAddressPrefixOriginTC=IpAddressPrefixOriginTC, IpAddressStatusTC=IpAddressStatusTC, Ipv6AddressIfIdentifierTC=Ipv6AddressIfIdentifierTC)

# Objects
mibBuilder.exportSymbols("IP-MIB", ip=ip, ipForwarding=ipForwarding, ipDefaultTTL=ipDefaultTTL, ipInReceives=ipInReceives, ipInHdrErrors=ipInHdrErrors, ipInAddrErrors=ipInAddrErrors, ipForwDatagrams=ipForwDatagrams, ipInUnknownProtos=ipInUnknownProtos, ipInDiscards=ipInDiscards, ipInDelivers=ipInDelivers, ipOutRequests=ipOutRequests, ipOutDiscards=ipOutDiscards, ipOutNoRoutes=ipOutNoRoutes, ipReasmTimeout=ipReasmTimeout, ipReasmReqds=ipReasmReqds, ipReasmOKs=ipReasmOKs, ipReasmFails=ipReasmFails, ipFragOKs=ipFragOKs, ipFragFails=ipFragFails, ipFragCreates=ipFragCreates, ipAddrTable=ipAddrTable, ipAddrEntry=ipAddrEntry, ipAdEntAddr=ipAdEntAddr, ipAdEntIfIndex=ipAdEntIfIndex, ipAdEntNetMask=ipAdEntNetMask, ipAdEntBcastAddr=ipAdEntBcastAddr, ipAdEntReasmMaxSize=ipAdEntReasmMaxSize, ipNetToMediaTable=ipNetToMediaTable, ipNetToMediaEntry=ipNetToMediaEntry, ipNetToMediaIfIndex=ipNetToMediaIfIndex, ipNetToMediaPhysAddress=ipNetToMediaPhysAddress, ipNetToMediaNetAddress=ipNetToMediaNetAddress, ipNetToMediaType=ipNetToMediaType, ipRoutingDiscards=ipRoutingDiscards, ipv6IpForwarding=ipv6IpForwarding, ipv6IpDefaultHopLimit=ipv6IpDefaultHopLimit, ipv4InterfaceTableLastChange=ipv4InterfaceTableLastChange, ipv4InterfaceTable=ipv4InterfaceTable, ipv4InterfaceEntry=ipv4InterfaceEntry, ipv4InterfaceIfIndex=ipv4InterfaceIfIndex, ipv4InterfaceReasmMaxSize=ipv4InterfaceReasmMaxSize, ipv4InterfaceEnableStatus=ipv4InterfaceEnableStatus, ipv4InterfaceRetransmitTime=ipv4InterfaceRetransmitTime, ipv6InterfaceTableLastChange=ipv6InterfaceTableLastChange, ipv6InterfaceTable=ipv6InterfaceTable, ipv6InterfaceEntry=ipv6InterfaceEntry, ipv6InterfaceIfIndex=ipv6InterfaceIfIndex, ipv6InterfaceReasmMaxSize=ipv6InterfaceReasmMaxSize, ipv6InterfaceIdentifier=ipv6InterfaceIdentifier, ipv6InterfaceEnableStatus=ipv6InterfaceEnableStatus, ipv6InterfaceReachableTime=ipv6InterfaceReachableTime, ipv6InterfaceRetransmitTime=ipv6InterfaceRetransmitTime, ipv6InterfaceForwarding=ipv6InterfaceForwarding, ipTrafficStats=ipTrafficStats, ipSystemStatsTable=ipSystemStatsTable, ipSystemStatsEntry=ipSystemStatsEntry, ipSystemStatsIPVersion=ipSystemStatsIPVersion, ipSystemStatsInReceives=ipSystemStatsInReceives, ipSystemStatsHCInReceives=ipSystemStatsHCInReceives, ipSystemStatsInOctets=ipSystemStatsInOctets, ipSystemStatsHCInOctets=ipSystemStatsHCInOctets, ipSystemStatsInHdrErrors=ipSystemStatsInHdrErrors, ipSystemStatsInNoRoutes=ipSystemStatsInNoRoutes, ipSystemStatsInAddrErrors=ipSystemStatsInAddrErrors, ipSystemStatsInUnknownProtos=ipSystemStatsInUnknownProtos, ipSystemStatsInTruncatedPkts=ipSystemStatsInTruncatedPkts, ipSystemStatsInForwDatagrams=ipSystemStatsInForwDatagrams, ipSystemStatsHCInForwDatagrams=ipSystemStatsHCInForwDatagrams, ipSystemStatsReasmReqds=ipSystemStatsReasmReqds, ipSystemStatsReasmOKs=ipSystemStatsReasmOKs, ipSystemStatsReasmFails=ipSystemStatsReasmFails, ipSystemStatsInDiscards=ipSystemStatsInDiscards, ipSystemStatsInDelivers=ipSystemStatsInDelivers, ipSystemStatsHCInDelivers=ipSystemStatsHCInDelivers, ipSystemStatsOutRequests=ipSystemStatsOutRequests, ipSystemStatsHCOutRequests=ipSystemStatsHCOutRequests, ipSystemStatsOutNoRoutes=ipSystemStatsOutNoRoutes, ipSystemStatsOutForwDatagrams=ipSystemStatsOutForwDatagrams, ipSystemStatsHCOutForwDatagrams=ipSystemStatsHCOutForwDatagrams, ipSystemStatsOutDiscards=ipSystemStatsOutDiscards, ipSystemStatsOutFragReqds=ipSystemStatsOutFragReqds, ipSystemStatsOutFragOKs=ipSystemStatsOutFragOKs, ipSystemStatsOutFragFails=ipSystemStatsOutFragFails, ipSystemStatsOutFragCreates=ipSystemStatsOutFragCreates, ipSystemStatsOutTransmits=ipSystemStatsOutTransmits, ipSystemStatsHCOutTransmits=ipSystemStatsHCOutTransmits, ipSystemStatsOutOctets=ipSystemStatsOutOctets, ipSystemStatsHCOutOctets=ipSystemStatsHCOutOctets, ipSystemStatsInMcastPkts=ipSystemStatsInMcastPkts, ipSystemStatsHCInMcastPkts=ipSystemStatsHCInMcastPkts, ipSystemStatsInMcastOctets=ipSystemStatsInMcastOctets, ipSystemStatsHCInMcastOctets=ipSystemStatsHCInMcastOctets, ipSystemStatsOutMcastPkts=ipSystemStatsOutMcastPkts, ipSystemStatsHCOutMcastPkts=ipSystemStatsHCOutMcastPkts, ipSystemStatsOutMcastOctets=ipSystemStatsOutMcastOctets, ipSystemStatsHCOutMcastOctets=ipSystemStatsHCOutMcastOctets, ipSystemStatsInBcastPkts=ipSystemStatsInBcastPkts, ipSystemStatsHCInBcastPkts=ipSystemStatsHCInBcastPkts, ipSystemStatsOutBcastPkts=ipSystemStatsOutBcastPkts, ipSystemStatsHCOutBcastPkts=ipSystemStatsHCOutBcastPkts, ipSystemStatsDiscontinuityTime=ipSystemStatsDiscontinuityTime, ipSystemStatsRefreshRate=ipSystemStatsRefreshRate, ipIfStatsTableLastChange=ipIfStatsTableLastChange, ipIfStatsTable=ipIfStatsTable, ipIfStatsEntry=ipIfStatsEntry, ipIfStatsIPVersion=ipIfStatsIPVersion, ipIfStatsIfIndex=ipIfStatsIfIndex, ipIfStatsInReceives=ipIfStatsInReceives, ipIfStatsHCInReceives=ipIfStatsHCInReceives, ipIfStatsInOctets=ipIfStatsInOctets, ipIfStatsHCInOctets=ipIfStatsHCInOctets, ipIfStatsInHdrErrors=ipIfStatsInHdrErrors, ipIfStatsInNoRoutes=ipIfStatsInNoRoutes, ipIfStatsInAddrErrors=ipIfStatsInAddrErrors, ipIfStatsInUnknownProtos=ipIfStatsInUnknownProtos, ipIfStatsInTruncatedPkts=ipIfStatsInTruncatedPkts, ipIfStatsInForwDatagrams=ipIfStatsInForwDatagrams, ipIfStatsHCInForwDatagrams=ipIfStatsHCInForwDatagrams, ipIfStatsReasmReqds=ipIfStatsReasmReqds, ipIfStatsReasmOKs=ipIfStatsReasmOKs, ipIfStatsReasmFails=ipIfStatsReasmFails, ipIfStatsInDiscards=ipIfStatsInDiscards, ipIfStatsInDelivers=ipIfStatsInDelivers, ipIfStatsHCInDelivers=ipIfStatsHCInDelivers, ipIfStatsOutRequests=ipIfStatsOutRequests, ipIfStatsHCOutRequests=ipIfStatsHCOutRequests)
mibBuilder.exportSymbols("IP-MIB", ipIfStatsOutForwDatagrams=ipIfStatsOutForwDatagrams, ipIfStatsHCOutForwDatagrams=ipIfStatsHCOutForwDatagrams, ipIfStatsOutDiscards=ipIfStatsOutDiscards, ipIfStatsOutFragReqds=ipIfStatsOutFragReqds, ipIfStatsOutFragOKs=ipIfStatsOutFragOKs, ipIfStatsOutFragFails=ipIfStatsOutFragFails, ipIfStatsOutFragCreates=ipIfStatsOutFragCreates, ipIfStatsOutTransmits=ipIfStatsOutTransmits, ipIfStatsHCOutTransmits=ipIfStatsHCOutTransmits, ipIfStatsOutOctets=ipIfStatsOutOctets, ipIfStatsHCOutOctets=ipIfStatsHCOutOctets, ipIfStatsInMcastPkts=ipIfStatsInMcastPkts, ipIfStatsHCInMcastPkts=ipIfStatsHCInMcastPkts, ipIfStatsInMcastOctets=ipIfStatsInMcastOctets, ipIfStatsHCInMcastOctets=ipIfStatsHCInMcastOctets, ipIfStatsOutMcastPkts=ipIfStatsOutMcastPkts, ipIfStatsHCOutMcastPkts=ipIfStatsHCOutMcastPkts, ipIfStatsOutMcastOctets=ipIfStatsOutMcastOctets, ipIfStatsHCOutMcastOctets=ipIfStatsHCOutMcastOctets, ipIfStatsInBcastPkts=ipIfStatsInBcastPkts, ipIfStatsHCInBcastPkts=ipIfStatsHCInBcastPkts, ipIfStatsOutBcastPkts=ipIfStatsOutBcastPkts, ipIfStatsHCOutBcastPkts=ipIfStatsHCOutBcastPkts, ipIfStatsDiscontinuityTime=ipIfStatsDiscontinuityTime, ipIfStatsRefreshRate=ipIfStatsRefreshRate, ipAddressPrefixTable=ipAddressPrefixTable, ipAddressPrefixEntry=ipAddressPrefixEntry, ipAddressPrefixIfIndex=ipAddressPrefixIfIndex, ipAddressPrefixType=ipAddressPrefixType, ipAddressPrefixPrefix=ipAddressPrefixPrefix, ipAddressPrefixLength=ipAddressPrefixLength, ipAddressPrefixOrigin=ipAddressPrefixOrigin, ipAddressPrefixOnLinkFlag=ipAddressPrefixOnLinkFlag, ipAddressPrefixAutonomousFlag=ipAddressPrefixAutonomousFlag, ipAddressPrefixAdvPreferredLifetime=ipAddressPrefixAdvPreferredLifetime, ipAddressPrefixAdvValidLifetime=ipAddressPrefixAdvValidLifetime, ipAddressSpinLock=ipAddressSpinLock, ipAddressTable=ipAddressTable, ipAddressEntry=ipAddressEntry, ipAddressAddrType=ipAddressAddrType, ipAddressAddr=ipAddressAddr, ipAddressIfIndex=ipAddressIfIndex, ipAddressType=ipAddressType, ipAddressPrefix=ipAddressPrefix, ipAddressOrigin=ipAddressOrigin, ipAddressStatus=ipAddressStatus, ipAddressCreated=ipAddressCreated, ipAddressLastChanged=ipAddressLastChanged, ipAddressRowStatus=ipAddressRowStatus, ipAddressStorageType=ipAddressStorageType, ipNetToPhysicalTable=ipNetToPhysicalTable, ipNetToPhysicalEntry=ipNetToPhysicalEntry, ipNetToPhysicalIfIndex=ipNetToPhysicalIfIndex, ipNetToPhysicalNetAddressType=ipNetToPhysicalNetAddressType, ipNetToPhysicalNetAddress=ipNetToPhysicalNetAddress, ipNetToPhysicalPhysAddress=ipNetToPhysicalPhysAddress, ipNetToPhysicalLastUpdated=ipNetToPhysicalLastUpdated, ipNetToPhysicalType=ipNetToPhysicalType, ipNetToPhysicalState=ipNetToPhysicalState, ipNetToPhysicalRowStatus=ipNetToPhysicalRowStatus, ipv6ScopeZoneIndexTable=ipv6ScopeZoneIndexTable, ipv6ScopeZoneIndexEntry=ipv6ScopeZoneIndexEntry, ipv6ScopeZoneIndexIfIndex=ipv6ScopeZoneIndexIfIndex, ipv6ScopeZoneIndexLinkLocal=ipv6ScopeZoneIndexLinkLocal, ipv6ScopeZoneIndex3=ipv6ScopeZoneIndex3, ipv6ScopeZoneIndexAdminLocal=ipv6ScopeZoneIndexAdminLocal, ipv6ScopeZoneIndexSiteLocal=ipv6ScopeZoneIndexSiteLocal, ipv6ScopeZoneIndex6=ipv6ScopeZoneIndex6, ipv6ScopeZoneIndex7=ipv6ScopeZoneIndex7, ipv6ScopeZoneIndexOrganizationLocal=ipv6ScopeZoneIndexOrganizationLocal, ipv6ScopeZoneIndex9=ipv6ScopeZoneIndex9, ipv6ScopeZoneIndexA=ipv6ScopeZoneIndexA, ipv6ScopeZoneIndexB=ipv6ScopeZoneIndexB, ipv6ScopeZoneIndexC=ipv6ScopeZoneIndexC, ipv6ScopeZoneIndexD=ipv6ScopeZoneIndexD, ipDefaultRouterTable=ipDefaultRouterTable, ipDefaultRouterEntry=ipDefaultRouterEntry, ipDefaultRouterAddressType=ipDefaultRouterAddressType, ipDefaultRouterAddress=ipDefaultRouterAddress, ipDefaultRouterIfIndex=ipDefaultRouterIfIndex, ipDefaultRouterLifetime=ipDefaultRouterLifetime, ipDefaultRouterPreference=ipDefaultRouterPreference, ipv6RouterAdvertSpinLock=ipv6RouterAdvertSpinLock, ipv6RouterAdvertTable=ipv6RouterAdvertTable, ipv6RouterAdvertEntry=ipv6RouterAdvertEntry, ipv6RouterAdvertIfIndex=ipv6RouterAdvertIfIndex, ipv6RouterAdvertSendAdverts=ipv6RouterAdvertSendAdverts, ipv6RouterAdvertMaxInterval=ipv6RouterAdvertMaxInterval, ipv6RouterAdvertMinInterval=ipv6RouterAdvertMinInterval, ipv6RouterAdvertManagedFlag=ipv6RouterAdvertManagedFlag, ipv6RouterAdvertOtherConfigFlag=ipv6RouterAdvertOtherConfigFlag, ipv6RouterAdvertLinkMTU=ipv6RouterAdvertLinkMTU, ipv6RouterAdvertReachableTime=ipv6RouterAdvertReachableTime, ipv6RouterAdvertRetransmitTime=ipv6RouterAdvertRetransmitTime, ipv6RouterAdvertCurHopLimit=ipv6RouterAdvertCurHopLimit, ipv6RouterAdvertDefaultLifetime=ipv6RouterAdvertDefaultLifetime, ipv6RouterAdvertRowStatus=ipv6RouterAdvertRowStatus, icmp=icmp, icmpInMsgs=icmpInMsgs, icmpInErrors=icmpInErrors, icmpInDestUnreachs=icmpInDestUnreachs, icmpInTimeExcds=icmpInTimeExcds, icmpInParmProbs=icmpInParmProbs, icmpInSrcQuenchs=icmpInSrcQuenchs, icmpInRedirects=icmpInRedirects, icmpInEchos=icmpInEchos, icmpInEchoReps=icmpInEchoReps, icmpInTimestamps=icmpInTimestamps, icmpInTimestampReps=icmpInTimestampReps, icmpInAddrMasks=icmpInAddrMasks, icmpInAddrMaskReps=icmpInAddrMaskReps, icmpOutMsgs=icmpOutMsgs, icmpOutErrors=icmpOutErrors, icmpOutDestUnreachs=icmpOutDestUnreachs, icmpOutTimeExcds=icmpOutTimeExcds, icmpOutParmProbs=icmpOutParmProbs, icmpOutSrcQuenchs=icmpOutSrcQuenchs, icmpOutRedirects=icmpOutRedirects, icmpOutEchos=icmpOutEchos, icmpOutEchoReps=icmpOutEchoReps, icmpOutTimestamps=icmpOutTimestamps, icmpOutTimestampReps=icmpOutTimestampReps, icmpOutAddrMasks=icmpOutAddrMasks, icmpOutAddrMaskReps=icmpOutAddrMaskReps, icmpStatsTable=icmpStatsTable, icmpStatsEntry=icmpStatsEntry, icmpStatsIPVersion=icmpStatsIPVersion)
mibBuilder.exportSymbols("IP-MIB", icmpStatsInMsgs=icmpStatsInMsgs, icmpStatsInErrors=icmpStatsInErrors, icmpStatsOutMsgs=icmpStatsOutMsgs, icmpStatsOutErrors=icmpStatsOutErrors, icmpMsgStatsTable=icmpMsgStatsTable, icmpMsgStatsEntry=icmpMsgStatsEntry, icmpMsgStatsIPVersion=icmpMsgStatsIPVersion, icmpMsgStatsType=icmpMsgStatsType, icmpMsgStatsInPkts=icmpMsgStatsInPkts, icmpMsgStatsOutPkts=icmpMsgStatsOutPkts, ipMIB=ipMIB, ipMIBConformance=ipMIBConformance, ipMIBCompliances=ipMIBCompliances, ipMIBGroups=ipMIBGroups)

# Groups
mibBuilder.exportSymbols("IP-MIB", ipGroup=ipGroup, icmpGroup=icmpGroup, ipv4GeneralGroup=ipv4GeneralGroup, ipv4IfGroup=ipv4IfGroup, ipv6GeneralGroup2=ipv6GeneralGroup2, ipv6IfGroup=ipv6IfGroup, ipLastChangeGroup=ipLastChangeGroup, ipSystemStatsGroup=ipSystemStatsGroup, ipv4SystemStatsGroup=ipv4SystemStatsGroup, ipSystemStatsHCOctetGroup=ipSystemStatsHCOctetGroup, ipSystemStatsHCPacketGroup=ipSystemStatsHCPacketGroup, ipv4SystemStatsHCPacketGroup=ipv4SystemStatsHCPacketGroup, ipIfStatsGroup=ipIfStatsGroup, ipv4IfStatsGroup=ipv4IfStatsGroup, ipIfStatsHCOctetGroup=ipIfStatsHCOctetGroup, ipIfStatsHCPacketGroup=ipIfStatsHCPacketGroup, ipv4IfStatsHCPacketGroup=ipv4IfStatsHCPacketGroup, ipAddressPrefixGroup=ipAddressPrefixGroup, ipAddressGroup=ipAddressGroup, ipNetToPhysicalGroup=ipNetToPhysicalGroup, ipv6ScopeGroup=ipv6ScopeGroup, ipDefaultRouterGroup=ipDefaultRouterGroup, ipv6RouterAdvertGroup=ipv6RouterAdvertGroup, icmpStatsGroup=icmpStatsGroup)

# Compliances
mibBuilder.exportSymbols("IP-MIB", ipMIBCompliance=ipMIBCompliance, ipMIBCompliance2=ipMIBCompliance2)
