#
# PySNMP MIB module IF-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/IF-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:03:47 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, Integer, ObjectIdentifier, ) = mibBuilder.importSymbols("ASN1", "OctetString", "Integer", "ObjectIdentifier")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ValueRangeConstraint, ValueSizeConstraint, ConstraintsUnion, ConstraintsIntersection, SingleValueConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueRangeConstraint", "ValueSizeConstraint", "ConstraintsUnion", "ConstraintsIntersection", "SingleValueConstraint")
( IANAifType, ) = mibBuilder.importSymbols("IANAifType-MIB", "IANAifType")
( NotificationGroup, ObjectGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ObjectGroup", "ModuleCompliance")
( snmpTraps, ) = mibBuilder.importSymbols("SNMPv2-MIB", "snmpTraps")
( Gauge32, MibScalar, MibTable, MibTableRow, MibTableColumn, NotificationType, MibIdentifier, Bits, Unsigned32, ObjectIdentity, ModuleIdentity, TimeTicks, Counter64, IpAddress, Integer32, Counter32, mib_2, iso, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Gauge32", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "NotificationType", "MibIdentifier", "Bits", "Unsigned32", "ObjectIdentity", "ModuleIdentity", "TimeTicks", "Counter64", "IpAddress", "Integer32", "Counter32", "mib-2", "iso")
( RowStatus, AutonomousType, TextualConvention, TimeStamp, TruthValue, DisplayString, TestAndIncr, PhysAddress, ) = mibBuilder.importSymbols("SNMPv2-TC", "RowStatus", "AutonomousType", "TextualConvention", "TimeStamp", "TruthValue", "DisplayString", "TestAndIncr", "PhysAddress")
ifMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 31)).setRevisions(("1996-02-28 21:55", "1993-11-08 21:55",))
if mibBuilder.loadTexts: ifMIB.setLastUpdated('9611031355Z')
if mibBuilder.loadTexts: ifMIB.setOrganization('IETF Interfaces MIB Working Group')
if mibBuilder.loadTexts: ifMIB.setContactInfo('   Keith McCloghrie\n                   Cisco Systems, Inc.\n                   170 West Tasman Drive\n                   San Jose, CA  95134-1706\n                   US\n\n                   408-526-5260\n                   kzm@cisco.com')
if mibBuilder.loadTexts: ifMIB.setDescription("The MIB module to describe generic objects for\n               network interface sub-layers.  This MIB is an updated\n               version of MIB-II's ifTable, and incorporates the\n               extensions defined in RFC 1229.\n               ")
ifMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 31, 1))
interfaces = MibIdentifier((1, 3, 6, 1, 2, 1, 2))
class OwnerString(OctetString, TextualConvention):
    displayHint = '255a'
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,255)

class InterfaceIndex(Integer32, TextualConvention):
    displayHint = 'd'
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(1,2147483647)

class InterfaceIndexOrZero(Integer32, TextualConvention):
    displayHint = 'd'
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,2147483647)

ifNumber = MibScalar((1, 3, 6, 1, 2, 1, 2, 1), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifNumber.setDescription('The number of network interfaces (regardless of their\n               current state) present on this system.')
ifTableLastChange = MibScalar((1, 3, 6, 1, 2, 1, 31, 1, 5), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifTableLastChange.setDescription('The value of sysUpTime at the time of the last\n               creation or deletion of an entry in the ifTable.  If\n               the number of entries has been unchanged since the\n               last re-initialization of the local network management\n               subsystem, then this object contains a zero value.')
ifTable = MibTable((1, 3, 6, 1, 2, 1, 2, 2), )
if mibBuilder.loadTexts: ifTable.setDescription('A list of interface entries.  The number of entries\n               is given by the value of ifNumber.')
ifEntry = MibTableRow((1, 3, 6, 1, 2, 1, 2, 2, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"))
if mibBuilder.loadTexts: ifEntry.setDescription('An entry containing management information applicable\n               to a particular interface.')
ifIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 1), InterfaceIndex()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifIndex.setDescription("A unique value, greater than zero, for each\n               interface.  It is recommended that values are assigned\n               contiguously starting from 1.  The value for each\n               interface sub-layer must remain constant at least from\n               one re-initialization of the entity's network\n               management system to the next re-initialization.")
ifDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 2), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifDescr.setDescription('A textual string containing information about the\n               interface.  This string should include the name of the\n               manufacturer, the product name and the version of the\n               interface hardware/software.')
ifType = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 3), IANAifType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifType.setDescription('The type of interface.  Additional values for ifType\n               are assigned by the Internet Assigned Numbers\n               Authority (IANA), through updating the syntax of the\n               IANAifType textual convention.')
ifMtu = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 4), Integer32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifMtu.setDescription('The size of the largest packet which can be\n               sent/received on the interface, specified in octets.\n               For interfaces that are used for transmitting network\n               datagrams, this is the size of the largest network\n               datagram that can be sent on the interface.')
ifSpeed = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifSpeed.setDescription("An estimate of the interface's current bandwidth in\n               bits per second.  For interfaces which do not vary in\n               bandwidth or for those where no accurate estimation\n               can be made, this object should contain the nominal\n               bandwidth.  If the bandwidth of the interface is\n               greater than the maximum value reportable by this\n               object then this object should report its maximum\n               value (4,294,967,295) and ifHighSpeed must be used to\n               report the interace's speed.  For a sub-layer which\n               has no concept of bandwidth, this object should be\n               zero.")
ifPhysAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 6), PhysAddress()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifPhysAddress.setDescription("The interface's address at its protocol sub-layer.\n               For example, for an 802.x interface, this object\n               normally contains a MAC address.  The interface's\n               media-specific MIB must define the bit and byte\n               ordering and the format of the value of this object.\n               For interfaces which do not have such an address\n               (e.g., a serial line), this object should contain an\n               octet string of zero length.")
ifAdminStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("up", 1), ("down", 2), ("testing", 3),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifAdminStatus.setDescription('The desired state of the interface.  The testing(3)\n               state indicates that no operational packets can be\n               passed.  When a managed system initializes, all\n               interfaces start with ifAdminStatus in the down(2)\n               state.  As a result of either explicit management\n               action or per configuration information retained by\n               the managed system, ifAdminStatus is then changed to\n               either the up(1) or testing(3) states (or remains in\n               the down(2) state).')
ifOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 8), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7,))).clone(namedValues=NamedValues(("up", 1), ("down", 2), ("testing", 3), ("unknown", 4), ("dormant", 5), ("notPresent", 6), ("lowerLayerDown", 7),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOperStatus.setDescription('The current operational state of the interface.  The\n               testing(3) state indicates that no operational packets\n               can be passed.  If ifAdminStatus is down(2) then\n               ifOperStatus should be down(2).  If ifAdminStatus is\n               changed to up(1) then ifOperStatus should change to\n               up(1) if the interface is ready to transmit and\n               receive network traffic; it should change to\n               dormant(5) if the interface is waiting for external\n               actions (such as a serial line waiting for an incoming\n               connection); it should remain in the down(2) state if\n               and only if there is a fault that prevents it from\n               going to the up(1) state; it should remain in the\n               notPresent(6) state if the interface has missing\n               (typically, hardware) components.')
ifLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 9), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifLastChange.setDescription('The value of sysUpTime at the time the interface\n               entered its current operational state.  If the current\n               state was entered prior to the last re-initialization\n               of the local network management subsystem, then this\n               object contains a zero value.')
ifInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInOctets.setDescription('The total number of octets received on the interface,\n               including framing characters.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifInUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInUcastPkts.setDescription('The number of packets, delivered by this sub-layer to\n               a higher (sub-)layer, which were not addressed to a\n               multicast or broadcast address at this sub-layer.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifInNUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInNUcastPkts.setDescription('The number of packets, delivered by this sub-layer to\n               a higher (sub-)layer, which were addressed to a\n               multicast or broadcast address at this sub-layer.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.\n\n               This object is deprecated in favour of\n               ifInMulticastPkts and ifInBroadcastPkts.')
ifInDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInDiscards.setDescription('The number of inbound packets which were chosen to be\n               discarded even though no errors had been detected to\n               prevent their being deliverable to a higher-layer\n               protocol.  One possible reason for discarding such a\n               packet could be to free up buffer space.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifInErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInErrors.setDescription('For packet-oriented interfaces, the number of inbound\n               packets that contained errors preventing them from\n               being deliverable to a higher-layer protocol.  For\n               character-oriented or fixed-length interfaces, the\n               number of inbound transmission units that contained\n               errors preventing them from being deliverable to a\n               higher-layer protocol.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifInUnknownProtos = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 15), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInUnknownProtos.setDescription('For packet-oriented interfaces, the number of packets\n               received via the interface which were discarded\n               because of an unknown or unsupported protocol.  For\n               character-oriented or fixed-length interfaces that\n               support protocol multiplexing the number of\n               transmission units received via the interface which\n               were discarded because of an unknown or unsupported\n               protocol.  For any interface that does not support\n               protocol multiplexing, this counter will always be 0.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutOctets.setDescription('The total number of octets transmitted out of the\n               interface, including framing characters.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifOutUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutUcastPkts.setDescription('The total number of packets that higher-level\n               protocols requested be transmitted, and which were not\n               addressed to a multicast or broadcast address at this\n               sub-layer, including those that were discarded or not\n               sent.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifOutNUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutNUcastPkts.setDescription('The total number of packets that higher-level\n               protocols requested be transmitted, and which were\n               addressed to a multicast or broadcast address at this\n               sub-layer, including those that were discarded or not\n               sent.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.\n\n               This object is deprecated in favour of\n               ifOutMulticastPkts and ifOutBroadcastPkts.')
ifOutDiscards = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutDiscards.setDescription('The number of outbound packets which were chosen to\n               be discarded even though no errors had been detected\n               to prevent their being transmitted.  One possible\n               reason for discarding such a packet could be to free\n               up buffer space.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifOutErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 20), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutErrors.setDescription('For packet-oriented interfaces, the number of\n               outbound packets that could not be transmitted because\n               of errors.  For character-oriented or fixed-length\n               interfaces, the number of outbound transmission units\n               that could not be transmitted because of errors.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifOutQLen = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 21), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutQLen.setDescription('The length of the output packet queue (in packets).')
ifSpecific = MibTableColumn((1, 3, 6, 1, 2, 1, 2, 2, 1, 22), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifSpecific.setDescription('A reference to MIB definitions specific to the\n               particular media being used to realize the interface.\n               It is recommended that this value point to an instance\n               of a MIB object in the media-specific MIB, i.e., that\n               this object have the semantics associated with the\n               InstancePointer textual convention defined in RFC\n               1903.  In fact, it is recommended that the media-\n               specific MIB specify what value ifSpecific should/can\n               take for values of ifType.  If no MIB definitions\n               specific to the particular media are available, the\n               value should be set to the OBJECT IDENTIFIER { 0 0 }.')
ifXTable = MibTable((1, 3, 6, 1, 2, 1, 31, 1, 1), )
if mibBuilder.loadTexts: ifXTable.setDescription('A list of interface entries.  The number of entries\n               is given by the value of ifNumber.  This table\n               contains additional objects for the interface table.')
ifXEntry = MibTableRow((1, 3, 6, 1, 2, 1, 31, 1, 1, 1), )
ifEntry.registerAugmentions(("IF-MIB", "ifXEntry"))
ifXEntry.setIndexNames(*ifEntry.getIndexNames())
if mibBuilder.loadTexts: ifXEntry.setDescription('An entry containing additional management information\n               applicable to a particular interface.')
ifName = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 1), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifName.setDescription("The textual name of the interface.  The value of this\n               object should be the name of the interface as assigned\n               by the local device and should be suitable for use in\n               commands entered at the device's `console'.  This\n               might be a text name, such as `le0' or a simple port\n               number, such as `1', depending on the interface naming\n               syntax of the device.  If several entries in the\n               ifTable together represent a single interface as named\n               by the device, then each will have the same value of\n               ifName.  Note that for an agent which responds to SNMP\n               queries concerning an interface on some other\n               (proxied) device, then the value of ifName for such an\n               interface is the proxied device's local name for it.\n\n               If there is no local name, or this object is otherwise\n               not applicable, then this object contains a zero-\n               length string.")
ifInMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInMulticastPkts.setDescription('The number of packets, delivered by this sub-layer to\n               a higher (sub-)layer, which were addressed to a\n               multicast address at this sub-layer.  For a MAC layer\n               protocol, this includes both Group and Functional\n               addresses.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifInBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifInBroadcastPkts.setDescription('The number of packets, delivered by this sub-layer to\n               a higher (sub-)layer, which were addressed to a\n               broadcast address at this sub-layer.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifOutMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutMulticastPkts.setDescription('The total number of packets that higher-level\n               protocols requested be transmitted, and which were\n               addressed to a multicast address at this sub-layer,\n               including those that were discarded or not sent.  For\n               a MAC layer protocol, this includes both Group and\n               Functional addresses.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifOutBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 5), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifOutBroadcastPkts.setDescription('The total number of packets that higher-level\n               protocols requested be transmitted, and which were\n               addressed to a broadcast address at this sub-layer,\n               including those that were discarded or not sent.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifHCInOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 6), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHCInOctets.setDescription('The total number of octets received on the interface,\n               including framing characters.  This object is a 64-bit\n               version of ifInOctets.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifHCInUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 7), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHCInUcastPkts.setDescription('The number of packets, delivered by this sub-layer to\n               a higher (sub-)layer, which were not addressed to a\n               multicast or broadcast address at this sub-layer.\n               This object is a 64-bit version of ifInUcastPkts.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifHCInMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 8), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHCInMulticastPkts.setDescription('The number of packets, delivered by this sub-layer to\n               a higher (sub-)layer, which were addressed to a\n               multicast address at this sub-layer.  For a MAC layer\n               protocol, this includes both Group and Functional\n               addresses.  This object is a 64-bit version of\n               ifInMulticastPkts.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifHCInBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 9), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHCInBroadcastPkts.setDescription('The number of packets, delivered by this sub-layer to\n               a higher (sub-)layer, which were addressed to a\n               broadcast address at this sub-layer.  This object is a\n               64-bit version of ifInBroadcastPkts.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifHCOutOctets = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 10), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHCOutOctets.setDescription('The total number of octets transmitted out of the\n               interface, including framing characters.  This object\n               is a 64-bit version of ifOutOctets.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifHCOutUcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 11), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHCOutUcastPkts.setDescription('The total number of packets that higher-level\n               protocols requested be transmitted, and which were not\n               addressed to a multicast or broadcast address at this\n               sub-layer, including those that were discarded or not\n               sent.  This object is a 64-bit version of\n               ifOutUcastPkts.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifHCOutMulticastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 12), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHCOutMulticastPkts.setDescription('The total number of packets that higher-level\n               protocols requested be transmitted, and which were\n               addressed to a multicast address at this sub-layer,\n               including those that were discarded or not sent.  For\n               a MAC layer protocol, this includes both Group and\n               Functional addresses.  This object is a 64-bit version\n               of ifOutMulticastPkts.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifHCOutBroadcastPkts = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 13), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHCOutBroadcastPkts.setDescription('The total number of packets that higher-level\n               protocols requested be transmitted, and which were\n               addressed to a broadcast address at this sub-layer,\n               including those that were discarded or not sent.  This\n               object is a 64-bit version of ifOutBroadcastPkts.\n\n               Discontinuities in the value of this counter can occur\n               at re-initialization of the management system, and at\n               other times as indicated by the value of\n               ifCounterDiscontinuityTime.')
ifLinkUpDownTrapEnable = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 14), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("enabled", 1), ("disabled", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifLinkUpDownTrapEnable.setDescription("Indicates whether linkUp/linkDown traps should be\n               generated for this interface.\n\n               By default, this object should have the value\n               enabled(1) for interfaces which do not operate on\n               'top' of any other interface (as defined in the\n               ifStackTable), and disabled(2) otherwise.")
ifHighSpeed = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 15), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifHighSpeed.setDescription("An estimate of the interface's current bandwidth in\n               units of 1,000,000 bits per second.  If this object\n               reports a value of `n' then the speed of the interface\n               is somewhere in the range of `n-500,000' to\n               `n+499,999'.  For interfaces which do not vary in\n               bandwidth or for those where no accurate estimation\n               can be made, this object should contain the nominal\n               bandwidth.  For a sub-layer which has no concept of\n               bandwidth, this object should be zero.")
ifPromiscuousMode = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 16), TruthValue()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifPromiscuousMode.setDescription('This object has a value of false(2) if this interface\n               only accepts packets/frames that are addressed to this\n               station.  This object has a value of true(1) when the\n               station accepts all packets/frames transmitted on the\n               media.  The value true(1) is only legal on certain\n               types of media.  If legal, setting this object to a\n               value of true(1) may require the interface to be reset\n               before becoming effective.\n\n               The value of ifPromiscuousMode does not affect the\n               reception of broadcast and multicast packets/frames by\n               the interface.')
ifConnectorPresent = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 17), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifConnectorPresent.setDescription("This object has the value 'true(1)' if the interface\n               sublayer has a physical connector and the value\n               'false(2)' otherwise.")
ifAlias = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 18), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,242))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifAlias.setDescription("This object is an 'alias' name for the interface as\n               specified by a network manager, and provides a non-\n               volatile 'handle' for the interface.\n\n               On the first instantiation of an interface, the value\n               of ifAlias associated with that interface is the\n               zero-length string.  As and when a value is written\n               into an instance of ifAlias through a network\n               management set operation, then the agent must retain\n               the supplied value in the ifAlias instance associated\n               with the same interface for as long as that interface\n               remains instantiated, including across all re-\n               initializations/reboots of the network management\n               system, including those which result in a change of\n               the interface's ifIndex value.\n\n               An example of the value which a network manager might\n               store in this object for a WAN interface is the\n               (Telco's) circuit number/identifier of the interface.\n\n               Some agents may support write-access only for\n               interfaces having particular values of ifType.  An\n               agent which supports write access to this object is\n               required to keep the value in non-volatile storage,\n               but it may limit the length of new values depending on\n               how much storage is already occupied by the current\n               values for other interfaces.")
ifCounterDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 1, 1, 19), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifCounterDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at\n               which any one or more of this interface's counters\n               suffered a discontinuity.  The relevant counters are\n               the specific instances associated with this interface\n               of any Counter32 or Counter64 object contained in the\n               ifTable or ifXTable.  If no such discontinuities have\n               occurred since the last re-initialization of the local\n               management subsystem, then this object contains a zero\n               value.")
ifStackTable = MibTable((1, 3, 6, 1, 2, 1, 31, 1, 2), )
if mibBuilder.loadTexts: ifStackTable.setDescription("The table containing information on the relationships\n               between the multiple sub-layers of network interfaces.\n               In particular, it contains information on which sub-\n               layers run 'on top of' which other sub-layers, where\n               each sub-layer corresponds to a conceptual row in the\n               ifTable.  For example, when the sub-layer with ifIndex\n               value x runs over the sub-layer with ifIndex value y,\n               then this table contains:\n\n                 ifStackStatus.x.y=active\n\n               For each ifIndex value, I, which identifies an active\n               interface, there are always at least two instantiated\n               rows in this table associated with I.  For one of\n               these rows, I is the value of ifStackHigherLayer; for\n               the other, I is the value of ifStackLowerLayer.  (If I\n               is not involved in multiplexing, then these are the\n               only two rows associated with I.)\n\n               For example, two rows exist even for an interface\n               which has no others stacked on top or below it:\n\n                 ifStackStatus.0.x=active\n                 ifStackStatus.x.0=active ")
ifStackEntry = MibTableRow((1, 3, 6, 1, 2, 1, 31, 1, 2, 1), ).setIndexNames((0, "IF-MIB", "ifStackHigherLayer"), (0, "IF-MIB", "ifStackLowerLayer"))
if mibBuilder.loadTexts: ifStackEntry.setDescription("Information on a particular relationship between two\n               sub-layers, specifying that one sub-layer runs on\n               'top' of the other sub-layer.  Each sub-layer\n               corresponds to a conceptual row in the ifTable.")
ifStackHigherLayer = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 2, 1, 1), Integer32())
if mibBuilder.loadTexts: ifStackHigherLayer.setDescription("The value of ifIndex corresponding to the higher\n               sub-layer of the relationship, i.e., the sub-layer\n               which runs on 'top' of the sub-layer identified by the\n               corresponding instance of ifStackLowerLayer.  If there\n               is no higher sub-layer (below the internetwork layer),\n               then this object has the value 0.")
ifStackLowerLayer = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 2, 1, 2), Integer32())
if mibBuilder.loadTexts: ifStackLowerLayer.setDescription("The value of ifIndex corresponding to the lower sub-\n               layer of the relationship, i.e., the sub-layer which\n               runs 'below' the sub-layer identified by the\n               corresponding instance of ifStackHigherLayer.  If\n               there is no lower sub-layer, then this object has the\n               value 0.")
ifStackStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 2, 1, 3), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ifStackStatus.setDescription("The status of the relationship between two sub-\n               layers.\n\n               Changing the value of this object from 'active' to\n               'notInService' or 'destroy' will likely have\n               consequences up and down the interface stack.  Thus,\n               write access to this object is likely to be\n               inappropriate for some types of interfaces, and many\n               implementations will choose not to support write-\n               access for any type of interface.")
ifStackLastChange = MibScalar((1, 3, 6, 1, 2, 1, 31, 1, 6), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifStackLastChange.setDescription('The value of sysUpTime at the time of the last change\n               of the (whole) interface stack.  A change of the\n               interface stack is defined to be any creation,\n               deletion, or change in value of any instance of\n               ifStackStatus.  If the interface stack has been\n               unchanged since the last re-initialization of the\n               local network management subsystem, then this object\n               contains a zero value.')
ifRcvAddressTable = MibTable((1, 3, 6, 1, 2, 1, 31, 1, 4), )
if mibBuilder.loadTexts: ifRcvAddressTable.setDescription('This table contains an entry for each address\n               (broadcast, multicast, or uni-cast) for which the\n               system will receive packets/frames on a particular\n               interface, except as follows:\n\n               - for an interface operating in promiscuous mode,\n               entries are only required for those addresses for\n               which the system would receive frames were it not\n               operating in promiscuous mode.\n\n               - for 802.5 functional addresses, only one entry is\n               required, for the address which has the functional\n               address bit ANDed with the bit mask of all functional\n               addresses for which the interface will accept frames.\n\n               A system is normally able to use any unicast address\n               which corresponds to an entry in this table as a\n               source address.')
ifRcvAddressEntry = MibTableRow((1, 3, 6, 1, 2, 1, 31, 1, 4, 1), ).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "IF-MIB", "ifRcvAddressAddress"))
if mibBuilder.loadTexts: ifRcvAddressEntry.setDescription('A list of objects identifying an address for which\n               the system will accept packets/frames on the\n               particular interface identified by the index value\n               ifIndex.')
ifRcvAddressAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 4, 1, 1), PhysAddress())
if mibBuilder.loadTexts: ifRcvAddressAddress.setDescription("An address for which the system will accept\n               packets/frames on this entry's interface.")
ifRcvAddressStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 4, 1, 2), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ifRcvAddressStatus.setDescription('This object is used to create and delete rows in the\n               ifRcvAddressTable.')
ifRcvAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 4, 1, 3), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3,))).clone(namedValues=NamedValues(("other", 1), ("volatile", 2), ("nonVolatile", 3),)).clone('volatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: ifRcvAddressType.setDescription('This object has the value nonVolatile(3) for those\n               entries in the table which are valid and will not be\n               deleted by the next restart of the managed system.\n               Entries having the value volatile(2) are valid and\n               exist, but have not been saved, so that will not exist\n               after the next restart of the managed system.  Entries\n               having the value other(1) are valid and exist but are\n               not classified as to whether they will continue to\n               exist after the next restart.')
linkDown = NotificationType((1, 3, 6, 1, 6, 3, 1, 1, 5, 3)).setObjects(*(("IF-MIB", "ifIndex"), ("IF-MIB", "ifAdminStatus"), ("IF-MIB", "ifOperStatus"), ("IF-MIB", "ifDescr"),))
if mibBuilder.loadTexts: linkDown.setDescription('A linkDown trap signifies that the SNMPv2 entity,\n               acting in an agent role, has detected that the\n               ifOperStatus object for one of its communication links\n               is about to enter the down state from some other state\n               (but not from the notPresent state).  This other state\n               is indicated by the included value of ifOperStatus.')
linkUp = NotificationType((1, 3, 6, 1, 6, 3, 1, 1, 5, 4)).setObjects(*(("IF-MIB", "ifIndex"), ("IF-MIB", "ifAdminStatus"), ("IF-MIB", "ifOperStatus"), ("IF-MIB", "ifDescr"),))
if mibBuilder.loadTexts: linkUp.setDescription('A linkUp trap signifies that the SNMPv2 entity,\n               acting in an agent role, has detected that the\n               ifOperStatus object for one of its communication links\n               left the down state and transitioned into some other\n               state (but not into the notPresent state).  This other\n               state is indicated by the included value of\n               ifOperStatus.')
ifConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 31, 2))
ifGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 31, 2, 1))
ifCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 31, 2, 2))
ifCompliance2 = ModuleCompliance((1, 3, 6, 1, 2, 1, 31, 2, 2, 2)).setObjects(*(("IF-MIB", "ifGeneralInformationGroup"), ("IF-MIB", "ifStackGroup2"), ("IF-MIB", "ifCounterDiscontinuityGroup"), ("IF-MIB", "ifFixedLengthGroup"), ("IF-MIB", "ifHCFixedLengthGroup"), ("IF-MIB", "ifPacketGroup"), ("IF-MIB", "ifHCPacketGroup"), ("IF-MIB", "ifRcvAddressGroup"),))
if mibBuilder.loadTexts: ifCompliance2.setDescription('The compliance statement for SNMPv2 entities which\n               have network interfaces.')
ifGeneralInformationGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 10)).setObjects(*(("IF-MIB", "ifIndex"), ("IF-MIB", "ifDescr"), ("IF-MIB", "ifType"), ("IF-MIB", "ifSpeed"), ("IF-MIB", "ifPhysAddress"), ("IF-MIB", "ifAdminStatus"), ("IF-MIB", "ifOperStatus"), ("IF-MIB", "ifLastChange"), ("IF-MIB", "ifLinkUpDownTrapEnable"), ("IF-MIB", "ifConnectorPresent"), ("IF-MIB", "ifHighSpeed"), ("IF-MIB", "ifName"), ("IF-MIB", "ifNumber"), ("IF-MIB", "ifAlias"), ("IF-MIB", "ifTableLastChange"),))
if mibBuilder.loadTexts: ifGeneralInformationGroup.setDescription('A collection of objects providing information\n               applicable to all network interfaces.')
ifFixedLengthGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 2)).setObjects(*(("IF-MIB", "ifInOctets"), ("IF-MIB", "ifOutOctets"), ("IF-MIB", "ifInUnknownProtos"), ("IF-MIB", "ifInErrors"), ("IF-MIB", "ifOutErrors"),))
if mibBuilder.loadTexts: ifFixedLengthGroup.setDescription('A collection of objects providing information\n               specific to non-high speed (non-high speed interfaces\n               transmit and receive at speeds less than or equal to\n               20,000,000 bits/second) character-oriented or fixed-\n               length-transmission network interfaces.')
ifHCFixedLengthGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 3)).setObjects(*(("IF-MIB", "ifHCInOctets"), ("IF-MIB", "ifHCOutOctets"), ("IF-MIB", "ifInOctets"), ("IF-MIB", "ifOutOctets"), ("IF-MIB", "ifInUnknownProtos"), ("IF-MIB", "ifInErrors"), ("IF-MIB", "ifOutErrors"),))
if mibBuilder.loadTexts: ifHCFixedLengthGroup.setDescription('A collection of objects providing information\n               specific to high speed (greater than 20,000,000\n               bits/second) character-oriented or fixed-length-\n               transmission network interfaces.')
ifPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 4)).setObjects(*(("IF-MIB", "ifInOctets"), ("IF-MIB", "ifOutOctets"), ("IF-MIB", "ifInUnknownProtos"), ("IF-MIB", "ifInErrors"), ("IF-MIB", "ifOutErrors"), ("IF-MIB", "ifMtu"), ("IF-MIB", "ifInUcastPkts"), ("IF-MIB", "ifInMulticastPkts"), ("IF-MIB", "ifInBroadcastPkts"), ("IF-MIB", "ifInDiscards"), ("IF-MIB", "ifOutUcastPkts"), ("IF-MIB", "ifOutMulticastPkts"), ("IF-MIB", "ifOutBroadcastPkts"), ("IF-MIB", "ifOutDiscards"), ("IF-MIB", "ifPromiscuousMode"),))
if mibBuilder.loadTexts: ifPacketGroup.setDescription('A collection of objects providing information\n               specific to non-high speed (non-high speed interfaces\n               transmit and receive at speeds less than or equal to\n               20,000,000 bits/second) packet-oriented network\n               interfaces.')
ifHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 5)).setObjects(*(("IF-MIB", "ifHCInOctets"), ("IF-MIB", "ifHCOutOctets"), ("IF-MIB", "ifInOctets"), ("IF-MIB", "ifOutOctets"), ("IF-MIB", "ifInUnknownProtos"), ("IF-MIB", "ifInErrors"), ("IF-MIB", "ifOutErrors"), ("IF-MIB", "ifMtu"), ("IF-MIB", "ifInUcastPkts"), ("IF-MIB", "ifInMulticastPkts"), ("IF-MIB", "ifInBroadcastPkts"), ("IF-MIB", "ifInDiscards"), ("IF-MIB", "ifOutUcastPkts"), ("IF-MIB", "ifOutMulticastPkts"), ("IF-MIB", "ifOutBroadcastPkts"), ("IF-MIB", "ifOutDiscards"), ("IF-MIB", "ifPromiscuousMode"),))
if mibBuilder.loadTexts: ifHCPacketGroup.setDescription('A collection of objects providing information\n               specific to high speed (greater than 20,000,000\n               bits/second but less than or equal to 650,000,000\n               bits/second) packet-oriented network interfaces.')
ifVHCPacketGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 6)).setObjects(*(("IF-MIB", "ifHCInUcastPkts"), ("IF-MIB", "ifHCInMulticastPkts"), ("IF-MIB", "ifHCInBroadcastPkts"), ("IF-MIB", "ifHCOutUcastPkts"), ("IF-MIB", "ifHCOutMulticastPkts"), ("IF-MIB", "ifHCOutBroadcastPkts"), ("IF-MIB", "ifHCInOctets"), ("IF-MIB", "ifHCOutOctets"), ("IF-MIB", "ifInOctets"), ("IF-MIB", "ifOutOctets"), ("IF-MIB", "ifInUnknownProtos"), ("IF-MIB", "ifInErrors"), ("IF-MIB", "ifOutErrors"), ("IF-MIB", "ifMtu"), ("IF-MIB", "ifInUcastPkts"), ("IF-MIB", "ifInMulticastPkts"), ("IF-MIB", "ifInBroadcastPkts"), ("IF-MIB", "ifInDiscards"), ("IF-MIB", "ifOutUcastPkts"), ("IF-MIB", "ifOutMulticastPkts"), ("IF-MIB", "ifOutBroadcastPkts"), ("IF-MIB", "ifOutDiscards"), ("IF-MIB", "ifPromiscuousMode"),))
if mibBuilder.loadTexts: ifVHCPacketGroup.setDescription('A collection of objects providing information\n               specific to higher speed (greater than 650,000,000\n               bits/second) packet-oriented network interfaces.')
ifRcvAddressGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 7)).setObjects(*(("IF-MIB", "ifRcvAddressStatus"), ("IF-MIB", "ifRcvAddressType"),))
if mibBuilder.loadTexts: ifRcvAddressGroup.setDescription('A collection of objects providing information on the\n               multiple addresses which an interface receives.')
ifStackGroup2 = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 11)).setObjects(*(("IF-MIB", "ifStackStatus"), ("IF-MIB", "ifStackLastChange"),))
if mibBuilder.loadTexts: ifStackGroup2.setDescription('A collection of objects providing information on the\n               layering of MIB-II interfaces.')
ifCounterDiscontinuityGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 13)).setObjects(*(("IF-MIB", "ifCounterDiscontinuityTime"),))
if mibBuilder.loadTexts: ifCounterDiscontinuityGroup.setDescription('A collection of objects providing information\n               specific to interface counter discontinuities.')
ifTestTable = MibTable((1, 3, 6, 1, 2, 1, 31, 1, 3), )
if mibBuilder.loadTexts: ifTestTable.setDescription("This table contains one entry per interface.  It\n               defines objects which allow a network manager to\n               instruct an agent to test an interface for various\n               faults.  Tests for an interface are defined in the\n               media-specific MIB for that interface.  After invoking\n               a test, the object ifTestResult can be read to\n               determine the outcome.  If an agent can not perform\n               the test, ifTestResult is set to so indicate.  The\n               object ifTestCode can be used to provide further\n               test-specific or interface-specific (or even\n               enterprise-specific) information concerning the\n               outcome of the test.  Only one test can be in progress\n               on each interface at any one time.  If one test is in\n               progress when another test is invoked, the second test\n               is rejected.  Some agents may reject a test when a\n               prior test is active on another interface.\n\n               Before starting a test, a manager-station must first\n               obtain 'ownership' of the entry in the ifTestTable for\n               the interface to be tested.  This is accomplished with\n               the ifTestId and ifTestStatus objects as follows:\n\n            try_again:\n                get (ifTestId, ifTestStatus)\n                while (ifTestStatus != notInUse)\n                    /*\n                     * Loop while a test is running or some other\n                     * manager is configuring a test.\n                     */\n                    short delay\n                    get (ifTestId, ifTestStatus)\n                }\n\n                /*\n                 * Is not being used right now -- let's compete\n                 * to see who gets it.\n                 */\n                lock_value = ifTestId\n\n                if ( set(ifTestId = lock_value, ifTestStatus = inUse,\n                         ifTestOwner = 'my-IP-address') == FAILURE)\n                    /*\n                     * Another manager got the ifTestEntry -- go\n                     * try again\n                     */\n                    goto try_again;\n\n                /*\n                 * I have the lock\n                 */\n                set up any test parameters.\n\n                /*\n                 * This starts the test\n                 */\n                set(ifTestType = test_to_run);\n\n                wait for test completion by polling ifTestResult\n\n                when test completes, agent sets ifTestResult\n                     agent also sets ifTestStatus = 'notInUse'\n\n                retrieve any additional test results, and ifTestId\n\n                if (ifTestId == lock_value+1) results are valid\n\n              A manager station first retrieves the value of the\n              appropriate ifTestId and ifTestStatus objects,\n              periodically repeating the retrieval if necessary,\n              until the value of ifTestStatus is 'notInUse'.  The\n              manager station then tries to set the same ifTestId\n              object to the value it just retrieved, the same\n              ifTestStatus object to 'inUse', and the corresponding\n              ifTestOwner object to a value indicating itself.  If\n              the set operation succeeds then the manager has\n              obtained ownership of the ifTestEntry, and the value of\n              the ifTestId object is incremented by the agent (per\n              the semantics of TestAndIncr).  Failure of the set\n              operation indicates that some other manager has\n              obtained ownership of the ifTestEntry.\n\n              Once ownership is obtained, any test parameters can be\n              setup, and then the test is initiated by setting\n              ifTestType.  On completion of the test, the agent sets\n              ifTestStatus to 'notInUse'.  Once this occurs, the\n              manager can retrieve the results.  In the (rare) event\n              that the invocation of tests by two network managers\n              were to overlap, then there would be a possibility that\n              the first test's results might be overwritten by the\n              second test's results prior to the first results being\n              read.  This unlikely circumstance can be detected by a\n              network manager retrieving ifTestId at the same time as\n              retrieving the test results, and ensuring that the\n              results are for the desired request.\n\n              If ifTestType is not set within an abnormally long\n              period of time after ownership is obtained, the agent\n              should time-out the manager, and reset the value of the\n              ifTestStatus object back to 'notInUse'.  It is\n              suggested that this time-out period be 5 minutes.\n\n              In general, a management station must not retransmit a\n              request to invoke a test for which it does not receive\n              a response; instead, it properly inspects an agent's\n              MIB to determine if the invocation was successful.\n              Only if the invocation was unsuccessful, is the\n              invocation request retransmitted.\n\n              Some tests may require the interface to be taken off-\n              line in order to execute them, or may even require the\n              agent to reboot after completion of the test.  In these\n              circumstances, communication with the management\n              station invoking the test may be lost until after\n              completion of the test.  An agent is not required to\n              support such tests.  However, if such tests are\n              supported, then the agent should make every effort to\n              transmit a response to the request which invoked the\n              test prior to losing communication.  When the agent is\n              restored to normal service, the results of the test are\n              properly made available in the appropriate objects.\n              Note that this requires that the ifIndex value assigned\n              to an interface must be unchanged even if the test\n              causes a reboot.  An agent must reject any test for\n              which it cannot, perhaps due to resource constraints,\n              make available at least the minimum amount of\n              information after that test completes.")
ifTestEntry = MibTableRow((1, 3, 6, 1, 2, 1, 31, 1, 3, 1), )
ifEntry.registerAugmentions(("IF-MIB", "ifTestEntry"))
ifTestEntry.setIndexNames(*ifEntry.getIndexNames())
if mibBuilder.loadTexts: ifTestEntry.setDescription('An entry containing objects for invoking tests on an\n               interface.')
ifTestId = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 1), TestAndIncr()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifTestId.setDescription("This object identifies the current invocation of the\n               interface's test.")
ifTestStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("notInUse", 1), ("inUse", 2),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifTestStatus.setDescription("This object indicates whether or not some manager\n               currently has the necessary 'ownership' required to\n               invoke a test on this interface.  A write to this\n               object is only successful when it changes its value\n               from 'notInUse(1)' to 'inUse(2)'.  After completion of\n               a test, the agent resets the value back to\n               'notInUse(1)'.")
ifTestType = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 3), AutonomousType()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifTestType.setDescription('A control variable used to start and stop operator-\n               initiated interface tests.  Most OBJECT IDENTIFIER\n               values assigned to tests are defined elsewhere, in\n               association with specific types of interface.\n               However, this document assigns a value for a full-\n               duplex loopback test, and defines the special meanings\n               of the subject identifier:\n\n                   noTest  OBJECT IDENTIFIER ::= { 0 0 }\n\n               When the value noTest is written to this object, no\n               action is taken unless a test is in progress, in which\n               case the test is aborted.  Writing any other value to\n               this object is only valid when no test is currently in\n               progress, in which case the indicated test is\n               initiated.\n\n               When read, this object always returns the most recent\n               value that ifTestType was set to.  If it has not been\n               set since the last initialization of the network\n               management subsystem on the agent, a value of noTest\n               is returned.')
ifTestResult = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7,))).clone(namedValues=NamedValues(("none", 1), ("success", 2), ("inProgress", 3), ("notSupported", 4), ("unAbleToRun", 5), ("aborted", 6), ("failed", 7),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifTestResult.setDescription('This object contains the result of the most recently\n               requested test, or the value none(1) if no tests have\n               been requested since the last reset.  Note that this\n               facility provides no provision for saving the results\n               of one test when starting another, as could be\n               required if used by multiple managers concurrently.')
ifTestCode = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 5), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: ifTestCode.setDescription('This object contains a code which contains more\n               specific information on the test result, for example\n               an error-code after a failed test.  Error codes and\n               other values this object may take are specific to the\n               type of interface and/or test.  The value may have the\n               semantics of either the AutonomousType or\n               InstancePointer textual conventions as defined in RFC\n               1903.  The identifier:\n\n                   testCodeUnknown  OBJECT IDENTIFIER ::= { 0 0 }\n\n               is defined for use if no additional result code is\n               available.')
ifTestOwner = MibTableColumn((1, 3, 6, 1, 2, 1, 31, 1, 3, 1, 6), OwnerString()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: ifTestOwner.setDescription("The entity which currently has the 'ownership'\n               required to invoke a test on this interface.")
ifGeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 1)).setObjects(*(("IF-MIB", "ifDescr"), ("IF-MIB", "ifType"), ("IF-MIB", "ifSpeed"), ("IF-MIB", "ifPhysAddress"), ("IF-MIB", "ifAdminStatus"), ("IF-MIB", "ifOperStatus"), ("IF-MIB", "ifLastChange"), ("IF-MIB", "ifLinkUpDownTrapEnable"), ("IF-MIB", "ifConnectorPresent"), ("IF-MIB", "ifHighSpeed"), ("IF-MIB", "ifName"),))
if mibBuilder.loadTexts: ifGeneralGroup.setDescription('A collection of objects deprecated in favour of\n               ifGeneralInformationGroup.')
ifTestGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 8)).setObjects(*(("IF-MIB", "ifTestId"), ("IF-MIB", "ifTestStatus"), ("IF-MIB", "ifTestType"), ("IF-MIB", "ifTestResult"), ("IF-MIB", "ifTestCode"), ("IF-MIB", "ifTestOwner"),))
if mibBuilder.loadTexts: ifTestGroup.setDescription('A collection of objects providing the ability to\n               invoke tests on an interface.')
ifStackGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 9)).setObjects(*(("IF-MIB", "ifStackStatus"),))
if mibBuilder.loadTexts: ifStackGroup.setDescription('The previous collection of objects providing\n               information on the layering of MIB-II interfaces.')
ifOldObjectsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 31, 2, 1, 12)).setObjects(*(("IF-MIB", "ifInNUcastPkts"), ("IF-MIB", "ifOutNUcastPkts"), ("IF-MIB", "ifOutQLen"), ("IF-MIB", "ifSpecific"),))
if mibBuilder.loadTexts: ifOldObjectsGroup.setDescription('The collection of objects deprecated from the\n               original MIB-II interfaces group.')
ifCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 31, 2, 2, 1)).setObjects(*(("IF-MIB", "ifGeneralGroup"), ("IF-MIB", "ifStackGroup"), ("IF-MIB", "ifFixedLengthGroup"), ("IF-MIB", "ifHCFixedLengthGroup"), ("IF-MIB", "ifPacketGroup"), ("IF-MIB", "ifHCPacketGroup"), ("IF-MIB", "ifTestGroup"), ("IF-MIB", "ifRcvAddressGroup"),))
if mibBuilder.loadTexts: ifCompliance.setDescription('The previous compliance statement for SNMPv2 entities\n               which have network interfaces.')
mibBuilder.exportSymbols("IF-MIB", ifOutBroadcastPkts=ifOutBroadcastPkts, ifHighSpeed=ifHighSpeed, ifHCInOctets=ifHCInOctets, ifTestEntry=ifTestEntry, ifOutDiscards=ifOutDiscards, ifIndex=ifIndex, ifOutOctets=ifOutOctets, ifInErrors=ifInErrors, ifHCInBroadcastPkts=ifHCInBroadcastPkts, ifType=ifType, InterfaceIndex=InterfaceIndex, InterfaceIndexOrZero=InterfaceIndexOrZero, ifTestType=ifTestType, ifOutNUcastPkts=ifOutNUcastPkts, ifInUnknownProtos=ifInUnknownProtos, ifHCInMulticastPkts=ifHCInMulticastPkts, ifStackGroup2=ifStackGroup2, ifTable=ifTable, ifStackStatus=ifStackStatus, ifInBroadcastPkts=ifInBroadcastPkts, ifDescr=ifDescr, ifPromiscuousMode=ifPromiscuousMode, ifTestStatus=ifTestStatus, ifTestOwner=ifTestOwner, ifInUcastPkts=ifInUcastPkts, ifMIBObjects=ifMIBObjects, ifInOctets=ifInOctets, ifPhysAddress=ifPhysAddress, interfaces=interfaces, ifCompliance2=ifCompliance2, ifSpeed=ifSpeed, ifLastChange=ifLastChange, ifRcvAddressTable=ifRcvAddressTable, ifHCOutUcastPkts=ifHCOutUcastPkts, ifStackHigherLayer=ifStackHigherLayer, ifAlias=ifAlias, ifSpecific=ifSpecific, ifRcvAddressStatus=ifRcvAddressStatus, ifCounterDiscontinuityGroup=ifCounterDiscontinuityGroup, ifHCOutBroadcastPkts=ifHCOutBroadcastPkts, ifXEntry=ifXEntry, ifMtu=ifMtu, PYSNMP_MODULE_ID=ifMIB, ifGeneralInformationGroup=ifGeneralInformationGroup, ifTestId=ifTestId, ifStackGroup=ifStackGroup, ifCompliance=ifCompliance, ifStackLowerLayer=ifStackLowerLayer, ifStackTable=ifStackTable, ifHCPacketGroup=ifHCPacketGroup, ifTestGroup=ifTestGroup, ifPacketGroup=ifPacketGroup, ifCompliances=ifCompliances, ifHCOutOctets=ifHCOutOctets, linkUp=linkUp, ifEntry=ifEntry, ifHCFixedLengthGroup=ifHCFixedLengthGroup, ifGeneralGroup=ifGeneralGroup, ifGroups=ifGroups, ifLinkUpDownTrapEnable=ifLinkUpDownTrapEnable, ifStackLastChange=ifStackLastChange, ifNumber=ifNumber, linkDown=linkDown, ifFixedLengthGroup=ifFixedLengthGroup, ifVHCPacketGroup=ifVHCPacketGroup, ifOutErrors=ifOutErrors, ifInMulticastPkts=ifInMulticastPkts, ifRcvAddressEntry=ifRcvAddressEntry, ifTestCode=ifTestCode, ifOldObjectsGroup=ifOldObjectsGroup, ifHCInUcastPkts=ifHCInUcastPkts, ifOutQLen=ifOutQLen, ifXTable=ifXTable, ifRcvAddressType=ifRcvAddressType, ifStackEntry=ifStackEntry, ifName=ifName, ifOutUcastPkts=ifOutUcastPkts, ifOutMulticastPkts=ifOutMulticastPkts, ifCounterDiscontinuityTime=ifCounterDiscontinuityTime, ifRcvAddressGroup=ifRcvAddressGroup, OwnerString=OwnerString, ifConformance=ifConformance, ifTableLastChange=ifTableLastChange, ifConnectorPresent=ifConnectorPresent, ifInDiscards=ifInDiscards, ifAdminStatus=ifAdminStatus, ifTestResult=ifTestResult, ifInNUcastPkts=ifInNUcastPkts, ifOperStatus=ifOperStatus, ifHCOutMulticastPkts=ifHCOutMulticastPkts, ifRcvAddressAddress=ifRcvAddressAddress, ifTestTable=ifTestTable, ifMIB=ifMIB)
