//
// C++ Implementation: CSplEdit
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2007
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <QtGui>

#include "CQcakeDlg.hpp"
#include "CSplEdit.hpp"
#include "messages.hpp"
#include "main.h"

CSplEditDlg::CSplEditDlg(QString strTitle, QWidget * parent, Qt::WFlags f)
: CQcakeDlg(parent, f)
{
   point = NULL;
   ui.setupUi(this);

   connect(ui.buttonBox, SIGNAL(accepted()), this, SLOT(slotEditData()));
   connect(ui.buttonBox, SIGNAL(rejected()), this, SLOT(slotGetData()));
   connect(ui.pushButton3, SIGNAL(released()), this, SLOT(slotEditorScript()));

   myParent = parent;
   setWindowTitle(strTitle);
}

CSplEditDlg::~CSplEditDlg() {
}

void CSplEditDlg::slotGetData()
{
    if(point != NULL){
      slotGetData(point);
    }
}

void CSplEditDlg::slotGetData(FolderListItem *i)
{
    point=i;
 
    ui.text->setText(i->text(0));
    ui.on->setChecked(i->GetValue("on",i).toInt());
    qWarning( "CSplEditDlg::slotGetData(): Geht !" );
}

void CSplEditDlg::slotEditData()
{
    if(point != NULL){
        point->setText(0,ui.text->text());
        point->SetValue("on", ui.on->isChecked() ? "1" : "0");
        point->updategl();
    }
    qWarning( "CSplEditDlg::slotEditData(): Geht !" );
}

void CSplEditDlg::slotEditorScript()
{
    QProcess*  proc = new QProcess( this );
    QString   arg = g_prjpath + point->GetValue("path",point ) + "/" + point->GetValue("file",point) ;
    QStringList arguments;
    arguments << arg;
    qWarning( arg.toAscii() );   // error handling

    QString program = g_editor;
    proc->start(program, arguments);
    if ( !proc->waitForStarted()) {
      QString qmsg = "MySplEditDlg::EditorScript(): cant start editor " + program;
      qWarning(qmsg.toAscii() );   // error handling
      ErrorMsg errormsg(qmsg);
    }
    qWarning( "MySplEditDlg::EditorScript(): Geht !" );
}
