/*
 * Copyright (C) 2009  Lorenzo Bettini <http://www.lorenzobettini.it>
 * See COPYING file that comes with this distribution
 */


#ifndef QSourceHighlight_H
#define QSourceHighlight_H

#include <QMainWindow>
#include <QCloseEvent>
#include <srchiliteqt/LanguageComboBox.h>
#include <srchiliteqt/OutputFormatComboBox.h>
#include <srchiliteqt/StyleComboBox.h>
#include <srchiliteqt/TextEditHighlighted.h>

class QAction;
class QMenu;
class QSourceHighlightFrame;
class QFile;
class Assistant;

namespace Ui
{
    class MainWindow;
}

class QSourceHighlight : public QMainWindow
{
      Q_OBJECT

public:
      QSourceHighlight();
      ~QSourceHighlight();

protected:
      void closeEvent(QCloseEvent *event);
      void highlight(bool onlySelectedLines = false);

protected slots:
      void highlightAll();
      void highlightSelected();

private slots:
      void newFile();
      void open();
      void openStyle();
      bool save();
      bool saveAs();
      bool saveHighlighted();
      bool saveHighlightedAs();
      bool saveStyle();
      bool saveStyleAs();
      void about();
      void documentWasModified();
      void configureHighlighting();
      void configureSourceHighlight();
      void showDocumentation();

      void currentStyleChanged(const QString &style);

private:
      void createActions();
      void createToolBars();
      void createStatusBar();
      void readSettings();
      void writeSettings();
      bool maybeSave();
      void loadFile(const QString &fileName);
      bool saveFile(const QString &fileName, const QTextEdit *editor);
      void setCurrentFile(const QString &fileName);
      QString strippedName(const QString &fullFileName);

      /**
        * Reloads the contents of the toolbar's combo boxes
        * (for instance, when source-highlight settings change or restored)
        */
      void reloadComboBoxes();

      /**
        * Generates the contents for a source-highlight style file
        * starting from the current highlighter formatters.
        * @param file
        */
      void writeStyleFile(QFile *file);

      /**
        * Checks that source-highlight settings are correct,
        * otherwise open the setting dialog.
        * @return whether settings are ok
        */
      bool checkSourceHighlightSettings();

      QSourceHighlightFrame *frame;

      srchiliteqt::TextEditHighlighted *textEdit;
      srchiliteqt::TextEditHighlighted *outputTextEdit;
      QString curFile;
      QString curHighlightedFile;
      QString curStyleFile;

      srchiliteqt::LanguageComboBox *languageComboBox;
      srchiliteqt::OutputFormatComboBox *outputFormatComboBox;
      srchiliteqt::StyleComboBox *styleComboBox;

      QString sourceHighlightDataDir;

      /// whether the user customized the style with the color dialog
      bool styleModified;

      /// the path of the executable
      QString binDir;

      /// the instance for showing help contents
      Assistant *assistant;

private:
    Ui::MainWindow *ui;
};

#endif
