% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{Expectations}
\alias{Expectations}
\alias{Expectations<-}
\alias{Expectations,MOFAmodel-method}
\alias{Expectations<-,MOFAmodel,list-method}
\title{Expectations: set and retrieve expectations of model components}
\usage{
Expectations(object)

Expectations(object) <- value

\S4method{Expectations}{MOFAmodel}(object)

\S4method{Expectations}{MOFAmodel,list}(object) <- value
}
\arguments{
\item{object}{a \code{\link{MOFAmodel}} object.}

\item{value}{a list with matrices for expectations of unobserved model components}
}
\value{
list of matrices containing expectations of model components
}
\description{
Function to set and retrieve expectations of model components.
}
\examples{
# load a trained MOFAmodel object
filepath <- system.file("extdata", "scMT_model.hdf5", package = "MOFAdata")
MOFAobject <- loadModel(filepath)
names(Expectations(MOFAobject))
}
