% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_tidiers.R
\name{robust_tidiers}
\alias{robust_tidiers}
\alias{tidy.lmRob}
\alias{augment.lmRob}
\alias{glance.lmRob}
\alias{robust_tidiers}
\alias{tidy.glmRob}
\alias{augment.glmRob}
\alias{glance.glmRob}
\title{Tidiers for lmRob and glmRob objects}
\usage{
\method{tidy}{lmRob}(x, ...)

\method{augment}{lmRob}(x, ...)

\method{glance}{lmRob}(x, ...)

\method{tidy}{glmRob}(x, ...)

\method{augment}{glmRob}(x, ...)

\method{glance}{glmRob}(x, ...)
}
\arguments{
\item{x}{An lmRob or glmRob object with a robust regression}

\item{...}{Extra arguments, not used}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy} and \code{augment} return the same results as \code{\link{lm_tidiers}}.

On an \code{lmRob} \code{glance} returns a one-row data frame with the following columns:
  \item{r.squared}{R-squared}
  \item{deviance}{Robust deviance}
  \item{sigma}{Residual scale estimate}
  \item{df.residual}{Number of residual degrees of freedom}

On an \code{lmRob} \code{glance} returns a one-row data frame with the following columns:
  \item{deviance}{Robust deviance}
  \item{null.deviance}{Deviance under the null model}
  \item{df.residual}{Number of residual degrees of freedom}
}
\description{
Tidying robust regression objects from the robust package. The tidy and augment
methods simply pass it on to the linear model tidiers.
}
\examples{

if (require("robust", quietly = TRUE)) {
  m <- lmRob(mpg ~ wt, data = mtcars)
  
  tidy(m)
  augment(m)
  glance(m)
  
  gm <- glmRob(am ~ wt, data = mtcars, family = "binomial")
  glance(gm)
}

}
\seealso{
\code{\link{lm_tidiers}}, \code{\link[robust]{lmRob}}, \code{\link[robust]{glmRob}}
}
