% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leim.R
\docType{class}
\name{LaplacianEigenmaps-class}
\alias{LaplacianEigenmaps-class}
\alias{LaplacianEigenmaps}
\title{Laplacian Eigenmaps}
\description{
An S4 Class implementing Laplacian Eigenmaps
}
\details{
Laplacian Eigenmaps use a kernel and were originally developed to
separate non-convex clusters under the name spectral clustering.
}
\section{Slots}{

\describe{
\item{\code{fun}}{A function that does the embedding and returns a
dimRedResult object.}

\item{\code{stdpars}}{The standard parameters for the function.}
}}

\section{General usage}{

Dimensionality reduction methods are S4 Classes that either be used
directly, in which case they have to be initialized and a full
list with parameters has to be handed to the \code{@fun()}
slot, or the method name be passed to the embed function and
parameters can be given to the \code{...}, in which case
missing parameters will be replaced by the ones in the
\code{@stdpars}.
}

\section{Parameters}{

\code{LaplacianEigenmaps} can take the following parameters:
\describe{
  \item{ndim}{the number of output dimensions.}

  \item{sparse}{A character vector specifying hot to make the graph
   sparse, \code{"knn"} means that a K-nearest neighbor graph is
   constructed, \code{"eps"} an epsilon neighborhood graph is
   constructed, else a dense distance matrix is used.}

  \item{knn}{The number of nearest neighbors to use for the knn graph.}
  \item{eps}{The distance for the epsilon neighborhood graph.}

  \item{t}{Parameter for the transformation of the distance matrix
  by \eqn{w=exp(-d^2/t)}, larger values give less weight to
  differences in distance, \code{t == Inf} treats all distances != 0 equally.}
  \item{norm}{logical, should the normed laplacian be used?}
}
}

\section{Implementation}{

Wraps around \code{\link[loe]{spec.emb}}.
}

\examples{
dat <- loadDataSet("3D S Curve")
leim <- LaplacianEigenmaps()
emb <- leim@fun(dat, leim@stdpars)


plot(emb@data@data)


}
\references{
Belkin, M., Niyogi, P., 2003. Laplacian Eigenmaps for
Dimensionality Reduction and Data Representation. Neural
Computation 15, 1373.
}
