% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_gpd.R
\name{dist_gpd}
\alias{dist_gpd}
\title{The Generalized Pareto Distribution}
\usage{
dist_gpd(location, scale, shape)
}
\arguments{
\item{location}{the location parameter \eqn{a} of the GPD distribution.}

\item{scale}{the scale parameter \eqn{b} of the GPD distribution.}

\item{shape}{the shape parameter \eqn{s} of the GPD distribution.}
}
\description{
The GPD distribution function with parameters \eqn{\code{location} = a},
\eqn{\code{scale} = b} and \eqn{\code{shape} = s} is
}
\details{
\deqn{F(x) = 1 - \left(1+s(x-a)/b\right)^{-1/s}}

for \eqn{1+s(x-a)/b > 0}, where \eqn{b > 0}. If \eqn{s = 0} the distribution
is defined by continuity, giving

\deqn{F(x) = 1 - \exp\left(-\frac{x-a}{b}\right)}

The support of the distribution is \eqn{x \geq a} if \eqn{s \geq 0}, and
\eqn{a \leq x \leq a -b/s} if \eqn{s < 0}.

The Pickands–Balkema–De Haan theorem states that for a large class of
distributions, the tail (above some threshold) can be approximated by a GPD.
}
\examples{
dist <- dist_gpd(location = 0, scale = 1, shape = 0)
}
\seealso{
\code{\link[evd]{gpd}}
}
