% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{path_expand}
\alias{path_expand}
\alias{path_expand_r}
\alias{path_home}
\alias{path_home_r}
\title{Finding the User Home Directory}
\usage{
path_expand(path)

path_expand_r(path)

path_home(...)

path_home_r(...)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{...}{Additional paths appended to the home directory by \code{\link[=path]{path()}}.}
}
\description{
\itemize{
\item \code{path_expand()} performs tilde expansion on a path, replacing instances of
\code{~} or \code{~user} with the user's home directory.
\item \code{path_home()} constructs a path within the expanded users home directory,
calling it with \emph{no} arguments can be useful to verify what fs considers the
home directory.
\item \code{path_expand_r()} and \code{path_home_r()} are equivalents which always use R's
definition of the home directory.
}
}
\details{
\code{path_expand()} differs from \code{\link[base:path.expand]{base::path.expand()}} in the interpretation of
the home directory of Windows. In particular \code{path_expand()} uses the path
set in the \code{USERPROFILE} environment variable and, if unset, then uses
\code{HOMEDRIVE}/\code{HOMEPATH}.

In contrast \code{\link[base:path.expand]{base::path.expand()}} first checks for \code{R_USER} then \code{HOME},
which in the default configuration of R on Windows are both set to the user's
document directory, e.g. \code{C:\\Users\\username\\Documents}.
\code{\link[base:path.expand]{base::path.expand()}} also does not support \code{~otheruser} syntax on Windows,
whereas \code{path_expand()} does support this syntax on all systems.

This definition makes fs more consistent with the definition of home
directory used on Windows in other languages, such as
\href{https://docs.python.org/3/library/os.path.html#os.path.expanduser}{python}
and \href{https://doc.rust-lang.org/std/env/fn.home_dir.html#windows}{rust}. This
is also more compatible with external tools such as git and ssh, both of
which put user-level files in \code{USERPROFILE} by default. It also allows you to
write portable paths, such as \code{~/Desktop} that points to the Desktop location
on Windows, MacOS and (most) Linux systems.

Users can set the \code{R_FS_HOME} environment variable to override the
definitions on any platform.
}
\examples{
# Expand a path
path_expand("~/bin")

# You can use `path_home()` without arguments to see what is being used as
# the home diretory.
path_home()
path_home("R")

# This will likely differ from the above on Windows
path_home_r()
}
\seealso{
\href{https://cran.r-project.org/bin/windows/base/rw-FAQ.html#What-are-HOME-and-working-directories_003f}{R for Windows FAQ - 2.14}
for behavior of \code{\link[base:path.expand]{base::path.expand()}}.
}
