% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/race-wrapper.R
\name{buildCommandLine}
\alias{buildCommandLine}
\title{Generate a command-line representation of a configuration}
\usage{
buildCommandLine(values, switches)
}
\arguments{
\item{values}{A vector containing the value of each parameter for the
candidate configuration.}

\item{switches}{A vector containing the switches of each paramter (in an
order that corresponds to the values vector).}
}
\value{
A string concatenating each element of \code{switches} and
\code{values} for all parameters with a space between each pair of
parameters (but none between the switches and the corresponding values).
}
\description{
\code{buildCommandLine} receives two vectors, one containing
the values of the parameters, the other containing the switches of the
parameters. It builds a string with the switches and the values that can
be used as a command line to call the program to be tuned, thus generating
one candidate configuration.
}
\examples{
switches <- c("--switch1 ", "--switch2-", "--switch3=")
values <- list("value_1", 1L, sqrt(2))
buildCommandLine (values, switches)
## Build a command-line from the results produced by a previous run of irace.
# First, load the data produced by irace.
logfile <- file.path(system.file(package="irace"), "exdata", "irace-acotsp.Rdata")
iraceResults <- read_logfile(logfile)
allConfigurations <- iraceResults$allConfigurations
parameters <- iraceResults$scenario$parameters
apply(allConfigurations[1:10, unlist(parameters$names)], 1, buildCommandLine,
      unlist(parameters$switches))

}
\author{
Manuel López-Ibáñez and Jérémie Dubois-Lacoste
}
