% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{has_keyring_support}
\alias{has_keyring_support}
\alias{keyring_create}
\alias{keyring_list}
\alias{keyring_delete}
\alias{keyring_lock}
\alias{keyring_unlock}
\alias{keyring_is_locked}
\title{Operations on keyrings}
\usage{
has_keyring_support()

keyring_create(keyring, password = NULL)

keyring_list()

keyring_delete(keyring = NULL)

keyring_lock(keyring = NULL)

keyring_unlock(keyring = NULL, password = NULL)

keyring_is_locked(keyring = NULL)
}
\arguments{
\item{keyring}{The name of the keyring to create or to operate on.
For functions other than \code{keyring_create}, it can also be \code{NULL} to
select the default keyring.}

\item{password}{The initial password or the password to unlock the
keyring. If not specified or \code{NULL}, it will be read from the console.}
}
\description{
On most platforms \code{keyring} supports multiple keyrings. This includes
Windows, macOS and Linux (Secret Service) as well. A keyring is a
collection of keys that can be treated as a unit. A keyring typically
has a name and a password to unlock it. Once a keyring is unlocked,
it remains unlocked until the end of the user session, or until it is
explicitly locked again.
}
\details{
Platforms typically have a default keyring, which is unlocked
automatically when the user logs in. This keyring does not need to be
unlocked explicitly.

You can configure the keyring to use via R options or environment
variables (see \code{\link[=default_backend]{default_backend()}}), or you can also specify it
directly in the \code{\link[=default_backend]{default_backend()}} call, or in the individual
\code{keyring} calls.

\code{has_keyring_support} checks if a backend supports multiple keyrings.

\code{keyring_create} creates a new keyring. It asks for a password if no
password is specified.

\code{keyring_list} lists all existing keyrings.

\code{keyring_delete} deletes a keyring. Deleting a non-empty keyring
requires confirmation, and the default keyring can only be deleted if
specified explicitly. On some backends (e.g. Windows Credential Store),
the default keyring cannot be deleted at all.

\code{keyring_lock} locks a keyring. On some backends (e.g. Windows
Credential Store), the default keyring cannot be locked.

\code{keyring_unlock} unlocks a keyring. If a password is not specified,
it will be read in interactively.

\code{keyring_is_locked} queries whether a keyring is locked.
}
\examples{
default_backend()
has_keyring_support()
backend_env$new()$has_keyring_support()

## This might ask for a password, so we do not run it by default
## It only works if the default backend supports multiple keyrings
\dontrun{
keyring_create("foobar")
key_set_with_value("R-test-service", "donaldduck", password = "secret",
                   keyring = "foobar")
key_get("R-test-service", "donaldduck", keyring = "foobar")
key_list(keyring = "foobar")
keyring_delete(keyring = "foobar")
}
}
