% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4-utils.R
\name{.callGeneric}
\alias{.callGeneric}
\title{Calls the given generic with the given arguments}
\usage{
.callGeneric(f, ..., .package = NULL)
}
\arguments{
\item{f}{the generic, as a character string or a \link[methods:standardGeneric-class]{standardGeneric}
object}

\item{...}{the arguments (named and/or unnamed) with which to call the
matching method}

\item{.package}{the package name for finding the generic (if \code{f} is a character
string); by default the package is determined from the calling environment}
}
\value{
the value returned by the method
}
\description{
Calls the given generic with the given arguments, using the method
whose signature matches the arguments.
}
\details{
Uses \code{\link[methods:selectMethod]{methods::selectMethod()}} to find the matching method. In theory,
this is at best wholly redundant with what standard S4 generics already
do by themselves. However, the generics dispatch for S4 seems (at least
currently) broken at least if the first argument in the signature is
a class that name-clashes with a class defined in another package. In
that case, whether the standard dispatch works correctly or not can depend
on \link[base:search]{search order}, and can change within a session
depending on the order in which packages are loaded.
}
