% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\docType{data}
\name{base_classes}
\alias{base_classes}
\alias{class_logical}
\alias{class_integer}
\alias{class_double}
\alias{class_complex}
\alias{class_character}
\alias{class_raw}
\alias{class_list}
\alias{class_expression}
\alias{class_name}
\alias{class_call}
\alias{class_function}
\alias{class_environment}
\alias{class_numeric}
\alias{class_atomic}
\alias{class_vector}
\alias{class_language}
\title{S7 wrappers for base types}
\usage{
class_logical

class_integer

class_double

class_complex

class_character

class_raw

class_list

class_expression

class_name

class_call

class_function

class_environment

class_numeric

class_atomic

class_vector

class_language
}
\value{
S7 classes wrapping around common base types and S3 classes.
}
\description{
The following S7 classes represent base types allowing them to be used
within S7:
\itemize{
\item \code{class_logical}
\item \code{class_integer}
\item \code{class_double}
\item \code{class_complex}
\item \code{class_character}
\item \code{class_raw}
\item \code{class_list}
\item \code{class_expression}
\item \code{class_name}
\item \code{class_call}
\item \code{class_function}
\item \code{class_environment} (can only be used for properties)
}

We also include three union types to model numerics, atomics, and vectors
respectively:
\itemize{
\item \code{class_numeric} is a union of \code{class_integer} and \code{class_double}.
\item \code{class_atomic} is a union of \code{class_logical}, \code{class_numeric},
\code{class_complex}, \code{class_character}, and \code{class_raw}.
\item \code{class_vector} is a union of \code{class_atomic}, \code{class_list}, and
\code{class_expression}.
\item \code{class_language} is a union of \code{class_name} and \code{class_call}.
}
}
\examples{

class_integer
class_numeric
class_factor
}
\keyword{datasets}
