# Unicode normalization tests, generated from NormalizationTests.txt in the
# Unicode database by S15-normalization/test-gen.p6.

use Test;

plan 2000;

ok Uni.new(0x1E0A).NFKD.list ~~ (0x0044, 0x0307,), '1E0A -> 0044 0307';
ok Uni.new(0x1E0C).NFKD.list ~~ (0x0044, 0x0323,), '1E0C -> 0044 0323';
ok Uni.new(0x1E0A, 0x0323).NFKD.list ~~ (0x0044, 0x0323, 0x0307,), '1E0A 0323 -> 0044 0323 0307';
ok Uni.new(0x1E0C, 0x0307).NFKD.list ~~ (0x0044, 0x0323, 0x0307,), '1E0C 0307 -> 0044 0323 0307';
ok Uni.new(0x0044, 0x0307, 0x0323).NFKD.list ~~ (0x0044, 0x0323, 0x0307,), '0044 0307 0323 -> 0044 0323 0307';
ok Uni.new(0x0044, 0x0323, 0x0307).NFKD.list ~~ (0x0044, 0x0323, 0x0307,), '0044 0323 0307 -> 0044 0323 0307';
ok Uni.new(0x1E0A, 0x031B).NFKD.list ~~ (0x0044, 0x031B, 0x0307,), '1E0A 031B -> 0044 031B 0307';
ok Uni.new(0x1E0C, 0x031B).NFKD.list ~~ (0x0044, 0x031B, 0x0323,), '1E0C 031B -> 0044 031B 0323';
ok Uni.new(0x1E0A, 0x031B, 0x0323).NFKD.list ~~ (0x0044, 0x031B, 0x0323, 0x0307,), '1E0A 031B 0323 -> 0044 031B 0323 0307';
ok Uni.new(0x1E0C, 0x031B, 0x0307).NFKD.list ~~ (0x0044, 0x031B, 0x0323, 0x0307,), '1E0C 031B 0307 -> 0044 031B 0323 0307';
ok Uni.new(0x0044, 0x031B, 0x0307, 0x0323).NFKD.list ~~ (0x0044, 0x031B, 0x0323, 0x0307,), '0044 031B 0307 0323 -> 0044 031B 0323 0307';
ok Uni.new(0x0044, 0x031B, 0x0323, 0x0307).NFKD.list ~~ (0x0044, 0x031B, 0x0323, 0x0307,), '0044 031B 0323 0307 -> 0044 031B 0323 0307';
ok Uni.new(0x00C8).NFKD.list ~~ (0x0045, 0x0300,), '00C8 -> 0045 0300';
ok Uni.new(0x0112).NFKD.list ~~ (0x0045, 0x0304,), '0112 -> 0045 0304';
ok Uni.new(0x0045, 0x0300).NFKD.list ~~ (0x0045, 0x0300,), '0045 0300 -> 0045 0300';
ok Uni.new(0x0045, 0x0304).NFKD.list ~~ (0x0045, 0x0304,), '0045 0304 -> 0045 0304';
ok Uni.new(0x1E14).NFKD.list ~~ (0x0045, 0x0304, 0x0300,), '1E14 -> 0045 0304 0300';
ok Uni.new(0x0112, 0x0300).NFKD.list ~~ (0x0045, 0x0304, 0x0300,), '0112 0300 -> 0045 0304 0300';
ok Uni.new(0x1E14, 0x0304).NFKD.list ~~ (0x0045, 0x0304, 0x0300, 0x0304,), '1E14 0304 -> 0045 0304 0300 0304';
ok Uni.new(0x0045, 0x0304, 0x0300).NFKD.list ~~ (0x0045, 0x0304, 0x0300,), '0045 0304 0300 -> 0045 0304 0300';
ok Uni.new(0x0045, 0x0300, 0x0304).NFKD.list ~~ (0x0045, 0x0300, 0x0304,), '0045 0300 0304 -> 0045 0300 0304';
ok Uni.new(0x05B8, 0x05B9, 0x05B1, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F).NFKD.list ~~ (0x05B1, 0x05B8, 0x05B9, 0x0591, 0x05C3, 0x05B0, 0x05AC, 0x059F,), '05B8 05B9 05B1 0591 05C3 05B0 05AC 059F -> 05B1 05B8 05B9 0591 05C3 05B0 05AC 059F';
ok Uni.new(0x0592, 0x05B7, 0x05BC, 0x05A5, 0x05B0, 0x05C0, 0x05C4, 0x05AD).NFKD.list ~~ (0x05B0, 0x05B7, 0x05BC, 0x05A5, 0x0592, 0x05C0, 0x05AD, 0x05C4,), '0592 05B7 05BC 05A5 05B0 05C0 05C4 05AD -> 05B0 05B7 05BC 05A5 0592 05C0 05AD 05C4';
ok Uni.new(0x00A0).NFKD.list ~~ (0x0020,), '00A0 -> 0020';
ok Uni.new(0x00A8).NFKD.list ~~ (0x0020, 0x0308,), '00A8 -> 0020 0308';
ok Uni.new(0x00AA).NFKD.list ~~ (0x0061,), '00AA -> 0061';
ok Uni.new(0x00AF).NFKD.list ~~ (0x0020, 0x0304,), '00AF -> 0020 0304';
ok Uni.new(0x00B2).NFKD.list ~~ (0x0032,), '00B2 -> 0032';
ok Uni.new(0x00B3).NFKD.list ~~ (0x0033,), '00B3 -> 0033';
ok Uni.new(0x00B4).NFKD.list ~~ (0x0020, 0x0301,), '00B4 -> 0020 0301';
ok Uni.new(0x00B5).NFKD.list ~~ (0x03BC,), '00B5 -> 03BC';
ok Uni.new(0x00B8).NFKD.list ~~ (0x0020, 0x0327,), '00B8 -> 0020 0327';
ok Uni.new(0x00B9).NFKD.list ~~ (0x0031,), '00B9 -> 0031';
ok Uni.new(0x00BA).NFKD.list ~~ (0x006F,), '00BA -> 006F';
ok Uni.new(0x00BC).NFKD.list ~~ (0x0031, 0x2044, 0x0034,), '00BC -> 0031 2044 0034';
ok Uni.new(0x00BD).NFKD.list ~~ (0x0031, 0x2044, 0x0032,), '00BD -> 0031 2044 0032';
ok Uni.new(0x00BE).NFKD.list ~~ (0x0033, 0x2044, 0x0034,), '00BE -> 0033 2044 0034';
ok Uni.new(0x00C0).NFKD.list ~~ (0x0041, 0x0300,), '00C0 -> 0041 0300';
ok Uni.new(0x00C1).NFKD.list ~~ (0x0041, 0x0301,), '00C1 -> 0041 0301';
ok Uni.new(0x00C2).NFKD.list ~~ (0x0041, 0x0302,), '00C2 -> 0041 0302';
ok Uni.new(0x00C3).NFKD.list ~~ (0x0041, 0x0303,), '00C3 -> 0041 0303';
ok Uni.new(0x00C4).NFKD.list ~~ (0x0041, 0x0308,), '00C4 -> 0041 0308';
ok Uni.new(0x00C5).NFKD.list ~~ (0x0041, 0x030A,), '00C5 -> 0041 030A';
ok Uni.new(0x00C7).NFKD.list ~~ (0x0043, 0x0327,), '00C7 -> 0043 0327';
ok Uni.new(0x00C8).NFKD.list ~~ (0x0045, 0x0300,), '00C8 -> 0045 0300';
ok Uni.new(0x00C9).NFKD.list ~~ (0x0045, 0x0301,), '00C9 -> 0045 0301';
ok Uni.new(0x00CA).NFKD.list ~~ (0x0045, 0x0302,), '00CA -> 0045 0302';
ok Uni.new(0x00CB).NFKD.list ~~ (0x0045, 0x0308,), '00CB -> 0045 0308';
ok Uni.new(0x00CC).NFKD.list ~~ (0x0049, 0x0300,), '00CC -> 0049 0300';
ok Uni.new(0x00CD).NFKD.list ~~ (0x0049, 0x0301,), '00CD -> 0049 0301';
ok Uni.new(0x00CE).NFKD.list ~~ (0x0049, 0x0302,), '00CE -> 0049 0302';
ok Uni.new(0x00CF).NFKD.list ~~ (0x0049, 0x0308,), '00CF -> 0049 0308';
ok Uni.new(0x00D1).NFKD.list ~~ (0x004E, 0x0303,), '00D1 -> 004E 0303';
ok Uni.new(0x00D2).NFKD.list ~~ (0x004F, 0x0300,), '00D2 -> 004F 0300';
ok Uni.new(0x00D3).NFKD.list ~~ (0x004F, 0x0301,), '00D3 -> 004F 0301';
ok Uni.new(0x00D4).NFKD.list ~~ (0x004F, 0x0302,), '00D4 -> 004F 0302';
ok Uni.new(0x00D5).NFKD.list ~~ (0x004F, 0x0303,), '00D5 -> 004F 0303';
ok Uni.new(0x00D6).NFKD.list ~~ (0x004F, 0x0308,), '00D6 -> 004F 0308';
ok Uni.new(0x00D9).NFKD.list ~~ (0x0055, 0x0300,), '00D9 -> 0055 0300';
ok Uni.new(0x00DA).NFKD.list ~~ (0x0055, 0x0301,), '00DA -> 0055 0301';
ok Uni.new(0x00DB).NFKD.list ~~ (0x0055, 0x0302,), '00DB -> 0055 0302';
ok Uni.new(0x00DC).NFKD.list ~~ (0x0055, 0x0308,), '00DC -> 0055 0308';
ok Uni.new(0x00DD).NFKD.list ~~ (0x0059, 0x0301,), '00DD -> 0059 0301';
ok Uni.new(0x00E0).NFKD.list ~~ (0x0061, 0x0300,), '00E0 -> 0061 0300';
ok Uni.new(0x00E1).NFKD.list ~~ (0x0061, 0x0301,), '00E1 -> 0061 0301';
ok Uni.new(0x00E2).NFKD.list ~~ (0x0061, 0x0302,), '00E2 -> 0061 0302';
ok Uni.new(0x00E3).NFKD.list ~~ (0x0061, 0x0303,), '00E3 -> 0061 0303';
ok Uni.new(0x00E4).NFKD.list ~~ (0x0061, 0x0308,), '00E4 -> 0061 0308';
ok Uni.new(0x00E5).NFKD.list ~~ (0x0061, 0x030A,), '00E5 -> 0061 030A';
ok Uni.new(0x00E7).NFKD.list ~~ (0x0063, 0x0327,), '00E7 -> 0063 0327';
ok Uni.new(0x00E8).NFKD.list ~~ (0x0065, 0x0300,), '00E8 -> 0065 0300';
ok Uni.new(0x00E9).NFKD.list ~~ (0x0065, 0x0301,), '00E9 -> 0065 0301';
ok Uni.new(0x00EA).NFKD.list ~~ (0x0065, 0x0302,), '00EA -> 0065 0302';
ok Uni.new(0x00EB).NFKD.list ~~ (0x0065, 0x0308,), '00EB -> 0065 0308';
ok Uni.new(0x00EC).NFKD.list ~~ (0x0069, 0x0300,), '00EC -> 0069 0300';
ok Uni.new(0x00ED).NFKD.list ~~ (0x0069, 0x0301,), '00ED -> 0069 0301';
ok Uni.new(0x00EE).NFKD.list ~~ (0x0069, 0x0302,), '00EE -> 0069 0302';
ok Uni.new(0x00EF).NFKD.list ~~ (0x0069, 0x0308,), '00EF -> 0069 0308';
ok Uni.new(0x00F1).NFKD.list ~~ (0x006E, 0x0303,), '00F1 -> 006E 0303';
ok Uni.new(0x00F2).NFKD.list ~~ (0x006F, 0x0300,), '00F2 -> 006F 0300';
ok Uni.new(0x00F3).NFKD.list ~~ (0x006F, 0x0301,), '00F3 -> 006F 0301';
ok Uni.new(0x00F4).NFKD.list ~~ (0x006F, 0x0302,), '00F4 -> 006F 0302';
ok Uni.new(0x00F5).NFKD.list ~~ (0x006F, 0x0303,), '00F5 -> 006F 0303';
ok Uni.new(0x00F6).NFKD.list ~~ (0x006F, 0x0308,), '00F6 -> 006F 0308';
ok Uni.new(0x00F9).NFKD.list ~~ (0x0075, 0x0300,), '00F9 -> 0075 0300';
ok Uni.new(0x00FA).NFKD.list ~~ (0x0075, 0x0301,), '00FA -> 0075 0301';
ok Uni.new(0x00FB).NFKD.list ~~ (0x0075, 0x0302,), '00FB -> 0075 0302';
ok Uni.new(0x00FC).NFKD.list ~~ (0x0075, 0x0308,), '00FC -> 0075 0308';
ok Uni.new(0x00FD).NFKD.list ~~ (0x0079, 0x0301,), '00FD -> 0079 0301';
ok Uni.new(0x00FF).NFKD.list ~~ (0x0079, 0x0308,), '00FF -> 0079 0308';
ok Uni.new(0x0100).NFKD.list ~~ (0x0041, 0x0304,), '0100 -> 0041 0304';
ok Uni.new(0x0101).NFKD.list ~~ (0x0061, 0x0304,), '0101 -> 0061 0304';
ok Uni.new(0x0102).NFKD.list ~~ (0x0041, 0x0306,), '0102 -> 0041 0306';
ok Uni.new(0x0103).NFKD.list ~~ (0x0061, 0x0306,), '0103 -> 0061 0306';
ok Uni.new(0x0104).NFKD.list ~~ (0x0041, 0x0328,), '0104 -> 0041 0328';
ok Uni.new(0x0105).NFKD.list ~~ (0x0061, 0x0328,), '0105 -> 0061 0328';
ok Uni.new(0x0106).NFKD.list ~~ (0x0043, 0x0301,), '0106 -> 0043 0301';
ok Uni.new(0x0107).NFKD.list ~~ (0x0063, 0x0301,), '0107 -> 0063 0301';
ok Uni.new(0x0108).NFKD.list ~~ (0x0043, 0x0302,), '0108 -> 0043 0302';
ok Uni.new(0x0109).NFKD.list ~~ (0x0063, 0x0302,), '0109 -> 0063 0302';
ok Uni.new(0x010A).NFKD.list ~~ (0x0043, 0x0307,), '010A -> 0043 0307';
ok Uni.new(0x010B).NFKD.list ~~ (0x0063, 0x0307,), '010B -> 0063 0307';
ok Uni.new(0x010C).NFKD.list ~~ (0x0043, 0x030C,), '010C -> 0043 030C';
ok Uni.new(0x010D).NFKD.list ~~ (0x0063, 0x030C,), '010D -> 0063 030C';
ok Uni.new(0x010E).NFKD.list ~~ (0x0044, 0x030C,), '010E -> 0044 030C';
ok Uni.new(0x010F).NFKD.list ~~ (0x0064, 0x030C,), '010F -> 0064 030C';
ok Uni.new(0x0112).NFKD.list ~~ (0x0045, 0x0304,), '0112 -> 0045 0304';
ok Uni.new(0x0113).NFKD.list ~~ (0x0065, 0x0304,), '0113 -> 0065 0304';
ok Uni.new(0x0114).NFKD.list ~~ (0x0045, 0x0306,), '0114 -> 0045 0306';
ok Uni.new(0x0115).NFKD.list ~~ (0x0065, 0x0306,), '0115 -> 0065 0306';
ok Uni.new(0x0116).NFKD.list ~~ (0x0045, 0x0307,), '0116 -> 0045 0307';
ok Uni.new(0x0117).NFKD.list ~~ (0x0065, 0x0307,), '0117 -> 0065 0307';
ok Uni.new(0x0118).NFKD.list ~~ (0x0045, 0x0328,), '0118 -> 0045 0328';
ok Uni.new(0x0119).NFKD.list ~~ (0x0065, 0x0328,), '0119 -> 0065 0328';
ok Uni.new(0x011A).NFKD.list ~~ (0x0045, 0x030C,), '011A -> 0045 030C';
ok Uni.new(0x011B).NFKD.list ~~ (0x0065, 0x030C,), '011B -> 0065 030C';
ok Uni.new(0x011C).NFKD.list ~~ (0x0047, 0x0302,), '011C -> 0047 0302';
ok Uni.new(0x011D).NFKD.list ~~ (0x0067, 0x0302,), '011D -> 0067 0302';
ok Uni.new(0x011E).NFKD.list ~~ (0x0047, 0x0306,), '011E -> 0047 0306';
ok Uni.new(0x011F).NFKD.list ~~ (0x0067, 0x0306,), '011F -> 0067 0306';
ok Uni.new(0x0120).NFKD.list ~~ (0x0047, 0x0307,), '0120 -> 0047 0307';
ok Uni.new(0x0121).NFKD.list ~~ (0x0067, 0x0307,), '0121 -> 0067 0307';
ok Uni.new(0x0122).NFKD.list ~~ (0x0047, 0x0327,), '0122 -> 0047 0327';
ok Uni.new(0x0123).NFKD.list ~~ (0x0067, 0x0327,), '0123 -> 0067 0327';
ok Uni.new(0x0124).NFKD.list ~~ (0x0048, 0x0302,), '0124 -> 0048 0302';
ok Uni.new(0x0125).NFKD.list ~~ (0x0068, 0x0302,), '0125 -> 0068 0302';
ok Uni.new(0x0128).NFKD.list ~~ (0x0049, 0x0303,), '0128 -> 0049 0303';
ok Uni.new(0x0129).NFKD.list ~~ (0x0069, 0x0303,), '0129 -> 0069 0303';
ok Uni.new(0x012A).NFKD.list ~~ (0x0049, 0x0304,), '012A -> 0049 0304';
ok Uni.new(0x012B).NFKD.list ~~ (0x0069, 0x0304,), '012B -> 0069 0304';
ok Uni.new(0x012C).NFKD.list ~~ (0x0049, 0x0306,), '012C -> 0049 0306';
ok Uni.new(0x012D).NFKD.list ~~ (0x0069, 0x0306,), '012D -> 0069 0306';
ok Uni.new(0x012E).NFKD.list ~~ (0x0049, 0x0328,), '012E -> 0049 0328';
ok Uni.new(0x012F).NFKD.list ~~ (0x0069, 0x0328,), '012F -> 0069 0328';
ok Uni.new(0x0130).NFKD.list ~~ (0x0049, 0x0307,), '0130 -> 0049 0307';
ok Uni.new(0x0132).NFKD.list ~~ (0x0049, 0x004A,), '0132 -> 0049 004A';
ok Uni.new(0x0133).NFKD.list ~~ (0x0069, 0x006A,), '0133 -> 0069 006A';
ok Uni.new(0x0134).NFKD.list ~~ (0x004A, 0x0302,), '0134 -> 004A 0302';
ok Uni.new(0x0135).NFKD.list ~~ (0x006A, 0x0302,), '0135 -> 006A 0302';
ok Uni.new(0x0136).NFKD.list ~~ (0x004B, 0x0327,), '0136 -> 004B 0327';
ok Uni.new(0x0137).NFKD.list ~~ (0x006B, 0x0327,), '0137 -> 006B 0327';
ok Uni.new(0x0139).NFKD.list ~~ (0x004C, 0x0301,), '0139 -> 004C 0301';
ok Uni.new(0x013A).NFKD.list ~~ (0x006C, 0x0301,), '013A -> 006C 0301';
ok Uni.new(0x013B).NFKD.list ~~ (0x004C, 0x0327,), '013B -> 004C 0327';
ok Uni.new(0x013C).NFKD.list ~~ (0x006C, 0x0327,), '013C -> 006C 0327';
ok Uni.new(0x013D).NFKD.list ~~ (0x004C, 0x030C,), '013D -> 004C 030C';
ok Uni.new(0x013E).NFKD.list ~~ (0x006C, 0x030C,), '013E -> 006C 030C';
ok Uni.new(0x013F).NFKD.list ~~ (0x004C, 0x00B7,), '013F -> 004C 00B7';
ok Uni.new(0x0140).NFKD.list ~~ (0x006C, 0x00B7,), '0140 -> 006C 00B7';
ok Uni.new(0x0143).NFKD.list ~~ (0x004E, 0x0301,), '0143 -> 004E 0301';
ok Uni.new(0x0144).NFKD.list ~~ (0x006E, 0x0301,), '0144 -> 006E 0301';
ok Uni.new(0x0145).NFKD.list ~~ (0x004E, 0x0327,), '0145 -> 004E 0327';
ok Uni.new(0x0146).NFKD.list ~~ (0x006E, 0x0327,), '0146 -> 006E 0327';
ok Uni.new(0x0147).NFKD.list ~~ (0x004E, 0x030C,), '0147 -> 004E 030C';
ok Uni.new(0x0148).NFKD.list ~~ (0x006E, 0x030C,), '0148 -> 006E 030C';
ok Uni.new(0x0149).NFKD.list ~~ (0x02BC, 0x006E,), '0149 -> 02BC 006E';
ok Uni.new(0x014C).NFKD.list ~~ (0x004F, 0x0304,), '014C -> 004F 0304';
ok Uni.new(0x014D).NFKD.list ~~ (0x006F, 0x0304,), '014D -> 006F 0304';
ok Uni.new(0x014E).NFKD.list ~~ (0x004F, 0x0306,), '014E -> 004F 0306';
ok Uni.new(0x014F).NFKD.list ~~ (0x006F, 0x0306,), '014F -> 006F 0306';
ok Uni.new(0x0150).NFKD.list ~~ (0x004F, 0x030B,), '0150 -> 004F 030B';
ok Uni.new(0x0151).NFKD.list ~~ (0x006F, 0x030B,), '0151 -> 006F 030B';
ok Uni.new(0x0154).NFKD.list ~~ (0x0052, 0x0301,), '0154 -> 0052 0301';
ok Uni.new(0x0155).NFKD.list ~~ (0x0072, 0x0301,), '0155 -> 0072 0301';
ok Uni.new(0x0156).NFKD.list ~~ (0x0052, 0x0327,), '0156 -> 0052 0327';
ok Uni.new(0x0157).NFKD.list ~~ (0x0072, 0x0327,), '0157 -> 0072 0327';
ok Uni.new(0x0158).NFKD.list ~~ (0x0052, 0x030C,), '0158 -> 0052 030C';
ok Uni.new(0x0159).NFKD.list ~~ (0x0072, 0x030C,), '0159 -> 0072 030C';
ok Uni.new(0x015A).NFKD.list ~~ (0x0053, 0x0301,), '015A -> 0053 0301';
ok Uni.new(0x015B).NFKD.list ~~ (0x0073, 0x0301,), '015B -> 0073 0301';
ok Uni.new(0x015C).NFKD.list ~~ (0x0053, 0x0302,), '015C -> 0053 0302';
ok Uni.new(0x015D).NFKD.list ~~ (0x0073, 0x0302,), '015D -> 0073 0302';
ok Uni.new(0x015E).NFKD.list ~~ (0x0053, 0x0327,), '015E -> 0053 0327';
ok Uni.new(0x015F).NFKD.list ~~ (0x0073, 0x0327,), '015F -> 0073 0327';
ok Uni.new(0x0160).NFKD.list ~~ (0x0053, 0x030C,), '0160 -> 0053 030C';
ok Uni.new(0x0161).NFKD.list ~~ (0x0073, 0x030C,), '0161 -> 0073 030C';
ok Uni.new(0x0162).NFKD.list ~~ (0x0054, 0x0327,), '0162 -> 0054 0327';
ok Uni.new(0x0163).NFKD.list ~~ (0x0074, 0x0327,), '0163 -> 0074 0327';
ok Uni.new(0x0164).NFKD.list ~~ (0x0054, 0x030C,), '0164 -> 0054 030C';
ok Uni.new(0x0165).NFKD.list ~~ (0x0074, 0x030C,), '0165 -> 0074 030C';
ok Uni.new(0x0168).NFKD.list ~~ (0x0055, 0x0303,), '0168 -> 0055 0303';
ok Uni.new(0x0169).NFKD.list ~~ (0x0075, 0x0303,), '0169 -> 0075 0303';
ok Uni.new(0x016A).NFKD.list ~~ (0x0055, 0x0304,), '016A -> 0055 0304';
ok Uni.new(0x016B).NFKD.list ~~ (0x0075, 0x0304,), '016B -> 0075 0304';
ok Uni.new(0x016C).NFKD.list ~~ (0x0055, 0x0306,), '016C -> 0055 0306';
ok Uni.new(0x016D).NFKD.list ~~ (0x0075, 0x0306,), '016D -> 0075 0306';
ok Uni.new(0x016E).NFKD.list ~~ (0x0055, 0x030A,), '016E -> 0055 030A';
ok Uni.new(0x016F).NFKD.list ~~ (0x0075, 0x030A,), '016F -> 0075 030A';
ok Uni.new(0x0170).NFKD.list ~~ (0x0055, 0x030B,), '0170 -> 0055 030B';
ok Uni.new(0x0171).NFKD.list ~~ (0x0075, 0x030B,), '0171 -> 0075 030B';
ok Uni.new(0x0172).NFKD.list ~~ (0x0055, 0x0328,), '0172 -> 0055 0328';
ok Uni.new(0x0173).NFKD.list ~~ (0x0075, 0x0328,), '0173 -> 0075 0328';
ok Uni.new(0x0174).NFKD.list ~~ (0x0057, 0x0302,), '0174 -> 0057 0302';
ok Uni.new(0x0175).NFKD.list ~~ (0x0077, 0x0302,), '0175 -> 0077 0302';
ok Uni.new(0x0176).NFKD.list ~~ (0x0059, 0x0302,), '0176 -> 0059 0302';
ok Uni.new(0x0177).NFKD.list ~~ (0x0079, 0x0302,), '0177 -> 0079 0302';
ok Uni.new(0x0178).NFKD.list ~~ (0x0059, 0x0308,), '0178 -> 0059 0308';
ok Uni.new(0x0179).NFKD.list ~~ (0x005A, 0x0301,), '0179 -> 005A 0301';
ok Uni.new(0x017A).NFKD.list ~~ (0x007A, 0x0301,), '017A -> 007A 0301';
ok Uni.new(0x017B).NFKD.list ~~ (0x005A, 0x0307,), '017B -> 005A 0307';
ok Uni.new(0x017C).NFKD.list ~~ (0x007A, 0x0307,), '017C -> 007A 0307';
ok Uni.new(0x017D).NFKD.list ~~ (0x005A, 0x030C,), '017D -> 005A 030C';
ok Uni.new(0x017E).NFKD.list ~~ (0x007A, 0x030C,), '017E -> 007A 030C';
ok Uni.new(0x017F).NFKD.list ~~ (0x0073,), '017F -> 0073';
ok Uni.new(0x01A0).NFKD.list ~~ (0x004F, 0x031B,), '01A0 -> 004F 031B';
ok Uni.new(0x01A1).NFKD.list ~~ (0x006F, 0x031B,), '01A1 -> 006F 031B';
ok Uni.new(0x01AF).NFKD.list ~~ (0x0055, 0x031B,), '01AF -> 0055 031B';
ok Uni.new(0x01B0).NFKD.list ~~ (0x0075, 0x031B,), '01B0 -> 0075 031B';
ok Uni.new(0x01C4).NFKD.list ~~ (0x0044, 0x005A, 0x030C,), '01C4 -> 0044 005A 030C';
ok Uni.new(0x01C5).NFKD.list ~~ (0x0044, 0x007A, 0x030C,), '01C5 -> 0044 007A 030C';
ok Uni.new(0x01C6).NFKD.list ~~ (0x0064, 0x007A, 0x030C,), '01C6 -> 0064 007A 030C';
ok Uni.new(0x01C7).NFKD.list ~~ (0x004C, 0x004A,), '01C7 -> 004C 004A';
ok Uni.new(0x01C8).NFKD.list ~~ (0x004C, 0x006A,), '01C8 -> 004C 006A';
ok Uni.new(0x01C9).NFKD.list ~~ (0x006C, 0x006A,), '01C9 -> 006C 006A';
ok Uni.new(0x01CA).NFKD.list ~~ (0x004E, 0x004A,), '01CA -> 004E 004A';
ok Uni.new(0x01CB).NFKD.list ~~ (0x004E, 0x006A,), '01CB -> 004E 006A';
ok Uni.new(0x01CC).NFKD.list ~~ (0x006E, 0x006A,), '01CC -> 006E 006A';
ok Uni.new(0x01CD).NFKD.list ~~ (0x0041, 0x030C,), '01CD -> 0041 030C';
ok Uni.new(0x01CE).NFKD.list ~~ (0x0061, 0x030C,), '01CE -> 0061 030C';
ok Uni.new(0x01CF).NFKD.list ~~ (0x0049, 0x030C,), '01CF -> 0049 030C';
ok Uni.new(0x01D0).NFKD.list ~~ (0x0069, 0x030C,), '01D0 -> 0069 030C';
ok Uni.new(0x01D1).NFKD.list ~~ (0x004F, 0x030C,), '01D1 -> 004F 030C';
ok Uni.new(0x01D2).NFKD.list ~~ (0x006F, 0x030C,), '01D2 -> 006F 030C';
ok Uni.new(0x01D3).NFKD.list ~~ (0x0055, 0x030C,), '01D3 -> 0055 030C';
ok Uni.new(0x01D4).NFKD.list ~~ (0x0075, 0x030C,), '01D4 -> 0075 030C';
ok Uni.new(0x01D5).NFKD.list ~~ (0x0055, 0x0308, 0x0304,), '01D5 -> 0055 0308 0304';
ok Uni.new(0x01D6).NFKD.list ~~ (0x0075, 0x0308, 0x0304,), '01D6 -> 0075 0308 0304';
ok Uni.new(0x01D7).NFKD.list ~~ (0x0055, 0x0308, 0x0301,), '01D7 -> 0055 0308 0301';
ok Uni.new(0x01D8).NFKD.list ~~ (0x0075, 0x0308, 0x0301,), '01D8 -> 0075 0308 0301';
ok Uni.new(0x01D9).NFKD.list ~~ (0x0055, 0x0308, 0x030C,), '01D9 -> 0055 0308 030C';
ok Uni.new(0x01DA).NFKD.list ~~ (0x0075, 0x0308, 0x030C,), '01DA -> 0075 0308 030C';
ok Uni.new(0x01DB).NFKD.list ~~ (0x0055, 0x0308, 0x0300,), '01DB -> 0055 0308 0300';
ok Uni.new(0x01DC).NFKD.list ~~ (0x0075, 0x0308, 0x0300,), '01DC -> 0075 0308 0300';
ok Uni.new(0x01DE).NFKD.list ~~ (0x0041, 0x0308, 0x0304,), '01DE -> 0041 0308 0304';
ok Uni.new(0x01DF).NFKD.list ~~ (0x0061, 0x0308, 0x0304,), '01DF -> 0061 0308 0304';
ok Uni.new(0x01E0).NFKD.list ~~ (0x0041, 0x0307, 0x0304,), '01E0 -> 0041 0307 0304';
ok Uni.new(0x01E1).NFKD.list ~~ (0x0061, 0x0307, 0x0304,), '01E1 -> 0061 0307 0304';
ok Uni.new(0x01E2).NFKD.list ~~ (0x00C6, 0x0304,), '01E2 -> 00C6 0304';
ok Uni.new(0x01E3).NFKD.list ~~ (0x00E6, 0x0304,), '01E3 -> 00E6 0304';
ok Uni.new(0x01E6).NFKD.list ~~ (0x0047, 0x030C,), '01E6 -> 0047 030C';
ok Uni.new(0x01E7).NFKD.list ~~ (0x0067, 0x030C,), '01E7 -> 0067 030C';
ok Uni.new(0x01E8).NFKD.list ~~ (0x004B, 0x030C,), '01E8 -> 004B 030C';
ok Uni.new(0x01E9).NFKD.list ~~ (0x006B, 0x030C,), '01E9 -> 006B 030C';
ok Uni.new(0x01EA).NFKD.list ~~ (0x004F, 0x0328,), '01EA -> 004F 0328';
ok Uni.new(0x01EB).NFKD.list ~~ (0x006F, 0x0328,), '01EB -> 006F 0328';
ok Uni.new(0x01EC).NFKD.list ~~ (0x004F, 0x0328, 0x0304,), '01EC -> 004F 0328 0304';
ok Uni.new(0x01ED).NFKD.list ~~ (0x006F, 0x0328, 0x0304,), '01ED -> 006F 0328 0304';
ok Uni.new(0x01EE).NFKD.list ~~ (0x01B7, 0x030C,), '01EE -> 01B7 030C';
ok Uni.new(0x01EF).NFKD.list ~~ (0x0292, 0x030C,), '01EF -> 0292 030C';
ok Uni.new(0x01F0).NFKD.list ~~ (0x006A, 0x030C,), '01F0 -> 006A 030C';
ok Uni.new(0x01F1).NFKD.list ~~ (0x0044, 0x005A,), '01F1 -> 0044 005A';
ok Uni.new(0x01F2).NFKD.list ~~ (0x0044, 0x007A,), '01F2 -> 0044 007A';
ok Uni.new(0x01F3).NFKD.list ~~ (0x0064, 0x007A,), '01F3 -> 0064 007A';
ok Uni.new(0x01F4).NFKD.list ~~ (0x0047, 0x0301,), '01F4 -> 0047 0301';
ok Uni.new(0x01F5).NFKD.list ~~ (0x0067, 0x0301,), '01F5 -> 0067 0301';
ok Uni.new(0x01F8).NFKD.list ~~ (0x004E, 0x0300,), '01F8 -> 004E 0300';
ok Uni.new(0x01F9).NFKD.list ~~ (0x006E, 0x0300,), '01F9 -> 006E 0300';
ok Uni.new(0x01FA).NFKD.list ~~ (0x0041, 0x030A, 0x0301,), '01FA -> 0041 030A 0301';
ok Uni.new(0x01FB).NFKD.list ~~ (0x0061, 0x030A, 0x0301,), '01FB -> 0061 030A 0301';
ok Uni.new(0x01FC).NFKD.list ~~ (0x00C6, 0x0301,), '01FC -> 00C6 0301';
ok Uni.new(0x01FD).NFKD.list ~~ (0x00E6, 0x0301,), '01FD -> 00E6 0301';
ok Uni.new(0x01FE).NFKD.list ~~ (0x00D8, 0x0301,), '01FE -> 00D8 0301';
ok Uni.new(0x01FF).NFKD.list ~~ (0x00F8, 0x0301,), '01FF -> 00F8 0301';
ok Uni.new(0x0200).NFKD.list ~~ (0x0041, 0x030F,), '0200 -> 0041 030F';
ok Uni.new(0x0201).NFKD.list ~~ (0x0061, 0x030F,), '0201 -> 0061 030F';
ok Uni.new(0x0202).NFKD.list ~~ (0x0041, 0x0311,), '0202 -> 0041 0311';
ok Uni.new(0x0203).NFKD.list ~~ (0x0061, 0x0311,), '0203 -> 0061 0311';
ok Uni.new(0x0204).NFKD.list ~~ (0x0045, 0x030F,), '0204 -> 0045 030F';
ok Uni.new(0x0205).NFKD.list ~~ (0x0065, 0x030F,), '0205 -> 0065 030F';
ok Uni.new(0x0206).NFKD.list ~~ (0x0045, 0x0311,), '0206 -> 0045 0311';
ok Uni.new(0x0207).NFKD.list ~~ (0x0065, 0x0311,), '0207 -> 0065 0311';
ok Uni.new(0x0208).NFKD.list ~~ (0x0049, 0x030F,), '0208 -> 0049 030F';
ok Uni.new(0x0209).NFKD.list ~~ (0x0069, 0x030F,), '0209 -> 0069 030F';
ok Uni.new(0x020A).NFKD.list ~~ (0x0049, 0x0311,), '020A -> 0049 0311';
ok Uni.new(0x020B).NFKD.list ~~ (0x0069, 0x0311,), '020B -> 0069 0311';
ok Uni.new(0x020C).NFKD.list ~~ (0x004F, 0x030F,), '020C -> 004F 030F';
ok Uni.new(0x020D).NFKD.list ~~ (0x006F, 0x030F,), '020D -> 006F 030F';
ok Uni.new(0x020E).NFKD.list ~~ (0x004F, 0x0311,), '020E -> 004F 0311';
ok Uni.new(0x020F).NFKD.list ~~ (0x006F, 0x0311,), '020F -> 006F 0311';
ok Uni.new(0x0210).NFKD.list ~~ (0x0052, 0x030F,), '0210 -> 0052 030F';
ok Uni.new(0x0211).NFKD.list ~~ (0x0072, 0x030F,), '0211 -> 0072 030F';
ok Uni.new(0x0212).NFKD.list ~~ (0x0052, 0x0311,), '0212 -> 0052 0311';
ok Uni.new(0x0213).NFKD.list ~~ (0x0072, 0x0311,), '0213 -> 0072 0311';
ok Uni.new(0x0214).NFKD.list ~~ (0x0055, 0x030F,), '0214 -> 0055 030F';
ok Uni.new(0x0215).NFKD.list ~~ (0x0075, 0x030F,), '0215 -> 0075 030F';
ok Uni.new(0x0216).NFKD.list ~~ (0x0055, 0x0311,), '0216 -> 0055 0311';
ok Uni.new(0x0217).NFKD.list ~~ (0x0075, 0x0311,), '0217 -> 0075 0311';
ok Uni.new(0x0218).NFKD.list ~~ (0x0053, 0x0326,), '0218 -> 0053 0326';
ok Uni.new(0x0219).NFKD.list ~~ (0x0073, 0x0326,), '0219 -> 0073 0326';
ok Uni.new(0x021A).NFKD.list ~~ (0x0054, 0x0326,), '021A -> 0054 0326';
ok Uni.new(0x021B).NFKD.list ~~ (0x0074, 0x0326,), '021B -> 0074 0326';
ok Uni.new(0x021E).NFKD.list ~~ (0x0048, 0x030C,), '021E -> 0048 030C';
ok Uni.new(0x021F).NFKD.list ~~ (0x0068, 0x030C,), '021F -> 0068 030C';
ok Uni.new(0x0226).NFKD.list ~~ (0x0041, 0x0307,), '0226 -> 0041 0307';
ok Uni.new(0x0227).NFKD.list ~~ (0x0061, 0x0307,), '0227 -> 0061 0307';
ok Uni.new(0x0228).NFKD.list ~~ (0x0045, 0x0327,), '0228 -> 0045 0327';
ok Uni.new(0x0229).NFKD.list ~~ (0x0065, 0x0327,), '0229 -> 0065 0327';
ok Uni.new(0x022A).NFKD.list ~~ (0x004F, 0x0308, 0x0304,), '022A -> 004F 0308 0304';
ok Uni.new(0x022B).NFKD.list ~~ (0x006F, 0x0308, 0x0304,), '022B -> 006F 0308 0304';
ok Uni.new(0x022C).NFKD.list ~~ (0x004F, 0x0303, 0x0304,), '022C -> 004F 0303 0304';
ok Uni.new(0x022D).NFKD.list ~~ (0x006F, 0x0303, 0x0304,), '022D -> 006F 0303 0304';
ok Uni.new(0x022E).NFKD.list ~~ (0x004F, 0x0307,), '022E -> 004F 0307';
ok Uni.new(0x022F).NFKD.list ~~ (0x006F, 0x0307,), '022F -> 006F 0307';
ok Uni.new(0x0230).NFKD.list ~~ (0x004F, 0x0307, 0x0304,), '0230 -> 004F 0307 0304';
ok Uni.new(0x0231).NFKD.list ~~ (0x006F, 0x0307, 0x0304,), '0231 -> 006F 0307 0304';
ok Uni.new(0x0232).NFKD.list ~~ (0x0059, 0x0304,), '0232 -> 0059 0304';
ok Uni.new(0x0233).NFKD.list ~~ (0x0079, 0x0304,), '0233 -> 0079 0304';
ok Uni.new(0x02B0).NFKD.list ~~ (0x0068,), '02B0 -> 0068';
ok Uni.new(0x02B1).NFKD.list ~~ (0x0266,), '02B1 -> 0266';
ok Uni.new(0x02B2).NFKD.list ~~ (0x006A,), '02B2 -> 006A';
ok Uni.new(0x02B3).NFKD.list ~~ (0x0072,), '02B3 -> 0072';
ok Uni.new(0x02B4).NFKD.list ~~ (0x0279,), '02B4 -> 0279';
ok Uni.new(0x02B5).NFKD.list ~~ (0x027B,), '02B5 -> 027B';
ok Uni.new(0x02B6).NFKD.list ~~ (0x0281,), '02B6 -> 0281';
ok Uni.new(0x02B7).NFKD.list ~~ (0x0077,), '02B7 -> 0077';
ok Uni.new(0x02B8).NFKD.list ~~ (0x0079,), '02B8 -> 0079';
ok Uni.new(0x02D8).NFKD.list ~~ (0x0020, 0x0306,), '02D8 -> 0020 0306';
ok Uni.new(0x02D9).NFKD.list ~~ (0x0020, 0x0307,), '02D9 -> 0020 0307';
ok Uni.new(0x02DA).NFKD.list ~~ (0x0020, 0x030A,), '02DA -> 0020 030A';
ok Uni.new(0x02DB).NFKD.list ~~ (0x0020, 0x0328,), '02DB -> 0020 0328';
ok Uni.new(0x02DC).NFKD.list ~~ (0x0020, 0x0303,), '02DC -> 0020 0303';
ok Uni.new(0x02DD).NFKD.list ~~ (0x0020, 0x030B,), '02DD -> 0020 030B';
ok Uni.new(0x02E0).NFKD.list ~~ (0x0263,), '02E0 -> 0263';
ok Uni.new(0x02E1).NFKD.list ~~ (0x006C,), '02E1 -> 006C';
ok Uni.new(0x02E2).NFKD.list ~~ (0x0073,), '02E2 -> 0073';
ok Uni.new(0x02E3).NFKD.list ~~ (0x0078,), '02E3 -> 0078';
ok Uni.new(0x02E4).NFKD.list ~~ (0x0295,), '02E4 -> 0295';
ok Uni.new(0x0340).NFKD.list ~~ (0x0300,), '0340 -> 0300';
ok Uni.new(0x0341).NFKD.list ~~ (0x0301,), '0341 -> 0301';
ok Uni.new(0x0343).NFKD.list ~~ (0x0313,), '0343 -> 0313';
ok Uni.new(0x0344).NFKD.list ~~ (0x0308, 0x0301,), '0344 -> 0308 0301';
ok Uni.new(0x0374).NFKD.list ~~ (0x02B9,), '0374 -> 02B9';
ok Uni.new(0x037A).NFKD.list ~~ (0x0020, 0x0345,), '037A -> 0020 0345';
ok Uni.new(0x037E).NFKD.list ~~ (0x003B,), '037E -> 003B';
ok Uni.new(0x0384).NFKD.list ~~ (0x0020, 0x0301,), '0384 -> 0020 0301';
ok Uni.new(0x0385).NFKD.list ~~ (0x0020, 0x0308, 0x0301,), '0385 -> 0020 0308 0301';
ok Uni.new(0x0386).NFKD.list ~~ (0x0391, 0x0301,), '0386 -> 0391 0301';
ok Uni.new(0x0387).NFKD.list ~~ (0x00B7,), '0387 -> 00B7';
ok Uni.new(0x0388).NFKD.list ~~ (0x0395, 0x0301,), '0388 -> 0395 0301';
ok Uni.new(0x0389).NFKD.list ~~ (0x0397, 0x0301,), '0389 -> 0397 0301';
ok Uni.new(0x038A).NFKD.list ~~ (0x0399, 0x0301,), '038A -> 0399 0301';
ok Uni.new(0x038C).NFKD.list ~~ (0x039F, 0x0301,), '038C -> 039F 0301';
ok Uni.new(0x038E).NFKD.list ~~ (0x03A5, 0x0301,), '038E -> 03A5 0301';
ok Uni.new(0x038F).NFKD.list ~~ (0x03A9, 0x0301,), '038F -> 03A9 0301';
ok Uni.new(0x0390).NFKD.list ~~ (0x03B9, 0x0308, 0x0301,), '0390 -> 03B9 0308 0301';
ok Uni.new(0x03AA).NFKD.list ~~ (0x0399, 0x0308,), '03AA -> 0399 0308';
ok Uni.new(0x03AB).NFKD.list ~~ (0x03A5, 0x0308,), '03AB -> 03A5 0308';
ok Uni.new(0x03AC).NFKD.list ~~ (0x03B1, 0x0301,), '03AC -> 03B1 0301';
ok Uni.new(0x03AD).NFKD.list ~~ (0x03B5, 0x0301,), '03AD -> 03B5 0301';
ok Uni.new(0x03AE).NFKD.list ~~ (0x03B7, 0x0301,), '03AE -> 03B7 0301';
ok Uni.new(0x03AF).NFKD.list ~~ (0x03B9, 0x0301,), '03AF -> 03B9 0301';
ok Uni.new(0x03B0).NFKD.list ~~ (0x03C5, 0x0308, 0x0301,), '03B0 -> 03C5 0308 0301';
ok Uni.new(0x03CA).NFKD.list ~~ (0x03B9, 0x0308,), '03CA -> 03B9 0308';
ok Uni.new(0x03CB).NFKD.list ~~ (0x03C5, 0x0308,), '03CB -> 03C5 0308';
ok Uni.new(0x03CC).NFKD.list ~~ (0x03BF, 0x0301,), '03CC -> 03BF 0301';
ok Uni.new(0x03CD).NFKD.list ~~ (0x03C5, 0x0301,), '03CD -> 03C5 0301';
ok Uni.new(0x03CE).NFKD.list ~~ (0x03C9, 0x0301,), '03CE -> 03C9 0301';
ok Uni.new(0x03D0).NFKD.list ~~ (0x03B2,), '03D0 -> 03B2';
ok Uni.new(0x03D1).NFKD.list ~~ (0x03B8,), '03D1 -> 03B8';
ok Uni.new(0x03D2).NFKD.list ~~ (0x03A5,), '03D2 -> 03A5';
ok Uni.new(0x03D3).NFKD.list ~~ (0x03A5, 0x0301,), '03D3 -> 03A5 0301';
ok Uni.new(0x03D4).NFKD.list ~~ (0x03A5, 0x0308,), '03D4 -> 03A5 0308';
ok Uni.new(0x03D5).NFKD.list ~~ (0x03C6,), '03D5 -> 03C6';
ok Uni.new(0x03D6).NFKD.list ~~ (0x03C0,), '03D6 -> 03C0';
ok Uni.new(0x03F0).NFKD.list ~~ (0x03BA,), '03F0 -> 03BA';
ok Uni.new(0x03F1).NFKD.list ~~ (0x03C1,), '03F1 -> 03C1';
ok Uni.new(0x03F2).NFKD.list ~~ (0x03C2,), '03F2 -> 03C2';
ok Uni.new(0x03F4).NFKD.list ~~ (0x0398,), '03F4 -> 0398';
ok Uni.new(0x03F5).NFKD.list ~~ (0x03B5,), '03F5 -> 03B5';
ok Uni.new(0x03F9).NFKD.list ~~ (0x03A3,), '03F9 -> 03A3';
ok Uni.new(0x0400).NFKD.list ~~ (0x0415, 0x0300,), '0400 -> 0415 0300';
ok Uni.new(0x0401).NFKD.list ~~ (0x0415, 0x0308,), '0401 -> 0415 0308';
ok Uni.new(0x0403).NFKD.list ~~ (0x0413, 0x0301,), '0403 -> 0413 0301';
ok Uni.new(0x0407).NFKD.list ~~ (0x0406, 0x0308,), '0407 -> 0406 0308';
ok Uni.new(0x040C).NFKD.list ~~ (0x041A, 0x0301,), '040C -> 041A 0301';
ok Uni.new(0x040D).NFKD.list ~~ (0x0418, 0x0300,), '040D -> 0418 0300';
ok Uni.new(0x040E).NFKD.list ~~ (0x0423, 0x0306,), '040E -> 0423 0306';
ok Uni.new(0x0419).NFKD.list ~~ (0x0418, 0x0306,), '0419 -> 0418 0306';
ok Uni.new(0x0439).NFKD.list ~~ (0x0438, 0x0306,), '0439 -> 0438 0306';
ok Uni.new(0x0450).NFKD.list ~~ (0x0435, 0x0300,), '0450 -> 0435 0300';
ok Uni.new(0x0451).NFKD.list ~~ (0x0435, 0x0308,), '0451 -> 0435 0308';
ok Uni.new(0x0453).NFKD.list ~~ (0x0433, 0x0301,), '0453 -> 0433 0301';
ok Uni.new(0x0457).NFKD.list ~~ (0x0456, 0x0308,), '0457 -> 0456 0308';
ok Uni.new(0x045C).NFKD.list ~~ (0x043A, 0x0301,), '045C -> 043A 0301';
ok Uni.new(0x045D).NFKD.list ~~ (0x0438, 0x0300,), '045D -> 0438 0300';
ok Uni.new(0x045E).NFKD.list ~~ (0x0443, 0x0306,), '045E -> 0443 0306';
ok Uni.new(0x0476).NFKD.list ~~ (0x0474, 0x030F,), '0476 -> 0474 030F';
ok Uni.new(0x0477).NFKD.list ~~ (0x0475, 0x030F,), '0477 -> 0475 030F';
ok Uni.new(0x04C1).NFKD.list ~~ (0x0416, 0x0306,), '04C1 -> 0416 0306';
ok Uni.new(0x04C2).NFKD.list ~~ (0x0436, 0x0306,), '04C2 -> 0436 0306';
ok Uni.new(0x04D0).NFKD.list ~~ (0x0410, 0x0306,), '04D0 -> 0410 0306';
ok Uni.new(0x04D1).NFKD.list ~~ (0x0430, 0x0306,), '04D1 -> 0430 0306';
ok Uni.new(0x04D2).NFKD.list ~~ (0x0410, 0x0308,), '04D2 -> 0410 0308';
ok Uni.new(0x04D3).NFKD.list ~~ (0x0430, 0x0308,), '04D3 -> 0430 0308';
ok Uni.new(0x04D6).NFKD.list ~~ (0x0415, 0x0306,), '04D6 -> 0415 0306';
ok Uni.new(0x04D7).NFKD.list ~~ (0x0435, 0x0306,), '04D7 -> 0435 0306';
ok Uni.new(0x04DA).NFKD.list ~~ (0x04D8, 0x0308,), '04DA -> 04D8 0308';
ok Uni.new(0x04DB).NFKD.list ~~ (0x04D9, 0x0308,), '04DB -> 04D9 0308';
ok Uni.new(0x04DC).NFKD.list ~~ (0x0416, 0x0308,), '04DC -> 0416 0308';
ok Uni.new(0x04DD).NFKD.list ~~ (0x0436, 0x0308,), '04DD -> 0436 0308';
ok Uni.new(0x04DE).NFKD.list ~~ (0x0417, 0x0308,), '04DE -> 0417 0308';
ok Uni.new(0x04DF).NFKD.list ~~ (0x0437, 0x0308,), '04DF -> 0437 0308';
ok Uni.new(0x04E2).NFKD.list ~~ (0x0418, 0x0304,), '04E2 -> 0418 0304';
ok Uni.new(0x04E3).NFKD.list ~~ (0x0438, 0x0304,), '04E3 -> 0438 0304';
ok Uni.new(0x04E4).NFKD.list ~~ (0x0418, 0x0308,), '04E4 -> 0418 0308';
ok Uni.new(0x04E5).NFKD.list ~~ (0x0438, 0x0308,), '04E5 -> 0438 0308';
ok Uni.new(0x04E6).NFKD.list ~~ (0x041E, 0x0308,), '04E6 -> 041E 0308';
ok Uni.new(0x04E7).NFKD.list ~~ (0x043E, 0x0308,), '04E7 -> 043E 0308';
ok Uni.new(0x04EA).NFKD.list ~~ (0x04E8, 0x0308,), '04EA -> 04E8 0308';
ok Uni.new(0x04EB).NFKD.list ~~ (0x04E9, 0x0308,), '04EB -> 04E9 0308';
ok Uni.new(0x04EC).NFKD.list ~~ (0x042D, 0x0308,), '04EC -> 042D 0308';
ok Uni.new(0x04ED).NFKD.list ~~ (0x044D, 0x0308,), '04ED -> 044D 0308';
ok Uni.new(0x04EE).NFKD.list ~~ (0x0423, 0x0304,), '04EE -> 0423 0304';
ok Uni.new(0x04EF).NFKD.list ~~ (0x0443, 0x0304,), '04EF -> 0443 0304';
ok Uni.new(0x04F0).NFKD.list ~~ (0x0423, 0x0308,), '04F0 -> 0423 0308';
ok Uni.new(0x04F1).NFKD.list ~~ (0x0443, 0x0308,), '04F1 -> 0443 0308';
ok Uni.new(0x04F2).NFKD.list ~~ (0x0423, 0x030B,), '04F2 -> 0423 030B';
ok Uni.new(0x04F3).NFKD.list ~~ (0x0443, 0x030B,), '04F3 -> 0443 030B';
ok Uni.new(0x04F4).NFKD.list ~~ (0x0427, 0x0308,), '04F4 -> 0427 0308';
ok Uni.new(0x04F5).NFKD.list ~~ (0x0447, 0x0308,), '04F5 -> 0447 0308';
ok Uni.new(0x04F8).NFKD.list ~~ (0x042B, 0x0308,), '04F8 -> 042B 0308';
ok Uni.new(0x04F9).NFKD.list ~~ (0x044B, 0x0308,), '04F9 -> 044B 0308';
ok Uni.new(0x0587).NFKD.list ~~ (0x0565, 0x0582,), '0587 -> 0565 0582';
ok Uni.new(0x0622).NFKD.list ~~ (0x0627, 0x0653,), '0622 -> 0627 0653';
ok Uni.new(0x0623).NFKD.list ~~ (0x0627, 0x0654,), '0623 -> 0627 0654';
ok Uni.new(0x0624).NFKD.list ~~ (0x0648, 0x0654,), '0624 -> 0648 0654';
ok Uni.new(0x0625).NFKD.list ~~ (0x0627, 0x0655,), '0625 -> 0627 0655';
ok Uni.new(0x0626).NFKD.list ~~ (0x064A, 0x0654,), '0626 -> 064A 0654';
ok Uni.new(0x0675).NFKD.list ~~ (0x0627, 0x0674,), '0675 -> 0627 0674';
ok Uni.new(0x0676).NFKD.list ~~ (0x0648, 0x0674,), '0676 -> 0648 0674';
ok Uni.new(0x0677).NFKD.list ~~ (0x06C7, 0x0674,), '0677 -> 06C7 0674';
ok Uni.new(0x0678).NFKD.list ~~ (0x064A, 0x0674,), '0678 -> 064A 0674';
ok Uni.new(0x06C0).NFKD.list ~~ (0x06D5, 0x0654,), '06C0 -> 06D5 0654';
ok Uni.new(0x06C2).NFKD.list ~~ (0x06C1, 0x0654,), '06C2 -> 06C1 0654';
ok Uni.new(0x06D3).NFKD.list ~~ (0x06D2, 0x0654,), '06D3 -> 06D2 0654';
ok Uni.new(0x0929).NFKD.list ~~ (0x0928, 0x093C,), '0929 -> 0928 093C';
ok Uni.new(0x0931).NFKD.list ~~ (0x0930, 0x093C,), '0931 -> 0930 093C';
ok Uni.new(0x0934).NFKD.list ~~ (0x0933, 0x093C,), '0934 -> 0933 093C';
ok Uni.new(0x0958).NFKD.list ~~ (0x0915, 0x093C,), '0958 -> 0915 093C';
ok Uni.new(0x0959).NFKD.list ~~ (0x0916, 0x093C,), '0959 -> 0916 093C';
ok Uni.new(0x095A).NFKD.list ~~ (0x0917, 0x093C,), '095A -> 0917 093C';
ok Uni.new(0x095B).NFKD.list ~~ (0x091C, 0x093C,), '095B -> 091C 093C';
ok Uni.new(0x095C).NFKD.list ~~ (0x0921, 0x093C,), '095C -> 0921 093C';
ok Uni.new(0x095D).NFKD.list ~~ (0x0922, 0x093C,), '095D -> 0922 093C';
ok Uni.new(0x095E).NFKD.list ~~ (0x092B, 0x093C,), '095E -> 092B 093C';
ok Uni.new(0x095F).NFKD.list ~~ (0x092F, 0x093C,), '095F -> 092F 093C';
ok Uni.new(0x09CB).NFKD.list ~~ (0x09C7, 0x09BE,), '09CB -> 09C7 09BE';
ok Uni.new(0x09CC).NFKD.list ~~ (0x09C7, 0x09D7,), '09CC -> 09C7 09D7';
ok Uni.new(0x09DC).NFKD.list ~~ (0x09A1, 0x09BC,), '09DC -> 09A1 09BC';
ok Uni.new(0x09DD).NFKD.list ~~ (0x09A2, 0x09BC,), '09DD -> 09A2 09BC';
ok Uni.new(0x09DF).NFKD.list ~~ (0x09AF, 0x09BC,), '09DF -> 09AF 09BC';
ok Uni.new(0x0A33).NFKD.list ~~ (0x0A32, 0x0A3C,), '0A33 -> 0A32 0A3C';
ok Uni.new(0x0A36).NFKD.list ~~ (0x0A38, 0x0A3C,), '0A36 -> 0A38 0A3C';
ok Uni.new(0x0A59).NFKD.list ~~ (0x0A16, 0x0A3C,), '0A59 -> 0A16 0A3C';
ok Uni.new(0x0A5A).NFKD.list ~~ (0x0A17, 0x0A3C,), '0A5A -> 0A17 0A3C';
ok Uni.new(0x0A5B).NFKD.list ~~ (0x0A1C, 0x0A3C,), '0A5B -> 0A1C 0A3C';
ok Uni.new(0x0A5E).NFKD.list ~~ (0x0A2B, 0x0A3C,), '0A5E -> 0A2B 0A3C';
ok Uni.new(0x0B48).NFKD.list ~~ (0x0B47, 0x0B56,), '0B48 -> 0B47 0B56';
ok Uni.new(0x0B4B).NFKD.list ~~ (0x0B47, 0x0B3E,), '0B4B -> 0B47 0B3E';
ok Uni.new(0x0B4C).NFKD.list ~~ (0x0B47, 0x0B57,), '0B4C -> 0B47 0B57';
ok Uni.new(0x0B5C).NFKD.list ~~ (0x0B21, 0x0B3C,), '0B5C -> 0B21 0B3C';
ok Uni.new(0x0B5D).NFKD.list ~~ (0x0B22, 0x0B3C,), '0B5D -> 0B22 0B3C';
ok Uni.new(0x0B94).NFKD.list ~~ (0x0B92, 0x0BD7,), '0B94 -> 0B92 0BD7';
ok Uni.new(0x0BCA).NFKD.list ~~ (0x0BC6, 0x0BBE,), '0BCA -> 0BC6 0BBE';
ok Uni.new(0x0BCB).NFKD.list ~~ (0x0BC7, 0x0BBE,), '0BCB -> 0BC7 0BBE';
ok Uni.new(0x0BCC).NFKD.list ~~ (0x0BC6, 0x0BD7,), '0BCC -> 0BC6 0BD7';
ok Uni.new(0x0C48).NFKD.list ~~ (0x0C46, 0x0C56,), '0C48 -> 0C46 0C56';
ok Uni.new(0x0CC0).NFKD.list ~~ (0x0CBF, 0x0CD5,), '0CC0 -> 0CBF 0CD5';
ok Uni.new(0x0CC7).NFKD.list ~~ (0x0CC6, 0x0CD5,), '0CC7 -> 0CC6 0CD5';
ok Uni.new(0x0CC8).NFKD.list ~~ (0x0CC6, 0x0CD6,), '0CC8 -> 0CC6 0CD6';
ok Uni.new(0x0CCA).NFKD.list ~~ (0x0CC6, 0x0CC2,), '0CCA -> 0CC6 0CC2';
ok Uni.new(0x0CCB).NFKD.list ~~ (0x0CC6, 0x0CC2, 0x0CD5,), '0CCB -> 0CC6 0CC2 0CD5';
ok Uni.new(0x0D4A).NFKD.list ~~ (0x0D46, 0x0D3E,), '0D4A -> 0D46 0D3E';
ok Uni.new(0x0D4B).NFKD.list ~~ (0x0D47, 0x0D3E,), '0D4B -> 0D47 0D3E';
ok Uni.new(0x0D4C).NFKD.list ~~ (0x0D46, 0x0D57,), '0D4C -> 0D46 0D57';
ok Uni.new(0x0DDA).NFKD.list ~~ (0x0DD9, 0x0DCA,), '0DDA -> 0DD9 0DCA';
ok Uni.new(0x0DDC).NFKD.list ~~ (0x0DD9, 0x0DCF,), '0DDC -> 0DD9 0DCF';
ok Uni.new(0x0DDD).NFKD.list ~~ (0x0DD9, 0x0DCF, 0x0DCA,), '0DDD -> 0DD9 0DCF 0DCA';
ok Uni.new(0x0DDE).NFKD.list ~~ (0x0DD9, 0x0DDF,), '0DDE -> 0DD9 0DDF';
ok Uni.new(0x0E33).NFKD.list ~~ (0x0E4D, 0x0E32,), '0E33 -> 0E4D 0E32';
ok Uni.new(0x0EB3).NFKD.list ~~ (0x0ECD, 0x0EB2,), '0EB3 -> 0ECD 0EB2';
ok Uni.new(0x0EDC).NFKD.list ~~ (0x0EAB, 0x0E99,), '0EDC -> 0EAB 0E99';
ok Uni.new(0x0EDD).NFKD.list ~~ (0x0EAB, 0x0EA1,), '0EDD -> 0EAB 0EA1';
ok Uni.new(0x0F0C).NFKD.list ~~ (0x0F0B,), '0F0C -> 0F0B';
ok Uni.new(0x0F43).NFKD.list ~~ (0x0F42, 0x0FB7,), '0F43 -> 0F42 0FB7';
ok Uni.new(0x0F4D).NFKD.list ~~ (0x0F4C, 0x0FB7,), '0F4D -> 0F4C 0FB7';
ok Uni.new(0x0F52).NFKD.list ~~ (0x0F51, 0x0FB7,), '0F52 -> 0F51 0FB7';
ok Uni.new(0x0F57).NFKD.list ~~ (0x0F56, 0x0FB7,), '0F57 -> 0F56 0FB7';
ok Uni.new(0x0F5C).NFKD.list ~~ (0x0F5B, 0x0FB7,), '0F5C -> 0F5B 0FB7';
ok Uni.new(0x0F69).NFKD.list ~~ (0x0F40, 0x0FB5,), '0F69 -> 0F40 0FB5';
ok Uni.new(0x0F73).NFKD.list ~~ (0x0F71, 0x0F72,), '0F73 -> 0F71 0F72';
ok Uni.new(0x0F75).NFKD.list ~~ (0x0F71, 0x0F74,), '0F75 -> 0F71 0F74';
ok Uni.new(0x0F76).NFKD.list ~~ (0x0FB2, 0x0F80,), '0F76 -> 0FB2 0F80';
ok Uni.new(0x0F77).NFKD.list ~~ (0x0FB2, 0x0F71, 0x0F80,), '0F77 -> 0FB2 0F71 0F80';
ok Uni.new(0x0F78).NFKD.list ~~ (0x0FB3, 0x0F80,), '0F78 -> 0FB3 0F80';
ok Uni.new(0x0F79).NFKD.list ~~ (0x0FB3, 0x0F71, 0x0F80,), '0F79 -> 0FB3 0F71 0F80';
ok Uni.new(0x0F81).NFKD.list ~~ (0x0F71, 0x0F80,), '0F81 -> 0F71 0F80';
ok Uni.new(0x0F93).NFKD.list ~~ (0x0F92, 0x0FB7,), '0F93 -> 0F92 0FB7';
ok Uni.new(0x0F9D).NFKD.list ~~ (0x0F9C, 0x0FB7,), '0F9D -> 0F9C 0FB7';
ok Uni.new(0x0FA2).NFKD.list ~~ (0x0FA1, 0x0FB7,), '0FA2 -> 0FA1 0FB7';
ok Uni.new(0x0FA7).NFKD.list ~~ (0x0FA6, 0x0FB7,), '0FA7 -> 0FA6 0FB7';
ok Uni.new(0x0FAC).NFKD.list ~~ (0x0FAB, 0x0FB7,), '0FAC -> 0FAB 0FB7';
ok Uni.new(0x0FB9).NFKD.list ~~ (0x0F90, 0x0FB5,), '0FB9 -> 0F90 0FB5';
ok Uni.new(0x1026).NFKD.list ~~ (0x1025, 0x102E,), '1026 -> 1025 102E';
ok Uni.new(0x10FC).NFKD.list ~~ (0x10DC,), '10FC -> 10DC';
ok Uni.new(0x1B06).NFKD.list ~~ (0x1B05, 0x1B35,), '1B06 -> 1B05 1B35';
ok Uni.new(0x1B08).NFKD.list ~~ (0x1B07, 0x1B35,), '1B08 -> 1B07 1B35';
ok Uni.new(0x1B0A).NFKD.list ~~ (0x1B09, 0x1B35,), '1B0A -> 1B09 1B35';
ok Uni.new(0x1B0C).NFKD.list ~~ (0x1B0B, 0x1B35,), '1B0C -> 1B0B 1B35';
ok Uni.new(0x1B0E).NFKD.list ~~ (0x1B0D, 0x1B35,), '1B0E -> 1B0D 1B35';
ok Uni.new(0x1B12).NFKD.list ~~ (0x1B11, 0x1B35,), '1B12 -> 1B11 1B35';
ok Uni.new(0x1B3B).NFKD.list ~~ (0x1B3A, 0x1B35,), '1B3B -> 1B3A 1B35';
ok Uni.new(0x1B3D).NFKD.list ~~ (0x1B3C, 0x1B35,), '1B3D -> 1B3C 1B35';
ok Uni.new(0x1B40).NFKD.list ~~ (0x1B3E, 0x1B35,), '1B40 -> 1B3E 1B35';
ok Uni.new(0x1B41).NFKD.list ~~ (0x1B3F, 0x1B35,), '1B41 -> 1B3F 1B35';
ok Uni.new(0x1B43).NFKD.list ~~ (0x1B42, 0x1B35,), '1B43 -> 1B42 1B35';
ok Uni.new(0x1D2C).NFKD.list ~~ (0x0041,), '1D2C -> 0041';
ok Uni.new(0x1D2D).NFKD.list ~~ (0x00C6,), '1D2D -> 00C6';
ok Uni.new(0x1D2E).NFKD.list ~~ (0x0042,), '1D2E -> 0042';
ok Uni.new(0x1D30).NFKD.list ~~ (0x0044,), '1D30 -> 0044';
ok Uni.new(0x1D31).NFKD.list ~~ (0x0045,), '1D31 -> 0045';
ok Uni.new(0x1D32).NFKD.list ~~ (0x018E,), '1D32 -> 018E';
ok Uni.new(0x1D33).NFKD.list ~~ (0x0047,), '1D33 -> 0047';
ok Uni.new(0x1D34).NFKD.list ~~ (0x0048,), '1D34 -> 0048';
ok Uni.new(0x1D35).NFKD.list ~~ (0x0049,), '1D35 -> 0049';
ok Uni.new(0x1D36).NFKD.list ~~ (0x004A,), '1D36 -> 004A';
ok Uni.new(0x1D37).NFKD.list ~~ (0x004B,), '1D37 -> 004B';
ok Uni.new(0x1D38).NFKD.list ~~ (0x004C,), '1D38 -> 004C';
ok Uni.new(0x1D39).NFKD.list ~~ (0x004D,), '1D39 -> 004D';
ok Uni.new(0x1D3A).NFKD.list ~~ (0x004E,), '1D3A -> 004E';
ok Uni.new(0x1D3C).NFKD.list ~~ (0x004F,), '1D3C -> 004F';
ok Uni.new(0x1D3D).NFKD.list ~~ (0x0222,), '1D3D -> 0222';
ok Uni.new(0x1D3E).NFKD.list ~~ (0x0050,), '1D3E -> 0050';
ok Uni.new(0x1D3F).NFKD.list ~~ (0x0052,), '1D3F -> 0052';
ok Uni.new(0x1D40).NFKD.list ~~ (0x0054,), '1D40 -> 0054';
ok Uni.new(0x1D41).NFKD.list ~~ (0x0055,), '1D41 -> 0055';
ok Uni.new(0x1D42).NFKD.list ~~ (0x0057,), '1D42 -> 0057';
ok Uni.new(0x1D43).NFKD.list ~~ (0x0061,), '1D43 -> 0061';
ok Uni.new(0x1D44).NFKD.list ~~ (0x0250,), '1D44 -> 0250';
ok Uni.new(0x1D45).NFKD.list ~~ (0x0251,), '1D45 -> 0251';
ok Uni.new(0x1D46).NFKD.list ~~ (0x1D02,), '1D46 -> 1D02';
ok Uni.new(0x1D47).NFKD.list ~~ (0x0062,), '1D47 -> 0062';
ok Uni.new(0x1D48).NFKD.list ~~ (0x0064,), '1D48 -> 0064';
ok Uni.new(0x1D49).NFKD.list ~~ (0x0065,), '1D49 -> 0065';
ok Uni.new(0x1D4A).NFKD.list ~~ (0x0259,), '1D4A -> 0259';
ok Uni.new(0x1D4B).NFKD.list ~~ (0x025B,), '1D4B -> 025B';
ok Uni.new(0x1D4C).NFKD.list ~~ (0x025C,), '1D4C -> 025C';
ok Uni.new(0x1D4D).NFKD.list ~~ (0x0067,), '1D4D -> 0067';
ok Uni.new(0x1D4F).NFKD.list ~~ (0x006B,), '1D4F -> 006B';
ok Uni.new(0x1D50).NFKD.list ~~ (0x006D,), '1D50 -> 006D';
ok Uni.new(0x1D51).NFKD.list ~~ (0x014B,), '1D51 -> 014B';
ok Uni.new(0x1D52).NFKD.list ~~ (0x006F,), '1D52 -> 006F';
ok Uni.new(0x1D53).NFKD.list ~~ (0x0254,), '1D53 -> 0254';
ok Uni.new(0x1D54).NFKD.list ~~ (0x1D16,), '1D54 -> 1D16';
ok Uni.new(0x1D55).NFKD.list ~~ (0x1D17,), '1D55 -> 1D17';
ok Uni.new(0x1D56).NFKD.list ~~ (0x0070,), '1D56 -> 0070';
ok Uni.new(0x1D57).NFKD.list ~~ (0x0074,), '1D57 -> 0074';
ok Uni.new(0x1D58).NFKD.list ~~ (0x0075,), '1D58 -> 0075';
ok Uni.new(0x1D59).NFKD.list ~~ (0x1D1D,), '1D59 -> 1D1D';
ok Uni.new(0x1D5A).NFKD.list ~~ (0x026F,), '1D5A -> 026F';
ok Uni.new(0x1D5B).NFKD.list ~~ (0x0076,), '1D5B -> 0076';
ok Uni.new(0x1D5C).NFKD.list ~~ (0x1D25,), '1D5C -> 1D25';
ok Uni.new(0x1D5D).NFKD.list ~~ (0x03B2,), '1D5D -> 03B2';
ok Uni.new(0x1D5E).NFKD.list ~~ (0x03B3,), '1D5E -> 03B3';
ok Uni.new(0x1D5F).NFKD.list ~~ (0x03B4,), '1D5F -> 03B4';
ok Uni.new(0x1D60).NFKD.list ~~ (0x03C6,), '1D60 -> 03C6';
ok Uni.new(0x1D61).NFKD.list ~~ (0x03C7,), '1D61 -> 03C7';
ok Uni.new(0x1D62).NFKD.list ~~ (0x0069,), '1D62 -> 0069';
ok Uni.new(0x1D63).NFKD.list ~~ (0x0072,), '1D63 -> 0072';
ok Uni.new(0x1D64).NFKD.list ~~ (0x0075,), '1D64 -> 0075';
ok Uni.new(0x1D65).NFKD.list ~~ (0x0076,), '1D65 -> 0076';
ok Uni.new(0x1D66).NFKD.list ~~ (0x03B2,), '1D66 -> 03B2';
ok Uni.new(0x1D67).NFKD.list ~~ (0x03B3,), '1D67 -> 03B3';
ok Uni.new(0x1D68).NFKD.list ~~ (0x03C1,), '1D68 -> 03C1';
ok Uni.new(0x1D69).NFKD.list ~~ (0x03C6,), '1D69 -> 03C6';
ok Uni.new(0x1D6A).NFKD.list ~~ (0x03C7,), '1D6A -> 03C7';
ok Uni.new(0x1D78).NFKD.list ~~ (0x043D,), '1D78 -> 043D';
ok Uni.new(0x1D9B).NFKD.list ~~ (0x0252,), '1D9B -> 0252';
ok Uni.new(0x1D9C).NFKD.list ~~ (0x0063,), '1D9C -> 0063';
ok Uni.new(0x1D9D).NFKD.list ~~ (0x0255,), '1D9D -> 0255';
ok Uni.new(0x1D9E).NFKD.list ~~ (0x00F0,), '1D9E -> 00F0';
ok Uni.new(0x1D9F).NFKD.list ~~ (0x025C,), '1D9F -> 025C';
ok Uni.new(0x1DA0).NFKD.list ~~ (0x0066,), '1DA0 -> 0066';
ok Uni.new(0x1DA1).NFKD.list ~~ (0x025F,), '1DA1 -> 025F';
ok Uni.new(0x1DA2).NFKD.list ~~ (0x0261,), '1DA2 -> 0261';
ok Uni.new(0x1DA3).NFKD.list ~~ (0x0265,), '1DA3 -> 0265';
ok Uni.new(0x1DA4).NFKD.list ~~ (0x0268,), '1DA4 -> 0268';
ok Uni.new(0x1DA5).NFKD.list ~~ (0x0269,), '1DA5 -> 0269';
ok Uni.new(0x1DA6).NFKD.list ~~ (0x026A,), '1DA6 -> 026A';
ok Uni.new(0x1DA7).NFKD.list ~~ (0x1D7B,), '1DA7 -> 1D7B';
ok Uni.new(0x1DA8).NFKD.list ~~ (0x029D,), '1DA8 -> 029D';
ok Uni.new(0x1DA9).NFKD.list ~~ (0x026D,), '1DA9 -> 026D';
ok Uni.new(0x1DAA).NFKD.list ~~ (0x1D85,), '1DAA -> 1D85';
ok Uni.new(0x1DAB).NFKD.list ~~ (0x029F,), '1DAB -> 029F';
ok Uni.new(0x1DAC).NFKD.list ~~ (0x0271,), '1DAC -> 0271';
ok Uni.new(0x1DAD).NFKD.list ~~ (0x0270,), '1DAD -> 0270';
ok Uni.new(0x1DAE).NFKD.list ~~ (0x0272,), '1DAE -> 0272';
ok Uni.new(0x1DAF).NFKD.list ~~ (0x0273,), '1DAF -> 0273';
ok Uni.new(0x1DB0).NFKD.list ~~ (0x0274,), '1DB0 -> 0274';
ok Uni.new(0x1DB1).NFKD.list ~~ (0x0275,), '1DB1 -> 0275';
ok Uni.new(0x1DB2).NFKD.list ~~ (0x0278,), '1DB2 -> 0278';
ok Uni.new(0x1DB3).NFKD.list ~~ (0x0282,), '1DB3 -> 0282';
ok Uni.new(0x1DB4).NFKD.list ~~ (0x0283,), '1DB4 -> 0283';
ok Uni.new(0x1DB5).NFKD.list ~~ (0x01AB,), '1DB5 -> 01AB';
ok Uni.new(0x1DB6).NFKD.list ~~ (0x0289,), '1DB6 -> 0289';
ok Uni.new(0x1DB7).NFKD.list ~~ (0x028A,), '1DB7 -> 028A';
ok Uni.new(0x1DB8).NFKD.list ~~ (0x1D1C,), '1DB8 -> 1D1C';
ok Uni.new(0x1DB9).NFKD.list ~~ (0x028B,), '1DB9 -> 028B';
ok Uni.new(0x1DBA).NFKD.list ~~ (0x028C,), '1DBA -> 028C';
ok Uni.new(0x1DBB).NFKD.list ~~ (0x007A,), '1DBB -> 007A';
ok Uni.new(0x1DBC).NFKD.list ~~ (0x0290,), '1DBC -> 0290';
ok Uni.new(0x1DBD).NFKD.list ~~ (0x0291,), '1DBD -> 0291';
ok Uni.new(0x1DBE).NFKD.list ~~ (0x0292,), '1DBE -> 0292';
ok Uni.new(0x1DBF).NFKD.list ~~ (0x03B8,), '1DBF -> 03B8';
ok Uni.new(0x1E00).NFKD.list ~~ (0x0041, 0x0325,), '1E00 -> 0041 0325';
ok Uni.new(0x1E01).NFKD.list ~~ (0x0061, 0x0325,), '1E01 -> 0061 0325';
ok Uni.new(0x1E02).NFKD.list ~~ (0x0042, 0x0307,), '1E02 -> 0042 0307';
ok Uni.new(0x1E03).NFKD.list ~~ (0x0062, 0x0307,), '1E03 -> 0062 0307';
ok Uni.new(0x1E04).NFKD.list ~~ (0x0042, 0x0323,), '1E04 -> 0042 0323';
ok Uni.new(0x1E05).NFKD.list ~~ (0x0062, 0x0323,), '1E05 -> 0062 0323';
ok Uni.new(0x1E06).NFKD.list ~~ (0x0042, 0x0331,), '1E06 -> 0042 0331';
ok Uni.new(0x1E07).NFKD.list ~~ (0x0062, 0x0331,), '1E07 -> 0062 0331';
ok Uni.new(0x1E08).NFKD.list ~~ (0x0043, 0x0327, 0x0301,), '1E08 -> 0043 0327 0301';
ok Uni.new(0x1E09).NFKD.list ~~ (0x0063, 0x0327, 0x0301,), '1E09 -> 0063 0327 0301';
ok Uni.new(0x1E0A).NFKD.list ~~ (0x0044, 0x0307,), '1E0A -> 0044 0307';
ok Uni.new(0x1E0B).NFKD.list ~~ (0x0064, 0x0307,), '1E0B -> 0064 0307';
ok Uni.new(0x1E0C).NFKD.list ~~ (0x0044, 0x0323,), '1E0C -> 0044 0323';
ok Uni.new(0x1E0D).NFKD.list ~~ (0x0064, 0x0323,), '1E0D -> 0064 0323';
ok Uni.new(0x1E0E).NFKD.list ~~ (0x0044, 0x0331,), '1E0E -> 0044 0331';
ok Uni.new(0x1E0F).NFKD.list ~~ (0x0064, 0x0331,), '1E0F -> 0064 0331';
ok Uni.new(0x1E10).NFKD.list ~~ (0x0044, 0x0327,), '1E10 -> 0044 0327';
ok Uni.new(0x1E11).NFKD.list ~~ (0x0064, 0x0327,), '1E11 -> 0064 0327';
ok Uni.new(0x1E12).NFKD.list ~~ (0x0044, 0x032D,), '1E12 -> 0044 032D';
ok Uni.new(0x1E13).NFKD.list ~~ (0x0064, 0x032D,), '1E13 -> 0064 032D';
ok Uni.new(0x1E14).NFKD.list ~~ (0x0045, 0x0304, 0x0300,), '1E14 -> 0045 0304 0300';
ok Uni.new(0x1E15).NFKD.list ~~ (0x0065, 0x0304, 0x0300,), '1E15 -> 0065 0304 0300';
ok Uni.new(0x1E16).NFKD.list ~~ (0x0045, 0x0304, 0x0301,), '1E16 -> 0045 0304 0301';
ok Uni.new(0x1E17).NFKD.list ~~ (0x0065, 0x0304, 0x0301,), '1E17 -> 0065 0304 0301';
ok Uni.new(0x1E18).NFKD.list ~~ (0x0045, 0x032D,), '1E18 -> 0045 032D';
ok Uni.new(0x1E19).NFKD.list ~~ (0x0065, 0x032D,), '1E19 -> 0065 032D';
ok Uni.new(0x1E1A).NFKD.list ~~ (0x0045, 0x0330,), '1E1A -> 0045 0330';
ok Uni.new(0x1E1B).NFKD.list ~~ (0x0065, 0x0330,), '1E1B -> 0065 0330';
ok Uni.new(0x1E1C).NFKD.list ~~ (0x0045, 0x0327, 0x0306,), '1E1C -> 0045 0327 0306';
ok Uni.new(0x1E1D).NFKD.list ~~ (0x0065, 0x0327, 0x0306,), '1E1D -> 0065 0327 0306';
ok Uni.new(0x1E1E).NFKD.list ~~ (0x0046, 0x0307,), '1E1E -> 0046 0307';
ok Uni.new(0x1E1F).NFKD.list ~~ (0x0066, 0x0307,), '1E1F -> 0066 0307';
ok Uni.new(0x1E20).NFKD.list ~~ (0x0047, 0x0304,), '1E20 -> 0047 0304';
ok Uni.new(0x1E21).NFKD.list ~~ (0x0067, 0x0304,), '1E21 -> 0067 0304';
ok Uni.new(0x1E22).NFKD.list ~~ (0x0048, 0x0307,), '1E22 -> 0048 0307';
ok Uni.new(0x1E23).NFKD.list ~~ (0x0068, 0x0307,), '1E23 -> 0068 0307';
ok Uni.new(0x1E24).NFKD.list ~~ (0x0048, 0x0323,), '1E24 -> 0048 0323';
ok Uni.new(0x1E25).NFKD.list ~~ (0x0068, 0x0323,), '1E25 -> 0068 0323';
ok Uni.new(0x1E26).NFKD.list ~~ (0x0048, 0x0308,), '1E26 -> 0048 0308';
ok Uni.new(0x1E27).NFKD.list ~~ (0x0068, 0x0308,), '1E27 -> 0068 0308';
ok Uni.new(0x1E28).NFKD.list ~~ (0x0048, 0x0327,), '1E28 -> 0048 0327';
ok Uni.new(0x1E29).NFKD.list ~~ (0x0068, 0x0327,), '1E29 -> 0068 0327';
ok Uni.new(0x1E2A).NFKD.list ~~ (0x0048, 0x032E,), '1E2A -> 0048 032E';
ok Uni.new(0x1E2B).NFKD.list ~~ (0x0068, 0x032E,), '1E2B -> 0068 032E';
ok Uni.new(0x1E2C).NFKD.list ~~ (0x0049, 0x0330,), '1E2C -> 0049 0330';
ok Uni.new(0x1E2D).NFKD.list ~~ (0x0069, 0x0330,), '1E2D -> 0069 0330';
ok Uni.new(0x1E2E).NFKD.list ~~ (0x0049, 0x0308, 0x0301,), '1E2E -> 0049 0308 0301';
ok Uni.new(0x1E2F).NFKD.list ~~ (0x0069, 0x0308, 0x0301,), '1E2F -> 0069 0308 0301';
ok Uni.new(0x1E30).NFKD.list ~~ (0x004B, 0x0301,), '1E30 -> 004B 0301';
ok Uni.new(0x1E31).NFKD.list ~~ (0x006B, 0x0301,), '1E31 -> 006B 0301';
ok Uni.new(0x1E32).NFKD.list ~~ (0x004B, 0x0323,), '1E32 -> 004B 0323';
ok Uni.new(0x1E33).NFKD.list ~~ (0x006B, 0x0323,), '1E33 -> 006B 0323';
ok Uni.new(0x1E34).NFKD.list ~~ (0x004B, 0x0331,), '1E34 -> 004B 0331';
ok Uni.new(0x1E35).NFKD.list ~~ (0x006B, 0x0331,), '1E35 -> 006B 0331';
ok Uni.new(0x1E36).NFKD.list ~~ (0x004C, 0x0323,), '1E36 -> 004C 0323';
ok Uni.new(0x1E37).NFKD.list ~~ (0x006C, 0x0323,), '1E37 -> 006C 0323';
ok Uni.new(0x1E38).NFKD.list ~~ (0x004C, 0x0323, 0x0304,), '1E38 -> 004C 0323 0304';
ok Uni.new(0x1E39).NFKD.list ~~ (0x006C, 0x0323, 0x0304,), '1E39 -> 006C 0323 0304';
ok Uni.new(0x1E3A).NFKD.list ~~ (0x004C, 0x0331,), '1E3A -> 004C 0331';
ok Uni.new(0x1E3B).NFKD.list ~~ (0x006C, 0x0331,), '1E3B -> 006C 0331';
ok Uni.new(0x1E3C).NFKD.list ~~ (0x004C, 0x032D,), '1E3C -> 004C 032D';
ok Uni.new(0x1E3D).NFKD.list ~~ (0x006C, 0x032D,), '1E3D -> 006C 032D';
ok Uni.new(0x1E3E).NFKD.list ~~ (0x004D, 0x0301,), '1E3E -> 004D 0301';
ok Uni.new(0x1E3F).NFKD.list ~~ (0x006D, 0x0301,), '1E3F -> 006D 0301';
ok Uni.new(0x1E40).NFKD.list ~~ (0x004D, 0x0307,), '1E40 -> 004D 0307';
ok Uni.new(0x1E41).NFKD.list ~~ (0x006D, 0x0307,), '1E41 -> 006D 0307';
ok Uni.new(0x1E42).NFKD.list ~~ (0x004D, 0x0323,), '1E42 -> 004D 0323';
ok Uni.new(0x1E43).NFKD.list ~~ (0x006D, 0x0323,), '1E43 -> 006D 0323';
ok Uni.new(0x1E44).NFKD.list ~~ (0x004E, 0x0307,), '1E44 -> 004E 0307';
ok Uni.new(0x1E45).NFKD.list ~~ (0x006E, 0x0307,), '1E45 -> 006E 0307';
ok Uni.new(0x1E46).NFKD.list ~~ (0x004E, 0x0323,), '1E46 -> 004E 0323';
ok Uni.new(0x1E47).NFKD.list ~~ (0x006E, 0x0323,), '1E47 -> 006E 0323';
ok Uni.new(0x1E48).NFKD.list ~~ (0x004E, 0x0331,), '1E48 -> 004E 0331';
ok Uni.new(0x1E49).NFKD.list ~~ (0x006E, 0x0331,), '1E49 -> 006E 0331';
ok Uni.new(0x1E4A).NFKD.list ~~ (0x004E, 0x032D,), '1E4A -> 004E 032D';
ok Uni.new(0x1E4B).NFKD.list ~~ (0x006E, 0x032D,), '1E4B -> 006E 032D';
ok Uni.new(0x1E4C).NFKD.list ~~ (0x004F, 0x0303, 0x0301,), '1E4C -> 004F 0303 0301';
ok Uni.new(0x1E4D).NFKD.list ~~ (0x006F, 0x0303, 0x0301,), '1E4D -> 006F 0303 0301';
ok Uni.new(0x1E4E).NFKD.list ~~ (0x004F, 0x0303, 0x0308,), '1E4E -> 004F 0303 0308';
ok Uni.new(0x1E4F).NFKD.list ~~ (0x006F, 0x0303, 0x0308,), '1E4F -> 006F 0303 0308';
ok Uni.new(0x1E50).NFKD.list ~~ (0x004F, 0x0304, 0x0300,), '1E50 -> 004F 0304 0300';
ok Uni.new(0x1E51).NFKD.list ~~ (0x006F, 0x0304, 0x0300,), '1E51 -> 006F 0304 0300';
ok Uni.new(0x1E52).NFKD.list ~~ (0x004F, 0x0304, 0x0301,), '1E52 -> 004F 0304 0301';
ok Uni.new(0x1E53).NFKD.list ~~ (0x006F, 0x0304, 0x0301,), '1E53 -> 006F 0304 0301';
ok Uni.new(0x1E54).NFKD.list ~~ (0x0050, 0x0301,), '1E54 -> 0050 0301';
ok Uni.new(0x1E55).NFKD.list ~~ (0x0070, 0x0301,), '1E55 -> 0070 0301';
ok Uni.new(0x1E56).NFKD.list ~~ (0x0050, 0x0307,), '1E56 -> 0050 0307';
ok Uni.new(0x1E57).NFKD.list ~~ (0x0070, 0x0307,), '1E57 -> 0070 0307';
ok Uni.new(0x1E58).NFKD.list ~~ (0x0052, 0x0307,), '1E58 -> 0052 0307';
ok Uni.new(0x1E59).NFKD.list ~~ (0x0072, 0x0307,), '1E59 -> 0072 0307';
ok Uni.new(0x1E5A).NFKD.list ~~ (0x0052, 0x0323,), '1E5A -> 0052 0323';
ok Uni.new(0x1E5B).NFKD.list ~~ (0x0072, 0x0323,), '1E5B -> 0072 0323';
ok Uni.new(0x1E5C).NFKD.list ~~ (0x0052, 0x0323, 0x0304,), '1E5C -> 0052 0323 0304';
ok Uni.new(0x1E5D).NFKD.list ~~ (0x0072, 0x0323, 0x0304,), '1E5D -> 0072 0323 0304';
ok Uni.new(0x1E5E).NFKD.list ~~ (0x0052, 0x0331,), '1E5E -> 0052 0331';
ok Uni.new(0x1E5F).NFKD.list ~~ (0x0072, 0x0331,), '1E5F -> 0072 0331';
ok Uni.new(0x1E60).NFKD.list ~~ (0x0053, 0x0307,), '1E60 -> 0053 0307';
ok Uni.new(0x1E61).NFKD.list ~~ (0x0073, 0x0307,), '1E61 -> 0073 0307';
ok Uni.new(0x1E62).NFKD.list ~~ (0x0053, 0x0323,), '1E62 -> 0053 0323';
ok Uni.new(0x1E63).NFKD.list ~~ (0x0073, 0x0323,), '1E63 -> 0073 0323';
ok Uni.new(0x1E64).NFKD.list ~~ (0x0053, 0x0301, 0x0307,), '1E64 -> 0053 0301 0307';
ok Uni.new(0x1E65).NFKD.list ~~ (0x0073, 0x0301, 0x0307,), '1E65 -> 0073 0301 0307';
ok Uni.new(0x1E66).NFKD.list ~~ (0x0053, 0x030C, 0x0307,), '1E66 -> 0053 030C 0307';
ok Uni.new(0x1E67).NFKD.list ~~ (0x0073, 0x030C, 0x0307,), '1E67 -> 0073 030C 0307';
ok Uni.new(0x1E68).NFKD.list ~~ (0x0053, 0x0323, 0x0307,), '1E68 -> 0053 0323 0307';
ok Uni.new(0x1E69).NFKD.list ~~ (0x0073, 0x0323, 0x0307,), '1E69 -> 0073 0323 0307';
ok Uni.new(0x1E6A).NFKD.list ~~ (0x0054, 0x0307,), '1E6A -> 0054 0307';
ok Uni.new(0x1E6B).NFKD.list ~~ (0x0074, 0x0307,), '1E6B -> 0074 0307';
ok Uni.new(0x1E6C).NFKD.list ~~ (0x0054, 0x0323,), '1E6C -> 0054 0323';
ok Uni.new(0x1E6D).NFKD.list ~~ (0x0074, 0x0323,), '1E6D -> 0074 0323';
ok Uni.new(0x1E6E).NFKD.list ~~ (0x0054, 0x0331,), '1E6E -> 0054 0331';
ok Uni.new(0x1E6F).NFKD.list ~~ (0x0074, 0x0331,), '1E6F -> 0074 0331';
ok Uni.new(0x1E70).NFKD.list ~~ (0x0054, 0x032D,), '1E70 -> 0054 032D';
ok Uni.new(0x1E71).NFKD.list ~~ (0x0074, 0x032D,), '1E71 -> 0074 032D';
ok Uni.new(0x1E72).NFKD.list ~~ (0x0055, 0x0324,), '1E72 -> 0055 0324';
ok Uni.new(0x1E73).NFKD.list ~~ (0x0075, 0x0324,), '1E73 -> 0075 0324';
ok Uni.new(0x1E74).NFKD.list ~~ (0x0055, 0x0330,), '1E74 -> 0055 0330';
ok Uni.new(0x1E75).NFKD.list ~~ (0x0075, 0x0330,), '1E75 -> 0075 0330';
ok Uni.new(0x1E76).NFKD.list ~~ (0x0055, 0x032D,), '1E76 -> 0055 032D';
ok Uni.new(0x1E77).NFKD.list ~~ (0x0075, 0x032D,), '1E77 -> 0075 032D';
ok Uni.new(0x1E78).NFKD.list ~~ (0x0055, 0x0303, 0x0301,), '1E78 -> 0055 0303 0301';
ok Uni.new(0x1E79).NFKD.list ~~ (0x0075, 0x0303, 0x0301,), '1E79 -> 0075 0303 0301';
ok Uni.new(0x1E7A).NFKD.list ~~ (0x0055, 0x0304, 0x0308,), '1E7A -> 0055 0304 0308';
ok Uni.new(0x1E7B).NFKD.list ~~ (0x0075, 0x0304, 0x0308,), '1E7B -> 0075 0304 0308';
ok Uni.new(0x1E7C).NFKD.list ~~ (0x0056, 0x0303,), '1E7C -> 0056 0303';
ok Uni.new(0x1E7D).NFKD.list ~~ (0x0076, 0x0303,), '1E7D -> 0076 0303';
ok Uni.new(0x1E7E).NFKD.list ~~ (0x0056, 0x0323,), '1E7E -> 0056 0323';
ok Uni.new(0x1E7F).NFKD.list ~~ (0x0076, 0x0323,), '1E7F -> 0076 0323';
ok Uni.new(0x1E80).NFKD.list ~~ (0x0057, 0x0300,), '1E80 -> 0057 0300';
ok Uni.new(0x1E81).NFKD.list ~~ (0x0077, 0x0300,), '1E81 -> 0077 0300';
ok Uni.new(0x1E82).NFKD.list ~~ (0x0057, 0x0301,), '1E82 -> 0057 0301';
ok Uni.new(0x1E83).NFKD.list ~~ (0x0077, 0x0301,), '1E83 -> 0077 0301';
ok Uni.new(0x1E84).NFKD.list ~~ (0x0057, 0x0308,), '1E84 -> 0057 0308';
ok Uni.new(0x1E85).NFKD.list ~~ (0x0077, 0x0308,), '1E85 -> 0077 0308';
ok Uni.new(0x1E86).NFKD.list ~~ (0x0057, 0x0307,), '1E86 -> 0057 0307';
ok Uni.new(0x1E87).NFKD.list ~~ (0x0077, 0x0307,), '1E87 -> 0077 0307';
ok Uni.new(0x1E88).NFKD.list ~~ (0x0057, 0x0323,), '1E88 -> 0057 0323';
ok Uni.new(0x1E89).NFKD.list ~~ (0x0077, 0x0323,), '1E89 -> 0077 0323';
ok Uni.new(0x1E8A).NFKD.list ~~ (0x0058, 0x0307,), '1E8A -> 0058 0307';
ok Uni.new(0x1E8B).NFKD.list ~~ (0x0078, 0x0307,), '1E8B -> 0078 0307';
ok Uni.new(0x1E8C).NFKD.list ~~ (0x0058, 0x0308,), '1E8C -> 0058 0308';
ok Uni.new(0x1E8D).NFKD.list ~~ (0x0078, 0x0308,), '1E8D -> 0078 0308';
ok Uni.new(0x1E8E).NFKD.list ~~ (0x0059, 0x0307,), '1E8E -> 0059 0307';
ok Uni.new(0x1E8F).NFKD.list ~~ (0x0079, 0x0307,), '1E8F -> 0079 0307';
ok Uni.new(0x1E90).NFKD.list ~~ (0x005A, 0x0302,), '1E90 -> 005A 0302';
ok Uni.new(0x1E91).NFKD.list ~~ (0x007A, 0x0302,), '1E91 -> 007A 0302';
ok Uni.new(0x1E92).NFKD.list ~~ (0x005A, 0x0323,), '1E92 -> 005A 0323';
ok Uni.new(0x1E93).NFKD.list ~~ (0x007A, 0x0323,), '1E93 -> 007A 0323';
ok Uni.new(0x1E94).NFKD.list ~~ (0x005A, 0x0331,), '1E94 -> 005A 0331';
ok Uni.new(0x1E95).NFKD.list ~~ (0x007A, 0x0331,), '1E95 -> 007A 0331';
ok Uni.new(0x1E96).NFKD.list ~~ (0x0068, 0x0331,), '1E96 -> 0068 0331';
ok Uni.new(0x1E97).NFKD.list ~~ (0x0074, 0x0308,), '1E97 -> 0074 0308';
ok Uni.new(0x1E98).NFKD.list ~~ (0x0077, 0x030A,), '1E98 -> 0077 030A';
ok Uni.new(0x1E99).NFKD.list ~~ (0x0079, 0x030A,), '1E99 -> 0079 030A';
ok Uni.new(0x1E9A).NFKD.list ~~ (0x0061, 0x02BE,), '1E9A -> 0061 02BE';
ok Uni.new(0x1E9B).NFKD.list ~~ (0x0073, 0x0307,), '1E9B -> 0073 0307';
ok Uni.new(0x1EA0).NFKD.list ~~ (0x0041, 0x0323,), '1EA0 -> 0041 0323';
ok Uni.new(0x1EA1).NFKD.list ~~ (0x0061, 0x0323,), '1EA1 -> 0061 0323';
ok Uni.new(0x1EA2).NFKD.list ~~ (0x0041, 0x0309,), '1EA2 -> 0041 0309';
ok Uni.new(0x1EA3).NFKD.list ~~ (0x0061, 0x0309,), '1EA3 -> 0061 0309';
ok Uni.new(0x1EA4).NFKD.list ~~ (0x0041, 0x0302, 0x0301,), '1EA4 -> 0041 0302 0301';
ok Uni.new(0x1EA5).NFKD.list ~~ (0x0061, 0x0302, 0x0301,), '1EA5 -> 0061 0302 0301';
ok Uni.new(0x1EA6).NFKD.list ~~ (0x0041, 0x0302, 0x0300,), '1EA6 -> 0041 0302 0300';
ok Uni.new(0x1EA7).NFKD.list ~~ (0x0061, 0x0302, 0x0300,), '1EA7 -> 0061 0302 0300';
ok Uni.new(0x1EA8).NFKD.list ~~ (0x0041, 0x0302, 0x0309,), '1EA8 -> 0041 0302 0309';
ok Uni.new(0x1EA9).NFKD.list ~~ (0x0061, 0x0302, 0x0309,), '1EA9 -> 0061 0302 0309';
ok Uni.new(0x1EAA).NFKD.list ~~ (0x0041, 0x0302, 0x0303,), '1EAA -> 0041 0302 0303';
ok Uni.new(0x1EAB).NFKD.list ~~ (0x0061, 0x0302, 0x0303,), '1EAB -> 0061 0302 0303';
ok Uni.new(0x1EAC).NFKD.list ~~ (0x0041, 0x0323, 0x0302,), '1EAC -> 0041 0323 0302';
ok Uni.new(0x1EAD).NFKD.list ~~ (0x0061, 0x0323, 0x0302,), '1EAD -> 0061 0323 0302';
ok Uni.new(0x1EAE).NFKD.list ~~ (0x0041, 0x0306, 0x0301,), '1EAE -> 0041 0306 0301';
ok Uni.new(0x1EAF).NFKD.list ~~ (0x0061, 0x0306, 0x0301,), '1EAF -> 0061 0306 0301';
ok Uni.new(0x1EB0).NFKD.list ~~ (0x0041, 0x0306, 0x0300,), '1EB0 -> 0041 0306 0300';
ok Uni.new(0x1EB1).NFKD.list ~~ (0x0061, 0x0306, 0x0300,), '1EB1 -> 0061 0306 0300';
ok Uni.new(0x1EB2).NFKD.list ~~ (0x0041, 0x0306, 0x0309,), '1EB2 -> 0041 0306 0309';
ok Uni.new(0x1EB3).NFKD.list ~~ (0x0061, 0x0306, 0x0309,), '1EB3 -> 0061 0306 0309';
ok Uni.new(0x1EB4).NFKD.list ~~ (0x0041, 0x0306, 0x0303,), '1EB4 -> 0041 0306 0303';
ok Uni.new(0x1EB5).NFKD.list ~~ (0x0061, 0x0306, 0x0303,), '1EB5 -> 0061 0306 0303';
ok Uni.new(0x1EB6).NFKD.list ~~ (0x0041, 0x0323, 0x0306,), '1EB6 -> 0041 0323 0306';
ok Uni.new(0x1EB7).NFKD.list ~~ (0x0061, 0x0323, 0x0306,), '1EB7 -> 0061 0323 0306';
ok Uni.new(0x1EB8).NFKD.list ~~ (0x0045, 0x0323,), '1EB8 -> 0045 0323';
ok Uni.new(0x1EB9).NFKD.list ~~ (0x0065, 0x0323,), '1EB9 -> 0065 0323';
ok Uni.new(0x1EBA).NFKD.list ~~ (0x0045, 0x0309,), '1EBA -> 0045 0309';
ok Uni.new(0x1EBB).NFKD.list ~~ (0x0065, 0x0309,), '1EBB -> 0065 0309';
ok Uni.new(0x1EBC).NFKD.list ~~ (0x0045, 0x0303,), '1EBC -> 0045 0303';
ok Uni.new(0x1EBD).NFKD.list ~~ (0x0065, 0x0303,), '1EBD -> 0065 0303';
ok Uni.new(0x1EBE).NFKD.list ~~ (0x0045, 0x0302, 0x0301,), '1EBE -> 0045 0302 0301';
ok Uni.new(0x1EBF).NFKD.list ~~ (0x0065, 0x0302, 0x0301,), '1EBF -> 0065 0302 0301';
ok Uni.new(0x1EC0).NFKD.list ~~ (0x0045, 0x0302, 0x0300,), '1EC0 -> 0045 0302 0300';
ok Uni.new(0x1EC1).NFKD.list ~~ (0x0065, 0x0302, 0x0300,), '1EC1 -> 0065 0302 0300';
ok Uni.new(0x1EC2).NFKD.list ~~ (0x0045, 0x0302, 0x0309,), '1EC2 -> 0045 0302 0309';
ok Uni.new(0x1EC3).NFKD.list ~~ (0x0065, 0x0302, 0x0309,), '1EC3 -> 0065 0302 0309';
ok Uni.new(0x1EC4).NFKD.list ~~ (0x0045, 0x0302, 0x0303,), '1EC4 -> 0045 0302 0303';
ok Uni.new(0x1EC5).NFKD.list ~~ (0x0065, 0x0302, 0x0303,), '1EC5 -> 0065 0302 0303';
ok Uni.new(0x1EC6).NFKD.list ~~ (0x0045, 0x0323, 0x0302,), '1EC6 -> 0045 0323 0302';
ok Uni.new(0x1EC7).NFKD.list ~~ (0x0065, 0x0323, 0x0302,), '1EC7 -> 0065 0323 0302';
ok Uni.new(0x1EC8).NFKD.list ~~ (0x0049, 0x0309,), '1EC8 -> 0049 0309';
ok Uni.new(0x1EC9).NFKD.list ~~ (0x0069, 0x0309,), '1EC9 -> 0069 0309';
ok Uni.new(0x1ECA).NFKD.list ~~ (0x0049, 0x0323,), '1ECA -> 0049 0323';
ok Uni.new(0x1ECB).NFKD.list ~~ (0x0069, 0x0323,), '1ECB -> 0069 0323';
ok Uni.new(0x1ECC).NFKD.list ~~ (0x004F, 0x0323,), '1ECC -> 004F 0323';
ok Uni.new(0x1ECD).NFKD.list ~~ (0x006F, 0x0323,), '1ECD -> 006F 0323';
ok Uni.new(0x1ECE).NFKD.list ~~ (0x004F, 0x0309,), '1ECE -> 004F 0309';
ok Uni.new(0x1ECF).NFKD.list ~~ (0x006F, 0x0309,), '1ECF -> 006F 0309';
ok Uni.new(0x1ED0).NFKD.list ~~ (0x004F, 0x0302, 0x0301,), '1ED0 -> 004F 0302 0301';
ok Uni.new(0x1ED1).NFKD.list ~~ (0x006F, 0x0302, 0x0301,), '1ED1 -> 006F 0302 0301';
ok Uni.new(0x1ED2).NFKD.list ~~ (0x004F, 0x0302, 0x0300,), '1ED2 -> 004F 0302 0300';
ok Uni.new(0x1ED3).NFKD.list ~~ (0x006F, 0x0302, 0x0300,), '1ED3 -> 006F 0302 0300';
ok Uni.new(0x1ED4).NFKD.list ~~ (0x004F, 0x0302, 0x0309,), '1ED4 -> 004F 0302 0309';
ok Uni.new(0x1ED5).NFKD.list ~~ (0x006F, 0x0302, 0x0309,), '1ED5 -> 006F 0302 0309';
ok Uni.new(0x1ED6).NFKD.list ~~ (0x004F, 0x0302, 0x0303,), '1ED6 -> 004F 0302 0303';
ok Uni.new(0x1ED7).NFKD.list ~~ (0x006F, 0x0302, 0x0303,), '1ED7 -> 006F 0302 0303';
ok Uni.new(0x1ED8).NFKD.list ~~ (0x004F, 0x0323, 0x0302,), '1ED8 -> 004F 0323 0302';
ok Uni.new(0x1ED9).NFKD.list ~~ (0x006F, 0x0323, 0x0302,), '1ED9 -> 006F 0323 0302';
ok Uni.new(0x1EDA).NFKD.list ~~ (0x004F, 0x031B, 0x0301,), '1EDA -> 004F 031B 0301';
ok Uni.new(0x1EDB).NFKD.list ~~ (0x006F, 0x031B, 0x0301,), '1EDB -> 006F 031B 0301';
ok Uni.new(0x1EDC).NFKD.list ~~ (0x004F, 0x031B, 0x0300,), '1EDC -> 004F 031B 0300';
ok Uni.new(0x1EDD).NFKD.list ~~ (0x006F, 0x031B, 0x0300,), '1EDD -> 006F 031B 0300';
ok Uni.new(0x1EDE).NFKD.list ~~ (0x004F, 0x031B, 0x0309,), '1EDE -> 004F 031B 0309';
ok Uni.new(0x1EDF).NFKD.list ~~ (0x006F, 0x031B, 0x0309,), '1EDF -> 006F 031B 0309';
ok Uni.new(0x1EE0).NFKD.list ~~ (0x004F, 0x031B, 0x0303,), '1EE0 -> 004F 031B 0303';
ok Uni.new(0x1EE1).NFKD.list ~~ (0x006F, 0x031B, 0x0303,), '1EE1 -> 006F 031B 0303';
ok Uni.new(0x1EE2).NFKD.list ~~ (0x004F, 0x031B, 0x0323,), '1EE2 -> 004F 031B 0323';
ok Uni.new(0x1EE3).NFKD.list ~~ (0x006F, 0x031B, 0x0323,), '1EE3 -> 006F 031B 0323';
ok Uni.new(0x1EE4).NFKD.list ~~ (0x0055, 0x0323,), '1EE4 -> 0055 0323';
ok Uni.new(0x1EE5).NFKD.list ~~ (0x0075, 0x0323,), '1EE5 -> 0075 0323';
ok Uni.new(0x1EE6).NFKD.list ~~ (0x0055, 0x0309,), '1EE6 -> 0055 0309';
ok Uni.new(0x1EE7).NFKD.list ~~ (0x0075, 0x0309,), '1EE7 -> 0075 0309';
ok Uni.new(0x1EE8).NFKD.list ~~ (0x0055, 0x031B, 0x0301,), '1EE8 -> 0055 031B 0301';
ok Uni.new(0x1EE9).NFKD.list ~~ (0x0075, 0x031B, 0x0301,), '1EE9 -> 0075 031B 0301';
ok Uni.new(0x1EEA).NFKD.list ~~ (0x0055, 0x031B, 0x0300,), '1EEA -> 0055 031B 0300';
ok Uni.new(0x1EEB).NFKD.list ~~ (0x0075, 0x031B, 0x0300,), '1EEB -> 0075 031B 0300';
ok Uni.new(0x1EEC).NFKD.list ~~ (0x0055, 0x031B, 0x0309,), '1EEC -> 0055 031B 0309';
ok Uni.new(0x1EED).NFKD.list ~~ (0x0075, 0x031B, 0x0309,), '1EED -> 0075 031B 0309';
ok Uni.new(0x1EEE).NFKD.list ~~ (0x0055, 0x031B, 0x0303,), '1EEE -> 0055 031B 0303';
ok Uni.new(0x1EEF).NFKD.list ~~ (0x0075, 0x031B, 0x0303,), '1EEF -> 0075 031B 0303';
ok Uni.new(0x1EF0).NFKD.list ~~ (0x0055, 0x031B, 0x0323,), '1EF0 -> 0055 031B 0323';
ok Uni.new(0x1EF1).NFKD.list ~~ (0x0075, 0x031B, 0x0323,), '1EF1 -> 0075 031B 0323';
ok Uni.new(0x1EF2).NFKD.list ~~ (0x0059, 0x0300,), '1EF2 -> 0059 0300';
ok Uni.new(0x1EF3).NFKD.list ~~ (0x0079, 0x0300,), '1EF3 -> 0079 0300';
ok Uni.new(0x1EF4).NFKD.list ~~ (0x0059, 0x0323,), '1EF4 -> 0059 0323';
ok Uni.new(0x1EF5).NFKD.list ~~ (0x0079, 0x0323,), '1EF5 -> 0079 0323';
ok Uni.new(0x1EF6).NFKD.list ~~ (0x0059, 0x0309,), '1EF6 -> 0059 0309';
ok Uni.new(0x1EF7).NFKD.list ~~ (0x0079, 0x0309,), '1EF7 -> 0079 0309';
ok Uni.new(0x1EF8).NFKD.list ~~ (0x0059, 0x0303,), '1EF8 -> 0059 0303';
ok Uni.new(0x1EF9).NFKD.list ~~ (0x0079, 0x0303,), '1EF9 -> 0079 0303';
ok Uni.new(0x1F00).NFKD.list ~~ (0x03B1, 0x0313,), '1F00 -> 03B1 0313';
ok Uni.new(0x1F01).NFKD.list ~~ (0x03B1, 0x0314,), '1F01 -> 03B1 0314';
ok Uni.new(0x1F02).NFKD.list ~~ (0x03B1, 0x0313, 0x0300,), '1F02 -> 03B1 0313 0300';
ok Uni.new(0x1F03).NFKD.list ~~ (0x03B1, 0x0314, 0x0300,), '1F03 -> 03B1 0314 0300';
ok Uni.new(0x1F04).NFKD.list ~~ (0x03B1, 0x0313, 0x0301,), '1F04 -> 03B1 0313 0301';
ok Uni.new(0x1F05).NFKD.list ~~ (0x03B1, 0x0314, 0x0301,), '1F05 -> 03B1 0314 0301';
ok Uni.new(0x1F06).NFKD.list ~~ (0x03B1, 0x0313, 0x0342,), '1F06 -> 03B1 0313 0342';
ok Uni.new(0x1F07).NFKD.list ~~ (0x03B1, 0x0314, 0x0342,), '1F07 -> 03B1 0314 0342';
ok Uni.new(0x1F08).NFKD.list ~~ (0x0391, 0x0313,), '1F08 -> 0391 0313';
ok Uni.new(0x1F09).NFKD.list ~~ (0x0391, 0x0314,), '1F09 -> 0391 0314';
ok Uni.new(0x1F0A).NFKD.list ~~ (0x0391, 0x0313, 0x0300,), '1F0A -> 0391 0313 0300';
ok Uni.new(0x1F0B).NFKD.list ~~ (0x0391, 0x0314, 0x0300,), '1F0B -> 0391 0314 0300';
ok Uni.new(0x1F0C).NFKD.list ~~ (0x0391, 0x0313, 0x0301,), '1F0C -> 0391 0313 0301';
ok Uni.new(0x1F0D).NFKD.list ~~ (0x0391, 0x0314, 0x0301,), '1F0D -> 0391 0314 0301';
ok Uni.new(0x1F0E).NFKD.list ~~ (0x0391, 0x0313, 0x0342,), '1F0E -> 0391 0313 0342';
ok Uni.new(0x1F0F).NFKD.list ~~ (0x0391, 0x0314, 0x0342,), '1F0F -> 0391 0314 0342';
ok Uni.new(0x1F10).NFKD.list ~~ (0x03B5, 0x0313,), '1F10 -> 03B5 0313';
ok Uni.new(0x1F11).NFKD.list ~~ (0x03B5, 0x0314,), '1F11 -> 03B5 0314';
ok Uni.new(0x1F12).NFKD.list ~~ (0x03B5, 0x0313, 0x0300,), '1F12 -> 03B5 0313 0300';
ok Uni.new(0x1F13).NFKD.list ~~ (0x03B5, 0x0314, 0x0300,), '1F13 -> 03B5 0314 0300';
ok Uni.new(0x1F14).NFKD.list ~~ (0x03B5, 0x0313, 0x0301,), '1F14 -> 03B5 0313 0301';
ok Uni.new(0x1F15).NFKD.list ~~ (0x03B5, 0x0314, 0x0301,), '1F15 -> 03B5 0314 0301';
ok Uni.new(0x1F18).NFKD.list ~~ (0x0395, 0x0313,), '1F18 -> 0395 0313';
ok Uni.new(0x1F19).NFKD.list ~~ (0x0395, 0x0314,), '1F19 -> 0395 0314';
ok Uni.new(0x1F1A).NFKD.list ~~ (0x0395, 0x0313, 0x0300,), '1F1A -> 0395 0313 0300';
ok Uni.new(0x1F1B).NFKD.list ~~ (0x0395, 0x0314, 0x0300,), '1F1B -> 0395 0314 0300';
ok Uni.new(0x1F1C).NFKD.list ~~ (0x0395, 0x0313, 0x0301,), '1F1C -> 0395 0313 0301';
ok Uni.new(0x1F1D).NFKD.list ~~ (0x0395, 0x0314, 0x0301,), '1F1D -> 0395 0314 0301';
ok Uni.new(0x1F20).NFKD.list ~~ (0x03B7, 0x0313,), '1F20 -> 03B7 0313';
ok Uni.new(0x1F21).NFKD.list ~~ (0x03B7, 0x0314,), '1F21 -> 03B7 0314';
ok Uni.new(0x1F22).NFKD.list ~~ (0x03B7, 0x0313, 0x0300,), '1F22 -> 03B7 0313 0300';
ok Uni.new(0x1F23).NFKD.list ~~ (0x03B7, 0x0314, 0x0300,), '1F23 -> 03B7 0314 0300';
ok Uni.new(0x1F24).NFKD.list ~~ (0x03B7, 0x0313, 0x0301,), '1F24 -> 03B7 0313 0301';
ok Uni.new(0x1F25).NFKD.list ~~ (0x03B7, 0x0314, 0x0301,), '1F25 -> 03B7 0314 0301';
ok Uni.new(0x1F26).NFKD.list ~~ (0x03B7, 0x0313, 0x0342,), '1F26 -> 03B7 0313 0342';
ok Uni.new(0x1F27).NFKD.list ~~ (0x03B7, 0x0314, 0x0342,), '1F27 -> 03B7 0314 0342';
ok Uni.new(0x1F28).NFKD.list ~~ (0x0397, 0x0313,), '1F28 -> 0397 0313';
ok Uni.new(0x1F29).NFKD.list ~~ (0x0397, 0x0314,), '1F29 -> 0397 0314';
ok Uni.new(0x1F2A).NFKD.list ~~ (0x0397, 0x0313, 0x0300,), '1F2A -> 0397 0313 0300';
ok Uni.new(0x1F2B).NFKD.list ~~ (0x0397, 0x0314, 0x0300,), '1F2B -> 0397 0314 0300';
ok Uni.new(0x1F2C).NFKD.list ~~ (0x0397, 0x0313, 0x0301,), '1F2C -> 0397 0313 0301';
ok Uni.new(0x1F2D).NFKD.list ~~ (0x0397, 0x0314, 0x0301,), '1F2D -> 0397 0314 0301';
ok Uni.new(0x1F2E).NFKD.list ~~ (0x0397, 0x0313, 0x0342,), '1F2E -> 0397 0313 0342';
ok Uni.new(0x1F2F).NFKD.list ~~ (0x0397, 0x0314, 0x0342,), '1F2F -> 0397 0314 0342';
ok Uni.new(0x1F30).NFKD.list ~~ (0x03B9, 0x0313,), '1F30 -> 03B9 0313';
ok Uni.new(0x1F31).NFKD.list ~~ (0x03B9, 0x0314,), '1F31 -> 03B9 0314';
ok Uni.new(0x1F32).NFKD.list ~~ (0x03B9, 0x0313, 0x0300,), '1F32 -> 03B9 0313 0300';
ok Uni.new(0x1F33).NFKD.list ~~ (0x03B9, 0x0314, 0x0300,), '1F33 -> 03B9 0314 0300';
ok Uni.new(0x1F34).NFKD.list ~~ (0x03B9, 0x0313, 0x0301,), '1F34 -> 03B9 0313 0301';
ok Uni.new(0x1F35).NFKD.list ~~ (0x03B9, 0x0314, 0x0301,), '1F35 -> 03B9 0314 0301';
ok Uni.new(0x1F36).NFKD.list ~~ (0x03B9, 0x0313, 0x0342,), '1F36 -> 03B9 0313 0342';
ok Uni.new(0x1F37).NFKD.list ~~ (0x03B9, 0x0314, 0x0342,), '1F37 -> 03B9 0314 0342';
ok Uni.new(0x1F38).NFKD.list ~~ (0x0399, 0x0313,), '1F38 -> 0399 0313';
ok Uni.new(0x1F39).NFKD.list ~~ (0x0399, 0x0314,), '1F39 -> 0399 0314';
ok Uni.new(0x1F3A).NFKD.list ~~ (0x0399, 0x0313, 0x0300,), '1F3A -> 0399 0313 0300';
ok Uni.new(0x1F3B).NFKD.list ~~ (0x0399, 0x0314, 0x0300,), '1F3B -> 0399 0314 0300';
ok Uni.new(0x1F3C).NFKD.list ~~ (0x0399, 0x0313, 0x0301,), '1F3C -> 0399 0313 0301';
ok Uni.new(0x1F3D).NFKD.list ~~ (0x0399, 0x0314, 0x0301,), '1F3D -> 0399 0314 0301';
ok Uni.new(0x1F3E).NFKD.list ~~ (0x0399, 0x0313, 0x0342,), '1F3E -> 0399 0313 0342';
ok Uni.new(0x1F3F).NFKD.list ~~ (0x0399, 0x0314, 0x0342,), '1F3F -> 0399 0314 0342';
ok Uni.new(0x1F40).NFKD.list ~~ (0x03BF, 0x0313,), '1F40 -> 03BF 0313';
ok Uni.new(0x1F41).NFKD.list ~~ (0x03BF, 0x0314,), '1F41 -> 03BF 0314';
ok Uni.new(0x1F42).NFKD.list ~~ (0x03BF, 0x0313, 0x0300,), '1F42 -> 03BF 0313 0300';
ok Uni.new(0x1F43).NFKD.list ~~ (0x03BF, 0x0314, 0x0300,), '1F43 -> 03BF 0314 0300';
ok Uni.new(0x1F44).NFKD.list ~~ (0x03BF, 0x0313, 0x0301,), '1F44 -> 03BF 0313 0301';
ok Uni.new(0x1F45).NFKD.list ~~ (0x03BF, 0x0314, 0x0301,), '1F45 -> 03BF 0314 0301';
ok Uni.new(0x1F48).NFKD.list ~~ (0x039F, 0x0313,), '1F48 -> 039F 0313';
ok Uni.new(0x1F49).NFKD.list ~~ (0x039F, 0x0314,), '1F49 -> 039F 0314';
ok Uni.new(0x1F4A).NFKD.list ~~ (0x039F, 0x0313, 0x0300,), '1F4A -> 039F 0313 0300';
ok Uni.new(0x1F4B).NFKD.list ~~ (0x039F, 0x0314, 0x0300,), '1F4B -> 039F 0314 0300';
ok Uni.new(0x1F4C).NFKD.list ~~ (0x039F, 0x0313, 0x0301,), '1F4C -> 039F 0313 0301';
ok Uni.new(0x1F4D).NFKD.list ~~ (0x039F, 0x0314, 0x0301,), '1F4D -> 039F 0314 0301';
ok Uni.new(0x1F50).NFKD.list ~~ (0x03C5, 0x0313,), '1F50 -> 03C5 0313';
ok Uni.new(0x1F51).NFKD.list ~~ (0x03C5, 0x0314,), '1F51 -> 03C5 0314';
ok Uni.new(0x1F52).NFKD.list ~~ (0x03C5, 0x0313, 0x0300,), '1F52 -> 03C5 0313 0300';
ok Uni.new(0x1F53).NFKD.list ~~ (0x03C5, 0x0314, 0x0300,), '1F53 -> 03C5 0314 0300';
ok Uni.new(0x1F54).NFKD.list ~~ (0x03C5, 0x0313, 0x0301,), '1F54 -> 03C5 0313 0301';
ok Uni.new(0x1F55).NFKD.list ~~ (0x03C5, 0x0314, 0x0301,), '1F55 -> 03C5 0314 0301';
ok Uni.new(0x1F56).NFKD.list ~~ (0x03C5, 0x0313, 0x0342,), '1F56 -> 03C5 0313 0342';
ok Uni.new(0x1F57).NFKD.list ~~ (0x03C5, 0x0314, 0x0342,), '1F57 -> 03C5 0314 0342';
ok Uni.new(0x1F59).NFKD.list ~~ (0x03A5, 0x0314,), '1F59 -> 03A5 0314';
ok Uni.new(0x1F5B).NFKD.list ~~ (0x03A5, 0x0314, 0x0300,), '1F5B -> 03A5 0314 0300';
ok Uni.new(0x1F5D).NFKD.list ~~ (0x03A5, 0x0314, 0x0301,), '1F5D -> 03A5 0314 0301';
ok Uni.new(0x1F5F).NFKD.list ~~ (0x03A5, 0x0314, 0x0342,), '1F5F -> 03A5 0314 0342';
ok Uni.new(0x1F60).NFKD.list ~~ (0x03C9, 0x0313,), '1F60 -> 03C9 0313';
ok Uni.new(0x1F61).NFKD.list ~~ (0x03C9, 0x0314,), '1F61 -> 03C9 0314';
ok Uni.new(0x1F62).NFKD.list ~~ (0x03C9, 0x0313, 0x0300,), '1F62 -> 03C9 0313 0300';
ok Uni.new(0x1F63).NFKD.list ~~ (0x03C9, 0x0314, 0x0300,), '1F63 -> 03C9 0314 0300';
ok Uni.new(0x1F64).NFKD.list ~~ (0x03C9, 0x0313, 0x0301,), '1F64 -> 03C9 0313 0301';
ok Uni.new(0x1F65).NFKD.list ~~ (0x03C9, 0x0314, 0x0301,), '1F65 -> 03C9 0314 0301';
ok Uni.new(0x1F66).NFKD.list ~~ (0x03C9, 0x0313, 0x0342,), '1F66 -> 03C9 0313 0342';
ok Uni.new(0x1F67).NFKD.list ~~ (0x03C9, 0x0314, 0x0342,), '1F67 -> 03C9 0314 0342';
ok Uni.new(0x1F68).NFKD.list ~~ (0x03A9, 0x0313,), '1F68 -> 03A9 0313';
ok Uni.new(0x1F69).NFKD.list ~~ (0x03A9, 0x0314,), '1F69 -> 03A9 0314';
ok Uni.new(0x1F6A).NFKD.list ~~ (0x03A9, 0x0313, 0x0300,), '1F6A -> 03A9 0313 0300';
ok Uni.new(0x1F6B).NFKD.list ~~ (0x03A9, 0x0314, 0x0300,), '1F6B -> 03A9 0314 0300';
ok Uni.new(0x1F6C).NFKD.list ~~ (0x03A9, 0x0313, 0x0301,), '1F6C -> 03A9 0313 0301';
ok Uni.new(0x1F6D).NFKD.list ~~ (0x03A9, 0x0314, 0x0301,), '1F6D -> 03A9 0314 0301';
ok Uni.new(0x1F6E).NFKD.list ~~ (0x03A9, 0x0313, 0x0342,), '1F6E -> 03A9 0313 0342';
ok Uni.new(0x1F6F).NFKD.list ~~ (0x03A9, 0x0314, 0x0342,), '1F6F -> 03A9 0314 0342';
ok Uni.new(0x1F70).NFKD.list ~~ (0x03B1, 0x0300,), '1F70 -> 03B1 0300';
ok Uni.new(0x1F71).NFKD.list ~~ (0x03B1, 0x0301,), '1F71 -> 03B1 0301';
ok Uni.new(0x1F72).NFKD.list ~~ (0x03B5, 0x0300,), '1F72 -> 03B5 0300';
ok Uni.new(0x1F73).NFKD.list ~~ (0x03B5, 0x0301,), '1F73 -> 03B5 0301';
ok Uni.new(0x1F74).NFKD.list ~~ (0x03B7, 0x0300,), '1F74 -> 03B7 0300';
ok Uni.new(0x1F75).NFKD.list ~~ (0x03B7, 0x0301,), '1F75 -> 03B7 0301';
ok Uni.new(0x1F76).NFKD.list ~~ (0x03B9, 0x0300,), '1F76 -> 03B9 0300';
ok Uni.new(0x1F77).NFKD.list ~~ (0x03B9, 0x0301,), '1F77 -> 03B9 0301';
ok Uni.new(0x1F78).NFKD.list ~~ (0x03BF, 0x0300,), '1F78 -> 03BF 0300';
ok Uni.new(0x1F79).NFKD.list ~~ (0x03BF, 0x0301,), '1F79 -> 03BF 0301';
ok Uni.new(0x1F7A).NFKD.list ~~ (0x03C5, 0x0300,), '1F7A -> 03C5 0300';
ok Uni.new(0x1F7B).NFKD.list ~~ (0x03C5, 0x0301,), '1F7B -> 03C5 0301';
ok Uni.new(0x1F7C).NFKD.list ~~ (0x03C9, 0x0300,), '1F7C -> 03C9 0300';
ok Uni.new(0x1F7D).NFKD.list ~~ (0x03C9, 0x0301,), '1F7D -> 03C9 0301';
ok Uni.new(0x1F80).NFKD.list ~~ (0x03B1, 0x0313, 0x0345,), '1F80 -> 03B1 0313 0345';
ok Uni.new(0x1F81).NFKD.list ~~ (0x03B1, 0x0314, 0x0345,), '1F81 -> 03B1 0314 0345';
ok Uni.new(0x1F82).NFKD.list ~~ (0x03B1, 0x0313, 0x0300, 0x0345,), '1F82 -> 03B1 0313 0300 0345';
ok Uni.new(0x1F83).NFKD.list ~~ (0x03B1, 0x0314, 0x0300, 0x0345,), '1F83 -> 03B1 0314 0300 0345';
ok Uni.new(0x1F84).NFKD.list ~~ (0x03B1, 0x0313, 0x0301, 0x0345,), '1F84 -> 03B1 0313 0301 0345';
ok Uni.new(0x1F85).NFKD.list ~~ (0x03B1, 0x0314, 0x0301, 0x0345,), '1F85 -> 03B1 0314 0301 0345';
ok Uni.new(0x1F86).NFKD.list ~~ (0x03B1, 0x0313, 0x0342, 0x0345,), '1F86 -> 03B1 0313 0342 0345';
ok Uni.new(0x1F87).NFKD.list ~~ (0x03B1, 0x0314, 0x0342, 0x0345,), '1F87 -> 03B1 0314 0342 0345';
ok Uni.new(0x1F88).NFKD.list ~~ (0x0391, 0x0313, 0x0345,), '1F88 -> 0391 0313 0345';
ok Uni.new(0x1F89).NFKD.list ~~ (0x0391, 0x0314, 0x0345,), '1F89 -> 0391 0314 0345';
ok Uni.new(0x1F8A).NFKD.list ~~ (0x0391, 0x0313, 0x0300, 0x0345,), '1F8A -> 0391 0313 0300 0345';
ok Uni.new(0x1F8B).NFKD.list ~~ (0x0391, 0x0314, 0x0300, 0x0345,), '1F8B -> 0391 0314 0300 0345';
ok Uni.new(0x1F8C).NFKD.list ~~ (0x0391, 0x0313, 0x0301, 0x0345,), '1F8C -> 0391 0313 0301 0345';
ok Uni.new(0x1F8D).NFKD.list ~~ (0x0391, 0x0314, 0x0301, 0x0345,), '1F8D -> 0391 0314 0301 0345';
ok Uni.new(0x1F8E).NFKD.list ~~ (0x0391, 0x0313, 0x0342, 0x0345,), '1F8E -> 0391 0313 0342 0345';
ok Uni.new(0x1F8F).NFKD.list ~~ (0x0391, 0x0314, 0x0342, 0x0345,), '1F8F -> 0391 0314 0342 0345';
ok Uni.new(0x1F90).NFKD.list ~~ (0x03B7, 0x0313, 0x0345,), '1F90 -> 03B7 0313 0345';
ok Uni.new(0x1F91).NFKD.list ~~ (0x03B7, 0x0314, 0x0345,), '1F91 -> 03B7 0314 0345';
ok Uni.new(0x1F92).NFKD.list ~~ (0x03B7, 0x0313, 0x0300, 0x0345,), '1F92 -> 03B7 0313 0300 0345';
ok Uni.new(0x1F93).NFKD.list ~~ (0x03B7, 0x0314, 0x0300, 0x0345,), '1F93 -> 03B7 0314 0300 0345';
ok Uni.new(0x1F94).NFKD.list ~~ (0x03B7, 0x0313, 0x0301, 0x0345,), '1F94 -> 03B7 0313 0301 0345';
ok Uni.new(0x1F95).NFKD.list ~~ (0x03B7, 0x0314, 0x0301, 0x0345,), '1F95 -> 03B7 0314 0301 0345';
ok Uni.new(0x1F96).NFKD.list ~~ (0x03B7, 0x0313, 0x0342, 0x0345,), '1F96 -> 03B7 0313 0342 0345';
ok Uni.new(0x1F97).NFKD.list ~~ (0x03B7, 0x0314, 0x0342, 0x0345,), '1F97 -> 03B7 0314 0342 0345';
ok Uni.new(0x1F98).NFKD.list ~~ (0x0397, 0x0313, 0x0345,), '1F98 -> 0397 0313 0345';
ok Uni.new(0x1F99).NFKD.list ~~ (0x0397, 0x0314, 0x0345,), '1F99 -> 0397 0314 0345';
ok Uni.new(0x1F9A).NFKD.list ~~ (0x0397, 0x0313, 0x0300, 0x0345,), '1F9A -> 0397 0313 0300 0345';
ok Uni.new(0x1F9B).NFKD.list ~~ (0x0397, 0x0314, 0x0300, 0x0345,), '1F9B -> 0397 0314 0300 0345';
ok Uni.new(0x1F9C).NFKD.list ~~ (0x0397, 0x0313, 0x0301, 0x0345,), '1F9C -> 0397 0313 0301 0345';
ok Uni.new(0x1F9D).NFKD.list ~~ (0x0397, 0x0314, 0x0301, 0x0345,), '1F9D -> 0397 0314 0301 0345';
ok Uni.new(0x1F9E).NFKD.list ~~ (0x0397, 0x0313, 0x0342, 0x0345,), '1F9E -> 0397 0313 0342 0345';
ok Uni.new(0x1F9F).NFKD.list ~~ (0x0397, 0x0314, 0x0342, 0x0345,), '1F9F -> 0397 0314 0342 0345';
ok Uni.new(0x1FA0).NFKD.list ~~ (0x03C9, 0x0313, 0x0345,), '1FA0 -> 03C9 0313 0345';
ok Uni.new(0x1FA1).NFKD.list ~~ (0x03C9, 0x0314, 0x0345,), '1FA1 -> 03C9 0314 0345';
ok Uni.new(0x1FA2).NFKD.list ~~ (0x03C9, 0x0313, 0x0300, 0x0345,), '1FA2 -> 03C9 0313 0300 0345';
ok Uni.new(0x1FA3).NFKD.list ~~ (0x03C9, 0x0314, 0x0300, 0x0345,), '1FA3 -> 03C9 0314 0300 0345';
ok Uni.new(0x1FA4).NFKD.list ~~ (0x03C9, 0x0313, 0x0301, 0x0345,), '1FA4 -> 03C9 0313 0301 0345';
ok Uni.new(0x1FA5).NFKD.list ~~ (0x03C9, 0x0314, 0x0301, 0x0345,), '1FA5 -> 03C9 0314 0301 0345';
ok Uni.new(0x1FA6).NFKD.list ~~ (0x03C9, 0x0313, 0x0342, 0x0345,), '1FA6 -> 03C9 0313 0342 0345';
ok Uni.new(0x1FA7).NFKD.list ~~ (0x03C9, 0x0314, 0x0342, 0x0345,), '1FA7 -> 03C9 0314 0342 0345';
ok Uni.new(0x1FA8).NFKD.list ~~ (0x03A9, 0x0313, 0x0345,), '1FA8 -> 03A9 0313 0345';
ok Uni.new(0x1FA9).NFKD.list ~~ (0x03A9, 0x0314, 0x0345,), '1FA9 -> 03A9 0314 0345';
ok Uni.new(0x1FAA).NFKD.list ~~ (0x03A9, 0x0313, 0x0300, 0x0345,), '1FAA -> 03A9 0313 0300 0345';
ok Uni.new(0x1FAB).NFKD.list ~~ (0x03A9, 0x0314, 0x0300, 0x0345,), '1FAB -> 03A9 0314 0300 0345';
ok Uni.new(0x1FAC).NFKD.list ~~ (0x03A9, 0x0313, 0x0301, 0x0345,), '1FAC -> 03A9 0313 0301 0345';
ok Uni.new(0x1FAD).NFKD.list ~~ (0x03A9, 0x0314, 0x0301, 0x0345,), '1FAD -> 03A9 0314 0301 0345';
ok Uni.new(0x1FAE).NFKD.list ~~ (0x03A9, 0x0313, 0x0342, 0x0345,), '1FAE -> 03A9 0313 0342 0345';
ok Uni.new(0x1FAF).NFKD.list ~~ (0x03A9, 0x0314, 0x0342, 0x0345,), '1FAF -> 03A9 0314 0342 0345';
ok Uni.new(0x1FB0).NFKD.list ~~ (0x03B1, 0x0306,), '1FB0 -> 03B1 0306';
ok Uni.new(0x1FB1).NFKD.list ~~ (0x03B1, 0x0304,), '1FB1 -> 03B1 0304';
ok Uni.new(0x1FB2).NFKD.list ~~ (0x03B1, 0x0300, 0x0345,), '1FB2 -> 03B1 0300 0345';
ok Uni.new(0x1FB3).NFKD.list ~~ (0x03B1, 0x0345,), '1FB3 -> 03B1 0345';
ok Uni.new(0x1FB4).NFKD.list ~~ (0x03B1, 0x0301, 0x0345,), '1FB4 -> 03B1 0301 0345';
ok Uni.new(0x1FB6).NFKD.list ~~ (0x03B1, 0x0342,), '1FB6 -> 03B1 0342';
ok Uni.new(0x1FB7).NFKD.list ~~ (0x03B1, 0x0342, 0x0345,), '1FB7 -> 03B1 0342 0345';
ok Uni.new(0x1FB8).NFKD.list ~~ (0x0391, 0x0306,), '1FB8 -> 0391 0306';
ok Uni.new(0x1FB9).NFKD.list ~~ (0x0391, 0x0304,), '1FB9 -> 0391 0304';
ok Uni.new(0x1FBA).NFKD.list ~~ (0x0391, 0x0300,), '1FBA -> 0391 0300';
ok Uni.new(0x1FBB).NFKD.list ~~ (0x0391, 0x0301,), '1FBB -> 0391 0301';
ok Uni.new(0x1FBC).NFKD.list ~~ (0x0391, 0x0345,), '1FBC -> 0391 0345';
ok Uni.new(0x1FBD).NFKD.list ~~ (0x0020, 0x0313,), '1FBD -> 0020 0313';
ok Uni.new(0x1FBE).NFKD.list ~~ (0x03B9,), '1FBE -> 03B9';
ok Uni.new(0x1FBF).NFKD.list ~~ (0x0020, 0x0313,), '1FBF -> 0020 0313';
ok Uni.new(0x1FC0).NFKD.list ~~ (0x0020, 0x0342,), '1FC0 -> 0020 0342';
ok Uni.new(0x1FC1).NFKD.list ~~ (0x0020, 0x0308, 0x0342,), '1FC1 -> 0020 0308 0342';
ok Uni.new(0x1FC2).NFKD.list ~~ (0x03B7, 0x0300, 0x0345,), '1FC2 -> 03B7 0300 0345';
ok Uni.new(0x1FC3).NFKD.list ~~ (0x03B7, 0x0345,), '1FC3 -> 03B7 0345';
ok Uni.new(0x1FC4).NFKD.list ~~ (0x03B7, 0x0301, 0x0345,), '1FC4 -> 03B7 0301 0345';
ok Uni.new(0x1FC6).NFKD.list ~~ (0x03B7, 0x0342,), '1FC6 -> 03B7 0342';
ok Uni.new(0x1FC7).NFKD.list ~~ (0x03B7, 0x0342, 0x0345,), '1FC7 -> 03B7 0342 0345';
ok Uni.new(0x1FC8).NFKD.list ~~ (0x0395, 0x0300,), '1FC8 -> 0395 0300';
ok Uni.new(0x1FC9).NFKD.list ~~ (0x0395, 0x0301,), '1FC9 -> 0395 0301';
ok Uni.new(0x1FCA).NFKD.list ~~ (0x0397, 0x0300,), '1FCA -> 0397 0300';
ok Uni.new(0x1FCB).NFKD.list ~~ (0x0397, 0x0301,), '1FCB -> 0397 0301';
ok Uni.new(0x1FCC).NFKD.list ~~ (0x0397, 0x0345,), '1FCC -> 0397 0345';
ok Uni.new(0x1FCD).NFKD.list ~~ (0x0020, 0x0313, 0x0300,), '1FCD -> 0020 0313 0300';
ok Uni.new(0x1FCE).NFKD.list ~~ (0x0020, 0x0313, 0x0301,), '1FCE -> 0020 0313 0301';
ok Uni.new(0x1FCF).NFKD.list ~~ (0x0020, 0x0313, 0x0342,), '1FCF -> 0020 0313 0342';
ok Uni.new(0x1FD0).NFKD.list ~~ (0x03B9, 0x0306,), '1FD0 -> 03B9 0306';
ok Uni.new(0x1FD1).NFKD.list ~~ (0x03B9, 0x0304,), '1FD1 -> 03B9 0304';
ok Uni.new(0x1FD2).NFKD.list ~~ (0x03B9, 0x0308, 0x0300,), '1FD2 -> 03B9 0308 0300';
ok Uni.new(0x1FD3).NFKD.list ~~ (0x03B9, 0x0308, 0x0301,), '1FD3 -> 03B9 0308 0301';
ok Uni.new(0x1FD6).NFKD.list ~~ (0x03B9, 0x0342,), '1FD6 -> 03B9 0342';
ok Uni.new(0x1FD7).NFKD.list ~~ (0x03B9, 0x0308, 0x0342,), '1FD7 -> 03B9 0308 0342';
ok Uni.new(0x1FD8).NFKD.list ~~ (0x0399, 0x0306,), '1FD8 -> 0399 0306';
ok Uni.new(0x1FD9).NFKD.list ~~ (0x0399, 0x0304,), '1FD9 -> 0399 0304';
ok Uni.new(0x1FDA).NFKD.list ~~ (0x0399, 0x0300,), '1FDA -> 0399 0300';
ok Uni.new(0x1FDB).NFKD.list ~~ (0x0399, 0x0301,), '1FDB -> 0399 0301';
ok Uni.new(0x1FDD).NFKD.list ~~ (0x0020, 0x0314, 0x0300,), '1FDD -> 0020 0314 0300';
ok Uni.new(0x1FDE).NFKD.list ~~ (0x0020, 0x0314, 0x0301,), '1FDE -> 0020 0314 0301';
ok Uni.new(0x1FDF).NFKD.list ~~ (0x0020, 0x0314, 0x0342,), '1FDF -> 0020 0314 0342';
ok Uni.new(0x1FE0).NFKD.list ~~ (0x03C5, 0x0306,), '1FE0 -> 03C5 0306';
ok Uni.new(0x1FE1).NFKD.list ~~ (0x03C5, 0x0304,), '1FE1 -> 03C5 0304';
ok Uni.new(0x1FE2).NFKD.list ~~ (0x03C5, 0x0308, 0x0300,), '1FE2 -> 03C5 0308 0300';
ok Uni.new(0x1FE3).NFKD.list ~~ (0x03C5, 0x0308, 0x0301,), '1FE3 -> 03C5 0308 0301';
ok Uni.new(0x1FE4).NFKD.list ~~ (0x03C1, 0x0313,), '1FE4 -> 03C1 0313';
ok Uni.new(0x1FE5).NFKD.list ~~ (0x03C1, 0x0314,), '1FE5 -> 03C1 0314';
ok Uni.new(0x1FE6).NFKD.list ~~ (0x03C5, 0x0342,), '1FE6 -> 03C5 0342';
ok Uni.new(0x1FE7).NFKD.list ~~ (0x03C5, 0x0308, 0x0342,), '1FE7 -> 03C5 0308 0342';
ok Uni.new(0x1FE8).NFKD.list ~~ (0x03A5, 0x0306,), '1FE8 -> 03A5 0306';
ok Uni.new(0x1FE9).NFKD.list ~~ (0x03A5, 0x0304,), '1FE9 -> 03A5 0304';
ok Uni.new(0x1FEA).NFKD.list ~~ (0x03A5, 0x0300,), '1FEA -> 03A5 0300';
ok Uni.new(0x1FEB).NFKD.list ~~ (0x03A5, 0x0301,), '1FEB -> 03A5 0301';
ok Uni.new(0x1FEC).NFKD.list ~~ (0x03A1, 0x0314,), '1FEC -> 03A1 0314';
ok Uni.new(0x1FED).NFKD.list ~~ (0x0020, 0x0308, 0x0300,), '1FED -> 0020 0308 0300';
ok Uni.new(0x1FEE).NFKD.list ~~ (0x0020, 0x0308, 0x0301,), '1FEE -> 0020 0308 0301';
ok Uni.new(0x1FEF).NFKD.list ~~ (0x0060,), '1FEF -> 0060';
ok Uni.new(0x1FF2).NFKD.list ~~ (0x03C9, 0x0300, 0x0345,), '1FF2 -> 03C9 0300 0345';
ok Uni.new(0x1FF3).NFKD.list ~~ (0x03C9, 0x0345,), '1FF3 -> 03C9 0345';
ok Uni.new(0x1FF4).NFKD.list ~~ (0x03C9, 0x0301, 0x0345,), '1FF4 -> 03C9 0301 0345';
ok Uni.new(0x1FF6).NFKD.list ~~ (0x03C9, 0x0342,), '1FF6 -> 03C9 0342';
ok Uni.new(0x1FF7).NFKD.list ~~ (0x03C9, 0x0342, 0x0345,), '1FF7 -> 03C9 0342 0345';
ok Uni.new(0x1FF8).NFKD.list ~~ (0x039F, 0x0300,), '1FF8 -> 039F 0300';
ok Uni.new(0x1FF9).NFKD.list ~~ (0x039F, 0x0301,), '1FF9 -> 039F 0301';
ok Uni.new(0x1FFA).NFKD.list ~~ (0x03A9, 0x0300,), '1FFA -> 03A9 0300';
ok Uni.new(0x1FFB).NFKD.list ~~ (0x03A9, 0x0301,), '1FFB -> 03A9 0301';
ok Uni.new(0x1FFC).NFKD.list ~~ (0x03A9, 0x0345,), '1FFC -> 03A9 0345';
ok Uni.new(0x1FFD).NFKD.list ~~ (0x0020, 0x0301,), '1FFD -> 0020 0301';
ok Uni.new(0x1FFE).NFKD.list ~~ (0x0020, 0x0314,), '1FFE -> 0020 0314';
ok Uni.new(0x2000).NFKD.list ~~ (0x0020,), '2000 -> 0020';
ok Uni.new(0x2001).NFKD.list ~~ (0x0020,), '2001 -> 0020';
ok Uni.new(0x2002).NFKD.list ~~ (0x0020,), '2002 -> 0020';
ok Uni.new(0x2003).NFKD.list ~~ (0x0020,), '2003 -> 0020';
ok Uni.new(0x2004).NFKD.list ~~ (0x0020,), '2004 -> 0020';
ok Uni.new(0x2005).NFKD.list ~~ (0x0020,), '2005 -> 0020';
ok Uni.new(0x2006).NFKD.list ~~ (0x0020,), '2006 -> 0020';
ok Uni.new(0x2007).NFKD.list ~~ (0x0020,), '2007 -> 0020';
ok Uni.new(0x2008).NFKD.list ~~ (0x0020,), '2008 -> 0020';
ok Uni.new(0x2009).NFKD.list ~~ (0x0020,), '2009 -> 0020';
ok Uni.new(0x200A).NFKD.list ~~ (0x0020,), '200A -> 0020';
ok Uni.new(0x2011).NFKD.list ~~ (0x2010,), '2011 -> 2010';
ok Uni.new(0x2017).NFKD.list ~~ (0x0020, 0x0333,), '2017 -> 0020 0333';
ok Uni.new(0x2024).NFKD.list ~~ (0x002E,), '2024 -> 002E';
ok Uni.new(0x2025).NFKD.list ~~ (0x002E, 0x002E,), '2025 -> 002E 002E';
ok Uni.new(0x2026).NFKD.list ~~ (0x002E, 0x002E, 0x002E,), '2026 -> 002E 002E 002E';
ok Uni.new(0x202F).NFKD.list ~~ (0x0020,), '202F -> 0020';
ok Uni.new(0x2033).NFKD.list ~~ (0x2032, 0x2032,), '2033 -> 2032 2032';
ok Uni.new(0x2034).NFKD.list ~~ (0x2032, 0x2032, 0x2032,), '2034 -> 2032 2032 2032';
ok Uni.new(0x2036).NFKD.list ~~ (0x2035, 0x2035,), '2036 -> 2035 2035';
ok Uni.new(0x2037).NFKD.list ~~ (0x2035, 0x2035, 0x2035,), '2037 -> 2035 2035 2035';
ok Uni.new(0x203C).NFKD.list ~~ (0x0021, 0x0021,), '203C -> 0021 0021';
ok Uni.new(0x203E).NFKD.list ~~ (0x0020, 0x0305,), '203E -> 0020 0305';
ok Uni.new(0x2047).NFKD.list ~~ (0x003F, 0x003F,), '2047 -> 003F 003F';
ok Uni.new(0x2048).NFKD.list ~~ (0x003F, 0x0021,), '2048 -> 003F 0021';
ok Uni.new(0x2049).NFKD.list ~~ (0x0021, 0x003F,), '2049 -> 0021 003F';
ok Uni.new(0x2057).NFKD.list ~~ (0x2032, 0x2032, 0x2032, 0x2032,), '2057 -> 2032 2032 2032 2032';
ok Uni.new(0x205F).NFKD.list ~~ (0x0020,), '205F -> 0020';
ok Uni.new(0x2070).NFKD.list ~~ (0x0030,), '2070 -> 0030';
ok Uni.new(0x2071).NFKD.list ~~ (0x0069,), '2071 -> 0069';
ok Uni.new(0x2074).NFKD.list ~~ (0x0034,), '2074 -> 0034';
ok Uni.new(0x2075).NFKD.list ~~ (0x0035,), '2075 -> 0035';
ok Uni.new(0x2076).NFKD.list ~~ (0x0036,), '2076 -> 0036';
ok Uni.new(0x2077).NFKD.list ~~ (0x0037,), '2077 -> 0037';
ok Uni.new(0x2078).NFKD.list ~~ (0x0038,), '2078 -> 0038';
ok Uni.new(0x2079).NFKD.list ~~ (0x0039,), '2079 -> 0039';
ok Uni.new(0x207A).NFKD.list ~~ (0x002B,), '207A -> 002B';
ok Uni.new(0x207B).NFKD.list ~~ (0x2212,), '207B -> 2212';
ok Uni.new(0x207C).NFKD.list ~~ (0x003D,), '207C -> 003D';
ok Uni.new(0x207D).NFKD.list ~~ (0x0028,), '207D -> 0028';
ok Uni.new(0x207E).NFKD.list ~~ (0x0029,), '207E -> 0029';
ok Uni.new(0x207F).NFKD.list ~~ (0x006E,), '207F -> 006E';
ok Uni.new(0x2080).NFKD.list ~~ (0x0030,), '2080 -> 0030';
ok Uni.new(0x2081).NFKD.list ~~ (0x0031,), '2081 -> 0031';
ok Uni.new(0x2082).NFKD.list ~~ (0x0032,), '2082 -> 0032';
ok Uni.new(0x2083).NFKD.list ~~ (0x0033,), '2083 -> 0033';
ok Uni.new(0x2084).NFKD.list ~~ (0x0034,), '2084 -> 0034';
ok Uni.new(0x2085).NFKD.list ~~ (0x0035,), '2085 -> 0035';
ok Uni.new(0x2086).NFKD.list ~~ (0x0036,), '2086 -> 0036';
ok Uni.new(0x2087).NFKD.list ~~ (0x0037,), '2087 -> 0037';
ok Uni.new(0x2088).NFKD.list ~~ (0x0038,), '2088 -> 0038';
ok Uni.new(0x2089).NFKD.list ~~ (0x0039,), '2089 -> 0039';
ok Uni.new(0x208A).NFKD.list ~~ (0x002B,), '208A -> 002B';
ok Uni.new(0x208B).NFKD.list ~~ (0x2212,), '208B -> 2212';
ok Uni.new(0x208C).NFKD.list ~~ (0x003D,), '208C -> 003D';
ok Uni.new(0x208D).NFKD.list ~~ (0x0028,), '208D -> 0028';
ok Uni.new(0x208E).NFKD.list ~~ (0x0029,), '208E -> 0029';
ok Uni.new(0x2090).NFKD.list ~~ (0x0061,), '2090 -> 0061';
ok Uni.new(0x2091).NFKD.list ~~ (0x0065,), '2091 -> 0065';
ok Uni.new(0x2092).NFKD.list ~~ (0x006F,), '2092 -> 006F';
ok Uni.new(0x2093).NFKD.list ~~ (0x0078,), '2093 -> 0078';
ok Uni.new(0x2094).NFKD.list ~~ (0x0259,), '2094 -> 0259';
ok Uni.new(0x2095).NFKD.list ~~ (0x0068,), '2095 -> 0068';
ok Uni.new(0x2096).NFKD.list ~~ (0x006B,), '2096 -> 006B';
ok Uni.new(0x2097).NFKD.list ~~ (0x006C,), '2097 -> 006C';
ok Uni.new(0x2098).NFKD.list ~~ (0x006D,), '2098 -> 006D';
ok Uni.new(0x2099).NFKD.list ~~ (0x006E,), '2099 -> 006E';
ok Uni.new(0x209A).NFKD.list ~~ (0x0070,), '209A -> 0070';
ok Uni.new(0x209B).NFKD.list ~~ (0x0073,), '209B -> 0073';
ok Uni.new(0x209C).NFKD.list ~~ (0x0074,), '209C -> 0074';
ok Uni.new(0x20A8).NFKD.list ~~ (0x0052, 0x0073,), '20A8 -> 0052 0073';
ok Uni.new(0x2100).NFKD.list ~~ (0x0061, 0x002F, 0x0063,), '2100 -> 0061 002F 0063';
ok Uni.new(0x2101).NFKD.list ~~ (0x0061, 0x002F, 0x0073,), '2101 -> 0061 002F 0073';
ok Uni.new(0x2102).NFKD.list ~~ (0x0043,), '2102 -> 0043';
ok Uni.new(0x2103).NFKD.list ~~ (0x00B0, 0x0043,), '2103 -> 00B0 0043';
ok Uni.new(0x2105).NFKD.list ~~ (0x0063, 0x002F, 0x006F,), '2105 -> 0063 002F 006F';
ok Uni.new(0x2106).NFKD.list ~~ (0x0063, 0x002F, 0x0075,), '2106 -> 0063 002F 0075';
ok Uni.new(0x2107).NFKD.list ~~ (0x0190,), '2107 -> 0190';
ok Uni.new(0x2109).NFKD.list ~~ (0x00B0, 0x0046,), '2109 -> 00B0 0046';
ok Uni.new(0x210A).NFKD.list ~~ (0x0067,), '210A -> 0067';
ok Uni.new(0x210B).NFKD.list ~~ (0x0048,), '210B -> 0048';
ok Uni.new(0x210C).NFKD.list ~~ (0x0048,), '210C -> 0048';
ok Uni.new(0x210D).NFKD.list ~~ (0x0048,), '210D -> 0048';
ok Uni.new(0x210E).NFKD.list ~~ (0x0068,), '210E -> 0068';
ok Uni.new(0x210F).NFKD.list ~~ (0x0127,), '210F -> 0127';
ok Uni.new(0x2110).NFKD.list ~~ (0x0049,), '2110 -> 0049';
ok Uni.new(0x2111).NFKD.list ~~ (0x0049,), '2111 -> 0049';
ok Uni.new(0x2112).NFKD.list ~~ (0x004C,), '2112 -> 004C';
ok Uni.new(0x2113).NFKD.list ~~ (0x006C,), '2113 -> 006C';
ok Uni.new(0x2115).NFKD.list ~~ (0x004E,), '2115 -> 004E';
ok Uni.new(0x2116).NFKD.list ~~ (0x004E, 0x006F,), '2116 -> 004E 006F';
ok Uni.new(0x2119).NFKD.list ~~ (0x0050,), '2119 -> 0050';
ok Uni.new(0x211A).NFKD.list ~~ (0x0051,), '211A -> 0051';
ok Uni.new(0x211B).NFKD.list ~~ (0x0052,), '211B -> 0052';
ok Uni.new(0x211C).NFKD.list ~~ (0x0052,), '211C -> 0052';
ok Uni.new(0x211D).NFKD.list ~~ (0x0052,), '211D -> 0052';
ok Uni.new(0x2120).NFKD.list ~~ (0x0053, 0x004D,), '2120 -> 0053 004D';
ok Uni.new(0x2121).NFKD.list ~~ (0x0054, 0x0045, 0x004C,), '2121 -> 0054 0045 004C';
ok Uni.new(0x2122).NFKD.list ~~ (0x0054, 0x004D,), '2122 -> 0054 004D';
ok Uni.new(0x2124).NFKD.list ~~ (0x005A,), '2124 -> 005A';
ok Uni.new(0x2126).NFKD.list ~~ (0x03A9,), '2126 -> 03A9';
ok Uni.new(0x2128).NFKD.list ~~ (0x005A,), '2128 -> 005A';
ok Uni.new(0x212A).NFKD.list ~~ (0x004B,), '212A -> 004B';
ok Uni.new(0x212B).NFKD.list ~~ (0x0041, 0x030A,), '212B -> 0041 030A';
ok Uni.new(0x212C).NFKD.list ~~ (0x0042,), '212C -> 0042';
ok Uni.new(0x212D).NFKD.list ~~ (0x0043,), '212D -> 0043';
ok Uni.new(0x212F).NFKD.list ~~ (0x0065,), '212F -> 0065';
ok Uni.new(0x2130).NFKD.list ~~ (0x0045,), '2130 -> 0045';
ok Uni.new(0x2131).NFKD.list ~~ (0x0046,), '2131 -> 0046';
ok Uni.new(0x2133).NFKD.list ~~ (0x004D,), '2133 -> 004D';
ok Uni.new(0x2134).NFKD.list ~~ (0x006F,), '2134 -> 006F';
ok Uni.new(0x2135).NFKD.list ~~ (0x05D0,), '2135 -> 05D0';
ok Uni.new(0x2136).NFKD.list ~~ (0x05D1,), '2136 -> 05D1';
ok Uni.new(0x2137).NFKD.list ~~ (0x05D2,), '2137 -> 05D2';
ok Uni.new(0x2138).NFKD.list ~~ (0x05D3,), '2138 -> 05D3';
ok Uni.new(0x2139).NFKD.list ~~ (0x0069,), '2139 -> 0069';
ok Uni.new(0x213B).NFKD.list ~~ (0x0046, 0x0041, 0x0058,), '213B -> 0046 0041 0058';
ok Uni.new(0x213C).NFKD.list ~~ (0x03C0,), '213C -> 03C0';
ok Uni.new(0x213D).NFKD.list ~~ (0x03B3,), '213D -> 03B3';
ok Uni.new(0x213E).NFKD.list ~~ (0x0393,), '213E -> 0393';
ok Uni.new(0x213F).NFKD.list ~~ (0x03A0,), '213F -> 03A0';
ok Uni.new(0x2140).NFKD.list ~~ (0x2211,), '2140 -> 2211';
ok Uni.new(0x2145).NFKD.list ~~ (0x0044,), '2145 -> 0044';
ok Uni.new(0x2146).NFKD.list ~~ (0x0064,), '2146 -> 0064';
ok Uni.new(0x2147).NFKD.list ~~ (0x0065,), '2147 -> 0065';
ok Uni.new(0x2148).NFKD.list ~~ (0x0069,), '2148 -> 0069';
ok Uni.new(0x2149).NFKD.list ~~ (0x006A,), '2149 -> 006A';
ok Uni.new(0x2150).NFKD.list ~~ (0x0031, 0x2044, 0x0037,), '2150 -> 0031 2044 0037';
ok Uni.new(0x2151).NFKD.list ~~ (0x0031, 0x2044, 0x0039,), '2151 -> 0031 2044 0039';
ok Uni.new(0x2152).NFKD.list ~~ (0x0031, 0x2044, 0x0031, 0x0030,), '2152 -> 0031 2044 0031 0030';
ok Uni.new(0x2153).NFKD.list ~~ (0x0031, 0x2044, 0x0033,), '2153 -> 0031 2044 0033';
ok Uni.new(0x2154).NFKD.list ~~ (0x0032, 0x2044, 0x0033,), '2154 -> 0032 2044 0033';
ok Uni.new(0x2155).NFKD.list ~~ (0x0031, 0x2044, 0x0035,), '2155 -> 0031 2044 0035';
ok Uni.new(0x2156).NFKD.list ~~ (0x0032, 0x2044, 0x0035,), '2156 -> 0032 2044 0035';
ok Uni.new(0x2157).NFKD.list ~~ (0x0033, 0x2044, 0x0035,), '2157 -> 0033 2044 0035';
ok Uni.new(0x2158).NFKD.list ~~ (0x0034, 0x2044, 0x0035,), '2158 -> 0034 2044 0035';
ok Uni.new(0x2159).NFKD.list ~~ (0x0031, 0x2044, 0x0036,), '2159 -> 0031 2044 0036';
ok Uni.new(0x215A).NFKD.list ~~ (0x0035, 0x2044, 0x0036,), '215A -> 0035 2044 0036';
ok Uni.new(0x215B).NFKD.list ~~ (0x0031, 0x2044, 0x0038,), '215B -> 0031 2044 0038';
ok Uni.new(0x215C).NFKD.list ~~ (0x0033, 0x2044, 0x0038,), '215C -> 0033 2044 0038';
ok Uni.new(0x215D).NFKD.list ~~ (0x0035, 0x2044, 0x0038,), '215D -> 0035 2044 0038';
ok Uni.new(0x215E).NFKD.list ~~ (0x0037, 0x2044, 0x0038,), '215E -> 0037 2044 0038';
ok Uni.new(0x215F).NFKD.list ~~ (0x0031, 0x2044,), '215F -> 0031 2044';
ok Uni.new(0x2160).NFKD.list ~~ (0x0049,), '2160 -> 0049';
ok Uni.new(0x2161).NFKD.list ~~ (0x0049, 0x0049,), '2161 -> 0049 0049';
ok Uni.new(0x2162).NFKD.list ~~ (0x0049, 0x0049, 0x0049,), '2162 -> 0049 0049 0049';
ok Uni.new(0x2163).NFKD.list ~~ (0x0049, 0x0056,), '2163 -> 0049 0056';
ok Uni.new(0x2164).NFKD.list ~~ (0x0056,), '2164 -> 0056';
ok Uni.new(0x2165).NFKD.list ~~ (0x0056, 0x0049,), '2165 -> 0056 0049';
ok Uni.new(0x2166).NFKD.list ~~ (0x0056, 0x0049, 0x0049,), '2166 -> 0056 0049 0049';
ok Uni.new(0x2167).NFKD.list ~~ (0x0056, 0x0049, 0x0049, 0x0049,), '2167 -> 0056 0049 0049 0049';
ok Uni.new(0x2168).NFKD.list ~~ (0x0049, 0x0058,), '2168 -> 0049 0058';
ok Uni.new(0x2169).NFKD.list ~~ (0x0058,), '2169 -> 0058';
ok Uni.new(0x216A).NFKD.list ~~ (0x0058, 0x0049,), '216A -> 0058 0049';
ok Uni.new(0x216B).NFKD.list ~~ (0x0058, 0x0049, 0x0049,), '216B -> 0058 0049 0049';
ok Uni.new(0x216C).NFKD.list ~~ (0x004C,), '216C -> 004C';
ok Uni.new(0x216D).NFKD.list ~~ (0x0043,), '216D -> 0043';
ok Uni.new(0x216E).NFKD.list ~~ (0x0044,), '216E -> 0044';
ok Uni.new(0x216F).NFKD.list ~~ (0x004D,), '216F -> 004D';
ok Uni.new(0x2170).NFKD.list ~~ (0x0069,), '2170 -> 0069';
ok Uni.new(0x2171).NFKD.list ~~ (0x0069, 0x0069,), '2171 -> 0069 0069';
ok Uni.new(0x2172).NFKD.list ~~ (0x0069, 0x0069, 0x0069,), '2172 -> 0069 0069 0069';
ok Uni.new(0x2173).NFKD.list ~~ (0x0069, 0x0076,), '2173 -> 0069 0076';
ok Uni.new(0x2174).NFKD.list ~~ (0x0076,), '2174 -> 0076';
ok Uni.new(0x2175).NFKD.list ~~ (0x0076, 0x0069,), '2175 -> 0076 0069';
ok Uni.new(0x2176).NFKD.list ~~ (0x0076, 0x0069, 0x0069,), '2176 -> 0076 0069 0069';
ok Uni.new(0x2177).NFKD.list ~~ (0x0076, 0x0069, 0x0069, 0x0069,), '2177 -> 0076 0069 0069 0069';
ok Uni.new(0x2178).NFKD.list ~~ (0x0069, 0x0078,), '2178 -> 0069 0078';
ok Uni.new(0x2179).NFKD.list ~~ (0x0078,), '2179 -> 0078';
ok Uni.new(0x217A).NFKD.list ~~ (0x0078, 0x0069,), '217A -> 0078 0069';
ok Uni.new(0x217B).NFKD.list ~~ (0x0078, 0x0069, 0x0069,), '217B -> 0078 0069 0069';
ok Uni.new(0x217C).NFKD.list ~~ (0x006C,), '217C -> 006C';
ok Uni.new(0x217D).NFKD.list ~~ (0x0063,), '217D -> 0063';
ok Uni.new(0x217E).NFKD.list ~~ (0x0064,), '217E -> 0064';
ok Uni.new(0x217F).NFKD.list ~~ (0x006D,), '217F -> 006D';
ok Uni.new(0x2189).NFKD.list ~~ (0x0030, 0x2044, 0x0033,), '2189 -> 0030 2044 0033';
ok Uni.new(0x219A).NFKD.list ~~ (0x2190, 0x0338,), '219A -> 2190 0338';
ok Uni.new(0x219B).NFKD.list ~~ (0x2192, 0x0338,), '219B -> 2192 0338';
ok Uni.new(0x21AE).NFKD.list ~~ (0x2194, 0x0338,), '21AE -> 2194 0338';
ok Uni.new(0x21CD).NFKD.list ~~ (0x21D0, 0x0338,), '21CD -> 21D0 0338';
ok Uni.new(0x21CE).NFKD.list ~~ (0x21D4, 0x0338,), '21CE -> 21D4 0338';
ok Uni.new(0x21CF).NFKD.list ~~ (0x21D2, 0x0338,), '21CF -> 21D2 0338';
ok Uni.new(0x2204).NFKD.list ~~ (0x2203, 0x0338,), '2204 -> 2203 0338';
ok Uni.new(0x2209).NFKD.list ~~ (0x2208, 0x0338,), '2209 -> 2208 0338';
ok Uni.new(0x220C).NFKD.list ~~ (0x220B, 0x0338,), '220C -> 220B 0338';
ok Uni.new(0x2224).NFKD.list ~~ (0x2223, 0x0338,), '2224 -> 2223 0338';
ok Uni.new(0x2226).NFKD.list ~~ (0x2225, 0x0338,), '2226 -> 2225 0338';
ok Uni.new(0x222C).NFKD.list ~~ (0x222B, 0x222B,), '222C -> 222B 222B';
ok Uni.new(0x222D).NFKD.list ~~ (0x222B, 0x222B, 0x222B,), '222D -> 222B 222B 222B';
ok Uni.new(0x222F).NFKD.list ~~ (0x222E, 0x222E,), '222F -> 222E 222E';
ok Uni.new(0x2230).NFKD.list ~~ (0x222E, 0x222E, 0x222E,), '2230 -> 222E 222E 222E';
ok Uni.new(0x2241).NFKD.list ~~ (0x223C, 0x0338,), '2241 -> 223C 0338';
ok Uni.new(0x2244).NFKD.list ~~ (0x2243, 0x0338,), '2244 -> 2243 0338';
ok Uni.new(0x2247).NFKD.list ~~ (0x2245, 0x0338,), '2247 -> 2245 0338';
ok Uni.new(0x2249).NFKD.list ~~ (0x2248, 0x0338,), '2249 -> 2248 0338';
ok Uni.new(0x2260).NFKD.list ~~ (0x003D, 0x0338,), '2260 -> 003D 0338';
ok Uni.new(0x2262).NFKD.list ~~ (0x2261, 0x0338,), '2262 -> 2261 0338';
ok Uni.new(0x226D).NFKD.list ~~ (0x224D, 0x0338,), '226D -> 224D 0338';
ok Uni.new(0x226E).NFKD.list ~~ (0x003C, 0x0338,), '226E -> 003C 0338';
ok Uni.new(0x226F).NFKD.list ~~ (0x003E, 0x0338,), '226F -> 003E 0338';
ok Uni.new(0x2270).NFKD.list ~~ (0x2264, 0x0338,), '2270 -> 2264 0338';
ok Uni.new(0x2271).NFKD.list ~~ (0x2265, 0x0338,), '2271 -> 2265 0338';
ok Uni.new(0x2274).NFKD.list ~~ (0x2272, 0x0338,), '2274 -> 2272 0338';
ok Uni.new(0x2275).NFKD.list ~~ (0x2273, 0x0338,), '2275 -> 2273 0338';
ok Uni.new(0x2278).NFKD.list ~~ (0x2276, 0x0338,), '2278 -> 2276 0338';
ok Uni.new(0x2279).NFKD.list ~~ (0x2277, 0x0338,), '2279 -> 2277 0338';
ok Uni.new(0x2280).NFKD.list ~~ (0x227A, 0x0338,), '2280 -> 227A 0338';
ok Uni.new(0x2281).NFKD.list ~~ (0x227B, 0x0338,), '2281 -> 227B 0338';
ok Uni.new(0x2284).NFKD.list ~~ (0x2282, 0x0338,), '2284 -> 2282 0338';
ok Uni.new(0x2285).NFKD.list ~~ (0x2283, 0x0338,), '2285 -> 2283 0338';
ok Uni.new(0x2288).NFKD.list ~~ (0x2286, 0x0338,), '2288 -> 2286 0338';
ok Uni.new(0x2289).NFKD.list ~~ (0x2287, 0x0338,), '2289 -> 2287 0338';
ok Uni.new(0x22AC).NFKD.list ~~ (0x22A2, 0x0338,), '22AC -> 22A2 0338';
ok Uni.new(0x22AD).NFKD.list ~~ (0x22A8, 0x0338,), '22AD -> 22A8 0338';
ok Uni.new(0x22AE).NFKD.list ~~ (0x22A9, 0x0338,), '22AE -> 22A9 0338';
ok Uni.new(0x22AF).NFKD.list ~~ (0x22AB, 0x0338,), '22AF -> 22AB 0338';
ok Uni.new(0x22E0).NFKD.list ~~ (0x227C, 0x0338,), '22E0 -> 227C 0338';
ok Uni.new(0x22E1).NFKD.list ~~ (0x227D, 0x0338,), '22E1 -> 227D 0338';
ok Uni.new(0x22E2).NFKD.list ~~ (0x2291, 0x0338,), '22E2 -> 2291 0338';
ok Uni.new(0x22E3).NFKD.list ~~ (0x2292, 0x0338,), '22E3 -> 2292 0338';
ok Uni.new(0x22EA).NFKD.list ~~ (0x22B2, 0x0338,), '22EA -> 22B2 0338';
ok Uni.new(0x22EB).NFKD.list ~~ (0x22B3, 0x0338,), '22EB -> 22B3 0338';
ok Uni.new(0x22EC).NFKD.list ~~ (0x22B4, 0x0338,), '22EC -> 22B4 0338';
ok Uni.new(0x22ED).NFKD.list ~~ (0x22B5, 0x0338,), '22ED -> 22B5 0338';
ok Uni.new(0x2329).NFKD.list ~~ (0x3008,), '2329 -> 3008';
ok Uni.new(0x232A).NFKD.list ~~ (0x3009,), '232A -> 3009';
ok Uni.new(0x2460).NFKD.list ~~ (0x0031,), '2460 -> 0031';
ok Uni.new(0x2461).NFKD.list ~~ (0x0032,), '2461 -> 0032';
ok Uni.new(0x2462).NFKD.list ~~ (0x0033,), '2462 -> 0033';
ok Uni.new(0x2463).NFKD.list ~~ (0x0034,), '2463 -> 0034';
ok Uni.new(0x2464).NFKD.list ~~ (0x0035,), '2464 -> 0035';
ok Uni.new(0x2465).NFKD.list ~~ (0x0036,), '2465 -> 0036';
ok Uni.new(0x2466).NFKD.list ~~ (0x0037,), '2466 -> 0037';
ok Uni.new(0x2467).NFKD.list ~~ (0x0038,), '2467 -> 0038';
ok Uni.new(0x2468).NFKD.list ~~ (0x0039,), '2468 -> 0039';
ok Uni.new(0x2469).NFKD.list ~~ (0x0031, 0x0030,), '2469 -> 0031 0030';
ok Uni.new(0x246A).NFKD.list ~~ (0x0031, 0x0031,), '246A -> 0031 0031';
ok Uni.new(0x246B).NFKD.list ~~ (0x0031, 0x0032,), '246B -> 0031 0032';
ok Uni.new(0x246C).NFKD.list ~~ (0x0031, 0x0033,), '246C -> 0031 0033';
ok Uni.new(0x246D).NFKD.list ~~ (0x0031, 0x0034,), '246D -> 0031 0034';
ok Uni.new(0x246E).NFKD.list ~~ (0x0031, 0x0035,), '246E -> 0031 0035';
ok Uni.new(0x246F).NFKD.list ~~ (0x0031, 0x0036,), '246F -> 0031 0036';
ok Uni.new(0x2470).NFKD.list ~~ (0x0031, 0x0037,), '2470 -> 0031 0037';
ok Uni.new(0x2471).NFKD.list ~~ (0x0031, 0x0038,), '2471 -> 0031 0038';
ok Uni.new(0x2472).NFKD.list ~~ (0x0031, 0x0039,), '2472 -> 0031 0039';
ok Uni.new(0x2473).NFKD.list ~~ (0x0032, 0x0030,), '2473 -> 0032 0030';
ok Uni.new(0x2474).NFKD.list ~~ (0x0028, 0x0031, 0x0029,), '2474 -> 0028 0031 0029';
ok Uni.new(0x2475).NFKD.list ~~ (0x0028, 0x0032, 0x0029,), '2475 -> 0028 0032 0029';
ok Uni.new(0x2476).NFKD.list ~~ (0x0028, 0x0033, 0x0029,), '2476 -> 0028 0033 0029';
ok Uni.new(0x2477).NFKD.list ~~ (0x0028, 0x0034, 0x0029,), '2477 -> 0028 0034 0029';
ok Uni.new(0x2478).NFKD.list ~~ (0x0028, 0x0035, 0x0029,), '2478 -> 0028 0035 0029';
ok Uni.new(0x2479).NFKD.list ~~ (0x0028, 0x0036, 0x0029,), '2479 -> 0028 0036 0029';
ok Uni.new(0x247A).NFKD.list ~~ (0x0028, 0x0037, 0x0029,), '247A -> 0028 0037 0029';
ok Uni.new(0x247B).NFKD.list ~~ (0x0028, 0x0038, 0x0029,), '247B -> 0028 0038 0029';
ok Uni.new(0x247C).NFKD.list ~~ (0x0028, 0x0039, 0x0029,), '247C -> 0028 0039 0029';
ok Uni.new(0x247D).NFKD.list ~~ (0x0028, 0x0031, 0x0030, 0x0029,), '247D -> 0028 0031 0030 0029';
ok Uni.new(0x247E).NFKD.list ~~ (0x0028, 0x0031, 0x0031, 0x0029,), '247E -> 0028 0031 0031 0029';
ok Uni.new(0x247F).NFKD.list ~~ (0x0028, 0x0031, 0x0032, 0x0029,), '247F -> 0028 0031 0032 0029';
ok Uni.new(0x2480).NFKD.list ~~ (0x0028, 0x0031, 0x0033, 0x0029,), '2480 -> 0028 0031 0033 0029';
ok Uni.new(0x2481).NFKD.list ~~ (0x0028, 0x0031, 0x0034, 0x0029,), '2481 -> 0028 0031 0034 0029';
ok Uni.new(0x2482).NFKD.list ~~ (0x0028, 0x0031, 0x0035, 0x0029,), '2482 -> 0028 0031 0035 0029';
ok Uni.new(0x2483).NFKD.list ~~ (0x0028, 0x0031, 0x0036, 0x0029,), '2483 -> 0028 0031 0036 0029';
ok Uni.new(0x2484).NFKD.list ~~ (0x0028, 0x0031, 0x0037, 0x0029,), '2484 -> 0028 0031 0037 0029';
ok Uni.new(0x2485).NFKD.list ~~ (0x0028, 0x0031, 0x0038, 0x0029,), '2485 -> 0028 0031 0038 0029';
ok Uni.new(0x2486).NFKD.list ~~ (0x0028, 0x0031, 0x0039, 0x0029,), '2486 -> 0028 0031 0039 0029';
ok Uni.new(0x2487).NFKD.list ~~ (0x0028, 0x0032, 0x0030, 0x0029,), '2487 -> 0028 0032 0030 0029';
ok Uni.new(0x2488).NFKD.list ~~ (0x0031, 0x002E,), '2488 -> 0031 002E';
ok Uni.new(0x2489).NFKD.list ~~ (0x0032, 0x002E,), '2489 -> 0032 002E';
ok Uni.new(0x248A).NFKD.list ~~ (0x0033, 0x002E,), '248A -> 0033 002E';
ok Uni.new(0x248B).NFKD.list ~~ (0x0034, 0x002E,), '248B -> 0034 002E';
ok Uni.new(0x248C).NFKD.list ~~ (0x0035, 0x002E,), '248C -> 0035 002E';
ok Uni.new(0x248D).NFKD.list ~~ (0x0036, 0x002E,), '248D -> 0036 002E';
ok Uni.new(0x248E).NFKD.list ~~ (0x0037, 0x002E,), '248E -> 0037 002E';
ok Uni.new(0x248F).NFKD.list ~~ (0x0038, 0x002E,), '248F -> 0038 002E';
ok Uni.new(0x2490).NFKD.list ~~ (0x0039, 0x002E,), '2490 -> 0039 002E';
ok Uni.new(0x2491).NFKD.list ~~ (0x0031, 0x0030, 0x002E,), '2491 -> 0031 0030 002E';
ok Uni.new(0x2492).NFKD.list ~~ (0x0031, 0x0031, 0x002E,), '2492 -> 0031 0031 002E';
ok Uni.new(0x2493).NFKD.list ~~ (0x0031, 0x0032, 0x002E,), '2493 -> 0031 0032 002E';
ok Uni.new(0x2494).NFKD.list ~~ (0x0031, 0x0033, 0x002E,), '2494 -> 0031 0033 002E';
ok Uni.new(0x2495).NFKD.list ~~ (0x0031, 0x0034, 0x002E,), '2495 -> 0031 0034 002E';
ok Uni.new(0x2496).NFKD.list ~~ (0x0031, 0x0035, 0x002E,), '2496 -> 0031 0035 002E';
ok Uni.new(0x2497).NFKD.list ~~ (0x0031, 0x0036, 0x002E,), '2497 -> 0031 0036 002E';
ok Uni.new(0x2498).NFKD.list ~~ (0x0031, 0x0037, 0x002E,), '2498 -> 0031 0037 002E';
ok Uni.new(0x2499).NFKD.list ~~ (0x0031, 0x0038, 0x002E,), '2499 -> 0031 0038 002E';
ok Uni.new(0x249A).NFKD.list ~~ (0x0031, 0x0039, 0x002E,), '249A -> 0031 0039 002E';
ok Uni.new(0x249B).NFKD.list ~~ (0x0032, 0x0030, 0x002E,), '249B -> 0032 0030 002E';
ok Uni.new(0x249C).NFKD.list ~~ (0x0028, 0x0061, 0x0029,), '249C -> 0028 0061 0029';
ok Uni.new(0x249D).NFKD.list ~~ (0x0028, 0x0062, 0x0029,), '249D -> 0028 0062 0029';
ok Uni.new(0x249E).NFKD.list ~~ (0x0028, 0x0063, 0x0029,), '249E -> 0028 0063 0029';
ok Uni.new(0x249F).NFKD.list ~~ (0x0028, 0x0064, 0x0029,), '249F -> 0028 0064 0029';
ok Uni.new(0x24A0).NFKD.list ~~ (0x0028, 0x0065, 0x0029,), '24A0 -> 0028 0065 0029';
ok Uni.new(0x24A1).NFKD.list ~~ (0x0028, 0x0066, 0x0029,), '24A1 -> 0028 0066 0029';
ok Uni.new(0x24A2).NFKD.list ~~ (0x0028, 0x0067, 0x0029,), '24A2 -> 0028 0067 0029';
ok Uni.new(0x24A3).NFKD.list ~~ (0x0028, 0x0068, 0x0029,), '24A3 -> 0028 0068 0029';
ok Uni.new(0x24A4).NFKD.list ~~ (0x0028, 0x0069, 0x0029,), '24A4 -> 0028 0069 0029';
ok Uni.new(0x24A5).NFKD.list ~~ (0x0028, 0x006A, 0x0029,), '24A5 -> 0028 006A 0029';
ok Uni.new(0x24A6).NFKD.list ~~ (0x0028, 0x006B, 0x0029,), '24A6 -> 0028 006B 0029';
ok Uni.new(0x24A7).NFKD.list ~~ (0x0028, 0x006C, 0x0029,), '24A7 -> 0028 006C 0029';
ok Uni.new(0x24A8).NFKD.list ~~ (0x0028, 0x006D, 0x0029,), '24A8 -> 0028 006D 0029';
ok Uni.new(0x24A9).NFKD.list ~~ (0x0028, 0x006E, 0x0029,), '24A9 -> 0028 006E 0029';
ok Uni.new(0x24AA).NFKD.list ~~ (0x0028, 0x006F, 0x0029,), '24AA -> 0028 006F 0029';
ok Uni.new(0x24AB).NFKD.list ~~ (0x0028, 0x0070, 0x0029,), '24AB -> 0028 0070 0029';
ok Uni.new(0x24AC).NFKD.list ~~ (0x0028, 0x0071, 0x0029,), '24AC -> 0028 0071 0029';
ok Uni.new(0x24AD).NFKD.list ~~ (0x0028, 0x0072, 0x0029,), '24AD -> 0028 0072 0029';
ok Uni.new(0x24AE).NFKD.list ~~ (0x0028, 0x0073, 0x0029,), '24AE -> 0028 0073 0029';
ok Uni.new(0x24AF).NFKD.list ~~ (0x0028, 0x0074, 0x0029,), '24AF -> 0028 0074 0029';
ok Uni.new(0x24B0).NFKD.list ~~ (0x0028, 0x0075, 0x0029,), '24B0 -> 0028 0075 0029';
ok Uni.new(0x24B1).NFKD.list ~~ (0x0028, 0x0076, 0x0029,), '24B1 -> 0028 0076 0029';
ok Uni.new(0x24B2).NFKD.list ~~ (0x0028, 0x0077, 0x0029,), '24B2 -> 0028 0077 0029';
ok Uni.new(0x24B3).NFKD.list ~~ (0x0028, 0x0078, 0x0029,), '24B3 -> 0028 0078 0029';
ok Uni.new(0x24B4).NFKD.list ~~ (0x0028, 0x0079, 0x0029,), '24B4 -> 0028 0079 0029';
ok Uni.new(0x24B5).NFKD.list ~~ (0x0028, 0x007A, 0x0029,), '24B5 -> 0028 007A 0029';
ok Uni.new(0x24B6).NFKD.list ~~ (0x0041,), '24B6 -> 0041';
ok Uni.new(0x24B7).NFKD.list ~~ (0x0042,), '24B7 -> 0042';
ok Uni.new(0x24B8).NFKD.list ~~ (0x0043,), '24B8 -> 0043';
ok Uni.new(0x24B9).NFKD.list ~~ (0x0044,), '24B9 -> 0044';
ok Uni.new(0x24BA).NFKD.list ~~ (0x0045,), '24BA -> 0045';
ok Uni.new(0x24BB).NFKD.list ~~ (0x0046,), '24BB -> 0046';
ok Uni.new(0x24BC).NFKD.list ~~ (0x0047,), '24BC -> 0047';
ok Uni.new(0x24BD).NFKD.list ~~ (0x0048,), '24BD -> 0048';
ok Uni.new(0x24BE).NFKD.list ~~ (0x0049,), '24BE -> 0049';
ok Uni.new(0x24BF).NFKD.list ~~ (0x004A,), '24BF -> 004A';
ok Uni.new(0x24C0).NFKD.list ~~ (0x004B,), '24C0 -> 004B';
ok Uni.new(0x24C1).NFKD.list ~~ (0x004C,), '24C1 -> 004C';
ok Uni.new(0x24C2).NFKD.list ~~ (0x004D,), '24C2 -> 004D';
ok Uni.new(0x24C3).NFKD.list ~~ (0x004E,), '24C3 -> 004E';
ok Uni.new(0x24C4).NFKD.list ~~ (0x004F,), '24C4 -> 004F';
ok Uni.new(0x24C5).NFKD.list ~~ (0x0050,), '24C5 -> 0050';
ok Uni.new(0x24C6).NFKD.list ~~ (0x0051,), '24C6 -> 0051';
ok Uni.new(0x24C7).NFKD.list ~~ (0x0052,), '24C7 -> 0052';
ok Uni.new(0x24C8).NFKD.list ~~ (0x0053,), '24C8 -> 0053';
ok Uni.new(0x24C9).NFKD.list ~~ (0x0054,), '24C9 -> 0054';
ok Uni.new(0x24CA).NFKD.list ~~ (0x0055,), '24CA -> 0055';
ok Uni.new(0x24CB).NFKD.list ~~ (0x0056,), '24CB -> 0056';
ok Uni.new(0x24CC).NFKD.list ~~ (0x0057,), '24CC -> 0057';
ok Uni.new(0x24CD).NFKD.list ~~ (0x0058,), '24CD -> 0058';
ok Uni.new(0x24CE).NFKD.list ~~ (0x0059,), '24CE -> 0059';
ok Uni.new(0x24CF).NFKD.list ~~ (0x005A,), '24CF -> 005A';
ok Uni.new(0x24D0).NFKD.list ~~ (0x0061,), '24D0 -> 0061';
ok Uni.new(0x24D1).NFKD.list ~~ (0x0062,), '24D1 -> 0062';
ok Uni.new(0x24D2).NFKD.list ~~ (0x0063,), '24D2 -> 0063';
ok Uni.new(0x24D3).NFKD.list ~~ (0x0064,), '24D3 -> 0064';
ok Uni.new(0x24D4).NFKD.list ~~ (0x0065,), '24D4 -> 0065';
ok Uni.new(0x24D5).NFKD.list ~~ (0x0066,), '24D5 -> 0066';
ok Uni.new(0x24D6).NFKD.list ~~ (0x0067,), '24D6 -> 0067';
ok Uni.new(0x24D7).NFKD.list ~~ (0x0068,), '24D7 -> 0068';
ok Uni.new(0x24D8).NFKD.list ~~ (0x0069,), '24D8 -> 0069';
ok Uni.new(0x24D9).NFKD.list ~~ (0x006A,), '24D9 -> 006A';
ok Uni.new(0x24DA).NFKD.list ~~ (0x006B,), '24DA -> 006B';
ok Uni.new(0x24DB).NFKD.list ~~ (0x006C,), '24DB -> 006C';
ok Uni.new(0x24DC).NFKD.list ~~ (0x006D,), '24DC -> 006D';
ok Uni.new(0x24DD).NFKD.list ~~ (0x006E,), '24DD -> 006E';
ok Uni.new(0x24DE).NFKD.list ~~ (0x006F,), '24DE -> 006F';
ok Uni.new(0x24DF).NFKD.list ~~ (0x0070,), '24DF -> 0070';
ok Uni.new(0x24E0).NFKD.list ~~ (0x0071,), '24E0 -> 0071';
ok Uni.new(0x24E1).NFKD.list ~~ (0x0072,), '24E1 -> 0072';
ok Uni.new(0x24E2).NFKD.list ~~ (0x0073,), '24E2 -> 0073';
ok Uni.new(0x24E3).NFKD.list ~~ (0x0074,), '24E3 -> 0074';
ok Uni.new(0x24E4).NFKD.list ~~ (0x0075,), '24E4 -> 0075';
ok Uni.new(0x24E5).NFKD.list ~~ (0x0076,), '24E5 -> 0076';
ok Uni.new(0x24E6).NFKD.list ~~ (0x0077,), '24E6 -> 0077';
ok Uni.new(0x24E7).NFKD.list ~~ (0x0078,), '24E7 -> 0078';
ok Uni.new(0x24E8).NFKD.list ~~ (0x0079,), '24E8 -> 0079';
ok Uni.new(0x24E9).NFKD.list ~~ (0x007A,), '24E9 -> 007A';
ok Uni.new(0x24EA).NFKD.list ~~ (0x0030,), '24EA -> 0030';
ok Uni.new(0x2A0C).NFKD.list ~~ (0x222B, 0x222B, 0x222B, 0x222B,), '2A0C -> 222B 222B 222B 222B';
ok Uni.new(0x2A74).NFKD.list ~~ (0x003A, 0x003A, 0x003D,), '2A74 -> 003A 003A 003D';
ok Uni.new(0x2A75).NFKD.list ~~ (0x003D, 0x003D,), '2A75 -> 003D 003D';
ok Uni.new(0x2A76).NFKD.list ~~ (0x003D, 0x003D, 0x003D,), '2A76 -> 003D 003D 003D';
ok Uni.new(0x2ADC).NFKD.list ~~ (0x2ADD, 0x0338,), '2ADC -> 2ADD 0338';
ok Uni.new(0x2C7C).NFKD.list ~~ (0x006A,), '2C7C -> 006A';
ok Uni.new(0x2C7D).NFKD.list ~~ (0x0056,), '2C7D -> 0056';
ok Uni.new(0x2D6F).NFKD.list ~~ (0x2D61,), '2D6F -> 2D61';
ok Uni.new(0x2E9F).NFKD.list ~~ (0x6BCD,), '2E9F -> 6BCD';
ok Uni.new(0x2EF3).NFKD.list ~~ (0x9F9F,), '2EF3 -> 9F9F';
ok Uni.new(0x2F00).NFKD.list ~~ (0x4E00,), '2F00 -> 4E00';
ok Uni.new(0x2F01).NFKD.list ~~ (0x4E28,), '2F01 -> 4E28';
ok Uni.new(0x2F02).NFKD.list ~~ (0x4E36,), '2F02 -> 4E36';
ok Uni.new(0x2F03).NFKD.list ~~ (0x4E3F,), '2F03 -> 4E3F';
ok Uni.new(0x2F04).NFKD.list ~~ (0x4E59,), '2F04 -> 4E59';
ok Uni.new(0x2F05).NFKD.list ~~ (0x4E85,), '2F05 -> 4E85';
ok Uni.new(0x2F06).NFKD.list ~~ (0x4E8C,), '2F06 -> 4E8C';
ok Uni.new(0x2F07).NFKD.list ~~ (0x4EA0,), '2F07 -> 4EA0';
ok Uni.new(0x2F08).NFKD.list ~~ (0x4EBA,), '2F08 -> 4EBA';
ok Uni.new(0x2F09).NFKD.list ~~ (0x513F,), '2F09 -> 513F';
ok Uni.new(0x2F0A).NFKD.list ~~ (0x5165,), '2F0A -> 5165';
ok Uni.new(0x2F0B).NFKD.list ~~ (0x516B,), '2F0B -> 516B';
ok Uni.new(0x2F0C).NFKD.list ~~ (0x5182,), '2F0C -> 5182';
ok Uni.new(0x2F0D).NFKD.list ~~ (0x5196,), '2F0D -> 5196';
ok Uni.new(0x2F0E).NFKD.list ~~ (0x51AB,), '2F0E -> 51AB';
ok Uni.new(0x2F0F).NFKD.list ~~ (0x51E0,), '2F0F -> 51E0';
ok Uni.new(0x2F10).NFKD.list ~~ (0x51F5,), '2F10 -> 51F5';
ok Uni.new(0x2F11).NFKD.list ~~ (0x5200,), '2F11 -> 5200';
ok Uni.new(0x2F12).NFKD.list ~~ (0x529B,), '2F12 -> 529B';
ok Uni.new(0x2F13).NFKD.list ~~ (0x52F9,), '2F13 -> 52F9';
ok Uni.new(0x2F14).NFKD.list ~~ (0x5315,), '2F14 -> 5315';
ok Uni.new(0x2F15).NFKD.list ~~ (0x531A,), '2F15 -> 531A';
ok Uni.new(0x2F16).NFKD.list ~~ (0x5338,), '2F16 -> 5338';
ok Uni.new(0x2F17).NFKD.list ~~ (0x5341,), '2F17 -> 5341';
ok Uni.new(0x2F18).NFKD.list ~~ (0x535C,), '2F18 -> 535C';
ok Uni.new(0x2F19).NFKD.list ~~ (0x5369,), '2F19 -> 5369';
ok Uni.new(0x2F1A).NFKD.list ~~ (0x5382,), '2F1A -> 5382';
ok Uni.new(0x2F1B).NFKD.list ~~ (0x53B6,), '2F1B -> 53B6';
ok Uni.new(0x2F1C).NFKD.list ~~ (0x53C8,), '2F1C -> 53C8';
ok Uni.new(0x2F1D).NFKD.list ~~ (0x53E3,), '2F1D -> 53E3';
ok Uni.new(0x2F1E).NFKD.list ~~ (0x56D7,), '2F1E -> 56D7';
ok Uni.new(0x2F1F).NFKD.list ~~ (0x571F,), '2F1F -> 571F';
ok Uni.new(0x2F20).NFKD.list ~~ (0x58EB,), '2F20 -> 58EB';
ok Uni.new(0x2F21).NFKD.list ~~ (0x5902,), '2F21 -> 5902';
ok Uni.new(0x2F22).NFKD.list ~~ (0x590A,), '2F22 -> 590A';
ok Uni.new(0x2F23).NFKD.list ~~ (0x5915,), '2F23 -> 5915';
ok Uni.new(0x2F24).NFKD.list ~~ (0x5927,), '2F24 -> 5927';
ok Uni.new(0x2F25).NFKD.list ~~ (0x5973,), '2F25 -> 5973';
ok Uni.new(0x2F26).NFKD.list ~~ (0x5B50,), '2F26 -> 5B50';
ok Uni.new(0x2F27).NFKD.list ~~ (0x5B80,), '2F27 -> 5B80';
ok Uni.new(0x2F28).NFKD.list ~~ (0x5BF8,), '2F28 -> 5BF8';
ok Uni.new(0x2F29).NFKD.list ~~ (0x5C0F,), '2F29 -> 5C0F';
ok Uni.new(0x2F2A).NFKD.list ~~ (0x5C22,), '2F2A -> 5C22';
ok Uni.new(0x2F2B).NFKD.list ~~ (0x5C38,), '2F2B -> 5C38';
ok Uni.new(0x2F2C).NFKD.list ~~ (0x5C6E,), '2F2C -> 5C6E';
ok Uni.new(0x2F2D).NFKD.list ~~ (0x5C71,), '2F2D -> 5C71';
ok Uni.new(0x2F2E).NFKD.list ~~ (0x5DDB,), '2F2E -> 5DDB';
ok Uni.new(0x2F2F).NFKD.list ~~ (0x5DE5,), '2F2F -> 5DE5';
ok Uni.new(0x2F30).NFKD.list ~~ (0x5DF1,), '2F30 -> 5DF1';
ok Uni.new(0x2F31).NFKD.list ~~ (0x5DFE,), '2F31 -> 5DFE';
ok Uni.new(0x2F32).NFKD.list ~~ (0x5E72,), '2F32 -> 5E72';
ok Uni.new(0x2F33).NFKD.list ~~ (0x5E7A,), '2F33 -> 5E7A';
ok Uni.new(0x2F34).NFKD.list ~~ (0x5E7F,), '2F34 -> 5E7F';
ok Uni.new(0x2F35).NFKD.list ~~ (0x5EF4,), '2F35 -> 5EF4';
ok Uni.new(0x2F36).NFKD.list ~~ (0x5EFE,), '2F36 -> 5EFE';
ok Uni.new(0x2F37).NFKD.list ~~ (0x5F0B,), '2F37 -> 5F0B';
ok Uni.new(0x2F38).NFKD.list ~~ (0x5F13,), '2F38 -> 5F13';
ok Uni.new(0x2F39).NFKD.list ~~ (0x5F50,), '2F39 -> 5F50';
ok Uni.new(0x2F3A).NFKD.list ~~ (0x5F61,), '2F3A -> 5F61';
ok Uni.new(0x2F3B).NFKD.list ~~ (0x5F73,), '2F3B -> 5F73';
ok Uni.new(0x2F3C).NFKD.list ~~ (0x5FC3,), '2F3C -> 5FC3';
ok Uni.new(0x2F3D).NFKD.list ~~ (0x6208,), '2F3D -> 6208';
ok Uni.new(0x2F3E).NFKD.list ~~ (0x6236,), '2F3E -> 6236';
ok Uni.new(0x2F3F).NFKD.list ~~ (0x624B,), '2F3F -> 624B';
ok Uni.new(0x2F40).NFKD.list ~~ (0x652F,), '2F40 -> 652F';
ok Uni.new(0x2F41).NFKD.list ~~ (0x6534,), '2F41 -> 6534';
ok Uni.new(0x2F42).NFKD.list ~~ (0x6587,), '2F42 -> 6587';
ok Uni.new(0x2F43).NFKD.list ~~ (0x6597,), '2F43 -> 6597';
ok Uni.new(0x2F44).NFKD.list ~~ (0x65A4,), '2F44 -> 65A4';
ok Uni.new(0x2F45).NFKD.list ~~ (0x65B9,), '2F45 -> 65B9';
ok Uni.new(0x2F46).NFKD.list ~~ (0x65E0,), '2F46 -> 65E0';
ok Uni.new(0x2F47).NFKD.list ~~ (0x65E5,), '2F47 -> 65E5';
ok Uni.new(0x2F48).NFKD.list ~~ (0x66F0,), '2F48 -> 66F0';
ok Uni.new(0x2F49).NFKD.list ~~ (0x6708,), '2F49 -> 6708';
ok Uni.new(0x2F4A).NFKD.list ~~ (0x6728,), '2F4A -> 6728';
ok Uni.new(0x2F4B).NFKD.list ~~ (0x6B20,), '2F4B -> 6B20';
ok Uni.new(0x2F4C).NFKD.list ~~ (0x6B62,), '2F4C -> 6B62';
ok Uni.new(0x2F4D).NFKD.list ~~ (0x6B79,), '2F4D -> 6B79';
ok Uni.new(0x2F4E).NFKD.list ~~ (0x6BB3,), '2F4E -> 6BB3';
ok Uni.new(0x2F4F).NFKD.list ~~ (0x6BCB,), '2F4F -> 6BCB';
ok Uni.new(0x2F50).NFKD.list ~~ (0x6BD4,), '2F50 -> 6BD4';
ok Uni.new(0x2F51).NFKD.list ~~ (0x6BDB,), '2F51 -> 6BDB';
ok Uni.new(0x2F52).NFKD.list ~~ (0x6C0F,), '2F52 -> 6C0F';
ok Uni.new(0x2F53).NFKD.list ~~ (0x6C14,), '2F53 -> 6C14';
ok Uni.new(0x2F54).NFKD.list ~~ (0x6C34,), '2F54 -> 6C34';
ok Uni.new(0x2F55).NFKD.list ~~ (0x706B,), '2F55 -> 706B';
ok Uni.new(0x2F56).NFKD.list ~~ (0x722A,), '2F56 -> 722A';
ok Uni.new(0x2F57).NFKD.list ~~ (0x7236,), '2F57 -> 7236';
ok Uni.new(0x2F58).NFKD.list ~~ (0x723B,), '2F58 -> 723B';
ok Uni.new(0x2F59).NFKD.list ~~ (0x723F,), '2F59 -> 723F';
ok Uni.new(0x2F5A).NFKD.list ~~ (0x7247,), '2F5A -> 7247';
ok Uni.new(0x2F5B).NFKD.list ~~ (0x7259,), '2F5B -> 7259';
ok Uni.new(0x2F5C).NFKD.list ~~ (0x725B,), '2F5C -> 725B';
ok Uni.new(0x2F5D).NFKD.list ~~ (0x72AC,), '2F5D -> 72AC';
ok Uni.new(0x2F5E).NFKD.list ~~ (0x7384,), '2F5E -> 7384';
ok Uni.new(0x2F5F).NFKD.list ~~ (0x7389,), '2F5F -> 7389';
ok Uni.new(0x2F60).NFKD.list ~~ (0x74DC,), '2F60 -> 74DC';
ok Uni.new(0x2F61).NFKD.list ~~ (0x74E6,), '2F61 -> 74E6';
ok Uni.new(0x2F62).NFKD.list ~~ (0x7518,), '2F62 -> 7518';
ok Uni.new(0x2F63).NFKD.list ~~ (0x751F,), '2F63 -> 751F';
ok Uni.new(0x2F64).NFKD.list ~~ (0x7528,), '2F64 -> 7528';
ok Uni.new(0x2F65).NFKD.list ~~ (0x7530,), '2F65 -> 7530';
ok Uni.new(0x2F66).NFKD.list ~~ (0x758B,), '2F66 -> 758B';
ok Uni.new(0x2F67).NFKD.list ~~ (0x7592,), '2F67 -> 7592';
ok Uni.new(0x2F68).NFKD.list ~~ (0x7676,), '2F68 -> 7676';
ok Uni.new(0x2F69).NFKD.list ~~ (0x767D,), '2F69 -> 767D';
ok Uni.new(0x2F6A).NFKD.list ~~ (0x76AE,), '2F6A -> 76AE';
ok Uni.new(0x2F6B).NFKD.list ~~ (0x76BF,), '2F6B -> 76BF';
ok Uni.new(0x2F6C).NFKD.list ~~ (0x76EE,), '2F6C -> 76EE';
ok Uni.new(0x2F6D).NFKD.list ~~ (0x77DB,), '2F6D -> 77DB';
ok Uni.new(0x2F6E).NFKD.list ~~ (0x77E2,), '2F6E -> 77E2';
ok Uni.new(0x2F6F).NFKD.list ~~ (0x77F3,), '2F6F -> 77F3';
ok Uni.new(0x2F70).NFKD.list ~~ (0x793A,), '2F70 -> 793A';
ok Uni.new(0x2F71).NFKD.list ~~ (0x79B8,), '2F71 -> 79B8';
ok Uni.new(0x2F72).NFKD.list ~~ (0x79BE,), '2F72 -> 79BE';
ok Uni.new(0x2F73).NFKD.list ~~ (0x7A74,), '2F73 -> 7A74';
ok Uni.new(0x2F74).NFKD.list ~~ (0x7ACB,), '2F74 -> 7ACB';
ok Uni.new(0x2F75).NFKD.list ~~ (0x7AF9,), '2F75 -> 7AF9';
ok Uni.new(0x2F76).NFKD.list ~~ (0x7C73,), '2F76 -> 7C73';
ok Uni.new(0x2F77).NFKD.list ~~ (0x7CF8,), '2F77 -> 7CF8';
ok Uni.new(0x2F78).NFKD.list ~~ (0x7F36,), '2F78 -> 7F36';
ok Uni.new(0x2F79).NFKD.list ~~ (0x7F51,), '2F79 -> 7F51';
ok Uni.new(0x2F7A).NFKD.list ~~ (0x7F8A,), '2F7A -> 7F8A';
ok Uni.new(0x2F7B).NFKD.list ~~ (0x7FBD,), '2F7B -> 7FBD';
ok Uni.new(0x2F7C).NFKD.list ~~ (0x8001,), '2F7C -> 8001';
ok Uni.new(0x2F7D).NFKD.list ~~ (0x800C,), '2F7D -> 800C';
ok Uni.new(0x2F7E).NFKD.list ~~ (0x8012,), '2F7E -> 8012';
ok Uni.new(0x2F7F).NFKD.list ~~ (0x8033,), '2F7F -> 8033';
ok Uni.new(0x2F80).NFKD.list ~~ (0x807F,), '2F80 -> 807F';
ok Uni.new(0x2F81).NFKD.list ~~ (0x8089,), '2F81 -> 8089';
ok Uni.new(0x2F82).NFKD.list ~~ (0x81E3,), '2F82 -> 81E3';
ok Uni.new(0x2F83).NFKD.list ~~ (0x81EA,), '2F83 -> 81EA';
ok Uni.new(0x2F84).NFKD.list ~~ (0x81F3,), '2F84 -> 81F3';
ok Uni.new(0x2F85).NFKD.list ~~ (0x81FC,), '2F85 -> 81FC';
ok Uni.new(0x2F86).NFKD.list ~~ (0x820C,), '2F86 -> 820C';
ok Uni.new(0x2F87).NFKD.list ~~ (0x821B,), '2F87 -> 821B';
ok Uni.new(0x2F88).NFKD.list ~~ (0x821F,), '2F88 -> 821F';
ok Uni.new(0x2F89).NFKD.list ~~ (0x826E,), '2F89 -> 826E';
ok Uni.new(0x2F8A).NFKD.list ~~ (0x8272,), '2F8A -> 8272';
ok Uni.new(0x2F8B).NFKD.list ~~ (0x8278,), '2F8B -> 8278';
ok Uni.new(0x2F8C).NFKD.list ~~ (0x864D,), '2F8C -> 864D';
ok Uni.new(0x2F8D).NFKD.list ~~ (0x866B,), '2F8D -> 866B';
ok Uni.new(0x2F8E).NFKD.list ~~ (0x8840,), '2F8E -> 8840';
ok Uni.new(0x2F8F).NFKD.list ~~ (0x884C,), '2F8F -> 884C';
ok Uni.new(0x2F90).NFKD.list ~~ (0x8863,), '2F90 -> 8863';
ok Uni.new(0x2F91).NFKD.list ~~ (0x897E,), '2F91 -> 897E';
ok Uni.new(0x2F92).NFKD.list ~~ (0x898B,), '2F92 -> 898B';
ok Uni.new(0x2F93).NFKD.list ~~ (0x89D2,), '2F93 -> 89D2';
ok Uni.new(0x2F94).NFKD.list ~~ (0x8A00,), '2F94 -> 8A00';
ok Uni.new(0x2F95).NFKD.list ~~ (0x8C37,), '2F95 -> 8C37';
ok Uni.new(0x2F96).NFKD.list ~~ (0x8C46,), '2F96 -> 8C46';
ok Uni.new(0x2F97).NFKD.list ~~ (0x8C55,), '2F97 -> 8C55';
ok Uni.new(0x2F98).NFKD.list ~~ (0x8C78,), '2F98 -> 8C78';
ok Uni.new(0x2F99).NFKD.list ~~ (0x8C9D,), '2F99 -> 8C9D';
ok Uni.new(0x2F9A).NFKD.list ~~ (0x8D64,), '2F9A -> 8D64';
ok Uni.new(0x2F9B).NFKD.list ~~ (0x8D70,), '2F9B -> 8D70';
ok Uni.new(0x2F9C).NFKD.list ~~ (0x8DB3,), '2F9C -> 8DB3';
ok Uni.new(0x2F9D).NFKD.list ~~ (0x8EAB,), '2F9D -> 8EAB';
ok Uni.new(0x2F9E).NFKD.list ~~ (0x8ECA,), '2F9E -> 8ECA';
ok Uni.new(0x2F9F).NFKD.list ~~ (0x8F9B,), '2F9F -> 8F9B';
ok Uni.new(0x2FA0).NFKD.list ~~ (0x8FB0,), '2FA0 -> 8FB0';
ok Uni.new(0x2FA1).NFKD.list ~~ (0x8FB5,), '2FA1 -> 8FB5';
ok Uni.new(0x2FA2).NFKD.list ~~ (0x9091,), '2FA2 -> 9091';
ok Uni.new(0x2FA3).NFKD.list ~~ (0x9149,), '2FA3 -> 9149';
ok Uni.new(0x2FA4).NFKD.list ~~ (0x91C6,), '2FA4 -> 91C6';
ok Uni.new(0x2FA5).NFKD.list ~~ (0x91CC,), '2FA5 -> 91CC';
ok Uni.new(0x2FA6).NFKD.list ~~ (0x91D1,), '2FA6 -> 91D1';
ok Uni.new(0x2FA7).NFKD.list ~~ (0x9577,), '2FA7 -> 9577';
ok Uni.new(0x2FA8).NFKD.list ~~ (0x9580,), '2FA8 -> 9580';
ok Uni.new(0x2FA9).NFKD.list ~~ (0x961C,), '2FA9 -> 961C';
ok Uni.new(0x2FAA).NFKD.list ~~ (0x96B6,), '2FAA -> 96B6';
ok Uni.new(0x2FAB).NFKD.list ~~ (0x96B9,), '2FAB -> 96B9';
ok Uni.new(0x2FAC).NFKD.list ~~ (0x96E8,), '2FAC -> 96E8';
ok Uni.new(0x2FAD).NFKD.list ~~ (0x9751,), '2FAD -> 9751';
ok Uni.new(0x2FAE).NFKD.list ~~ (0x975E,), '2FAE -> 975E';
ok Uni.new(0x2FAF).NFKD.list ~~ (0x9762,), '2FAF -> 9762';
ok Uni.new(0x2FB0).NFKD.list ~~ (0x9769,), '2FB0 -> 9769';
ok Uni.new(0x2FB1).NFKD.list ~~ (0x97CB,), '2FB1 -> 97CB';
ok Uni.new(0x2FB2).NFKD.list ~~ (0x97ED,), '2FB2 -> 97ED';
ok Uni.new(0x2FB3).NFKD.list ~~ (0x97F3,), '2FB3 -> 97F3';
ok Uni.new(0x2FB4).NFKD.list ~~ (0x9801,), '2FB4 -> 9801';
ok Uni.new(0x2FB5).NFKD.list ~~ (0x98A8,), '2FB5 -> 98A8';
ok Uni.new(0x2FB6).NFKD.list ~~ (0x98DB,), '2FB6 -> 98DB';
ok Uni.new(0x2FB7).NFKD.list ~~ (0x98DF,), '2FB7 -> 98DF';
ok Uni.new(0x2FB8).NFKD.list ~~ (0x9996,), '2FB8 -> 9996';
ok Uni.new(0x2FB9).NFKD.list ~~ (0x9999,), '2FB9 -> 9999';
ok Uni.new(0x2FBA).NFKD.list ~~ (0x99AC,), '2FBA -> 99AC';
ok Uni.new(0x2FBB).NFKD.list ~~ (0x9AA8,), '2FBB -> 9AA8';
ok Uni.new(0x2FBC).NFKD.list ~~ (0x9AD8,), '2FBC -> 9AD8';
ok Uni.new(0x2FBD).NFKD.list ~~ (0x9ADF,), '2FBD -> 9ADF';
ok Uni.new(0x2FBE).NFKD.list ~~ (0x9B25,), '2FBE -> 9B25';
ok Uni.new(0x2FBF).NFKD.list ~~ (0x9B2F,), '2FBF -> 9B2F';
ok Uni.new(0x2FC0).NFKD.list ~~ (0x9B32,), '2FC0 -> 9B32';
ok Uni.new(0x2FC1).NFKD.list ~~ (0x9B3C,), '2FC1 -> 9B3C';
ok Uni.new(0x2FC2).NFKD.list ~~ (0x9B5A,), '2FC2 -> 9B5A';
ok Uni.new(0x2FC3).NFKD.list ~~ (0x9CE5,), '2FC3 -> 9CE5';
ok Uni.new(0x2FC4).NFKD.list ~~ (0x9E75,), '2FC4 -> 9E75';
ok Uni.new(0x2FC5).NFKD.list ~~ (0x9E7F,), '2FC5 -> 9E7F';
ok Uni.new(0x2FC6).NFKD.list ~~ (0x9EA5,), '2FC6 -> 9EA5';
ok Uni.new(0x2FC7).NFKD.list ~~ (0x9EBB,), '2FC7 -> 9EBB';
ok Uni.new(0x2FC8).NFKD.list ~~ (0x9EC3,), '2FC8 -> 9EC3';
ok Uni.new(0x2FC9).NFKD.list ~~ (0x9ECD,), '2FC9 -> 9ECD';
ok Uni.new(0x2FCA).NFKD.list ~~ (0x9ED1,), '2FCA -> 9ED1';
ok Uni.new(0x2FCB).NFKD.list ~~ (0x9EF9,), '2FCB -> 9EF9';
ok Uni.new(0x2FCC).NFKD.list ~~ (0x9EFD,), '2FCC -> 9EFD';
ok Uni.new(0x2FCD).NFKD.list ~~ (0x9F0E,), '2FCD -> 9F0E';
ok Uni.new(0x2FCE).NFKD.list ~~ (0x9F13,), '2FCE -> 9F13';
ok Uni.new(0x2FCF).NFKD.list ~~ (0x9F20,), '2FCF -> 9F20';
ok Uni.new(0x2FD0).NFKD.list ~~ (0x9F3B,), '2FD0 -> 9F3B';
ok Uni.new(0x2FD1).NFKD.list ~~ (0x9F4A,), '2FD1 -> 9F4A';
ok Uni.new(0x2FD2).NFKD.list ~~ (0x9F52,), '2FD2 -> 9F52';
ok Uni.new(0x2FD3).NFKD.list ~~ (0x9F8D,), '2FD3 -> 9F8D';
ok Uni.new(0x2FD4).NFKD.list ~~ (0x9F9C,), '2FD4 -> 9F9C';
ok Uni.new(0x2FD5).NFKD.list ~~ (0x9FA0,), '2FD5 -> 9FA0';
ok Uni.new(0x3000).NFKD.list ~~ (0x0020,), '3000 -> 0020';
ok Uni.new(0x3036).NFKD.list ~~ (0x3012,), '3036 -> 3012';
ok Uni.new(0x3038).NFKD.list ~~ (0x5341,), '3038 -> 5341';
ok Uni.new(0x3039).NFKD.list ~~ (0x5344,), '3039 -> 5344';
ok Uni.new(0x303A).NFKD.list ~~ (0x5345,), '303A -> 5345';
ok Uni.new(0x304C).NFKD.list ~~ (0x304B, 0x3099,), '304C -> 304B 3099';
ok Uni.new(0x304E).NFKD.list ~~ (0x304D, 0x3099,), '304E -> 304D 3099';
ok Uni.new(0x3050).NFKD.list ~~ (0x304F, 0x3099,), '3050 -> 304F 3099';
ok Uni.new(0x3052).NFKD.list ~~ (0x3051, 0x3099,), '3052 -> 3051 3099';
ok Uni.new(0x3054).NFKD.list ~~ (0x3053, 0x3099,), '3054 -> 3053 3099';
ok Uni.new(0x3056).NFKD.list ~~ (0x3055, 0x3099,), '3056 -> 3055 3099';
ok Uni.new(0x3058).NFKD.list ~~ (0x3057, 0x3099,), '3058 -> 3057 3099';
ok Uni.new(0x305A).NFKD.list ~~ (0x3059, 0x3099,), '305A -> 3059 3099';
ok Uni.new(0x305C).NFKD.list ~~ (0x305B, 0x3099,), '305C -> 305B 3099';
ok Uni.new(0x305E).NFKD.list ~~ (0x305D, 0x3099,), '305E -> 305D 3099';
ok Uni.new(0x3060).NFKD.list ~~ (0x305F, 0x3099,), '3060 -> 305F 3099';
ok Uni.new(0x3062).NFKD.list ~~ (0x3061, 0x3099,), '3062 -> 3061 3099';
ok Uni.new(0x3065).NFKD.list ~~ (0x3064, 0x3099,), '3065 -> 3064 3099';
ok Uni.new(0x3067).NFKD.list ~~ (0x3066, 0x3099,), '3067 -> 3066 3099';
ok Uni.new(0x3069).NFKD.list ~~ (0x3068, 0x3099,), '3069 -> 3068 3099';
ok Uni.new(0x3070).NFKD.list ~~ (0x306F, 0x3099,), '3070 -> 306F 3099';
ok Uni.new(0x3071).NFKD.list ~~ (0x306F, 0x309A,), '3071 -> 306F 309A';
ok Uni.new(0x3073).NFKD.list ~~ (0x3072, 0x3099,), '3073 -> 3072 3099';
ok Uni.new(0x3074).NFKD.list ~~ (0x3072, 0x309A,), '3074 -> 3072 309A';
ok Uni.new(0x3076).NFKD.list ~~ (0x3075, 0x3099,), '3076 -> 3075 3099';
ok Uni.new(0x3077).NFKD.list ~~ (0x3075, 0x309A,), '3077 -> 3075 309A';
ok Uni.new(0x3079).NFKD.list ~~ (0x3078, 0x3099,), '3079 -> 3078 3099';
ok Uni.new(0x307A).NFKD.list ~~ (0x3078, 0x309A,), '307A -> 3078 309A';
ok Uni.new(0x307C).NFKD.list ~~ (0x307B, 0x3099,), '307C -> 307B 3099';
ok Uni.new(0x307D).NFKD.list ~~ (0x307B, 0x309A,), '307D -> 307B 309A';
ok Uni.new(0x3094).NFKD.list ~~ (0x3046, 0x3099,), '3094 -> 3046 3099';
ok Uni.new(0x309B).NFKD.list ~~ (0x0020, 0x3099,), '309B -> 0020 3099';
ok Uni.new(0x309C).NFKD.list ~~ (0x0020, 0x309A,), '309C -> 0020 309A';
ok Uni.new(0x309E).NFKD.list ~~ (0x309D, 0x3099,), '309E -> 309D 3099';
ok Uni.new(0x309F).NFKD.list ~~ (0x3088, 0x308A,), '309F -> 3088 308A';
ok Uni.new(0x30AC).NFKD.list ~~ (0x30AB, 0x3099,), '30AC -> 30AB 3099';
ok Uni.new(0x30AE).NFKD.list ~~ (0x30AD, 0x3099,), '30AE -> 30AD 3099';
ok Uni.new(0x30B0).NFKD.list ~~ (0x30AF, 0x3099,), '30B0 -> 30AF 3099';
ok Uni.new(0x30B2).NFKD.list ~~ (0x30B1, 0x3099,), '30B2 -> 30B1 3099';
ok Uni.new(0x30B4).NFKD.list ~~ (0x30B3, 0x3099,), '30B4 -> 30B3 3099';
ok Uni.new(0x30B6).NFKD.list ~~ (0x30B5, 0x3099,), '30B6 -> 30B5 3099';
ok Uni.new(0x30B8).NFKD.list ~~ (0x30B7, 0x3099,), '30B8 -> 30B7 3099';
ok Uni.new(0x30BA).NFKD.list ~~ (0x30B9, 0x3099,), '30BA -> 30B9 3099';
ok Uni.new(0x30BC).NFKD.list ~~ (0x30BB, 0x3099,), '30BC -> 30BB 3099';
ok Uni.new(0x30BE).NFKD.list ~~ (0x30BD, 0x3099,), '30BE -> 30BD 3099';
ok Uni.new(0x30C0).NFKD.list ~~ (0x30BF, 0x3099,), '30C0 -> 30BF 3099';
ok Uni.new(0x30C2).NFKD.list ~~ (0x30C1, 0x3099,), '30C2 -> 30C1 3099';
ok Uni.new(0x30C5).NFKD.list ~~ (0x30C4, 0x3099,), '30C5 -> 30C4 3099';
ok Uni.new(0x30C7).NFKD.list ~~ (0x30C6, 0x3099,), '30C7 -> 30C6 3099';
ok Uni.new(0x30C9).NFKD.list ~~ (0x30C8, 0x3099,), '30C9 -> 30C8 3099';
ok Uni.new(0x30D0).NFKD.list ~~ (0x30CF, 0x3099,), '30D0 -> 30CF 3099';
ok Uni.new(0x30D1).NFKD.list ~~ (0x30CF, 0x309A,), '30D1 -> 30CF 309A';
ok Uni.new(0x30D3).NFKD.list ~~ (0x30D2, 0x3099,), '30D3 -> 30D2 3099';
ok Uni.new(0x30D4).NFKD.list ~~ (0x30D2, 0x309A,), '30D4 -> 30D2 309A';
ok Uni.new(0x30D6).NFKD.list ~~ (0x30D5, 0x3099,), '30D6 -> 30D5 3099';
ok Uni.new(0x30D7).NFKD.list ~~ (0x30D5, 0x309A,), '30D7 -> 30D5 309A';
ok Uni.new(0x30D9).NFKD.list ~~ (0x30D8, 0x3099,), '30D9 -> 30D8 3099';
ok Uni.new(0x30DA).NFKD.list ~~ (0x30D8, 0x309A,), '30DA -> 30D8 309A';
ok Uni.new(0x30DC).NFKD.list ~~ (0x30DB, 0x3099,), '30DC -> 30DB 3099';
ok Uni.new(0x30DD).NFKD.list ~~ (0x30DB, 0x309A,), '30DD -> 30DB 309A';
ok Uni.new(0x30F4).NFKD.list ~~ (0x30A6, 0x3099,), '30F4 -> 30A6 3099';
ok Uni.new(0x30F7).NFKD.list ~~ (0x30EF, 0x3099,), '30F7 -> 30EF 3099';
ok Uni.new(0x30F8).NFKD.list ~~ (0x30F0, 0x3099,), '30F8 -> 30F0 3099';
ok Uni.new(0x30F9).NFKD.list ~~ (0x30F1, 0x3099,), '30F9 -> 30F1 3099';
ok Uni.new(0x30FA).NFKD.list ~~ (0x30F2, 0x3099,), '30FA -> 30F2 3099';
ok Uni.new(0x30FE).NFKD.list ~~ (0x30FD, 0x3099,), '30FE -> 30FD 3099';
ok Uni.new(0x30FF).NFKD.list ~~ (0x30B3, 0x30C8,), '30FF -> 30B3 30C8';
ok Uni.new(0x3131).NFKD.list ~~ (0x1100,), '3131 -> 1100';
ok Uni.new(0x3132).NFKD.list ~~ (0x1101,), '3132 -> 1101';
ok Uni.new(0x3133).NFKD.list ~~ (0x11AA,), '3133 -> 11AA';
ok Uni.new(0x3134).NFKD.list ~~ (0x1102,), '3134 -> 1102';
ok Uni.new(0x3135).NFKD.list ~~ (0x11AC,), '3135 -> 11AC';
ok Uni.new(0x3136).NFKD.list ~~ (0x11AD,), '3136 -> 11AD';
ok Uni.new(0x3137).NFKD.list ~~ (0x1103,), '3137 -> 1103';
ok Uni.new(0x3138).NFKD.list ~~ (0x1104,), '3138 -> 1104';
ok Uni.new(0x3139).NFKD.list ~~ (0x1105,), '3139 -> 1105';
ok Uni.new(0x313A).NFKD.list ~~ (0x11B0,), '313A -> 11B0';
ok Uni.new(0x313B).NFKD.list ~~ (0x11B1,), '313B -> 11B1';
ok Uni.new(0x313C).NFKD.list ~~ (0x11B2,), '313C -> 11B2';
ok Uni.new(0x313D).NFKD.list ~~ (0x11B3,), '313D -> 11B3';
ok Uni.new(0x313E).NFKD.list ~~ (0x11B4,), '313E -> 11B4';
ok Uni.new(0x313F).NFKD.list ~~ (0x11B5,), '313F -> 11B5';
ok Uni.new(0x3140).NFKD.list ~~ (0x111A,), '3140 -> 111A';
ok Uni.new(0x3141).NFKD.list ~~ (0x1106,), '3141 -> 1106';
ok Uni.new(0x3142).NFKD.list ~~ (0x1107,), '3142 -> 1107';
ok Uni.new(0x3143).NFKD.list ~~ (0x1108,), '3143 -> 1108';
ok Uni.new(0x3144).NFKD.list ~~ (0x1121,), '3144 -> 1121';
ok Uni.new(0x3145).NFKD.list ~~ (0x1109,), '3145 -> 1109';
ok Uni.new(0x3146).NFKD.list ~~ (0x110A,), '3146 -> 110A';
ok Uni.new(0x3147).NFKD.list ~~ (0x110B,), '3147 -> 110B';
ok Uni.new(0x3148).NFKD.list ~~ (0x110C,), '3148 -> 110C';
ok Uni.new(0x3149).NFKD.list ~~ (0x110D,), '3149 -> 110D';
ok Uni.new(0x314A).NFKD.list ~~ (0x110E,), '314A -> 110E';
ok Uni.new(0x314B).NFKD.list ~~ (0x110F,), '314B -> 110F';
ok Uni.new(0x314C).NFKD.list ~~ (0x1110,), '314C -> 1110';
ok Uni.new(0x314D).NFKD.list ~~ (0x1111,), '314D -> 1111';
ok Uni.new(0x314E).NFKD.list ~~ (0x1112,), '314E -> 1112';
ok Uni.new(0x314F).NFKD.list ~~ (0x1161,), '314F -> 1161';
ok Uni.new(0x3150).NFKD.list ~~ (0x1162,), '3150 -> 1162';
ok Uni.new(0x3151).NFKD.list ~~ (0x1163,), '3151 -> 1163';
ok Uni.new(0x3152).NFKD.list ~~ (0x1164,), '3152 -> 1164';
ok Uni.new(0x3153).NFKD.list ~~ (0x1165,), '3153 -> 1165';
ok Uni.new(0x3154).NFKD.list ~~ (0x1166,), '3154 -> 1166';
ok Uni.new(0x3155).NFKD.list ~~ (0x1167,), '3155 -> 1167';
ok Uni.new(0x3156).NFKD.list ~~ (0x1168,), '3156 -> 1168';
ok Uni.new(0x3157).NFKD.list ~~ (0x1169,), '3157 -> 1169';
ok Uni.new(0x3158).NFKD.list ~~ (0x116A,), '3158 -> 116A';
ok Uni.new(0x3159).NFKD.list ~~ (0x116B,), '3159 -> 116B';
ok Uni.new(0x315A).NFKD.list ~~ (0x116C,), '315A -> 116C';
ok Uni.new(0x315B).NFKD.list ~~ (0x116D,), '315B -> 116D';
ok Uni.new(0x315C).NFKD.list ~~ (0x116E,), '315C -> 116E';
ok Uni.new(0x315D).NFKD.list ~~ (0x116F,), '315D -> 116F';
ok Uni.new(0x315E).NFKD.list ~~ (0x1170,), '315E -> 1170';
ok Uni.new(0x315F).NFKD.list ~~ (0x1171,), '315F -> 1171';
ok Uni.new(0x3160).NFKD.list ~~ (0x1172,), '3160 -> 1172';
ok Uni.new(0x3161).NFKD.list ~~ (0x1173,), '3161 -> 1173';
ok Uni.new(0x3162).NFKD.list ~~ (0x1174,), '3162 -> 1174';
ok Uni.new(0x3163).NFKD.list ~~ (0x1175,), '3163 -> 1175';
ok Uni.new(0x3164).NFKD.list ~~ (0x1160,), '3164 -> 1160';
ok Uni.new(0x3165).NFKD.list ~~ (0x1114,), '3165 -> 1114';
ok Uni.new(0x3166).NFKD.list ~~ (0x1115,), '3166 -> 1115';
ok Uni.new(0x3167).NFKD.list ~~ (0x11C7,), '3167 -> 11C7';
ok Uni.new(0x3168).NFKD.list ~~ (0x11C8,), '3168 -> 11C8';
ok Uni.new(0x3169).NFKD.list ~~ (0x11CC,), '3169 -> 11CC';
ok Uni.new(0x316A).NFKD.list ~~ (0x11CE,), '316A -> 11CE';
ok Uni.new(0x316B).NFKD.list ~~ (0x11D3,), '316B -> 11D3';
ok Uni.new(0x316C).NFKD.list ~~ (0x11D7,), '316C -> 11D7';
ok Uni.new(0x316D).NFKD.list ~~ (0x11D9,), '316D -> 11D9';
ok Uni.new(0x316E).NFKD.list ~~ (0x111C,), '316E -> 111C';
ok Uni.new(0x316F).NFKD.list ~~ (0x11DD,), '316F -> 11DD';
ok Uni.new(0x3170).NFKD.list ~~ (0x11DF,), '3170 -> 11DF';
ok Uni.new(0x3171).NFKD.list ~~ (0x111D,), '3171 -> 111D';
ok Uni.new(0x3172).NFKD.list ~~ (0x111E,), '3172 -> 111E';
ok Uni.new(0x3173).NFKD.list ~~ (0x1120,), '3173 -> 1120';
ok Uni.new(0x3174).NFKD.list ~~ (0x1122,), '3174 -> 1122';
ok Uni.new(0x3175).NFKD.list ~~ (0x1123,), '3175 -> 1123';
ok Uni.new(0x3176).NFKD.list ~~ (0x1127,), '3176 -> 1127';
ok Uni.new(0x3177).NFKD.list ~~ (0x1129,), '3177 -> 1129';
ok Uni.new(0x3178).NFKD.list ~~ (0x112B,), '3178 -> 112B';
ok Uni.new(0x3179).NFKD.list ~~ (0x112C,), '3179 -> 112C';
ok Uni.new(0x317A).NFKD.list ~~ (0x112D,), '317A -> 112D';
ok Uni.new(0x317B).NFKD.list ~~ (0x112E,), '317B -> 112E';
ok Uni.new(0x317C).NFKD.list ~~ (0x112F,), '317C -> 112F';
ok Uni.new(0x317D).NFKD.list ~~ (0x1132,), '317D -> 1132';
ok Uni.new(0x317E).NFKD.list ~~ (0x1136,), '317E -> 1136';
ok Uni.new(0x317F).NFKD.list ~~ (0x1140,), '317F -> 1140';
ok Uni.new(0x3180).NFKD.list ~~ (0x1147,), '3180 -> 1147';
ok Uni.new(0x3181).NFKD.list ~~ (0x114C,), '3181 -> 114C';
ok Uni.new(0x3182).NFKD.list ~~ (0x11F1,), '3182 -> 11F1';
ok Uni.new(0x3183).NFKD.list ~~ (0x11F2,), '3183 -> 11F2';
ok Uni.new(0x3184).NFKD.list ~~ (0x1157,), '3184 -> 1157';
ok Uni.new(0x3185).NFKD.list ~~ (0x1158,), '3185 -> 1158';
ok Uni.new(0x3186).NFKD.list ~~ (0x1159,), '3186 -> 1159';
ok Uni.new(0x3187).NFKD.list ~~ (0x1184,), '3187 -> 1184';
ok Uni.new(0x3188).NFKD.list ~~ (0x1185,), '3188 -> 1185';
ok Uni.new(0x3189).NFKD.list ~~ (0x1188,), '3189 -> 1188';
ok Uni.new(0x318A).NFKD.list ~~ (0x1191,), '318A -> 1191';
ok Uni.new(0x318B).NFKD.list ~~ (0x1192,), '318B -> 1192';
ok Uni.new(0x318C).NFKD.list ~~ (0x1194,), '318C -> 1194';
ok Uni.new(0x318D).NFKD.list ~~ (0x119E,), '318D -> 119E';
ok Uni.new(0x318E).NFKD.list ~~ (0x11A1,), '318E -> 11A1';
ok Uni.new(0x3192).NFKD.list ~~ (0x4E00,), '3192 -> 4E00';
ok Uni.new(0x3193).NFKD.list ~~ (0x4E8C,), '3193 -> 4E8C';
ok Uni.new(0x3194).NFKD.list ~~ (0x4E09,), '3194 -> 4E09';
ok Uni.new(0x3195).NFKD.list ~~ (0x56DB,), '3195 -> 56DB';
ok Uni.new(0x3196).NFKD.list ~~ (0x4E0A,), '3196 -> 4E0A';
ok Uni.new(0x3197).NFKD.list ~~ (0x4E2D,), '3197 -> 4E2D';
ok Uni.new(0x3198).NFKD.list ~~ (0x4E0B,), '3198 -> 4E0B';
ok Uni.new(0x3199).NFKD.list ~~ (0x7532,), '3199 -> 7532';
ok Uni.new(0x319A).NFKD.list ~~ (0x4E59,), '319A -> 4E59';
ok Uni.new(0x319B).NFKD.list ~~ (0x4E19,), '319B -> 4E19';
ok Uni.new(0x319C).NFKD.list ~~ (0x4E01,), '319C -> 4E01';
ok Uni.new(0x319D).NFKD.list ~~ (0x5929,), '319D -> 5929';
ok Uni.new(0x319E).NFKD.list ~~ (0x5730,), '319E -> 5730';
ok Uni.new(0x319F).NFKD.list ~~ (0x4EBA,), '319F -> 4EBA';
ok Uni.new(0x3200).NFKD.list ~~ (0x0028, 0x1100, 0x0029,), '3200 -> 0028 1100 0029';
ok Uni.new(0x3201).NFKD.list ~~ (0x0028, 0x1102, 0x0029,), '3201 -> 0028 1102 0029';
ok Uni.new(0x3202).NFKD.list ~~ (0x0028, 0x1103, 0x0029,), '3202 -> 0028 1103 0029';
ok Uni.new(0x3203).NFKD.list ~~ (0x0028, 0x1105, 0x0029,), '3203 -> 0028 1105 0029';
ok Uni.new(0x3204).NFKD.list ~~ (0x0028, 0x1106, 0x0029,), '3204 -> 0028 1106 0029';
ok Uni.new(0x3205).NFKD.list ~~ (0x0028, 0x1107, 0x0029,), '3205 -> 0028 1107 0029';
ok Uni.new(0x3206).NFKD.list ~~ (0x0028, 0x1109, 0x0029,), '3206 -> 0028 1109 0029';
ok Uni.new(0x3207).NFKD.list ~~ (0x0028, 0x110B, 0x0029,), '3207 -> 0028 110B 0029';
ok Uni.new(0x3208).NFKD.list ~~ (0x0028, 0x110C, 0x0029,), '3208 -> 0028 110C 0029';
ok Uni.new(0x3209).NFKD.list ~~ (0x0028, 0x110E, 0x0029,), '3209 -> 0028 110E 0029';
ok Uni.new(0x320A).NFKD.list ~~ (0x0028, 0x110F, 0x0029,), '320A -> 0028 110F 0029';
ok Uni.new(0x320B).NFKD.list ~~ (0x0028, 0x1110, 0x0029,), '320B -> 0028 1110 0029';
ok Uni.new(0x320C).NFKD.list ~~ (0x0028, 0x1111, 0x0029,), '320C -> 0028 1111 0029';
ok Uni.new(0x320D).NFKD.list ~~ (0x0028, 0x1112, 0x0029,), '320D -> 0028 1112 0029';
ok Uni.new(0x320E).NFKD.list ~~ (0x0028, 0x1100, 0x1161, 0x0029,), '320E -> 0028 1100 1161 0029';
ok Uni.new(0x320F).NFKD.list ~~ (0x0028, 0x1102, 0x1161, 0x0029,), '320F -> 0028 1102 1161 0029';
ok Uni.new(0x3210).NFKD.list ~~ (0x0028, 0x1103, 0x1161, 0x0029,), '3210 -> 0028 1103 1161 0029';
ok Uni.new(0x3211).NFKD.list ~~ (0x0028, 0x1105, 0x1161, 0x0029,), '3211 -> 0028 1105 1161 0029';
ok Uni.new(0x3212).NFKD.list ~~ (0x0028, 0x1106, 0x1161, 0x0029,), '3212 -> 0028 1106 1161 0029';
ok Uni.new(0x3213).NFKD.list ~~ (0x0028, 0x1107, 0x1161, 0x0029,), '3213 -> 0028 1107 1161 0029';
ok Uni.new(0x3214).NFKD.list ~~ (0x0028, 0x1109, 0x1161, 0x0029,), '3214 -> 0028 1109 1161 0029';
ok Uni.new(0x3215).NFKD.list ~~ (0x0028, 0x110B, 0x1161, 0x0029,), '3215 -> 0028 110B 1161 0029';
ok Uni.new(0x3216).NFKD.list ~~ (0x0028, 0x110C, 0x1161, 0x0029,), '3216 -> 0028 110C 1161 0029';
ok Uni.new(0x3217).NFKD.list ~~ (0x0028, 0x110E, 0x1161, 0x0029,), '3217 -> 0028 110E 1161 0029';
ok Uni.new(0x3218).NFKD.list ~~ (0x0028, 0x110F, 0x1161, 0x0029,), '3218 -> 0028 110F 1161 0029';
ok Uni.new(0x3219).NFKD.list ~~ (0x0028, 0x1110, 0x1161, 0x0029,), '3219 -> 0028 1110 1161 0029';
ok Uni.new(0x321A).NFKD.list ~~ (0x0028, 0x1111, 0x1161, 0x0029,), '321A -> 0028 1111 1161 0029';
ok Uni.new(0x321B).NFKD.list ~~ (0x0028, 0x1112, 0x1161, 0x0029,), '321B -> 0028 1112 1161 0029';
ok Uni.new(0x321C).NFKD.list ~~ (0x0028, 0x110C, 0x116E, 0x0029,), '321C -> 0028 110C 116E 0029';
ok Uni.new(0x321D).NFKD.list ~~ (0x0028, 0x110B, 0x1169, 0x110C, 0x1165, 0x11AB, 0x0029,), '321D -> 0028 110B 1169 110C 1165 11AB 0029';
ok Uni.new(0x321E).NFKD.list ~~ (0x0028, 0x110B, 0x1169, 0x1112, 0x116E, 0x0029,), '321E -> 0028 110B 1169 1112 116E 0029';
ok Uni.new(0x3220).NFKD.list ~~ (0x0028, 0x4E00, 0x0029,), '3220 -> 0028 4E00 0029';
ok Uni.new(0x3221).NFKD.list ~~ (0x0028, 0x4E8C, 0x0029,), '3221 -> 0028 4E8C 0029';
ok Uni.new(0x3222).NFKD.list ~~ (0x0028, 0x4E09, 0x0029,), '3222 -> 0028 4E09 0029';
ok Uni.new(0x3223).NFKD.list ~~ (0x0028, 0x56DB, 0x0029,), '3223 -> 0028 56DB 0029';
ok Uni.new(0x3224).NFKD.list ~~ (0x0028, 0x4E94, 0x0029,), '3224 -> 0028 4E94 0029';
ok Uni.new(0x3225).NFKD.list ~~ (0x0028, 0x516D, 0x0029,), '3225 -> 0028 516D 0029';
ok Uni.new(0x3226).NFKD.list ~~ (0x0028, 0x4E03, 0x0029,), '3226 -> 0028 4E03 0029';
ok Uni.new(0x3227).NFKD.list ~~ (0x0028, 0x516B, 0x0029,), '3227 -> 0028 516B 0029';
ok Uni.new(0x3228).NFKD.list ~~ (0x0028, 0x4E5D, 0x0029,), '3228 -> 0028 4E5D 0029';
ok Uni.new(0x3229).NFKD.list ~~ (0x0028, 0x5341, 0x0029,), '3229 -> 0028 5341 0029';
ok Uni.new(0x322A).NFKD.list ~~ (0x0028, 0x6708, 0x0029,), '322A -> 0028 6708 0029';
ok Uni.new(0x322B).NFKD.list ~~ (0x0028, 0x706B, 0x0029,), '322B -> 0028 706B 0029';
ok Uni.new(0x322C).NFKD.list ~~ (0x0028, 0x6C34, 0x0029,), '322C -> 0028 6C34 0029';
ok Uni.new(0x322D).NFKD.list ~~ (0x0028, 0x6728, 0x0029,), '322D -> 0028 6728 0029';
ok Uni.new(0x322E).NFKD.list ~~ (0x0028, 0x91D1, 0x0029,), '322E -> 0028 91D1 0029';
ok Uni.new(0x322F).NFKD.list ~~ (0x0028, 0x571F, 0x0029,), '322F -> 0028 571F 0029';
ok Uni.new(0x3230).NFKD.list ~~ (0x0028, 0x65E5, 0x0029,), '3230 -> 0028 65E5 0029';
ok Uni.new(0x3231).NFKD.list ~~ (0x0028, 0x682A, 0x0029,), '3231 -> 0028 682A 0029';
ok Uni.new(0x3232).NFKD.list ~~ (0x0028, 0x6709, 0x0029,), '3232 -> 0028 6709 0029';
ok Uni.new(0x3233).NFKD.list ~~ (0x0028, 0x793E, 0x0029,), '3233 -> 0028 793E 0029';
ok Uni.new(0x3234).NFKD.list ~~ (0x0028, 0x540D, 0x0029,), '3234 -> 0028 540D 0029';
ok Uni.new(0x3235).NFKD.list ~~ (0x0028, 0x7279, 0x0029,), '3235 -> 0028 7279 0029';
ok Uni.new(0x3236).NFKD.list ~~ (0x0028, 0x8CA1, 0x0029,), '3236 -> 0028 8CA1 0029';
ok Uni.new(0x3237).NFKD.list ~~ (0x0028, 0x795D, 0x0029,), '3237 -> 0028 795D 0029';
ok Uni.new(0x3238).NFKD.list ~~ (0x0028, 0x52B4, 0x0029,), '3238 -> 0028 52B4 0029';
ok Uni.new(0x3239).NFKD.list ~~ (0x0028, 0x4EE3, 0x0029,), '3239 -> 0028 4EE3 0029';
ok Uni.new(0x323A).NFKD.list ~~ (0x0028, 0x547C, 0x0029,), '323A -> 0028 547C 0029';
ok Uni.new(0x323B).NFKD.list ~~ (0x0028, 0x5B66, 0x0029,), '323B -> 0028 5B66 0029';
ok Uni.new(0x323C).NFKD.list ~~ (0x0028, 0x76E3, 0x0029,), '323C -> 0028 76E3 0029';
ok Uni.new(0x323D).NFKD.list ~~ (0x0028, 0x4F01, 0x0029,), '323D -> 0028 4F01 0029';
ok Uni.new(0x323E).NFKD.list ~~ (0x0028, 0x8CC7, 0x0029,), '323E -> 0028 8CC7 0029';
ok Uni.new(0x323F).NFKD.list ~~ (0x0028, 0x5354, 0x0029,), '323F -> 0028 5354 0029';
ok Uni.new(0x3240).NFKD.list ~~ (0x0028, 0x796D, 0x0029,), '3240 -> 0028 796D 0029';
ok Uni.new(0x3241).NFKD.list ~~ (0x0028, 0x4F11, 0x0029,), '3241 -> 0028 4F11 0029';
ok Uni.new(0x3242).NFKD.list ~~ (0x0028, 0x81EA, 0x0029,), '3242 -> 0028 81EA 0029';
ok Uni.new(0x3243).NFKD.list ~~ (0x0028, 0x81F3, 0x0029,), '3243 -> 0028 81F3 0029';
ok Uni.new(0x3244).NFKD.list ~~ (0x554F,), '3244 -> 554F';
ok Uni.new(0x3245).NFKD.list ~~ (0x5E7C,), '3245 -> 5E7C';
ok Uni.new(0x3246).NFKD.list ~~ (0x6587,), '3246 -> 6587';
ok Uni.new(0x3247).NFKD.list ~~ (0x7B8F,), '3247 -> 7B8F';
ok Uni.new(0x3250).NFKD.list ~~ (0x0050, 0x0054, 0x0045,), '3250 -> 0050 0054 0045';
ok Uni.new(0x3251).NFKD.list ~~ (0x0032, 0x0031,), '3251 -> 0032 0031';
ok Uni.new(0x3252).NFKD.list ~~ (0x0032, 0x0032,), '3252 -> 0032 0032';
ok Uni.new(0x3253).NFKD.list ~~ (0x0032, 0x0033,), '3253 -> 0032 0033';
ok Uni.new(0x3254).NFKD.list ~~ (0x0032, 0x0034,), '3254 -> 0032 0034';
ok Uni.new(0x3255).NFKD.list ~~ (0x0032, 0x0035,), '3255 -> 0032 0035';
ok Uni.new(0x3256).NFKD.list ~~ (0x0032, 0x0036,), '3256 -> 0032 0036';
ok Uni.new(0x3257).NFKD.list ~~ (0x0032, 0x0037,), '3257 -> 0032 0037';
ok Uni.new(0x3258).NFKD.list ~~ (0x0032, 0x0038,), '3258 -> 0032 0038';
ok Uni.new(0x3259).NFKD.list ~~ (0x0032, 0x0039,), '3259 -> 0032 0039';
ok Uni.new(0x325A).NFKD.list ~~ (0x0033, 0x0030,), '325A -> 0033 0030';
ok Uni.new(0x325B).NFKD.list ~~ (0x0033, 0x0031,), '325B -> 0033 0031';
ok Uni.new(0x325C).NFKD.list ~~ (0x0033, 0x0032,), '325C -> 0033 0032';
ok Uni.new(0x325D).NFKD.list ~~ (0x0033, 0x0033,), '325D -> 0033 0033';
ok Uni.new(0x325E).NFKD.list ~~ (0x0033, 0x0034,), '325E -> 0033 0034';
ok Uni.new(0x325F).NFKD.list ~~ (0x0033, 0x0035,), '325F -> 0033 0035';
ok Uni.new(0x3260).NFKD.list ~~ (0x1100,), '3260 -> 1100';
ok Uni.new(0x3261).NFKD.list ~~ (0x1102,), '3261 -> 1102';
ok Uni.new(0x3262).NFKD.list ~~ (0x1103,), '3262 -> 1103';
ok Uni.new(0x3263).NFKD.list ~~ (0x1105,), '3263 -> 1105';
ok Uni.new(0x3264).NFKD.list ~~ (0x1106,), '3264 -> 1106';
ok Uni.new(0x3265).NFKD.list ~~ (0x1107,), '3265 -> 1107';
ok Uni.new(0x3266).NFKD.list ~~ (0x1109,), '3266 -> 1109';
ok Uni.new(0x3267).NFKD.list ~~ (0x110B,), '3267 -> 110B';
ok Uni.new(0x3268).NFKD.list ~~ (0x110C,), '3268 -> 110C';
ok Uni.new(0x3269).NFKD.list ~~ (0x110E,), '3269 -> 110E';
ok Uni.new(0x326A).NFKD.list ~~ (0x110F,), '326A -> 110F';
ok Uni.new(0x326B).NFKD.list ~~ (0x1110,), '326B -> 1110';
ok Uni.new(0x326C).NFKD.list ~~ (0x1111,), '326C -> 1111';
ok Uni.new(0x326D).NFKD.list ~~ (0x1112,), '326D -> 1112';
ok Uni.new(0x326E).NFKD.list ~~ (0x1100, 0x1161,), '326E -> 1100 1161';
ok Uni.new(0x326F).NFKD.list ~~ (0x1102, 0x1161,), '326F -> 1102 1161';
ok Uni.new(0x3270).NFKD.list ~~ (0x1103, 0x1161,), '3270 -> 1103 1161';
ok Uni.new(0x3271).NFKD.list ~~ (0x1105, 0x1161,), '3271 -> 1105 1161';
ok Uni.new(0x3272).NFKD.list ~~ (0x1106, 0x1161,), '3272 -> 1106 1161';
ok Uni.new(0x3273).NFKD.list ~~ (0x1107, 0x1161,), '3273 -> 1107 1161';
ok Uni.new(0x3274).NFKD.list ~~ (0x1109, 0x1161,), '3274 -> 1109 1161';
ok Uni.new(0x3275).NFKD.list ~~ (0x110B, 0x1161,), '3275 -> 110B 1161';
ok Uni.new(0x3276).NFKD.list ~~ (0x110C, 0x1161,), '3276 -> 110C 1161';
ok Uni.new(0x3277).NFKD.list ~~ (0x110E, 0x1161,), '3277 -> 110E 1161';
ok Uni.new(0x3278).NFKD.list ~~ (0x110F, 0x1161,), '3278 -> 110F 1161';
ok Uni.new(0x3279).NFKD.list ~~ (0x1110, 0x1161,), '3279 -> 1110 1161';
ok Uni.new(0x327A).NFKD.list ~~ (0x1111, 0x1161,), '327A -> 1111 1161';
ok Uni.new(0x327B).NFKD.list ~~ (0x1112, 0x1161,), '327B -> 1112 1161';
ok Uni.new(0x327C).NFKD.list ~~ (0x110E, 0x1161, 0x11B7, 0x1100, 0x1169,), '327C -> 110E 1161 11B7 1100 1169';
ok Uni.new(0x327D).NFKD.list ~~ (0x110C, 0x116E, 0x110B, 0x1174,), '327D -> 110C 116E 110B 1174';
ok Uni.new(0x327E).NFKD.list ~~ (0x110B, 0x116E,), '327E -> 110B 116E';
ok Uni.new(0x3280).NFKD.list ~~ (0x4E00,), '3280 -> 4E00';
ok Uni.new(0x3281).NFKD.list ~~ (0x4E8C,), '3281 -> 4E8C';
ok Uni.new(0x3282).NFKD.list ~~ (0x4E09,), '3282 -> 4E09';
ok Uni.new(0x3283).NFKD.list ~~ (0x56DB,), '3283 -> 56DB';
ok Uni.new(0x3284).NFKD.list ~~ (0x4E94,), '3284 -> 4E94';
ok Uni.new(0x3285).NFKD.list ~~ (0x516D,), '3285 -> 516D';
ok Uni.new(0x3286).NFKD.list ~~ (0x4E03,), '3286 -> 4E03';
ok Uni.new(0x3287).NFKD.list ~~ (0x516B,), '3287 -> 516B';
ok Uni.new(0x3288).NFKD.list ~~ (0x4E5D,), '3288 -> 4E5D';
ok Uni.new(0x3289).NFKD.list ~~ (0x5341,), '3289 -> 5341';
ok Uni.new(0x328A).NFKD.list ~~ (0x6708,), '328A -> 6708';
ok Uni.new(0x328B).NFKD.list ~~ (0x706B,), '328B -> 706B';
ok Uni.new(0x328C).NFKD.list ~~ (0x6C34,), '328C -> 6C34';
ok Uni.new(0x328D).NFKD.list ~~ (0x6728,), '328D -> 6728';
ok Uni.new(0x328E).NFKD.list ~~ (0x91D1,), '328E -> 91D1';
ok Uni.new(0x328F).NFKD.list ~~ (0x571F,), '328F -> 571F';
ok Uni.new(0x3290).NFKD.list ~~ (0x65E5,), '3290 -> 65E5';
ok Uni.new(0x3291).NFKD.list ~~ (0x682A,), '3291 -> 682A';
ok Uni.new(0x3292).NFKD.list ~~ (0x6709,), '3292 -> 6709';
ok Uni.new(0x3293).NFKD.list ~~ (0x793E,), '3293 -> 793E';
ok Uni.new(0x3294).NFKD.list ~~ (0x540D,), '3294 -> 540D';
ok Uni.new(0x3295).NFKD.list ~~ (0x7279,), '3295 -> 7279';
ok Uni.new(0x3296).NFKD.list ~~ (0x8CA1,), '3296 -> 8CA1';
ok Uni.new(0x3297).NFKD.list ~~ (0x795D,), '3297 -> 795D';
ok Uni.new(0x3298).NFKD.list ~~ (0x52B4,), '3298 -> 52B4';
