#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
TOP_SRCDIR=${TOP_SRCDIR-"../../../rheolef"}
SRCDIR=${SRCDIR-"$TOP_SRCDIR/main/tst"}
GEODIR=$SRCDIR
NPROC_MAX=${NPROC_MAX-"2"}
. "${TOP_SRCDIR}/config/loop_mpirun.sh"

status=0
#echo "    not yet (skiped)"
#exit $status

L2D="
$SRCDIR/carre-bamg-v2
$SRCDIR/carre-tq-10-bdry-v2
"
L="
$GEODIR/line-1-bdry
$GEODIR/line-2-bdry
$GEODIR/line-3-bdry
$GEODIR/line-20-bdry
$L2D
$SRCDIR/cube-5-bdry-v2
$GEODIR/cube-P-5-dom-v2
$GEODIR/my_cube_PH-5-v2
$GEODIR/my_cube_TP-5-v2
$GEODIR/my_cube_TPH-5-v2
"

tol="1e-5"

# -------------------------------------
# cartesian case
# -------------------------------------
for fullgeo in $L; do
 geo=`basename $fullgeo`
 dir=`dirname $fullgeo`
 for Pk in P1 P2 P3; do
   loop_mpirun "./form_vf_expr_tst $fullgeo $Pk $tol 2>/dev/null >/dev/null"
   if test $? -ne 0; then status=1; fi
 done
done
# -------------------------------------
# axi case
# -------------------------------------
for fullgeo in $L2D; do
 geo=`basename $fullgeo`
 dir=`dirname $fullgeo`
 for Pk in P1 P2 P3; do
  for sys_coord in rz zr; do
   loop_mpirun "./form_vf_expr_tst $fullgeo $Pk $tol $sys_coord 2>/dev/null >/dev/null"
   if test $? -ne 0; then status=1; fi
  done
 done
done

exit $status
