/*
*  Rubrica
*  file: form_phone.h
*
*  
*  Copyright (C) 2000-2005 Nicola Fragale <nicolafragale@libero.it>
*
*  This program is free software; you can redistribute it and/or modify
*  it under the terms of the GNU General Public License as published by
*  the Free Software Foundation; either version 2 of the License, or
*  (at your option) any later version.
*
*  This program is distributed in the hope that it will be useful,
*  but WITHOUT ANY WARRANTY; without even the implied warranty of
*  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*  GNU General Public License for more details.
*
*  You should have received a copy of the GNU General Public License
*  along with this program; if not, write to the Free Software
*  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/


#ifndef _RUBRICA_FORM_PHONE_H
#define _RUBRICA_FORM_PHONE_H

#include <glib.h>
#include <glib-object.h>
#include <glade/glade.h>

#include "app.h"
#include "form.h"


#define RUBRICA_FORM_PHONE_TYPE           (rubrica_form_phone_get_type())

#define RUBRICA_FORM_PHONE(obj)           (G_TYPE_CHECK_INSTANCE_CAST((obj), \
                                           RUBRICA_FORM_PHONE_TYPE,          \
                                           RubricaFormPhone))

#define RUBRICA_FORM_PHONE_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST((klass),  \
                                           RUBRICA_FORM_PHONE_TYPE,          \
                                           RubricaFormPhoneClass))

#define IS_RUBRICA_FORM_PHONE(obj)        (G_TYPE_CHECK_INSTANCE_TYPE((obj), \
                                           RUBRICA_FORM_PHONE_TYPE))

#define IS_RUBRICA_FORM_PHONE_CLASS(kls)  (G_TYPE_CHECK_CLASS_TYPE((kls),    \
                                           RUBRICA_FORM_PHONE_TYPE))

#define RUBRICA_FORM_PHONE_GET_CLASS(kls) (G_TYPE_INSTANCE_GET_CLASS((kls),  \
			                   RUBRICA_FORM_PHONE_TYPE,          \
                                           RubricaFormPhoneClass))



typedef struct _RubricaFormPhone        RubricaFormPhone; 
typedef struct _RubricaFormPhoneClass   RubricaFormPhoneClass;
typedef struct _RubricaFormPhonePrivate RubricaFormPhonePrivate;



struct _RubricaFormPhone {
  RubricaForm parent;
   
  RubricaFormPhonePrivate* private;  
};



struct _RubricaFormPhoneClass {
   RubricaFormClass parent;
};


typedef enum {
  FORM_PHONE_PERSONAL,
  FORM_PHONE_COMPANY
} FormPhoneType;


GType             rubrica_form_phone_get_type (void);


RubricaFormPhone* rubrica_form_phone_new  (RubricaApp* app, GladeXML *gui,
					   FormPhoneType type);
void              rubrica_form_phone_free (RubricaFormPhone* form);

#endif
