// Copyright 2014 The Rust Project Developers. See the COPYRIGHT
// file at the top-level directory of this distribution and at
// http://rust-lang.org/COPYRIGHT.
//
// Licensed under the Apache License, Version 2.0 <LICENSE-APACHE or
// http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your
// option. This file may not be copied, modified, or distributed
// except according to those terms.

// run-pass
// Test equality constraints on associated types inside of an object type

// pretty-expanded FIXME #23616

pub trait Foo {
    type A;
    fn boo(&self) -> <Self as Foo>::A;
}

pub struct Bar;

impl Foo for char {
    type A = Bar;
    fn boo(&self) -> Bar { Bar }
}

fn baz(x: &Foo<A=Bar>) -> Bar {
    x.boo()
}

pub fn main() {
    let a = 'a';
    baz(&a);
}
