#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-04-06
# _preinstall-debian.sh

### P A R A M S

package="$1"

### I N C L U D E

. ./_include.sh

### H E L P E R S

function debdeps()
{
	dpkg --info $1 | grep 'Depends:' | sed 's/Depends://' | sed 's/([^)]*)//g' | sed 's/, / /g'
}

### S T A R T

echo "+DEBIAN PACKAGES"
packages=`debdeps "${package}"`
for p in ${packages}; do
	echo -n "${p}"
	if ! ${PACKAGETEST} ${p} > /dev/null 2> /dev/null; then
		echo
		${PACKAGEINSTALL} -y ${p}
	else
		echo " OK"
	fi
done
echo '+end of debian preinstall'
