/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : NC_read.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2001/05/31
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <math.h>
#include "intl.h"

#include "types.h"
#include "List_cad.h"
#include "List_cam.h"
#include "List_Undo.h"
#include "global.h"
#include "culcfunc.h"
#include "Select.h"
#include "Draw.h"
#include "MsgBox.h"
#include "sagcad.h"
#include "etc.h"
#include "Command.h"

#define _NC_READ_
#include "NC_read.h"



/* -------------------------------------------------------------------
 * データ読み込み
 *	
 */
int NcFileRead(void)
{
	FILE *stream;
	char FileName[256], DumyStr[256], path[256];
	int i;
	struct RtnDat PPCH;
	int Xido, Yido;
	struct RtnDat LA1, LA2, LA3, LA4;


	/* NC FILE Default */
	if (strstr(sagcad_user.NcPath, "CADPATH") != NULL) strcpy(path, sagcad_user.CadPath);
	else strcpy(path, sagcad_user.NcPath);
	sprintf(FileName, "%s/NoName.nc", path);

	/* NC FILE Select */
	read_file_name_get(FileName);
	if (FileName == NULL) {
		return 0;
	}


	/* 初期化 */
	for( i = 0 ; i < NC_MAX ; i++ ) {
		NcCode[i][0] = '\0';
		nc[i].Mode = 90;
		nc[i].Gcode = 0;
		nc[i].X = 0;
		nc[i].Y = 0;
		nc[i].CX = 0;
		nc[i].CY = 0;
		nc[i].R = 0;
		nc[i].I = 0;
		nc[i].J = 0;
		nc[i].Move = 0;
	}
	nc[0].Mode = 90;
	nc[0].Gcode = 0;
	nc[0].X = 0;
	nc[0].Y = 0;
	nc[0].CX = 0;
	nc[0].CY = 0;
	nc[0].R = 0;
	nc[0].I = 0;
	nc[0].J = 0;
	nc[0].Move = 0;



	/* ファイルをオープン */ 
	if ((stream  = fopen(FileName, "r")) == NULL) {
		g_print( _("The file could not be opened. [%s]\n"),FileName);
		return 0;
	}


	/* NcCode を 1 から入れる */
	i=1;
	while (fgets(NcCode[i], 256, stream) != NULL) {
		i++;
	}
	fclose(stream);
	NcData = i;


	for (i = 1 ; i <= NcData ; i++) {
		/* 注釈の削除 */
		atension_cut(NcCode[i]);

		/* ABS or INC 取り込み */
		if (strstr(NcCode[i], "G90") != NULL) nc[i].Mode = 90;
		else if (strstr(NcCode[i], "G91") != NULL) nc[i].Mode = 91;
		else nc[i].Mode = nc[i-1].Mode;

		/* --- < 移動指令取り込み */
		if (strstr(NcCode[i], "G03") != NULL) nc[i].Gcode = 3;
		else if (strstr(NcCode[i], "G02") != NULL) nc[i].Gcode = 2;
		else if (strstr(NcCode[i], "G01") != NULL) nc[i].Gcode = 1;
		else if (strstr(NcCode[i], "G00") != NULL) nc[i].Gcode = 0;
		else nc[i].Gcode = nc[i-1].Gcode;


		/* X 値取り込み */
		sprintf(DumyStr, "X");
		if (ValueData(NcCode[i], DumyStr) == 0) {
			Xido = 0;
			nc[i].X = nc[i-1].X;
		}
		else {
			Xido = 1;
			nc[i].X = atof(DumyStr);
			if ( nc[i].Mode == 91) {
				if ( nc[i].X != 0) nc[i].X = sg(nc[i].X + sg(nc[i-1].X, 3), 3);
				else nc[i].X = nc[i-1].X;
			}
			if (sg(nc[i-1].X, 3) == sg(nc[i].X, 3)) Xido = 0;
		}


		/* < Y 値取り込み > */
		sprintf(DumyStr, "Y");
		if (ValueData(NcCode[i], DumyStr) == 0) {
			Yido = 0;
			nc[i].Y = nc[i-1].Y;
		}
		else {
			Yido = 1;
			nc[i].Y = atof(DumyStr);
			if ( nc[i].Mode == 91) {
				if ( nc[i].Y != 0) nc[i].Y = sg(nc[i].Y + sg(nc[i-1].Y, 3), 3);
				else nc[i].Y = nc[i-1].Y;
			}
			if (sg(nc[i-1].Y, 3) == sg(nc[i].Y, 3)) Yido = 0;
		}


		/* R 値取り込み */
		sprintf(DumyStr, "R");
		if (ValueData(NcCode[i], DumyStr) == 1) nc[i].R = atof(DumyStr);

		/* I 値取り込み */
		sprintf(DumyStr, "I");
		if (ValueData(NcCode[i], DumyStr) == 1) nc[i].I = atof(DumyStr);

		/* J 値取り込み */
		sprintf(DumyStr, "J");
		if (ValueData(NcCode[i], DumyStr) == 1) nc[i].J = atof(DumyStr);


		/* 移動判断 */
		if ( Xido == 0 && Yido == 0) {
			nc[i].Move = 0;
			if ( nc[i].I != 0 || nc[i].J != 0) {
				/* 移動なし */
				nc[i].X = nc[i-1].X;
				nc[i].Y = nc[i-1].Y;
				nc[i].Move = 1;
			}
		}
		else nc[i].Move = 1;


		/* 円弧の中心を計算 */
		if (nc[i].Gcode == 2 || nc[i].Gcode == 3) {
			/* I,J 入力のとき R と中心を計算 */
			if (nc[i].I != 0 || nc[i].J != 0) {
				nc[i].R = sg(sqrt(nc[i].J * nc[i].J + nc[i].I * nc[i].I), 6);
				nc[i].CX = sg(nc[i-1].X + sg(nc[i].I, 6), 6);
				nc[i].CY = sg(nc[i-1].Y + sg(nc[i].J, 6), 6);
			}
			/* R 入力のとき中心を計算 */
			else {
				if (nc[i].R != 0) {
					/* ------------------------------------------------
					 * PPC	２点を通る円
					 */
					PPCH.sx[1] = nc[i-1].X;
					PPCH.sy[1] = nc[i-1].Y;
					PPCH.sx[2] = nc[i].X;
					PPCH.sy[2] = nc[i].Y;
					PPCH.r[1] = nc[i].R;
					ppc(&PPCH);
					/* PPCH.cx[1],PPCH.cy[1] */
					/* PPCH.cx[2],PPCH.cy[2] */

					if (PPCH.type == 0) {
						MsgBox(_("NC Drawing"), _("Center of circle isn't found."), "Error" , NULL, NULL, "OK");
					}
					else if (PPCH.type == 1) {
						nc[i].CX = PPCH.cx[1];
						nc[i].CY = PPCH.cy[1];
					}
					else {
						/* IA が + なら G03   - なら G02 */
						/* 円候補1と円弧の始点の角度 */
						LA1.sx[1] = PPCH.cx[1];
						LA1.sy[1] = PPCH.cy[1];
						LA1.ex[1] = nc[i-1].X;
						LA1.ey[1] = nc[i-1].Y;
						la(&LA1);
						/* LA1.angle */
						
						/* 円候補1と円弧の終点の角度 */
						LA2.sx[1] = PPCH.cx[1];
						LA2.sy[1] = PPCH.cy[1];
						LA2.ex[1] = nc[i].X;
						LA2.ey[1] = nc[i].Y;
						la(&LA2);
						/* LA2.angle */
						
						/* 円候補2と円弧の始点の角度 */
						LA3.sx[1] = PPCH.cx[2];
						LA3.sy[1] = PPCH.cy[2];
						LA3.ex[1] = nc[i-1].X;
						LA3.ey[1] = nc[i-1].Y;
						la(&LA3);
						/* LA3.angle */
						
						/* 円候補2と円弧の終点の角度 */
						LA4.sx[1] = PPCH.cx[2];
						LA4.sy[1] = PPCH.cy[2];
						LA4.ex[1] = nc[i].X;
						LA4.ey[1] = nc[i].Y;
						la(&LA4);
						/* LA4.angle */


						/* G03 */
						if (nc[i].Gcode == 3) {
							if (sg(LA1.angle, 1) == 0 || sg(LA1.angle, 1) == 360) LA1.angle = 0.;
							if (sg(LA3.angle, 1) == 0 || sg(LA3.angle, 1) == 360) LA3.angle = 0.;
							if (sg(LA2.angle, 1) == 0 || sg(LA2.angle, 1) == 360) LA2.angle = 360.;
							if (sg(LA4.angle, 1) == 0 || sg(LA4.angle, 1) == 360) LA4.angle = 360.;
							if (LA1.angle < LA2.angle) {
								if (sg(LA2.angle - LA1.angle, 1) <= 180) {
									nc[i].CX = PPCH.cx[1];
									nc[i].CY = PPCH.cy[1];
								}
							}
							else if (LA2.angle < LA1.angle) {
								if (sg(LA1.angle + LA2.angle, 1) <= 180) {
									nc[i].CX = PPCH.cx[1];
									nc[i].CY = PPCH.cy[1];
								}
							}
							if (LA3.angle < LA4.angle) {
								if (sg(LA4.angle - LA3.angle, 1) <= 180) {
									nc[i].CX = PPCH.cx[2];
									nc[i].CY = PPCH.cy[2];
								}
							}
							else if (LA4.angle < LA3.angle) {
								if (sg(LA3.angle + LA4.angle, 1) <= 180) {
									nc[i].CX = PPCH.cx[2];
									nc[i].CY = PPCH.cy[2];
								}
							}
						}
						
						else if (nc[i].Gcode == 2) {
							if (sg(LA2.angle, 1) == 0 || sg(LA2.angle, 1) == 360) LA2.angle = 0.;
							if (sg(LA4.angle, 1) == 0 || sg(LA4.angle, 1) == 360) LA4.angle = 0.;
							if (sg(LA1.angle, 1) == 0 || sg(LA1.angle, 1) == 360) LA1.angle = 360.;
							if (sg(LA3.angle, 1) == 0 || sg(LA3.angle, 1) == 360) LA3.angle = 360.;
							if (LA2.angle < LA1.angle) {
								if (sg(LA1.angle - LA2.angle, 1) <= 180) {
									nc[i].CX = PPCH.cx[1];
									nc[i].CY = PPCH.cy[1];
								}
							}

							else if (LA1.angle < LA2.angle) {
								if (sg(LA2.angle + LA1.angle, 1) <= 180) {
									nc[i].CX = PPCH.cx[1];
									nc[i].CY = PPCH.cy[1];
								}
							}
							if (LA4.angle < LA3.angle) {
								if (sg(LA3.angle - LA4.angle, 1) <= 180) {
									nc[i].CX = PPCH.cx[2];
									nc[i].CY = PPCH.cy[2];
								}
							}

							else if (LA3.angle < LA4.angle) {
								if (sg(LA4.angle + LA3.angle, 1) <= 180) {
										nc[i].CX = PPCH.cx[2];
										nc[i].CY = PPCH.cy[2];
								}
							}
						} /* else if (nc[i].Gcode == 2) */
					}
				} /* if (nc[i].R != 0) */
			} /* else */
		} /* if (nc[i].Gcode == 2 || nc[i].Gcode == 3) */
	} /* for( i = 1 ; i <= NcData ; i++ ) */
	NcMakeDraw();
	return 1;
}





/* -------------------------------------------------------------------
 * データ作成＆描画
 *	
 */
int NcMakeDraw(void)
{
	int i;
	CAD cad;


	if (NcData <= 0) {
		return 0;
	}
	else {
		undo_index_plus();
	}

	for (i = 1 ; i <= NcData ; i++) {
		if (nc[i].Move == 1) {

			/* G00  */
			if (nc[i].Gcode == 0) {
				cad.code = 1;
				cad.layer = NowLayer;
				cad.style = 2;
				cad.color = (long)0x0000ffff;
				
				cad.sx = sg(nc[i-1].X, 6);
				cad.sy = sg(nc[i-1].Y, 6);
				cad.ex = sg(nc[i].X, 6);
				cad.ey = sg(nc[i].Y, 6);
				
				/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
				cad_list_add_first_with_undo(&cad, &cad_list_info);
				SelectCadDraw(drawing_area, &cad, SCD_ORG);
			}

			/* G01  */
			else if (nc[i].Gcode == 1) {
				cad.code = 1;
				cad.layer = NowLayer;
				cad.style = 1;
				cad.color = (long)0x00ffff00;
				
				cad.sx = sg(nc[i-1].X, 6);
				cad.sy = sg(nc[i-1].Y, 6);
				cad.ex = sg(nc[i].X, 6);
				cad.ey = sg(nc[i].Y, 6);
				
				/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
				cad_list_add_first_with_undo(&cad, &cad_list_info);
				CadDraw(drawing_area, &cad, SCD_ORG, UPDATE_OFF);
			}

			/* G02  */
			else if (nc[i].Gcode == 2) {
				if (sg(nc[i-1].X, 3) == sg(nc[i].X, 3) && sg(nc[i-1].Y, 3) == sg(nc[i].Y, 3)) {
					cad.code = 4;
					cad.layer = NowLayer;
					cad.style = 1;
					cad.color = (long)0x00ffff00;
					
					/* G02 の場合 始点と終点は逆 */
					cad.ex = sg(nc[i-1].X, 6);
					cad.ey = sg(nc[i-1].Y, 6);
					cad.sx = sg(nc[i].X, 6);
					cad.sy = sg(nc[i].Y, 6);
					
					cad.r = sg(nc[i].R, 6);
					cad.cx = sg(nc[i].CX, 6);
					cad.cy = sg(nc[i].CY, 6);
					
					/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
					cad_list_add_first_with_undo(&cad, &cad_list_info);
					SelectCadDraw(drawing_area, &cad, SCD_ORG);
				}
				else {
					cad.code = 2;
					cad.layer = NowLayer;
					cad.style = 1;
					cad.color = (long)0x00ffff00;
					
					/* G02 の場合 始点と終点は逆 */
					cad.ex = sg(nc[i-1].X, 6);
					cad.ey = sg(nc[i-1].Y, 6);
					cad.sx = sg(nc[i].X, 6);
					cad.sy = sg(nc[i].Y, 6);
					
					cad.r = sg(nc[i].R, 6);
					cad.cx = sg(nc[i].CX, 6);
					cad.cy = sg(nc[i].CY, 6);
					
					/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
					cad_list_add_first_with_undo(&cad, &cad_list_info);
					SelectCadDraw(drawing_area, &cad, SCD_ORG);
				}
			}

			/* G03  */
			else if (nc[i].Gcode == 3) {
				if (sg(nc[i-1].X, 3) == sg(nc[i].X, 3) && sg(nc[i-1].Y, 3) == sg(nc[i].Y, 3)) {
					cad.code = 4;
					cad.layer = NowLayer;
					cad.style = 1;
					cad.color = (long)0x00ffff00;
					
					/* G03 の場合 始点と終点はそのまま */
					cad.sx = sg(nc[i-1].X, 6);
					cad.sy = sg(nc[i-1].Y, 6);
					cad.ex = sg(nc[i].X, 6);
					cad.ey = sg(nc[i].Y, 6);
					
					cad.r = sg(nc[i].R, 6);
					cad.cx = sg(nc[i].CX, 6);
					cad.cy = sg(nc[i].CY, 6);
					
					/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
					cad_list_add_first_with_undo(&cad, &cad_list_info);
					SelectCadDraw(drawing_area, &cad, SCD_ORG);
				}
				else {
					cad.code = 2;
					cad.layer = NowLayer;
					cad.style = 1;
					cad.color = (long)0x00ffff00;
						
					/* G03 の場合 始点と終点はそのまま */
					cad.sx = sg(nc[i-1].X, 6);
					cad.sy = sg(nc[i-1].Y, 6);
					cad.ex = sg(nc[i].X, 6);
					cad.ey = sg(nc[i].Y, 6);
					
					cad.r = sg(nc[i].R, 6);
					cad.cx = sg(nc[i].CX, 6);
					cad.cy = sg(nc[i].CY, 6);
					/* CAD Data をリストの最初に追加して、 Undo Baffer に書込む */
					cad_list_add_first_with_undo(&cad, &cad_list_info);
					SelectCadDraw(drawing_area, &cad, SCD_ORG);
				}
			}
		}
	}
	return 1;
}





/* -------------------------------------------------------------------
 * 注釈をカット
 * 
 */
int atension_cut(char *str)
{
	int i, InsideAtension;
	char *dumy, DumyStr[256];

	dumy = str;
	i = 0;
	InsideAtension = 0;
	/* NC 注釈の削除 */
	while (*str != '\0') {
		/* 注釈の開始 「(」0x28 */
		if (*str == '(') 
			InsideAtension = 1;
		/* 注釈の終了 「)」0x29 */
		else if (*str == ')')
			InsideAtension = 0;
		/* NC を DumyStr に入れる */
		else if (InsideAtension == 0) {
			/* NC 文中の [space] と [tab] の 削除 */
			if (*str != ' ' && *str != '\t') {
				DumyStr[i] = *str;
				i++;
			}
		}
		str++;
	}
	DumyStr[i] = '\0';
	*dumy = '\0';
	strcpy(dumy, DumyStr);
	return 1;
}





/* -------------------------------------------------------------------
 * パラメータの数値を取得
 * 
 */
int ValueData(char *org, char *str)
{
	char RetX[256], *Point;
	int i;


	RetX[0] = '\0';
	Point = strstr(org, str);
	if (Point != NULL) {
		i=0;
		Point++;
		while (1) {
			if (*Point == '-') RetX[i] = *Point;
			else if ( *Point == '0') RetX[i] = *Point;
			else if ( *Point == '1') RetX[i] = *Point;
			else if ( *Point == '2') RetX[i] = *Point;
			else if ( *Point == '3') RetX[i] = *Point;
			else if ( *Point == '4') RetX[i] = *Point;
			else if ( *Point == '5') RetX[i] = *Point;
			else if ( *Point == '6') RetX[i] = *Point;
			else if ( *Point == '7') RetX[i] = *Point;
			else if ( *Point == '8') RetX[i] = *Point;
			else if ( *Point == '9') RetX[i] = *Point;
			else if ( *Point == '.') RetX[i] = *Point;
			else {
				i++;
				break;
			}
			Point++;
			i++;
		}
		RetX[i] = '\0';
		strcpy(str, RetX);
		return 1;
	}
	else {
		strcpy(str, "");
		return 0;
	}
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : NC_read.c
 * ====================================================================
 */
