/* Generated by GOB (v2.0.9) on Sat Aug 14 09:55:53 2004
   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */

#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 9

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "sand-window.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 11 "../gob/sand-window.gob"

#include "locate.h"
#include "../pixmaps/icon24.xbm"
#define _(A) A

#line 31 "sand-window.c"
/* self casting macros */
#define SELF(x) SAND_WINDOW(x)
#define SELF_CONST(x) SAND_WINDOW_CONST(x)
#define IS_SELF(x) SAND_IS_WINDOW(x)
#define TYPE_SELF SAND_TYPE_WINDOW
#define SELF_CLASS(x) SAND_WINDOW_CLASS(x)

#define SELF_GET_CLASS(x) SAND_WINDOW_GET_CLASS(x)

/* self typedefs */
typedef SandWindow Self;
typedef SandWindowClass SelfClass;

/* here are local prototypes */
static void ___object_set_property (GObject *object, guint property_id, const GValue *value, GParamSpec *pspec);
static void ___object_get_property (GObject *object, guint property_id, GValue *value, GParamSpec *pspec);
static void sand_window_class_init (SandWindowClass * c) G_GNUC_UNUSED;
static double sand_window_get_row_volume (SandWindow * self, int y) G_GNUC_UNUSED;
static void sand_window_set_row_alpha (SandWindow * self, int y, double q) G_GNUC_UNUSED;
static void sand_window_init_sand (SandWindow * self) G_GNUC_UNUSED;
static void sand_window_refill (SandWindow * self) G_GNUC_UNUSED;
static GdkPixbuf * sand_window_get_pixmap_themed (const char * name, const char * theme) G_GNUC_UNUSED;
static void sand_window_release_pixmaps (SandWindow * self) G_GNUC_UNUSED;
static void sand_window_load_pixmaps (SandWindow * self) G_GNUC_UNUSED;
static void sand_window_create_shape (SandWindow * self, int image_width, int image_height) G_GNUC_UNUSED;
static void sand_window_draw (SandWindow * self, GdkRectangle * area) G_GNUC_UNUSED;
static void sand_window_redraw (SandWindow * self) G_GNUC_UNUSED;
static gint ___b_sand_window_expose_event (GtkWidget * widget, GdkEventExpose * event) G_GNUC_UNUSED;
static void ___c_sand_window_size_request (GtkWidget * widget, GtkRequisition * requisition) G_GNUC_UNUSED;
static void sand_window_size_allocate_handler (GtkWidget * widget, GtkAllocation * allocation, gpointer data) G_GNUC_UNUSED;
static void sand_window_drop_handler (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * selection_data, guint info, guint time, gpointer data) G_GNUC_UNUSED;
static void ___f_sand_window_realize (GtkWidget * widget) G_GNUC_UNUSED;
static void sand_window_init (SandWindow * swindow) G_GNUC_UNUSED;
static void ___11_sand_window_destroy (GtkObject * object) G_GNUC_UNUSED;
static void sand_window_set_decorations (SandWindow * self) G_GNUC_UNUSED;

enum {
	PROP_0,
	PROP_THEME,
	PROP_DECORATIONS,
	PROP_RATIO,
	PROP_FLOW
};

/* pointer to the class of our parent */
static GtkWindowClass *parent_class = NULL;

/* Short form macros */
#define self_get_row_volume sand_window_get_row_volume
#define self_set_row_alpha sand_window_set_row_alpha
#define self_init_sand sand_window_init_sand
#define self_refill sand_window_refill
#define self_get_pixmap_themed sand_window_get_pixmap_themed
#define self_release_pixmaps sand_window_release_pixmaps
#define self_load_pixmaps sand_window_load_pixmaps
#define self_create_shape sand_window_create_shape
#define self_draw sand_window_draw
#define self_redraw sand_window_redraw
#define self_size_allocate_handler sand_window_size_allocate_handler
#define self_drop_handler sand_window_drop_handler
#define self_set_decorations sand_window_set_decorations
#define self_get_color sand_window_get_color
#define self_set_color sand_window_set_color
#define self_set_ratio sand_window_set_ratio
#define self_set_flow sand_window_set_flow
GType
sand_window_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (SandWindowClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) sand_window_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (SandWindow),
			0 /* n_preallocs */,
			(GInstanceInitFunc) sand_window_init,
			NULL
		};

		type = g_type_register_static (GTK_TYPE_WINDOW, "SandWindow", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((SandWindow *)g_object_new(sand_window_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static SandWindow * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static SandWindow *
GET_NEW_VARG (const char *first, ...)
{
	SandWindow *ret;
	va_list ap;
	va_start (ap, first);
	ret = (SandWindow *)g_object_new_valist (sand_window_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Sand:Window::finalize"
	SandWindow *self  G_GNUC_UNUSED = SAND_WINDOW (obj_self);
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
#line 19 "../gob/sand-window.gob"
	if(self->theme) { ((*(void (*)(void *))g_free)) (self->theme); self->theme = NULL; }
#line 149 "sand-window.c"
}
#undef __GOB_FUNCTION__

static void 
sand_window_class_init (SandWindowClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Sand:Window::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	GtkWidgetClass *gtk_widget_class = (GtkWidgetClass *)c;
	GtkObjectClass *gtk_object_class = (GtkObjectClass *)c;

	parent_class = g_type_class_ref (GTK_TYPE_WINDOW);

#line 313 "../gob/sand-window.gob"
	gtk_widget_class->expose_event = ___b_sand_window_expose_event;
#line 324 "../gob/sand-window.gob"
	gtk_widget_class->size_request = ___c_sand_window_size_request;
#line 374 "../gob/sand-window.gob"
	gtk_widget_class->realize = ___f_sand_window_realize;
#line 421 "../gob/sand-window.gob"
	gtk_object_class->destroy = ___11_sand_window_destroy;
#line 171 "sand-window.c"
	g_object_class->finalize = ___finalize;
	g_object_class->get_property = ___object_get_property;
	g_object_class->set_property = ___object_set_property;
    {
	GParamSpec   *param_spec;

	param_spec = g_param_spec_string
		("theme" /* name */,
		 _("theme name") /* nick */,
		 _("the timer's theme name, or NULL for the default theme") /* blurb */,
		 NULL /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (g_object_class,
		PROP_THEME,
		param_spec);
	param_spec = g_param_spec_boolean
		("decorations" /* name */,
		 _("decoration flag") /* nick */,
		 _("flag to control the display of window decorations") /* blurb */,
		 FALSE /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (g_object_class,
		PROP_DECORATIONS,
		param_spec);
	param_spec = g_param_spec_double
		("ratio" /* name */,
		 _("") /* nick */,
		 _("") /* blurb */,
		 0.0 /* minimum */,
		 1.0 /* maximum */,
		 1.0 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_RATIO,
		param_spec);
	param_spec = g_param_spec_double
		("flow" /* name */,
		 _("") /* nick */,
		 _("") /* blurb */,
		 0.0 /* minimum */,
		 1.0 /* maximum */,
		 0.3 /* default_value */,
		 (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (g_object_class,
		PROP_FLOW,
		param_spec);
    }
}
#undef __GOB_FUNCTION__
#line 401 "../gob/sand-window.gob"
static void 
sand_window_init (SandWindow * swindow G_GNUC_UNUSED)
#line 224 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::init"
#line 11 "../gob/sand-window.gob"
	swindow->theme = NULL;
#line 229 "sand-window.c"
 {
#line 401 "../gob/sand-window.gob"

    /* Set the window policy */
    gtk_window_set_resizable (GTK_WINDOW (swindow), FALSE);
    gtk_signal_connect (GTK_OBJECT (swindow), "size_allocate",
			(GtkSignalFunc) self_size_allocate_handler,
			NULL);

    swindow->back = NULL;
    swindow->front = NULL;
    swindow->sand = NULL;
    swindow->sandmask = NULL;
    
    swindow->r = 0;
    swindow->g = 0;
    swindow->b = 0;
    swindow->linevol = NULL;

    swindow->decorations = FALSE;
  
#line 251 "sand-window.c"
 }
}
#undef __GOB_FUNCTION__

static void
___object_set_property (GObject *object,
	guint property_id,
	const GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Sand:Window::set_property"
{
	SandWindow *self G_GNUC_UNUSED;

	self = SAND_WINDOW (object);

	switch (property_id) {
	case PROP_THEME:
		{
#line 25 "../gob/sand-window.gob"
 g_free(self->theme);
          self->theme = g_strdup (g_value_dup_string (VAL));
          self_load_pixmaps (self); 
#line 274 "sand-window.c"
		}
		break;
	case PROP_DECORATIONS:
		{
#line 35 "../gob/sand-window.gob"
 self->decorations = g_value_get_boolean(VAL);
          self_set_decorations (self); 
#line 282 "sand-window.c"
		}
		break;
	case PROP_RATIO:
		{
#line 47 "../gob/sand-window.gob"
 self_set_ratio (self, g_value_get_double(VAL)); 
#line 289 "sand-window.c"
		}
		break;
	case PROP_FLOW:
		{
#line 58 "../gob/sand-window.gob"
 self_set_flow (self, g_value_get_double(VAL)); 
#line 296 "sand-window.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__

static void
___object_get_property (GObject *object,
	guint property_id,
	GValue *VAL G_GNUC_UNUSED,
	GParamSpec *pspec G_GNUC_UNUSED)
#define __GOB_FUNCTION__ "Sand:Window::get_property"
{
	SandWindow *self G_GNUC_UNUSED;

	self = SAND_WINDOW (object);

	switch (property_id) {
	case PROP_THEME:
		{
#line 28 "../gob/sand-window.gob"
 g_value_set_string (VAL, self->theme); 
#line 327 "sand-window.c"
		}
		break;
	case PROP_DECORATIONS:
		{
#line 37 "../gob/sand-window.gob"
 g_value_set_boolean (VAL, self->decorations); 
#line 334 "sand-window.c"
		}
		break;
	case PROP_RATIO:
		{
#line 48 "../gob/sand-window.gob"
 g_value_set_double (VAL, self->ratio); 
#line 341 "sand-window.c"
		}
		break;
	case PROP_FLOW:
		{
#line 59 "../gob/sand-window.gob"
 g_value_set_double (VAL, self->flow); 
#line 348 "sand-window.c"
		}
		break;
	default:
/* Apparently in g++ this is needed, glib is b0rk */
#ifndef __PRETTY_FUNCTION__
#  undef G_STRLOC
#  define G_STRLOC	__FILE__ ":" G_STRINGIFY (__LINE__)
#endif
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}
#undef __GOB_FUNCTION__


#line 85 "../gob/sand-window.gob"
static double 
sand_window_get_row_volume (SandWindow * self, int y)
#line 367 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::get_row_volume"
#line 85 "../gob/sand-window.gob"
	g_return_val_if_fail (self != NULL, (double )0);
#line 85 "../gob/sand-window.gob"
	g_return_val_if_fail (SAND_IS_WINDOW (self), (double )0);
#line 374 "sand-window.c"
{
#line 88 "../gob/sand-window.gob"
	
    guchar *pixels = gdk_pixbuf_get_pixels (self->sandmask);
    int  rowstride = gdk_pixbuf_get_rowstride (self->sandmask);
    double  volume;
    int  x;

    volume = 0;
    for (x=0; x<self->width; ++x) {
      int yy = (y>=self->waist_y) ? y + 0.5*ABS(x-self->waist_x) : y;
      if (yy<gdk_pixbuf_get_height (self->sandmask)) {
	volume += pixels[4*x+yy*rowstride+3] / 255.0;
      }
    }
    return  volume;
  }}
#line 392 "sand-window.c"
#undef __GOB_FUNCTION__

#line 104 "../gob/sand-window.gob"
static void 
sand_window_set_row_alpha (SandWindow * self, int y, double q)
#line 398 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::set_row_alpha"
#line 104 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 104 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 405 "sand-window.c"
{
#line 107 "../gob/sand-window.gob"
	
    guchar *mask = gdk_pixbuf_get_pixels (self->sandmask);
    guchar *pixels = gdk_pixbuf_get_pixels (self->sand);
    int  rowstride = gdk_pixbuf_get_rowstride (self->sand);
    int x;

    for (x=0; x<self->width; ++x) {
      int yy = (y>=self->waist_y) ? y + 0.5*ABS(x-self->waist_x) : y;
      if (yy<gdk_pixbuf_get_height (self->sand)) {
	double qq = q;
	if  (y>=self->waist_y && x==self->waist_x && self->flow>qq)
	  qq = self->flow;
	pixels[4*x+yy*rowstride+3] = qq*mask[4*x+yy*rowstride+3] + 0.5;
      }
    }
  }}
#line 424 "sand-window.c"
#undef __GOB_FUNCTION__

#line 124 "../gob/sand-window.gob"
static void 
sand_window_init_sand (SandWindow * self)
#line 430 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::init_sand"
#line 124 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 124 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 437 "sand-window.c"
{
#line 128 "../gob/sand-window.gob"
	
    double  A=0, B=0;
    int  j;

    self->waist_x = self->width/2;
    self->waist_y = self->height/2;

    for (j=0; j<self->waist_y; ++j) {
      self->linevol[j] = self_get_row_volume (self, j);
      A += self->linevol[j];
    }
    for (j=self->waist_y; j<self->height; ++j) {
      self->linevol[j] = self_get_row_volume (self, j);
      B += self->linevol[j];
    }

    self->A = A;
    self->B = B;
    self->volume = 0.9*MIN(A,B);
  }}
#line 460 "sand-window.c"
#undef __GOB_FUNCTION__

#line 149 "../gob/sand-window.gob"
static void 
sand_window_refill (SandWindow * self)
#line 466 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::refill"
#line 149 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 149 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 473 "sand-window.c"
{
#line 151 "../gob/sand-window.gob"
	
    double  q = self->ratio;
    double  a, empty;
    int  j;

    if (! self->back)  return;
    
    /* upper chamber */
    a = 0;
    empty = self->A-(1-q)*self->volume;
    for (j=0; j<self->waist_y; ++j) {
      if (a >= empty) {		/* row is completely filled */
	self_set_row_alpha (self, j, 1);
      } else {
	a += self->linevol[j];
	if (a >= empty) {	/* row is partially filled */
	  double  x = (a - empty) / self->linevol[j];
	  self_set_row_alpha (self, j, x);
	} else {		/* row is completely empty */
	  self_set_row_alpha (self, j, 0);
	}
      }
    }

    /* lower chamber */
    a = 0;
    empty = self->B-q*self->volume;
    for (j=self->waist_y; j<self->height; ++j) {
      if (a >= empty) {		/* row is completely filled */
	self_set_row_alpha (self, j, 1);
      } else {
	a += self->linevol[j];
	if (a >= empty) {	/* row is partially filled */
	  double  x = (a - empty) / self->linevol[j];
	  self_set_row_alpha (self, j, x);
	} else {		/* row is completely empty */
	  self_set_row_alpha (self, j, 0);
	}
      }
    }
  }}
#line 517 "sand-window.c"
#undef __GOB_FUNCTION__

#line 193 "../gob/sand-window.gob"
static GdkPixbuf * 
sand_window_get_pixmap_themed (const char * name, const char * theme)
#line 523 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::get_pixmap_themed"
{
#line 195 "../gob/sand-window.gob"
	
    char *tname, *fname;
    GdkPixbuf *res;
    
    if (! theme || ! *theme)  theme = "default";
    tname = g_strdup_printf ("%s/%s", theme, name);
    fname = get_pixmap_file (tname);
    g_free (tname);
    res = gdk_pixbuf_new_from_file (fname, NULL);
    g_free (fname);

    return  res;
  }}
#line 541 "sand-window.c"
#undef __GOB_FUNCTION__

#line 209 "../gob/sand-window.gob"
static void 
sand_window_release_pixmaps (SandWindow * self)
#line 547 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::release_pixmaps"
#line 209 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 209 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 554 "sand-window.c"
{
#line 211 "../gob/sand-window.gob"
	
    if (self->back) {
      g_object_unref (self->back);
      self->back = NULL;
    }
    if (self->front) {
      g_object_unref (self->front);
      self->front = NULL;
    }
    if (self->sandmask) {
      g_object_unref (self->sandmask);
      self->sandmask = NULL;
    }
    if (self->sand) {
      g_object_unref (self->sand);
      self->sand = NULL;
    }
    g_free (self->linevol);
    self->linevol = NULL;

    g_free (self->theme);
    self->theme = NULL;
  }}
#line 580 "sand-window.c"
#undef __GOB_FUNCTION__

#line 235 "../gob/sand-window.gob"
static void 
sand_window_load_pixmaps (SandWindow * self)
#line 586 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::load_pixmaps"
#line 235 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 235 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 593 "sand-window.c"
{
#line 237 "../gob/sand-window.gob"
	
    int  w, h;

    self->back = self_get_pixmap_themed ("back.png", self->theme);
    self->front = self_get_pixmap_themed ("front.png", self->theme);
    self->sandmask = self_get_pixmap_themed ("mask.png", self->theme);
    g_assert (gdk_pixbuf_get_colorspace(self->sandmask) == GDK_COLORSPACE_RGB);
    g_assert (gdk_pixbuf_get_has_alpha (self->sandmask));

    w = self->width = gdk_pixbuf_get_width (self->back);
    h = self->height = gdk_pixbuf_get_height (self->back);
    self->sand = gdk_pixbuf_new (GDK_COLORSPACE_RGB, TRUE, 8, w, h);

    self->linevol = g_new (double, self->height);

    self_init_sand (self);
  }}
#line 613 "sand-window.c"
#undef __GOB_FUNCTION__

#line 255 "../gob/sand-window.gob"
static void 
sand_window_create_shape (SandWindow * self, int image_width, int image_height)
#line 619 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::create_shape"
#line 255 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 255 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 626 "sand-window.c"
{
#line 257 "../gob/sand-window.gob"
	
    GdkBitmap *shapemask;

    if (! self->back)  return;

    shapemask = gdk_pixmap_new (GTK_WIDGET (self)->window,
				image_width, image_height, 1);
    gdk_pixbuf_render_threshold_alpha (self->back, shapemask,
				       0, 0, 0, 0, image_width, image_height,
				       128);

    if (!GTK_WIDGET_REALIZED (self))  gtk_widget_realize (GTK_WIDGET (self));

    gtk_widget_shape_combine_mask (GTK_WIDGET (self), shapemask, 0, 0);
    gdk_bitmap_unref (shapemask);
  }}
#line 645 "sand-window.c"
#undef __GOB_FUNCTION__

#line 274 "../gob/sand-window.gob"
static void 
sand_window_draw (SandWindow * self, GdkRectangle * area)
#line 651 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::draw"
#line 274 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 274 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 658 "sand-window.c"
{
#line 276 "../gob/sand-window.gob"
	
    GtkStyle *style;

    if (! self->back)  return;
    
    style = gtk_widget_get_style (GTK_WIDGET(self));
    gdk_draw_pixbuf (GTK_WIDGET(self)->window,
		     style->black_gc,
		     self->back,
		     area->x, area->y, 
		     area->x, area->y, area->width, area->height,
		     GDK_RGB_DITHER_NORMAL, 0, 0);
    gdk_draw_pixbuf (GTK_WIDGET(self)->window,
		     style->black_gc,
		     self->sand,
		     area->x, area->y, 
		     area->x, area->y, area->width, area->height,
		     GDK_RGB_DITHER_NORMAL, 0, 0);
    gdk_draw_pixbuf (GTK_WIDGET(self)->window,
		     style->black_gc,
 		     self->front,
 		     area->x, area->y, 
 		     area->x, area->y, area->width, area->height,
 		     GDK_RGB_DITHER_NORMAL, 0, 0);
  }}
#line 686 "sand-window.c"
#undef __GOB_FUNCTION__

#line 302 "../gob/sand-window.gob"
static void 
sand_window_redraw (SandWindow * self)
#line 692 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::redraw"
#line 302 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 302 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 699 "sand-window.c"
{
#line 304 "../gob/sand-window.gob"
	
    gtk_widget_queue_draw_area (GTK_WIDGET(self), 
				0, 0, self->width, self->height);
  }}
#line 706 "sand-window.c"
#undef __GOB_FUNCTION__

#line 313 "../gob/sand-window.gob"
static gint 
___b_sand_window_expose_event (GtkWidget * widget G_GNUC_UNUSED, GdkEventExpose * event)
#line 712 "sand-window.c"
#define PARENT_HANDLER(___widget,___event) \
	((GTK_WIDGET_CLASS(parent_class)->expose_event)? \
		(* GTK_WIDGET_CLASS(parent_class)->expose_event)(___widget,___event): \
		((gint )0))
{
#define __GOB_FUNCTION__ "Sand:Window::expose_event"
{
#line 315 "../gob/sand-window.gob"
	
    SandWindow *self;

    self = SAND_WINDOW (widget);
    self_draw (self, &(event->area));

    return  TRUE;
  }}
#line 729 "sand-window.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 324 "../gob/sand-window.gob"
static void 
___c_sand_window_size_request (GtkWidget * widget G_GNUC_UNUSED, GtkRequisition * requisition)
#line 736 "sand-window.c"
#define PARENT_HANDLER(___widget,___requisition) \
	{ if(GTK_WIDGET_CLASS(parent_class)->size_request) \
		(* GTK_WIDGET_CLASS(parent_class)->size_request)(___widget,___requisition); }
{
#define __GOB_FUNCTION__ "Sand:Window::size_request"
#line 324 "../gob/sand-window.gob"
	g_return_if_fail (widget != NULL);
#line 744 "sand-window.c"
{
#line 326 "../gob/sand-window.gob"
	
    SandWindow *self;

    self = SAND_WINDOW (widget);
    requisition->width = self->width;
    requisition->height = self->height;
  }}
#line 754 "sand-window.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 334 "../gob/sand-window.gob"
static void 
sand_window_size_allocate_handler (GtkWidget * widget, GtkAllocation * allocation, gpointer data)
#line 761 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::size_allocate_handler"
{
#line 337 "../gob/sand-window.gob"
	
    SandWindow *self;

    self = SAND_WINDOW (widget);
    self_create_shape (self, allocation->width, allocation->height);
  }}
#line 772 "sand-window.c"
#undef __GOB_FUNCTION__

#line 344 "../gob/sand-window.gob"
static void 
sand_window_drop_handler (GtkWidget * widget, GdkDragContext * context, gint x, gint y, GtkSelectionData * selection_data, guint info, guint time, gpointer data)
#line 778 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::drop_handler"
{
#line 353 "../gob/sand-window.gob"
	
    SandWindow *sand_window = SAND_WINDOW (widget);
    guint16 *vals;
    gdouble  r, g, b;

    if (selection_data->length < 0) return;

    if ((selection_data->format != 16) || (selection_data->length != 8)) {
      g_warning ("Received invalid color data");
      return;
    }
  
    vals = (guint16 *)selection_data->data;

    r = (gdouble)vals[0] / 0xffff;
    g = (gdouble)vals[1] / 0xffff;
    b = (gdouble)vals[2] / 0xffff;
  
    self_set_color (sand_window, r*255, g*255, b*255);
  }}
#line 803 "sand-window.c"
#undef __GOB_FUNCTION__

#line 374 "../gob/sand-window.gob"
static void 
___f_sand_window_realize (GtkWidget * widget G_GNUC_UNUSED)
#line 809 "sand-window.c"
#define PARENT_HANDLER(___widget) \
	{ if(GTK_WIDGET_CLASS(parent_class)->realize) \
		(* GTK_WIDGET_CLASS(parent_class)->realize)(___widget); }
{
#define __GOB_FUNCTION__ "Sand:Window::realize"
#line 374 "../gob/sand-window.gob"
	g_return_if_fail (widget != NULL);
#line 817 "sand-window.c"
{
#line 376 "../gob/sand-window.gob"
	
    GdkPixmap *icon;
    static const GtkTargetEntry targets[] = {
      { "application/x-color", 0 }
    };

    g_return_if_fail (SAND_IS_WINDOW (widget));

    PARENT_HANDLER (widget);

    icon = gdk_bitmap_create_from_data (widget->window, icon24_bits,
				        icon24_width, icon24_height);
    gdk_window_set_icon (widget->window, NULL, icon, NULL);
    gdk_window_set_functions (widget->window, GDK_FUNC_MOVE|GDK_FUNC_CLOSE);
    self_set_decorations (SAND_WINDOW (widget));

    gtk_drag_dest_set (widget, GTK_DEST_DEFAULT_ALL,
		       targets, 1, GDK_ACTION_COPY);
  
    gtk_signal_connect (GTK_OBJECT (widget),
			"drag_data_received",
			GTK_SIGNAL_FUNC (self_drop_handler),
			NULL);
  }}
#line 844 "sand-window.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER


#line 421 "../gob/sand-window.gob"
static void 
___11_sand_window_destroy (GtkObject * object G_GNUC_UNUSED)
#line 852 "sand-window.c"
#define PARENT_HANDLER(___object) \
	{ if(GTK_OBJECT_CLASS(parent_class)->destroy) \
		(* GTK_OBJECT_CLASS(parent_class)->destroy)(___object); }
{
#define __GOB_FUNCTION__ "Sand:Window::destroy"
#line 421 "../gob/sand-window.gob"
	g_return_if_fail (object != NULL);
#line 860 "sand-window.c"
{
#line 423 "../gob/sand-window.gob"
	
    SandWindow *self;

    self = SAND_WINDOW (object);
    self_release_pixmaps (self);
    PARENT_HANDLER (object);
  }}
#line 870 "sand-window.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 435 "../gob/sand-window.gob"
static void 
sand_window_set_decorations (SandWindow * self)
#line 877 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::set_decorations"
#line 435 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 435 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 884 "sand-window.c"
{
#line 437 "../gob/sand-window.gob"
	
    GtkWidget *widget = GTK_WIDGET (self);
    gboolean  fix_broken_wm;
    gint x, y;

    if (! GTK_WIDGET_REALIZED (self))  return;

    /* work around broken window managers */
    fix_broken_wm = GTK_WIDGET_MAPPED (self);
    if (fix_broken_wm) {
      gdk_window_get_position (widget->window, &x, &y);
      gdk_window_hide (widget->window);
    }

    if (self->decorations) {
      gdk_window_set_decorations (widget->window, GDK_DECOR_TITLE);
    } else {
      gdk_window_set_decorations (widget->window, 0);
    }

    if (fix_broken_wm) {
      gdk_window_show (widget->window);
      gdk_window_move (widget->window, x, y);
    }
  }}
#line 912 "sand-window.c"
#undef __GOB_FUNCTION__

#line 467 "../gob/sand-window.gob"
void 
sand_window_get_color (SandWindow * self, guint8 * r, guint8 * g, guint8 * b)
#line 918 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::get_color"
#line 467 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 467 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 925 "sand-window.c"
{
#line 469 "../gob/sand-window.gob"
	
    *r = self->r;
    *g = self->g;
    *b = self->b;
  }}
#line 933 "sand-window.c"
#undef __GOB_FUNCTION__

#line 475 "../gob/sand-window.gob"
void 
sand_window_set_color (SandWindow * self, guint8 r, guint8 g, guint8 b)
#line 939 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::set_color"
#line 475 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 475 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 946 "sand-window.c"
{
#line 477 "../gob/sand-window.gob"
	
    guint32  col = r << 24 | g << 16 | b << 8 | 0x00;
    self->r = r;
    self->g = g;
    self->b = b;
    if (self->sand)  gdk_pixbuf_fill (self->sand, col);
    self_refill (self);
    self_redraw (self);
  }}
#line 958 "sand-window.c"
#undef __GOB_FUNCTION__

#line 487 "../gob/sand-window.gob"
void 
sand_window_set_ratio (SandWindow * self, double q)
#line 964 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::set_ratio"
#line 487 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 487 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 971 "sand-window.c"
{
#line 489 "../gob/sand-window.gob"
	
    self->ratio = CLAMP(q, 0.0, 1.0);
    self_refill (self);
    self_redraw (self);
  }}
#line 979 "sand-window.c"
#undef __GOB_FUNCTION__

#line 495 "../gob/sand-window.gob"
void 
sand_window_set_flow (SandWindow * self, double flow)
#line 985 "sand-window.c"
{
#define __GOB_FUNCTION__ "Sand:Window::set_flow"
#line 495 "../gob/sand-window.gob"
	g_return_if_fail (self != NULL);
#line 495 "../gob/sand-window.gob"
	g_return_if_fail (SAND_IS_WINDOW (self));
#line 992 "sand-window.c"
{
#line 497 "../gob/sand-window.gob"
	
    self->flow = CLAMP(flow, 0.0, 1.0);
    self_refill (self);
    self_redraw (self);
  }}
#line 1000 "sand-window.c"
#undef __GOB_FUNCTION__
