/*
 * Sentinella
 * http://sentinella.sourceforge.net/
 * Copyright (c) 2009-2011 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <sys/types.h>
#include <libsysactivity/libsysactivity.h>
#include <QSet>
#include <QCloseEvent>
#include <KMainWindow>
#include <KAboutData>
#include <KCmdLineArgs>
#include <kstatusnotifieritem.h>
#include <solid/powermanagement.h>
#include "ui_MainWindow.h"
#include "Actions/AbstractAction.h"
#include "Conditions/AbstractCondition.h"
#include "Process.h"
#include "NetworkInterface.h"
#include "common.h"

enum ConditionId {
	NO_CONDITION = -1,
	CPU_ID, // Can't use 'CPU' identifier because it's taken by class CPU
	MEMORY,
	NETWORK,
	DATETIME,
	PROCESSDIES
};
enum ActionId {
	NO_ACTION = -1,
	SHUTDOWN,
	REBOOT,
	SLEEP,
	EXECUTECOMMAND,
	PLAYALARM,
	KILLPROCESS
};

class MainWindow : public KMainWindow {
	Q_OBJECT

public:
	MainWindow(KCmdLineArgs* cmdLineArgs, const ConditionId cmdChosenCondition, const ActionId cmdChosenAction);
	~MainWindow();

protected:
	void checkShutdownSleepStates();
	void initConditionWidgets(const ConditionId cmdSelectedCondition);
	void initActionWidgets(const ActionId cmdSelectedAction);
	void startCondition();
	void showError(const int error) _COLD;
	inline void saveConfig(ConditionId conditionCheckedId, ActionId actionCheckedId, qint64 msecs);
	void chooseProcess(bool isAction);
	void closeEvent(QCloseEvent *event);
	bool createProcess();
	bool processExists(pid_t pid);
	bool getProcess(struct sa_process* procInfo);
	void stopCondition();
	void saveProperties(KConfigGroup& config);
	void readProperties(const KConfigGroup& config);

private:
	Ui::MainWindow gui;
	bool isKDE;
	KCmdLineArgs* cmdLineArgs;
	QButtonGroup conditionsGroup;
	QButtonGroup actionsGroup;
	KSharedConfig::Ptr config;
	bool supportedShutdown;
	KIconLoader* iconLoader;
	KStatusNotifierItem trayIcon;
	AbstractAction* action;
	QSet<Solid::PowerManagement::SleepState> supportedSleepStates;
	pid_t pidProcessDies;
	pid_t pidKillProcess;
	QStringList* availableSounds;
	Process* processAPI;
	NetworkInterface* networkInterfaceAPI;
	AbstractCondition* condition;

public slots:
	void radioButtonNetworkToggled(bool checked);
	void radioButtonPlayAlarmToggled(bool checked);
	void programDiesClicked();
	void startStopClicked();
	void conditionAccomplished();
	void conditionFailed(int error);
	void killProcessClicked();
	void showAboutApp() _COLD;
	void actionButtonClicked(int id);
};

#endif /* MAINWINDOW_H */
