# sight::module::viz::scene3d

Contains adaptors available for the generic scene.

## Services

- **axis**: shows a simple coordinate system.
- **camera**: transforms a Sight camera to an Ogre camera.
- **compositor_parameter**: binds a Sight data to a shader uniform from a specific compositor.
- **fragments_info**: takes a snapshot of layer fragments information and output it as a sight::data::image.
- **frustum**: displays the frustum of a sight::data::camera.
- **frustumList**: displays a new Frustum each time the transform is updated.
- **image_multi_distances**: displays distances retrieved from the image fields.
- **landmarks**: displays landmarks.
- **light**: adds a light to the scene manager.
- **line**: shows a simple line.
- **material**: adapts a sight::data::material, allowing to tweak material parameters.
- **mesh**: shows individual meshes.
- **meshList**: shows a list of mesh.
- **model_series**: shows a modelSeries. It creates an adaptor for each reconstruction in the model.
- **negato2d**: displays a 2D negato.
- **negato2d_camera**: lets the user move an orthographic camera to visualize medical images in 2D.
- **negato3d**: displays a 3D negato.
- **orientation_marker**: displays an orientation "marker", marker is represented by a human body mesh, its orientation follows camera movement.
- **picker**: performs picking queries on mouse clicks and forwards the picked data through a signal.
- **point_list**: shows a point list using billboards generated by a geometry shader.
- **reconstruction**: displays a reconstruction.
- **render_stats**: displays rendering statistics in the window overlay.
- **resize_viewport**: resizes and moves viewports.
- **shader_parameter**: sends a Sight data as a shader parameter.
- **shape_extruder**: allows to draw a 2D shape with a lasso tool, and create an extruded mesh from it.
- **text**: displays a text object in the center or along the window borders.
- **texture**: maps a texture on a mesh. This is done via module::viz::scene3d::adaptor::material.
- **trackball_camera**: lets the user move the camera around a point of interest using the mouse and keyboard.
- **transform**: binds a sight::data::matrix4 to a scene node.
- **vector**: shows a simple vector.
- **video**: renders a video frame from a 2D-image.
- **volume_render**: displays a volume rendering.
- **voxel_picker**: performs picking queries on an image voxel using slices.

## How to use it

### CMake

```cmake
add_dependencies(my_target module_viz_scene3d ... )
```

### XML

Please consult the [doxygen](https://sight.pages.ircad.fr/sight) of each service to learn more about its use in xml configurations.
