/*****************************************************************************\
 *  sicp.h - Inter-cluster job management functions
 *****************************************************************************
 *  Copyright (C) SchedMD LLC (http://www.schedmd.com).
 *  Written by Morris Jette
 *
 *  This file is part of SLURM, a resource management program.
 *  For details, see <http://slurm.schedmd.com/>.
 *  Please also read the included file: DISCLAIMER.
 *
 *  SLURM is free software; you can redistribute it and/or modify it under
 *  the terms of the GNU General Public License as published by the Free
 *  Software Foundation; either version 2 of the License, or (at your option)
 *  any later version.
 *
 *  In addition, as a special exception, the copyright holders give permission
 *  to link the code of portions of this program with the OpenSSL library under
 *  certain conditions as described in each individual source file, and
 *  distribute linked combinations including the two. You must obey the GNU
 *  General Public License in all respects for all of the code used other than
 *  OpenSSL. If you modify file(s) with this exception, you may extend this
 *  exception to your version of the file(s), but you are not obligated to do
 *  so. If you do not wish to do so, delete this exception statement from your
 *  version.  If you delete this exception statement from all source files in
 *  the program, then also delete it here.
 *
 *  SLURM is distributed in the hope that it will be useful, but WITHOUT ANY
 *  WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 *  FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with SLURM; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA.
\*****************************************************************************/

#ifndef _HAVE_SICP_H
#define _HAVE_SICP_H

#include <sys/types.h>
#include <time.h>

#include "src/common/list.h"
#include "src/slurmctld/slurmctld.h"

typedef struct sicp_job {
	uint32_t job_id;		/* Global job ID */
	uint32_t job_state;		/* state of the job */
	struct sicp_job *sicp_next;	/* link for hash table */
	time_t   update_time;		/* Time job last seen */
} sicp_job_t;

/* For a given inter-cluster job ID, return its state (if found) or NO_VAL */
extern uint32_t sicp_get_state(uint32_t job_id);

/* Start a thread to poll other clusters for inter-cluster job status */
extern void sicp_init(void);

/* Shutdown the inter-cluster job status thread */
extern void sicp_fini(void);

#endif /* !_HAVE_SICP_H */
