<?php /* SRG Default PHP Header - 1.3.6
	   * 
	   * If you make modifications to this file you *must* remove the
	   * 'SRG Default PHP Header - 1.3.6' string on the first line or your
	   * changes may be overwritten.
	   *
	   * $Id: header.php 234 2005-05-11 22:18:35Z matt $
	   *
	   */
/* Define some defaults */
define("CONFIG_FILE", "/etc/srg/srg.conf");
define("DEFAULT_OUTPUTURL", "/srg_reports/");
define("DEFAULT_TITLE", "SRG - Squid Log Analysis");
define("DEFAULT_INCLUDEJS", 0);

/* Read configuration information from the default configuration file */
$outputurl = DEFAULT_OUTPUTURL;
$title = DEFAULT_TITLE;
$include_js = DEFAULT_INCLUDEJS;

$config = @file(CONFIG_FILE);

if ($config) {
    /* Loop through lines and find output URL or title*/
    for ($i=0; $i<count($config); $i++) {
        if (substr($config[$i], 0, 5) == "title") {
            $title = substr($config[$i], 7);
            $title = trim(trim($title), "\"");
            continue;
        }
        if (substr($config[$i], 0, 10) == "output_url") {
            $outputurl = substr($config[$i], 12);
            $outputurl = trim(trim($outputurl), "\"");
            continue;
        }
        if (substr($config[$i], 0, 12) == "sort_columns") {
            $tmp = substr($config[$i], 13);
            if (strtolower(substr($tmp, 0, 4)) == "true") {
                $include_js = 1;
            }
        }
    }
}

/* Check default output URL ends in a / */
$last = substr($outputurl, -1, 1);
if ($last != "/") {
	$outputurl .= "/";
}

/* Do any custom page setup below here */

/* if you have php_authentication (-A) enabled then this function must be 
 * filled in.
 *
 * For each group in the report the name of the group is passed to this
 * function which must return true if the currently logged in user can view the
 * reports for the specified group.
 *
 * A return value of false causes the reports for the specified group not to be
 * displayed.
 */
function can_view($groupname) {
	/* Retrieve the currently logged in user from your session/cookie here */

	/* Check authentication here */

	/* But by default we'll have no authentication :) */
	return true;
}

/* This function is called when an error must be displayed to the user due to 
 * an access denied error or similar.
 */
function report_error($errormessage) {
	echo "<br><b>$errormessage</b><br>";	
}

/* Setup the page HTML here */
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
<meta name="generator" content="SRG 1.3.6 (http://www.crc.net.nz/software/srg.php)">
<meta name="robots" content="noindex,nofollow">
<?php
    echo "<link href=\"${outputurl}style.css\" type=\"text/css\" " .
        "rel=\"stylesheet\">\n";
    if ($include_js == 1) {
        echo "<script language=\"javascript\" src=\"${outputurl}srg.js\" " .
            "type=\"text/javascript\"></script>\n";
    }
    echo "<title>$title</title>\n";
?>
</head>
<?php
    if ($include_js == 1) {
        echo "<body onload=\"setupSort();\">\n";
    } else {
        echo "<body>\n";
    }
?>
<br>
<div align="center"><h1><?php echo $title; ?></h1></div>
<br>
<?php 
// vim: ts=4 sw=4 sts=4 et: 
?>
