/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.HashComputer;
import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.common.math.FastMath;
import cds.healpix.common.math.HackersDelight;
import cds.healpix.common.math.Math;

final class HealpixNestedHashComputer
implements HashComputer {
    private final HealpixNested h;
    private double xpm1;
    private int q;
    private long d0h;
    private double lInD0h;
    private double hInD0h;

    HealpixNestedHashComputer(HealpixNested healpixNested) {
        this.h = healpixNested;
    }

    @Override
    public int depth() {
        return this.h.depth;
    }

    @Override
    public long hash(double lonRad, double latRad) {
        Healpix.checkLatitude(latRad);
        this.d0hAndlhInD0c(lonRad, latRad);
        int i = (int)this.h.timeHalfNside(this.hInD0h + this.lInD0h);
        int j = (int)this.h.timeHalfNside(this.hInD0h - this.lInD0h);
        if (i == this.h.nside) {
            --i;
        }
        if (j == this.h.nside) {
            --j;
        }
        return this.d0h << this.h.twiceDepth | this.h.fc.ij2hash(i, j);
    }

    private void d0hAndlhInD0c(double lonRad, double latRad) {
        this.xpm1AndQ(lonRad);
        assert (-1.0 <= this.xpm1 && this.xpm1 <= 1.0);
        assert (0 <= this.q && this.q <= 3);
        if (latRad > Healpix.TRANSITION_LATITUDE) {
            double sqrt3OneMinZ = Math.SQRT6 * FastMath.cosQ(0.5 * latRad + 0.7853981633974483);
            this.lInD0h = this.xpm1 * sqrt3OneMinZ;
            this.hInD0h = 2.0 - sqrt3OneMinZ;
            this.d0h = this.q;
        } else if (latRad < -Healpix.TRANSITION_LATITUDE) {
            double sqrt3OneMinZ = Math.SQRT6 * FastMath.cosQ(0.7853981633974483 - 0.5 * latRad);
            this.lInD0h = this.xpm1 * sqrt3OneMinZ;
            this.hInD0h = sqrt3OneMinZ;
            this.d0h = this.q + 8;
        } else {
            long signLat = HackersDelight.toBits(latRad);
            double absLat = HackersDelight.fromBits(signLat & Long.MAX_VALUE);
            double ypm1 = HackersDelight.fromBits(HackersDelight.toBits(FastMath.sinQ(absLat, 0.0) * 1.5) | (signLat &= Long.MIN_VALUE));
            int q01 = this.xpm1 > ypm1 ? 1 : 0;
            int q12 = this.xpm1 >= -ypm1 ? 1 : 0;
            int q1 = q01 & q12;
            int q013 = q01 + (1 - q12);
            this.lInD0h = this.xpm1 - (double)(q01 + q12 - 1);
            this.hInD0h = ypm1 + (double)q013;
            this.d0h = (q013 << 2) + (this.q + q1 & 3);
        }
    }

    private void xpm1AndQ(double lonRad) {
        long lonSign = HackersDelight.toBits(lonRad);
        double lonAbs = HackersDelight.fromBits(lonSign & Long.MAX_VALUE);
        double x = lonAbs * 1.2732395447351628;
        int q = (int)x | 1;
        if ((lonSign &= Long.MIN_VALUE) == 0L) {
            this.xpm1 = x - (double)q;
            this.q = (q & 7) >> 1;
        } else {
            this.xpm1 = (double)q - x;
            this.q = 3 - ((q & 7) >> 1);
        }
    }
}

