/* ====================================================================
 * Copyright (c) 2008-2009  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "WcViewCmdProgressTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "subcommander/WcViewCmdProgress.h"
#include "subcommander/commands/ListParam.h"
#include "subcommander/events/LoggingEvent.h"
#include "util/Error.h"

// qt
#include <QtCore/QEvent>
#include <QtCore/QRegExp>
#include <QtGui/QApplication>


void WcViewCmdProgressTest::setUp()
{
  _progress = new WcViewCmdProgress(this);
}

void WcViewCmdProgressTest::tearDown()
{
  delete _progress;
  _ld.clear();
}

bool WcViewCmdProgressTest::event( QEvent* e )
{
  switch( e->type() )
  {
    case ScLoggingEvent:
    {
      LoggingEvent* le = (LoggingEvent*)e;
      _ld.push_back(le->getData());
      break;
    }
    default:
    {
      CPPUNIT_ASSERT(false);
    }
  }
  
  return true;
}

void WcViewCmdProgressTest::processEvents()
{
  qApp->processEvents();  
}

void WcViewCmdProgressTest::ASSERT_MSG( const sc::String& expected, const sc::String& actual )
{
  QString msg = QString::fromUtf8((const char*)actual);
  QRegExp reg = QRegExp( ".*\\s*" +QString::fromUtf8((const char*)expected)+ "\\s*.*");
  bool    res = reg.exactMatch("url");
  
  CPPUNIT_ASSERT_EQUAL( true, res );
}

void WcViewCmdProgressTest::listStarted()
{
  ListParam* p = new ListParam(
    sc::String("url"), new svn::Revision(svn::Revision_Unspecified), false, false );
  
  _progress->started(p,NULL);

  processEvents();
  
  LogDataPtr ld;
  CPPUNIT_ASSERT_EQUAL( (size_t)1, _ld.size() );
  
  ld = _ld[0];
  CPPUNIT_ASSERT_EQUAL( p->getId(), ld->getId() );
  CPPUNIT_ASSERT_EQUAL( true, ld->isStarted() );
  CPPUNIT_ASSERT_EQUAL( false, ld->isCancelable() );
  ASSERT_MSG( sc::String("url"), ld->getMsg() );
  
  delete p;
}

void WcViewCmdProgressTest::listFinished()
{
  ListParam* p = new ListParam(
    sc::String("url"), new svn::Revision(svn::Revision_Unspecified), false, false );
  p->setError(sc::Success);
  
  _progress->finished(p,0.0);
  
  processEvents();  

  LogDataPtr ld;
  CPPUNIT_ASSERT_EQUAL( (size_t)1, _ld.size() );

  ld = _ld[0];
  CPPUNIT_ASSERT_EQUAL( p->getId(), ld->getId() );
  CPPUNIT_ASSERT_EQUAL( true, ld->isFinished() );
  
  delete p;
}

void WcViewCmdProgressTest::listFinishedFailed()
{
  ListParam* p = new ListParam(
    sc::String("url"), new svn::Revision(svn::Revision_Unspecified), false, false );
  p->setError(sc::createError( 1, sc::String("Error 1") ));
  
  _progress->finished(p,0.0);
  
  processEvents();  

  LogDataPtr ld;  
  CPPUNIT_ASSERT_EQUAL( (size_t)2, _ld.size() );
  
  ld = _ld[0];  
  CPPUNIT_ASSERT_EQUAL( p->getId(), ld->getId() );
  CPPUNIT_ASSERT_EQUAL( true, ld->isError() );
  //ASSERT_MSG( sc::String("Error 1"), ld->getMsg() );

  ld = _ld[1];  
  CPPUNIT_ASSERT_EQUAL( p->getId(), ld->getId() );
  CPPUNIT_ASSERT_EQUAL( true, ld->isFinished() );
  
  delete p;
}
