/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_UNLOCKCMD_H
#define _SC_UNLOCKCMD_H

// sc
#include "ScCmd.h"
class CmdResultCallback;
class UnlockParam;


/**
 * Command for unlocking paths or urls.
 */
class UnlockCmd : public ScCmd
{
public:
  /**
   * Construct a UnlockCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  UnlockCmd( UnlockParam* param, CmdResultCallback* cb );
  ~UnlockCmd();

  void run();

private:
  // in
  UnlockParam*       _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_UNLOCKCMD_H
