/**
 * Copyright (C) 2007-2013 Lawrence Murray
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * @author Lawrence Murray <lawrence@indii.org>
 * $Rev$
 * $Date$
 */
#include "TintApp.hpp"

#include "TintWindow.hpp"
#include "../images/tint.hpp"
#include "../../gui/Splash.hpp"

#include "wx/splash.h"

using namespace indii;

INDII_IMPLEMENT_APP(TintApp)

void TintApp::splash() {
  tint_initialize_images();
  wxSplashScreen* splash = new wxSplashScreen(Splash(_img_tint_splash),
      wxSPLASH_CENTRE_ON_SCREEN|wxSPLASH_TIMEOUT, 5000, NULL, -1);
}

indii::Window* TintApp::open(const wxString& file) {
  return new TintWindow(NULL, file, TintWindow::STANDALONE, this);
}

indii::Window* TintApp::open() {
  return new TintWindow(NULL, TintWindow::STANDALONE, this);
}

BEGIN_EVENT_TABLE(TintApp, App)
END_EVENT_TABLE()
