-- lib/tongue/util.lua
--
-- Lua I18N library 'Tongue' - Utility routines
--
-- Copyright 2016 Daniel Silverstone <dsilvers@digital-scurf.org>
--
-- For licence terms, see COPYING
--

--- Tongue needs to process lots of interesting data, here are some utility
-- functions it might use.
--
-- @module tongue.util

--- Split a category into its components.
--
-- Categories can have low level languages, sub languages (countries), and
-- character sets.  This routine splits a category string in the same way as
-- glibc does which seems to be a reasonable 'standard' to use.
--
-- @tparam string category The category to split up
-- @treturn string The base (low level) language name.
-- @treturn ?string The sub-language (or nil if no sub-language was specified)
-- @treturn ?string The characterset (or nil if no character set was specified)
-- @function split_category
local function split_category(category)
   -- ll_CC.SSS
   local charset = nil
   if category:find("%.") then
      category, charset = category:match("^(.-)%.(.+)$")
   end
   local country = nil
   if category:find("_") then
      category, country = category:match("^(.-)_(.+)$")
   end
   return category, country, charset
end

return {
   split_category = split_category,
}

