// $Id$

#include "pamgen_code_types.h"
#include "pamgen_element_dictionary.h"

namespace PAMGEN_NEVADA {


// if you add an element type, you must be consistant with the arrays defined
// below and you should make sure that element_dictionary.h is in sync.

extern const int NUM_ELEMENT_TYPES = MAX_EL_TYPES;

extern const Element_Info element_info[MAX_EL_TYPES] = {
// nodes, edges, faces,  npf,   nsp,    class
 {   0,     0,     0,     0,     0,  EL_UNKNOWN    },  // UNKNOWN_ELEMENT
 {   1,     0,     0,     0,     1,  EL_CONTINUUM  },  // CIRCLE
 {   1,     0,     0,     0,     1,  EL_CONTINUUM  },  // SPHERE
 {   4,     4,     4,     2,     1,  EL_CONTINUUM  },  // QUAD4
 {   0,     0,     0,     0,     0,  EL_UNKNOWN    },  // QUAD8
 {   0,     0,     0,     0,     0,  EL_UNKNOWN    },  // QUAD9
 {   3,     3,     3,     2,     1,  EL_CONTINUUM  },  // TRI3
 {   6,     3,     3,     3,     3,  EL_CONTINUUM  },  // TRI6
 {   4,     4,     4,     2,     3,  EL_CONTINUUM  },  // TRI7
 {   4,     4,     2,     4,     3,  EL_STRUCTURAL },  // SHELL4
 {   0,     0,     0,     0,     0,  EL_UNKNOWN    },  // SHELL8
 {   8,    12,     6,     4,     1,  EL_CONTINUUM  },  // HEX8
 {  20,    12,     6,     8,     1,  EL_CONTINUUM  },  // HEX20
 {   0,     0,     0,     0,     0,  EL_UNKNOWN    },  // HEX27
 {   4,     6,     4,     3,     1,  EL_CONTINUUM  },  // TET4 - c
 {   8,     6,     4,     4,     1,  EL_CONTINUUM  },  // TET8 - c+f
 {  10,     6,     4,     6,     5,  EL_CONTINUUM  },  // TET10 - c+e
 {   8,    12,     6,     4,     4,  EL_CONTINUUM  },  // TET15 - c+f+e
 {   6,     9,     5,     4,     1,  EL_CONTINUUM  },  // WEDGE6
 {   0,     0,     0,     0,     0,  EL_UNKNOWN    },  // WEDGE18
 {   0,     0,     0,     0,     0,  EL_UNKNOWN    },  // BEAM2
 {   0,     0,     0,     0,     0,  EL_UNKNOWN    },  // BEAM3
 {   0,     0,     0,     0,     0,  EL_UNKNOWN    },  // TRUSS2
 {   0,     0,     0,     0,     0,  EL_UNKNOWN    },  // TRUSS3
 {   0,     0,     0,     0,     0,  EL_UNKNOWN    },  // STRUCT1D
 {   0,     0,     0,     0,     0,  EL_UNKNOWN    },  // STRUCT2D
 {   0,     0,     0,     0,     0,  EL_UNKNOWN    },  // STRUCT3D
 {   0,     0,     0,     0,     0,  EL_UNKNOWN    },  // SFACET3D
 {   5,     8,     5,     4,     1,  EL_CONTINUUM  },  // PYRAMID5
 {   0,     0,     0,     0,     0,  EL_UNKNOWN    },  // SEG2
 {   0,     0,     0,     0,     0,  EL_UNKNOWN    }   // SEG3
};

// Maximum nodes per face
extern const int nodes_per_face[] = {0, 1, 1, 2, 3, 
                                     3, 2, 3, 3, 4,
                                     8, 4, 8, 8, 3, 4,
                                     6, 7, 4, 8, 2,
                                     3, 2, 3, 2, 2,
                                     4, 4, 4, 1, 1};
       
extern const int faces_per_element[] = {0, 1, 1, 4, 4,
                                        4, 3, 3, 3, 6,
                                        6, 6, 6, 6, 4, 4,
                                        4, 4, 5, 5, 2,
                                        2, 2, 2, 2, 4,
                                        6, 6, 5, 2, 2};

extern const int edges_per_element[] = { 0, 0, 0, 4, 0,
                                         0, 3, 3, 4, 4,
                                         0,12, 12, 0, 6, 6,
                                         6,12, 9, 0, 0,
                                         0, 0, 0, 0, 0,
                                         0, 0, 8, 0, 0};

/* translations tables do not include the nonstandard element TET8 */

/* node to side translation tables - 
 *   These tables are used to look up the side number based on the
 *   first and second node in the side/face list. The side node order
 *   is found in the original Exodus document, SAND87-2997. The element
 *   node order is found in the ExodusII document, SAND92-2137. These
 *   tables were generated by following the right-hand rule for determining
 *   the outward normal. Note: Only the more complex 3-D shapes require
 *   these tables, the simple shapes are trivial - the first node found
 *   is also the side number.
 */

extern const int shell_node_to_side_table[2][8]  = {
//      1     2   3    4                                          node 1 
      {2,4, 3,1, 4,2, 1,3},                                    // node 2
      {1,2, 1,2, 1,2, 1,2}                                     // side #
};

extern const int tetra_node_to_side_table[2][12]  = {
//       1      2      3      4                                   node 1
      {2,3,4, 1,3,4, 4,1,2, 1,2,3},                            // node 2
      {1,4,3, 4,2,1, 2,3,4, 1,2,3}                             // side #
};

extern const int wedge_node_to_side_table[2][18]  = {
//       1      2      3      4      5      6                     node 1
      {2,4,3, 5,1,3, 6,1,2, 1,6,5, 6,2,4, 4,3,5},              // node 2
      {1,3,4, 1,4,2, 2,3,4, 1,3,5, 5,2,1, 5,3,2}               // side #
};

extern const int hex_node_to_side_table[2][24]  = {
//       1      2      3      4      5      6      7      8       node 1
      {4,2,5, 1,3,6, 7,4,2, 3,1,8, 6,8,1, 5,2,7, 8,6,3, 7,5,4},// node 2
      {5,1,4, 5,2,1, 2,3,5, 5,4,3, 6,4,1, 1,2,6, 6,2,3, 3,6,4} // side #
};

/* side to node translation tables -
 *   These tables are used to look up the side number based on the
 *   first and second node in the side/face list. The side node order
 *   is found in the original Exodus document, SAND87-2997. The element
 *   node order is found in the ExodusII document, SAND92-2137. These
 *   tables were generated by following the right-hand rule for determining
 *   the outward normal.
 */

extern const int tri_side_to_node_table[3][3] = {
//     1        2        3                                                side
    {1,2,4}, {2,3,5}, {3,1,6}                                          // nodes
};

extern const int quad_side_to_node_table[4][3] = {
//     1        2        3        4                                       side
    {1,2,5}, {2,3,6}, {3,4,7}, {4,1,8}                                 // nodes
};
 
extern const int shell_side_to_node_table[2][8] = {
//          1                  2                                          side
    {1,2,3,4,5,6,7,8}, {1,4,3,2,8,7,6,5}                               // nodes
};
 
extern const int tetra_side_to_node_table[4][7] = {
//        1                2                 3                 4          side
    {1,2,4,5,9,8,13}, {2,3,4,6,10,9,14}, {1,4,3,8,10,7,15}, {1,3,2,7,6,5,12}       // nodes
}; 
    
extern const int wedge_side_to_node_table[5][8] = {
//          1                     2                     3                 side
    {1,2,5,4,7,11,13,10}, {2,3,6,5,8,12,14,11}, {1,4,6,3,10,15,12,9},  // nodes
//          4                  5                                          side
    {1,3,2,0,9,8,7,0}, {4,5,6,0,13,14,15,0}                            // nodes
};
 
extern const int hex_side_to_node_table[6][8] = {
//          1                     2                      3                side
    {1,2,6,5,9,14,17,13}, {2,3,7,6,10,15,18,14}, {3,4,8,7,11,16,19,15},// nodes
//          4                     5                      6                side
    {1,5,8,4,13,20,16,12},{1,4,3,2,12,11,10,9},  {5,6,7,8,17,18,19,20} // nodes  
};

extern const int face_bit_mask[6] = {1, 2, 4, 8, 16, 32};
 
const char* Element_Type_Names[NUM_ELEMENT_TYPES] = {
                                                "UNKNOWN_ELEMENT",
                                                "CIRCLE",
                                                "SPHERE",
                                                "QUAD4",
                                                "QUAD8",
                                                "QUAD9",
                                                "TRI3",
                                                "TRI6",
                                                "TRI7",
                                                "SHELL4",
                                                "SHELL8",
                                                "HEX8",
                                                "HEX20",
                                                "HEX27",
                                                "TET4",
                                                "TET8",
                                                "TET10",
                                                "TET15",
                                                "WEDGE6",
                                                "WEDGE18",
                                                "BEAM2",
                                                "BEAM3",
                                                "TRUSS2",
                                                "TRUSS3",
                                                "STRUCT1D",
                                                "STRUCT2D",
                                                "STRUCT3D",
                                                "SFACET3D",
                                                "PYRAMID5",
                                                "SEG2",
                                                "SEG3" };

} // end namespace PAMGEN_NEVADA {

