(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    155375,       3065]
NotebookOptionsPosition[    153028,       2982]
NotebookOutlinePosition[    153388,       2998]
CellTagsIndexPosition[    153345,       2995]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"x1", "[", "t_", "]"}], " ", ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"t", "-", "0.05"}], ")"}], "/", "0.02"}], "]"}], "+", "1"}], 
     ")"}], "/", "2"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Tanh", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"t", "-", "0.25"}], ")"}], "/", "0.15"}], "]"}], "-", 
        "1"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "/", "0.8"}], ")"}]}], "+", "0.2"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.580752004412757*^9, 3.580752103202203*^9}, {
  3.580752171305957*^9, 3.580752222609702*^9}, {3.580752312242154*^9, 
  3.580752313648488*^9}, {3.5807523477363863`*^9, 3.580752348133786*^9}, {
  3.580752390879958*^9, 3.580752391767249*^9}, {3.580752427637784*^9, 
  3.580752501116292*^9}, {3.580752536956726*^9, 3.580752585363427*^9}, {
  3.5807526638245153`*^9, 3.580752665338571*^9}, {3.580753054111665*^9, 
  3.5807530888798637`*^9}, {3.5807531338732147`*^9, 3.580753134071847*^9}, {
  3.581100697244295*^9, 3.5811007193020067`*^9}, {3.581100763125119*^9, 
  3.581100800811627*^9}, {3.585413975107188*^9, 3.585413975651729*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"x1", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", " ", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.580751959116416*^9, 3.58075197468567*^9}, {
  3.5807521323042917`*^9, 3.5807521567613573`*^9}, {3.58075230372132*^9, 
  3.580752334375638*^9}, {3.5807524104647703`*^9, 3.580752412573423*^9}, {
  3.58541398018079*^9, 3.585413980689952*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c81d8fB3BJkcoupSE0kJUkLa9C2aIUSkhKSRnRUGkZJVGZX5G9iexN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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.580751979624938*^9, 3.580752019476227*^9, {3.5807520613494587`*^9, 
   3.580752105785049*^9}, {3.580752146300036*^9, 3.580752158285748*^9}, {
   3.5807521984821033`*^9, 3.580752231140465*^9}, {3.580752305598843*^9, 
   3.580752350399807*^9}, {3.580752395020825*^9, 3.580752504448967*^9}, 
   3.580752556283455*^9, 3.580752588017646*^9, 3.580752672895823*^9, 
   3.580753063402336*^9, 3.580753094099453*^9, 3.580753137934491*^9, {
   3.580755703054798*^9, 3.5807557342209253`*^9}, 3.580755789117435*^9, 
   3.580755834362371*^9, {3.5807558935912123`*^9, 3.580755942899684*^9}, 
   3.5807560078398046`*^9, 3.580756960802745*^9, 3.5807571228017693`*^9, 
   3.580757537815143*^9, 3.58075808396738*^9, 3.5808089665539923`*^9, 
   3.5808090193933163`*^9, {3.581100702874085*^9, 3.581100723948579*^9}, {
   3.5811007668932962`*^9, 3.58110080456533*^9}, 3.581101412470778*^9, 
   3.58110231057283*^9, 3.5811024212196283`*^9, 3.581778270586213*^9, 
   3.581780870512804*^9, 3.585411275907765*^9, 3.585414144414916*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x2", "[", "t_", "]"}], " ", ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Tanh", "[", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"Log10", "[", "t", "]"}], "/", "10"}], "+", "1"}], ")"}],
           "-", "0.1"}], ")"}], "/", "0.02"}], "]"}], "+", "1"}], ")"}], "/", 
    "2"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Tanh", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{
              RowBox[{
               RowBox[{"Log10", "[", "t", "]"}], "/", "10"}], "+", "1"}], 
             ")"}], "-", "0.25"}], ")"}], "/", "0.15"}], "]"}], "-", "1"}], 
       ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "2"}], "/", "0.8"}], ")"}]}], "+", "0.2"}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQBmIQneCmtGLf2leOWzbdXgWid8y7uQFEH3Ku3wiiU80f
bAfRJwyeHALRTNrVv0C0RuRVMH1KaQLrfiDtrruME0TvrIsTBtEJwtJiIPqv
wldlEL0hPFEfRO8JO20Mok+wZlqDaKOihGkg+tXrs2A6bP2EbSD6RkvzDhCt
FbZrL4jOMz68H0SXqT2+C6L5IvkegehdKROegWgPn8MvwOrYe96B6KLDM8E0
m8CHzyBaqePrbxC9Lqk3M2PdK8e2KL4sEC3knZAHoiOcU8B0cOWfIhB9gce7
AkQb+NjnLNr2yvGHxMJ8EA0AGXWtDg==
  "]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x2", "[", "t", "]"}], "//", "Simplify"}]], "Input",
 CellChangeTimes->{{3.580755179591853*^9, 3.580755189968231*^9}, {
  3.5854139906435204`*^9, 3.585414016368482*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.2`"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1.5000000000000002`"}], "+", 
    RowBox[{"1.`", " ", 
     RowBox[{"Tanh", "[", 
      RowBox[{"5.`", "\[VeryThinSpace]", "+", 
       RowBox[{"0.28952965460216784`", " ", 
        RowBox[{"Log", "[", "t", "]"}]}]}], "]"}]}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1.`", "\[VeryThinSpace]", "+", 
    RowBox[{"Tanh", "[", 
     RowBox[{"44.99999999999999`", "\[VeryThinSpace]", "+", 
      RowBox[{"2.1714724095162588`", " ", 
       RowBox[{"Log", "[", "t", "]"}]}]}], "]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{
  3.580755192278996*^9, {3.580755386524068*^9, 3.5807553986990347`*^9}, {
   3.580755442306794*^9, 3.580755456883688*^9}, {3.5807557031271143`*^9, 
   3.580755734287054*^9}, 3.58075578917715*^9, 3.580755834441173*^9, {
   3.580755893649337*^9, 3.580755942966137*^9}, 3.5807560079052277`*^9, 
   3.580756960885498*^9, 3.58075712288846*^9, 3.580757537899744*^9, 
   3.5807580840497637`*^9, 3.580808966659606*^9, 3.580809019476136*^9, 
   3.5811008896485558`*^9, 3.581100924499188*^9, {3.581100956828726*^9, 
   3.5811009982737627`*^9}, 3.5811013170974007`*^9, 3.581101412572569*^9, 
   3.581102310654087*^9, 3.581102421305415*^9, 3.5817782707350607`*^9, 
   3.581780870605487*^9, 3.5854112760373077`*^9, 3.585414144489435*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLinearPlot", "[", 
  RowBox[{
   RowBox[{"x2", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.00000000001", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.580753261805335*^9, 3.5807532629973383`*^9}, {
  3.580755139643799*^9, 3.580755139801734*^9}, {3.585413998241819*^9, 
  3.585414019840716*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1nc4le8bAPDISiohsvfezlS8D2WlUslqaCAZhaLIiEik7JWWlRHZM9K5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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{-25.328436022934504`, 0.},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Part[#, 2]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Part[#, 2]}& )},
  FrameTicks->{{Automatic, Automatic}, {{{-25.328436022934504`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-20.72326583694641, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-16.11809565095832, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-11.512925464970229`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-6.907755278982137, 
       FormBox["0.001`", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["0.1`", TraditionalForm]}, {-22.843529373146502`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-22.192941807005354`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-21.80207549831834, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-21.521773533164183`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-21.303084332199354`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-21.123743403543536`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-20.97172719624491, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-20.839799653202363`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.238359187158412`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-17.58777162101726, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-17.196905312330248`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.916603347176093`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.69791414621126, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.518573217555446`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.36655701025682, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.234629467214273`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.633189001170319`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.98260143502917, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.591735126342158`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.311433161188, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.09274396022317, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.913403031567354`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.761386824268728`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.629459281226179`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.028018815182229, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.377431249041079, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.986564940354067, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.706262975199909, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.487573774235079, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.308232845579262, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.156216638280637, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.024289095238088, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.422848629194137, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.7722610630529876`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.3813947543659757`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.101092789211817, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.882403588246988, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.703062659591171, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.551046452292545, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.419118909249997, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-25.328436022934504`, 
       FormBox["\"\"", TraditionalForm]}, {-20.72326583694641, 
       FormBox["\"\"", TraditionalForm]}, {-16.11809565095832, 
       FormBox["\"\"", TraditionalForm]}, {-11.512925464970229`, 
       FormBox["\"\"", TraditionalForm]}, {-6.907755278982137, 
       FormBox["\"\"", TraditionalForm]}, {-2.3025850929940455`, 
       FormBox["\"\"", TraditionalForm]}, {-22.843529373146502`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-22.192941807005354`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-21.80207549831834, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-21.521773533164183`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-21.303084332199354`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-21.123743403543536`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-20.97172719624491, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-20.839799653202363`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.238359187158412`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-17.58777162101726, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-17.196905312330248`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.916603347176093`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.69791414621126, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.518573217555446`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.36655701025682, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-16.234629467214273`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.633189001170319`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.98260143502917, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.591735126342158`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.311433161188, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-12.09274396022317, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.913403031567354`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.761386824268728`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.629459281226179`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.028018815182229, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-8.377431249041079, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.986564940354067, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.706262975199909, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.487573774235079, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.308232845579262, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.156216638280637, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-7.024289095238088, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.422848629194137, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.7722610630529876`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.3813947543659757`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-3.101092789211817, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.882403588246988, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.703062659591171, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.551046452292545, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.419118909249997, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{-25.328436022934504`, 0}, {0., 0.8347766149206788}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{{{-25.328436022934504`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-20.72326583694641, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "9"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-16.11809565095832, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "7"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-11.512925464970229`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "5"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-6.907755278982137, 
      FormBox["0.001`", TraditionalForm]}, {-2.3025850929940455`, 
      FormBox["0.1`", TraditionalForm]}, {-22.843529373146502`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-22.192941807005354`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-21.80207549831834, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-21.521773533164183`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-21.303084332199354`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-21.123743403543536`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-20.97172719624491, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-20.839799653202363`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-18.238359187158412`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-17.58777162101726, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-17.196905312330248`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-16.916603347176093`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-16.69791414621126, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-16.518573217555446`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-16.36655701025682, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-16.234629467214273`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-13.633189001170319`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-12.98260143502917, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-12.591735126342158`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-12.311433161188, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-12.09274396022317, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-11.913403031567354`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-11.761386824268728`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-11.629459281226179`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.028018815182229, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-8.377431249041079, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.986564940354067, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.706262975199909, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.487573774235079, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.308232845579262, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.156216638280637, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-7.024289095238088, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.422848629194137, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.7722610630529876`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.3813947543659757`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-3.101092789211817, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.882403588246988, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.703062659591171, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.551046452292545, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.419118909249997, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}, Automatic}]], "Output",
 CellChangeTimes->{
  3.5807532650851583`*^9, 3.580753298758851*^9, 3.580753395904469*^9, 
   3.5807534363670397`*^9, 3.580754002486109*^9, 3.580754404984429*^9, {
   3.580755129394383*^9, 3.5807551412315073`*^9}, {3.5807553918833723`*^9, 
   3.580755401443686*^9}, {3.5807554442273827`*^9, 3.580755458408538*^9}, {
   3.58075570319905*^9, 3.5807557343637114`*^9}, 3.580755789254932*^9, 
   3.580755834510584*^9, {3.580755893720677*^9, 3.580755943035685*^9}, 
   3.580756007976036*^9, 3.58075696095532*^9, 3.58075712295894*^9, 
   3.5807575380075493`*^9, 3.5807580841235313`*^9, 3.580808966780727*^9, 
   3.580809019613448*^9, 3.581100893917624*^9, 3.5811009275446663`*^9, {
   3.581100962756482*^9, 3.58110100195704*^9}, 3.5811013194616547`*^9, 
   3.581101412754854*^9, 3.5811023107314053`*^9, 3.581102421384273*^9, 
   3.581778270832568*^9, 3.5817808707012997`*^9, 3.585411276113248*^9, 
   3.585414144565549*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"x2", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.580755561698144*^9, 3.58075557564819*^9}, {
  3.580755633865802*^9, 3.580755634244999*^9}, {3.5854140041472*^9, 
  3.585414024897931*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1Hc41f8XAHAVpRISFV2hUMlqGF+lIxRdqp9VEbJKGRkNqxIRFVEJ6dpb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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.5807555644879017`*^9, 3.580755588306725*^9}, 
   3.5807556360748158`*^9, {3.580755703243639*^9, 3.580755734444921*^9}, 
   3.580755789331723*^9, 3.58075583455888*^9, {3.580755893762686*^9, 
   3.580755943107727*^9}, 3.580756008055963*^9, 3.580756961037512*^9, 
   3.5807571230513973`*^9, 3.580757538069974*^9, 3.5807580842170897`*^9, 
   3.5808089668486967`*^9, 3.580809019686051*^9, 3.5811010131544847`*^9, 
   3.581101412813642*^9, 3.581102310837344*^9, 3.5811024214696407`*^9, 
   3.581778270931335*^9, 3.58178087079757*^9, 3.5854112761648827`*^9, 
   3.585414144612926*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x3", "[", "t_", "]"}], ":=", 
  RowBox[{
   RowBox[{"-", "0.2"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1.5"}], "+", " ", 
     RowBox[{"Tanh", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1.3", "+", 
         RowBox[{"0.08", " ", 
          RowBox[{"Log", "[", "t", "]"}]}]}], ")"}], "/", "0.3"}], "]"}]}], 
    ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "\[VeryThinSpace]", "+", 
     RowBox[{"Tanh", "[", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"0.8", "\[VeryThinSpace]", "+", 
         RowBox[{"0.04", " ", 
          RowBox[{"Log", "[", "t", "]"}]}]}], ")"}], "/", "0.02"}], "]"}]}], 
    ")"}]}]}]], "Input",
 CellChangeTimes->{{3.5807560352120247`*^9, 3.580756094255912*^9}, {
   3.580756125397533*^9, 3.58075614491755*^9}, {3.580756182958461*^9, 
   3.580756183173799*^9}, {3.580756237244499*^9, 3.580756244293152*^9}, {
   3.580756449802987*^9, 3.5807564912398853`*^9}, {3.58075654324652*^9, 
   3.580756638277091*^9}, {3.580756720585328*^9, 3.580756722545632*^9}, {
   3.5807569780157137`*^9, 3.580756990471532*^9}, {3.580757112829767*^9, 
   3.5807571385737743`*^9}, {3.581101041637302*^9, 3.5811010702846823`*^9}, {
   3.5811011058276033`*^9, 3.581101129091095*^9}, {3.581101168594153*^9, 
   3.5811011688948507`*^9}, 3.5811012211793013`*^9, {3.581101285958799*^9, 
   3.581101286168796*^9}, {3.581101372846857*^9, 3.581101372939999*^9}, {
   3.581101438135128*^9, 3.5811014588131533`*^9}, {3.581101498732315*^9, 
   3.581101531499296*^9}, {3.5811015723730507`*^9, 3.581101599345087*^9}, {
   3.58541332255971*^9, 3.5854133231358213`*^9}, {3.585414031463974*^9, 
   3.585414033185906*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x3", "[", "t", "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.580757044916828*^9, 3.580757067077897*^9}, {
  3.585413328502833*^9, 3.5854133295326157`*^9}, {3.585414036071864*^9, 
  3.585414037951809*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.2`"}], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", "1.5`"}], "+", 
    RowBox[{"Tanh", "[", 
     RowBox[{"4.333333333333334`", "\[VeryThinSpace]", "+", 
      RowBox[{"0.26666666666666666`", " ", 
       RowBox[{"Log", "[", "t", "]"}]}]}], "]"}]}], ")"}], " ", 
  RowBox[{"(", 
   RowBox[{"1", "+", 
    RowBox[{"Tanh", "[", 
     RowBox[{"40.`", "\[VeryThinSpace]", "+", 
      RowBox[{"2.`", " ", 
       RowBox[{"Log", "[", "t", "]"}]}]}], "]"}]}], ")"}]}]], "Output",
 CellChangeTimes->{{3.581101507991509*^9, 3.5811015349597063`*^9}, {
   3.581101578205556*^9, 3.581101603033988*^9}, 3.581102310926264*^9, 
   3.5811024215619*^9, 3.5817782711360292`*^9, 3.5817808709142647`*^9, 
   3.5854112764195127`*^9, 3.58541329908389*^9, 3.585413450585107*^9, 
   3.585413677063532*^9, 3.585414144714411*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLinearPlot", "[", 
  RowBox[{
   RowBox[{"x3", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.00000000001", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.0000000001", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.580756258356675*^9, 3.58075625844341*^9}, {
  3.580756858447241*^9, 3.5807569068887167`*^9}, {3.580756946952095*^9, 
  3.58075694853261*^9}, {3.585413337023106*^9, 3.5854133374634933`*^9}, {
  3.585414042625396*^9, 3.585414042713657*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8Vf8bAHAJId+SZGTvmXG36HwoIypJkdBCZTTMjJKVjGwiLZsiuyTh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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{-23.025850929940457`, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Part[#, 2]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Part[#, 2]}& )},
  FrameTicks->{{Automatic, Automatic}, {{{-23.025850929940457`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "10"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-18.420680743952367`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-13.815510557964274`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-9.210340371976182, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-4.605170185988091, 
       FormBox["0.01`", TraditionalForm]}, {0., 
       FormBox["1", TraditionalForm]}, {-20.540944280152456`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.890356714011308`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.499490405324295`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.219188440170136`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.000499239205308`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.821158310549492`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.669142103250866`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.537214560208316`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.935774094164366`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.285186528023216`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.894320219336205`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.614018254182046`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.395329053217216`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.215988124561399`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.063971917262773`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.932044374220226`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.330603908176274`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.680016342035124`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.289150033348113`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.008848068193954`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.790158867229126, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.610817938573309, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.458801731274683, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.326874188232134, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.725433722188183, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.074846156047033, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.683979847360021, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.403677882205863, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.184988681241033, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.005647752585217, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.853631545286591, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.721704002244043, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.120263536200091, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.4696759700589417`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.07880966137193, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.7985076962177716, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.579818495252942, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.40047756659712525`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2484613592984996, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.11653381625595151`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-23.025850929940457`, 
       FormBox["\"\"", TraditionalForm]}, {-18.420680743952367`, 
       FormBox["\"\"", TraditionalForm]}, {-13.815510557964274`, 
       FormBox["\"\"", TraditionalForm]}, {-9.210340371976182, 
       FormBox["\"\"", TraditionalForm]}, {-4.605170185988091, 
       FormBox["\"\"", TraditionalForm]}, {0., 
       FormBox["\"\"", TraditionalForm]}, {-20.540944280152456`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.890356714011308`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.499490405324295`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.219188440170136`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.000499239205308`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.821158310549492`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.669142103250866`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.537214560208316`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.935774094164366`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.285186528023216`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.894320219336205`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.614018254182046`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.395329053217216`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.215988124561399`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.063971917262773`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.932044374220226`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.330603908176274`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.680016342035124`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.289150033348113`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.008848068193954`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.790158867229126, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.610817938573309, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.458801731274683, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.326874188232134, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.725433722188183, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.074846156047033, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.683979847360021, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.403677882205863, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.184988681241033, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.005647752585217, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.853631545286591, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.721704002244043, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.120263536200091, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.4696759700589417`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.07880966137193, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.7985076962177716, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.579818495252942, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.40047756659712525`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2484613592984996, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.11653381625595151`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{-23.025850929940457`, 0.}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{None, None}, {None, None}},
  Ticks->{{{-23.025850929940457`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "10"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-18.420680743952367`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-13.815510557964274`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-9.210340371976182, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-4.605170185988091, 
      FormBox["0.01`", TraditionalForm]}, {0., 
      FormBox["1", TraditionalForm]}, {-20.540944280152456`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-19.890356714011308`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-19.499490405324295`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-19.219188440170136`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-19.000499239205308`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-18.821158310549492`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-18.669142103250866`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-18.537214560208316`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-15.935774094164366`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-15.285186528023216`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.894320219336205`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.614018254182046`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.395329053217216`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.215988124561399`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.063971917262773`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-13.932044374220226`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-11.330603908176274`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.680016342035124`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.289150033348113`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.008848068193954`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.790158867229126, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.610817938573309, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.458801731274683, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.326874188232134, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-6.725433722188183, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-6.074846156047033, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.683979847360021, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.403677882205863, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.184988681241033, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.005647752585217, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.853631545286591, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.721704002244043, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.120263536200091, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.4696759700589417`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.07880966137193, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.7985076962177716, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.579818495252942, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.40047756659712525`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.2484613592984996, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.11653381625595151`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}, Automatic}]], "Output",
 CellChangeTimes->{
  3.580756260221982*^9, 3.580756600001751*^9, 3.5807567265984488`*^9, {
   3.580756871415565*^9, 3.5807569078354797`*^9}, {3.580756950343389*^9, 
   3.580757006025198*^9}, {3.5807571232086897`*^9, 3.580757146134426*^9}, 
   3.580757538249*^9, 3.580758084383215*^9, 3.5808089670677156`*^9, 
   3.580809019861514*^9, 3.581101232899035*^9, 3.5811012939225492`*^9, 
   3.581101382779789*^9, 3.581101412968754*^9, {3.5811014471690073`*^9, 
   3.581101468378566*^9}, {3.5811015161220827`*^9, 3.581101537754259*^9}, {
   3.5811015810572777`*^9, 3.581101607157467*^9}, 3.581102311002199*^9, 
   3.581102421635962*^9, 3.581778271232555*^9, 3.581780871005352*^9, 
   3.585411276490902*^9, 3.585413299157342*^9, 3.585413450657484*^9, 
   3.5854136771366463`*^9, 3.5854141447871637`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"x3", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.580756281420579*^9, 3.5807562815463543`*^9}, {
  3.58541334184628*^9, 3.5854133423113127`*^9}, {3.585414047122076*^9, 
  3.585414047185565*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1Xk01tkfB3BiJtVkCYUeawgJGVti3qaSsvQrtMiSrUQJRZspS4wWT9ZQ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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.580756283733034*^9, 3.580756961211357*^9, 
  3.580757123275943*^9, 3.580757158099588*^9, 3.580757538300544*^9, 
  3.5807580844355783`*^9, 3.58080896716492*^9, 3.580809019934916*^9, 
  3.5811014130103703`*^9, 3.581101632064217*^9, 3.5811023110562677`*^9, 
  3.581102421688251*^9, 3.581778271384809*^9, 3.581780871068738*^9, 
  3.585411276569702*^9, 3.585413299217709*^9, 3.585413450709154*^9, 
  3.585413677192172*^9, 3.5854141448446407`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x4", "[", "t_", "]"}], ":=", 
  RowBox[{
   RowBox[{"-", "0.2"}], 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1.5"}], "+", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1.3", "\[VeryThinSpace]", "+", 
            RowBox[{"0.08", " ", 
             RowBox[{"Log", "[", "t", "]"}]}]}], ")"}], "/", "0.3"}], "]"}], 
        "-", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1.3", "\[VeryThinSpace]", "+", 
             RowBox[{"0.08", " ", 
              RowBox[{"Log", "[", "t", "]"}]}]}], ")"}]}], "/", "0.3"}], 
         "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1.3", "\[VeryThinSpace]", "+", 
            RowBox[{"0.08", " ", 
             RowBox[{"Log", "[", "t", "]"}]}]}], ")"}], "/", "0.3"}], "]"}], 
        "+", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"1.3", "\[VeryThinSpace]", "+", 
             RowBox[{"0.08", " ", 
              RowBox[{"Log", "[", "t", "]"}]}]}], ")"}]}], "/", "0.3"}], 
         "]"}]}], ")"}]}]}], ")"}], 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"0.8", "\[VeryThinSpace]", "+", 
            RowBox[{"0.04", " ", 
             RowBox[{"Log", "[", "t", "]"}]}]}], ")"}], "/", "0.02"}], "]"}], 
        "-", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"0.8", "\[VeryThinSpace]", "+", 
             RowBox[{"0.04", " ", 
              RowBox[{"Log", "[", "t", "]"}]}]}], ")"}]}], "/", "0.02"}], 
         "]"}]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"0.8", "\[VeryThinSpace]", "+", 
            RowBox[{"0.04", " ", 
             RowBox[{"Log", "[", "t", "]"}]}]}], ")"}], "/", "0.02"}], "]"}], 
        "+", 
        RowBox[{"Exp", "[", 
         RowBox[{
          RowBox[{"-", 
           RowBox[{"(", 
            RowBox[{"0.8", "\[VeryThinSpace]", "+", 
             RowBox[{"0.04", " ", 
              RowBox[{"Log", "[", "t", "]"}]}]}], ")"}]}], "/", "0.02"}], 
         "]"}]}], ")"}]}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.580757231833193*^9, 3.5807573985339203`*^9}, {
  3.5811016591341953`*^9, 3.581101696242104*^9}, {3.585413374529559*^9, 
  3.58541337568084*^9}, {3.5854140519662437`*^9, 3.58541405203907*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x4", "[", "t", "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.580757427598435*^9, 3.5807574277489862`*^9}, {
  3.585413380277954*^9, 3.585413380605723*^9}, {3.5854140554579906`*^9, 
  3.585414055531002*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{
   RowBox[{"0.00017223225596080987`", " ", 
    SuperscriptBox["t", "4.`"]}], "+", 
   RowBox[{"0.2`", " ", 
    SuperscriptBox["t", "4.533333333333333`"]}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"0.00017223225596080984`", "\[VeryThinSpace]", "+", 
     RowBox[{"1.`", " ", 
      SuperscriptBox["t", "0.5333333333333333`"]}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1.804851387845415`*^-35", "+", 
     RowBox[{"1.`", " ", 
      SuperscriptBox["t", "4.`"]}]}], ")"}]}]]], "Output",
 CellChangeTimes->{3.580757429954485*^9, 3.580757538367342*^9, 
  3.580758084502384*^9, 3.580808967255992*^9, 3.580809020011508*^9, 
  3.581101413064457*^9, 3.581101757662773*^9, 3.581102311122486*^9, 
  3.581102421754806*^9, 3.581778271481805*^9, 3.581780871160058*^9, 
  3.585411276643531*^9, 3.585413299296709*^9, 3.585413450768783*^9, 
  3.5854136772727213`*^9, 3.585414144909103*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x5", "[", "t_", "]"}], ":=", 
  RowBox[{"1.4", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"0.0001", " ", 
       SuperscriptBox["t", "4"]}], "+", 
      RowBox[{"0.1", 
       SuperscriptBox["t", 
        RowBox[{"9", "/", "2"}]]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"0.0001", "+", 
        SuperscriptBox["t", 
         RowBox[{"1", "/", "2"}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"10", "^", 
         RowBox[{"-", "36"}]}], "+", " ", 
        SuperscriptBox["t", "4"]}], ")"}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.581101977610181*^9, 3.581101998605035*^9}, {
  3.581102062641466*^9, 3.581102150078186*^9}, {3.581102185157133*^9, 
  3.5811022271662397`*^9}, {3.581102274013789*^9, 3.581102274125328*^9}, {
  3.5811023577006702`*^9, 3.5811023961469383`*^9}, {3.585411567939103*^9, 
  3.5854115680553493`*^9}, {3.585411655697714*^9, 3.585411741237236*^9}, {
  3.585411793518104*^9, 3.58541179494907*^9}, {3.5854119093551397`*^9, 
  3.585411990705216*^9}, {3.5854120352509317`*^9, 3.5854120355444603`*^9}, {
  3.585412314532691*^9, 3.585412358476475*^9}, {3.585412388892747*^9, 
  3.585412460568041*^9}, {3.5854125744401293`*^9, 3.58541261978925*^9}, {
  3.58541339768477*^9, 3.585413399061494*^9}, {3.585414061417448*^9, 
  3.585414061494726*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LogLinearPlot", "[", 
  RowBox[{
   RowBox[{"x5", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.00000000001", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0.0000000001", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.580807183825584*^9, 3.580807184017147*^9}, {
   3.580807993511723*^9, 3.580808002142817*^9}, {3.580808977298156*^9, 
   3.580808990963481*^9}, 3.580809955115676*^9, 3.5808100075127*^9, {
   3.581099974894414*^9, 3.5810999905222588`*^9}, {3.5811000535699463`*^9, 
   3.5811000760098267`*^9}, 3.5811003024996767`*^9, 3.581100339040888*^9, {
   3.5811004716403713`*^9, 3.581100484015877*^9}, {3.5811020207620993`*^9, 
   3.581102021633669*^9}, {3.585412370488617*^9, 3.585412370601851*^9}, {
   3.585412625933969*^9, 3.585412626077777*^9}, {3.585413402987379*^9, 
   3.5854134036610737`*^9}, {3.5854140645369596`*^9, 3.585414064619069*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV13c8Vf8bAHAzkm/JJnuvhDtF50NWGrJaSFaFIpFIkpGdkRktErKzSon7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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{-23.025850929940457`, 0},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Part[#, 2]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Part[#, 2]}& )},
  FrameTicks->{{Automatic, Automatic}, {{{-23.025850929940457`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "10"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-18.420680743952367`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-13.815510557964274`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-9.210340371976182, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm]}, {-4.605170185988091, 
       FormBox["0.01`", TraditionalForm]}, {0., 
       FormBox["1", TraditionalForm]}, {-20.540944280152456`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.890356714011308`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.499490405324295`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.219188440170136`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.000499239205308`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.821158310549492`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.669142103250866`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.537214560208316`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.935774094164366`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.285186528023216`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.894320219336205`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.614018254182046`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.395329053217216`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.215988124561399`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.063971917262773`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.932044374220226`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.330603908176274`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.680016342035124`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.289150033348113`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.008848068193954`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.790158867229126, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.610817938573309, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.458801731274683, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.326874188232134, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.725433722188183, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.074846156047033, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.683979847360021, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.403677882205863, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.184988681241033, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.005647752585217, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.853631545286591, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.721704002244043, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.120263536200091, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.4696759700589417`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.07880966137193, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.7985076962177716, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.579818495252942, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.40047756659712525`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2484613592984996, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.11653381625595151`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}, {{-23.025850929940457`, 
       FormBox["\"\"", TraditionalForm]}, {-18.420680743952367`, 
       FormBox["\"\"", TraditionalForm]}, {-13.815510557964274`, 
       FormBox["\"\"", TraditionalForm]}, {-9.210340371976182, 
       FormBox["\"\"", TraditionalForm]}, {-4.605170185988091, 
       FormBox["\"\"", TraditionalForm]}, {0., 
       FormBox["\"\"", TraditionalForm]}, {-20.540944280152456`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.890356714011308`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.499490405324295`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.219188440170136`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-19.000499239205308`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.821158310549492`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.669142103250866`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-18.537214560208316`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.935774094164366`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-15.285186528023216`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.894320219336205`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.614018254182046`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.395329053217216`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.215988124561399`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-14.063971917262773`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-13.932044374220226`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-11.330603908176274`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.680016342035124`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.289150033348113`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-10.008848068193954`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.790158867229126, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.610817938573309, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.458801731274683, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-9.326874188232134, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.725433722188183, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-6.074846156047033, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.683979847360021, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.403677882205863, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.184988681241033, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-5.005647752585217, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.853631545286591, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-4.721704002244043, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-2.120263536200091, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.4696759700589417`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-1.07880966137193, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.7985076962177716, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.579818495252942, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.40047756659712525`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.2484613592984996, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}, {-0.11653381625595151`, 
       FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
        Thickness[0.001]}}}}},
  GridLines->{None, None},
  Method->{},
  PlotRange->{{-23.025850929940457`, 0.}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{None, None}, {None, None}},
  Ticks->{{{-23.025850929940457`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "10"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-18.420680743952367`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "8"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-13.815510557964274`, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-9.210340371976182, 
      FormBox[
       TemplateBox[{"10", 
         RowBox[{"-", "4"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
       TraditionalForm]}, {-4.605170185988091, 
      FormBox["0.01`", TraditionalForm]}, {0., 
      FormBox["1", TraditionalForm]}, {-20.540944280152456`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-19.890356714011308`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-19.499490405324295`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-19.219188440170136`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-19.000499239205308`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-18.821158310549492`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-18.669142103250866`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-18.537214560208316`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-15.935774094164366`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-15.285186528023216`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.894320219336205`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.614018254182046`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.395329053217216`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.215988124561399`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-14.063971917262773`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-13.932044374220226`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-11.330603908176274`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.680016342035124`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.289150033348113`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-10.008848068193954`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.790158867229126, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.610817938573309, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.458801731274683, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-9.326874188232134, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-6.725433722188183, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-6.074846156047033, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.683979847360021, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.403677882205863, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.184988681241033, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-5.005647752585217, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.853631545286591, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-4.721704002244043, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-2.120263536200091, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.4696759700589417`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-1.07880966137193, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.7985076962177716, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.579818495252942, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.40047756659712525`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.2484613592984996, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}, {-0.11653381625595151`, 
      FormBox["\"\"", TraditionalForm], {0.00375, 0.}, {
       Thickness[0.001]}}}, Automatic}]], "Output",
 CellChangeTimes->{{3.580807186274766*^9, 3.5808072151978693`*^9}, {
   3.58080725837794*^9, 3.580807272270656*^9}, 3.580807309955657*^9, {
   3.580807967346208*^9, 3.580808032264966*^9}, 3.580808103784309*^9, {
   3.580808137963266*^9, 3.580808191782155*^9}, 3.580808542401724*^9, 
   3.580808651983716*^9, 3.580808805281948*^9, {3.580808967962061*^9, 
   3.580809020702903*^9}, {3.580809945674746*^9, 3.58080995746273*^9}, {
   3.580810002451107*^9, 3.5808100087615957`*^9}, {3.5810999686423063`*^9, 
   3.5810999848252172`*^9}, {3.581100027280004*^9, 3.581100101028406*^9}, 
   3.58110024780663*^9, {3.581100295925152*^9, 3.581100303814679*^9}, {
   3.5811003357209063`*^9, 3.581100351364148*^9}, {3.581100466831936*^9, 
   3.581100485787485*^9}, 3.5811014138181353`*^9, {3.5811020172105417`*^9, 
   3.581102022955647*^9}, 3.5811020670033817`*^9, {3.581102104507341*^9, 
   3.581102155295917*^9}, {3.581102193794778*^9, 3.581102231715404*^9}, 
   3.581102278601493*^9, 3.581102311830402*^9, {3.581102369442631*^9, 
   3.581102422383999*^9}, 3.58177827223495*^9, 3.58178087191859*^9, 
   3.585411277354575*^9, 3.585411572348529*^9, {3.585411685518187*^9, 
   3.585411743605143*^9}, 3.585411853143984*^9, {3.585411915909255*^9, 
   3.5854119929809923`*^9}, {3.585412308547826*^9, 3.585412419033955*^9}, {
   3.5854124492103653`*^9, 3.58541246337018*^9}, {3.585412584055418*^9, 
   3.585412627307852*^9}, 3.585413299406764*^9, 3.585413450883418*^9, 
   3.585413677380422*^9, 3.585414145039651*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"x5", "[", "t", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.580808831161529*^9, 3.580808867727618*^9}, {
  3.585413408773316*^9, 3.58541341009923*^9}, {3.585414068366971*^9, 
  3.585414068448317*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwV1Xc41usbAHCRaJkRSlI4qTfkV1Fx7kLIqoxKRkQI2RlJKKMSrTccyd5C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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0, 1}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.5808088337596893`*^9, 3.580808868322196*^9}, 
   3.5808089679966784`*^9, 3.5808090207477694`*^9, 3.581101413867078*^9, 
   3.5811020436959763`*^9, {3.581102304176489*^9, 3.5811023119104156`*^9}, 
   3.5811024224568243`*^9, 3.581778272289077*^9, 3.581780871967498*^9, 
   3.585411277396617*^9, 3.585413299456115*^9, 3.5854134509403267`*^9, 
   3.585413677439533*^9, 3.585414145095648*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"x6", "[", "t_", "]"}], ":=", 
  RowBox[{"a", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"b", " ", 
       SuperscriptBox["t", "4"]}], "+", 
      RowBox[{"c", " ", 
       SuperscriptBox["t", 
        RowBox[{"9", "/", "2"}]]}]}], ")"}], "/", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "+", 
        SuperscriptBox["t", 
         RowBox[{"1", "/", "2"}]]}], ")"}], " ", 
      RowBox[{"(", 
       RowBox[{"d", "+", " ", 
        SuperscriptBox["t", "4"]}], ")"}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.58110274512568*^9, 3.581102772030114*^9}, {
  3.581102808501548*^9, 3.5811028175138617`*^9}, {3.581778408854047*^9, 
  3.58177848341961*^9}, {3.5854134189979362`*^9, 3.585413419499721*^9}, {
  3.585414073665751*^9, 3.585414073718567*^9}, {3.585414117416822*^9, 
  3.585414117501958*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x6", "[", "t", "]"}]], "Input",
 CellChangeTimes->{{3.58110282196537*^9, 3.581102825225965*^9}, {
  3.581778233548525*^9, 3.58177825256749*^9}, {3.58177849086735*^9, 
  3.581778501226562*^9}, {3.5854134222050962`*^9, 3.585413422588771*^9}, {
  3.585414076720245*^9, 3.58541407680744*^9}, {3.585414119646831*^9, 
  3.585414119863729*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"a", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"b", " ", 
      SuperscriptBox["t", "4"]}], "+", 
     RowBox[{"c", " ", 
      SuperscriptBox["t", 
       RowBox[{"9", "/", "2"}]]}]}], ")"}]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"b", "+", 
     SqrtBox["t"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"d", "+", 
     SuperscriptBox["t", "4"]}], ")"}]}]]], "Output",
 CellChangeTimes->{
  3.581102826780127*^9, 3.5817782725892477`*^9, {3.5817784949450293`*^9, 
   3.581778502896688*^9}, 3.581780872118745*^9, 3.585411277596908*^9, 
   3.5854132995142317`*^9, 3.585413451002597*^9, 3.585413677505947*^9, 
   3.585414145176358*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CForm", "[", 
   RowBox[{"x6", "[", "t", "]"}], "]"}], "/.", " ", 
  RowBox[{"{", 
   RowBox[{"Power", " ", "\[Rule]", " ", "pow"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.585413489985793*^9, 3.585413549564509*^9}, {
  3.585414089416066*^9, 3.585414089475175*^9}, {3.585414123422563*^9, 
  3.585414123487926*^9}}],

Cell["\<\
a*(b*pow(t,4) + c*pow(t,4.5))*pow(b + pow(t,0.5),-1)*pow(d + pow(t,4),-1)\
\>", "Output",
 CellChangeTimes->{3.585413550945531*^9, 3.585413677543303*^9, 
  3.585414145213606*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"D", "[", 
   RowBox[{
    RowBox[{"x6", "[", "t", "]"}], ",", "t"}], "]"}], "//", 
  "Simplify"}]], "Input",
 CellChangeTimes->{{3.5811029604150333`*^9, 3.581102980663455*^9}, {
  3.5811030148621387`*^9, 3.581103038404964*^9}, {3.581103123132625*^9, 
  3.581103141744482*^9}, {3.581778207051756*^9, 3.581778265070562*^9}, {
  3.58177851422058*^9, 3.581778553785655*^9}, {3.5854134251967916`*^9, 
  3.585413425428594*^9}, {3.585414092534442*^9, 3.585414092615883*^9}, {
  3.585414127278867*^9, 3.585414127359825*^9}}],

Cell[BoxData[
 FractionBox[
  RowBox[{"a", " ", 
   SuperscriptBox["t", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"8", " ", 
      SuperscriptBox["b", "2"], " ", "d"}], "+", 
     RowBox[{"8", " ", "c", " ", "d", " ", "t"}], "+", 
     RowBox[{"b", " ", 
      SqrtBox["t"], " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"7", "+", 
           RowBox[{"9", " ", "c"}]}], ")"}], " ", "d"}], "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"-", "1"}], "+", "c"}], ")"}], " ", 
         SuperscriptBox["t", "4"]}]}], ")"}]}]}], ")"}]}], 
  RowBox[{"2", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"b", "+", 
      SqrtBox["t"]}], ")"}], "2"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"d", "+", 
      SuperscriptBox["t", "4"]}], ")"}], "2"]}]]], "Output",
 CellChangeTimes->{{3.5811029735492764`*^9, 3.5811029815810328`*^9}, {
   3.581103016275399*^9, 3.581103039439567*^9}, {3.581103125970273*^9, 
   3.581103142825058*^9}, 3.581778216886858*^9, 3.581778272622612*^9, {
   3.58177852486598*^9, 3.581778554725651*^9}, 3.581780872166884*^9, 
   3.585411277637919*^9, 3.58541329955599*^9, 3.585413451046871*^9, 
   3.585413677593404*^9, 3.585414145268032*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"CForm", "[", 
   RowBox[{"Simplify", "[", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"x6", "[", "t", "]"}], ",", "t"}], "]"}], "]"}], "]"}], " ", "/.",
   " ", 
  RowBox[{"{", 
   RowBox[{"Power", " ", "\[Rule]", " ", "pow"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.5817804180375957`*^9, 3.581780426981848*^9}, {
  3.581780571948286*^9, 3.581780580033698*^9}, {3.581780720937159*^9, 
  3.5817807670871553`*^9}, {3.5817808232712917`*^9, 3.581780862457892*^9}, {
  3.5854132946664886`*^9, 3.5854132950802727`*^9}, {3.5854134345322523`*^9, 
  3.585413435253035*^9}, {3.585413563666988*^9, 3.585413582247245*^9}, {
  3.585414097384019*^9, 3.585414097441392*^9}, {3.58541413235117*^9, 
  3.585414132664339*^9}}],

Cell["\<\
(a*pow(t,3)*(8*c*d*t + 8*d*pow(b,2) + 
       b*pow(t,0.5)*((7 + 9*c)*d + (-1 + c)*pow(t,4)))*pow(b + \
pow(t,0.5),-2)*
     pow(d + pow(t,4),-2))/2.\
\>", "Output",
 CellChangeTimes->{3.581780872238564*^9, 3.585411277718358*^9, 
  3.585413299589862*^9, 3.585413451077916*^9, 3.5854135836296883`*^9, 
  3.585413677648116*^9, 3.585414145316063*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"x6", "[", "t", "]"}], "//", "TeXForm"}]], "Input",
 CellChangeTimes->{{3.5854112198233013`*^9, 3.5854112681082478`*^9}, {
  3.585413438468358*^9, 3.585413438835496*^9}, {3.58541410091853*^9, 
  3.585414101031023*^9}, {3.585414135646861*^9, 3.585414135782242*^9}}],

Cell["\<\
\\frac{a \\left(b t^4+c t^{9/2}\\right)}{\\left(b+\\sqrt{t}\\right) \
\\left(d+t^4\\right)}\
\>", "Output",
 CellChangeTimes->{
  3.585411236595874*^9, {3.585411269546817*^9, 3.585411278052396*^9}, 
   3.585413299636847*^9, 3.5854134511229153`*^9, 3.5854136776937113`*^9, 
   3.585414145443181*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Simplify", "[", 
   RowBox[{"D", "[", 
    RowBox[{
     RowBox[{"x6", "[", "t", "]"}], ",", "t"}], "]"}], "]"}], "//", 
  "TeXForm"}]], "Input",
 CellChangeTimes->{{3.5854120633850517`*^9, 3.5854120684709473`*^9}, {
  3.585412115783704*^9, 3.585412115934883*^9}, {3.5854122105339193`*^9, 
  3.585412224020556*^9}, {3.5854134417653418`*^9, 3.5854134420360107`*^9}, {
  3.585414105800269*^9, 3.5854141058771152`*^9}, {3.5854141401248093`*^9, 
  3.5854141402130613`*^9}}],

Cell["\<\
\\frac{a t^3 \\left(8 b^2 d+b \\sqrt{t} \\left((9 c+7) d+(c-1) t^4\\right)+8 \
c d
   t\\right)}{2 \\left(b+\\sqrt{t}\\right)^2 \\left(d+t^4\\right)^2}\
\>", "Output",
 CellChangeTimes->{3.58541206968258*^9, 3.585412117591714*^9, 
  3.5854122254674263`*^9, 3.585413299684869*^9, 3.5854134511625223`*^9, 
  3.58541367772684*^9, 3.5854141454823017`*^9}]
}, Open  ]]
},
WindowSize->{749, 1002},
WindowMargins->{{650, Automatic}, {Automatic, 186}},
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (November 20, \
2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 1327, 34, 28, "Input"],
Cell[CellGroupData[{
Cell[1909, 58, 645, 16, 28, "Input"],
Cell[2557, 76, 13192, 220, 242, "Output"]
}, Open  ]],
Cell[15764, 299, 1366, 43, 46, "Input"],
Cell[CellGroupData[{
Cell[17155, 346, 203, 4, 28, "Input"],
Cell[17361, 352, 1349, 27, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18747, 384, 356, 8, 28, "Input"],
Cell[19106, 394, 33370, 594, 246, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[52513, 993, 539, 15, 28, "Input"],
Cell[53055, 1010, 5031, 87, 242, "Output"]
}, Open  ]],
Cell[58101, 1100, 1679, 37, 46, "Input"],
Cell[CellGroupData[{
Cell[59805, 1141, 256, 5, 28, "Input"],
Cell[60064, 1148, 852, 20, 28, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[60953, 1173, 671, 16, 28, "Input"],
Cell[61627, 1191, 33625, 597, 248, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[95289, 1793, 545, 15, 28, "Input"],
Cell[95837, 1810, 4850, 85, 242, "Output"]
}, Open  ]],
Cell[100702, 1898, 2776, 82, 114, "Input"],
Cell[CellGroupData[{
Cell[103503, 1984, 258, 5, 28, "Input"],
Cell[103764, 1991, 921, 21, 55, "Output"]
}, Open  ]],
Cell[104700, 2015, 1388, 33, 35, "Input"],
Cell[CellGroupData[{
Cell[106113, 2052, 1070, 21, 28, "Input"],
Cell[107186, 2075, 33347, 590, 248, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[140570, 2670, 541, 15, 28, "Input"],
Cell[141114, 2687, 4780, 83, 242, "Output"]
}, Open  ]],
Cell[145909, 2773, 880, 25, 35, "Input"],
Cell[CellGroupData[{
Cell[146814, 2802, 361, 6, 28, "Input"],
Cell[147178, 2810, 682, 21, 60, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[147897, 2836, 350, 8, 28, "Input"],
Cell[148250, 2846, 188, 4, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[148475, 2855, 551, 11, 28, "Input"],
Cell[149029, 2868, 1283, 36, 62, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[150349, 2909, 752, 16, 28, "Input"],
Cell[151104, 2927, 357, 8, 70, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[151498, 2940, 298, 5, 28, "Input"],
Cell[151799, 2947, 308, 7, 40, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[152144, 2959, 504, 11, 28, "Input"],
Cell[152651, 2972, 361, 7, 55, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
