/*
    Tucnak - VHF contest log
    Copyright (C) 2002-2006  Ladislav Vaiz <ok1zia@nagano.cz>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    version 2 as published by the Free Software Foundation.

*/

#include "header.h"

#ifdef HAVE_SNDFILE

struct ssbd *ssbd;
MUTEX_DEFINE(ssbd);
/*GMutex *ssbd_mutex;
#ifdef LEAK_DEBUG_LIST
char *ssbd_file;
int ssbd_line;
#endif*/

#define MAXCNTLEVEL 1

struct ssbd *init_ssbd(){
    struct ssbd *ssbd;

    ssbd = g_new0(struct ssbd, 1);
    ssbd->b = 0xbbbbbbbb;
    ssbd->a = 0xaaaaaaaa;
    ssbd_mutex = g_mutex_new();    
    
#if defined(HAVE_SDL) && defined(HAVE_LIBPNG)    
    if (sdl){
        ssbd->norecicon = do_png_create(icon_norec, sizeof(icon_norec));
        if (!ssbd->norecicon) internal_("Can't create norec icon, currupted executable?");
    
        ssbd->recicon = do_png_create(icon_record, sizeof(icon_record));
        if (!ssbd->recicon) internal_("Can't create record icon, currupted executable?");
    
        ssbd->playicon = do_png_create(icon_play, sizeof(icon_play));
        if (!ssbd->playicon) internal_("Can't create play icon, currupted executable?");
    }
#endif
    ssbd->loglevel = -1;
    ssbd->oldloglevel = -2;
    MUTEX_INIT(ssbd->loglevel);
    MUTEX_INIT(ssbd->seek);
    
    return ssbd;
}

void free_ssbd(struct ssbd *ssbd){
    dbg("free_ssbd\n");
    cq_abort(1);
    ssbd_abort(ssbd,1); 
    ssbd_thread_kill(ssbd); /* killed before but... */
    CONDGFREE(ssbd->callsign);
    CONDGFREE(ssbd->pfilename);
    CONDGFREE(ssbd->rfilename);
#ifdef HAVE_SDL    
    if (sdl){
        if (ssbd->playicon) SDL_FreeSurface(ssbd->playicon);
        if (ssbd->recicon) SDL_FreeSurface(ssbd->recicon);
        if (ssbd->norecicon) SDL_FreeSurface(ssbd->norecicon);
    }
#endif
    if (ssbd->pl_pcmfile){
        unlink(ssbd->pl_pcmfile);
        g_free(ssbd->pl_pcmfile);
    }
    g_mutex_free(ssbd_mutex);
    MUTEX_FREE(ssbd->loglevel);
    MUTEX_FREE(ssbd->seek);
    g_free(ssbd);
}

void ssbd_abort(struct ssbd *ssbd, int abort_rec){
    gchar *tmpfile;
    
    /*dbg("ssbd_abort recording=%d abort_rec=%d\n", ssbd->recording, abort_rec);*/
    
    if (!ssbd) return;
    
    ssbd->channels = 0;
    ssbd->played = 0;
    if (gses) gses->icon=NULL;
    ssbd_thread_kill(ssbd);
        
    if (ssbd->sndfile) { 
        sf_close (ssbd->sndfile);
        ssbd->sndfile = NULL;
    
        if (!cfg->ssbd_template || !ssbd->rfilename) goto x;
        tmpfile=convert_esc(cfg->ssbd_template, NULL, CE_NONE, time(NULL));
        /*dbg("cfg->template='%s' cfg->callsign='%s' \n", cfg->ssbd_template, ssbd->callsign);
        dbg("tmpfile='%s'  cfg->filename='%s'\n", tmpfile, ssbd->rfilename);*/
        if (strcmp(tmpfile, ssbd->rfilename)!=0){
            //dbg("renaming '%s' to '%s'\n", ssbd->rfilename, tmpfile);         
            rename(ssbd->rfilename, tmpfile);
            g_free(ssbd->rfilename);
            ssbd->rfilename=g_strdup(tmpfile);
            
        }
        g_free(tmpfile);
    }
x:;    
    dsp->close2(dsp);
 
    ssbd->recording=0;
    if (!abort_rec) ssbd_rec_file(ssbd);
}

void ssbd_thread_create(struct ssbd *ssbd, GThreadFunc thread_func){
    /*dbg("ssbd_thread_create");*/
 /*   if (thread_func==ssbd_play_thread_func) dbg(" play"); 
    else if (thread_func==ssbd_rec_thread_func) dbg(" rec");
    else dbg(" ???");                          
   */ 
  /*  dbg("\n");*/
    ssbd->proc_break=0;
    if (ssbd->thread) return;
	ssbd->thread = g_thread_create(thread_func, (gpointer)ssbd, TRUE, NULL);
//    dbg("ssbd created thread %p\n", ssbd->thread);
}

void ssbd_thread_join(struct ssbd *ssbd){
//    dbg("ssbd thread join %p\n", ssbd->thread);
    if (!ssbd->thread) return;
    ssbd->proc_break=1;
    dbg("join ssbd...\n");
    g_thread_join(ssbd->thread);
    dbg("done\n");
	ssbd->thread = NULL;
}

void ssbd_thread_kill(struct ssbd *ssbd){
//    dbg("ssbd thread kill %p\n", ssbd->thread);
    if (!ssbd->thread) return;
//	dbg("  waiting\n");
    ssbd->proc_break=1;
    dbg("join ssbd...\n");
    g_thread_join(ssbd->thread);
    dbg("done\n");
	ssbd->thread = NULL;
}

/* ------- playing -------------------------------------------------- */

int ssbd_play_file(struct ssbd *ssbd, gchar *pfilename){
    SF_INFO sfinfo;
    int subformat;
    
    /*dbg("ssbd_play_file('%s')\n", pfilename);*/
    ssbd_abort(ssbd,1); /*aborts playing or recording */

    memset (&sfinfo, 0, sizeof (sfinfo));

    if (!pfilename || strlen(pfilename)==0) {
        log_adds("No file specified");
        return -1;
    }
    
 /*   dbg ("Playing %s\n", filename);*/
    if (! (ssbd->sndfile = sf_open (pfilename, SFM_READ, &sfinfo))){   
        log_addf("Can't play %s - %s", pfilename, sf_strerror (NULL));
        return -1;
    };

    if (sfinfo.channels < 1 || sfinfo.channels > 2){   
        log_addf ("Channels = %d.", sfinfo.channels);
        return -1;
    };
    
    subformat = sfinfo.format & SF_FORMAT_SUBMASK;
    
    if (subformat == SF_FORMAT_FLOAT || subformat == SF_FORMAT_DOUBLE){   
        log_addf("Float point files are not supported");
        return -1;
    }

    /*dbg("sfinfo: format=0x%x channels=%d speed=%d   frames=%d\n", sfinfo.format, sfinfo.channels, sfinfo.samplerate, sfinfo.frames);*/
    dsp->set_format(dsp, &sfinfo);
    dsp->set_plevel(dsp);
    if (dsp->open(dsp, 0)<0) {
        log_addf("Can't open DSP %s for playing", dsp->name);
        return -1;
    };
/*    dbg("play opened: format=%x channels=%d speed=%d\n", dsp->format, dsp->channels, dsp->speed);*/

    fft_start(SSBBUFFER_LEN / dsp->bpf);
    ssbd->channels = sfinfo.channels;
    ssbd->seek = 0;
    ssbd_thread_create(ssbd, ssbd_play_thread_func);
	
    if (gses) gses->icon=ssbd->playicon;
    return 0;
}

void play_thread_sigint(int a){
    dbg("play_thread_sigint\n");
    ssbd->proc_break=1;
}

gpointer ssbd_play_thread_func(gpointer data){
    gchar *c;
    char s[256];
    int written, readcount;
	char errbuf[1024];
    int err, towrite;
    char *wrptr;
    int xxx = -1;
    int i, j, ret;
    
    /*dbg("play thread started\n");
    for (i=0;i<6;i++){
        if (ssbd->thread_break)  goto x; 
        dbg("kdák\n");
        sleep(1);
    }
    */
    while(1){
        xxx++;
        if (ssbd->proc_break) {
            dsp->reset(dsp);
            goto x; 
        }
        MUTEX_LOCK(ssbd->seek);
        int seek = ssbd->seek * ssbd->channels * dsp->speed / 1000;
        ssbd->seek = 0;
        MUTEX_UNLOCK(ssbd->seek);
        
        if (seek != 0){
            dbg("seek(%d)\n", seek);
            sf_count_t cnt = sf_seek(ssbd->sndfile, 0, SEEK_CUR);
            cnt += seek;
            if (cnt < 0) cnt = 0;
            cnt = sf_seek(ssbd->sndfile, cnt, SEEK_SET);
            if (cnt >= 0) ssbd->played = cnt;
            ssbd->cntlevel = 0;
        }
        ssbd_assert();
        readcount = sf_read_short (ssbd->sndfile, ssbd->buffer2, SSBBUFFER_LEN/sizeof(short));
        ssbd_assert();
        if (readcount<=0) break;            
        ssbd->played += readcount / ssbd->channels;

        /* todo playmax & etc */

        if (ssbd->proc_break)  {
            dsp->reset(dsp);
            goto x; 
        }

        wrptr=(char*)ssbd->buffer2;
        towrite=readcount * sizeof (short);

        if (ssbd->cntlevel--==0){
            ssbd->cntlevel=MAXCNTLEVEL;

            c=g_strdup_printf("SSBP;L\n");
            ret = write(tpipe->threadpipe_write, c, strlen(c));
            g_free(c);
		}

        
#ifdef USE_FFT
        if (fft){
//            dbg("towrite=%d ch=%d\n", towrite, dsp->channels);
            ssbd_assert();
            for (i=0; i<towrite/(sizeof(short)*dsp->channels); i+= dsp->channels){
                double v = 0;
                for (j=0; j<dsp->channels; j++){
                    v += (double)ssbd->buffer2[i*dsp->channels+j];
                }
                v /= dsp->channels;
                v /= 32768;
                fft->rin[i] = v;
            }
            ssbd_assert();

            fft_do(fft);
//            dbg(" done i=%d\n", i);
        }
#endif

        while(1){
            ssbd_assert();
            written  = dsp->write (dsp, wrptr, towrite);
            ssbd_assert();
            /*dbg("%d written=%d  readcount*%d=%d  errno=%d %s\n",
                        xxx, written, sizeof(short), readcount*sizeof(short), errno,strerror_r(err, errbuf, sizeof(errbuf)) );
            */
                        
            if (written < 0){
                err=errno;
                MUTEX_LOCK(ssbd);
                c=g_strdup_printf("SSBP;!%s %s %s\n", "Can't write to", dsp->name, strerror_r(err, errbuf, sizeof(errbuf)) );
                MUTEX_UNLOCK(ssbd);
                ret = write(tpipe->threadpipe_write, c, strlen(c));
                g_free(c);
                goto x;
            }
            if (written < readcount * sizeof(short)){
                dbg("write(%s) interrupted after %d bytes\n", dsp->name, written);
                wrptr+=written;
                towrite-=written;
                    
            }
            break;
        }
    }
    dsp->sync(dsp);
    sprintf(s, "SSBP;e\n");
    ret = write(tpipe->threadpipe_write, s, strlen(s));
x:;    
    ssbd_assert();
	memset(ssbd->buffer2, 0, SSBBUFFER_LEN*sizeof(short));
    ssbd_assert();
    /*dbg("play thread exited\n");*/
  return NULL;
}

void ssbd_play_read_handler(struct ssbd *ssbd, gchar *str){

    /*dbg("ssbd_read_handler\n");*/
    
    if (gses->last_cq_timer_id){ /* CQ was aborted while playing */
        kill_timer(gses->last_cq_timer_id);
        gses->last_cq_timer_id = 0;
    }

    switch(str[0]){
        case '!':  /* error */
            cq_abort(ssbd->recording); /*abort recording only if it is in progress */
            
            log_addf("ssbd: %s", str+1);
            gses->icon=NULL;
            redraw_later();
            cq_abort(ssbd->recording);
            peer_tx(aband, 0);
            break;
        case 'e':  /* sample played */
    	    if (!gses) break;
            gses->icon=NULL;
            if (!gses->last_cq) { /* last sample played */
                cq_abort(ssbd->recording);
                break; 
            }
            if (gses->last_cq->ssb_repeat)
                cq_ssb_wait(gses->last_cq);
            else{
                gses->last_cq->type=MOD_NONE;
                cq_abort(ssbd->recording);
            }
            peer_tx(aband, 0);
            redraw_later();
            break;
        case 'L':  /* play level */
            //ssbd->loglevel=atoi(str+1);
#ifdef HAVE_SDL
			if (gses->ontop->type == SWT_SCOPE){
				gses->ontop->gdirty = 1;
				//dbg("set gdirty\n");
			}
#endif
            redraw_later();
            /*dbg("level=%d\n", ssbd->loglevel);*/
            break;
    }
}

/* ------- recording -------------------------------------------------- */

int ssbd_rec_file(struct ssbd *ssbd){
    int subformat;
    SF_INFO sfinfo;
	char errbuf[1024];
    double df;
    
    /*dbg("ssbd_rec_file  cfg->ssbd_record=%d  ssbd->recording=%d  ctest->recording=%d\n", cfg->ssbd_record, ssbd->recording, ctest?ctest->recording:-123); */

    if (!cfg->ssbd_record) {
        strcpy(errbuf, "recording disabled");
        goto norec;
    }
    if (ssbd->recording) return 0;
    
    gses->icon=ssbd->norecicon;
    if (ctest && ctest->oldcontest) {
        strcpy(errbuf, "contest too old");
        goto norec;
    }
    

    ssbd_abort(ssbd,1); /*aborts playing or recording */
    ssbd_watchdog(ssbd, 0);

    CONDGFREE(ssbd->rfilename);
    ssbd->serno++;
    ssbd->rfilename=convert_esc(cfg->ssbd_template, NULL, CE_NONE, time(NULL));
    
    /*dbg ("Playing %s\n", ssbd->rfilename);*/
    
    memset (&sfinfo, 0, sizeof (sfinfo));

    sfinfo.format     = cfg->ssbd_format;
    sfinfo.channels   = cfg->ssbd_channels;
    sfinfo.samplerate = cfg->ssbd_samplerate;
    
    if (!sfinfo.format)     sfinfo.format=SF_FORMAT_WAV | SF_FORMAT_PCM_16;
    if (!sfinfo.channels)   sfinfo.channels=1;
    if (!sfinfo.samplerate) sfinfo.samplerate=22050;
    

	ssbd->code = 0;
    fmkdir_p(ssbd->rfilename,0777);

    if ((ssbd->sndfd=open(ssbd->rfilename, O_WRONLY|O_CREAT|O_TRUNC, 0666))<0){
        log_addf ("Error writing file (1) %s: %s",ssbd->rfilename, strerror_r(errno, errbuf, sizeof(errbuf)));
        return -1;
    };

    df=fdf(ssbd->sndfd);
    if (df>=0.0 && cfg->ssbd_diskfree>0){
        if (df < (cfg->ssbd_diskfree*1058576.0)){
            dbg("Not enough free disk space for %s: %d<%d (MiB)\n",ssbd->rfilename, (int)(df/1048576), cfg->ssbd_diskfree);
            log_addf ("Not enough free disk space for %s: %d<%d (MiB)",ssbd->rfilename, (int)(df/1048576), cfg->ssbd_diskfree);
            return -1;
        }
    }

    /*dbg("check:%d\n", sf_format_check(&sfinfo));*/
    
    if (! (ssbd->sndfile = sf_open_fd (ssbd->sndfd, SFM_WRITE, &sfinfo, 1))){   
        log_addf ("Error writing file (2) %s: %s",ssbd->rfilename, sf_strerror (NULL));
        close(ssbd->sndfd);
        return -1;
    };
    
    subformat = sfinfo.format & SF_FORMAT_SUBMASK;

    if (subformat == SF_FORMAT_FLOAT || subformat == SF_FORMAT_DOUBLE){   
        log_addf("Float point files are not supported");
        sf_close (ssbd->sndfile);
        return -1;
    }

    /*dbg("sfinfo: format=%x channels=%d speed=%d   frames=%d\n", sfinfo.format, sfinfo.channels, sfinfo.samplerate, sfinfo.frames);*/
    dsp->set_format(dsp, &sfinfo);
    dsp->set_source(dsp);
/*    dbg("converted format=%x\n", dsp->format);*/
    if (dsp->open(dsp, 1)<0){
        log_addf("Can't open DSP %s for recording", dsp->name);
        sf_close (ssbd->sndfile);
        return -1;
    };
    /*dbg("rec opened: format=%x channels=%d speed=%d\n", dsp->format, dsp->channels, dsp->speed);*/


    
    fft_start(SSBBUFFER_LEN / dsp->bpf);
    ssbd->channels = sfinfo.channels;
    ssbd_thread_create(ssbd, ssbd_rec_thread_func);
    gses->icon=ssbd->recicon;
    
    ssbd->recording=1;
	return 0;

norec:;    
    if (ssbd->norecshowed) return 0;
    log_addf(CTEXT(T_NOT_RECORDING_S), errbuf); 
    ssbd->norecshowed=1;
    return 0;  
}

void rec_thread_sigint(int a){
    /*dbg("rec_thread_sigint\n");*/
    ssbd->proc_break=1;
}

gpointer ssbd_rec_thread_func(gpointer data){
    gchar *c;
    int readed, readeds, writecount=0, err, i, j;
    int max, loglevel, avg, ret;
    unsigned long sum;
    time_t now;
    double df;
    
    
    while(1){
        if (ssbd->proc_break) break;
        
        ssbd_assert();
        readed  = dsp->read(dsp, ssbd->buffer2, SSBBUFFER_LEN);
        ssbd_assert();
        if (readed<=0) {
            /*dbg("ssbd_rec_func read<=0\n"); */
            char errstr[1030];
            err=errno;
            MUTEX_LOCK(ssbd);
            c=g_strdup_printf("SSBR;!%s %s %s %d %d\n", "Can't read from", dsp->name, strerror_r(err, errstr, sizeof(errstr)), readed, err);
            MUTEX_UNLOCK(ssbd);
            ret = write(tpipe->threadpipe_write, c, strlen(c));
            g_free(c);
            break;
        }
      /*  dbg("readed=%d  readed/%d=%d  errno=%d\n",
                    readed, sizeof(short), readed/sizeof(short), errno);*/
//		for (i=0; i<512;i++) ssbd->buffer[i]=rand(); // FIXME
        
        if (ssbd->proc_break) break;
        
        if (ssbd->cntlevel--==0){
            ssbd->cntlevel=MAXCNTLEVEL;
            sum=0;
            max=0;
            avg=0;
            readeds=readed/(sizeof(short)*dsp->channels);
            ssbd_assert();
            for (j=0;j<dsp->channels;j++){
                for (i=0;i<readeds;i+=dsp->channels){
                    short sample=ssbd->buffer2[i*dsp->channels+j];
                    avg+=sample;
                }
            }
            ssbd_assert();
            avg /= dsp->channels;
            avg /= readeds;
            ssbd_assert();
            for (j=0;j<dsp->channels;j++){
                for (i=0;i<readeds;i+=dsp->channels){
                    short sample=ssbd->buffer2[i*dsp->channels+j] - avg;
                    if (sample<0) sample=-sample;
                    sum+=sample;
                    if (sample>max) max=sample;
                }
            }
            ssbd_assert();
            ssbd->midlevel=sum/(readed/sizeof(short));
            ssbd->maxlevel=max;
            if (max<32) loglevel=0;
            else loglevel=(log(max)-3.465735903)*14;
            if (loglevel>95) loglevel=95;
            MUTEX_LOCK(ssbd->loglevel);
            ssbd->loglevel = loglevel;
            if (ssbd->swontoptype==SWT_SCOPE){
                c=g_strdup_printf("SSBR;L%d\n", loglevel);
                ret = write(tpipe->threadpipe_write, c, strlen(c));
                g_free(c);
            }
            MUTEX_UNLOCK(ssbd->loglevel);
        } 
    
        df=fdf(ssbd->sndfd);
/*        dbg("df=%f df=%d diskfree=%d\n", df, (int)(df/1048576), cfg->ssbd_diskfree);*/
        if (df>=0.0 && cfg->ssbd_diskfree>0){
            if (df < (cfg->ssbd_diskfree*1048576.0)){
                MUTEX_LOCK(ssbd);
                dbg("Not enough free disk space for %s: %d<%d (MiB)\n",ssbd->rfilename, (int)(df/1048576), cfg->ssbd_diskfree);
                c=g_strdup_printf("SSBR;!%s %s %f<%d (MiB)\n", "Not enough free disk space for", ssbd->rfilename, df/1048576.0, cfg->ssbd_diskfree);
                MUTEX_UNLOCK(ssbd);
                ret = write(tpipe->threadpipe_write, c, strlen(c));
                g_free(c);
                break;
            }
        }

#ifdef USE_FFT
        if (fft){
            //RST_START;
/*            int vali, mini,maxi;
            mini = 2000000000;
            maxi = -2000000000;*/
//            dbg("readed=%d ch=%d\n", readed, dsp->channels);
            ssbd_assert();
            for (i=0; i<readed/(sizeof(short)*dsp->channels); i+= dsp->channels){
                double v = 0;
                for (j=0; j<dsp->channels; j++){
                    /*vali = ssbd->buffer[i*dsp->channels+j];
                    if (vali < mini) mini = vali;
                    if (vali > maxi) maxi = vali;*/
                    v += (double)ssbd->buffer2[i*dsp->channels+j];
                }
                v /= dsp->channels;
                v /= 32768;
                fft->rin[i] = v;
            }
            ssbd_assert();
            fft_do(fft);
//            dbg(" done i=%d\n", i);
//            dbg("vali=%d .. %d \t", mini, maxi);
            //RST_STOP;
        }
#endif

        writecount = sf_write_short (ssbd->sndfile, ssbd->buffer2, readed/sizeof(short));
        if (writecount <=0) {
            char errstr[1030];
            dbg("ssbd_rec_func write<=0\n"); 
            MUTEX_LOCK(ssbd);
            c=g_strdup_printf("SSBR;!%s %s %s\n", "Can't write to", ssbd->rfilename, strerror_r(errno, errstr, sizeof(errstr)));
            MUTEX_UNLOCK(ssbd);
            ret = write(tpipe->threadpipe_write, c, strlen(c));
            g_free(c);
            break;
        }

        now=time(NULL);
        MUTEX_LOCK(ssbd);
        if (ssbd->recstop && now > ssbd->recstop){
            dbg("ssbd_rec_func: timeout\n");
            
            c=g_strdup("SSBR;Q\n");
            ret = write(tpipe->threadpipe_write, c, strlen(c));
            g_free(c);
            MUTEX_UNLOCK(ssbd);
            break;
        }
        MUTEX_UNLOCK(ssbd);
    }
    
    ssbd_assert();
	memset(ssbd->buffer2, 0, SSBBUFFER_LEN*sizeof(short));
    ssbd_assert();
    /*dbg("rec_thread exited\n");*/
	return 0;
}

void ssbd_rec_read_handler(struct ssbd *ssbd, gchar *str){
    /*dbg("ssbd_read_handler\n");*/
    
    switch(str[0]){
        case '!':  /* error */
            cq_abort(1); 
            log_addf("ssbd: %s", str+1);
            if (gses) gses->icon=NULL;
            redraw_later();
            break;
        case 'L':  /* recording level */
            //ssbd->loglevel=atoi(str+1);
#ifdef HAVE_SDL
			if (gses->ontop->type == SWT_SCOPE){
				gses->ontop->gdirty = 1;
//				dbg("set gdirty\n");
			}
#endif
            redraw_later();
			sw_scope_redraw(gses->ontop, 0);
            /*dbg("level=%d\n", ssbd->loglevel);*/
            break;
        case 'Q':
            ssbd_thread_join(ssbd);
            ssbd_abort(ssbd, 1);
            redraw_later(); // to clean record level bar
            break;
    }
}


int ssbd_recording(struct ssbd *ssbd){
    return ssbd->recording;
}


/* ------- misc -------------------------------------------------- */

int ssbd_callsign(struct ssbd *ssbd, char *call){
    
    if (!ssbd) return 0;

    MUTEX_LOCK(ssbd);
    CONDGFREE(ssbd->callsign);
    ssbd->callsign=g_strdup(call);
    MUTEX_UNLOCK(ssbd);
	return 0;
}


int fmkdir_p(const char *filename, mode_t mode){
    gchar *dir,*d;
    int ret;
    
    /*dbg("fmkdir_p '%s'\n", filename);*/
    dir=g_strdup(filename);
    d=strrchr(dir,'/');
    ret=-1;
    if (d){
        *d='\0';
        ret=mkdir_p(dir,mode);
    }
    g_free(dir);
    return ret;
}

gchar *unique_filename(gchar *filename){
    struct stat st;
    int ser;
    gchar *file, *ext, *c;
    char *c1, *c2, *c3;

    c1=c2=c3=NULL;
    if (stat(filename, &st)) return filename; /* filename doesn't exist */
    
    if (regmatch(filename, "(.*)(\\..*)", &c1, &c2, &c3, NULL)==0){
        file=g_strdup(c2);
        ext=g_strdup(c3);
        g_free(filename);
    }else{
        file=filename;
        ext=g_strdup("");
    }
    if (c1) mem_free(c1);
    if (c2) mem_free(c2);
    if (c3) mem_free(c3);
    
    c=NULL;
    for (ser=1; ;ser++){
        /*dbg("file='%s'  ext='%s'\n", file, ext);*/
        c=g_strdup_printf("%s%d%s", file, ser, ext);
/*        dbg("c='%s'\n", c);*/
        if (stat(c, &st)){ /* c doesn't exist */
            break;
        }
        g_free(c);
    }
    return c;
}

void ssbd_watchdog(struct ssbd *ssbd, int start_rec){
    time_t t;

//    dbg("ssbd_watchdog\n");
    if (!cfg->ssbd_maxmin) {
        ssbd->recstop=0;
        return;
    }
    t=time(NULL);
    t+=60*cfg->ssbd_maxmin;
    ssbd->recstop=t;
    if (!start_rec) return;

    if (ssbd->recording) return;
    if (gses->tx) return;
    if (gses->last_cq) return;
    
    ssbd_rec_file(ssbd);
    
}

void menu_ssbd_play(cba_t cba, cba_t unused){
    SF_INFO iin, iout;
    SNDFILE *fin, *fout;
    char *filename = cba.charp;
    short *buf;
    int l, r, w;

    dbg("menu_ssbd_play('%s')\n", filename);
    memset(&iin, 0, sizeof(SF_INFO));
    fin = sf_open(filename, SFM_READ, &iin);
    if (!fin){
        log_addf("Can't play %s - %s", filename, sf_strerror (NULL));
        return;
    }
    if (iin.seekable){
        sf_close(fin);
        player_play(filename);
    }

    // convert to PCM16
    memcpy(&iout, &iin, sizeof(SF_INFO));
    iout.format = SF_FORMAT_WAV | SF_FORMAT_PCM_16;

    CONDGFREE(ssbd->pl_pcmfile);
    ssbd->pl_pcmfile = g_strconcat(getenv("HOME"), "/tucnak/tmp.wav", NULL);
    fout = sf_open(ssbd->pl_pcmfile, SFM_WRITE, &iout);
    if (!fout){
        log_addf("Can't write %s - %s", ssbd->pl_pcmfile, sf_strerror(NULL));
        return;
    }

    l = 65536;
    buf = g_new0(short, l);

    while(1){
        r = sf_read_short(fin, buf, l);
        if  (r <= 0) break;
        w = sf_write_short(fout, buf, r);
        if (w <= 0) break;
        if (r != w) break;
    }

    sf_close(fin);
    sf_close(fout);

    player_play(ssbd->pl_pcmfile);
    g_free(buf);

}


void scan_dir(char *base, GIndexArray *ia){
    DIR *d;
    struct dirent *de;
    struct stat st;
    char *full = NULL;

    d = opendir(base);
    while ((de = readdir(d)) != NULL){
        if (strcmp(de->d_name, ".") == 0) continue;
        if (strcmp(de->d_name, "..") == 0) continue;
//        dbg("de='%s'\n", de->d_name);
        CONDGFREE(full);
        full = g_strconcat(base, "/", de->d_name, NULL);
        if (stat(full, &st)) continue;
//        dbg("full='%s'\n", full);
        if (S_ISDIR(st.st_mode)) scan_dir(full, ia);
        if (S_ISREG(st.st_mode)) g_index_array_add(ia, g_strdup(full));
    }
    closedir(d);
    CONDGFREE(full);
}

void ssbd_play_last_sample(struct ssbd *ssbd, struct qso *qso){
    GIndexArray *ia;
    struct tm tm;
    int i, act, first, len;
    struct menu_item *mi = NULL;
    cba_t cba2;

    //log_addf("qso=%p", qso);
    if (ssbd->recording){
        cq_abort(1);   /* abort recording */
    }else{
        rx();
    }

    if (!qso){
        if (ssbd->rfilename && *ssbd->rfilename){
            dbg("rfilename=%s gses->last_cq=%p\n", ssbd->rfilename, gses->last_cq);
            ssbd_play_file(ssbd, ssbd->rfilename);
            gses->icon=ssbd->playicon;
        }else{
            log_adds("No sample recorded");
        }

        redraw_later();
        return;
    }

    char *template = g_strdup(cfg->ssbd_template);
   // log_addf("template='%s'", template);
    char *c = strchr(template, '%');
    if (!c){
        log_adds("No macro %% in SSBD template");
        goto x;
    }
    *c='\0';
    if (strlen(template) && template[strlen(template)-1] == '/') template[strlen(template)-1] = '\0';
   // log_addf("template='%s'", template);
    ia = g_index_array_new();
    c = convert_esc(template, NULL, 0, 0); 
    scan_dir(c, ia);
    g_free(c);

    int d = atoi(qso->date_str);
    int t = atoi(qso->time_str);
    tm.tm_sec = 0;
    tm.tm_min = t % 100;
    tm.tm_hour = t / 100;
    tm.tm_mday = d % 100;
    tm.tm_mon = (d / 100 ) % 100 - 1;
    tm.tm_year = d / 10000 - 1900;
    time_t qt = timegm(&tm);
    dbg("qt=%d d=%d t=%d\n", qt, d, t);
    c = convert_esc(cfg->ssbd_template, NULL, 0, qt);
//    dbg("   c='%s'\n", c);
    g_index_array_add(ia, c);
    g_index_array_qsort(ia, compare_string);

    act=-1;
    for (i=0; i<ia->len;i++){
        if (strcmp(g_index_array_index(ia, i), c)!=0) continue;
        act=i;
        break;
    }
    if (act < 0) goto x;
    g_index_array_remove_index(ia, act);

//    for (i=0; i<ia->len;i++) dbg("%3d '%s'\n", i, g_index_array_index(ia, i));
    dbg("act=%d\n", act);
    first = act - term->y / 2 - 2;
    len  =  term->y - 2;
    dbg("first=%d len=%d\n", first, len);
    if (first < 0) {
        first = 0;
    }
    if (first + len - 1 >= ia->len){
        len = ia->len - first; 
    }
    dbg("first=%d len=%d\n", first, len);
    if (!(mi = new_menu(3))) return;
    for (i=0; i<len;i++){
        char *f = (char *)g_index_array_index(ia, i+first);
        dbg("%3d '%s'\n", i+first, f);
            
        cba2.charp = f;
        add_to_menu(&mi, 
                stracpy(f), 
                "", "", 
                menu_ssbd_play, cba2, 1);    
    }

// FIXME    g_index_array_free_all(ia);
    
    do_menu_selected(mi, CBA0, act - first);
x:;    
    g_free(template);
}
#endif

int mkdir_p(const char *s,mode_t mode) {
    struct stat st;
    gchar *dir,*c;

    /*dbg("mkdir_p '%s'\n", s);*/

    if (!stat(s,&st))
        if (S_ISDIR(st.st_mode)) return(0);

    dir = g_strdup(s);
    c=strrchr(dir,'/');
    if (c==NULL) {
        g_free(dir);
        return(-1);
    }
    *c='\0';
    if (strlen(dir)==0) {
        g_free(dir);
        return(-1);
    }
    mkdir_p(dir,mode);
    g_free(dir);
    return(tmkdir(s,mode));
}

void ssbd_assert(){
/*    if (!ssbd) return;
    if (ssbd->b != 0xbbbbbbbb || ssbd->a != 0xaaaaaaaa) 
        internal_error("Corrupted ssbd->b=0x%x a=0x%x", ssbd->b, ssbd->a);
        */
}
