/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef TIMELABEL_H
#define TIMELABEL_H

#include "fixlabel.h"
#include <QDBusInterface>

class TimeLabel : public FixLabel
{
    Q_OBJECT

public:
    TimeLabel(QWidget *parent = nullptr);
    ~TimeLabel();
    // 返回日期和星期
    QString dateText();

protected:
    void timerEvent(QTimerEvent *e);
    void setTimeText();

private:
    int timerID;
    QDBusInterface *areaInterface = nullptr;
    QString        timeFormat     = "";
    QString        date           = "";

Q_SIGNALS:
    void dateChanged();
};




#endif // TIMELABEL_H
