#!/usr/bin/env python3
# -*- coding: utf-8 -*-
# Unity Mail, functions for working with configuration file
# Authors: Dmitry Shachnev <mitya57@gmail.com>
#          Robert Tari <robert.tari@gmail.com>
# License: GNU GPL 3 or higher; http://www.gnu.org/licenses/gpl.html

from gi.repository import GLib
from configparser import RawConfigParser
from os.path import join

config_dir = GLib.get_user_config_dir()
config_file_path = join(config_dir, 'unity-mail.conf')

class ConfigFile(RawConfigParser):

    def __init__(self, filename):

        RawConfigParser.__init__(self, strict=False)
        self.optionxform = str
        self.read(filename)

    def get_str_with_default(self, item, defaultvalue = '', section = 'General'):

        if self.has_option(section, item):
            return self.get(section, item)
        else:
            return defaultvalue

    def get_bool_with_default(self, item, defaultvalue, section = 'General'):

        if self.has_option(section, item):
            return self.getboolean(section, item)
        else:
            return defaultvalue

    def get_int_with_default(self, item, defaultvalue, section = 'General'):

        if self.has_option(section, item):
            return self.getint(section, item)
        else:
            return defaultvalue
