/* wikiscanner.c generated by valac, the Vala compiler
 * generated from wikiscanner.vala, do not modify */

/* wikiscanner.vala
 *
 * Copyright (C) 2008-2009 Florian Brosch, Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <vala.h>

enum  {
	VALADOC_WIKI_SCANNER_0_PROPERTY,
	VALADOC_WIKI_SCANNER_NUM_PROPERTIES
};
static GParamSpec* valadoc_wiki_scanner_properties[VALADOC_WIKI_SCANNER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _valadoc_parser_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_parser_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValadocWikiScannerPrivate {
	ValadocSettings* _settings;
	ValadocParser* _parser;
	gchar* _content;
	const gchar* _index;
	gboolean _stop;
	gint _last_line;
	gint _last_column;
	gint _line;
	gint _column;
	gboolean _url_escape_mode;
	gboolean _code_escape_mode;
	gunichar _last_char;
	gint _skip;
	GString* _current_string;
};

static gint ValadocWikiScanner_private_offset;
static gpointer valadoc_wiki_scanner_parent_class = NULL;
static ValadocScannerIface * valadoc_wiki_scanner_valadoc_scanner_parent_iface = NULL;

static void valadoc_wiki_scanner_real_set_parser (ValadocScanner* base,
                                           ValadocParser* parser);
static void valadoc_wiki_scanner_real_reset (ValadocWikiScanner* self);
static void valadoc_wiki_scanner_real_scan (ValadocScanner* base,
                                     const gchar* content,
                                     GError** error);
static void valadoc_wiki_scanner_real_end (ValadocScanner* base,
                                    GError** error);
static void valadoc_wiki_scanner_emit_token (ValadocWikiScanner* self,
                                      ValadocTokenType* type,
                                      GError** error);
static void valadoc_wiki_scanner_real_stop (ValadocWikiScanner* self);
static gchar* valadoc_wiki_scanner_real_get_line_content (ValadocWikiScanner* self);
static void valadoc_wiki_scanner_real_accept (ValadocWikiScanner* self,
                                       gunichar c,
                                       GError** error);
static void valadoc_wiki_scanner_append_char (ValadocWikiScanner* self,
                                       gunichar c);
static void valadoc_wiki_scanner_look_for_three (ValadocWikiScanner* self,
                                          gunichar c,
                                          ValadocTokenType* one,
                                          ValadocTokenType* two,
                                          ValadocTokenType* three,
                                          GError** error);
static void valadoc_wiki_scanner_look_for_two_or_append (ValadocWikiScanner* self,
                                                  gunichar c,
                                                  ValadocTokenType* type,
                                                  GError** error);
static void valadoc_wiki_scanner_look_for_two (ValadocWikiScanner* self,
                                        gunichar c,
                                        ValadocTokenType* one,
                                        ValadocTokenType* two,
                                        GError** error);
static void valadoc_wiki_scanner_look_for_five (ValadocWikiScanner* self,
                                         gunichar c,
                                         ValadocTokenType* one,
                                         ValadocTokenType* two,
                                         ValadocTokenType* three,
                                         ValadocTokenType* four,
                                         ValadocTokenType* five,
                                         GError** error);
static gboolean valadoc_wiki_scanner_look_for (ValadocWikiScanner* self,
                                        const gchar* str,
                                        ValadocTokenType* type,
                                        GError** error);
static gint valadoc_wiki_scanner_real_get_line_start_column (ValadocWikiScanner* self);
static void valadoc_wiki_scanner_get_begin (ValadocWikiScanner* self,
                                     ValaSourceLocation* result);
static void valadoc_wiki_scanner_get_end (ValadocWikiScanner* self,
                                   gint offset,
                                   ValaSourceLocation* result);
static void valadoc_wiki_scanner_emit_current_word (ValadocWikiScanner* self,
                                             GError** error);
static void valadoc_wiki_scanner_finalize (GObject * obj);
static GType valadoc_wiki_scanner_get_type_once (void);

static inline gpointer
valadoc_wiki_scanner_get_instance_private (ValadocWikiScanner* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocWikiScanner_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

ValadocWikiScanner*
valadoc_wiki_scanner_construct (GType object_type,
                                ValadocSettings* settings)
{
	ValadocWikiScanner * self = NULL;
	ValadocSettings* _tmp0_;
	g_return_val_if_fail (settings != NULL, NULL);
	self = (ValadocWikiScanner*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	return self;
}

ValadocWikiScanner*
valadoc_wiki_scanner_new (ValadocSettings* settings)
{
	return valadoc_wiki_scanner_construct (VALADOC_TYPE_WIKI_SCANNER, settings);
}

static gpointer
_valadoc_parser_ref0 (gpointer self)
{
	return self ? valadoc_parser_ref (self) : NULL;
}

static void
valadoc_wiki_scanner_real_set_parser (ValadocScanner* base,
                                      ValadocParser* parser)
{
	ValadocWikiScanner * self;
	ValadocParser* _tmp0_;
	self = (ValadocWikiScanner*) base;
	g_return_if_fail (parser != NULL);
	_tmp0_ = _valadoc_parser_ref0 (parser);
	_valadoc_parser_unref0 (self->priv->_parser);
	self->priv->_parser = _tmp0_;
}

static void
valadoc_wiki_scanner_real_reset (ValadocWikiScanner* self)
{
	GString* _tmp0_;
	self->priv->_stop = FALSE;
	self->priv->_last_line = 0;
	self->priv->_last_column = 0;
	self->priv->_line = 0;
	self->priv->_column = 0;
	self->priv->_url_escape_mode = FALSE;
	self->priv->_code_escape_mode = FALSE;
	self->priv->_last_char = (gunichar) 0;
	self->priv->_skip = 0;
	_tmp0_ = self->priv->_current_string;
	g_string_erase (_tmp0_, (gssize) 0, (gssize) -1);
}

void
valadoc_wiki_scanner_reset (ValadocWikiScanner* self)
{
	g_return_if_fail (self != NULL);
	VALADOC_WIKI_SCANNER_GET_CLASS (self)->reset (self);
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}

static void
valadoc_wiki_scanner_real_scan (ValadocScanner* base,
                                const gchar* content,
                                GError** error)
{
	ValadocWikiScanner * self;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (ValadocWikiScanner*) base;
	g_return_if_fail (content != NULL);
	_tmp0_ = g_strdup (content);
	_g_free0 (self->priv->_content);
	self->priv->_content = _tmp0_;
	{
		const gchar* _tmp1_;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = self->priv->_content;
		self->priv->_index = _tmp1_;
		_tmp2_ = TRUE;
		while (TRUE) {
			gboolean _tmp5_ = FALSE;
			gunichar c = 0U;
			const gchar* _tmp7_;
			if (!_tmp2_) {
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				_tmp3_ = self->priv->_index;
				_tmp4_ = g_utf8_next_char (_tmp3_);
				self->priv->_index = _tmp4_;
			}
			_tmp2_ = FALSE;
			if (!self->priv->_stop) {
				const gchar* _tmp6_;
				_tmp6_ = self->priv->_index;
				_tmp5_ = string_get_char (_tmp6_, (glong) 0) != ((gunichar) 0);
			} else {
				_tmp5_ = FALSE;
			}
			if (!_tmp5_) {
				break;
			}
			_tmp7_ = self->priv->_index;
			c = string_get_char (_tmp7_, (glong) 0);
			valadoc_wiki_scanner_accept (self, c, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
		}
	}
}

static void
valadoc_wiki_scanner_real_end (ValadocScanner* base,
                               GError** error)
{
	ValadocWikiScanner * self;
	ValadocTokenType* _tmp0_;
	GError* _inner_error0_ = NULL;
	self = (ValadocWikiScanner*) base;
	_tmp0_ = valadoc_token_type_EOF;
	valadoc_wiki_scanner_emit_token (self, _tmp0_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static void
valadoc_wiki_scanner_real_stop (ValadocWikiScanner* self)
{
	self->priv->_stop = TRUE;
}

void
valadoc_wiki_scanner_stop (ValadocWikiScanner* self)
{
	g_return_if_fail (self != NULL);
	VALADOC_WIKI_SCANNER_GET_CLASS (self)->stop (self);
}

void
valadoc_wiki_scanner_set_url_escape_mode (ValadocWikiScanner* self,
                                          gboolean escape_mode)
{
	g_return_if_fail (self != NULL);
	self->priv->_url_escape_mode = escape_mode;
}

void
valadoc_wiki_scanner_set_code_escape_mode (ValadocWikiScanner* self,
                                           gboolean escape_mode)
{
	g_return_if_fail (self != NULL);
	self->priv->_code_escape_mode = escape_mode;
}

gint
valadoc_wiki_scanner_get_line (ValadocWikiScanner* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_line;
	return result;
}

static gchar*
valadoc_wiki_scanner_real_get_line_content (ValadocWikiScanner* self)
{
	GString* builder = NULL;
	GString* _tmp0_;
	const gchar* line_start = NULL;
	const gchar* _tmp1_;
	gunichar c = 0U;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* result = NULL;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->priv->_index;
	line_start = _tmp1_;
	while (TRUE) {
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp3_ = line_start;
		_tmp4_ = self->priv->_content;
		if (((gchar*) _tmp3_) > ((gchar*) _tmp4_)) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = line_start;
			_tmp6_ = g_utf8_prev_char (_tmp5_);
			_tmp2_ = string_get_char (_tmp6_, (glong) 0) != ((gunichar) '\n');
		} else {
			_tmp2_ = FALSE;
		}
		if (!_tmp2_) {
			break;
		}
		_tmp7_ = line_start;
		_tmp8_ = g_utf8_prev_char (_tmp7_);
		line_start = _tmp8_;
	}
	while (TRUE) {
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp10_ = line_start;
		c = string_get_char (_tmp10_, (glong) 0);
		if (c != ((gunichar) '\n')) {
			_tmp9_ = c != ((gunichar) '\0');
		} else {
			_tmp9_ = FALSE;
		}
		if (!_tmp9_) {
			break;
		}
		if (c == ((gunichar) '\t')) {
			GString* _tmp11_;
			_tmp11_ = builder;
			g_string_append_c (_tmp11_, ' ');
		} else {
			GString* _tmp12_;
			_tmp12_ = builder;
			g_string_append_unichar (_tmp12_, c);
		}
		_tmp13_ = line_start;
		_tmp14_ = g_utf8_next_char (_tmp13_);
		line_start = _tmp14_;
	}
	_tmp15_ = builder;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (builder);
	return result;
}

gchar*
valadoc_wiki_scanner_get_line_content (ValadocWikiScanner* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_WIKI_SCANNER_GET_CLASS (self)->get_line_content (self);
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
	result = (gint) (_tmp0_ - ((gchar*) self));
	return result;
}

gunichar
valadoc_wiki_scanner_get_next_char (ValadocWikiScanner* self,
                                    gint offset)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->_index;
	_tmp1_ = self->priv->_index;
	result = string_get_char (_tmp0_, (glong) string_index_of_nth_char (_tmp1_, (glong) offset));
	return result;
}

static void
valadoc_wiki_scanner_real_accept (ValadocWikiScanner* self,
                                  gunichar c,
                                  GError** error)
{
	gint _tmp0_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = self->priv->_column;
	self->priv->_column = _tmp0_ + 1;
	if (self->priv->_skip == 0) {
		if (self->priv->_code_escape_mode) {
			gboolean _tmp1_ = FALSE;
			gboolean _tmp2_ = FALSE;
			if (c == ((gunichar) '}')) {
				_tmp2_ = valadoc_wiki_scanner_get_next_char (self, 1) == ((gunichar) '}');
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				_tmp1_ = valadoc_wiki_scanner_get_next_char (self, 2) == ((gunichar) '}');
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				ValadocTokenType* _tmp3_;
				self->priv->_code_escape_mode = FALSE;
				_tmp3_ = valadoc_token_type_TRIPLE_CLOSED_BRACE;
				valadoc_wiki_scanner_emit_token (self, _tmp3_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				self->priv->_skip = 2;
			} else {
				valadoc_wiki_scanner_append_char (self, c);
			}
			return;
		} else {
			if (self->priv->_url_escape_mode) {
				switch (c) {
					case ';':
					case '/':
					case '?':
					case ':':
					case '@':
					case '#':
					case '=':
					case '&':
					case '$':
					case '-':
					case '_':
					case '.':
					case '+':
					case '!':
					case '*':
					case '\'':
					case '(':
					case ')':
					case ',':
					{
						valadoc_wiki_scanner_append_char (self, c);
						return;
					}
					default:
					{
						break;
					}
				}
			}
		}
		switch (c) {
			case '@':
			{
				ValadocTokenType* _tmp4_;
				_tmp4_ = valadoc_token_type_AROBASE;
				valadoc_wiki_scanner_emit_token (self, _tmp4_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			case '{':
			{
				ValadocTokenType* _tmp5_;
				ValadocTokenType* _tmp6_;
				ValadocTokenType* _tmp7_;
				_tmp5_ = valadoc_token_type_OPEN_BRACE;
				_tmp6_ = valadoc_token_type_DOUBLE_OPEN_BRACE;
				_tmp7_ = valadoc_token_type_TRIPLE_OPEN_BRACE;
				valadoc_wiki_scanner_look_for_three (self, c, _tmp5_, _tmp6_, _tmp7_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			case '}':
			{
				ValadocTokenType* _tmp8_;
				ValadocTokenType* _tmp9_;
				ValadocTokenType* _tmp10_;
				_tmp8_ = valadoc_token_type_CLOSED_BRACE;
				_tmp9_ = valadoc_token_type_DOUBLE_CLOSED_BRACE;
				_tmp10_ = valadoc_token_type_TRIPLE_CLOSED_BRACE;
				valadoc_wiki_scanner_look_for_three (self, c, _tmp8_, _tmp9_, _tmp10_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			case '[':
			{
				ValadocTokenType* _tmp11_;
				_tmp11_ = valadoc_token_type_DOUBLE_OPEN_BRACKET;
				valadoc_wiki_scanner_look_for_two_or_append (self, c, _tmp11_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			case ']':
			{
				ValadocTokenType* _tmp12_;
				_tmp12_ = valadoc_token_type_DOUBLE_CLOSED_BRACKET;
				valadoc_wiki_scanner_look_for_two_or_append (self, c, _tmp12_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			case '|':
			{
				ValadocTokenType* _tmp13_;
				ValadocTokenType* _tmp14_;
				_tmp13_ = valadoc_token_type_PIPE;
				_tmp14_ = valadoc_token_type_DOUBLE_PIPE;
				valadoc_wiki_scanner_look_for_two (self, c, _tmp13_, _tmp14_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			case ')':
			{
				if (valadoc_wiki_scanner_get_next_char (self, 1) == ((gunichar) ')')) {
					ValadocTokenType* _tmp15_;
					_tmp15_ = valadoc_token_type_ALIGN_RIGHT;
					valadoc_wiki_scanner_emit_token (self, _tmp15_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error0_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					self->priv->_skip = 1;
				} else {
					if (valadoc_wiki_scanner_get_next_char (self, 1) == ((gunichar) '(')) {
						ValadocTokenType* _tmp16_;
						_tmp16_ = valadoc_token_type_ALIGN_CENTER;
						valadoc_wiki_scanner_emit_token (self, _tmp16_, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
								g_propagate_error (error, _inner_error0_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
								g_clear_error (&_inner_error0_);
								return;
							}
						}
						self->priv->_skip = 1;
					} else {
						valadoc_wiki_scanner_append_char (self, c);
					}
				}
				break;
			}
			case '-':
			{
				ValadocTokenType* _tmp17_;
				_tmp17_ = valadoc_token_type_MINUS;
				valadoc_wiki_scanner_emit_token (self, _tmp17_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			case '=':
			{
				ValadocTokenType* _tmp18_;
				ValadocTokenType* _tmp19_;
				ValadocTokenType* _tmp20_;
				ValadocTokenType* _tmp21_;
				ValadocTokenType* _tmp22_;
				_tmp18_ = valadoc_token_type_EQUAL_1;
				_tmp19_ = valadoc_token_type_EQUAL_2;
				_tmp20_ = valadoc_token_type_EQUAL_3;
				_tmp21_ = valadoc_token_type_EQUAL_4;
				_tmp22_ = valadoc_token_type_EQUAL_5;
				valadoc_wiki_scanner_look_for_five (self, c, _tmp18_, _tmp19_, _tmp20_, _tmp21_, _tmp22_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			case '<':
			{
				gboolean _tmp23_ = FALSE;
				ValadocTokenType* _tmp24_;
				_tmp24_ = valadoc_token_type_BREAK;
				_tmp23_ = valadoc_wiki_scanner_look_for (self, "<<BR>>", _tmp24_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				if (!_tmp23_) {
					ValadocTokenType* _tmp25_;
					_tmp25_ = valadoc_token_type_LESS_THAN;
					valadoc_wiki_scanner_emit_token (self, _tmp25_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error0_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
				break;
			}
			case '>':
			{
				ValadocTokenType* _tmp26_;
				_tmp26_ = valadoc_token_type_GREATER_THAN;
				valadoc_wiki_scanner_emit_token (self, _tmp26_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			case '^':
			{
				ValadocTokenType* _tmp27_;
				_tmp27_ = valadoc_token_type_ALIGN_TOP;
				valadoc_wiki_scanner_emit_token (self, _tmp27_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			case 'v':
			{
				gunichar next_char = 0U;
				gboolean _tmp28_ = FALSE;
				gboolean _tmp29_ = FALSE;
				gboolean _tmp30_ = FALSE;
				next_char = valadoc_wiki_scanner_get_next_char (self, 1);
				if (g_unichar_isalnum (self->priv->_last_char)) {
					_tmp30_ = TRUE;
				} else {
					_tmp30_ = self->priv->_last_char == ((gunichar) ' ');
				}
				if (_tmp30_) {
					_tmp29_ = TRUE;
				} else {
					_tmp29_ = g_unichar_isalnum (next_char);
				}
				if (_tmp29_) {
					_tmp28_ = TRUE;
				} else {
					_tmp28_ = next_char == ((gunichar) ' ');
				}
				if (_tmp28_) {
					valadoc_wiki_scanner_append_char (self, c);
				} else {
					ValadocTokenType* _tmp31_;
					_tmp31_ = valadoc_token_type_ALIGN_BOTTOM;
					valadoc_wiki_scanner_emit_token (self, _tmp31_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error0_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
				}
				break;
			}
			case '\'':
			{
				ValadocTokenType* _tmp32_;
				_tmp32_ = valadoc_token_type_SINGLE_QUOTE_2;
				valadoc_wiki_scanner_look_for_two_or_append (self, c, _tmp32_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			case '/':
			{
				ValadocTokenType* _tmp33_;
				_tmp33_ = valadoc_token_type_SLASH_2;
				valadoc_wiki_scanner_look_for_two_or_append (self, c, _tmp33_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			case '_':
			{
				ValadocTokenType* _tmp34_;
				_tmp34_ = valadoc_token_type_UNDERSCORE_2;
				valadoc_wiki_scanner_look_for_two_or_append (self, c, _tmp34_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			case '`':
			{
				if (valadoc_wiki_scanner_get_next_char (self, 1) == ((gunichar) '`')) {
					ValadocTokenType* _tmp35_;
					_tmp35_ = valadoc_token_type_BACK_QUOTE_2;
					valadoc_wiki_scanner_emit_token (self, _tmp35_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error0_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					self->priv->_skip = 1;
				} else {
					valadoc_wiki_scanner_append_char (self, c);
				}
				break;
			}
			case '\t':
			{
				ValadocTokenType* _tmp36_;
				_tmp36_ = valadoc_token_type_TAB;
				valadoc_wiki_scanner_emit_token (self, _tmp36_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			case ' ':
			{
				ValadocTokenType* _tmp37_;
				_tmp37_ = valadoc_token_type_SPACE;
				valadoc_wiki_scanner_emit_token (self, _tmp37_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				break;
			}
			case '\r':
			{
				break;
			}
			case '\n':
			{
				ValadocTokenType* _tmp38_;
				gint _tmp39_;
				_tmp38_ = valadoc_token_type_EOL;
				valadoc_wiki_scanner_emit_token (self, _tmp38_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				_tmp39_ = self->priv->_line;
				self->priv->_line = _tmp39_ + 1;
				self->priv->_column = 0;
				self->priv->_last_column = 0;
				break;
			}
			default:
			{
				valadoc_wiki_scanner_append_char (self, c);
				break;
			}
		}
	} else {
		gint _tmp40_;
		_tmp40_ = self->priv->_skip;
		self->priv->_skip = _tmp40_ - 1;
	}
	self->priv->_last_char = c;
}

void
valadoc_wiki_scanner_accept (ValadocWikiScanner* self,
                             gunichar c,
                             GError** error)
{
	g_return_if_fail (self != NULL);
	VALADOC_WIKI_SCANNER_GET_CLASS (self)->accept (self, c, error);
}

static void
valadoc_wiki_scanner_append_char (ValadocWikiScanner* self,
                                  gunichar c)
{
	GString* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_string;
	g_string_append_unichar (_tmp0_, c);
}

static gint
valadoc_wiki_scanner_real_get_line_start_column (ValadocWikiScanner* self)
{
	gint result = 0;
	result = 0;
	return result;
}

gint
valadoc_wiki_scanner_get_line_start_column (ValadocWikiScanner* self)
{
	g_return_val_if_fail (self != NULL, 0);
	return VALADOC_WIKI_SCANNER_GET_CLASS (self)->get_line_start_column (self);
}

static void
valadoc_wiki_scanner_get_begin (ValadocWikiScanner* self,
                                ValaSourceLocation* result)
{
	const gchar* _tmp0_;
	ValaSourceLocation _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_index;
	vala_source_location_init (&_tmp1_, _tmp0_, self->priv->_last_line, valadoc_wiki_scanner_get_line_start_column (self) + self->priv->_last_column);
	*result = _tmp1_;
	return;
}

static void
valadoc_wiki_scanner_get_end (ValadocWikiScanner* self,
                              gint offset,
                              ValaSourceLocation* result)
{
	const gchar* _tmp0_;
	ValaSourceLocation _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_index;
	vala_source_location_init (&_tmp1_, _tmp0_, self->priv->_line, (valadoc_wiki_scanner_get_line_start_column (self) + self->priv->_column) + offset);
	*result = _tmp1_;
	return;
}

static void
valadoc_wiki_scanner_emit_current_word (ValadocWikiScanner* self,
                                        GError** error)
{
	GString* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_current_string;
	if (_tmp0_->len > ((gssize) 0)) {
		ValadocParser* _tmp1_;
		GString* _tmp2_;
		const gchar* _tmp3_;
		ValaSourceLocation _tmp4_ = {0};
		ValaSourceLocation _tmp5_ = {0};
		ValadocToken* _tmp6_;
		ValadocToken* _tmp7_;
		GString* _tmp8_;
		_tmp1_ = self->priv->_parser;
		_tmp2_ = self->priv->_current_string;
		_tmp3_ = _tmp2_->str;
		valadoc_wiki_scanner_get_begin (self, &_tmp4_);
		valadoc_wiki_scanner_get_end (self, -1, &_tmp5_);
		_tmp6_ = valadoc_token_new_from_word (_tmp3_, &_tmp4_, &_tmp5_);
		_tmp7_ = _tmp6_;
		valadoc_parser_accept_token (_tmp1_, _tmp7_, &_inner_error0_);
		_g_object_unref0 (_tmp7_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		_tmp8_ = self->priv->_current_string;
		g_string_erase (_tmp8_, (gssize) 0, (gssize) -1);
		self->priv->_last_line = self->priv->_line;
		self->priv->_last_column = self->priv->_column - 1;
	}
}

static void
valadoc_wiki_scanner_emit_token (ValadocWikiScanner* self,
                                 ValadocTokenType* type,
                                 GError** error)
{
	ValadocParser* _tmp0_;
	ValaSourceLocation _tmp1_ = {0};
	ValaSourceLocation _tmp2_ = {0};
	ValadocToken* _tmp3_;
	ValadocToken* _tmp4_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	valadoc_wiki_scanner_emit_current_word (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp0_ = self->priv->_parser;
	valadoc_wiki_scanner_get_begin (self, &_tmp1_);
	valadoc_wiki_scanner_get_end (self, self->priv->_skip, &_tmp2_);
	_tmp3_ = valadoc_token_new_from_type (type, &_tmp1_, &_tmp2_, NULL);
	_tmp4_ = _tmp3_;
	valadoc_parser_accept_token (_tmp0_, _tmp4_, &_inner_error0_);
	_g_object_unref0 (_tmp4_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	self->priv->_last_line = self->priv->_line;
	self->priv->_last_column = self->priv->_column;
}

static void
valadoc_wiki_scanner_look_for_two_or_append (ValadocWikiScanner* self,
                                             gunichar c,
                                             ValadocTokenType* type,
                                             GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	if (valadoc_wiki_scanner_get_next_char (self, 1) == c) {
		valadoc_wiki_scanner_emit_token (self, type, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		self->priv->_skip = 1;
	} else {
		valadoc_wiki_scanner_append_char (self, c);
	}
}

static void
valadoc_wiki_scanner_look_for_two (ValadocWikiScanner* self,
                                   gunichar c,
                                   ValadocTokenType* one,
                                   ValadocTokenType* two,
                                   GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (one != NULL);
	g_return_if_fail (two != NULL);
	if (valadoc_wiki_scanner_get_next_char (self, 1) == c) {
		valadoc_wiki_scanner_emit_token (self, two, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
		self->priv->_skip = 1;
	} else {
		valadoc_wiki_scanner_emit_token (self, one, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
}

static void
valadoc_wiki_scanner_look_for_three (ValadocWikiScanner* self,
                                     gunichar c,
                                     ValadocTokenType* one,
                                     ValadocTokenType* two,
                                     ValadocTokenType* three,
                                     GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (one != NULL);
	g_return_if_fail (two != NULL);
	g_return_if_fail (three != NULL);
	if (valadoc_wiki_scanner_get_next_char (self, 1) == c) {
		if (valadoc_wiki_scanner_get_next_char (self, 2) == c) {
			valadoc_wiki_scanner_emit_token (self, three, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			self->priv->_skip = 2;
		} else {
			valadoc_wiki_scanner_emit_token (self, two, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			self->priv->_skip = 1;
		}
	} else {
		valadoc_wiki_scanner_emit_token (self, one, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
}

static void
valadoc_wiki_scanner_look_for_five (ValadocWikiScanner* self,
                                    gunichar c,
                                    ValadocTokenType* one,
                                    ValadocTokenType* two,
                                    ValadocTokenType* three,
                                    ValadocTokenType* four,
                                    ValadocTokenType* five,
                                    GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (one != NULL);
	g_return_if_fail (two != NULL);
	g_return_if_fail (three != NULL);
	g_return_if_fail (four != NULL);
	g_return_if_fail (five != NULL);
	if (valadoc_wiki_scanner_get_next_char (self, 1) == c) {
		if (valadoc_wiki_scanner_get_next_char (self, 2) == c) {
			if (valadoc_wiki_scanner_get_next_char (self, 3) == c) {
				if (valadoc_wiki_scanner_get_next_char (self, 4) == c) {
					valadoc_wiki_scanner_emit_token (self, five, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error0_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					self->priv->_skip = 4;
				} else {
					valadoc_wiki_scanner_emit_token (self, four, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
							g_propagate_error (error, _inner_error0_);
							return;
						} else {
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return;
						}
					}
					self->priv->_skip = 3;
				}
			} else {
				valadoc_wiki_scanner_emit_token (self, three, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
						g_propagate_error (error, _inner_error0_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return;
					}
				}
				self->priv->_skip = 2;
			}
		} else {
			valadoc_wiki_scanner_emit_token (self, two, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
					g_propagate_error (error, _inner_error0_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
			}
			self->priv->_skip = 1;
		}
	} else {
		valadoc_wiki_scanner_emit_token (self, one, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
				g_propagate_error (error, _inner_error0_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gboolean
valadoc_wiki_scanner_look_for (ValadocWikiScanner* self,
                               const gchar* str,
                               ValadocTokenType* type,
                               GError** error)
{
	gint _tmp6_;
	gint _tmp7_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (str != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				gint _tmp3_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = strlen (str);
				_tmp3_ = _tmp2_;
				if (!(i < _tmp3_)) {
					break;
				}
				if (valadoc_wiki_scanner_get_next_char (self, i) != ((gunichar) string_get (str, (glong) i))) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	valadoc_wiki_scanner_emit_token (self, type, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == VALADOC_PARSER_ERROR) {
			gboolean _tmp4_ = FALSE;
			g_propagate_error (error, _inner_error0_);
			return _tmp4_;
		} else {
			gboolean _tmp5_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp5_;
		}
	}
	_tmp6_ = strlen (str);
	_tmp7_ = _tmp6_;
	self->priv->_skip = (gint) (_tmp7_ - 1);
	result = TRUE;
	return result;
}

static void
valadoc_wiki_scanner_class_init (ValadocWikiScannerClass * klass,
                                 gpointer klass_data)
{
	valadoc_wiki_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocWikiScanner_private_offset);
	((ValadocWikiScannerClass *) klass)->reset = (void (*) (ValadocWikiScanner*)) valadoc_wiki_scanner_real_reset;
	((ValadocWikiScannerClass *) klass)->stop = (void (*) (ValadocWikiScanner*)) valadoc_wiki_scanner_real_stop;
	((ValadocWikiScannerClass *) klass)->get_line_content = (gchar* (*) (ValadocWikiScanner*)) valadoc_wiki_scanner_real_get_line_content;
	((ValadocWikiScannerClass *) klass)->accept = (void (*) (ValadocWikiScanner*, gunichar, GError**)) valadoc_wiki_scanner_real_accept;
	((ValadocWikiScannerClass *) klass)->get_line_start_column = (gint (*) (ValadocWikiScanner*)) valadoc_wiki_scanner_real_get_line_start_column;
	G_OBJECT_CLASS (klass)->finalize = valadoc_wiki_scanner_finalize;
}

static void
valadoc_wiki_scanner_valadoc_scanner_interface_init (ValadocScannerIface * iface,
                                                     gpointer iface_data)
{
	valadoc_wiki_scanner_valadoc_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_parser = (void (*) (ValadocScanner*, ValadocParser*)) valadoc_wiki_scanner_real_set_parser;
	iface->reset = (void (*) (ValadocScanner*)) valadoc_wiki_scanner_reset;
	iface->scan = (void (*) (ValadocScanner*, const gchar*, GError**)) valadoc_wiki_scanner_real_scan;
	iface->end = (void (*) (ValadocScanner*, GError**)) valadoc_wiki_scanner_real_end;
	iface->stop = (void (*) (ValadocScanner*)) valadoc_wiki_scanner_stop;
	iface->get_line_content = (gchar* (*) (ValadocScanner*)) valadoc_wiki_scanner_get_line_content;
}

static void
valadoc_wiki_scanner_instance_init (ValadocWikiScanner * self,
                                    gpointer klass)
{
	GString* _tmp0_;
	self->priv = valadoc_wiki_scanner_get_instance_private (self);
	_tmp0_ = g_string_new ("");
	self->priv->_current_string = _tmp0_;
}

static void
valadoc_wiki_scanner_finalize (GObject * obj)
{
	ValadocWikiScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_TYPE_WIKI_SCANNER, ValadocWikiScanner);
	_g_object_unref0 (self->priv->_settings);
	_valadoc_parser_unref0 (self->priv->_parser);
	_g_free0 (self->priv->_content);
	_g_string_free0 (self->priv->_current_string);
	G_OBJECT_CLASS (valadoc_wiki_scanner_parent_class)->finalize (obj);
}

static GType
valadoc_wiki_scanner_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValadocWikiScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_wiki_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocWikiScanner), 0, (GInstanceInitFunc) valadoc_wiki_scanner_instance_init, NULL };
	static const GInterfaceInfo valadoc_scanner_info = { (GInterfaceInitFunc) valadoc_wiki_scanner_valadoc_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType valadoc_wiki_scanner_type_id;
	valadoc_wiki_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocWikiScanner", &g_define_type_info, 0);
	g_type_add_interface_static (valadoc_wiki_scanner_type_id, VALADOC_TYPE_SCANNER, &valadoc_scanner_info);
	ValadocWikiScanner_private_offset = g_type_add_instance_private (valadoc_wiki_scanner_type_id, sizeof (ValadocWikiScannerPrivate));
	return valadoc_wiki_scanner_type_id;
}

GType
valadoc_wiki_scanner_get_type (void)
{
	static volatile gsize valadoc_wiki_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_wiki_scanner_type_id__volatile)) {
		GType valadoc_wiki_scanner_type_id;
		valadoc_wiki_scanner_type_id = valadoc_wiki_scanner_get_type_once ();
		g_once_init_leave (&valadoc_wiki_scanner_type_id__volatile, valadoc_wiki_scanner_type_id);
	}
	return valadoc_wiki_scanner_type_id__volatile;
}

