/****************************************************************************
 *
 * $Id: movePtu46.cpp 4056 2013-01-05 13:04:42Z fspindle $
 *
 * This file is part of the ViSP software.
 * Copyright (C) 2005 - 2013 by INRIA. All rights reserved.
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * ("GPL") version 2 as published by the Free Software Foundation.
 * See the file LICENSE.txt at the root directory of this source
 * distribution for additional information about the GNU GPL.
 *
 * For using ViSP with software that can not be combined with the GNU
 * GPL, please contact INRIA about acquiring a ViSP Professional 
 * Edition License.
 *
 * See http://www.irisa.fr/lagadic/visp/visp.html for more information.
 * 
 * This software was developed at:
 * INRIA Rennes - Bretagne Atlantique
 * Campus Universitaire de Beaulieu
 * 35042 Rennes Cedex
 * France
 * http://www.irisa.fr/lagadic
 *
 * If you have questions regarding the use of this file, please contact
 * INRIA at visp@inria.fr
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 *
 *
 * Description:
 *   Tests the control law
 *
 * Authors:
 * Fabien Spindler
 *
 *****************************************************************************/
/*!
  \file movePtu46.cpp

  \brief Example of a real robot control, the ptu-46 robot (pan-tilt turret). The
  robot is controlled first in position, then in velocity.

*/


/*!
  \example movePtu46.cpp

  Example of a real robot control, the ptu-46 robot (pan-tilt turret). The
  robot is controlled first in position, then in velocity.

*/
#include <visp/vpConfig.h>
#include <visp/vpDebug.h>
#ifdef UNIX
#  include <unistd.h>
#endif



#ifdef VISP_HAVE_PTU46

#include <visp/vpRobotPtu46.h>

int
main()
{
  try
  {
    vpRobotPtu46 robot ;
    vpColVector q(2) ;

    vpERROR_TRACE(" ") ;

    robot.setRobotState(vpRobot::STATE_POSITION_CONTROL) ;

    q = 0;
    vpCTRACE << "Set position in the articular frame: " << q.t();
    robot.setPosition(vpRobot::ARTICULAR_FRAME, q) ;

    q[0] = vpMath::rad(10);
    q[1] = vpMath::rad(20);
    vpCTRACE << "Set position in the articular frame: " << q.t();
    robot.setPosition(vpRobot::ARTICULAR_FRAME, q) ;

    vpColVector qm(2) ;
    robot.getPosition(vpRobot::ARTICULAR_FRAME, qm) ;
    vpCTRACE << "Position in the articular frame " << qm.t() ;

    vpColVector qdot(2) ;
    robot.setRobotState(vpRobot::STATE_VELOCITY_CONTROL) ;
#if 0
    qdot = 0 ;
    qdot[0] = vpMath::rad(10) ;
    qdot[1] = vpMath::rad(10) ;
    vpCTRACE << "Set camera frame velocity " << qdot.t() ;

    robot.setVelocity(vpRobot::CAMERA_FRAME, qdot) ;
    sleep(2) ;

    qdot = 0 ;
    qdot[0] = vpMath::rad(-10) ;
    qdot[1] = vpMath::rad(-10) ;

    vpCTRACE << "Set camera frame velocity " << qdot.t() ;
    robot.setVelocity(vpRobot::CAMERA_FRAME, qdot) ;
    sleep(2) ;
#endif

    qdot = 0 ;
    //  qdot[0] = vpMath::rad(0.1) ;
    qdot[1] = vpMath::rad(10) ;
    vpCTRACE << "Set articular frame velocity " << qdot.t() ;
    robot.setVelocity(vpRobot::ARTICULAR_FRAME, qdot) ;
    sleep(2) ;

    qdot = 0 ;
    qdot[0] = vpMath::rad(-5);
    //qdot[1] = vpMath::rad(-5);

    vpCTRACE << "Set articular frame velocity " << qdot.t() ;
    robot.setVelocity(vpRobot::ARTICULAR_FRAME, qdot) ;
    sleep(2) ;
  }
  catch (...)
  {
    std::cout << "Sorry PtU46 not available ..." << std::endl;
  }

  return 0;

}
#else
int
main()
{
  vpERROR_TRACE("You do not have a ptu-46 robot connected to your computer...");
  return 0; 
}

#endif
