// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_UADDL2_8H_TRACE_AARCH64_H_
#define VIXL_SIM_UADDL2_8H_TRACE_AARCH64_H_

const uint16_t kExpected_NEON_uaddl2_8H[] = {
  0x0106, 0x0154, 0x0198, 0x01f0, 0x01fa, 0x01fc, 0x01fe, 0x0000,
  0x012d, 0x0176, 0x01c4, 0x01f5, 0x01fb, 0x01fd, 0x00ff, 0x0001,
  0x014f, 0x01a2, 0x01c9, 0x01f6, 0x01fc, 0x00fe, 0x0100, 0x0002,
  0x017b, 0x01a7, 0x01ca, 0x01f7, 0x00fd, 0x00ff, 0x0101, 0x0008,
  0x0180, 0x01a8, 0x01cb, 0x00f8, 0x00fe, 0x0100, 0x0107, 0x0033,
  0x0181, 0x01a9, 0x00cc, 0x00f9, 0x00ff, 0x0106, 0x0132, 0x0055,
  0x0182, 0x00aa, 0x00cd, 0x00fa, 0x0105, 0x0131, 0x0154, 0x007d,
  0x0083, 0x00ab, 0x00ce, 0x0100, 0x0130, 0x0153, 0x017c, 0x007e,
  0x0084, 0x00ac, 0x00d4, 0x012b, 0x0152, 0x017b, 0x017d, 0x007f,
  0x0085, 0x00b2, 0x00ff, 0x014d, 0x017a, 0x017c, 0x017e, 0x0080,
  0x008b, 0x00dd, 0x0121, 0x0175, 0x017b, 0x017d, 0x017f, 0x0081,
  0x00b6, 0x00ff, 0x0149, 0x0176, 0x017c, 0x017e, 0x0180, 0x0082,
  0x00d8, 0x0127, 0x014a, 0x0177, 0x017d, 0x017f, 0x0181, 0x0083,
  0x0100, 0x0128, 0x014b, 0x0178, 0x017e, 0x0180, 0x0182, 0x00aa,
  0x0101, 0x0129, 0x014c, 0x0179, 0x017f, 0x0181, 0x01a9, 0x00cc,
  0x0102, 0x012a, 0x014d, 0x017a, 0x0180, 0x01a8, 0x01cb, 0x00f8,
  0x0103, 0x012b, 0x014e, 0x017b, 0x01a7, 0x01ca, 0x01f7, 0x00fd,
  0x0104, 0x012c, 0x014f, 0x01a2, 0x01c9, 0x01f6, 0x01fc, 0x00fe,
  0x0105, 0x012d, 0x0176, 0x01c4, 0x01f5, 0x01fb, 0x01fd, 0x00ff,
  0x012d, 0x0176, 0x01c4, 0x01f5, 0x01fb, 0x01fd, 0x00ff, 0x0001,
  0x0154, 0x0198, 0x01f0, 0x01fa, 0x01fc, 0x01fe, 0x0000, 0x0002,
  0x0176, 0x01c4, 0x01f5, 0x01fb, 0x01fd, 0x00ff, 0x0001, 0x0003,
  0x01a2, 0x01c9, 0x01f6, 0x01fc, 0x00fe, 0x0100, 0x0002, 0x0009,
  0x01a7, 0x01ca, 0x01f7, 0x00fd, 0x00ff, 0x0101, 0x0008, 0x0034,
  0x01a8, 0x01cb, 0x00f8, 0x00fe, 0x0100, 0x0107, 0x0033, 0x0056,
  0x01a9, 0x00cc, 0x00f9, 0x00ff, 0x0106, 0x0132, 0x0055, 0x007e,
  0x00aa, 0x00cd, 0x00fa, 0x0105, 0x0131, 0x0154, 0x007d, 0x007f,
  0x00ab, 0x00ce, 0x0100, 0x0130, 0x0153, 0x017c, 0x007e, 0x0080,
  0x00ac, 0x00d4, 0x012b, 0x0152, 0x017b, 0x017d, 0x007f, 0x0081,
  0x00b2, 0x00ff, 0x014d, 0x017a, 0x017c, 0x017e, 0x0080, 0x0082,
  0x00dd, 0x0121, 0x0175, 0x017b, 0x017d, 0x017f, 0x0081, 0x0083,
  0x00ff, 0x0149, 0x0176, 0x017c, 0x017e, 0x0180, 0x0082, 0x0084,
  0x0127, 0x014a, 0x0177, 0x017d, 0x017f, 0x0181, 0x0083, 0x00ab,
  0x0128, 0x014b, 0x0178, 0x017e, 0x0180, 0x0182, 0x00aa, 0x00cd,
  0x0129, 0x014c, 0x0179, 0x017f, 0x0181, 0x01a9, 0x00cc, 0x00f9,
  0x012a, 0x014d, 0x017a, 0x0180, 0x01a8, 0x01cb, 0x00f8, 0x00fe,
  0x012b, 0x014e, 0x017b, 0x01a7, 0x01ca, 0x01f7, 0x00fd, 0x00ff,
  0x012c, 0x014f, 0x01a2, 0x01c9, 0x01f6, 0x01fc, 0x00fe, 0x0100,
  0x014f, 0x01a2, 0x01c9, 0x01f6, 0x01fc, 0x00fe, 0x0100, 0x0002,
  0x0176, 0x01c4, 0x01f5, 0x01fb, 0x01fd, 0x00ff, 0x0001, 0x0003,
  0x0198, 0x01f0, 0x01fa, 0x01fc, 0x01fe, 0x0000, 0x0002, 0x0004,
  0x01c4, 0x01f5, 0x01fb, 0x01fd, 0x00ff, 0x0001, 0x0003, 0x000a,
  0x01c9, 0x01f6, 0x01fc, 0x00fe, 0x0100, 0x0002, 0x0009, 0x0035,
  0x01ca, 0x01f7, 0x00fd, 0x00ff, 0x0101, 0x0008, 0x0034, 0x0057,
  0x01cb, 0x00f8, 0x00fe, 0x0100, 0x0107, 0x0033, 0x0056, 0x007f,
  0x00cc, 0x00f9, 0x00ff, 0x0106, 0x0132, 0x0055, 0x007e, 0x0080,
  0x00cd, 0x00fa, 0x0105, 0x0131, 0x0154, 0x007d, 0x007f, 0x0081,
  0x00ce, 0x0100, 0x0130, 0x0153, 0x017c, 0x007e, 0x0080, 0x0082,
  0x00d4, 0x012b, 0x0152, 0x017b, 0x017d, 0x007f, 0x0081, 0x0083,
  0x00ff, 0x014d, 0x017a, 0x017c, 0x017e, 0x0080, 0x0082, 0x0084,
  0x0121, 0x0175, 0x017b, 0x017d, 0x017f, 0x0081, 0x0083, 0x0085,
  0x0149, 0x0176, 0x017c, 0x017e, 0x0180, 0x0082, 0x0084, 0x00ac,
  0x014a, 0x0177, 0x017d, 0x017f, 0x0181, 0x0083, 0x00ab, 0x00ce,
  0x014b, 0x0178, 0x017e, 0x0180, 0x0182, 0x00aa, 0x00cd, 0x00fa,
  0x014c, 0x0179, 0x017f, 0x0181, 0x01a9, 0x00cc, 0x00f9, 0x00ff,
  0x014d, 0x017a, 0x0180, 0x01a8, 0x01cb, 0x00f8, 0x00fe, 0x0100,
  0x014e, 0x017b, 0x01a7, 0x01ca, 0x01f7, 0x00fd, 0x00ff, 0x0101,
  0x017b, 0x01a7, 0x01ca, 0x01f7, 0x00fd, 0x00ff, 0x0101, 0x0008,
  0x01a2, 0x01c9, 0x01f6, 0x01fc, 0x00fe, 0x0100, 0x0002, 0x0009,
  0x01c4, 0x01f5, 0x01fb, 0x01fd, 0x00ff, 0x0001, 0x0003, 0x000a,
  0x01f0, 0x01fa, 0x01fc, 0x01fe, 0x0000, 0x0002, 0x0004, 0x0010,
  0x01f5, 0x01fb, 0x01fd, 0x00ff, 0x0001, 0x0003, 0x000a, 0x003b,
  0x01f6, 0x01fc, 0x00fe, 0x0100, 0x0002, 0x0009, 0x0035, 0x005d,
  0x01f7, 0x00fd, 0x00ff, 0x0101, 0x0008, 0x0034, 0x0057, 0x0085,
  0x00f8, 0x00fe, 0x0100, 0x0107, 0x0033, 0x0056, 0x007f, 0x0086,
  0x00f9, 0x00ff, 0x0106, 0x0132, 0x0055, 0x007e, 0x0080, 0x0087,
  0x00fa, 0x0105, 0x0131, 0x0154, 0x007d, 0x007f, 0x0081, 0x0088,
  0x0100, 0x0130, 0x0153, 0x017c, 0x007e, 0x0080, 0x0082, 0x0089,
  0x012b, 0x0152, 0x017b, 0x017d, 0x007f, 0x0081, 0x0083, 0x008a,
  0x014d, 0x017a, 0x017c, 0x017e, 0x0080, 0x0082, 0x0084, 0x008b,
  0x0175, 0x017b, 0x017d, 0x017f, 0x0081, 0x0083, 0x0085, 0x00b2,
  0x0176, 0x017c, 0x017e, 0x0180, 0x0082, 0x0084, 0x00ac, 0x00d4,
  0x0177, 0x017d, 0x017f, 0x0181, 0x0083, 0x00ab, 0x00ce, 0x0100,
  0x0178, 0x017e, 0x0180, 0x0182, 0x00aa, 0x00cd, 0x00fa, 0x0105,
  0x0179, 0x017f, 0x0181, 0x01a9, 0x00cc, 0x00f9, 0x00ff, 0x0106,
  0x017a, 0x0180, 0x01a8, 0x01cb, 0x00f8, 0x00fe, 0x0100, 0x0107,
  0x0180, 0x01a8, 0x01cb, 0x00f8, 0x00fe, 0x0100, 0x0107, 0x0033,
  0x01a7, 0x01ca, 0x01f7, 0x00fd, 0x00ff, 0x0101, 0x0008, 0x0034,
  0x01c9, 0x01f6, 0x01fc, 0x00fe, 0x0100, 0x0002, 0x0009, 0x0035,
  0x01f5, 0x01fb, 0x01fd, 0x00ff, 0x0001, 0x0003, 0x000a, 0x003b,
  0x01fa, 0x01fc, 0x01fe, 0x0000, 0x0002, 0x0004, 0x0010, 0x0066,
  0x01fb, 0x01fd, 0x00ff, 0x0001, 0x0003, 0x000a, 0x003b, 0x0088,
  0x01fc, 0x00fe, 0x0100, 0x0002, 0x0009, 0x0035, 0x005d, 0x00b0,
  0x00fd, 0x00ff, 0x0101, 0x0008, 0x0034, 0x0057, 0x0085, 0x00b1,
  0x00fe, 0x0100, 0x0107, 0x0033, 0x0056, 0x007f, 0x0086, 0x00b2,
  0x00ff, 0x0106, 0x0132, 0x0055, 0x007e, 0x0080, 0x0087, 0x00b3,
  0x0105, 0x0131, 0x0154, 0x007d, 0x007f, 0x0081, 0x0088, 0x00b4,
  0x0130, 0x0153, 0x017c, 0x007e, 0x0080, 0x0082, 0x0089, 0x00b5,
  0x0152, 0x017b, 0x017d, 0x007f, 0x0081, 0x0083, 0x008a, 0x00b6,
  0x017a, 0x017c, 0x017e, 0x0080, 0x0082, 0x0084, 0x008b, 0x00dd,
  0x017b, 0x017d, 0x017f, 0x0081, 0x0083, 0x0085, 0x00b2, 0x00ff,
  0x017c, 0x017e, 0x0180, 0x0082, 0x0084, 0x00ac, 0x00d4, 0x012b,
  0x017d, 0x017f, 0x0181, 0x0083, 0x00ab, 0x00ce, 0x0100, 0x0130,
  0x017e, 0x0180, 0x0182, 0x00aa, 0x00cd, 0x00fa, 0x0105, 0x0131,
  0x017f, 0x0181, 0x01a9, 0x00cc, 0x00f9, 0x00ff, 0x0106, 0x0132,
  0x0181, 0x01a9, 0x00cc, 0x00f9, 0x00ff, 0x0106, 0x0132, 0x0055,
  0x01a8, 0x01cb, 0x00f8, 0x00fe, 0x0100, 0x0107, 0x0033, 0x0056,
  0x01ca, 0x01f7, 0x00fd, 0x00ff, 0x0101, 0x0008, 0x0034, 0x0057,
  0x01f6, 0x01fc, 0x00fe, 0x0100, 0x0002, 0x0009, 0x0035, 0x005d,
  0x01fb, 0x01fd, 0x00ff, 0x0001, 0x0003, 0x000a, 0x003b, 0x0088,
  0x01fc, 0x01fe, 0x0000, 0x0002, 0x0004, 0x0010, 0x0066, 0x00aa,
  0x01fd, 0x00ff, 0x0001, 0x0003, 0x000a, 0x003b, 0x0088, 0x00d2,
  0x00fe, 0x0100, 0x0002, 0x0009, 0x0035, 0x005d, 0x00b0, 0x00d3,
  0x00ff, 0x0101, 0x0008, 0x0034, 0x0057, 0x0085, 0x00b1, 0x00d4,
  0x0100, 0x0107, 0x0033, 0x0056, 0x007f, 0x0086, 0x00b2, 0x00d5,
  0x0106, 0x0132, 0x0055, 0x007e, 0x0080, 0x0087, 0x00b3, 0x00d6,
  0x0131, 0x0154, 0x007d, 0x007f, 0x0081, 0x0088, 0x00b4, 0x00d7,
  0x0153, 0x017c, 0x007e, 0x0080, 0x0082, 0x0089, 0x00b5, 0x00d8,
  0x017b, 0x017d, 0x007f, 0x0081, 0x0083, 0x008a, 0x00b6, 0x00ff,
  0x017c, 0x017e, 0x0080, 0x0082, 0x0084, 0x008b, 0x00dd, 0x0121,
  0x017d, 0x017f, 0x0081, 0x0083, 0x0085, 0x00b2, 0x00ff, 0x014d,
  0x017e, 0x0180, 0x0082, 0x0084, 0x00ac, 0x00d4, 0x012b, 0x0152,
  0x017f, 0x0181, 0x0083, 0x00ab, 0x00ce, 0x0100, 0x0130, 0x0153,
  0x0180, 0x0182, 0x00aa, 0x00cd, 0x00fa, 0x0105, 0x0131, 0x0154,
  0x0182, 0x00aa, 0x00cd, 0x00fa, 0x0105, 0x0131, 0x0154, 0x007d,
  0x01a9, 0x00cc, 0x00f9, 0x00ff, 0x0106, 0x0132, 0x0055, 0x007e,
  0x01cb, 0x00f8, 0x00fe, 0x0100, 0x0107, 0x0033, 0x0056, 0x007f,
  0x01f7, 0x00fd, 0x00ff, 0x0101, 0x0008, 0x0034, 0x0057, 0x0085,
  0x01fc, 0x00fe, 0x0100, 0x0002, 0x0009, 0x0035, 0x005d, 0x00b0,
  0x01fd, 0x00ff, 0x0001, 0x0003, 0x000a, 0x003b, 0x0088, 0x00d2,
  0x01fe, 0x0000, 0x0002, 0x0004, 0x0010, 0x0066, 0x00aa, 0x00fa,
  0x00ff, 0x0001, 0x0003, 0x000a, 0x003b, 0x0088, 0x00d2, 0x00fb,
  0x0100, 0x0002, 0x0009, 0x0035, 0x005d, 0x00b0, 0x00d3, 0x00fc,
  0x0101, 0x0008, 0x0034, 0x0057, 0x0085, 0x00b1, 0x00d4, 0x00fd,
  0x0107, 0x0033, 0x0056, 0x007f, 0x0086, 0x00b2, 0x00d5, 0x00fe,
  0x0132, 0x0055, 0x007e, 0x0080, 0x0087, 0x00b3, 0x00d6, 0x00ff,
  0x0154, 0x007d, 0x007f, 0x0081, 0x0088, 0x00b4, 0x00d7, 0x0100,
  0x017c, 0x007e, 0x0080, 0x0082, 0x0089, 0x00b5, 0x00d8, 0x0127,
  0x017d, 0x007f, 0x0081, 0x0083, 0x008a, 0x00b6, 0x00ff, 0x0149,
  0x017e, 0x0080, 0x0082, 0x0084, 0x008b, 0x00dd, 0x0121, 0x0175,
  0x017f, 0x0081, 0x0083, 0x0085, 0x00b2, 0x00ff, 0x014d, 0x017a,
  0x0180, 0x0082, 0x0084, 0x00ac, 0x00d4, 0x012b, 0x0152, 0x017b,
  0x0181, 0x0083, 0x00ab, 0x00ce, 0x0100, 0x0130, 0x0153, 0x017c,
  0x0083, 0x00ab, 0x00ce, 0x0100, 0x0130, 0x0153, 0x017c, 0x007e,
  0x00aa, 0x00cd, 0x00fa, 0x0105, 0x0131, 0x0154, 0x007d, 0x007f,
  0x00cc, 0x00f9, 0x00ff, 0x0106, 0x0132, 0x0055, 0x007e, 0x0080,
  0x00f8, 0x00fe, 0x0100, 0x0107, 0x0033, 0x0056, 0x007f, 0x0086,
  0x00fd, 0x00ff, 0x0101, 0x0008, 0x0034, 0x0057, 0x0085, 0x00b1,
  0x00fe, 0x0100, 0x0002, 0x0009, 0x0035, 0x005d, 0x00b0, 0x00d3,
  0x00ff, 0x0001, 0x0003, 0x000a, 0x003b, 0x0088, 0x00d2, 0x00fb,
  0x0000, 0x0002, 0x0004, 0x0010, 0x0066, 0x00aa, 0x00fa, 0x00fc,
  0x0001, 0x0003, 0x000a, 0x003b, 0x0088, 0x00d2, 0x00fb, 0x00fd,
  0x0002, 0x0009, 0x0035, 0x005d, 0x00b0, 0x00d3, 0x00fc, 0x00fe,
  0x0008, 0x0034, 0x0057, 0x0085, 0x00b1, 0x00d4, 0x00fd, 0x00ff,
  0x0033, 0x0056, 0x007f, 0x0086, 0x00b2, 0x00d5, 0x00fe, 0x0100,
  0x0055, 0x007e, 0x0080, 0x0087, 0x00b3, 0x00d6, 0x00ff, 0x0101,
  0x007d, 0x007f, 0x0081, 0x0088, 0x00b4, 0x00d7, 0x0100, 0x0128,
  0x007e, 0x0080, 0x0082, 0x0089, 0x00b5, 0x00d8, 0x0127, 0x014a,
  0x007f, 0x0081, 0x0083, 0x008a, 0x00b6, 0x00ff, 0x0149, 0x0176,
  0x0080, 0x0082, 0x0084, 0x008b, 0x00dd, 0x0121, 0x0175, 0x017b,
  0x0081, 0x0083, 0x0085, 0x00b2, 0x00ff, 0x014d, 0x017a, 0x017c,
  0x0082, 0x0084, 0x00ac, 0x00d4, 0x012b, 0x0152, 0x017b, 0x017d,
  0x0084, 0x00ac, 0x00d4, 0x012b, 0x0152, 0x017b, 0x017d, 0x007f,
  0x00ab, 0x00ce, 0x0100, 0x0130, 0x0153, 0x017c, 0x007e, 0x0080,
  0x00cd, 0x00fa, 0x0105, 0x0131, 0x0154, 0x007d, 0x007f, 0x0081,
  0x00f9, 0x00ff, 0x0106, 0x0132, 0x0055, 0x007e, 0x0080, 0x0087,
  0x00fe, 0x0100, 0x0107, 0x0033, 0x0056, 0x007f, 0x0086, 0x00b2,
  0x00ff, 0x0101, 0x0008, 0x0034, 0x0057, 0x0085, 0x00b1, 0x00d4,
  0x0100, 0x0002, 0x0009, 0x0035, 0x005d, 0x00b0, 0x00d3, 0x00fc,
  0x0001, 0x0003, 0x000a, 0x003b, 0x0088, 0x00d2, 0x00fb, 0x00fd,
  0x0002, 0x0004, 0x0010, 0x0066, 0x00aa, 0x00fa, 0x00fc, 0x00fe,
  0x0003, 0x000a, 0x003b, 0x0088, 0x00d2, 0x00fb, 0x00fd, 0x00ff,
  0x0009, 0x0035, 0x005d, 0x00b0, 0x00d3, 0x00fc, 0x00fe, 0x0100,
  0x0034, 0x0057, 0x0085, 0x00b1, 0x00d4, 0x00fd, 0x00ff, 0x0101,
  0x0056, 0x007f, 0x0086, 0x00b2, 0x00d5, 0x00fe, 0x0100, 0x0102,
  0x007e, 0x0080, 0x0087, 0x00b3, 0x00d6, 0x00ff, 0x0101, 0x0129,
  0x007f, 0x0081, 0x0088, 0x00b4, 0x00d7, 0x0100, 0x0128, 0x014b,
  0x0080, 0x0082, 0x0089, 0x00b5, 0x00d8, 0x0127, 0x014a, 0x0177,
  0x0081, 0x0083, 0x008a, 0x00b6, 0x00ff, 0x0149, 0x0176, 0x017c,
  0x0082, 0x0084, 0x008b, 0x00dd, 0x0121, 0x0175, 0x017b, 0x017d,
  0x0083, 0x0085, 0x00b2, 0x00ff, 0x014d, 0x017a, 0x017c, 0x017e,
  0x0085, 0x00b2, 0x00ff, 0x014d, 0x017a, 0x017c, 0x017e, 0x0080,
  0x00ac, 0x00d4, 0x012b, 0x0152, 0x017b, 0x017d, 0x007f, 0x0081,
  0x00ce, 0x0100, 0x0130, 0x0153, 0x017c, 0x007e, 0x0080, 0x0082,
  0x00fa, 0x0105, 0x0131, 0x0154, 0x007d, 0x007f, 0x0081, 0x0088,
  0x00ff, 0x0106, 0x0132, 0x0055, 0x007e, 0x0080, 0x0087, 0x00b3,
  0x0100, 0x0107, 0x0033, 0x0056, 0x007f, 0x0086, 0x00b2, 0x00d5,
  0x0101, 0x0008, 0x0034, 0x0057, 0x0085, 0x00b1, 0x00d4, 0x00fd,
  0x0002, 0x0009, 0x0035, 0x005d, 0x00b0, 0x00d3, 0x00fc, 0x00fe,
  0x0003, 0x000a, 0x003b, 0x0088, 0x00d2, 0x00fb, 0x00fd, 0x00ff,
  0x0004, 0x0010, 0x0066, 0x00aa, 0x00fa, 0x00fc, 0x00fe, 0x0100,
  0x000a, 0x003b, 0x0088, 0x00d2, 0x00fb, 0x00fd, 0x00ff, 0x0101,
  0x0035, 0x005d, 0x00b0, 0x00d3, 0x00fc, 0x00fe, 0x0100, 0x0102,
  0x0057, 0x0085, 0x00b1, 0x00d4, 0x00fd, 0x00ff, 0x0101, 0x0103,
  0x007f, 0x0086, 0x00b2, 0x00d5, 0x00fe, 0x0100, 0x0102, 0x012a,
  0x0080, 0x0087, 0x00b3, 0x00d6, 0x00ff, 0x0101, 0x0129, 0x014c,
  0x0081, 0x0088, 0x00b4, 0x00d7, 0x0100, 0x0128, 0x014b, 0x0178,
  0x0082, 0x0089, 0x00b5, 0x00d8, 0x0127, 0x014a, 0x0177, 0x017d,
  0x0083, 0x008a, 0x00b6, 0x00ff, 0x0149, 0x0176, 0x017c, 0x017e,
  0x0084, 0x008b, 0x00dd, 0x0121, 0x0175, 0x017b, 0x017d, 0x017f,
  0x008b, 0x00dd, 0x0121, 0x0175, 0x017b, 0x017d, 0x017f, 0x0081,
  0x00b2, 0x00ff, 0x014d, 0x017a, 0x017c, 0x017e, 0x0080, 0x0082,
  0x00d4, 0x012b, 0x0152, 0x017b, 0x017d, 0x007f, 0x0081, 0x0083,
  0x0100, 0x0130, 0x0153, 0x017c, 0x007e, 0x0080, 0x0082, 0x0089,
  0x0105, 0x0131, 0x0154, 0x007d, 0x007f, 0x0081, 0x0088, 0x00b4,
  0x0106, 0x0132, 0x0055, 0x007e, 0x0080, 0x0087, 0x00b3, 0x00d6,
  0x0107, 0x0033, 0x0056, 0x007f, 0x0086, 0x00b2, 0x00d5, 0x00fe,
  0x0008, 0x0034, 0x0057, 0x0085, 0x00b1, 0x00d4, 0x00fd, 0x00ff,
  0x0009, 0x0035, 0x005d, 0x00b0, 0x00d3, 0x00fc, 0x00fe, 0x0100,
  0x000a, 0x003b, 0x0088, 0x00d2, 0x00fb, 0x00fd, 0x00ff, 0x0101,
  0x0010, 0x0066, 0x00aa, 0x00fa, 0x00fc, 0x00fe, 0x0100, 0x0102,
  0x003b, 0x0088, 0x00d2, 0x00fb, 0x00fd, 0x00ff, 0x0101, 0x0103,
  0x005d, 0x00b0, 0x00d3, 0x00fc, 0x00fe, 0x0100, 0x0102, 0x0104,
  0x0085, 0x00b1, 0x00d4, 0x00fd, 0x00ff, 0x0101, 0x0103, 0x012b,
  0x0086, 0x00b2, 0x00d5, 0x00fe, 0x0100, 0x0102, 0x012a, 0x014d,
  0x0087, 0x00b3, 0x00d6, 0x00ff, 0x0101, 0x0129, 0x014c, 0x0179,
  0x0088, 0x00b4, 0x00d7, 0x0100, 0x0128, 0x014b, 0x0178, 0x017e,
  0x0089, 0x00b5, 0x00d8, 0x0127, 0x014a, 0x0177, 0x017d, 0x017f,
  0x008a, 0x00b6, 0x00ff, 0x0149, 0x0176, 0x017c, 0x017e, 0x0180,
  0x00b6, 0x00ff, 0x0149, 0x0176, 0x017c, 0x017e, 0x0180, 0x0082,
  0x00dd, 0x0121, 0x0175, 0x017b, 0x017d, 0x017f, 0x0081, 0x0083,
  0x00ff, 0x014d, 0x017a, 0x017c, 0x017e, 0x0080, 0x0082, 0x0084,
  0x012b, 0x0152, 0x017b, 0x017d, 0x007f, 0x0081, 0x0083, 0x008a,
  0x0130, 0x0153, 0x017c, 0x007e, 0x0080, 0x0082, 0x0089, 0x00b5,
  0x0131, 0x0154, 0x007d, 0x007f, 0x0081, 0x0088, 0x00b4, 0x00d7,
  0x0132, 0x0055, 0x007e, 0x0080, 0x0087, 0x00b3, 0x00d6, 0x00ff,
  0x0033, 0x0056, 0x007f, 0x0086, 0x00b2, 0x00d5, 0x00fe, 0x0100,
  0x0034, 0x0057, 0x0085, 0x00b1, 0x00d4, 0x00fd, 0x00ff, 0x0101,
  0x0035, 0x005d, 0x00b0, 0x00d3, 0x00fc, 0x00fe, 0x0100, 0x0102,
  0x003b, 0x0088, 0x00d2, 0x00fb, 0x00fd, 0x00ff, 0x0101, 0x0103,
  0x0066, 0x00aa, 0x00fa, 0x00fc, 0x00fe, 0x0100, 0x0102, 0x0104,
  0x0088, 0x00d2, 0x00fb, 0x00fd, 0x00ff, 0x0101, 0x0103, 0x0105,
  0x00b0, 0x00d3, 0x00fc, 0x00fe, 0x0100, 0x0102, 0x0104, 0x012c,
  0x00b1, 0x00d4, 0x00fd, 0x00ff, 0x0101, 0x0103, 0x012b, 0x014e,
  0x00b2, 0x00d5, 0x00fe, 0x0100, 0x0102, 0x012a, 0x014d, 0x017a,
  0x00b3, 0x00d6, 0x00ff, 0x0101, 0x0129, 0x014c, 0x0179, 0x017f,
  0x00b4, 0x00d7, 0x0100, 0x0128, 0x014b, 0x0178, 0x017e, 0x0180,
  0x00b5, 0x00d8, 0x0127, 0x014a, 0x0177, 0x017d, 0x017f, 0x0181,
  0x00d8, 0x0127, 0x014a, 0x0177, 0x017d, 0x017f, 0x0181, 0x0083,
  0x00ff, 0x0149, 0x0176, 0x017c, 0x017e, 0x0180, 0x0082, 0x0084,
  0x0121, 0x0175, 0x017b, 0x017d, 0x017f, 0x0081, 0x0083, 0x0085,
  0x014d, 0x017a, 0x017c, 0x017e, 0x0080, 0x0082, 0x0084, 0x008b,
  0x0152, 0x017b, 0x017d, 0x007f, 0x0081, 0x0083, 0x008a, 0x00b6,
  0x0153, 0x017c, 0x007e, 0x0080, 0x0082, 0x0089, 0x00b5, 0x00d8,
  0x0154, 0x007d, 0x007f, 0x0081, 0x0088, 0x00b4, 0x00d7, 0x0100,
  0x0055, 0x007e, 0x0080, 0x0087, 0x00b3, 0x00d6, 0x00ff, 0x0101,
  0x0056, 0x007f, 0x0086, 0x00b2, 0x00d5, 0x00fe, 0x0100, 0x0102,
  0x0057, 0x0085, 0x00b1, 0x00d4, 0x00fd, 0x00ff, 0x0101, 0x0103,
  0x005d, 0x00b0, 0x00d3, 0x00fc, 0x00fe, 0x0100, 0x0102, 0x0104,
  0x0088, 0x00d2, 0x00fb, 0x00fd, 0x00ff, 0x0101, 0x0103, 0x0105,
  0x00aa, 0x00fa, 0x00fc, 0x00fe, 0x0100, 0x0102, 0x0104, 0x0106,
  0x00d2, 0x00fb, 0x00fd, 0x00ff, 0x0101, 0x0103, 0x0105, 0x012d,
  0x00d3, 0x00fc, 0x00fe, 0x0100, 0x0102, 0x0104, 0x012c, 0x014f,
  0x00d4, 0x00fd, 0x00ff, 0x0101, 0x0103, 0x012b, 0x014e, 0x017b,
  0x00d5, 0x00fe, 0x0100, 0x0102, 0x012a, 0x014d, 0x017a, 0x0180,
  0x00d6, 0x00ff, 0x0101, 0x0129, 0x014c, 0x0179, 0x017f, 0x0181,
  0x00d7, 0x0100, 0x0128, 0x014b, 0x0178, 0x017e, 0x0180, 0x0182,
  0x0100, 0x0128, 0x014b, 0x0178, 0x017e, 0x0180, 0x0182, 0x00aa,
  0x0127, 0x014a, 0x0177, 0x017d, 0x017f, 0x0181, 0x0083, 0x00ab,
  0x0149, 0x0176, 0x017c, 0x017e, 0x0180, 0x0082, 0x0084, 0x00ac,
  0x0175, 0x017b, 0x017d, 0x017f, 0x0081, 0x0083, 0x0085, 0x00b2,
  0x017a, 0x017c, 0x017e, 0x0080, 0x0082, 0x0084, 0x008b, 0x00dd,
  0x017b, 0x017d, 0x007f, 0x0081, 0x0083, 0x008a, 0x00b6, 0x00ff,
  0x017c, 0x007e, 0x0080, 0x0082, 0x0089, 0x00b5, 0x00d8, 0x0127,
  0x007d, 0x007f, 0x0081, 0x0088, 0x00b4, 0x00d7, 0x0100, 0x0128,
  0x007e, 0x0080, 0x0087, 0x00b3, 0x00d6, 0x00ff, 0x0101, 0x0129,
  0x007f, 0x0086, 0x00b2, 0x00d5, 0x00fe, 0x0100, 0x0102, 0x012a,
  0x0085, 0x00b1, 0x00d4, 0x00fd, 0x00ff, 0x0101, 0x0103, 0x012b,
  0x00b0, 0x00d3, 0x00fc, 0x00fe, 0x0100, 0x0102, 0x0104, 0x012c,
  0x00d2, 0x00fb, 0x00fd, 0x00ff, 0x0101, 0x0103, 0x0105, 0x012d,
  0x00fa, 0x00fc, 0x00fe, 0x0100, 0x0102, 0x0104, 0x0106, 0x0154,
  0x00fb, 0x00fd, 0x00ff, 0x0101, 0x0103, 0x0105, 0x012d, 0x0176,
  0x00fc, 0x00fe, 0x0100, 0x0102, 0x0104, 0x012c, 0x014f, 0x01a2,
  0x00fd, 0x00ff, 0x0101, 0x0103, 0x012b, 0x014e, 0x017b, 0x01a7,
  0x00fe, 0x0100, 0x0102, 0x012a, 0x014d, 0x017a, 0x0180, 0x01a8,
  0x00ff, 0x0101, 0x0129, 0x014c, 0x0179, 0x017f, 0x0181, 0x01a9,
  0x0101, 0x0129, 0x014c, 0x0179, 0x017f, 0x0181, 0x01a9, 0x00cc,
  0x0128, 0x014b, 0x0178, 0x017e, 0x0180, 0x0182, 0x00aa, 0x00cd,
  0x014a, 0x0177, 0x017d, 0x017f, 0x0181, 0x0083, 0x00ab, 0x00ce,
  0x0176, 0x017c, 0x017e, 0x0180, 0x0082, 0x0084, 0x00ac, 0x00d4,
  0x017b, 0x017d, 0x017f, 0x0081, 0x0083, 0x0085, 0x00b2, 0x00ff,
  0x017c, 0x017e, 0x0080, 0x0082, 0x0084, 0x008b, 0x00dd, 0x0121,
  0x017d, 0x007f, 0x0081, 0x0083, 0x008a, 0x00b6, 0x00ff, 0x0149,
  0x007e, 0x0080, 0x0082, 0x0089, 0x00b5, 0x00d8, 0x0127, 0x014a,
  0x007f, 0x0081, 0x0088, 0x00b4, 0x00d7, 0x0100, 0x0128, 0x014b,
  0x0080, 0x0087, 0x00b3, 0x00d6, 0x00ff, 0x0101, 0x0129, 0x014c,
  0x0086, 0x00b2, 0x00d5, 0x00fe, 0x0100, 0x0102, 0x012a, 0x014d,
  0x00b1, 0x00d4, 0x00fd, 0x00ff, 0x0101, 0x0103, 0x012b, 0x014e,
  0x00d3, 0x00fc, 0x00fe, 0x0100, 0x0102, 0x0104, 0x012c, 0x014f,
  0x00fb, 0x00fd, 0x00ff, 0x0101, 0x0103, 0x0105, 0x012d, 0x0176,
  0x00fc, 0x00fe, 0x0100, 0x0102, 0x0104, 0x0106, 0x0154, 0x0198,
  0x00fd, 0x00ff, 0x0101, 0x0103, 0x0105, 0x012d, 0x0176, 0x01c4,
  0x00fe, 0x0100, 0x0102, 0x0104, 0x012c, 0x014f, 0x01a2, 0x01c9,
  0x00ff, 0x0101, 0x0103, 0x012b, 0x014e, 0x017b, 0x01a7, 0x01ca,
  0x0100, 0x0102, 0x012a, 0x014d, 0x017a, 0x0180, 0x01a8, 0x01cb,
  0x0102, 0x012a, 0x014d, 0x017a, 0x0180, 0x01a8, 0x01cb, 0x00f8,
  0x0129, 0x014c, 0x0179, 0x017f, 0x0181, 0x01a9, 0x00cc, 0x00f9,
  0x014b, 0x0178, 0x017e, 0x0180, 0x0182, 0x00aa, 0x00cd, 0x00fa,
  0x0177, 0x017d, 0x017f, 0x0181, 0x0083, 0x00ab, 0x00ce, 0x0100,
  0x017c, 0x017e, 0x0180, 0x0082, 0x0084, 0x00ac, 0x00d4, 0x012b,
  0x017d, 0x017f, 0x0081, 0x0083, 0x0085, 0x00b2, 0x00ff, 0x014d,
  0x017e, 0x0080, 0x0082, 0x0084, 0x008b, 0x00dd, 0x0121, 0x0175,
  0x007f, 0x0081, 0x0083, 0x008a, 0x00b6, 0x00ff, 0x0149, 0x0176,
  0x0080, 0x0082, 0x0089, 0x00b5, 0x00d8, 0x0127, 0x014a, 0x0177,
  0x0081, 0x0088, 0x00b4, 0x00d7, 0x0100, 0x0128, 0x014b, 0x0178,
  0x0087, 0x00b3, 0x00d6, 0x00ff, 0x0101, 0x0129, 0x014c, 0x0179,
  0x00b2, 0x00d5, 0x00fe, 0x0100, 0x0102, 0x012a, 0x014d, 0x017a,
  0x00d4, 0x00fd, 0x00ff, 0x0101, 0x0103, 0x012b, 0x014e, 0x017b,
  0x00fc, 0x00fe, 0x0100, 0x0102, 0x0104, 0x012c, 0x014f, 0x01a2,
  0x00fd, 0x00ff, 0x0101, 0x0103, 0x0105, 0x012d, 0x0176, 0x01c4,
  0x00fe, 0x0100, 0x0102, 0x0104, 0x0106, 0x0154, 0x0198, 0x01f0,
  0x00ff, 0x0101, 0x0103, 0x0105, 0x012d, 0x0176, 0x01c4, 0x01f5,
  0x0100, 0x0102, 0x0104, 0x012c, 0x014f, 0x01a2, 0x01c9, 0x01f6,
  0x0101, 0x0103, 0x012b, 0x014e, 0x017b, 0x01a7, 0x01ca, 0x01f7,
  0x0103, 0x012b, 0x014e, 0x017b, 0x01a7, 0x01ca, 0x01f7, 0x00fd,
  0x012a, 0x014d, 0x017a, 0x0180, 0x01a8, 0x01cb, 0x00f8, 0x00fe,
  0x014c, 0x0179, 0x017f, 0x0181, 0x01a9, 0x00cc, 0x00f9, 0x00ff,
  0x0178, 0x017e, 0x0180, 0x0182, 0x00aa, 0x00cd, 0x00fa, 0x0105,
  0x017d, 0x017f, 0x0181, 0x0083, 0x00ab, 0x00ce, 0x0100, 0x0130,
  0x017e, 0x0180, 0x0082, 0x0084, 0x00ac, 0x00d4, 0x012b, 0x0152,
  0x017f, 0x0081, 0x0083, 0x0085, 0x00b2, 0x00ff, 0x014d, 0x017a,
  0x0080, 0x0082, 0x0084, 0x008b, 0x00dd, 0x0121, 0x0175, 0x017b,
  0x0081, 0x0083, 0x008a, 0x00b6, 0x00ff, 0x0149, 0x0176, 0x017c,
  0x0082, 0x0089, 0x00b5, 0x00d8, 0x0127, 0x014a, 0x0177, 0x017d,
  0x0088, 0x00b4, 0x00d7, 0x0100, 0x0128, 0x014b, 0x0178, 0x017e,
  0x00b3, 0x00d6, 0x00ff, 0x0101, 0x0129, 0x014c, 0x0179, 0x017f,
  0x00d5, 0x00fe, 0x0100, 0x0102, 0x012a, 0x014d, 0x017a, 0x0180,
  0x00fd, 0x00ff, 0x0101, 0x0103, 0x012b, 0x014e, 0x017b, 0x01a7,
  0x00fe, 0x0100, 0x0102, 0x0104, 0x012c, 0x014f, 0x01a2, 0x01c9,
  0x00ff, 0x0101, 0x0103, 0x0105, 0x012d, 0x0176, 0x01c4, 0x01f5,
  0x0100, 0x0102, 0x0104, 0x0106, 0x0154, 0x0198, 0x01f0, 0x01fa,
  0x0101, 0x0103, 0x0105, 0x012d, 0x0176, 0x01c4, 0x01f5, 0x01fb,
  0x0102, 0x0104, 0x012c, 0x014f, 0x01a2, 0x01c9, 0x01f6, 0x01fc,
  0x0104, 0x012c, 0x014f, 0x01a2, 0x01c9, 0x01f6, 0x01fc, 0x00fe,
  0x012b, 0x014e, 0x017b, 0x01a7, 0x01ca, 0x01f7, 0x00fd, 0x00ff,
  0x014d, 0x017a, 0x0180, 0x01a8, 0x01cb, 0x00f8, 0x00fe, 0x0100,
  0x0179, 0x017f, 0x0181, 0x01a9, 0x00cc, 0x00f9, 0x00ff, 0x0106,
  0x017e, 0x0180, 0x0182, 0x00aa, 0x00cd, 0x00fa, 0x0105, 0x0131,
  0x017f, 0x0181, 0x0083, 0x00ab, 0x00ce, 0x0100, 0x0130, 0x0153,
  0x0180, 0x0082, 0x0084, 0x00ac, 0x00d4, 0x012b, 0x0152, 0x017b,
  0x0081, 0x0083, 0x0085, 0x00b2, 0x00ff, 0x014d, 0x017a, 0x017c,
  0x0082, 0x0084, 0x008b, 0x00dd, 0x0121, 0x0175, 0x017b, 0x017d,
  0x0083, 0x008a, 0x00b6, 0x00ff, 0x0149, 0x0176, 0x017c, 0x017e,
  0x0089, 0x00b5, 0x00d8, 0x0127, 0x014a, 0x0177, 0x017d, 0x017f,
  0x00b4, 0x00d7, 0x0100, 0x0128, 0x014b, 0x0178, 0x017e, 0x0180,
  0x00d6, 0x00ff, 0x0101, 0x0129, 0x014c, 0x0179, 0x017f, 0x0181,
  0x00fe, 0x0100, 0x0102, 0x012a, 0x014d, 0x017a, 0x0180, 0x01a8,
  0x00ff, 0x0101, 0x0103, 0x012b, 0x014e, 0x017b, 0x01a7, 0x01ca,
  0x0100, 0x0102, 0x0104, 0x012c, 0x014f, 0x01a2, 0x01c9, 0x01f6,
  0x0101, 0x0103, 0x0105, 0x012d, 0x0176, 0x01c4, 0x01f5, 0x01fb,
  0x0102, 0x0104, 0x0106, 0x0154, 0x0198, 0x01f0, 0x01fa, 0x01fc,
  0x0103, 0x0105, 0x012d, 0x0176, 0x01c4, 0x01f5, 0x01fb, 0x01fd,
  0x0105, 0x012d, 0x0176, 0x01c4, 0x01f5, 0x01fb, 0x01fd, 0x00ff,
  0x012c, 0x014f, 0x01a2, 0x01c9, 0x01f6, 0x01fc, 0x00fe, 0x0100,
  0x014e, 0x017b, 0x01a7, 0x01ca, 0x01f7, 0x00fd, 0x00ff, 0x0101,
  0x017a, 0x0180, 0x01a8, 0x01cb, 0x00f8, 0x00fe, 0x0100, 0x0107,
  0x017f, 0x0181, 0x01a9, 0x00cc, 0x00f9, 0x00ff, 0x0106, 0x0132,
  0x0180, 0x0182, 0x00aa, 0x00cd, 0x00fa, 0x0105, 0x0131, 0x0154,
  0x0181, 0x0083, 0x00ab, 0x00ce, 0x0100, 0x0130, 0x0153, 0x017c,
  0x0082, 0x0084, 0x00ac, 0x00d4, 0x012b, 0x0152, 0x017b, 0x017d,
  0x0083, 0x0085, 0x00b2, 0x00ff, 0x014d, 0x017a, 0x017c, 0x017e,
  0x0084, 0x008b, 0x00dd, 0x0121, 0x0175, 0x017b, 0x017d, 0x017f,
  0x008a, 0x00b6, 0x00ff, 0x0149, 0x0176, 0x017c, 0x017e, 0x0180,
  0x00b5, 0x00d8, 0x0127, 0x014a, 0x0177, 0x017d, 0x017f, 0x0181,
  0x00d7, 0x0100, 0x0128, 0x014b, 0x0178, 0x017e, 0x0180, 0x0182,
  0x00ff, 0x0101, 0x0129, 0x014c, 0x0179, 0x017f, 0x0181, 0x01a9,
  0x0100, 0x0102, 0x012a, 0x014d, 0x017a, 0x0180, 0x01a8, 0x01cb,
  0x0101, 0x0103, 0x012b, 0x014e, 0x017b, 0x01a7, 0x01ca, 0x01f7,
  0x0102, 0x0104, 0x012c, 0x014f, 0x01a2, 0x01c9, 0x01f6, 0x01fc,
  0x0103, 0x0105, 0x012d, 0x0176, 0x01c4, 0x01f5, 0x01fb, 0x01fd,
  0x0104, 0x0106, 0x0154, 0x0198, 0x01f0, 0x01fa, 0x01fc, 0x01fe,
};
const unsigned kExpectedCount_NEON_uaddl2_8H = 361;

#endif  // VIXL_SIM_UADDL2_8H_TRACE_AARCH64_H_
